/* # site_url: https://hs.vicq.org */;
/* # home_url: https://hs.vicq.org */;
/* # content_url: https://hs.vicq.org/wp-content */;
/* # upload_url: https://hs.vicq.org/wp-content/uploads */;
/* # table_prefix: hs_ */;


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `hs_links`
--

DROP TABLE IF EXISTS `hs_links`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `hs_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hs_links`
--

LOCK TABLES `hs_links` WRITE;
/*!40000 ALTER TABLE `hs_links` DISABLE KEYS */;
/*!40000 ALTER TABLE `hs_links` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hs_frm_forms`
--

DROP TABLE IF EXISTS `hs_frm_forms`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `hs_frm_forms` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `form_key` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_520_ci,
  `parent_form_id` int(11) DEFAULT '0',
  `logged_in` tinyint(1) DEFAULT NULL,
  `editable` tinyint(1) DEFAULT NULL,
  `is_template` tinyint(1) DEFAULT '0',
  `default_template` tinyint(1) DEFAULT '0',
  `status` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `options` longtext COLLATE utf8mb4_unicode_520_ci,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `form_key` (`form_key`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hs_frm_forms`
--

LOCK TABLES `hs_frm_forms` WRITE;
/*!40000 ALTER TABLE `hs_frm_forms` DISABLE KEYS */;
INSERT INTO `hs_frm_forms` VALUES (1,'contact-form','Contact','<p>We would like to hear from you. Please send us a message by filling out the form below and we will get back with you shortly.</p>\r\n',0,0,0,0,0,'published','a:19:{s:18:"on_submit_migrated";s:1:"1";s:8:"honeypot";s:5:"basic";s:12:"custom_style";s:1:"1";s:10:"form_class";s:0:"";s:11:"before_html";s:232:"<legend class=\\"frm_screen_reader\\">[form_name]</legend>\r\n[if form_name]<h3 class=\\"frm_form_title\\">[form_name]</h3>[/if form_name]\r\n[if form_description]<div class=\\"frm_description\\">[form_description]</div>[/if form_description]";s:10:"after_html";s:0:"";s:11:"submit_html";s:538:"<div class=\\"frm_submit frm_flex\\">\r\n<button class=\\"frm_button_submit\\" type=\\"submit\\"  [button_action]>[button_label]</button>\r\n[if back_button]<button type=\\"submit\\" name=\\"frm_prev_page\\" formnovalidate=\\"formnovalidate\\" class=\\"frm_prev_page\\" [back_hook]>[back_label]</button>[/if back_button]\r\n[if save_draft]<button class=\\"frm_save_draft\\" [draft_hook]>[draft_label]</button>[/if save_draft]\r\n[if start_over]<a href=\\"#\\" tabindex=\\"0\\" class=\\"frm_start_over\\" [start_over_hook]>[start_over_label]</a>[/if start_over]\r\n</div>";s:14:"success_action";s:7:"message";s:11:"success_msg";s:37:"Merci. Je vous répondrai rapidement.";s:9:"show_form";b:0;s:12:"submit_value";s:7:"Envoyer";s:7:"akismet";s:0:"";s:8:"antispam";i:0;s:7:"no_save";i:0;s:9:"ajax_load";i:0;s:11:"js_validate";i:0;s:10:"show_title";i:0;s:16:"show_description";i:0;s:11:"ajax_submit";i:0;}','2024-05-09 18:48:17');
/*!40000 ALTER TABLE `hs_frm_forms` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hs_term_relationships`
--

DROP TABLE IF EXISTS `hs_term_relationships`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `hs_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hs_term_relationships`
--

LOCK TABLES `hs_term_relationships` WRITE;
/*!40000 ALTER TABLE `hs_term_relationships` DISABLE KEYS */;
INSERT INTO `hs_term_relationships` VALUES (11,2,0);
INSERT INTO `hs_term_relationships` VALUES (18,2,0);
INSERT INTO `hs_term_relationships` VALUES (27,2,0);
INSERT INTO `hs_term_relationships` VALUES (155,2,0);
/*!40000 ALTER TABLE `hs_term_relationships` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hs_commentmeta`
--

DROP TABLE IF EXISTS `hs_commentmeta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `hs_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hs_commentmeta`
--

LOCK TABLES `hs_commentmeta` WRITE;
/*!40000 ALTER TABLE `hs_commentmeta` DISABLE KEYS */;
/*!40000 ALTER TABLE `hs_commentmeta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hs_frm_fields`
--

DROP TABLE IF EXISTS `hs_frm_fields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `hs_frm_fields` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `field_key` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `name` text COLLATE utf8mb4_unicode_520_ci,
  `description` longtext COLLATE utf8mb4_unicode_520_ci,
  `type` text COLLATE utf8mb4_unicode_520_ci,
  `default_value` longtext COLLATE utf8mb4_unicode_520_ci,
  `options` longtext COLLATE utf8mb4_unicode_520_ci,
  `field_order` int(11) DEFAULT '0',
  `required` int(1) DEFAULT NULL,
  `field_options` longtext COLLATE utf8mb4_unicode_520_ci,
  `form_id` int(11) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `field_key` (`field_key`),
  KEY `form_id` (`form_id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hs_frm_fields`
--

LOCK TABLES `hs_frm_fields` WRITE;
/*!40000 ALTER TABLE `hs_frm_fields` DISABLE KEYS */;
INSERT INTO `hs_frm_fields` VALUES (6,'jxu2g','Envoyer','','submit','','',12,0,'a:21:{s:9:"edit_text";s:0:"";s:5:"align";s:0:"";s:10:"start_over";s:0:"";s:16:"start_over_label";s:0:"";s:4:"size";s:0:"";s:3:"max";s:0:"";s:5:"label";s:0:"";s:5:"blank";s:36:"[field_name] ne peut pas être vide.";s:18:"required_indicator";s:1:"*";s:7:"invalid";s:0:"";s:10:"unique_msg";s:0:"";s:14:"separate_value";i:0;s:14:"clear_on_focus";i:0;s:7:"classes";s:0:"";s:11:"custom_html";s:121:"<div id=\\"frm_field_[id]_container\\" class=\\"frm_form_field form-field [required_class][error_class]\\">\r\n	[input]\r\n</div>";s:6:"minnum";i:1;s:6:"maxnum";i:10;s:4:"step";i:1;s:6:"format";s:0:"";s:11:"placeholder";s:0:"";s:5:"draft";i:0;}',1,'2024-05-09 18:50:26');
INSERT INTO `hs_frm_fields` VALUES (9,'7hbv5','Prénom Nom','','text','','',2,1,'a:17:{s:4:"size";s:0:"";s:3:"max";s:0:"";s:5:"label";s:0:"";s:5:"blank";s:36:"[field_name] ne peut pas être vide.";s:18:"required_indicator";s:1:"*";s:7:"invalid";s:27:"[field_name] est non valide";s:10:"unique_msg";s:0:"";s:14:"separate_value";i:0;s:14:"clear_on_focus";i:0;s:7:"classes";s:25:"frm12 frm_f frm_half irst";s:11:"custom_html";s:524:"<div id=\\"frm_field_[id]_container\\" class=\\"frm_form_field form-field [required_class][error_class]\\">\r\n	<label for=\\"field_[key]\\" id=\\"field_[key]_label\\" class=\\"frm_primary_label\\">[field_name]\r\n		<span class=\\"frm_required\\" aria-hidden=\\"true\\">[required_label]</span>\r\n	</label>\r\n	[input]\r\n	[if description]<div class=\\"frm_description\\" id=\\"frm_desc_field_[key]\\">[description]</div>[/if description]\r\n	[if error]<div class=\\"frm_error\\" role=\\"alert\\" id=\\"frm_error_field_[key]\\">[error]</div>[/if error]\r\n</div>";s:6:"minnum";i:1;s:6:"maxnum";i:10;s:4:"step";i:1;s:6:"format";s:0:"";s:11:"placeholder";s:0:"";s:5:"draft";i:0;}',1,'2024-05-09 19:53:20');
INSERT INTO `hs_frm_fields` VALUES (10,'yfcrl','Email','','text','','',4,1,'a:17:{s:4:"size";s:0:"";s:3:"max";s:0:"";s:5:"label";s:0:"";s:5:"blank";s:36:"[field_name] ne peut pas être vide.";s:18:"required_indicator";s:1:"*";s:7:"invalid";s:27:"[field_name] est non valide";s:10:"unique_msg";s:0:"";s:14:"separate_value";i:0;s:14:"clear_on_focus";i:0;s:7:"classes";s:24:"frm12 frm_first frm_half";s:11:"custom_html";s:524:"<div id=\\"frm_field_[id]_container\\" class=\\"frm_form_field form-field [required_class][error_class]\\">\r\n	<label for=\\"field_[key]\\" id=\\"field_[key]_label\\" class=\\"frm_primary_label\\">[field_name]\r\n		<span class=\\"frm_required\\" aria-hidden=\\"true\\">[required_label]</span>\r\n	</label>\r\n	[input]\r\n	[if description]<div class=\\"frm_description\\" id=\\"frm_desc_field_[key]\\">[description]</div>[/if description]\r\n	[if error]<div class=\\"frm_error\\" role=\\"alert\\" id=\\"frm_error_field_[key]\\">[error]</div>[/if error]\r\n</div>";s:6:"minnum";i:1;s:6:"maxnum";i:10;s:4:"step";i:1;s:6:"format";s:0:"";s:11:"placeholder";s:0:"";s:5:"draft";i:0;}',1,'2024-05-09 19:54:02');
INSERT INTO `hs_frm_fields` VALUES (11,'knfbx','Message','Merci de remplir ce champ pour préciser votre demande.','textarea','','',8,1,'a:17:{s:4:"size";s:0:"";s:3:"max";s:1:"5";s:5:"label";s:0:"";s:5:"blank";s:36:"[field_name] ne peut pas être vide.";s:18:"required_indicator";s:1:"*";s:7:"invalid";s:0:"";s:10:"unique_msg";s:0:"";s:14:"separate_value";i:0;s:14:"clear_on_focus";i:0;s:7:"classes";s:24:"frm12 frm_first frm_half";s:11:"custom_html";s:524:"<div id=\\"frm_field_[id]_container\\" class=\\"frm_form_field form-field [required_class][error_class]\\">\r\n	<label for=\\"field_[key]\\" id=\\"field_[key]_label\\" class=\\"frm_primary_label\\">[field_name]\r\n		<span class=\\"frm_required\\" aria-hidden=\\"true\\">[required_label]</span>\r\n	</label>\r\n	[input]\r\n	[if description]<div class=\\"frm_description\\" id=\\"frm_desc_field_[key]\\">[description]</div>[/if description]\r\n	[if error]<div class=\\"frm_error\\" role=\\"alert\\" id=\\"frm_error_field_[key]\\">[error]</div>[/if error]\r\n</div>";s:6:"minnum";i:1;s:6:"maxnum";i:10;s:4:"step";i:1;s:6:"format";s:0:"";s:11:"placeholder";s:0:"";s:5:"draft";i:0;}',1,'2024-05-09 19:54:52');
INSERT INTO `hs_frm_fields` VALUES (14,'gmzx1','Téléphone','','text','','',6,0,'a:17:{s:4:"size";s:0:"";s:3:"max";s:0:"";s:5:"label";s:0:"";s:5:"blank";s:36:"[field_name] ne peut pas être vide.";s:18:"required_indicator";s:1:"*";s:7:"invalid";s:27:"[field_name] est non valide";s:10:"unique_msg";s:0:"";s:14:"separate_value";i:0;s:14:"clear_on_focus";i:0;s:7:"classes";s:24:"frm12 frm_first frm_half";s:11:"custom_html";s:524:"<div id=\\"frm_field_[id]_container\\" class=\\"frm_form_field form-field [required_class][error_class]\\">\r\n	<label for=\\"field_[key]\\" id=\\"field_[key]_label\\" class=\\"frm_primary_label\\">[field_name]\r\n		<span class=\\"frm_required\\" aria-hidden=\\"true\\">[required_label]</span>\r\n	</label>\r\n	[input]\r\n	[if description]<div class=\\"frm_description\\" id=\\"frm_desc_field_[key]\\">[description]</div>[/if description]\r\n	[if error]<div class=\\"frm_error\\" role=\\"alert\\" id=\\"frm_error_field_[key]\\">[error]</div>[/if error]\r\n</div>";s:6:"minnum";i:1;s:6:"maxnum";i:10;s:4:"step";i:1;s:6:"format";s:0:"";s:11:"placeholder";s:0:"";s:5:"draft";i:0;}',1,'2024-05-09 19:58:01');
/*!40000 ALTER TABLE `hs_frm_fields` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hs_postmeta`
--

DROP TABLE IF EXISTS `hs_postmeta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `hs_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=92 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hs_postmeta`
--

LOCK TABLES `hs_postmeta` WRITE;
/*!40000 ALTER TABLE `hs_postmeta` DISABLE KEYS */;
INSERT INTO `hs_postmeta` VALUES (1,2,'_wp_page_template','default');
INSERT INTO `hs_postmeta` VALUES (2,3,'_wp_page_template','default');
INSERT INTO `hs_postmeta` VALUES (6,2,'_edit_lock','1709225180:1');
INSERT INTO `hs_postmeta` VALUES (7,8,'_edit_lock','1702141299:1');
INSERT INTO `hs_postmeta` VALUES (9,11,'_menu_item_type','post_type');
INSERT INTO `hs_postmeta` VALUES (10,11,'_menu_item_menu_item_parent','0');
INSERT INTO `hs_postmeta` VALUES (11,11,'_menu_item_object_id','8');
INSERT INTO `hs_postmeta` VALUES (12,11,'_menu_item_object','page');
INSERT INTO `hs_postmeta` VALUES (13,11,'_menu_item_target','');
INSERT INTO `hs_postmeta` VALUES (14,11,'_menu_item_classes','a:1:{i:0;s:0:"";}');
INSERT INTO `hs_postmeta` VALUES (15,11,'_menu_item_xfn','');
INSERT INTO `hs_postmeta` VALUES (16,11,'_menu_item_url','');
INSERT INTO `hs_postmeta` VALUES (27,15,'_edit_lock','1702231270:1');
INSERT INTO `hs_postmeta` VALUES (28,18,'_menu_item_type','post_type');
INSERT INTO `hs_postmeta` VALUES (29,18,'_menu_item_menu_item_parent','0');
INSERT INTO `hs_postmeta` VALUES (30,18,'_menu_item_object_id','15');
INSERT INTO `hs_postmeta` VALUES (31,18,'_menu_item_object','page');
INSERT INTO `hs_postmeta` VALUES (32,18,'_menu_item_target','');
INSERT INTO `hs_postmeta` VALUES (33,18,'_menu_item_classes','a:1:{i:0;s:0:"";}');
INSERT INTO `hs_postmeta` VALUES (34,18,'_menu_item_xfn','');
INSERT INTO `hs_postmeta` VALUES (35,18,'_menu_item_url','');
INSERT INTO `hs_postmeta` VALUES (38,19,'_edit_lock','1715285426:1');
INSERT INTO `hs_postmeta` VALUES (39,27,'_menu_item_type','post_type');
INSERT INTO `hs_postmeta` VALUES (40,27,'_menu_item_menu_item_parent','0');
INSERT INTO `hs_postmeta` VALUES (41,27,'_menu_item_object_id','19');
INSERT INTO `hs_postmeta` VALUES (42,27,'_menu_item_object','page');
INSERT INTO `hs_postmeta` VALUES (43,27,'_menu_item_target','');
INSERT INTO `hs_postmeta` VALUES (44,27,'_menu_item_classes','a:1:{i:0;s:0:"";}');
INSERT INTO `hs_postmeta` VALUES (45,27,'_menu_item_xfn','');
INSERT INTO `hs_postmeta` VALUES (46,27,'_menu_item_url','');
INSERT INTO `hs_postmeta` VALUES (51,8,'_oembed_80ef40e7f1dbc807a20a60724b7857d9','<iframe title="Système de Bioponie Marseille" width="525" height="394" src="https://www.youtube.com/embed/MCo0lrLJxGQ?feature=oembed" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen></iframe>');
INSERT INTO `hs_postmeta` VALUES (52,8,'_oembed_time_80ef40e7f1dbc807a20a60724b7857d9','1690129774');
INSERT INTO `hs_postmeta` VALUES (56,38,'_wp_attached_file','2023/07/galerie-de-photos.png');
INSERT INTO `hs_postmeta` VALUES (57,38,'_wp_attachment_metadata','a:6:{s:5:"width";i:512;s:6:"height";i:512;s:4:"file";s:29:"2023/07/galerie-de-photos.png";s:8:"filesize";i:27961;s:5:"sizes";a:4:{s:6:"medium";a:5:{s:4:"file";s:29:"galerie-de-photos-300x300.png";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:20166;}s:9:"thumbnail";a:5:{s:4:"file";s:29:"galerie-de-photos-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:9537;}s:36:"agriculture-farming-thumbnail-avatar";a:5:{s:4:"file";s:29:"galerie-de-photos-100x100.png";s:5:"width";i:100;s:6:"height";i:100;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:6058;}s:29:"organic-farm-thumbnail-avatar";a:5:{s:4:"file";s:29:"galerie-de-photos-100x100.png";s:5:"width";i:100;s:6:"height";i:100;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:6058;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `hs_postmeta` VALUES (58,40,'_tablepress_table_options','{"last_editor":1,"table_head":true,"table_foot":false,"alternating_row_colors":true,"row_hover":true,"print_name":false,"print_name_position":"above","print_description":false,"print_description_position":"below","extra_css_classes":"","use_datatables":true,"datatables_sort":true,"datatables_filter":true,"datatables_paginate":true,"datatables_lengthchange":true,"datatables_paginate_entries":10,"datatables_info":true,"datatables_scrollx":false,"datatables_custom_commands":""}');
INSERT INTO `hs_postmeta` VALUES (59,40,'_tablepress_table_visibility','{"rows":[1],"columns":[1,1]}');
INSERT INTO `hs_postmeta` VALUES (64,2,'footnotes','');
INSERT INTO `hs_postmeta` VALUES (66,15,'_oembed_0bafb918a501d278799a53f875b6012d','<iframe title="Système hydroponique de terrasse" width="525" height="295" src="https://www.youtube.com/embed/6_k53IJklnw?feature=oembed" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen></iframe>');
INSERT INTO `hs_postmeta` VALUES (67,15,'_oembed_time_0bafb918a501d278799a53f875b6012d','1702225256');
INSERT INTO `hs_postmeta` VALUES (69,15,'_oembed_fc575a75fd61f48e6aa7ab32a5be58ff','<iframe title="Système hydroponique de terrasse" width="525" height="295" src="https://www.youtube.com/embed/6_k53IJklnw?feature=oembed" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen></iframe>');
INSERT INTO `hs_postmeta` VALUES (70,15,'_oembed_time_fc575a75fd61f48e6aa7ab32a5be58ff','1702224910');
INSERT INTO `hs_postmeta` VALUES (71,15,'_oembed_83436db54e4b707e745258b4c9295fef','{{unknown}}');
INSERT INTO `hs_postmeta` VALUES (72,15,'_oembed_0db34fb03d56f26c50ab0aa6cf1f989e','<iframe title="Système hydroponique de terrasse" width="525" height="295" src="https://www.youtube.com/embed/6_k53IJklnw?feature=oembed" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen></iframe>');
INSERT INTO `hs_postmeta` VALUES (73,15,'_oembed_time_0db34fb03d56f26c50ab0aa6cf1f989e','1702225151');
INSERT INTO `hs_postmeta` VALUES (74,139,'footnotes','');
INSERT INTO `hs_postmeta` VALUES (75,8,'_oembed_9afd983a90c2159d184a14079f026268','<iframe title="Système de Bioponie Marseille" width="525" height="394" src="https://www.youtube.com/embed/MCo0lrLJxGQ?feature=oembed" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>');
INSERT INTO `hs_postmeta` VALUES (76,8,'_oembed_time_9afd983a90c2159d184a14079f026268','1713498596');
INSERT INTO `hs_postmeta` VALUES (77,15,'_oembed_dc0e8ba2be3d46757f971c2c4c38f337','<iframe title="Système hydroponique de terrasse" width="525" height="295" src="https://www.youtube.com/embed/6_k53IJklnw?feature=oembed" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>');
INSERT INTO `hs_postmeta` VALUES (78,15,'_oembed_time_dc0e8ba2be3d46757f971c2c4c38f337','1713517107');
INSERT INTO `hs_postmeta` VALUES (79,140,'_edit_lock','1715284734:1');
INSERT INTO `hs_postmeta` VALUES (80,145,'_wp_old_slug','confirmation');
INSERT INTO `hs_postmeta` VALUES (81,148,'footnotes','');
INSERT INTO `hs_postmeta` VALUES (82,155,'_menu_item_type','post_type');
INSERT INTO `hs_postmeta` VALUES (83,155,'_menu_item_menu_item_parent','0');
INSERT INTO `hs_postmeta` VALUES (84,155,'_menu_item_object_id','140');
INSERT INTO `hs_postmeta` VALUES (85,155,'_menu_item_object','page');
INSERT INTO `hs_postmeta` VALUES (86,155,'_menu_item_target','');
INSERT INTO `hs_postmeta` VALUES (87,155,'_menu_item_classes','a:1:{i:0;s:0:"";}');
INSERT INTO `hs_postmeta` VALUES (88,155,'_menu_item_xfn','');
INSERT INTO `hs_postmeta` VALUES (89,155,'_menu_item_url','');
INSERT INTO `hs_postmeta` VALUES (90,154,'_wp_trash_meta_status','publish');
INSERT INTO `hs_postmeta` VALUES (91,154,'_wp_trash_meta_time','1715285377');
/*!40000 ALTER TABLE `hs_postmeta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hs_term_taxonomy`
--

DROP TABLE IF EXISTS `hs_term_taxonomy`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `hs_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hs_term_taxonomy`
--

LOCK TABLES `hs_term_taxonomy` WRITE;
/*!40000 ALTER TABLE `hs_term_taxonomy` DISABLE KEYS */;
INSERT INTO `hs_term_taxonomy` VALUES (1,1,'category','',0,0);
INSERT INTO `hs_term_taxonomy` VALUES (2,2,'nav_menu','',0,4);
/*!40000 ALTER TABLE `hs_term_taxonomy` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hs_termmeta`
--

DROP TABLE IF EXISTS `hs_termmeta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `hs_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hs_termmeta`
--

LOCK TABLES `hs_termmeta` WRITE;
/*!40000 ALTER TABLE `hs_termmeta` DISABLE KEYS */;
/*!40000 ALTER TABLE `hs_termmeta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hs_terms`
--

DROP TABLE IF EXISTS `hs_terms`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `hs_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hs_terms`
--

LOCK TABLES `hs_terms` WRITE;
/*!40000 ALTER TABLE `hs_terms` DISABLE KEYS */;
INSERT INTO `hs_terms` VALUES (1,'Non classé','non-classe',0);
INSERT INTO `hs_terms` VALUES (2,'principal','principal',0);
/*!40000 ALTER TABLE `hs_terms` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hs_usermeta`
--

DROP TABLE IF EXISTS `hs_usermeta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `hs_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hs_usermeta`
--

LOCK TABLES `hs_usermeta` WRITE;
/*!40000 ALTER TABLE `hs_usermeta` DISABLE KEYS */;
INSERT INTO `hs_usermeta` VALUES (1,1,'nickname','Axl_admin');
INSERT INTO `hs_usermeta` VALUES (2,1,'first_name','');
INSERT INTO `hs_usermeta` VALUES (3,1,'last_name','');
INSERT INTO `hs_usermeta` VALUES (4,1,'description','');
INSERT INTO `hs_usermeta` VALUES (5,1,'rich_editing','true');
INSERT INTO `hs_usermeta` VALUES (6,1,'syntax_highlighting','true');
INSERT INTO `hs_usermeta` VALUES (7,1,'comment_shortcuts','false');
INSERT INTO `hs_usermeta` VALUES (8,1,'admin_color','fresh');
INSERT INTO `hs_usermeta` VALUES (9,1,'use_ssl','0');
INSERT INTO `hs_usermeta` VALUES (10,1,'show_admin_bar_front','true');
INSERT INTO `hs_usermeta` VALUES (11,1,'locale','');
INSERT INTO `hs_usermeta` VALUES (12,1,'hs_capabilities','a:7:{s:13:"administrator";b:1;s:14:"frm_view_forms";b:1;s:14:"frm_edit_forms";b:1;s:16:"frm_delete_forms";b:1;s:19:"frm_change_settings";b:1;s:16:"frm_view_entries";b:1;s:18:"frm_delete_entries";b:1;}');
INSERT INTO `hs_usermeta` VALUES (13,1,'hs_user_level','10');
INSERT INTO `hs_usermeta` VALUES (14,1,'dismissed_wp_pointers','tp20_edit_context_menu');
INSERT INTO `hs_usermeta` VALUES (15,1,'show_welcome_panel','1');
INSERT INTO `hs_usermeta` VALUES (16,1,'session_tokens','a:1:{s:64:"2dfdf13338b549984a1059f0ea79d4564ebfd9715e88adc2a382617f804adaba";a:4:{s:10:"expiration";i:1716489126;s:2:"ip";s:37:"2a01:e0a:4ac:1cd0:214e:58ae:44d7:2e60";s:2:"ua";s:84:"Mozilla/5.0 (Macintosh; Intel Mac OS X 10.15; rv:125.0) Gecko/20100101 Firefox/125.0";s:5:"login";i:1715279526;}}');
INSERT INTO `hs_usermeta` VALUES (17,1,'hs_dashboard_quick_press_last_post_id','144');
INSERT INTO `hs_usermeta` VALUES (18,1,'community-events-location','a:1:{s:2:"ip";s:19:"2a01:e0a:4ac:1cd0::";}');
INSERT INTO `hs_usermeta` VALUES (19,1,'hs_persisted_preferences','a:2:{s:14:"core/edit-post";a:2:{s:26:"isComplementaryAreaVisible";b:0;s:12:"welcomeGuide";b:0;}s:9:"_modified";s:24:"2023-07-09T16:18:57.272Z";}');
INSERT INTO `hs_usermeta` VALUES (20,1,'hs_user-settings','libraryContent=browse');
INSERT INTO `hs_usermeta` VALUES (21,1,'hs_user-settings-time','1688918824');
INSERT INTO `hs_usermeta` VALUES (22,1,'hs_tablepress_user_options','{"user_options_db_version":76,"admin_menu_parent_page":"middle","message_first_visit":true,"table_editor_column_width":"170","table_editor_line_clamp":"5"}');
INSERT INTO `hs_usermeta` VALUES (23,1,'managetablepress_listcolumnshidden','a:1:{i:0;s:22:"table_last_modified_by";}');
INSERT INTO `hs_usermeta` VALUES (24,1,'frm_reviewed','a:3:{s:4:"time";i:1715280620;s:9:"dismissed";b:0;s:5:"asked";i:0;}');
/*!40000 ALTER TABLE `hs_usermeta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hs_frm_item_metas`
--

DROP TABLE IF EXISTS `hs_frm_item_metas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `hs_frm_item_metas` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  `field_id` bigint(20) NOT NULL,
  `item_id` bigint(20) NOT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `field_id` (`field_id`),
  KEY `item_id` (`item_id`),
  KEY `idx_field_id_item_id` (`field_id`,`item_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hs_frm_item_metas`
--

LOCK TABLES `hs_frm_item_metas` WRITE;
/*!40000 ALTER TABLE `hs_frm_item_metas` DISABLE KEYS */;
INSERT INTO `hs_frm_item_metas` VALUES (1,'a',9,1,'2024-06-06 06:32:58');
INSERT INTO `hs_frm_item_metas` VALUES (2,'roro@toto.com',10,1,'2024-06-06 06:32:58');
INSERT INTO `hs_frm_item_metas` VALUES (3,'Prout',11,1,'2024-06-06 06:32:58');
/*!40000 ALTER TABLE `hs_frm_item_metas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hs_users`
--

DROP TABLE IF EXISTS `hs_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `hs_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hs_users`
--

LOCK TABLES `hs_users` WRITE;
/*!40000 ALTER TABLE `hs_users` DISABLE KEYS */;
INSERT INTO `hs_users` VALUES (1,'Axl_admin','$P$BRRnu4qZ4G90byiOESnKtrjUb.CHGJ0','axl_admin','alex@vicq.org','http://hs.vicq.org','2023-07-09 14:43:05','',0,'Axl_admin');
/*!40000 ALTER TABLE `hs_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hs_comments`
--

DROP TABLE IF EXISTS `hs_comments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `hs_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hs_comments`
--

LOCK TABLES `hs_comments` WRITE;
/*!40000 ALTER TABLE `hs_comments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hs_comments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hs_frm_items`
--

DROP TABLE IF EXISTS `hs_frm_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `hs_frm_items` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `item_key` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_520_ci,
  `ip` text COLLATE utf8mb4_unicode_520_ci,
  `form_id` bigint(20) DEFAULT NULL,
  `post_id` bigint(20) DEFAULT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `parent_item_id` bigint(20) DEFAULT '0',
  `is_draft` tinyint(1) DEFAULT '0',
  `updated_by` bigint(20) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `item_key` (`item_key`),
  KEY `form_id` (`form_id`),
  KEY `post_id` (`post_id`),
  KEY `user_id` (`user_id`),
  KEY `parent_item_id` (`parent_item_id`),
  KEY `idx_is_draft_created_at` (`is_draft`,`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hs_frm_items`
--

LOCK TABLES `hs_frm_items` WRITE;
/*!40000 ALTER TABLE `hs_frm_items` DISABLE KEYS */;
INSERT INTO `hs_frm_items` VALUES (1,'ucnwj','a','{"browser":"Mozilla\\/5.0 (Android 14; Mobile; rv:126.0) Gecko\\/126.0 Firefox\\/126.0","referrer":"https:\\/\\/hs.vicq.org\\/contact\\/"}','2a01:e0a:4ac:1cd0:ed83:cb97:b92:f608',1,0,0,0,0,0,'2024-06-06 06:32:57','2024-06-06 06:32:57');
/*!40000 ALTER TABLE `hs_frm_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hs_options`
--

DROP TABLE IF EXISTS `hs_options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `hs_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=6790 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hs_options`
--

LOCK TABLES `hs_options` WRITE;
/*!40000 ALTER TABLE `hs_options` DISABLE KEYS */;
INSERT INTO `hs_options` VALUES (1,'siteurl','https://hs.vicq.org','yes');
INSERT INTO `hs_options` VALUES (2,'home','https://hs.vicq.org','yes');
INSERT INTO `hs_options` VALUES (3,'blogname','Culture hors sol urbaine','yes');
INSERT INTO `hs_options` VALUES (4,'blogdescription','','yes');
INSERT INTO `hs_options` VALUES (5,'users_can_register','0','yes');
INSERT INTO `hs_options` VALUES (6,'admin_email','alex@vicq.me','yes');
INSERT INTO `hs_options` VALUES (7,'start_of_week','1','yes');
INSERT INTO `hs_options` VALUES (8,'use_balanceTags','0','yes');
INSERT INTO `hs_options` VALUES (9,'use_smilies','1','yes');
INSERT INTO `hs_options` VALUES (10,'require_name_email','1','yes');
INSERT INTO `hs_options` VALUES (11,'comments_notify','1','yes');
INSERT INTO `hs_options` VALUES (12,'posts_per_rss','10','yes');
INSERT INTO `hs_options` VALUES (13,'rss_use_excerpt','0','yes');
INSERT INTO `hs_options` VALUES (14,'mailserver_url','mail.example.com','yes');
INSERT INTO `hs_options` VALUES (15,'mailserver_login','login@example.com','yes');
INSERT INTO `hs_options` VALUES (16,'mailserver_pass','password','yes');
INSERT INTO `hs_options` VALUES (17,'mailserver_port','110','yes');
INSERT INTO `hs_options` VALUES (18,'default_category','1','yes');
INSERT INTO `hs_options` VALUES (19,'default_comment_status','open','yes');
INSERT INTO `hs_options` VALUES (20,'default_ping_status','open','yes');
INSERT INTO `hs_options` VALUES (21,'default_pingback_flag','1','yes');
INSERT INTO `hs_options` VALUES (22,'posts_per_page','10','yes');
INSERT INTO `hs_options` VALUES (23,'date_format','j F Y','yes');
INSERT INTO `hs_options` VALUES (24,'time_format','G\\hi','yes');
INSERT INTO `hs_options` VALUES (25,'links_updated_date_format','d F Y G\\hi','yes');
INSERT INTO `hs_options` VALUES (26,'comment_moderation','0','yes');
INSERT INTO `hs_options` VALUES (27,'moderation_notify','1','yes');
INSERT INTO `hs_options` VALUES (28,'permalink_structure','/%year%/%monthnum%/%day%/%postname%/','yes');
INSERT INTO `hs_options` VALUES (29,'rewrite_rules','a:131:{s:11:"^wp-json/?$";s:22:"index.php?rest_route=/";s:14:"^wp-json/(.*)?";s:33:"index.php?rest_route=/$matches[1]";s:21:"^index.php/wp-json/?$";s:22:"index.php?rest_route=/";s:24:"^index.php/wp-json/(.*)?";s:33:"index.php?rest_route=/$matches[1]";s:17:"^wp-sitemap\\.xml$";s:23:"index.php?sitemap=index";s:17:"^wp-sitemap\\.xsl$";s:36:"index.php?sitemap-stylesheet=sitemap";s:23:"^wp-sitemap-index\\.xsl$";s:34:"index.php?sitemap-stylesheet=index";s:48:"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$";s:75:"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]";s:34:"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$";s:47:"index.php?sitemap=$matches[1]&paged=$matches[2]";s:47:"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$";s:52:"index.php?category_name=$matches[1]&feed=$matches[2]";s:42:"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$";s:52:"index.php?category_name=$matches[1]&feed=$matches[2]";s:23:"category/(.+?)/embed/?$";s:46:"index.php?category_name=$matches[1]&embed=true";s:35:"category/(.+?)/page/?([0-9]{1,})/?$";s:53:"index.php?category_name=$matches[1]&paged=$matches[2]";s:17:"category/(.+?)/?$";s:35:"index.php?category_name=$matches[1]";s:44:"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:42:"index.php?tag=$matches[1]&feed=$matches[2]";s:39:"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:42:"index.php?tag=$matches[1]&feed=$matches[2]";s:20:"tag/([^/]+)/embed/?$";s:36:"index.php?tag=$matches[1]&embed=true";s:32:"tag/([^/]+)/page/?([0-9]{1,})/?$";s:43:"index.php?tag=$matches[1]&paged=$matches[2]";s:14:"tag/([^/]+)/?$";s:25:"index.php?tag=$matches[1]";s:45:"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:50:"index.php?post_format=$matches[1]&feed=$matches[2]";s:40:"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:50:"index.php?post_format=$matches[1]&feed=$matches[2]";s:21:"type/([^/]+)/embed/?$";s:44:"index.php?post_format=$matches[1]&embed=true";s:33:"type/([^/]+)/page/?([0-9]{1,})/?$";s:51:"index.php?post_format=$matches[1]&paged=$matches[2]";s:15:"type/([^/]+)/?$";s:33:"index.php?post_format=$matches[1]";s:38:"frm_styles/[^/]+/attachment/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:48:"frm_styles/[^/]+/attachment/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:68:"frm_styles/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:63:"frm_styles/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:63:"frm_styles/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:44:"frm_styles/[^/]+/attachment/([^/]+)/embed/?$";s:43:"index.php?attachment=$matches[1]&embed=true";s:27:"frm_styles/([^/]+)/embed/?$";s:43:"index.php?frm_styles=$matches[1]&embed=true";s:31:"frm_styles/([^/]+)/trackback/?$";s:37:"index.php?frm_styles=$matches[1]&tb=1";s:39:"frm_styles/([^/]+)/page/?([0-9]{1,})/?$";s:50:"index.php?frm_styles=$matches[1]&paged=$matches[2]";s:46:"frm_styles/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?frm_styles=$matches[1]&cpage=$matches[2]";s:35:"frm_styles/([^/]+)(?:/([0-9]+))?/?$";s:49:"index.php?frm_styles=$matches[1]&page=$matches[2]";s:27:"frm_styles/[^/]+/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:37:"frm_styles/[^/]+/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:57:"frm_styles/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:52:"frm_styles/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:52:"frm_styles/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:33:"frm_styles/[^/]+/([^/]+)/embed/?$";s:43:"index.php?attachment=$matches[1]&embed=true";s:44:"frm_form_actions/[^/]+/attachment/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:54:"frm_form_actions/[^/]+/attachment/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:74:"frm_form_actions/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:69:"frm_form_actions/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:69:"frm_form_actions/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:50:"frm_form_actions/[^/]+/attachment/([^/]+)/embed/?$";s:43:"index.php?attachment=$matches[1]&embed=true";s:33:"frm_form_actions/([^/]+)/embed/?$";s:49:"index.php?frm_form_actions=$matches[1]&embed=true";s:37:"frm_form_actions/([^/]+)/trackback/?$";s:43:"index.php?frm_form_actions=$matches[1]&tb=1";s:45:"frm_form_actions/([^/]+)/page/?([0-9]{1,})/?$";s:56:"index.php?frm_form_actions=$matches[1]&paged=$matches[2]";s:52:"frm_form_actions/([^/]+)/comment-page-([0-9]{1,})/?$";s:56:"index.php?frm_form_actions=$matches[1]&cpage=$matches[2]";s:41:"frm_form_actions/([^/]+)(?:/([0-9]+))?/?$";s:55:"index.php?frm_form_actions=$matches[1]&page=$matches[2]";s:33:"frm_form_actions/[^/]+/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:43:"frm_form_actions/[^/]+/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:63:"frm_form_actions/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:58:"frm_form_actions/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:58:"frm_form_actions/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:39:"frm_form_actions/[^/]+/([^/]+)/embed/?$";s:43:"index.php?attachment=$matches[1]&embed=true";s:12:"robots\\.txt$";s:18:"index.php?robots=1";s:13:"favicon\\.ico$";s:19:"index.php?favicon=1";s:48:".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$";s:18:"index.php?feed=old";s:20:".*wp-app\\.php(/.*)?$";s:19:"index.php?error=403";s:18:".*wp-register.php$";s:23:"index.php?register=true";s:32:"feed/(feed|rdf|rss|rss2|atom)/?$";s:27:"index.php?&feed=$matches[1]";s:27:"(feed|rdf|rss|rss2|atom)/?$";s:27:"index.php?&feed=$matches[1]";s:8:"embed/?$";s:21:"index.php?&embed=true";s:20:"page/?([0-9]{1,})/?$";s:28:"index.php?&paged=$matches[1]";s:27:"comment-page-([0-9]{1,})/?$";s:38:"index.php?&page_id=2&cpage=$matches[1]";s:41:"comments/feed/(feed|rdf|rss|rss2|atom)/?$";s:42:"index.php?&feed=$matches[1]&withcomments=1";s:36:"comments/(feed|rdf|rss|rss2|atom)/?$";s:42:"index.php?&feed=$matches[1]&withcomments=1";s:17:"comments/embed/?$";s:21:"index.php?&embed=true";s:44:"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:40:"index.php?s=$matches[1]&feed=$matches[2]";s:39:"search/(.+)/(feed|rdf|rss|rss2|atom)/?$";s:40:"index.php?s=$matches[1]&feed=$matches[2]";s:20:"search/(.+)/embed/?$";s:34:"index.php?s=$matches[1]&embed=true";s:32:"search/(.+)/page/?([0-9]{1,})/?$";s:41:"index.php?s=$matches[1]&paged=$matches[2]";s:14:"search/(.+)/?$";s:23:"index.php?s=$matches[1]";s:47:"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:50:"index.php?author_name=$matches[1]&feed=$matches[2]";s:42:"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:50:"index.php?author_name=$matches[1]&feed=$matches[2]";s:23:"author/([^/]+)/embed/?$";s:44:"index.php?author_name=$matches[1]&embed=true";s:35:"author/([^/]+)/page/?([0-9]{1,})/?$";s:51:"index.php?author_name=$matches[1]&paged=$matches[2]";s:17:"author/([^/]+)/?$";s:33:"index.php?author_name=$matches[1]";s:69:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$";s:80:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]";s:64:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$";s:80:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]";s:45:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$";s:74:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true";s:57:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$";s:81:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]";s:39:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$";s:63:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]";s:56:"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$";s:64:"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]";s:51:"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$";s:64:"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]";s:32:"([0-9]{4})/([0-9]{1,2})/embed/?$";s:58:"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true";s:44:"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$";s:65:"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]";s:26:"([0-9]{4})/([0-9]{1,2})/?$";s:47:"index.php?year=$matches[1]&monthnum=$matches[2]";s:43:"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$";s:43:"index.php?year=$matches[1]&feed=$matches[2]";s:38:"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$";s:43:"index.php?year=$matches[1]&feed=$matches[2]";s:19:"([0-9]{4})/embed/?$";s:37:"index.php?year=$matches[1]&embed=true";s:31:"([0-9]{4})/page/?([0-9]{1,})/?$";s:44:"index.php?year=$matches[1]&paged=$matches[2]";s:13:"([0-9]{4})/?$";s:26:"index.php?year=$matches[1]";s:58:"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:68:"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:88:"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:83:"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:83:"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:64:"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/embed/?$";s:43:"index.php?attachment=$matches[1]&embed=true";s:53:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/embed/?$";s:91:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&embed=true";s:57:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/trackback/?$";s:85:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&tb=1";s:77:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:97:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]";s:72:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:97:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]";s:65:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/page/?([0-9]{1,})/?$";s:98:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&paged=$matches[5]";s:72:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/comment-page-([0-9]{1,})/?$";s:98:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&cpage=$matches[5]";s:61:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)(?:/([0-9]+))?/?$";s:97:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&page=$matches[5]";s:47:"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:57:"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:77:"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:72:"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:72:"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:53:"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/embed/?$";s:43:"index.php?attachment=$matches[1]&embed=true";s:64:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$";s:81:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&cpage=$matches[4]";s:51:"([0-9]{4})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$";s:65:"index.php?year=$matches[1]&monthnum=$matches[2]&cpage=$matches[3]";s:38:"([0-9]{4})/comment-page-([0-9]{1,})/?$";s:44:"index.php?year=$matches[1]&cpage=$matches[2]";s:27:".?.+?/attachment/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:37:".?.+?/attachment/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:57:".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:52:".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:52:".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:33:".?.+?/attachment/([^/]+)/embed/?$";s:43:"index.php?attachment=$matches[1]&embed=true";s:16:"(.?.+?)/embed/?$";s:41:"index.php?pagename=$matches[1]&embed=true";s:20:"(.?.+?)/trackback/?$";s:35:"index.php?pagename=$matches[1]&tb=1";s:40:"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$";s:47:"index.php?pagename=$matches[1]&feed=$matches[2]";s:35:"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$";s:47:"index.php?pagename=$matches[1]&feed=$matches[2]";s:28:"(.?.+?)/page/?([0-9]{1,})/?$";s:48:"index.php?pagename=$matches[1]&paged=$matches[2]";s:35:"(.?.+?)/comment-page-([0-9]{1,})/?$";s:48:"index.php?pagename=$matches[1]&cpage=$matches[2]";s:24:"(.?.+?)(?:/([0-9]+))?/?$";s:47:"index.php?pagename=$matches[1]&page=$matches[2]";}','yes');
INSERT INTO `hs_options` VALUES (30,'hack_file','0','yes');
INSERT INTO `hs_options` VALUES (31,'blog_charset','UTF-8','yes');
INSERT INTO `hs_options` VALUES (32,'moderation_keys','','no');
INSERT INTO `hs_options` VALUES (33,'active_plugins','a:3:{i:0;s:25:"formidable/formidable.php";i:1;s:25:"tablepress/tablepress.php";i:2;s:47:"wpvivid-backuprestore/wpvivid-backuprestore.php";}','yes');
INSERT INTO `hs_options` VALUES (34,'category_base','','yes');
INSERT INTO `hs_options` VALUES (35,'ping_sites','http://rpc.pingomatic.com/','yes');
INSERT INTO `hs_options` VALUES (36,'comment_max_links','2','yes');
INSERT INTO `hs_options` VALUES (37,'gmt_offset','','yes');
INSERT INTO `hs_options` VALUES (38,'default_email_category','1','yes');
INSERT INTO `hs_options` VALUES (39,'recently_edited','','no');
INSERT INTO `hs_options` VALUES (40,'template','organic-farm','yes');
INSERT INTO `hs_options` VALUES (41,'stylesheet','agriculture-farming','yes');
INSERT INTO `hs_options` VALUES (42,'comment_registration','0','yes');
INSERT INTO `hs_options` VALUES (43,'html_type','text/html','yes');
INSERT INTO `hs_options` VALUES (44,'use_trackback','0','yes');
INSERT INTO `hs_options` VALUES (45,'default_role','subscriber','yes');
INSERT INTO `hs_options` VALUES (46,'db_version','57155','yes');
INSERT INTO `hs_options` VALUES (47,'uploads_use_yearmonth_folders','1','yes');
INSERT INTO `hs_options` VALUES (48,'upload_path','','yes');
INSERT INTO `hs_options` VALUES (49,'blog_public','1','yes');
INSERT INTO `hs_options` VALUES (50,'default_link_category','2','yes');
INSERT INTO `hs_options` VALUES (51,'show_on_front','page','yes');
INSERT INTO `hs_options` VALUES (52,'tag_base','','yes');
INSERT INTO `hs_options` VALUES (53,'show_avatars','1','yes');
INSERT INTO `hs_options` VALUES (54,'avatar_rating','G','yes');
INSERT INTO `hs_options` VALUES (55,'upload_url_path','','yes');
INSERT INTO `hs_options` VALUES (56,'thumbnail_size_w','150','yes');
INSERT INTO `hs_options` VALUES (57,'thumbnail_size_h','150','yes');
INSERT INTO `hs_options` VALUES (58,'thumbnail_crop','1','yes');
INSERT INTO `hs_options` VALUES (59,'medium_size_w','300','yes');
INSERT INTO `hs_options` VALUES (60,'medium_size_h','300','yes');
INSERT INTO `hs_options` VALUES (61,'avatar_default','mystery','yes');
INSERT INTO `hs_options` VALUES (62,'large_size_w','1024','yes');
INSERT INTO `hs_options` VALUES (63,'large_size_h','1024','yes');
INSERT INTO `hs_options` VALUES (64,'image_default_link_type','none','yes');
INSERT INTO `hs_options` VALUES (65,'image_default_size','','yes');
INSERT INTO `hs_options` VALUES (66,'image_default_align','','yes');
INSERT INTO `hs_options` VALUES (67,'close_comments_for_old_posts','0','yes');
INSERT INTO `hs_options` VALUES (68,'close_comments_days_old','14','yes');
INSERT INTO `hs_options` VALUES (69,'thread_comments','1','yes');
INSERT INTO `hs_options` VALUES (70,'thread_comments_depth','5','yes');
INSERT INTO `hs_options` VALUES (71,'page_comments','0','yes');
INSERT INTO `hs_options` VALUES (72,'comments_per_page','50','yes');
INSERT INTO `hs_options` VALUES (73,'default_comments_page','newest','yes');
INSERT INTO `hs_options` VALUES (74,'comment_order','asc','yes');
INSERT INTO `hs_options` VALUES (75,'sticky_posts','a:0:{}','yes');
INSERT INTO `hs_options` VALUES (76,'widget_categories','a:2:{i:1;a:0:{}s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `hs_options` VALUES (77,'widget_text','a:2:{i:1;a:0:{}s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `hs_options` VALUES (78,'widget_rss','a:2:{i:1;a:0:{}s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `hs_options` VALUES (79,'uninstall_plugins','a:0:{}','no');
INSERT INTO `hs_options` VALUES (80,'timezone_string','Europe/Paris','yes');
INSERT INTO `hs_options` VALUES (81,'page_for_posts','0','yes');
INSERT INTO `hs_options` VALUES (82,'page_on_front','2','yes');
INSERT INTO `hs_options` VALUES (83,'default_post_format','0','yes');
INSERT INTO `hs_options` VALUES (84,'link_manager_enabled','0','yes');
INSERT INTO `hs_options` VALUES (85,'finished_splitting_shared_terms','1','yes');
INSERT INTO `hs_options` VALUES (86,'site_icon','0','yes');
INSERT INTO `hs_options` VALUES (87,'medium_large_size_w','768','yes');
INSERT INTO `hs_options` VALUES (88,'medium_large_size_h','0','yes');
INSERT INTO `hs_options` VALUES (89,'wp_page_for_privacy_policy','3','yes');
INSERT INTO `hs_options` VALUES (90,'show_comments_cookies_opt_in','1','yes');
INSERT INTO `hs_options` VALUES (91,'admin_email_lifespan','1704465785','yes');
INSERT INTO `hs_options` VALUES (92,'disallowed_keys','','no');
INSERT INTO `hs_options` VALUES (93,'comment_previously_approved','1','yes');
INSERT INTO `hs_options` VALUES (94,'auto_plugin_theme_update_emails','a:0:{}','no');
INSERT INTO `hs_options` VALUES (95,'auto_update_core_dev','enabled','yes');
INSERT INTO `hs_options` VALUES (96,'auto_update_core_minor','enabled','yes');
INSERT INTO `hs_options` VALUES (97,'auto_update_core_major','enabled','yes');
INSERT INTO `hs_options` VALUES (98,'wp_force_deactivated_plugins','a:0:{}','yes');
INSERT INTO `hs_options` VALUES (99,'initial_db_version','53496','yes');
INSERT INTO `hs_options` VALUES (100,'hs_user_roles','a:5:{s:13:"administrator";a:2:{s:4:"name";s:13:"Administrator";s:12:"capabilities";a:78:{s:13:"switch_themes";b:1;s:11:"edit_themes";b:1;s:16:"activate_plugins";b:1;s:12:"edit_plugins";b:1;s:10:"edit_users";b:1;s:10:"edit_files";b:1;s:14:"manage_options";b:1;s:17:"moderate_comments";b:1;s:17:"manage_categories";b:1;s:12:"manage_links";b:1;s:12:"upload_files";b:1;s:6:"import";b:1;s:15:"unfiltered_html";b:1;s:10:"edit_posts";b:1;s:17:"edit_others_posts";b:1;s:20:"edit_published_posts";b:1;s:13:"publish_posts";b:1;s:10:"edit_pages";b:1;s:4:"read";b:1;s:8:"level_10";b:1;s:7:"level_9";b:1;s:7:"level_8";b:1;s:7:"level_7";b:1;s:7:"level_6";b:1;s:7:"level_5";b:1;s:7:"level_4";b:1;s:7:"level_3";b:1;s:7:"level_2";b:1;s:7:"level_1";b:1;s:7:"level_0";b:1;s:17:"edit_others_pages";b:1;s:20:"edit_published_pages";b:1;s:13:"publish_pages";b:1;s:12:"delete_pages";b:1;s:19:"delete_others_pages";b:1;s:22:"delete_published_pages";b:1;s:12:"delete_posts";b:1;s:19:"delete_others_posts";b:1;s:22:"delete_published_posts";b:1;s:20:"delete_private_posts";b:1;s:18:"edit_private_posts";b:1;s:18:"read_private_posts";b:1;s:20:"delete_private_pages";b:1;s:18:"edit_private_pages";b:1;s:18:"read_private_pages";b:1;s:12:"delete_users";b:1;s:12:"create_users";b:1;s:17:"unfiltered_upload";b:1;s:14:"edit_dashboard";b:1;s:14:"update_plugins";b:1;s:14:"delete_plugins";b:1;s:15:"install_plugins";b:1;s:13:"update_themes";b:1;s:14:"install_themes";b:1;s:11:"update_core";b:1;s:10:"list_users";b:1;s:12:"remove_users";b:1;s:13:"promote_users";b:1;s:18:"edit_theme_options";b:1;s:13:"delete_themes";b:1;s:6:"export";b:1;s:22:"tablepress_edit_tables";b:1;s:24:"tablepress_delete_tables";b:1;s:22:"tablepress_list_tables";b:1;s:21:"tablepress_add_tables";b:1;s:22:"tablepress_copy_tables";b:1;s:24:"tablepress_import_tables";b:1;s:24:"tablepress_export_tables";b:1;s:32:"tablepress_access_options_screen";b:1;s:30:"tablepress_access_about_screen";b:1;s:23:"tablepress_edit_options";b:1;s:14:"frm_view_forms";b:1;s:14:"frm_edit_forms";b:1;s:16:"frm_delete_forms";b:1;s:19:"frm_change_settings";b:1;s:16:"frm_view_entries";b:1;s:18:"frm_delete_entries";b:1;s:28:"tablepress_import_tables_url";b:1;}}s:6:"editor";a:2:{s:4:"name";s:6:"Editor";s:12:"capabilities";a:44:{s:17:"moderate_comments";b:1;s:17:"manage_categories";b:1;s:12:"manage_links";b:1;s:12:"upload_files";b:1;s:15:"unfiltered_html";b:1;s:10:"edit_posts";b:1;s:17:"edit_others_posts";b:1;s:20:"edit_published_posts";b:1;s:13:"publish_posts";b:1;s:10:"edit_pages";b:1;s:4:"read";b:1;s:7:"level_7";b:1;s:7:"level_6";b:1;s:7:"level_5";b:1;s:7:"level_4";b:1;s:7:"level_3";b:1;s:7:"level_2";b:1;s:7:"level_1";b:1;s:7:"level_0";b:1;s:17:"edit_others_pages";b:1;s:20:"edit_published_pages";b:1;s:13:"publish_pages";b:1;s:12:"delete_pages";b:1;s:19:"delete_others_pages";b:1;s:22:"delete_published_pages";b:1;s:12:"delete_posts";b:1;s:19:"delete_others_posts";b:1;s:22:"delete_published_posts";b:1;s:20:"delete_private_posts";b:1;s:18:"edit_private_posts";b:1;s:18:"read_private_posts";b:1;s:20:"delete_private_pages";b:1;s:18:"edit_private_pages";b:1;s:18:"read_private_pages";b:1;s:22:"tablepress_edit_tables";b:1;s:24:"tablepress_delete_tables";b:1;s:22:"tablepress_list_tables";b:1;s:21:"tablepress_add_tables";b:1;s:22:"tablepress_copy_tables";b:1;s:24:"tablepress_import_tables";b:1;s:24:"tablepress_export_tables";b:1;s:32:"tablepress_access_options_screen";b:1;s:30:"tablepress_access_about_screen";b:1;s:28:"tablepress_import_tables_url";b:1;}}s:6:"author";a:2:{s:4:"name";s:6:"Author";s:12:"capabilities";a:19:{s:12:"upload_files";b:1;s:10:"edit_posts";b:1;s:20:"edit_published_posts";b:1;s:13:"publish_posts";b:1;s:4:"read";b:1;s:7:"level_2";b:1;s:7:"level_1";b:1;s:7:"level_0";b:1;s:12:"delete_posts";b:1;s:22:"delete_published_posts";b:1;s:22:"tablepress_edit_tables";b:1;s:24:"tablepress_delete_tables";b:1;s:22:"tablepress_list_tables";b:1;s:21:"tablepress_add_tables";b:1;s:22:"tablepress_copy_tables";b:1;s:24:"tablepress_import_tables";b:1;s:24:"tablepress_export_tables";b:1;s:32:"tablepress_access_options_screen";b:1;s:30:"tablepress_access_about_screen";b:1;}}s:11:"contributor";a:2:{s:4:"name";s:11:"Contributor";s:12:"capabilities";a:5:{s:10:"edit_posts";b:1;s:4:"read";b:1;s:7:"level_1";b:1;s:7:"level_0";b:1;s:12:"delete_posts";b:1;}}s:10:"subscriber";a:2:{s:4:"name";s:10:"Subscriber";s:12:"capabilities";a:2:{s:4:"read";b:1;s:7:"level_0";b:1;}}}','yes');
INSERT INTO `hs_options` VALUES (101,'fresh_site','0','yes');
INSERT INTO `hs_options` VALUES (102,'WPLANG','fr_FR','yes');
INSERT INTO `hs_options` VALUES (103,'user_count','1','no');
INSERT INTO `hs_options` VALUES (104,'widget_block','a:6:{i:2;a:1:{s:7:"content";s:19:"<!-- wp:search /-->";}i:3;a:1:{s:7:"content";s:159:"<!-- wp:group --><div class="wp-block-group"><!-- wp:heading --><h2>Articles récents</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->";}i:4;a:1:{s:7:"content";s:233:"<!-- wp:group --><div class="wp-block-group"><!-- wp:heading --><h2>Commentaires récents</h2><!-- /wp:heading --><!-- wp:latest-comments {"displayAvatar":false,"displayDate":false,"displayExcerpt":false} /--></div><!-- /wp:group -->";}i:5;a:1:{s:7:"content";s:146:"<!-- wp:group --><div class="wp-block-group"><!-- wp:heading --><h2>Archives</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->";}i:6;a:1:{s:7:"content";s:151:"<!-- wp:group --><div class="wp-block-group"><!-- wp:heading --><h2>Catégories</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->";}s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `hs_options` VALUES (105,'sidebars_widgets','a:9:{s:19:"wp_inactive_widgets";a:0:{}s:9:"sidebar-1";a:3:{i:0;s:7:"block-2";i:1;s:7:"block-3";i:2;s:7:"block-4";}s:9:"sidebar-2";a:2:{i:0;s:7:"block-5";i:1;s:7:"block-6";}s:8:"footer-1";a:0:{}s:8:"footer-2";a:0:{}s:8:"footer-3";a:0:{}s:8:"footer-4";a:0:{}s:11:"product-cat";a:0:{}s:13:"array_version";i:3;}','yes');
INSERT INTO `hs_options` VALUES (106,'cron','a:14:{i:1717726091;a:1:{s:33:"wpvivid_clean_backup_record_event";a:1:{s:32:"a16003197f2bd4bac2d6bae0005ed71c";a:2:{s:8:"schedule";b:0;s:4:"args";a:1:{i:0;s:21:"wpvivid-665e80a510ba1";}}}}i:1717726151;a:1:{s:28:"wpvivid_task_monitor_event_2";a:1:{s:32:"d8876ba3c8e1aac8a316ffa7a4fdfb03";a:2:{s:8:"schedule";b:0;s:4:"args";a:1:{i:0;s:21:"wpvivid-66626b4fcf874";}}}}i:1717728186;a:3:{s:16:"wp_version_check";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:10:"twicedaily";s:4:"args";a:0:{}s:8:"interval";i:43200;}}s:17:"wp_update_plugins";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:10:"twicedaily";s:4:"args";a:0:{}s:8:"interval";i:43200;}}s:16:"wp_update_themes";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:10:"twicedaily";s:4:"args";a:0:{}s:8:"interval";i:43200;}}}i:1717728199;a:1:{s:21:"wp_update_user_counts";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:10:"twicedaily";s:4:"args";a:0:{}s:8:"interval";i:43200;}}}i:1717729096;a:1:{s:34:"wp_privacy_delete_old_export_files";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:6:"hourly";s:4:"args";a:0:{}s:8:"interval";i:3600;}}}i:1717771399;a:2:{s:19:"wp_scheduled_delete";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:5:"daily";s:4:"args";a:0:{}s:8:"interval";i:86400;}}s:25:"delete_expired_transients";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:5:"daily";s:4:"args";a:0:{}s:8:"interval";i:86400;}}}i:1717771400;a:1:{s:30:"wp_scheduled_auto_draft_delete";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:5:"daily";s:4:"args";a:0:{}s:8:"interval";i:86400;}}}i:1717777578;a:1:{s:32:"recovery_mode_clean_expired_keys";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:5:"daily";s:4:"args";a:0:{}s:8:"interval";i:86400;}}}i:1717779509;a:1:{s:30:"wp_delete_temp_updater_backups";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:6:"weekly";s:4:"args";a:0:{}s:8:"interval";i:604800;}}}i:1717786096;a:1:{s:15:"frm_daily_event";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:5:"daily";s:4:"args";a:0:{}s:8:"interval";i:86400;}}}i:1717804800;a:1:{s:27:"wpvivid_main_schedule_event";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:13:"wpvivid_daily";s:4:"args";a:0:{}s:8:"interval";i:86400;}}}i:1718030586;a:1:{s:30:"wp_site_health_scheduled_check";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:6:"weekly";s:4:"args";a:0:{}s:8:"interval";i:604800;}}}i:1718197517;a:1:{s:21:"formidable_send_usage";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:6:"weekly";s:4:"args";a:0:{}s:8:"interval";i:604800;}}}s:7:"version";i:2;}','yes');
INSERT INTO `hs_options` VALUES (107,'widget_pages','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `hs_options` VALUES (108,'widget_calendar','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `hs_options` VALUES (109,'widget_archives','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `hs_options` VALUES (110,'widget_media_audio','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `hs_options` VALUES (111,'widget_media_image','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `hs_options` VALUES (112,'widget_media_gallery','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `hs_options` VALUES (113,'widget_media_video','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `hs_options` VALUES (114,'widget_meta','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `hs_options` VALUES (115,'widget_search','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `hs_options` VALUES (116,'widget_recent-posts','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `hs_options` VALUES (117,'widget_recent-comments','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `hs_options` VALUES (118,'widget_tag_cloud','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `hs_options` VALUES (119,'widget_nav_menu','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `hs_options` VALUES (120,'widget_custom_html','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `hs_options` VALUES (122,'theme_mods_twentytwentythree','a:2:{s:18:"custom_css_post_id";i:-1;s:16:"sidebars_widgets";a:2:{s:4:"time";i:1688914268;s:4:"data";a:3:{s:19:"wp_inactive_widgets";a:0:{}s:9:"sidebar-1";a:3:{i:0;s:7:"block-2";i:1;s:7:"block-3";i:2;s:7:"block-4";}s:9:"sidebar-2";a:2:{i:0;s:7:"block-5";i:1;s:7:"block-6";}}}}','no');
INSERT INTO `hs_options` VALUES (123,'recovery_keys','a:0:{}','yes');
INSERT INTO `hs_options` VALUES (124,'https_detection_errors','a:1:{s:23:"ssl_verification_failed";a:1:{i:0;s:32:"La vérification SSL a échoué.";}}','yes');
INSERT INTO `hs_options` VALUES (155,'recently_activated','a:0:{}','yes');
INSERT INTO `hs_options` VALUES (159,'finished_updating_comment_type','1','yes');
INSERT INTO `hs_options` VALUES (164,'current_theme','Agriculture Farming','yes');
INSERT INTO `hs_options` VALUES (165,'theme_mods_agriculture-farm','a:4:{i:0;b:0;s:18:"nav_menu_locations";a:0:{}s:18:"custom_css_post_id";i:-1;s:16:"sidebars_widgets";a:2:{s:4:"time";i:1688920050;s:4:"data";a:10:{s:19:"wp_inactive_widgets";a:0:{}s:9:"sidebar-1";a:3:{i:0;s:7:"block-2";i:1;s:7:"block-3";i:2;s:7:"block-4";}s:9:"sidebar-2";a:2:{i:0;s:7:"block-5";i:1;s:7:"block-6";}s:9:"sidebar-3";a:0:{}s:8:"footer-1";a:0:{}s:8:"footer-2";a:0:{}s:8:"footer-3";a:0:{}s:8:"footer-4";a:0:{}s:19:"woocommerce_sidebar";a:0:{}s:26:"woocommerce-single-sidebar";a:0:{}}}}','no');
INSERT INTO `hs_options` VALUES (166,'theme_switched','','yes');
INSERT INTO `hs_options` VALUES (168,'theme_mods_agriculture-farming','a:4:{i:0;b:0;s:18:"nav_menu_locations";a:1:{s:7:"primary";i:2;}s:18:"custom_css_post_id";i:-1;s:16:"sidebars_widgets";a:2:{s:4:"time";i:1688920009;s:4:"data";a:10:{s:19:"wp_inactive_widgets";a:0:{}s:9:"sidebar-1";a:3:{i:0;s:7:"block-2";i:1;s:7:"block-3";i:2;s:7:"block-4";}s:9:"sidebar-2";a:2:{i:0;s:7:"block-5";i:1;s:7:"block-6";}s:9:"sidebar-3";a:0:{}s:8:"footer-1";a:0:{}s:8:"footer-2";a:0:{}s:8:"footer-3";a:0:{}s:8:"footer-4";a:0:{}s:19:"woocommerce_sidebar";a:0:{}s:26:"woocommerce-single-sidebar";a:0:{}}}}','yes');
INSERT INTO `hs_options` VALUES (170,'downloaded_font_files','a:82:{s:70:"https://fonts.gstatic.com/s/bangers/v24/FeVQS0BTqb0h60ACH5FQ2Ixi.woff2";s:76:"/home/vicqorgvmv/hs/wp-content//fonts/bangers/FeVQS0BTqb0h60ACH5FQ2Ixi.woff2";s:70:"https://fonts.gstatic.com/s/bangers/v24/FeVQS0BTqb0h60ACH5BQ2Ixi.woff2";s:76:"/home/vicqorgvmv/hs/wp-content//fonts/bangers/FeVQS0BTqb0h60ACH5BQ2Ixi.woff2";s:68:"https://fonts.gstatic.com/s/bangers/v24/FeVQS0BTqb0h60ACH55Q2A.woff2";s:74:"/home/vicqorgvmv/hs/wp-content//fonts/bangers/FeVQS0BTqb0h60ACH55Q2A.woff2";s:71:"https://fonts.gstatic.com/s/kanit/v15/nKKV-Go6G5tXcraQI2GwZoREDFs.woff2";s:77:"/home/vicqorgvmv/hs/wp-content//fonts/kanit/nKKV-Go6G5tXcraQI2GwZoREDFs.woff2";s:71:"https://fonts.gstatic.com/s/kanit/v15/nKKV-Go6G5tXcraQI2GwfYREDFs.woff2";s:77:"/home/vicqorgvmv/hs/wp-content//fonts/kanit/nKKV-Go6G5tXcraQI2GwfYREDFs.woff2";s:71:"https://fonts.gstatic.com/s/kanit/v15/nKKV-Go6G5tXcraQI2GwfIREDFs.woff2";s:77:"/home/vicqorgvmv/hs/wp-content//fonts/kanit/nKKV-Go6G5tXcraQI2GwfIREDFs.woff2";s:68:"https://fonts.gstatic.com/s/kanit/v15/nKKV-Go6G5tXcraQI2GwcoRE.woff2";s:74:"/home/vicqorgvmv/hs/wp-content//fonts/kanit/nKKV-Go6G5tXcraQI2GwcoRE.woff2";s:72:"https://fonts.gstatic.com/s/kanit/v15/nKKS-Go6G5tXcraQI82hZbdhMWJy.woff2";s:78:"/home/vicqorgvmv/hs/wp-content//fonts/kanit/nKKS-Go6G5tXcraQI82hZbdhMWJy.woff2";s:72:"https://fonts.gstatic.com/s/kanit/v15/nKKS-Go6G5tXcraQI82hZaxhMWJy.woff2";s:78:"/home/vicqorgvmv/hs/wp-content//fonts/kanit/nKKS-Go6G5tXcraQI82hZaxhMWJy.woff2";s:72:"https://fonts.gstatic.com/s/kanit/v15/nKKS-Go6G5tXcraQI82hZa1hMWJy.woff2";s:78:"/home/vicqorgvmv/hs/wp-content//fonts/kanit/nKKS-Go6G5tXcraQI82hZa1hMWJy.woff2";s:70:"https://fonts.gstatic.com/s/kanit/v15/nKKS-Go6G5tXcraQI82hZaNhMQ.woff2";s:76:"/home/vicqorgvmv/hs/wp-content//fonts/kanit/nKKS-Go6G5tXcraQI82hZaNhMQ.woff2";s:72:"https://fonts.gstatic.com/s/kanit/v15/nKKS-Go6G5tXcraQI6miZbdhMWJy.woff2";s:78:"/home/vicqorgvmv/hs/wp-content//fonts/kanit/nKKS-Go6G5tXcraQI6miZbdhMWJy.woff2";s:72:"https://fonts.gstatic.com/s/kanit/v15/nKKS-Go6G5tXcraQI6miZaxhMWJy.woff2";s:78:"/home/vicqorgvmv/hs/wp-content//fonts/kanit/nKKS-Go6G5tXcraQI6miZaxhMWJy.woff2";s:72:"https://fonts.gstatic.com/s/kanit/v15/nKKS-Go6G5tXcraQI6miZa1hMWJy.woff2";s:78:"/home/vicqorgvmv/hs/wp-content//fonts/kanit/nKKS-Go6G5tXcraQI6miZa1hMWJy.woff2";s:70:"https://fonts.gstatic.com/s/kanit/v15/nKKS-Go6G5tXcraQI6miZaNhMQ.woff2";s:76:"/home/vicqorgvmv/hs/wp-content//fonts/kanit/nKKS-Go6G5tXcraQI6miZaNhMQ.woff2";s:68:"https://fonts.gstatic.com/s/kanit/v15/nKKX-Go6G5tXcraQKxaAcJxA.woff2";s:74:"/home/vicqorgvmv/hs/wp-content//fonts/kanit/nKKX-Go6G5tXcraQKxaAcJxA.woff2";s:68:"https://fonts.gstatic.com/s/kanit/v15/nKKX-Go6G5tXcraQKw2AcJxA.woff2";s:74:"/home/vicqorgvmv/hs/wp-content//fonts/kanit/nKKX-Go6G5tXcraQKw2AcJxA.woff2";s:68:"https://fonts.gstatic.com/s/kanit/v15/nKKX-Go6G5tXcraQKwyAcJxA.woff2";s:74:"/home/vicqorgvmv/hs/wp-content//fonts/kanit/nKKX-Go6G5tXcraQKwyAcJxA.woff2";s:66:"https://fonts.gstatic.com/s/kanit/v15/nKKX-Go6G5tXcraQKwKAcA.woff2";s:72:"/home/vicqorgvmv/hs/wp-content//fonts/kanit/nKKX-Go6G5tXcraQKwKAcA.woff2";s:72:"https://fonts.gstatic.com/s/kanit/v15/nKKS-Go6G5tXcraQI_GjZbdhMWJy.woff2";s:78:"/home/vicqorgvmv/hs/wp-content//fonts/kanit/nKKS-Go6G5tXcraQI_GjZbdhMWJy.woff2";s:72:"https://fonts.gstatic.com/s/kanit/v15/nKKS-Go6G5tXcraQI_GjZaxhMWJy.woff2";s:78:"/home/vicqorgvmv/hs/wp-content//fonts/kanit/nKKS-Go6G5tXcraQI_GjZaxhMWJy.woff2";s:72:"https://fonts.gstatic.com/s/kanit/v15/nKKS-Go6G5tXcraQI_GjZa1hMWJy.woff2";s:78:"/home/vicqorgvmv/hs/wp-content//fonts/kanit/nKKS-Go6G5tXcraQI_GjZa1hMWJy.woff2";s:70:"https://fonts.gstatic.com/s/kanit/v15/nKKS-Go6G5tXcraQI_GjZaNhMQ.woff2";s:76:"/home/vicqorgvmv/hs/wp-content//fonts/kanit/nKKS-Go6G5tXcraQI_GjZaNhMQ.woff2";s:72:"https://fonts.gstatic.com/s/kanit/v15/nKKS-Go6G5tXcraQI92kZbdhMWJy.woff2";s:78:"/home/vicqorgvmv/hs/wp-content//fonts/kanit/nKKS-Go6G5tXcraQI92kZbdhMWJy.woff2";s:72:"https://fonts.gstatic.com/s/kanit/v15/nKKS-Go6G5tXcraQI92kZaxhMWJy.woff2";s:78:"/home/vicqorgvmv/hs/wp-content//fonts/kanit/nKKS-Go6G5tXcraQI92kZaxhMWJy.woff2";s:72:"https://fonts.gstatic.com/s/kanit/v15/nKKS-Go6G5tXcraQI92kZa1hMWJy.woff2";s:78:"/home/vicqorgvmv/hs/wp-content//fonts/kanit/nKKS-Go6G5tXcraQI92kZa1hMWJy.woff2";s:70:"https://fonts.gstatic.com/s/kanit/v15/nKKS-Go6G5tXcraQI92kZaNhMQ.woff2";s:76:"/home/vicqorgvmv/hs/wp-content//fonts/kanit/nKKS-Go6G5tXcraQI92kZaNhMQ.woff2";s:72:"https://fonts.gstatic.com/s/kanit/v15/nKKS-Go6G5tXcraQI7mlZbdhMWJy.woff2";s:78:"/home/vicqorgvmv/hs/wp-content//fonts/kanit/nKKS-Go6G5tXcraQI7mlZbdhMWJy.woff2";s:72:"https://fonts.gstatic.com/s/kanit/v15/nKKS-Go6G5tXcraQI7mlZaxhMWJy.woff2";s:78:"/home/vicqorgvmv/hs/wp-content//fonts/kanit/nKKS-Go6G5tXcraQI7mlZaxhMWJy.woff2";s:72:"https://fonts.gstatic.com/s/kanit/v15/nKKS-Go6G5tXcraQI7mlZa1hMWJy.woff2";s:78:"/home/vicqorgvmv/hs/wp-content//fonts/kanit/nKKS-Go6G5tXcraQI7mlZa1hMWJy.woff2";s:70:"https://fonts.gstatic.com/s/kanit/v15/nKKS-Go6G5tXcraQI7mlZaNhMQ.woff2";s:76:"/home/vicqorgvmv/hs/wp-content//fonts/kanit/nKKS-Go6G5tXcraQI7mlZaNhMQ.woff2";s:72:"https://fonts.gstatic.com/s/kanit/v15/nKKS-Go6G5tXcraQI6WmZbdhMWJy.woff2";s:78:"/home/vicqorgvmv/hs/wp-content//fonts/kanit/nKKS-Go6G5tXcraQI6WmZbdhMWJy.woff2";s:72:"https://fonts.gstatic.com/s/kanit/v15/nKKS-Go6G5tXcraQI6WmZaxhMWJy.woff2";s:78:"/home/vicqorgvmv/hs/wp-content//fonts/kanit/nKKS-Go6G5tXcraQI6WmZaxhMWJy.woff2";s:72:"https://fonts.gstatic.com/s/kanit/v15/nKKS-Go6G5tXcraQI6WmZa1hMWJy.woff2";s:78:"/home/vicqorgvmv/hs/wp-content//fonts/kanit/nKKS-Go6G5tXcraQI6WmZa1hMWJy.woff2";s:70:"https://fonts.gstatic.com/s/kanit/v15/nKKS-Go6G5tXcraQI6WmZaNhMQ.woff2";s:76:"/home/vicqorgvmv/hs/wp-content//fonts/kanit/nKKS-Go6G5tXcraQI6WmZaNhMQ.woff2";s:72:"https://fonts.gstatic.com/s/kanit/v15/nKKS-Go6G5tXcraQI4GnZbdhMWJy.woff2";s:78:"/home/vicqorgvmv/hs/wp-content//fonts/kanit/nKKS-Go6G5tXcraQI4GnZbdhMWJy.woff2";s:72:"https://fonts.gstatic.com/s/kanit/v15/nKKS-Go6G5tXcraQI4GnZaxhMWJy.woff2";s:78:"/home/vicqorgvmv/hs/wp-content//fonts/kanit/nKKS-Go6G5tXcraQI4GnZaxhMWJy.woff2";s:72:"https://fonts.gstatic.com/s/kanit/v15/nKKS-Go6G5tXcraQI4GnZa1hMWJy.woff2";s:78:"/home/vicqorgvmv/hs/wp-content//fonts/kanit/nKKS-Go6G5tXcraQI4GnZa1hMWJy.woff2";s:70:"https://fonts.gstatic.com/s/kanit/v15/nKKS-Go6G5tXcraQI4GnZaNhMQ.woff2";s:76:"/home/vicqorgvmv/hs/wp-content//fonts/kanit/nKKS-Go6G5tXcraQI4GnZaNhMQ.woff2";s:68:"https://fonts.gstatic.com/s/kanit/v15/nKKX-Go6G5tXcr72KxaAcJxA.woff2";s:74:"/home/vicqorgvmv/hs/wp-content//fonts/kanit/nKKX-Go6G5tXcr72KxaAcJxA.woff2";s:68:"https://fonts.gstatic.com/s/kanit/v15/nKKX-Go6G5tXcr72Kw2AcJxA.woff2";s:74:"/home/vicqorgvmv/hs/wp-content//fonts/kanit/nKKX-Go6G5tXcr72Kw2AcJxA.woff2";s:68:"https://fonts.gstatic.com/s/kanit/v15/nKKX-Go6G5tXcr72KwyAcJxA.woff2";s:74:"/home/vicqorgvmv/hs/wp-content//fonts/kanit/nKKX-Go6G5tXcr72KwyAcJxA.woff2";s:66:"https://fonts.gstatic.com/s/kanit/v15/nKKX-Go6G5tXcr72KwKAcA.woff2";s:72:"/home/vicqorgvmv/hs/wp-content//fonts/kanit/nKKX-Go6G5tXcr72KwKAcA.woff2";s:70:"https://fonts.gstatic.com/s/kanit/v15/nKKU-Go6G5tXcr5aOhWzVaF5NQ.woff2";s:76:"/home/vicqorgvmv/hs/wp-content//fonts/kanit/nKKU-Go6G5tXcr5aOhWzVaF5NQ.woff2";s:70:"https://fonts.gstatic.com/s/kanit/v15/nKKU-Go6G5tXcr5aOhWoVaF5NQ.woff2";s:76:"/home/vicqorgvmv/hs/wp-content//fonts/kanit/nKKU-Go6G5tXcr5aOhWoVaF5NQ.woff2";s:70:"https://fonts.gstatic.com/s/kanit/v15/nKKU-Go6G5tXcr5aOhWpVaF5NQ.woff2";s:76:"/home/vicqorgvmv/hs/wp-content//fonts/kanit/nKKU-Go6G5tXcr5aOhWpVaF5NQ.woff2";s:67:"https://fonts.gstatic.com/s/kanit/v15/nKKU-Go6G5tXcr5aOhWnVaE.woff2";s:73:"/home/vicqorgvmv/hs/wp-content//fonts/kanit/nKKU-Go6G5tXcr5aOhWnVaE.woff2";s:70:"https://fonts.gstatic.com/s/kanit/v15/nKKU-Go6G5tXcr4-ORWzVaF5NQ.woff2";s:76:"/home/vicqorgvmv/hs/wp-content//fonts/kanit/nKKU-Go6G5tXcr4-ORWzVaF5NQ.woff2";s:70:"https://fonts.gstatic.com/s/kanit/v15/nKKU-Go6G5tXcr4-ORWoVaF5NQ.woff2";s:76:"/home/vicqorgvmv/hs/wp-content//fonts/kanit/nKKU-Go6G5tXcr4-ORWoVaF5NQ.woff2";s:70:"https://fonts.gstatic.com/s/kanit/v15/nKKU-Go6G5tXcr4-ORWpVaF5NQ.woff2";s:76:"/home/vicqorgvmv/hs/wp-content//fonts/kanit/nKKU-Go6G5tXcr4-ORWpVaF5NQ.woff2";s:67:"https://fonts.gstatic.com/s/kanit/v15/nKKU-Go6G5tXcr4-ORWnVaE.woff2";s:73:"/home/vicqorgvmv/hs/wp-content//fonts/kanit/nKKU-Go6G5tXcr4-ORWnVaE.woff2";s:66:"https://fonts.gstatic.com/s/kanit/v15/nKKZ-Go6G5tXcraBGwCYdA.woff2";s:72:"/home/vicqorgvmv/hs/wp-content//fonts/kanit/nKKZ-Go6G5tXcraBGwCYdA.woff2";s:66:"https://fonts.gstatic.com/s/kanit/v15/nKKZ-Go6G5tXcraaGwCYdA.woff2";s:72:"/home/vicqorgvmv/hs/wp-content//fonts/kanit/nKKZ-Go6G5tXcraaGwCYdA.woff2";s:66:"https://fonts.gstatic.com/s/kanit/v15/nKKZ-Go6G5tXcrabGwCYdA.woff2";s:72:"/home/vicqorgvmv/hs/wp-content//fonts/kanit/nKKZ-Go6G5tXcrabGwCYdA.woff2";s:63:"https://fonts.gstatic.com/s/kanit/v15/nKKZ-Go6G5tXcraVGwA.woff2";s:69:"/home/vicqorgvmv/hs/wp-content//fonts/kanit/nKKZ-Go6G5tXcraVGwA.woff2";s:70:"https://fonts.gstatic.com/s/kanit/v15/nKKU-Go6G5tXcr5mOBWzVaF5NQ.woff2";s:76:"/home/vicqorgvmv/hs/wp-content//fonts/kanit/nKKU-Go6G5tXcr5mOBWzVaF5NQ.woff2";s:70:"https://fonts.gstatic.com/s/kanit/v15/nKKU-Go6G5tXcr5mOBWoVaF5NQ.woff2";s:76:"/home/vicqorgvmv/hs/wp-content//fonts/kanit/nKKU-Go6G5tXcr5mOBWoVaF5NQ.woff2";s:70:"https://fonts.gstatic.com/s/kanit/v15/nKKU-Go6G5tXcr5mOBWpVaF5NQ.woff2";s:76:"/home/vicqorgvmv/hs/wp-content//fonts/kanit/nKKU-Go6G5tXcr5mOBWpVaF5NQ.woff2";s:67:"https://fonts.gstatic.com/s/kanit/v15/nKKU-Go6G5tXcr5mOBWnVaE.woff2";s:73:"/home/vicqorgvmv/hs/wp-content//fonts/kanit/nKKU-Go6G5tXcr5mOBWnVaE.woff2";s:70:"https://fonts.gstatic.com/s/kanit/v15/nKKU-Go6G5tXcr5KPxWzVaF5NQ.woff2";s:76:"/home/vicqorgvmv/hs/wp-content//fonts/kanit/nKKU-Go6G5tXcr5KPxWzVaF5NQ.woff2";s:70:"https://fonts.gstatic.com/s/kanit/v15/nKKU-Go6G5tXcr5KPxWoVaF5NQ.woff2";s:76:"/home/vicqorgvmv/hs/wp-content//fonts/kanit/nKKU-Go6G5tXcr5KPxWoVaF5NQ.woff2";s:70:"https://fonts.gstatic.com/s/kanit/v15/nKKU-Go6G5tXcr5KPxWpVaF5NQ.woff2";s:76:"/home/vicqorgvmv/hs/wp-content//fonts/kanit/nKKU-Go6G5tXcr5KPxWpVaF5NQ.woff2";s:67:"https://fonts.gstatic.com/s/kanit/v15/nKKU-Go6G5tXcr5KPxWnVaE.woff2";s:73:"/home/vicqorgvmv/hs/wp-content//fonts/kanit/nKKU-Go6G5tXcr5KPxWnVaE.woff2";s:70:"https://fonts.gstatic.com/s/kanit/v15/nKKU-Go6G5tXcr4uPhWzVaF5NQ.woff2";s:76:"/home/vicqorgvmv/hs/wp-content//fonts/kanit/nKKU-Go6G5tXcr4uPhWzVaF5NQ.woff2";s:70:"https://fonts.gstatic.com/s/kanit/v15/nKKU-Go6G5tXcr4uPhWoVaF5NQ.woff2";s:76:"/home/vicqorgvmv/hs/wp-content//fonts/kanit/nKKU-Go6G5tXcr4uPhWoVaF5NQ.woff2";s:70:"https://fonts.gstatic.com/s/kanit/v15/nKKU-Go6G5tXcr4uPhWpVaF5NQ.woff2";s:76:"/home/vicqorgvmv/hs/wp-content//fonts/kanit/nKKU-Go6G5tXcr4uPhWpVaF5NQ.woff2";s:67:"https://fonts.gstatic.com/s/kanit/v15/nKKU-Go6G5tXcr4uPhWnVaE.woff2";s:73:"/home/vicqorgvmv/hs/wp-content//fonts/kanit/nKKU-Go6G5tXcr4uPhWnVaE.woff2";s:70:"https://fonts.gstatic.com/s/kanit/v15/nKKU-Go6G5tXcr4yPRWzVaF5NQ.woff2";s:76:"/home/vicqorgvmv/hs/wp-content//fonts/kanit/nKKU-Go6G5tXcr4yPRWzVaF5NQ.woff2";s:70:"https://fonts.gstatic.com/s/kanit/v15/nKKU-Go6G5tXcr4yPRWoVaF5NQ.woff2";s:76:"/home/vicqorgvmv/hs/wp-content//fonts/kanit/nKKU-Go6G5tXcr4yPRWoVaF5NQ.woff2";s:70:"https://fonts.gstatic.com/s/kanit/v15/nKKU-Go6G5tXcr4yPRWpVaF5NQ.woff2";s:76:"/home/vicqorgvmv/hs/wp-content//fonts/kanit/nKKU-Go6G5tXcr4yPRWpVaF5NQ.woff2";s:67:"https://fonts.gstatic.com/s/kanit/v15/nKKU-Go6G5tXcr4yPRWnVaE.woff2";s:73:"/home/vicqorgvmv/hs/wp-content//fonts/kanit/nKKU-Go6G5tXcr4yPRWnVaE.woff2";s:70:"https://fonts.gstatic.com/s/kanit/v15/nKKU-Go6G5tXcr4WPBWzVaF5NQ.woff2";s:76:"/home/vicqorgvmv/hs/wp-content//fonts/kanit/nKKU-Go6G5tXcr4WPBWzVaF5NQ.woff2";s:70:"https://fonts.gstatic.com/s/kanit/v15/nKKU-Go6G5tXcr4WPBWoVaF5NQ.woff2";s:76:"/home/vicqorgvmv/hs/wp-content//fonts/kanit/nKKU-Go6G5tXcr4WPBWoVaF5NQ.woff2";s:70:"https://fonts.gstatic.com/s/kanit/v15/nKKU-Go6G5tXcr4WPBWpVaF5NQ.woff2";s:76:"/home/vicqorgvmv/hs/wp-content//fonts/kanit/nKKU-Go6G5tXcr4WPBWpVaF5NQ.woff2";s:67:"https://fonts.gstatic.com/s/kanit/v15/nKKU-Go6G5tXcr4WPBWnVaE.woff2";s:73:"/home/vicqorgvmv/hs/wp-content//fonts/kanit/nKKU-Go6G5tXcr4WPBWnVaE.woff2";s:68:"https://fonts.gstatic.com/s/oswald/v53/TK3iWkUHHAIjg752FD8Ghe4.woff2";s:74:"/home/vicqorgvmv/hs/wp-content//fonts/oswald/TK3iWkUHHAIjg752FD8Ghe4.woff2";s:68:"https://fonts.gstatic.com/s/oswald/v53/TK3iWkUHHAIjg752HT8Ghe4.woff2";s:74:"/home/vicqorgvmv/hs/wp-content//fonts/oswald/TK3iWkUHHAIjg752HT8Ghe4.woff2";s:68:"https://fonts.gstatic.com/s/oswald/v53/TK3iWkUHHAIjg752Fj8Ghe4.woff2";s:74:"/home/vicqorgvmv/hs/wp-content//fonts/oswald/TK3iWkUHHAIjg752Fj8Ghe4.woff2";s:68:"https://fonts.gstatic.com/s/oswald/v53/TK3iWkUHHAIjg752Fz8Ghe4.woff2";s:74:"/home/vicqorgvmv/hs/wp-content//fonts/oswald/TK3iWkUHHAIjg752Fz8Ghe4.woff2";s:65:"https://fonts.gstatic.com/s/oswald/v53/TK3iWkUHHAIjg752GT8G.woff2";s:71:"/home/vicqorgvmv/hs/wp-content//fonts/oswald/TK3iWkUHHAIjg752GT8G.woff2";s:60:"https://fonts.gstatic.com/s/sen/v9/6xKjdSxYI9_3kvWNEmo.woff2";s:67:"/home/vicqorgvmv/hs/wp-content//fonts/sen/6xKjdSxYI9_3kvWNEmo.woff2";s:57:"https://fonts.gstatic.com/s/sen/v9/6xKjdSxYI9_3nPWN.woff2";s:64:"/home/vicqorgvmv/hs/wp-content//fonts/sen/6xKjdSxYI9_3nPWN.woff2";}','no');
INSERT INTO `hs_options` VALUES (184,'nav_menu_options','a:1:{s:8:"auto_add";a:0:{}}','yes');
INSERT INTO `hs_options` VALUES (220,'fs_active_plugins','O:8:"stdClass":3:{s:7:"plugins";a:1:{s:29:"tablepress/libraries/freemius";O:8:"stdClass":4:{s:7:"version";s:5:"2.7.2";s:4:"type";s:6:"plugin";s:9:"timestamp";i:1714474750;s:11:"plugin_path";s:25:"tablepress/tablepress.php";}}s:7:"abspath";s:20:"/home/vicqorgvmv/hs/";s:6:"newest";O:8:"stdClass":5:{s:11:"plugin_path";s:25:"tablepress/tablepress.php";s:8:"sdk_path";s:29:"tablepress/libraries/freemius";s:7:"version";s:5:"2.7.2";s:13:"in_activation";b:0;s:9:"timestamp";i:1714474750;}}','yes');
INSERT INTO `hs_options` VALUES (221,'fs_debug_mode','','yes');
INSERT INTO `hs_options` VALUES (222,'fs_accounts','a:8:{s:21:"id_slug_type_path_map";a:1:{i:10340;a:3:{s:4:"slug";s:10:"tablepress";s:4:"type";s:6:"plugin";s:4:"path";s:25:"tablepress/tablepress.php";}}s:11:"plugin_data";a:1:{s:10:"tablepress";a:17:{s:16:"plugin_main_file";O:8:"stdClass":1:{s:4:"path";s:25:"tablepress/tablepress.php";}s:20:"is_network_activated";b:0;s:17:"install_timestamp";i:1688919324;s:17:"was_plugin_loaded";b:1;s:21:"is_plugin_new_install";b:0;s:16:"sdk_last_version";s:5:"2.6.2";s:11:"sdk_version";s:5:"2.7.2";s:16:"sdk_upgrade_mode";b:1;s:18:"sdk_downgrade_mode";b:0;s:19:"plugin_last_version";s:5:"2.3.1";s:14:"plugin_version";s:5:"2.3.2";s:19:"plugin_upgrade_mode";b:1;s:21:"plugin_downgrade_mode";b:0;s:17:"connectivity_test";a:6:{s:12:"is_connected";N;s:4:"host";s:8:"vicq.org";s:9:"server_ip";s:12:"10.11.20.141";s:9:"is_active";b:1;s:9:"timestamp";i:1688919324;s:7:"version";s:5:"2.1.5";}s:15:"prev_is_premium";b:0;s:21:"is_pending_activation";b:1;s:19:"last_load_timestamp";i:1717677727;}}s:13:"file_slug_map";a:1:{s:25:"tablepress/tablepress.php";s:10:"tablepress";}s:7:"plugins";a:1:{s:10:"tablepress";O:9:"FS_Plugin":24:{s:16:"parent_plugin_id";N;s:5:"title";s:10:"TablePress";s:4:"slug";s:10:"tablepress";s:12:"premium_slug";s:18:"tablepress-premium";s:4:"type";s:6:"plugin";s:20:"affiliate_moderation";b:0;s:19:"is_wp_org_compliant";b:1;s:22:"premium_releases_count";N;s:4:"file";s:25:"tablepress/tablepress.php";s:7:"version";s:5:"2.3.2";s:11:"auto_update";N;s:4:"info";N;s:10:"is_premium";b:0;s:14:"premium_suffix";s:9:"(Premium)";s:7:"is_live";b:1;s:9:"bundle_id";N;s:17:"bundle_public_key";N;s:17:"opt_in_moderation";N;s:10:"public_key";s:32:"pk_b215ca1bb4041cf43ed137ae7665b";s:10:"secret_key";N;s:2:"id";s:5:"10340";s:7:"updated";N;s:7:"created";N;s:22:"\0FS_Entity\0_is_updated";b:1;}}s:9:"unique_id";s:32:"08191d99a2272d4534baa70ca279417a";s:13:"admin_notices";a:1:{s:10:"tablepress";a:0:{}}s:12:"gc_timestamp";a:0:{}s:10:"theme_data";a:0:{}}','yes');
INSERT INTO `hs_options` VALUES (223,'fs_api_cache','a:0:{}','no');
INSERT INTO `hs_options` VALUES (226,'tablepress_plugin_options','{"plugin_options_db_version":78,"table_scheme_db_version":3,"prev_tablepress_version":"2.3.1","tablepress_version":"2.3.2","first_activation":1688919325,"message_plugin_update":true,"message_donation_nag":true,"use_custom_css":true,"use_custom_css_file":true,"custom_css":"","custom_css_minified":"","custom_css_version":0,"modules":false}','yes');
INSERT INTO `hs_options` VALUES (227,'tablepress_tables','{"last_id":1,"table_post":{"1":40}}','yes');
INSERT INTO `hs_options` VALUES (250,'_transient_health-check-site-status-result','{"good":18,"recommended":5,"critical":0}','yes');
INSERT INTO `hs_options` VALUES (479,'db_upgraded','','yes');
INSERT INTO `hs_options` VALUES (485,'auto_core_update_notified','a:4:{s:4:"type";s:7:"success";s:5:"email";s:12:"alex@vicq.me";s:7:"version";s:5:"6.5.4";s:9:"timestamp";i:1717610856;}','no');
INSERT INTO `hs_options` VALUES (495,'category_children','a:0:{}','yes');
INSERT INTO `hs_options` VALUES (522,'wpvivid_remote_init','init','no');
INSERT INTO `hs_options` VALUES (524,'wpvivid_check_htaccess_rule_free','1','yes');
INSERT INTO `hs_options` VALUES (527,'clean_task','a:1:{s:21:"wpvivid-665e80a510ba1";a:11:{s:4:"type";s:4:"Cron";s:11:"create_time";i:1717469349;s:13:"manual_delete";i:0;s:5:"local";a:1:{s:4:"path";s:14:"wpvividbackups";}s:8:"compress";a:1:{s:13:"compress_type";s:3:"zip";}s:10:"save_local";b:0;s:13:"backup_prefix";s:11:"hs.vicq.org";s:3:"log";s:94:"/home/vicqorgvmv/hs/wp-content/wpvividbackups/wpvivid_log/wpvivid-665e80a510ba1_backup_log.txt";s:6:"backup";a:2:{s:6:"result";s:7:"success";s:5:"files";a:1:{i:0;a:2:{s:9:"file_name";s:65:"hs.vicq.org_wpvivid-665e80a510ba1_2024-06-04-04-49_backup_all.zip";s:4:"size";i:70179935;}}}s:6:"remote";a:1:{s:28:"wpvivid-remote-64d7698e5fbc0";a:9:{s:7:"passive";s:1:"1";s:4:"name";s:6:"ovh-hs";s:6:"server";s:12:"ftp.vicq.org";s:8:"username";s:10:"vicqorgvmv";s:4:"path";s:21:"/backup/wordpress/hs/";s:8:"password";s:16:"RnRwb3ZoMTcxNg==";s:4:"type";s:3:"ftp";s:4:"host";s:12:"ftp.vicq.org";s:10:"is_encrypt";i:1;}}s:4:"lock";s:1:"0";}}','no');
INSERT INTO `hs_options` VALUES (530,'wpvivid_init','init','no');
INSERT INTO `hs_options` VALUES (531,'wpvivid_schedule_setting','a:5:{s:6:"enable";s:1:"1";s:4:"type";s:13:"wpvivid_daily";s:5:"event";s:27:"wpvivid_main_schedule_event";s:10:"start_time";i:1692835200;s:6:"backup";a:5:{s:12:"backup_files";s:8:"files+db";s:5:"local";i:0;s:6:"remote";i:1;s:7:"ismerge";i:1;s:4:"lock";s:1:"0";}}','no');
INSERT INTO `hs_options` VALUES (532,'wpvivid_compress_setting','a:7:{s:13:"compress_type";s:3:"zip";s:13:"max_file_size";i:200;s:11:"no_compress";b:1;s:13:"use_temp_file";i:1;s:13:"use_temp_size";i:16;s:17:"exclude_file_size";i:0;s:24:"subpackage_plugin_upload";b:0;}','no');
INSERT INTO `hs_options` VALUES (533,'wpvivid_local_setting','a:2:{s:4:"path";s:14:"wpvividbackups";s:10:"save_local";i:1;}','no');
INSERT INTO `hs_options` VALUES (534,'wpvivid_upload_setting','a:2:{s:15:"remote_selected";a:0:{}s:28:"wpvivid-remote-64d7698e5fbc0";a:9:{s:7:"passive";s:1:"1";s:4:"name";s:6:"ovh-hs";s:6:"server";s:12:"ftp.vicq.org";s:8:"username";s:10:"vicqorgvmv";s:4:"path";s:21:"/backup/wordpress/hs/";s:8:"password";s:16:"RnRwb3ZoMTcxNg==";s:4:"type";s:3:"ftp";s:4:"host";s:12:"ftp.vicq.org";s:10:"is_encrypt";i:1;}}','no');
INSERT INTO `hs_options` VALUES (535,'wpvivid_common_setting','a:10:{s:18:"max_execution_time";i:300;s:16:"max_backup_count";i:3;s:14:"show_admin_bar";b:1;s:14:"domain_include";b:1;s:15:"estimate_backup";b:1;s:16:"max_resume_count";i:6;s:12:"memory_limit";s:4:"256M";s:20:"restore_memory_limit";s:4:"512M";s:12:"migrate_size";s:4:"2048";s:17:"log_save_location";s:26:"wpvividbackups/wpvivid_log";}','no');
INSERT INTO `hs_options` VALUES (536,'wpvivid_email_setting','a:3:{s:7:"send_to";a:0:{}s:6:"always";b:1;s:12:"email_enable";b:0;}','no');
INSERT INTO `hs_options` VALUES (537,'wpvivid_saved_api_token','a:0:{}','no');
INSERT INTO `hs_options` VALUES (539,'wpvivid_last_msg','a:7:{s:2:"id";s:21:"wpvivid-66626b4fcf874";s:4:"type";s:4:"Cron";s:7:"options";a:23:{s:12:"backup_files";s:8:"files+db";s:5:"local";s:1:"0";s:6:"remote";s:1:"1";s:7:"ismerge";s:1:"1";s:4:"lock";s:1:"0";s:4:"type";s:4:"Cron";s:6:"action";s:6:"backup";s:10:"save_local";b:0;s:13:"backup_prefix";s:11:"hs.vicq.org";s:11:"file_prefix";s:50:"hs.vicq.org_wpvivid-66626b4fcf874_2024-06-07-04-07";s:13:"log_file_name";s:28:"wpvivid-66626b4fcf874_backup";s:13:"log_file_path";s:94:"/home/vicqorgvmv/hs/wp-content/wpvividbackups/wpvivid_log/wpvivid-66626b4fcf874_backup_log.txt";s:6:"prefix";s:50:"hs.vicq.org_wpvivid-66626b4fcf874_2024-06-07-04-07";s:3:"dir";s:45:"/home/vicqorgvmv/hs/wp-content/wpvividbackups";s:10:"backup_dir";s:14:"wpvividbackups";s:14:"exclude-tables";a:6:{i:0;s:14:"hs_wpvivid_log";i:1;s:28:"hs_wpvivid_increment_big_ids";i:2;s:18:"hs_wpvivid_options";i:3;s:22:"hs_wpvivid_record_task";i:4;s:19:"hs_wpvivid_merge_db";i:5;s:20:"hs_wpvivid_merge_ids";}s:14:"include-tables";a:0:{}s:13:"exclude_files";a:9:{i:0;s:71:"#^\\/home\\/vicqorgvmv\\/hs\\/wp\\-content\\/plugins\\/wpvivid\\-backuprestore#";i:1;s:59:"#^\\/home\\/vicqorgvmv\\/hs\\/wp\\-content\\/plugins\\/wp\\-cerber#";i:2;s:51:"#^\\/home\\/vicqorgvmv\\/hs\\/wp\\-content\\/plugins\\/\\.#";i:3;s:69:"#^\\/home\\/vicqorgvmv\\/hs\\/wp\\-content\\/plugins\\/wpvivid\\-backup\\-pro#";i:4;s:65:"#^\\/home\\/vicqorgvmv\\/hs\\/wp\\-content\\/plugins\\/wpvividdashboard#";i:5;s:47:"#^\\/home\\/vicqorgvmv\\/hs\\/wp\\-content\\/upgrade#";i:6;s:55:"#^\\/home\\/vicqorgvmv\\/hs\\/wp\\-content\\/wpvivid_uploads#";i:7;s:47:"#^\\/home\\/vicqorgvmv\\/hs\\/wp\\-content\\/wpvivid#";i:8;s:54:"#^\\/home\\/vicqorgvmv\\/hs\\/wp\\-content\\/wpvividbackups#";}s:13:"include_files";a:2:{i:0;s:36:"#^\\/home\\/vicqorgvmv\\/hs\\/wp\\-admin#";i:1;s:39:"#^\\/home\\/vicqorgvmv\\/hs\\/wp\\-includes#";}s:15:"include_plugins";a:0:{}s:14:"include_themes";a:0:{}s:14:"backup_options";a:1:{s:8:"compress";a:1:{s:13:"compress_type";s:3:"zip";}}s:14:"remote_options";a:1:{s:28:"wpvivid-remote-64d7698e5fbc0";a:9:{s:7:"passive";s:1:"1";s:4:"name";s:6:"ovh-hs";s:6:"server";s:12:"ftp.vicq.org";s:8:"username";s:10:"vicqorgvmv";s:4:"path";s:21:"/backup/wordpress/hs/";s:8:"password";s:16:"RnRwb3ZoMTcxNg==";s:4:"type";s:3:"ftp";s:4:"host";s:12:"ftp.vicq.org";s:10:"is_encrypt";i:1;}}}s:6:"status";a:7:{s:15:"task_start_time";i:1717726031;s:13:"task_end_time";i:1717726031;s:10:"start_time";i:1717726031;s:8:"run_time";i:1717726031;s:7:"timeout";i:1717726031;s:3:"str";s:5:"ready";s:12:"resume_count";i:0;}s:7:"setting";a:12:{s:17:"db_connect_method";s:4:"wpdb";s:12:"memory_limit";s:4:"256M";s:18:"max_execution_time";i:300;s:23:"compress_file_use_cache";b:0;s:19:"compress_file_count";i:500;s:13:"max_file_size";i:200;s:17:"max_sql_file_size";i:200;s:17:"exclude_file_size";i:0;s:16:"max_resume_count";i:6;s:10:"zip_method";s:10:"ziparchive";s:8:"is_merge";b:1;s:10:"save_local";b:0;}s:4:"data";a:3:{s:5:"doing";s:6:"backup";s:6:"backup";a:3:{s:5:"doing";s:0:"";s:8:"progress";i:0;s:7:"sub_job";a:0:{}}s:6:"upload";a:5:{s:5:"doing";s:0:"";s:8:"finished";i:0;s:8:"progress";i:0;s:8:"job_data";a:0:{}s:7:"sub_job";a:0:{}}}s:4:"jobs";a:7:{i:0;a:5:{s:11:"backup_type";s:9:"backup_db";s:8:"finished";i:0;s:8:"progress";i:0;s:10:"file_index";i:1;s:16:"mysql_file_index";i:1;}i:1;a:5:{s:11:"backup_type";s:13:"backup_themes";s:8:"finished";i:0;s:8:"progress";i:0;s:10:"file_index";i:1;s:5:"index";i:0;}i:2;a:5:{s:11:"backup_type";s:13:"backup_plugin";s:8:"finished";i:0;s:8:"progress";i:0;s:10:"file_index";i:1;s:5:"index";i:0;}i:3;a:5:{s:11:"backup_type";s:14:"backup_uploads";s:8:"finished";i:0;s:8:"progress";i:0;s:10:"file_index";i:1;s:5:"index";i:0;}i:4;a:5:{s:11:"backup_type";s:14:"backup_content";s:8:"finished";i:0;s:8:"progress";i:0;s:10:"file_index";i:1;s:5:"index";i:0;}i:5;a:5:{s:11:"backup_type";s:11:"backup_core";s:8:"finished";i:0;s:8:"progress";i:0;s:10:"file_index";i:1;s:5:"index";i:0;}i:6;a:6:{s:11:"backup_type";s:12:"backup_merge";s:8:"finished";i:0;s:8:"progress";i:0;s:10:"file_index";i:1;s:10:"child_file";a:0:{}s:5:"index";i:0;}}}','no');
INSERT INTO `hs_options` VALUES (540,'wpvivid_user_history','a:1:{s:15:"remote_selected";a:1:{i:0;s:28:"wpvivid-remote-64d7698e5fbc0";}}','no');
INSERT INTO `hs_options` VALUES (541,'wpvivid_backup_list','a:2:{s:21:"wpvivid-665fab75c5206";a:11:{s:4:"type";s:4:"Cron";s:11:"create_time";i:1717545845;s:13:"manual_delete";i:0;s:5:"local";a:1:{s:4:"path";s:14:"wpvividbackups";}s:8:"compress";a:1:{s:13:"compress_type";s:3:"zip";}s:10:"save_local";b:0;s:13:"backup_prefix";s:11:"hs.vicq.org";s:3:"log";s:94:"/home/vicqorgvmv/hs/wp-content/wpvividbackups/wpvivid_log/wpvivid-665fab75c5206_backup_log.txt";s:6:"backup";a:2:{s:6:"result";s:7:"success";s:5:"files";a:1:{i:0;a:2:{s:9:"file_name";s:65:"hs.vicq.org_wpvivid-665fab75c5206_2024-06-05-02-04_backup_all.zip";s:4:"size";i:70190342;}}}s:6:"remote";a:1:{s:28:"wpvivid-remote-64d7698e5fbc0";a:9:{s:7:"passive";s:1:"1";s:4:"name";s:6:"ovh-hs";s:6:"server";s:12:"ftp.vicq.org";s:8:"username";s:10:"vicqorgvmv";s:4:"path";s:21:"/backup/wordpress/hs/";s:8:"password";s:16:"RnRwb3ZoMTcxNg==";s:4:"type";s:3:"ftp";s:4:"host";s:12:"ftp.vicq.org";s:10:"is_encrypt";i:1;}}s:4:"lock";s:1:"0";}s:21:"wpvivid-66610120ebaa0";a:11:{s:4:"type";s:4:"Cron";s:11:"create_time";i:1717633313;s:13:"manual_delete";i:0;s:5:"local";a:1:{s:4:"path";s:14:"wpvividbackups";}s:8:"compress";a:1:{s:13:"compress_type";s:3:"zip";}s:10:"save_local";b:0;s:13:"backup_prefix";s:11:"hs.vicq.org";s:3:"log";s:94:"/home/vicqorgvmv/hs/wp-content/wpvividbackups/wpvivid_log/wpvivid-66610120ebaa0_backup_log.txt";s:6:"backup";a:2:{s:6:"result";s:7:"success";s:5:"files";a:1:{i:0;a:2:{s:9:"file_name";s:65:"hs.vicq.org_wpvivid-66610120ebaa0_2024-06-06-02-21_backup_all.zip";s:4:"size";i:70180102;}}}s:6:"remote";a:1:{s:28:"wpvivid-remote-64d7698e5fbc0";a:9:{s:7:"passive";s:1:"1";s:4:"name";s:6:"ovh-hs";s:6:"server";s:12:"ftp.vicq.org";s:8:"username";s:10:"vicqorgvmv";s:4:"path";s:21:"/backup/wordpress/hs/";s:8:"password";s:16:"RnRwb3ZoMTcxNg==";s:4:"type";s:3:"ftp";s:4:"host";s:12:"ftp.vicq.org";s:10:"is_encrypt";i:1;}}s:4:"lock";s:1:"0";}}','no');
INSERT INTO `hs_options` VALUES (542,'wpvivid_need_review','show','no');
INSERT INTO `hs_options` VALUES (543,'cron_backup_count','264','no');
INSERT INTO `hs_options` VALUES (544,'wpvivid_review_msg','Cheers! The schedule feature of WPvivid Backup plugin seems to be running well. If you found WPvivid Backup plugin helpful, a 5-star rating will motivate us to keep improving the plugin quality.','no');
INSERT INTO `hs_options` VALUES (568,'wpvivid_backup_success_count','271','no');
INSERT INTO `hs_options` VALUES (569,'wpvivid_backup_reports','a:196:{s:21:"wpvivid-64d769fcd936f";a:3:{s:7:"task_id";s:21:"wpvivid-64d769fcd936f";s:11:"backup_time";i:1691838973;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-64d76addea6bf";a:3:{s:7:"task_id";s:21:"wpvivid-64d76addea6bf";s:11:"backup_time";i:1691839198;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-64d77d8407862";a:3:{s:7:"task_id";s:21:"wpvivid-64d77d8407862";s:11:"backup_time";i:1691843972;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-64d77e78f3189";a:3:{s:7:"task_id";s:21:"wpvivid-64d77e78f3189";s:11:"backup_time";i:1691844217;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-64d77f9ccb3cc";a:3:{s:7:"task_id";s:21:"wpvivid-64d77f9ccb3cc";s:11:"backup_time";i:1691844509;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-64d7805a4e6b3";a:3:{s:7:"task_id";s:21:"wpvivid-64d7805a4e6b3";s:11:"backup_time";i:1691844698;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-64d7877ca93ca";a:3:{s:7:"task_id";s:21:"wpvivid-64d7877ca93ca";s:11:"backup_time";i:1691846525;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-64d82e21acafa";a:3:{s:7:"task_id";s:21:"wpvivid-64d82e21acafa";s:11:"backup_time";i:1691889185;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-64d9da45474d5";a:3:{s:7:"task_id";s:21:"wpvivid-64d9da45474d5";s:11:"backup_time";i:1691998789;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-64db8e2a05815";a:3:{s:7:"task_id";s:21:"wpvivid-64db8e2a05815";s:11:"backup_time";i:1692110378;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-64dcb222a20d5";a:3:{s:7:"task_id";s:21:"wpvivid-64dcb222a20d5";s:11:"backup_time";i:1692185122;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-64ddc9eecaf47";a:3:{s:7:"task_id";s:21:"wpvivid-64ddc9eecaf47";s:11:"backup_time";i:1692256750;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-64debba551f86";a:3:{s:7:"task_id";s:21:"wpvivid-64debba551f86";s:11:"backup_time";i:1692318629;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-64e00f6f3826b";a:3:{s:7:"task_id";s:21:"wpvivid-64e00f6f3826b";s:11:"backup_time";i:1692405615;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-64e22a52c8e00";a:3:{s:7:"task_id";s:21:"wpvivid-64e22a52c8e00";s:11:"backup_time";i:1692543570;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-64e2f6a30f4cd";a:3:{s:7:"task_id";s:21:"wpvivid-64e2f6a30f4cd";s:11:"backup_time";i:1692595875;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-64e57438f2529";a:3:{s:7:"task_id";s:21:"wpvivid-64e57438f2529";s:11:"backup_time";i:1692759097;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-64e7256b82c02";a:3:{s:7:"task_id";s:21:"wpvivid-64e7256b82c02";s:11:"backup_time";i:1692869995;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-64e807b708cbe";a:3:{s:7:"task_id";s:21:"wpvivid-64e807b708cbe";s:11:"backup_time";i:1692927927;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-64e9ed6220c50";a:3:{s:7:"task_id";s:21:"wpvivid-64e9ed6220c50";s:11:"backup_time";i:1693052258;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-64eb06a7c5ccb";a:3:{s:7:"task_id";s:21:"wpvivid-64eb06a7c5ccb";s:11:"backup_time";i:1693124263;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-64ebfa167ca56";a:3:{s:7:"task_id";s:21:"wpvivid-64ebfa167ca56";s:11:"backup_time";i:1693186582;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-64ed3e0deb390";a:3:{s:7:"task_id";s:21:"wpvivid-64ed3e0deb390";s:11:"backup_time";i:1693269518;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-64ee90aabf05c";a:3:{s:7:"task_id";s:21:"wpvivid-64ee90aabf05c";s:11:"backup_time";i:1693356202;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-64f096a740c38";a:3:{s:7:"task_id";s:21:"wpvivid-64f096a740c38";s:11:"backup_time";i:1693488807;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-64f1e0887a1e3";a:3:{s:7:"task_id";s:21:"wpvivid-64f1e0887a1e3";s:11:"backup_time";i:1693573256;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-64f2f6a15495b";a:3:{s:7:"task_id";s:21:"wpvivid-64f2f6a15495b";s:11:"backup_time";i:1693644449;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-64f48b702fa04";a:3:{s:7:"task_id";s:21:"wpvivid-64f48b702fa04";s:11:"backup_time";i:1693748080;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-64f57755e3f48";a:3:{s:7:"task_id";s:21:"wpvivid-64f57755e3f48";s:11:"backup_time";i:1693808470;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-64f6f61942de2";a:3:{s:7:"task_id";s:21:"wpvivid-64f6f61942de2";s:11:"backup_time";i:1693906457;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-64f90279479e1";a:3:{s:7:"task_id";s:21:"wpvivid-64f90279479e1";s:11:"backup_time";i:1694040697;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-64f9526e24897";a:3:{s:7:"task_id";s:21:"wpvivid-64f9526e24897";s:11:"backup_time";i:1694061166;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-64faa3b940cfa";a:3:{s:7:"task_id";s:21:"wpvivid-64faa3b940cfa";s:11:"backup_time";i:1694147513;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-64fdc4f27edd1";a:3:{s:7:"task_id";s:21:"wpvivid-64fdc4f27edd1";s:11:"backup_time";i:1694352626;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-6500ea812248a";a:3:{s:7:"task_id";s:21:"wpvivid-6500ea812248a";s:11:"backup_time";i:1694558849;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-6501984aa511b";a:3:{s:7:"task_id";s:21:"wpvivid-6501984aa511b";s:11:"backup_time";i:1694603338;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-6505c068721f9";a:3:{s:7:"task_id";s:21:"wpvivid-6505c068721f9";s:11:"backup_time";i:1694875752;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-650731fb918ae";a:3:{s:7:"task_id";s:21:"wpvivid-650731fb918ae";s:11:"backup_time";i:1694970363;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-6508f74bc42d3";a:3:{s:7:"task_id";s:21:"wpvivid-6508f74bc42d3";s:11:"backup_time";i:1695086411;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-650bbca198167";a:3:{s:7:"task_id";s:21:"wpvivid-650bbca198167";s:11:"backup_time";i:1695268001;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-650d2bd7d29ff";a:3:{s:7:"task_id";s:21:"wpvivid-650d2bd7d29ff";s:11:"backup_time";i:1695362007;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-650e9061e29fe";a:3:{s:7:"task_id";s:21:"wpvivid-650e9061e29fe";s:11:"backup_time";i:1695453282;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65104a1481836";a:3:{s:7:"task_id";s:21:"wpvivid-65104a1481836";s:11:"backup_time";i:1695566356;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65110aaf04c0d";a:3:{s:7:"task_id";s:21:"wpvivid-65110aaf04c0d";s:11:"backup_time";i:1695615663;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65143aa989e6d";a:3:{s:7:"task_id";s:21:"wpvivid-65143aa989e6d";s:11:"backup_time";i:1695824553;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65154c393cdaa";a:3:{s:7:"task_id";s:21:"wpvivid-65154c393cdaa";s:11:"backup_time";i:1695894585;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-6516138c5f426";a:3:{s:7:"task_id";s:21:"wpvivid-6516138c5f426";s:11:"backup_time";i:1695945612;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65182361ec937";a:3:{s:7:"task_id";s:21:"wpvivid-65182361ec937";s:11:"backup_time";i:1696080738;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-6518b6a6df01c";a:3:{s:7:"task_id";s:21:"wpvivid-6518b6a6df01c";s:11:"backup_time";i:1696118438;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-651a6c1e61b44";a:3:{s:7:"task_id";s:21:"wpvivid-651a6c1e61b44";s:11:"backup_time";i:1696230430;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-651b684609ee0";a:3:{s:7:"task_id";s:21:"wpvivid-651b684609ee0";s:11:"backup_time";i:1696294982;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-651cae3016cce";a:3:{s:7:"task_id";s:21:"wpvivid-651cae3016cce";s:11:"backup_time";i:1696378416;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-651e9e8303374";a:3:{s:7:"task_id";s:21:"wpvivid-651e9e8303374";s:11:"backup_time";i:1696505475;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-651f74a668371";a:3:{s:7:"task_id";s:21:"wpvivid-651f74a668371";s:11:"backup_time";i:1696560294;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-6520ae9352713";a:3:{s:7:"task_id";s:21:"wpvivid-6520ae9352713";s:11:"backup_time";i:1696640659;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-652200d2bd90e";a:3:{s:7:"task_id";s:21:"wpvivid-652200d2bd90e";s:11:"backup_time";i:1696727250;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65234e8cf3dd7";a:3:{s:7:"task_id";s:21:"wpvivid-65234e8cf3dd7";s:11:"backup_time";i:1696812685;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-6524a395470ca";a:3:{s:7:"task_id";s:21:"wpvivid-6524a395470ca";s:11:"backup_time";i:1696899989;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-6527febe47fcf";a:3:{s:7:"task_id";s:21:"wpvivid-6527febe47fcf";s:11:"backup_time";i:1697119934;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65289dfa8fe52";a:3:{s:7:"task_id";s:21:"wpvivid-65289dfa8fe52";s:11:"backup_time";i:1697160698;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-6529db39544b9";a:3:{s:7:"task_id";s:21:"wpvivid-6529db39544b9";s:11:"backup_time";i:1697241913;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-652b3ddbc98cd";a:3:{s:7:"task_id";s:21:"wpvivid-652b3ddbc98cd";s:11:"backup_time";i:1697332699;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-652c883cdeed4";a:3:{s:7:"task_id";s:21:"wpvivid-652c883cdeed4";s:11:"backup_time";i:1697417276;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-652dd83e3d920";a:3:{s:7:"task_id";s:21:"wpvivid-652dd83e3d920";s:11:"backup_time";i:1697503294;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-6530054936226";a:3:{s:7:"task_id";s:21:"wpvivid-6530054936226";s:11:"backup_time";i:1697645897;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-653072f93945f";a:3:{s:7:"task_id";s:21:"wpvivid-653072f93945f";s:11:"backup_time";i:1697673977;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-6531ceeb7ee56";a:3:{s:7:"task_id";s:21:"wpvivid-6531ceeb7ee56";s:11:"backup_time";i:1697763051;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-6533fb4f1e618";a:3:{s:7:"task_id";s:21:"wpvivid-6533fb4f1e618";s:11:"backup_time";i:1697905487;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-6535fe5177368";a:3:{s:7:"task_id";s:21:"wpvivid-6535fe5177368";s:11:"backup_time";i:1698037329;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65371bae67e53";a:3:{s:7:"task_id";s:21:"wpvivid-65371bae67e53";s:11:"backup_time";i:1698110382;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-653a0834cf104";a:3:{s:7:"task_id";s:21:"wpvivid-653a0834cf104";s:11:"backup_time";i:1698302004;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-653b0d35d1c81";a:3:{s:7:"task_id";s:21:"wpvivid-653b0d35d1c81";s:11:"backup_time";i:1698368821;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-653f67ada5a1c";a:3:{s:7:"task_id";s:21:"wpvivid-653f67ada5a1c";s:11:"backup_time";i:1698654125;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-654077d08827a";a:3:{s:7:"task_id";s:21:"wpvivid-654077d08827a";s:11:"backup_time";i:1698723792;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-6541afcf83aab";a:3:{s:7:"task_id";s:21:"wpvivid-6541afcf83aab";s:11:"backup_time";i:1698803663;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-6542ebe636a54";a:3:{s:7:"task_id";s:21:"wpvivid-6542ebe636a54";s:11:"backup_time";i:1698884582;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-6544fa285aba2";a:3:{s:7:"task_id";s:21:"wpvivid-6544fa285aba2";s:11:"backup_time";i:1699019304;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-6545d642df6c2";a:3:{s:7:"task_id";s:21:"wpvivid-6545d642df6c2";s:11:"backup_time";i:1699075650;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65479c2c63995";a:3:{s:7:"task_id";s:21:"wpvivid-65479c2c63995";s:11:"backup_time";i:1699191852;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65487b9a5a8a6";a:3:{s:7:"task_id";s:21:"wpvivid-65487b9a5a8a6";s:11:"backup_time";i:1699249050;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-6549f29e85808";a:3:{s:7:"task_id";s:21:"wpvivid-6549f29e85808";s:11:"backup_time";i:1699345054;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-654ae5779e141";a:3:{s:7:"task_id";s:21:"wpvivid-654ae5779e141";s:11:"backup_time";i:1699407223;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-654c26635912f";a:3:{s:7:"task_id";s:21:"wpvivid-654c26635912f";s:11:"backup_time";i:1699489379;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-654da2609c63a";a:3:{s:7:"task_id";s:21:"wpvivid-654da2609c63a";s:11:"backup_time";i:1699586656;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-654f03eb41844";a:3:{s:7:"task_id";s:21:"wpvivid-654f03eb41844";s:11:"backup_time";i:1699677163;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-655120c376a80";a:3:{s:7:"task_id";s:21:"wpvivid-655120c376a80";s:11:"backup_time";i:1699815619;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-6551c4578a602";a:3:{s:7:"task_id";s:21:"wpvivid-6551c4578a602";s:11:"backup_time";i:1699857495;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-6552f05e8df1c";a:3:{s:7:"task_id";s:21:"wpvivid-6552f05e8df1c";s:11:"backup_time";i:1699934302;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-6556cded09b4a";a:3:{s:7:"task_id";s:21:"wpvivid-6556cded09b4a";s:11:"backup_time";i:1700187629;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65583ca4b1a02";a:3:{s:7:"task_id";s:21:"wpvivid-65583ca4b1a02";s:11:"backup_time";i:1700281508;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-6559e5c452090";a:3:{s:7:"task_id";s:21:"wpvivid-6559e5c452090";s:11:"backup_time";i:1700390340;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-655ac2d43cc92";a:3:{s:7:"task_id";s:21:"wpvivid-655ac2d43cc92";s:11:"backup_time";i:1700446932;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-655c47a7be830";a:3:{s:7:"task_id";s:21:"wpvivid-655c47a7be830";s:11:"backup_time";i:1700546471;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-655e58157e439";a:3:{s:7:"task_id";s:21:"wpvivid-655e58157e439";s:11:"backup_time";i:1700681749;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-655ea4a167ad5";a:3:{s:7:"task_id";s:21:"wpvivid-655ea4a167ad5";s:11:"backup_time";i:1700701345;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65601f341cc77";a:3:{s:7:"task_id";s:21:"wpvivid-65601f341cc77";s:11:"backup_time";i:1700798260;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65652285c8ce5";a:3:{s:7:"task_id";s:21:"wpvivid-65652285c8ce5";s:11:"backup_time";i:1701126789;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-656581325d225";a:3:{s:7:"task_id";s:21:"wpvivid-656581325d225";s:11:"backup_time";i:1701151026;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-6566ec077525f";a:3:{s:7:"task_id";s:21:"wpvivid-6566ec077525f";s:11:"backup_time";i:1701243911;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-6568e5e654273";a:3:{s:7:"task_id";s:21:"wpvivid-6568e5e654273";s:11:"backup_time";i:1701373414;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-656a00848e33d";a:3:{s:7:"task_id";s:21:"wpvivid-656a00848e33d";s:11:"backup_time";i:1701445764;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-656af0d527bdf";a:3:{s:7:"task_id";s:21:"wpvivid-656af0d527bdf";s:11:"backup_time";i:1701507285;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-656c59111c8ff";a:3:{s:7:"task_id";s:21:"wpvivid-656c59111c8ff";s:11:"backup_time";i:1701599505;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-656f0fa65304e";a:3:{s:7:"task_id";s:21:"wpvivid-656f0fa65304e";s:11:"backup_time";i:1701777318;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-656fbb51ec95e";a:3:{s:7:"task_id";s:21:"wpvivid-656fbb51ec95e";s:11:"backup_time";i:1701821266;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65717a52ae57c";a:3:{s:7:"task_id";s:21:"wpvivid-65717a52ae57c";s:11:"backup_time";i:1701935698;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-6574757492c70";a:3:{s:7:"task_id";s:21:"wpvivid-6574757492c70";s:11:"backup_time";i:1702131060;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-6575d817cc0fa";a:3:{s:7:"task_id";s:21:"wpvivid-6575d817cc0fa";s:11:"backup_time";i:1702221847;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-657660be5c009";a:3:{s:7:"task_id";s:21:"wpvivid-657660be5c009";s:11:"backup_time";i:1702256830;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-6577d4444564a";a:3:{s:7:"task_id";s:21:"wpvivid-6577d4444564a";s:11:"backup_time";i:1702351940;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-6578f58b71761";a:3:{s:7:"task_id";s:21:"wpvivid-6578f58b71761";s:11:"backup_time";i:1702425995;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-657a9e5e57099";a:3:{s:7:"task_id";s:21:"wpvivid-657a9e5e57099";s:11:"backup_time";i:1702534750;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-657ba493c3d2d";a:3:{s:7:"task_id";s:21:"wpvivid-657ba493c3d2d";s:11:"backup_time";i:1702601875;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-657ce93e71454";a:3:{s:7:"task_id";s:21:"wpvivid-657ce93e71454";s:11:"backup_time";i:1702684990;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-657e3a11f0771";a:3:{s:7:"task_id";s:21:"wpvivid-657e3a11f0771";s:11:"backup_time";i:1702771218;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-657f9046962da";a:3:{s:7:"task_id";s:21:"wpvivid-657f9046962da";s:11:"backup_time";i:1702858822;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65823fef499f9";a:3:{s:7:"task_id";s:21:"wpvivid-65823fef499f9";s:11:"backup_time";i:1703034863;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-658385e65adbd";a:3:{s:7:"task_id";s:21:"wpvivid-658385e65adbd";s:11:"backup_time";i:1703118310;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-658516ce9384a";a:3:{s:7:"task_id";s:21:"wpvivid-658516ce9384a";s:11:"backup_time";i:1703220942;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-658624666c8bf";a:3:{s:7:"task_id";s:21:"wpvivid-658624666c8bf";s:11:"backup_time";i:1703289958;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-658777fe4adee";a:3:{s:7:"task_id";s:21:"wpvivid-658777fe4adee";s:11:"backup_time";i:1703376894;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65892990b2ae7";a:3:{s:7:"task_id";s:21:"wpvivid-65892990b2ae7";s:11:"backup_time";i:1703487888;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-658c3605da0d6";a:3:{s:7:"task_id";s:21:"wpvivid-658c3605da0d6";s:11:"backup_time";i:1703687685;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-658d1f3d38cfa";a:3:{s:7:"task_id";s:21:"wpvivid-658d1f3d38cfa";s:11:"backup_time";i:1703747389;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-658e6441bfecf";a:3:{s:7:"task_id";s:21:"wpvivid-658e6441bfecf";s:11:"backup_time";i:1703830593;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-6591911d4d519";a:3:{s:7:"task_id";s:21:"wpvivid-6591911d4d519";s:11:"backup_time";i:1704038685;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-659235d545cef";a:3:{s:7:"task_id";s:21:"wpvivid-659235d545cef";s:11:"backup_time";i:1704080853;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65938a0c8f44b";a:3:{s:7:"task_id";s:21:"wpvivid-65938a0c8f44b";s:11:"backup_time";i:1704167948;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-6594a447664e6";a:3:{s:7:"task_id";s:21:"wpvivid-6594a447664e6";s:11:"backup_time";i:1704240199;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-6596312a61aac";a:3:{s:7:"task_id";s:21:"wpvivid-6596312a61aac";s:11:"backup_time";i:1704341802;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65974cbbd2d8c";a:3:{s:7:"task_id";s:21:"wpvivid-65974cbbd2d8c";s:11:"backup_time";i:1704414395;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-6598994ce059e";a:3:{s:7:"task_id";s:21:"wpvivid-6598994ce059e";s:11:"backup_time";i:1704499533;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-6599ee0ac1a6e";a:3:{s:7:"task_id";s:21:"wpvivid-6599ee0ac1a6e";s:11:"backup_time";i:1704586762;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-659bc4431c46d";a:3:{s:7:"task_id";s:21:"wpvivid-659bc4431c46d";s:11:"backup_time";i:1704707139;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-659d5459bbafc";a:3:{s:7:"task_id";s:21:"wpvivid-659d5459bbafc";s:11:"backup_time";i:1704809561;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-659e226f72176";a:3:{s:7:"task_id";s:21:"wpvivid-659e226f72176";s:11:"backup_time";i:1704862319;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-659f4c4fe118d";a:3:{s:7:"task_id";s:21:"wpvivid-659f4c4fe118d";s:11:"backup_time";i:1704938575;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65a0862ac6888";a:3:{s:7:"task_id";s:21:"wpvivid-65a0862ac6888";s:11:"backup_time";i:1705018922;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65a1e437eb51d";a:3:{s:7:"task_id";s:21:"wpvivid-65a1e437eb51d";s:11:"backup_time";i:1705108536;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65a328ba9996e";a:3:{s:7:"task_id";s:21:"wpvivid-65a328ba9996e";s:11:"backup_time";i:1705191610;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65a47baa43c24";a:3:{s:7:"task_id";s:21:"wpvivid-65a47baa43c24";s:11:"backup_time";i:1705278378;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65aaa91a59277";a:3:{s:7:"task_id";s:21:"wpvivid-65aaa91a59277";s:11:"backup_time";i:1705683226;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65ab3fbee5cb4";a:3:{s:7:"task_id";s:21:"wpvivid-65ab3fbee5cb4";s:11:"backup_time";i:1705721791;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65ac5f61b0c6a";a:3:{s:7:"task_id";s:21:"wpvivid-65ac5f61b0c6a";s:11:"backup_time";i:1705795425;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65adb25e35933";a:3:{s:7:"task_id";s:21:"wpvivid-65adb25e35933";s:11:"backup_time";i:1705882206;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65af02b594747";a:3:{s:7:"task_id";s:21:"wpvivid-65af02b594747";s:11:"backup_time";i:1705968309;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65b0da2ee82e2";a:3:{s:7:"task_id";s:21:"wpvivid-65b0da2ee82e2";s:11:"backup_time";i:1706089007;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65b1c20885ded";a:3:{s:7:"task_id";s:21:"wpvivid-65b1c20885ded";s:11:"backup_time";i:1706148360;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65b3181c6c4a6";a:3:{s:7:"task_id";s:21:"wpvivid-65b3181c6c4a6";s:11:"backup_time";i:1706235932;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65b44946d75b9";a:3:{s:7:"task_id";s:21:"wpvivid-65b44946d75b9";s:11:"backup_time";i:1706314055;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65b633a3dc67b";a:3:{s:7:"task_id";s:21:"wpvivid-65b633a3dc67b";s:11:"backup_time";i:1706439587;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65b71e279d54d";a:3:{s:7:"task_id";s:21:"wpvivid-65b71e279d54d";s:11:"backup_time";i:1706499623;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65b852fdb5934";a:3:{s:7:"task_id";s:21:"wpvivid-65b852fdb5934";s:11:"backup_time";i:1706578685;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65ba7da8ecf61";a:3:{s:7:"task_id";s:21:"wpvivid-65ba7da8ecf61";s:11:"backup_time";i:1706720681;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65bb0c48f1361";a:3:{s:7:"task_id";s:21:"wpvivid-65bb0c48f1361";s:11:"backup_time";i:1706757193;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65bc351861500";a:3:{s:7:"task_id";s:21:"wpvivid-65bc351861500";s:11:"backup_time";i:1706833176;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65be137711da3";a:3:{s:7:"task_id";s:21:"wpvivid-65be137711da3";s:11:"backup_time";i:1706955639;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65bef8bec4094";a:3:{s:7:"task_id";s:21:"wpvivid-65bef8bec4094";s:11:"backup_time";i:1707014334;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65c119b07b729";a:3:{s:7:"task_id";s:21:"wpvivid-65c119b07b729";s:11:"backup_time";i:1707153840;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65c1e30fcd897";a:3:{s:7:"task_id";s:21:"wpvivid-65c1e30fcd897";s:11:"backup_time";i:1707205391;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65c35adb47f7e";a:3:{s:7:"task_id";s:21:"wpvivid-65c35adb47f7e";s:11:"backup_time";i:1707301595;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65c624febd037";a:3:{s:7:"task_id";s:21:"wpvivid-65c624febd037";s:11:"backup_time";i:1707484414;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65c817a992db6";a:3:{s:7:"task_id";s:21:"wpvivid-65c817a992db6";s:11:"backup_time";i:1707612073;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65c961fb6493c";a:3:{s:7:"task_id";s:21:"wpvivid-65c961fb6493c";s:11:"backup_time";i:1707696635;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65cab2323eca0";a:3:{s:7:"task_id";s:21:"wpvivid-65cab2323eca0";s:11:"backup_time";i:1707782706;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65cc285316e58";a:3:{s:7:"task_id";s:21:"wpvivid-65cc285316e58";s:11:"backup_time";i:1707878483;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65ce308dc7c11";a:3:{s:7:"task_id";s:21:"wpvivid-65ce308dc7c11";s:11:"backup_time";i:1708011661;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65ced8c8dfa03";a:3:{s:7:"task_id";s:21:"wpvivid-65ced8c8dfa03";s:11:"backup_time";i:1708054729;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65cff759a65bb";a:3:{s:7:"task_id";s:21:"wpvivid-65cff759a65bb";s:11:"backup_time";i:1708128089;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65d2208d5fc12";a:3:{s:7:"task_id";s:21:"wpvivid-65d2208d5fc12";s:11:"backup_time";i:1708269709;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65d39b935b0b5";a:3:{s:7:"task_id";s:21:"wpvivid-65d39b935b0b5";s:11:"backup_time";i:1708366739;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65d4ece133e1f";a:3:{s:7:"task_id";s:21:"wpvivid-65d4ece133e1f";s:11:"backup_time";i:1708453089;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65d63a6eb50ff";a:3:{s:7:"task_id";s:21:"wpvivid-65d63a6eb50ff";s:11:"backup_time";i:1708538478;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65d6c8f71fa11";a:3:{s:7:"task_id";s:21:"wpvivid-65d6c8f71fa11";s:11:"backup_time";i:1708574967;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65d7e21a5517d";a:3:{s:7:"task_id";s:21:"wpvivid-65d7e21a5517d";s:11:"backup_time";i:1708646938;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65da5203c339f";a:3:{s:7:"task_id";s:21:"wpvivid-65da5203c339f";s:11:"backup_time";i:1708806659;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65dadb3b32718";a:3:{s:7:"task_id";s:21:"wpvivid-65dadb3b32718";s:11:"backup_time";i:1708841787;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65dc10bf8ee1b";a:3:{s:7:"task_id";s:21:"wpvivid-65dc10bf8ee1b";s:11:"backup_time";i:1708921023;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65ddb9237ccd2";a:3:{s:7:"task_id";s:21:"wpvivid-65ddb9237ccd2";s:11:"backup_time";i:1709029667;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65dea05a74691";a:3:{s:7:"task_id";s:21:"wpvivid-65dea05a74691";s:11:"backup_time";i:1709088858;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65dfc9b7864d2";a:3:{s:7:"task_id";s:21:"wpvivid-65dfc9b7864d2";s:11:"backup_time";i:1709164983;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65e11c1510f74";a:3:{s:7:"task_id";s:21:"wpvivid-65e11c1510f74";s:11:"backup_time";i:1709251605;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65e37aa40dac6";a:3:{s:7:"task_id";s:21:"wpvivid-65e37aa40dac6";s:11:"backup_time";i:1709406884;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65e440dbf3824";a:3:{s:7:"task_id";s:21:"wpvivid-65e440dbf3824";s:11:"backup_time";i:1709457628;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65e5494631fdd";a:3:{s:7:"task_id";s:21:"wpvivid-65e5494631fdd";s:11:"backup_time";i:1709525318;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65e660b04f0bb";a:3:{s:7:"task_id";s:21:"wpvivid-65e660b04f0bb";s:11:"backup_time";i:1709596848;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65e7dac617849";a:3:{s:7:"task_id";s:21:"wpvivid-65e7dac617849";s:11:"backup_time";i:1709693638;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65e90d5f1d5aa";a:3:{s:7:"task_id";s:21:"wpvivid-65e90d5f1d5aa";s:11:"backup_time";i:1709772127;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65ea89be0cb4e";a:3:{s:7:"task_id";s:21:"wpvivid-65ea89be0cb4e";s:11:"backup_time";i:1709869502;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65ebbec3ea551";a:3:{s:7:"task_id";s:21:"wpvivid-65ebbec3ea551";s:11:"backup_time";i:1709948612;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65ee9cd956360";a:3:{s:7:"task_id";s:21:"wpvivid-65ee9cd956360";s:11:"backup_time";i:1710136537;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65efcd9405297";a:3:{s:7:"task_id";s:21:"wpvivid-65efcd9405297";s:11:"backup_time";i:1710214548;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65f1dfde72807";a:3:{s:7:"task_id";s:21:"wpvivid-65f1dfde72807";s:11:"backup_time";i:1710350302;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65f50a3d7de23";a:3:{s:7:"task_id";s:21:"wpvivid-65f50a3d7de23";s:11:"backup_time";i:1710557757;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65f66e9c7e777";a:3:{s:7:"task_id";s:21:"wpvivid-65f66e9c7e777";s:11:"backup_time";i:1710648988;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65f7ab4dc0bbf";a:3:{s:7:"task_id";s:21:"wpvivid-65f7ab4dc0bbf";s:11:"backup_time";i:1710730061;s:6:"status";s:9:"Succeeded";}}','yes');
INSERT INTO `hs_options` VALUES (572,'wpvivid_download_task_v2','a:0:{}','no');
INSERT INTO `hs_options` VALUES (861,'auto_update_plugins','a:3:{i:0;s:47:"wpvivid-backuprestore/wpvivid-backuprestore.php";i:1;s:25:"tablepress/tablepress.php";i:2;s:19:"akismet/akismet.php";}','no');
INSERT INTO `hs_options` VALUES (897,'https_migration_required','1','yes');
INSERT INTO `hs_options` VALUES (901,'auto_update_themes','a:3:{i:0;s:16:"agriculture-farm";i:1;s:12:"organic-farm";i:2;s:19:"agriculture-farming";}','no');
INSERT INTO `hs_options` VALUES (980,'_site_transient_timeout_g_url_details_response_ffb415b1b1599b5217be3519a8f9ab8e','1693149175','no');
INSERT INTO `hs_options` VALUES (1174,'_site_transient_timeout_g_url_details_response_71f8abaf9c44d4b1d33f4f9b8aeb3cc1','1694976861','no');
INSERT INTO `hs_options` VALUES (1922,'organic_farm_sticky_header','off','yes');
INSERT INTO `hs_options` VALUES (2205,'wp_attachment_pages_enabled','1','yes');
INSERT INTO `hs_options` VALUES (5877,'can_compress_scripts','0','yes');
INSERT INTO `hs_options` VALUES (5887,'_site_transient_wp_plugin_dependencies_plugin_data','a:0:{}','no');
INSERT INTO `hs_options` VALUES (5893,'frm_strp_options','O:8:"stdClass":2:{s:9:"test_mode";i:1;s:18:"processing_message";s:58:"Le traitement de ce paiement peut prendre plusieurs jours.";}','yes');
INSERT INTO `hs_options` VALUES (5894,'widget_frm_show_form','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `hs_options` VALUES (5895,'frm_options','O:11:"FrmSettings":40:{s:11:"option_name";s:11:"frm_options";s:4:"menu";N;s:7:"mu_menu";N;s:8:"use_html";N;s:10:"jquery_css";N;s:12:"accordion_js";N;s:9:"fade_form";N;s:7:"old_css";N;s:9:"admin_bar";N;s:11:"success_msg";N;s:9:"blank_msg";N;s:10:"unique_msg";N;s:11:"invalid_msg";N;s:10:"failed_msg";N;s:12:"submit_value";N;s:9:"login_msg";N;s:16:"admin_permission";N;s:8:"email_to";N;s:10:"load_style";N;s:12:"custom_style";N;s:14:"active_captcha";N;s:6:"pubkey";N;s:7:"privkey";N;s:7:"re_lang";N;s:7:"re_type";N;s:6:"re_msg";N;s:8:"re_multi";N;s:15:"hcaptcha_pubkey";N;s:16:"hcaptcha_privkey";N;s:16:"turnstile_pubkey";N;s:17:"turnstile_privkey";N;s:6:"no_ips";N;s:16:"custom_header_ip";N;s:12:"current_form";i:0;s:8:"tracking";N;s:14:"summary_emails";N;s:25:"summary_emails_recipients";N;s:13:"default_email";N;s:8:"currency";N;s:10:"custom_css";N;}','yes');
INSERT INTO `hs_options` VALUES (5898,'frm_inbox_cache','a:3:{s:7:"timeout";i:1715302095;s:5:"value";s:21:"{"response_code":403}";s:7:"version";s:5:"6.9.1";}','no');
INSERT INTO `hs_options` VALUES (5905,'frm_db_version','6.9.1-101','yes');
INSERT INTO `hs_options` VALUES (5906,'frm_last_style_update','591848','yes');
INSERT INTO `hs_options` VALUES (5907,'frm_honeypot_class','frm__663d1a7145329','yes');
INSERT INTO `hs_options` VALUES (5908,'frmpro_css','/* AVERTISSEMENT : Toutes modifications apportées à ce fichier seront perdues lorsque vos réglages de Formidable seront mis à jour. */\n.with_frm_style{--form-width:100%;--form-align:left;--direction:ltr;--fieldset:0px;--fieldset-color:#000000;--fieldset-padding:0 0 15px 0;--fieldset-bg-color:transparent;--title-size:40px;--title-color:#444444;--title-margin-top:10px;--title-margin-bottom:60px;--form-desc-size:14px;--form-desc-color:#666666;--form-desc-margin-top:10px;--form-desc-margin-bottom:25px;--form-desc-padding:0;--font-size:15px;--label-color:#3f4b5b;--weight:normal;--position:none;--align:left;--width:150px;--required-color:#B94A48;--required-weight:bold;--label-padding:0 0 3px 0;--description-font-size:12px;--description-color:#666666;--description-weight:normal;--description-style:normal;--description-align:left;--description-margin:0;--field-font-size:14px;--field-height:32px;--line-height:32px;--field-width:100%;--auto-width:100%;--field-pad:6px 10px;--field-margin:20px;--field-weight:normal;--text-color:#555555;--border-color:#BFC3C8;--field-border-width:1px;--field-border-style:solid;--bg-color:#ffffff;--bg-color-active:#ffffff;--border-color-active:#66afe9;--text-color-error:#444444;--bg-color-error:#ffffff;--border-color-error:#B94A48;--border-width-error:1px;--border-style-error:solid;--bg-color-disabled:#ffffff;--border-color-disabled:#E5E5E5;--text-color-disabled:#A1A1A1;--radio-align:block;--check-align:block;--check-font-size:13px;--check-label-color:#444444;--check-weight:normal;--section-font-size:18px;--section-color:#444444;--section-weight:bold;--section-pad:15px 0 3px 0;--section-mar-top:15px;--section-mar-bottom:30px;--section-bg-color:transparent;--section-border-color:#e8e8e8;--section-border-width:2px;--section-border-style:solid;--section-border-loc:-top;--collapse-pos:after;--repeat-icon-color:#ffffff;--submit-font-size:15px;--submit-width:auto;--submit-height:auto;--submit-bg-color:#579AF6;--submit-border-color:#579AF6;--submit-border-width:1px;--submit-text-color:#ffffff;--submit-weight:normal;--submit-border-radius:4px;--submit-margin:10px;--submit-padding:10px 20px;--submit-shadow-color:#eeeeee;--submit-hover-bg-color:#efefef;--submit-hover-color:#444444;--submit-hover-border-color:#cccccc;--submit-active-bg-color:#efefef;--submit-active-color:#444444;--submit-active-border-color:#cccccc;--border-radius:4px;--error-bg:#F2DEDE;--error-border:#EBCCD1;--error-text:#B94A48;--error-font-size:14px;--success-bg-color:#DFF0D8;--success-border-color:#D6E9C6;--success-text-color:#468847;--success-font-size:14px;--progress-bg-color:#eaeaea;--progress-active-color:#ffffff;--progress-active-bg-color:#579AF6;--progress-color:#3f4b5b;--progress-border-color:#E5E5E5;--progress-border-size:2px;--progress-size:24px;--box-shadow:0 1px 1px rgba(0, 0, 0, 0.075) inset;}.frm_hidden,.frm_add_form_row.frm_hidden,.frm_remove_form_row.frm_hidden,.with_frm_style .frm_button.frm_hidden{display:none;}.with_frm_style,.with_frm_style form,.with_frm_style .frm-show-form div.frm_description p{text-align:left;text-align:var(--form-align);}input:-webkit-autofill {-webkit-box-shadow: 0 0 0 30px white inset;}.with_frm_style .frm-show-form div.frm_description p{font-size:14px;font-size:var(--form-desc-size);color:#666666;color:var(--form-desc-color);margin-top:10px;margin-top:var(--form-desc-margin-top);margin-bottom:25px;margin-bottom:var(--form-desc-margin-bottom);padding:0;padding:var(--form-desc-padding);}form .frm__663d1a7145329 {overflow: hidden;width: 0;height: 0;position: absolute;}.with_frm_style fieldset{min-width:0;display: block; }.with_frm_style fieldset fieldset{border:none;margin:0;padding:0;background-color:transparent;}.with_frm_style .frm_form_fields > fieldset{border-width:0px;border-width:var(--fieldset);border-style:solid;border-color:#000000;border-color:var(--fieldset-color);margin:0;padding:0 0 15px 0;padding:var(--fieldset-padding);background-color:transparent;background-color:var(--fieldset-bg-color);}legend.frm_hidden{display:none !important;}.with_frm_style .frm_form_fields{opacity:1;transition: opacity 0.1s linear;}.with_frm_style .frm_doing_ajax{opacity:.5;}.frm_transparent{color:transparent;}.with_frm_style legend + h3,.with_frm_style h3.frm_form_title{font-size:40px;font-size:var(--title-size);color:#444444;color:var(--title-color);margin-top:10px;margin-top:var(--title-margin-top);margin-bottom:60px;margin-bottom:var(--title-margin-bottom);}.with_frm_style .frm_form_field.frm_html_container,.with_frm_style .frm_form_field .frm_show_it{color:#666666;color:var(--form-desc-color);}.with_frm_style .frm_form_field.frm_html_container{font-size:14px;font-size:var(--form-desc-size);}.with_frm_style .frm_form_field .frm_show_it{font-size:14px;font-size:var(--field-font-size);font-weight:normal;font-weight:var(--field-weight);}.with_frm_style .frm_required{color:#B94A48;color:var(--required-color);font-weight:bold;font-weight:var(--required-weight);}.with_frm_style input[type=text],.with_frm_style input[type=password],.with_frm_style input[type=email],.with_frm_style input[type=number],.with_frm_style input[type=url],.with_frm_style input[type=tel],.with_frm_style input[type=search],.with_frm_style select,.with_frm_style textarea,.with_frm_style .frm-card-element.StripeElement,.with_frm_style .chosen-container{font-family:var(--font);font-size:14px;font-size:var(--field-font-size);margin-bottom:0;}.with_frm_style textarea{vertical-align:top;height:auto;}.with_frm_style input[type=text],.with_frm_style input[type=password],.with_frm_style input[type=email],.with_frm_style input[type=number],.with_frm_style input[type=url],.with_frm_style input[type=tel],.with_frm_style input[type=phone],.with_frm_style input[type=search],.with_frm_style select,.with_frm_style textarea,.frm_form_fields_style,.with_frm_style .frm_scroll_box .frm_opt_container,.frm_form_fields_active_style,.frm_form_fields_error_style,.with_frm_style .frm-card-element.StripeElement,.with_frm_style .chosen-container-multi .chosen-choices,.with_frm_style .chosen-container-single .chosen-single,.with_frm_style .frm_slimselect.ss-main {color:#555555;color:var(--text-color);background-color:#ffffff;background-color:var(--bg-color);border-color:#BFC3C8;border-color:var(--border-color);border-width:1px;border-width:var(--field-border-width);border-style:solid;border-style:var(--field-border-style);border-radius:4px;border-radius:var(--border-radius);width:100%;width:var(--field-width);max-width:100%;font-size:14px;font-size:var(--field-font-size);padding:6px 10px;padding:var(--field-pad);box-sizing:border-box;outline:none;font-weight:normal;font-weight:var(--field-weight);box-shadow:var(--box-shadow);}.with_frm_style select option {color:#555555;color:var(--text-color);}.with_frm_style select option.frm-select-placeholder {color:#A1A1A1;color:var(--text-color-disabled);}.with_frm_style input[type=radio],.with_frm_style input[type=checkbox]{border-color:#BFC3C8;border-color:var(--border-color);box-shadow:var(--box-shadow);float: none;}.with_frm_style input[type=radio]:after,.with_frm_style input[type=checkbox]:after {display: none; }.with_frm_style input[type=text],.with_frm_style input[type=password],.with_frm_style input[type=email],.with_frm_style input[type=number],.with_frm_style input[type=url],.with_frm_style input[type=tel],.with_frm_style input[type=file],.with_frm_style input[type=search],.with_frm_style select,.with_frm_style .frm-card-element.StripeElement{min-height:32px;min-height:var(--field-height);line-height:1.3;}.with_frm_style select[multiple=multiple]{height:auto;}.input[type=file].frm_transparent:focus,.with_frm_style input[type=file]{background-color:transparent;border:none;outline:none;box-shadow:none;}.with_frm_style input[type=file]{color:#555555;color:var(--text-color);padding:0px;font-size:14px;font-size:var(--field-font-size);display:initial;}.with_frm_style input[type=file].frm_transparent{color:transparent;}.with_frm_style .wp-editor-wrap{width:100%;width:var(--field-width);max-width:100%;}.with_frm_style .wp-editor-container textarea{border:none;box-shadow:none !important;}.with_frm_style .mceIframeContainer{background-color:#ffffff;background-color:var(--bg-color);}.with_frm_style select{width:100%;width:var(--auto-width);max-width:100%;background-position-y: calc(50% + 3px);}.with_frm_style input[disabled],.with_frm_style select[disabled],.with_frm_style textarea[disabled],.with_frm_style input[readonly],.with_frm_style select[readonly],.with_frm_style textarea[readonly]{background-color:#ffffff;background-color:var(--bg-color-disabled);color:#A1A1A1;color:var(--text-color-disabled);border-color:#E5E5E5;border-color:var(--border-color-disabled);}.frm_preview_page:before{content:normal !important;}.frm_preview_page{padding:25px;}.with_frm_style .frm_primary_label{max-width:100%;font-size:15px;font-size:var(--font-size);color:#3f4b5b;color:var(--label-color);font-weight:normal;font-weight:var(--weight);text-align:left;text-align:var(--align);padding:0 0 3px 0;padding:var(--label-padding);margin:0;width:auto;display:block;}.with_frm_style .frm_top_container .frm_primary_label,.with_frm_style .frm_hidden_container .frm_primary_label,.with_frm_style .frm_pos_top{display:block;float:none;width:auto;}.with_frm_style .frm_inline_container .frm_primary_label{margin-right:10px;}.with_frm_style .frm_right_container .frm_primary_label,.with_frm_style .frm_pos_right{display:inline;float:right;margin-left:10px;}.with_frm_style .frm_pos_center {text-align: center;}.with_frm_style .frm_none_container .frm_primary_label,.with_frm_style .frm_pos_none,.frm_pos_none,.frm_none_container .frm_primary_label{display:none;}.with_frm_style .frm_section_heading.frm_hide_section{margin-top:0 !important;}.with_frm_style .frm_hidden_container .frm_primary_label,.with_frm_style .frm_pos_hidden,.frm_hidden_container .frm_primary_label{visibility:hidden;white-space:nowrap;}.frm_visible{opacity:1;}.with_frm_style .frm_inside_container {position: relative;padding-top: 16px;padding-top: calc(0.5 * var(--field-height));}.with_frm_style .frm_inside_container > input,.with_frm_style .frm_inside_container > select,.with_frm_style .frm_inside_container > textarea {display: block;}.with_frm_style .frm_inside_container > input::-moz-placeholder,.with_frm_style .frm_inside_container > textarea::-moz-placeholder {opacity: 0 !important;transition: opacity 0.3s ease-in;}.with_frm_style .frm_inside_container > input:-ms-input-placeholder,.with_frm_style .frm_inside_container > textarea:-ms-input-placeholder {opacity: 0;transition: opacity 0.3s ease-in;}.with_frm_style .frm_inside_container > input::placeholder,.with_frm_style .frm_inside_container > textarea::placeholder {opacity: 0;transition: opacity 0.3s ease-in;}.with_frm_style .frm_inside_container > label {transition: all 0.3s ease-in;position: absolute;top: 17px;top: calc(1px + .5 * var(--field-height));left: 3px;width: 100%;line-height: 1.3;text-overflow: ellipsis;overflow: hidden;white-space: nowrap;padding: 6px 10px;padding: var(--field-pad);font-size: 14px;font-size: var(--field-font-size);font-weight: normal;font-weight: var(--field-weight);-ms-pointer-events: none;pointer-events: none;}.with_frm_style.frm_style_lines-no-boxes .frm_inside_container > label {line-height: 1;}.with_frm_style .frm_inside_container.frm_label_float_top > label {top: 0;left: 0;padding: 0;font-size: 12px;font-size: calc(0.85 * var(--field-font-size));}.with_frm_style .frm_inside_container.frm_label_float_top > input::-moz-placeholder,.with_frm_style .frm_inside_container.frm_label_float_top > textarea::-moz-placeholder {opacity: 1 !important;transition: opacity 0.3s ease-in;}.with_frm_style .frm_inside_container.frm_label_float_top > input:-ms-input-placeholder,.with_frm_style .frm_inside_container.frm_label_float_top > textarea:-ms-input-placeholder {opacity: 1;transition: opacity 0.3s ease-in;}.with_frm_style .frm_inside_container.frm_label_float_top > input::placeholder,.with_frm_style .frm_inside_container.frm_label_float_top > textarea::placeholder {opacity: 1;transition: opacity 0.3s ease-in;}.with_frm_style .frm_description,.with_frm_style .frm_pro_max_limit_desc{clear:both;}.with_frm_style input[type=number][readonly]{-moz-appearance: textfield;}.with_frm_style select[multiple="multiple"]{height:auto;line-height:normal;}.with_frm_style .frm_catlevel_2,.with_frm_style .frm_catlevel_3,.with_frm_style .frm_catlevel_4,.with_frm_style .frm_catlevel_5{margin-left:18px;}.with_frm_style .wp-editor-container{border:1px solid #e5e5e5;}.with_frm_style .quicktags-toolbar input{font-size:12px !important;}.with_frm_style .wp-editor-container textarea{border:none;}.with_frm_style .auto_width #loginform input,.with_frm_style .auto_width input,.with_frm_style input.auto_width,.with_frm_style select.auto_width,.with_frm_style textarea.auto_width{width:auto;}.with_frm_style .frm_repeat_buttons{white-space:nowrap;}.with_frm_style .frm_button{text-decoration:none !important;;border:1px solid #eee;display:inline-block;padding:10px 20px;padding:var(--submit-padding);border-radius:4px;border-radius:var(--border-radius);font-size:15px;font-size:var(--submit-font-size);font-weight:normal;font-weight:var(--submit-weight);color:#ffffff;color:var(--submit-text-color);background:#579AF6;background:var(--submit-bg-color);border-width:1px;border-width:var(--submit-border-width);border-color:#579AF6;border-color:var(--submit-border-color);height:auto;height:var(--submit-height);}.with_frm_style .frm_button.frm_inverse{color:var(--submit-bg-color);background:var(--submit-text-color);}.with_frm_style .frm_submit{clear:both;}.frm_inline_form .frm_form_field,.frm_inline_form .frm_submit{grid-column: span 1 / span 1;}.frm_inline_form .frm_submit{margin:0;}.frm_submit.frm_inline_submit input[type=submit],.frm_submit.frm_inline_submit button,.frm_inline_form .frm_submit input[type=submit],.frm_inline_form .frm_submit button{margin-top:0;}.with_frm_style.frm_center_submit .frm_submit{text-align:center;}.with_frm_style.frm_center_submit .frm_flex.frm_submit {justify-content: center;}.with_frm_style .frm_inline_success .frm_submit{display: flex;flex-direction: row;align-items: center;margin: 0;}.with_frm_style .frm_inline_success .frm_submit .frm_message{flex: 1;margin: 0;padding-left: 10px;}.with_frm_style .frm_inline_success.frm_alignright_success .frm_submit .frm_message{text-align: right;}.with_frm_style.frm_center_submit .frm_submit input[type=submit],.with_frm_style.frm_center_submit .frm_submit input[type=button],.with_frm_style.frm_center_submit .frm_submit button{margin-bottom:8px !important;}.with_frm_style .frm-edit-page-btn,.with_frm_style .frm_submit input[type=submit],.with_frm_style .frm_submit input[type=button],.with_frm_style .frm_submit button{-webkit-appearance: none;cursor: pointer;}.with_frm_style.frm_center_submit .frm_submit .frm_ajax_loading{display: block;margin: 0 auto;}.with_frm_style .frm_loading_prev .frm_ajax_loading,.with_frm_style .frm_loading_form .frm_ajax_loading{visibility:visible !important;}.with_frm_style .frm_loading_prev .frm_prev_page,.with_frm_style .frm_loading_form .frm_button_submit {position: relative;opacity: .8;color: transparent !important;text-shadow: none !important;}.with_frm_style .frm_loading_prev .frm_prev_page:hover,.with_frm_style .frm_loading_prev .frm_prev_page:active,.with_frm_style .frm_loading_prev .frm_prev_page:focus,.with_frm_style .frm_loading_form .frm_button_submit:hover,.with_frm_style .frm_loading_form .frm_button_submit:active,.with_frm_style .frm_loading_form .frm_button_submit:focus {cursor: not-allowed;color: transparent;outline: none !important;box-shadow: none;}.with_frm_style .frm_loading_prev .frm_prev_page::before,.with_frm_style .frm_loading_form .frm_button_submit:before {content: \'\';display: inline-block;position: absolute;background: transparent;border: 1px solid #fff;border-top-color: transparent;border-left-color: transparent;border-radius: 50%;box-sizing: border-box;top: 50%;left: 50%;margin-top: -10px;margin-left: -10px;width: 20px;height: 20px;animation: spin 2s linear infinite;}.with_frm_style .frm_submit.frm_flex {align-items: center;gap: 2%;}.with_frm_style .frm_submit.frm_flex button.frm_button_submit ~ .frm_prev_page {order: -1;}.frm_style_style-formidable.with_frm_style{}.frm_forms.frm_style_style-formidable.with_frm_style{max-width:100%;direction:ltr;}.frm_style_style-formidable.with_frm_style .frm_icon_font{color:#3f4b5b;}.frm_style_style-formidable.with_frm_style .frm_icon_font.frm_minus_icon:before{content:"\\e600";}.frm_style_style-formidable.with_frm_style .frm_icon_font.frm_plus_icon:before{content:"\\e602";}.frm_style_style-formidable.with_frm_style .frm_icon_font.frm_minus_icon:before,.frm_style_style-formidable.with_frm_style .frm_icon_font.frm_plus_icon:before{color:#ffffff;vertical-align:middle;}.frm_style_style-formidable.with_frm_style .frm_trigger.active .frm_icon_font.frm_arrow_icon:before{content:"\\e62d";color:#444444;}.frm_style_style-formidable.with_frm_style .frm_trigger .frm_icon_font.frm_arrow_icon:before{content:"\\e62a";color:#444444;}.frm_style_style-formidable.with_frm_style .form-field{margin-bottom:20px;}.frm_style_style-formidable.with_frm_style .form-field.frm_section_heading{margin-bottom:0;}.frm_style_style-formidable.with_frm_style p.description,.frm_style_style-formidable.with_frm_style div.description,.frm_style_style-formidable.with_frm_style div.frm_description,.frm_style_style-formidable.with_frm_style .frm-show-form > div.frm_description,.frm_style_style-formidable.with_frm_style .frm_error,.frm_style_style-formidable.with_frm_style .frm_pro_max_limit_desc{padding:0;font-size:12px;color:#666666;font-weight:normal;text-align:left;font-style:normal;max-width:100%;}.frm_style_style-formidable.with_frm_style .frm_form_field.frm_left_container{grid-template-columns: 150px auto;}.frm_style_style-formidable.with_frm_style .frm_form_field.frm_right_container{grid-template-columns: auto 150px;}.frm_form_field.frm_right_container{grid-template-columns: auto 25%;}.frm_style_style-formidable.with_frm_style .frm_inline_container.frm_dynamic_select_container .frm_data_container,.frm_style_style-formidable.with_frm_style .frm_inline_container.frm_dynamic_select_container .frm_opt_container{display:inline;}.frm_style_style-formidable.with_frm_style .frm_pos_right{display:inline;width:150px;}.frm_style_style-formidable.with_frm_style .frm_none_container .frm_primary_label,.frm_style_style-formidable.with_frm_style .frm_pos_none{display:none;}.frm_style_style-formidable.with_frm_style input::placeholder,.frm_style_style-formidable.with_frm_style textarea::placeholder{color: #A1A1A1;}.frm_style_style-formidable.with_frm_style input::-webkit-input-placeholder,.frm_style_style-formidable.with_frm_style textarea::-webkit-input-placeholder{color: #A1A1A1;}.frm_style_style-formidable.with_frm_style input::-moz-placeholder,.frm_style_style-formidable.with_frm_style textarea::-moz-placeholder{color: #A1A1A1;opacity: 1;}.frm_style_style-formidable.with_frm_style input:-ms-input-placeholder,frm_style_style-formidable.with_frm_style textarea:-ms-input-placeholder{color: #A1A1A1;}.frm_style_style-formidable.with_frm_style .frm_default,.frm_style_style-formidable.with_frm_style input.frm_default,.frm_style_style-formidable.with_frm_style textarea.frm_default,.frm_style_style-formidable.with_frm_style select.frm_default,.frm_style_style-formidable.with_frm_style .placeholder,.frm_style_style-formidable.with_frm_style .chosen-container-multi .chosen-choices li.search-field .default,.frm_style_style-formidable.with_frm_style .chosen-container-single .chosen-default{color: #A1A1A1;}.frm_style_style-formidable.with_frm_style .form-field input:not([type=file]):focus,.frm_style_style-formidable.with_frm_style select:focus,.frm_style_style-formidable.with_frm_style textarea:focus,.frm_style_style-formidable.with_frm_style .frm_focus_field input[type=text],.frm_style_style-formidable.with_frm_style .frm_focus_field input[type=password],.frm_style_style-formidable.with_frm_style .frm_focus_field input[type=email],.frm_style_style-formidable.with_frm_style .frm_focus_field input[type=number],.frm_style_style-formidable.with_frm_style .frm_focus_field input[type=url],.frm_style_style-formidable.with_frm_style .frm_focus_field input[type=tel],.frm_style_style-formidable.with_frm_style .frm_focus_field input[type=search],.frm_form_fields_active_style,.frm_style_style-formidable.with_frm_style .frm_focus_field .frm-card-element.StripeElement,.frm_style_style-formidable.with_frm_style .chosen-container-single.chosen-container-active .chosen-single,.frm_style_style-formidable.with_frm_style .chosen-container-active .chosen-choices{background-color:#ffffff;border-color:#66afe9;color: var(--text-color);box-shadow:0 1px 1px rgba(0, 0, 0, 0.075) inset, 0 0 8px rgba(102,175,233, 0.6);}.frm_style_style-formidable.with_frm_style .frm_compact .frm_dropzone.dz-clickable .dz-message,.frm_style_style-formidable.with_frm_style input[type=submit],.frm_style_style-formidable.with_frm_style .frm_submit input[type=button],.frm_style_style-formidable.with_frm_style .frm_submit button,.frm_form_submit_style,.frm_style_style-formidable.with_frm_style .frm-edit-page-btn {width:auto;font-size:15px;height:auto;line-height:normal;text-align:center;background:#579AF6;border-width:1px;border-color: #579AF6;border-style:solid;color:#ffffff;cursor:pointer;font-weight:normal;border-radius:4px;text-shadow:none;padding:10px 20px;box-sizing:border-box;-ms-box-sizing:border-box;box-shadow:0 1px 1px #eeeeee;margin:10px;margin-left:0;margin-right:0;vertical-align:middle;}.frm_style_style-formidable.with_frm_style .frm_compact .frm_dropzone.dz-clickable .dz-message{margin:0;}.frm_style_style-formidable.with_frm_style .frm-edit-page-btn:hover,.frm_style_style-formidable.with_frm_style input[type=submit]:hover,.frm_style_style-formidable.with_frm_style .frm_submit input[type=button]:hover,.frm_style_style-formidable.with_frm_style .frm_submit button:hover{background: #efefef;border-color: #cccccc;color: #444444;}.frm_style_style-formidable.with_frm_style.frm_center_submit .frm_submit .frm_ajax_loading{margin-bottom:10px;}.frm_style_style-formidable.with_frm_style .frm-edit-page-btn:focus,.frm_style_style-formidable.with_frm_style input[type=submit]:focus,.frm_style_style-formidable.with_frm_style .frm_submit input[type=button]:focus,.frm_style_style-formidable.with_frm_style .frm_submit button:focus,.frm_style_style-formidable.with_frm_style input[type=submit]:active,.frm_style_style-formidable.with_frm_style .frm_submit input[type=button]:active,.frm_style_style-formidable.with_frm_style .frm_submit button:active{background: #efefef;border-color: #cccccc;color: #444444;outline: none;}.frm_style_style-formidable.with_frm_style .frm_loading_prev .frm_prev_page,.frm_style_style-formidable.with_frm_style .frm_loading_prev .frm_prev_page:hover,.frm_style_style-formidable.with_frm_style .frm_loading_prev .frm_prev_page:active,.frm_style_style-formidable.with_frm_style .frm_loading_prev .frm_prev_page:focus,.frm_style_style-formidable.with_frm_style .frm_loading_form .frm_button_submit,.frm_style_style-formidable.with_frm_style .frm_loading_form .frm_button_submit:hover,.frm_style_style-formidable.with_frm_style .frm_loading_form .frm_button_submit:active,.frm_style_style-formidable.with_frm_style .frm_loading_form .frm_button_submit:focus{color: transparent ;background: #579AF6;}.frm_style_style-formidable.with_frm_style .frm_loading_prev .frm_prev_page:before,.frm_style_style-formidable.with_frm_style .frm_loading_form .frm_button_submit:before {border-bottom-color: #ffffff;border-right-color: #ffffff;}.frm_style_style-formidable.with_frm_style.frm_inline_top .frm_submit::before,.frm_style_style-formidable.with_frm_style .frm_submit.frm_inline_submit::before {content:"before";font-size:15px;color:#3f4b5b;font-weight:normal;margin:0;padding:0 0 3px 0;width:auto;display:block;visibility:hidden;}.frm_style_style-formidable.with_frm_style.frm_inline_form .frm_submit input,.frm_style_style-formidable.with_frm_style.frm_inline_form .frm_submit button,.frm_style_style-formidable.with_frm_style .frm_submit.frm_inline_submit input,.frm_style_style-formidable.with_frm_style .frm_submit.frm_inline_submit button {margin: 0 !important;}.frm_style_style-formidable.with_frm_style #frm_field_cptch_number_container{font-size:15px;color:#3f4b5b;font-weight:normal;clear:both;}.frm_style_style-formidable.with_frm_style .frm_blank_field input[type=text],.frm_style_style-formidable.with_frm_style .frm_blank_field input[type=password],.frm_style_style-formidable.with_frm_style .frm_blank_field input[type=url],.frm_style_style-formidable.with_frm_style .frm_blank_field input[type=tel],.frm_style_style-formidable.with_frm_style .frm_blank_field input[type=number],.frm_style_style-formidable.with_frm_style .frm_blank_field input[type=email],.frm_style_style-formidable.with_frm_style .frm_blank_field textarea,.frm_style_style-formidable.with_frm_style .frm_blank_field .mce-edit-area iframe,.frm_style_style-formidable.with_frm_style .frm_blank_field select:not(.ui-datepicker-month):not(.ui-datepicker-year),.frm_form_fields_error_style,.frm_style_style-formidable.with_frm_style .frm_blank_field .frm-g-recaptcha iframe,.frm_style_style-formidable.with_frm_style .frm_blank_field .g-recaptcha iframe,.frm_style_style-formidable.with_frm_style .frm_blank_field .frm-card-element.StripeElement,.frm_style_style-formidable.with_frm_style .frm_blank_field .chosen-container-multi .chosen-choices,.frm_style_style-formidable.with_frm_style .frm_blank_field .chosen-container-single .chosen-single,.frm_style_style-formidable.with_frm_style .frm_form_field :invalid{color:#444444;background-color:#ffffff;border-color:#B94A48;border-width:1px;border-style:solid;}.frm_style_style-formidable.with_frm_style .frm_blank_field .sigWrapper{border-color:#B94A48 !important;}.frm_style_style-formidable.with_frm_style .frm_error,.frm_style_style-formidable.with_frm_style .frm_limit_error{font-weight:normal;}.frm_style_style-formidable.with_frm_style .frm_blank_field label,.frm_style_style-formidable.with_frm_style .frm_error,.frm_style_style-formidable.with_frm_style .frm_limit_error{color:#B94A48;}.frm_style_style-formidable.with_frm_style .frm_error_style{background-color:#F2DEDE;border:1px solid #EBCCD1;border-radius:4px;color: #B94A48;font-size:14px;margin:0;margin-bottom:20px;}.frm_style_style-formidable.with_frm_style #frm_loading .progress-striped .progress-bar{background-image:linear-gradient(45deg, #BFC3C8 25%, rgba(0, 0, 0, 0) 25%, rgba(0, 0, 0, 0) 50%, #BFC3C8 50%, #BFC3C8 75%, rgba(0, 0, 0, 0) 75%, rgba(0, 0, 0, 0));}.frm_style_style-formidable.with_frm_style #frm_loading .progress-bar{background-color:#ffffff;}.frm_style_style-formidable.with_frm_style .frm_form_field.frm_total_big input,.frm_style_style-formidable.with_frm_style .frm_form_field.frm_total_big textarea,.frm_style_style-formidable.with_frm_style .frm_form_field.frm_total input,.frm_style_style-formidable.with_frm_style .frm_form_field.frm_total textarea{color: #555555;background-color:transparent;border:none;display:inline;width:auto;padding:0;}.frm_ajax_loading{visibility:hidden;width:auto;}.frm_form_submit_style{height:auto;}a.frm_save_draft{cursor:pointer;}.with_frm_style a.frm_save_draft,.with_frm_style a.frm_start_over{font-size:15px;font-size:var(--submit-font-size);font-weight:normal;font-weight:var(--submit-weight);}.horizontal_radio .frm_radio{margin:0 5px 0 0;}.horizontal_radio .frm_checkbox{margin:0;margin-right:5px;}.vertical_radio .frm_checkbox,.vertical_radio .frm_radio,.vertical_radio .frm_catlevel_1{display:block;}.horizontal_radio .frm_checkbox,.horizontal_radio .frm_radio,.horizontal_radio .frm_catlevel_1{display:inline-block;padding-left: 0;}.with_frm_style .frm_radio{display:block;display:var(--radio-align);}.with_frm_style .frm_checkbox{display:block;display:var(--check-align);}.with_frm_style .vertical_radio .frm_checkbox,.with_frm_style .vertical_radio .frm_radio,.vertical_radio .frm_catlevel_1{display:block;}.with_frm_style .horizontal_radio .frm_checkbox,.with_frm_style .horizontal_radio .frm_radio,.horizontal_radio .frm_catlevel_1{display:inline-block;}.with_frm_style .frm_checkbox label,.with_frm_style .frm_radio label{display: inline;white-space:normal;}.with_frm_style .vertical_radio .frm_checkbox label,.with_frm_style .vertical_radio .frm_radio label{display: block;padding-left: 20px;text-indent: -20px;}.with_frm_style .frm_radio label,.with_frm_style .frm_checkbox label{font-size:13px;font-size:var(--check-font-size);color:#444444;color:var(--check-label-color);font-weight:normal;font-weight:var(--check-weight);line-height: 1.3;}.with_frm_style .frm_radio input[type=radio],.with_frm_style .frm_checkbox input[type=checkbox] {font-size:13px;font-size:var(--check-font-size);position:static;}.frm_file_container .frm_file_link,.with_frm_style .frm_radio label .frm_file_container,.with_frm_style .frm_checkbox label .frm_file_container{display:inline-block;margin:5px;vertical-align:middle;}.with_frm_style .frm_radio input[type=radio]{border-radius:50%;}.with_frm_style .frm_checkbox input[type=checkbox]{border-radius:0;}.with_frm_style .frm_radio input[type=radio],.with_frm_style .frm_checkbox input[type=checkbox]{appearance: none;background-color: var(--bg-color);flex: none;display:inline-block !important;margin: 0 5px 0 0;color: var(--border-color);width: 18px;min-width: 18px;height: 18px;border: 1px solid currentColor;border-color: var(--border-color);vertical-align: middle;position: initial; padding: 0;}.with_frm_style .frm_radio input[type=radio]:before,.with_frm_style .frm_checkbox input[type=checkbox]:before {content: \'\';width: 12px;height: 12px;border-radius: 50%;transform: scale(0);transition: 120ms transform ease-in-out;box-shadow: inset 10px 10px var(--text-color);display: block;margin: 2px 0 0 2px;}.with_frm_style .frm_checkbox input[type=checkbox]:before{clip-path: polygon(14% 44%, 0 65%, 50% 100%, 100% 16%, 80% 0%, 43% 62%);border-radius: 0;}.with_frm_style .frm_radio input[type=radio]:checked:before,.with_frm_style .frm_checkbox input[type=checkbox]:checked:before {transform: scale(1);}.with_frm_style :invalid,.with_frm_style :-moz-submit-invalid,.with_frm_style :-moz-ui-invalid{box-shadow:none;}.with_frm_style .frm_error_style img{padding-right:10px;vertical-align:middle;border:none;}.with_frm_style .frm_trigger{cursor:pointer;}.with_frm_style .frm_error_style,.with_frm_style .frm_message,.frm_success_style{border-radius:4px;padding:15px;}.with_frm_style .frm_message p{margin-bottom:5px;color:#468847;color:var(--success-text-color);}.with_frm_style .frm_message,.frm_success_style{margin:5px 0 15px;border:1px solid #D6E9C6;border-color:var(--success-border-color);background-color:#DFF0D8;background-color:var(--success-bg-color);color:#468847;color:var(--success-text-color);border-radius:4px;border-radius:var(--border-radius);font-size:14px;font-size:var(--success-font-size);}.with_frm_style .frm_plain_success .frm_message {background-color: transparent;padding:0;border:none;font-size:inherit;color:inherit;}.with_frm_style .frm_plain_success .frm_message p {color:inherit;}.frm_form_fields_style,.frm_form_fields_active_style,.frm_form_fields_error_style,.frm_form_submit_style{width:auto;}.with_frm_style .frm_trigger span{float:left;}.with_frm_style table.frm-grid,#content .with_frm_style table.frm-grid{border-collapse:collapse;border:none;}.frm-grid td,.frm-grid th{padding:5px;border-width:1px;border-style:solid;border-color:#BFC3C8;border-color:var(--border-color);border-top:none;border-left:none;border-right:none;}.frm-alt-table {width:100%;border-collapse:separate;margin-top:0.5em;font-size:15px;border-width:1px;}.with_frm_style .frm-alt-table{border-color:#BFC3C8;border-color:var(--border-color);}.frm-alt-table th {width:200px;}.frm-alt-table tr {background-color:transparent;}.frm-alt-table th,.frm-alt-table td {background-color:transparent;vertical-align:top;text-align:left;padding:20px;border-color:transparent;}.frm-alt-table tr:nth-child(even) {background-color:#ecf0f5;}table.form_results.with_frm_style{border:1px solid #BFC3C8;border-width:var(--field-border-width);border-color:var(--border-color);}table.form_results.with_frm_style tr td{text-align:left;padding:7px 9px;color:#555555;color:var(--text-color);border-top:1px solid #BFC3C8;border-top-width:var(--field-border-width);border-top-color:var(--border-color);}table.form_results.with_frm_style tr.frm_even,.frm-grid .frm_even{background-color:#fff;background-color:var(--bg-color);}table.form_results.with_frm_style tr.frm_odd,.frm-grid .frm_odd{background-color:#ffffff;background-color:var(--bg-color);}.frm_color_block {background-color:#ecf0f5;padding: 40px;}.with_frm_style .frm-show-form .frm_color_block.frm_section_heading h3,.frm_color_block.frm_section_heading h3 {border-width: 0 !important;}.frm_collapse .ui-icon{display:inline-block;}.frm_toggle_container{border:1px solid transparent;}.frm_toggle_container ul{margin:5px 0;padding-left:0;list-style-type:none;}.frm_toggle_container .frm_month_heading{text-indent:15px;}.frm_toggle_container .frm_month_listing{margin-left:40px;}#frm_loading{display:none;position:fixed;top:0;left:0;width:100%;height:100%;z-index:99999;}#frm_loading h3{font-weight:500;padding-bottom:15px;color:#fff;font-size:24px;}#frm_loading_content{position:fixed;top:20%;left:33%;width:33%;text-align:center;padding-top:30px;font-weight:bold;z-index:9999999;}#frm_loading img{max-width:100%;}#frm_loading .progress{border-radius:4px;box-shadow:0 1px 2px rgba(0, 0, 0, 0.1) inset;height:20px;margin-bottom:20px;overflow:hidden;}#frm_loading .progress.active .progress-bar{animation:2s linear 0s normal none infinite progress-bar-stripes;}#frm_loading .progress-striped .progress-bar{background-image:linear-gradient(45deg, #BFC3C8 25%, rgba(0, 0, 0, 0) 25%, rgba(0, 0, 0, 0) 50%, #BFC3C8 50%, #BFC3C8 75%, rgba(0, 0, 0, 0) 75%, rgba(0, 0, 0, 0));background-size:40px 40px;}#frm_loading .progress-bar{background-color:#ffffff;background-color:var(--bg-color);box-shadow:0 -1px 0 rgba(0, 0, 0, 0.15) inset;float:left;height:100%;line-height:20px;text-align:center;transition:width 0.6s ease 0s;width:100%;}.frm_image_from_url{height:50px;}.frm-loading-img{background:url(https://hs.vicq.org/wp-content/plugins/formidable/images/ajax_loader.gif) no-repeat center center;padding:6px 12px;}select.frm_loading_lookup{background-image: url(https://hs.vicq.org/wp-content/plugins/formidable/images/ajax_loader.gif) !important;background-position: 10px;background-repeat: no-repeat;color: transparent !important;}.frm_screen_reader {border: 0;clip: rect(1px, 1px, 1px, 1px);-webkit-clip-path: inset(50%);clip-path: inset(50%);height: 1px;margin: -1px;overflow: hidden;padding: 0;position: absolute;width: 1px;word-wrap: normal !important; }.frm_screen_reader.frm_hidden{display:initial;}.frm_clear_none{clear:none;}.frm_clear{clear:both;}.frm_form_field.frm_alignright{float:right !important;}.with_frm_style .frm_form_field{clear:both;}.frm_combo_inputs_container,.frm_grid_container,.frm_form_fields .frm_section_heading,.frm_form_fields .frm_fields_container{display:grid;grid-template-columns: repeat(12, 1fr);grid-auto-rows: max-content;grid-gap: 0 2%;}.frm_combo_inputs_container > *,.frm_grid_container > *,.frm_section_heading > *,.frm_fields_container .frm_form_field,.frm_fields_container > *{grid-column: span 12 / span 12;}.frm_inline,.frm_form_field.frm_left_inline,.frm_form_field.frm_first_inline,.frm_form_field.frm_inline,.frm_submit.frm_inline,.frm_form_field.frm_right_inline,.frm_form_field.frm_last_inline{width:auto;grid-column: span 2 / span 2;}.frm6,.frm_half,.frm_form_field.frm_three_fifths, .frm_form_field.frm6,.frm_submit.frm6,.frm_form_field.frm_left_half,.frm_form_field.frm_right_half,.frm_form_field.frm_first_half,.frm_form_field.frm_last_half,.frm_form_field.frm_half,.frm_submit.frm_half{grid-column:span 6 / span 6;}.frm4,.frm_third,.frm_form_field.frm_two_fifths, .frm_form_field.frm4,.frm_submit.frm4,.frm_form_field.frm_left_third,.frm_form_field.frm_third,.frm_submit.frm_third,.frm_form_field.frm_right_third,.frm_form_field.frm_first_third,.frm_form_field.frm_last_third{grid-column:span 4 / span 4;}.frm8,.frm_two_thirds,.frm_form_field.frm8,.frm_submit.frm8,.frm_form_field.frm_left_two_thirds,.frm_form_field.frm_right_two_thirds,.frm_form_field.frm_first_two_thirds,.frm_form_field.frm_last_two_thirds,.frm_form_field.frm_two_thirds{grid-column: span 8/span 8;}.frm3,.frm_fourth,.frm_form_field.frm3,.frm_submit.frm3,.frm_form_field.frm_left_fourth,.frm_form_field.frm_fourth,.frm_submit.frm_fourth,.frm_form_field.frm_right_fourth,.frm_form_field.frm_first_fourth,.frm_form_field.frm_last_fourth{grid-column: span 3/span 3;}.frm9,.frm_three_fourths,.frm_form_field.frm_four_fifths, .frm_form_field.frm9,.frm_submit.frm9,.frm_form_field.frm_three_fourths{grid-column: span 9/span 9;}.frm_form_field.frm_left_fifth,.frm_form_field.frm_fifth,.frm_submit.frm_fifth,.frm_form_field.frm_right_fifth,.frm_form_field.frm_first_fifth,.frm_form_field.frm_last_fifth{grid-column: span 2/span 2;}.frm2,.frm_sixth,.frm_form_field.frm2,.frm_submit.frm2,.frm_form_field.frm_sixth,.frm_submit.frm_sixth,.frm_form_field.frm_first_sixth,.frm_form_field.frm_last_sixth{grid-column: span 2/span 2;}.frm10,.frm_form_field.frm10,.frm_submit.frm10{grid-column: span 10/span 10;}.frm1,.frm_form_field.frm1,.frm_submit.frm1,.frm_form_field.frm_seventh,.frm_submit.frm_seventh,.frm_form_field.frm_first_seventh,.frm_form_field.frm_last_seventh.frm_form_field.frm_eighth,.frm_submit.frm_eighth,.frm_form_field.frm_first_eighth,.frm_form_field.frm_last_eighth{grid-column: span 1/span 1;}.frm5,.frm_form_field.frm5,.frm_submit.frm5{grid-column: span 5/span 5;}.frm7,.frm_form_field.frm7,.frm_submit.frm7{grid-column: span 7/span 7;}.frm11,.frm_form_field.frm11,.frm_submit.frm11{grid-column: span 11/span 11;}.frm12,.frm_full,.frm_full .wp-editor-wrap,.frm_full > input:not([type=\'checkbox\']):not([type=\'radio\']):not([type=\'button\']),.frm_full select,.frm_full textarea{width:100% !important;grid-column: span 12/span 12;box-sizing: border-box;}.frm_full .wp-editor-wrap input{width:auto !important;}.frm_first,.frm_form_field.frm_left_half,.frm_form_field.frm_left_third,.frm_form_field.frm_left_two_thirds,.frm_form_field.frm_left_fourth,.frm_form_field.frm_left_fifth,.frm_form_field.frm_left_inline,.frm_form_field.frm_first_half,.frm_form_field.frm_first_third,.frm_form_field.frm_first_two_thirds,.frm_form_field.frm_first_fourth,.frm_form_field.frm_first_fifth,.frm_form_field.frm_first_sixth,.frm_form_field.frm_first_seventh,.frm_form_field.frm_first_eighth,.frm_form_field.frm_first_inline,.frm_form_field.frm_first{grid-column-start:1;}.frm_last,.frm_form_field.frm_last,.frm_form_field.frm_alignright{grid-column-end:-1;justify-content: end;}.with_frm_style.frm_rtl .frm_form_fields .star-rating{float:right;}.with_frm_style.frm_rtl .frm_grid .frm_primary_label,.with_frm_style.frm_rtl .frm_grid_first .frm_primary_label,.with_frm_style.frm_rtl .frm_grid_odd .frm_primary_label,.with_frm_style.frm_rtl .frm_grid .frm_radio,.with_frm_style.frm_rtl .frm_grid_first .frm_radio,.with_frm_style.frm_rtl .frm_grid_odd .frm_radio,.with_frm_style.frm_rtl .frm_grid .frm_checkbox,.with_frm_style.frm_rtl .frm_grid_first .frm_checkbox,.with_frm_style.frm_rtl .frm_grid_odd .frm_checkbox{float:right !important;margin-right:0 !important;}.with_frm_style.frm_rtl .frm_grid_first .frm_radio label input,.with_frm_style.frm_rtl .frm_grid .frm_radio label input,.with_frm_style.frm_rtl .frm_grid_odd .frm_radio label input,.with_frm_style.frm_rtl .frm_grid_first .frm_checkbox label input,.with_frm_style.frm_rtl .frm_grid .frm_checkbox label input,.with_frm_style.frm_rtl .frm_grid_odd .frm_checkbox label input{float:left;}.with_frm_style.frm_rtl .frm_catlevel_2,.with_frm_style.frm_rtl .frm_catlevel_3,.with_frm_style.frm_rtl .frm_catlevel_4,.with_frm_style.frm_rtl .frm_catlevel_5{margin-right:18px;}.with_frm_style.frm_rtl div > .frm_time_select{margin-right:5px;}.frm_form_field.frm_inline_container,.frm_form_field.frm_right_container,.frm_form_field.frm_left_container{display: grid;grid-template-columns: 25% auto;width:100%;grid-auto-rows: min-content;}.frm_form_field.frm_right_container{grid-template-columns: auto 25%;}.frm_form_field.frm_inline_container{grid-template-columns: repeat(2, minmax(auto, max-content) );}.frm_form_field.frm_inline_container .frm_primary_label,.frm_form_field.frm_right_container .frm_primary_label,.frm_form_field.frm_left_container .frm_primary_label{margin-right:10px;grid-row:span 2/span 2;padding-top:4px;}.frm_form_field.frm_left_container .frm_primary_label{grid-column:1;grid-row:span 2/span 2; }.frm_form_field.frm_right_container .frm_primary_label{grid-column:2;grid-row:1;margin-right:0;margin-left:10px;}.frm_form_field.frm_inline_container .frm_description,.frm_form_field.frm_left_container .frm_description{grid-column:2;}.frm_form_field.frm_right_container .frm_description{grid-column:1;}.frm_conf_field.frm_left_container{grid-template-columns: 67%;}.frm_conf_field.frm_left_container .frm_description{grid-column:1;}.frm-fade-in {animation-name: fadeIn;animation-duration: 1s;animation-fill-mode: both;}@keyframes spin {0% { transform: rotate(0deg); }100% { transform: rotate(360deg); }}@keyframes fadeIn {   0% {opacity: 0;}   100% {opacity: 1;}}@media only screen and (max-width: 750px) {.frm_grid_container.frm_no_grid_750 > div{grid-column: span 12/span 12;}}@media only screen and (max-width: 600px) {.frm_section_heading > .frm_form_field,.frm_fields_container > .frm_submit,.frm_grid_container > .frm_form_field,.frm_fields_container > .frm_form_field{grid-column: 1 / span 12 !important;}.frm_grid_container.frm_no_grid_600,.frm_form_field.frm_inline_container,.frm_form_field.frm_right_container,.frm_form_field.frm_left_container{display:block;}}.frm_conf_field.frm_left_container .frm_primary_label{display:none;}.wp-editor-wrap *,.wp-editor-wrap *:after,.wp-editor-wrap *:before{box-sizing:content-box;}.with_frm_style .frm_grid,.with_frm_style .frm_grid_first,.with_frm_style .frm_grid_odd{clear:both;margin-bottom:0 !important;padding:5px;border-width:1px;border-style:solid;border-color:#BFC3C8;border-color:var(--border-color);border-left:none;border-right:none;}.with_frm_style .frm_grid,.with_frm_style .frm_grid_odd{border-top:none;}.frm_grid .frm_error,.frm_grid_first .frm_error,.frm_grid_odd .frm_error,.frm_grid .frm_limit_error,.frm_grid_first .frm_limit_error,.frm_grid_odd .frm_limit_error{display:none;}.frm_grid:after,.frm_grid_first:after,.frm_grid_odd:after{visibility:hidden;display:block;font-size:0;content:" ";clear:both;height:0;}.frm_grid_first{margin-top:20px;}.frm_grid_first,.frm_grid_odd{background-color:#ffffff;background-color:var(--bg-color);}.frm_grid{background-color:#ffffff;background-color:var(--bg-color-active);}.with_frm_style .frm_grid.frm_blank_field,.with_frm_style .frm_grid_first.frm_blank_field,.with_frm_style .frm_grid_odd.frm_blank_field{background-color:#F2DEDE;background-color:var(--error-bg);border-color:#EBCCD1;border-color:var(--error-bg);}.frm_grid .frm_primary_label,.frm_grid_first .frm_primary_label,.frm_grid_odd .frm_primary_label,.frm_grid .frm_radio,.frm_grid_first .frm_radio,.frm_grid_odd .frm_radio,.frm_grid .frm_checkbox,.frm_grid_first .frm_checkbox,.frm_grid_odd .frm_checkbox{float:left !important;display:block;margin-top:0;margin-left:0 !important;}.frm_grid_first .frm_radio label,.frm_grid .frm_radio label,.frm_grid_odd .frm_radio label,.frm_grid_first .frm_checkbox label,.frm_grid .frm_checkbox label,.frm_grid_odd .frm_checkbox label{visibility:hidden;white-space:nowrap;text-align:left;}.frm_grid_first .frm_radio label input,.frm_grid .frm_radio label input,.frm_grid_odd .frm_radio label input,.frm_grid_first .frm_checkbox label input,.frm_grid .frm_checkbox label input,.frm_grid_odd .frm_checkbox label input{visibility:visible;margin:2px 0 0;float:right;}.frm_grid .frm_radio,.frm_grid_first .frm_radio,.frm_grid_odd .frm_radio,.frm_grid .frm_checkbox,.frm_grid_first .frm_checkbox,.frm_grid_odd .frm_checkbox{display:inline;}.frm_grid_2 .frm_radio,.frm_grid_2 .frm_checkbox,.frm_grid_2 .frm_primary_label{width:48% !important;}.frm_grid_2 .frm_radio,.frm_grid_2 .frm_checkbox{margin-right:4%;}.frm_grid_3 .frm_radio,.frm_grid_3 .frm_checkbox,.frm_grid_3 .frm_primary_label{width:30% !important;}.frm_grid_3 .frm_radio,.frm_grid_3 .frm_checkbox{margin-right:3%;}.frm_grid_4 .frm_radio,.frm_grid_4 .frm_checkbox{width:20% !important;}.frm_grid_4 .frm_primary_label{width:28% !important;}.frm_grid_4 .frm_radio,.frm_grid_4 .frm_checkbox{margin-right:4%;}.frm_grid_5 .frm_primary_label,.frm_grid_7 .frm_primary_label{width:24% !important;}.frm_grid_5 .frm_radio,.frm_grid_5 .frm_checkbox{width:17% !important;margin-right:2%;}.frm_grid_6 .frm_primary_label{width:25% !important;}.frm_grid_6 .frm_radio,.frm_grid_6 .frm_checkbox{width:14% !important;margin-right:1%;}.frm_grid_7 .frm_primary_label{width:22% !important;}.frm_grid_7 .frm_radio,.frm_grid_7 .frm_checkbox{width:12% !important;margin-right:1%;}.frm_grid_8 .frm_primary_label{width:23% !important;}.frm_grid_8 .frm_radio,.frm_grid_8 .frm_checkbox{width:10% !important;margin-right:1%;}.frm_grid_9 .frm_primary_label{width:20% !important;}.frm_grid_9 .frm_radio,.frm_grid_9 .frm_checkbox{width:9% !important;margin-right:1%;}.frm_grid_10 .frm_primary_label{width:19% !important;}.frm_grid_10 .frm_radio,.frm_grid_10 .frm_checkbox{width:8% !important;margin-right:1%;}.frm_form_field.frm_inline_container .frm_opt_container,.frm_form_field.frm_right_container .frm_opt_container,.frm_form_field.frm_left_container .frm_opt_container{padding-top:4px;}.with_frm_style .frm_inline_container.frm_grid_first .frm_primary_label,.with_frm_style .frm_inline_container.frm_grid .frm_primary_label,.with_frm_style .frm_inline_container.frm_grid_odd .frm_primary_label,.with_frm_style .frm_inline_container.frm_grid_first .frm_opt_container,.with_frm_style .frm_inline_container.frm_grid .frm_opt_container,.with_frm_style .frm_inline_container.frm_grid_odd .frm_opt_container{margin-right:0;}.frm_form_field.frm_two_col .frm_opt_container,.frm_form_field.frm_three_col .frm_opt_container,.frm_form_field.frm_four_col .frm_opt_container{display: grid;grid-template-columns: repeat(2, 1fr);grid-auto-rows: max-content;grid-gap: 0 2.5%;}.frm_form_field.frm_three_col .frm_opt_container{grid-template-columns: repeat(3, 1fr);}.frm_form_field.frm_four_col .frm_opt_container{grid-template-columns: repeat(4, 1fr);}.frm_form_field.frm_two_col .frm_radio,.frm_form_field.frm_two_col .frm_checkbox,.frm_form_field.frm_three_col .frm_radio,.frm_form_field.frm_three_col .frm_checkbox,.frm_form_field.frm_four_col .frm_radio,.frm_form_field.frm_four_col .frm_checkbox{grid-column-end: span 1;}.frm_form_field .frm_checkbox,.frm_form_field .frm_checkbox + .frm_checkbox,.frm_form_field .frm_radio,.frm_form_field .frm_radio + .frm_radio{margin-top: 0;margin-bottom: 0;}.frm_form_field.frm_scroll_box .frm_opt_container{height:100px;overflow:auto;}.frm_html_container.frm_scroll_box,.frm_form_field.frm_html_scroll_box{height:100px;overflow:auto;background-color:#ffffff;background-color:var(--bg-color);border-color:#BFC3C8;border-color:var(--border-color);border-width:1px;border-width:var(--field-border-width);border-style:solid;border-style:var(--field-border-style);border-radius:4px;border-radius:var(--border-radius);width:100%;width:var(--field-width);max-width:100%;font-size:14px;font-size:var(--field-font-size);padding:6px 10px;padding:var(--field-pad);box-sizing:border-box;outline:none;font-weight:normal;box-shadow:var(--box-shadow);}.frm_form_field.frm_total_big input,.frm_form_field.frm_total_big textarea,.frm_form_field.frm_total input,.frm_form_field.frm_total textarea{opacity:1;background-color:transparent !important;border:none !important;font-weight:bold;width:auto !important;height:auto !important;box-shadow:none !important;display:inline;-moz-appearance:textfield;padding:0;}.frm_form_field.frm_total_big input::-webkit-outer-spin-button,.frm_form_field.frm_total_big input::-webkit-inner-spin-button,.frm_form_field.frm_total input::-webkit-outer-spin-button,.frm_form_field.frm_total input::-webkit-inner-spin-button {-webkit-appearance: none;}.frm_form_field.frm_total_big input:focus,.frm_form_field.frm_total_big textarea:focus,.frm_form_field.frm_total input:focus,.frm_form_field.frm_total textarea:focus{background-color:transparent;border:none;box-shadow:none;}.frm_form_field.frm_label_justify .frm_primary_label{text-align:justify !important;}.frm_form_field.frm_capitalize input,.frm_form_field.frm_capitalize select,.frm_form_field.frm_capitalize .frm_opt_container label{text-transform:capitalize;}.frm_clearfix:after{content:".";display:block;clear:both;visibility:hidden;line-height:0;height:0;}.frm_clearfix{display:block;}.with_frm_style .frm_repeat_sec .frm_form_field.frm_repeat_buttons .frm_icon_font::before {color:#ffffff;color:var(--repeat-icon-color);}.with_frm_style .frm_combo_inputs_container > .frm_form_subfield-first,.with_frm_style .frm_combo_inputs_container > .frm_form_subfield-middle,.with_frm_style .frm_combo_inputs_container > .frm_form_subfield-last {margin-bottom: 0 !important;}@media only screen and (max-width: 900px) {.frm_form_field .frm_repeat_grid .frm_form_field.frm_sixth .frm_primary_label,.frm_form_field .frm_repeat_grid .frm_form_field.frm_seventh .frm_primary_label,.frm_form_field .frm_repeat_grid .frm_form_field.frm_eighth .frm_primary_label{display: block !important;}}@media only screen and (max-width: 600px) {.frm_form_field.frm_four_col .frm_opt_container{grid-template-columns: repeat(2, 1fr);}.with_frm_style .frm_repeat_inline,.with_frm_style .frm_repeat_grid{margin: 20px 0;}}@media only screen and (max-width: 500px) {.frm_form_field.frm_two_col .frm_radio,.frm_form_field.frm_two_col .frm_checkbox,.frm_form_field.frm_three_col .frm_radio,.frm_form_field.frm_three_col .frm_checkbox{width: auto;margin-right: 0;float: none;display:block;}.frm_form_field input[type=file] {max-width:220px;}.with_frm_style .frm-g-recaptcha > div > div,.with_frm_style .g-recaptcha > div > div{width:inherit !important;display:block;overflow:hidden;max-width:302px;border-right:1px solid #d3d3d3;border-radius:4px;box-shadow:2px 0px 4px -1px rgba(0,0,0,.08);-moz-box-shadow:2px 0px 4px -1px rgba(0,0,0,.08);}.with_frm_style .g-recaptcha iframe,.with_frm_style .frm-g-recaptcha iframe{width:100%;}}','no');
INSERT INTO `hs_options` VALUES (5911,'_transient_timeout_frmpro_css','1717872497','no');
INSERT INTO `hs_options` VALUES (5912,'_transient_frmpro_css','/* AVERTISSEMENT : Toutes modifications apportées à ce fichier seront perdues lorsque vos réglages de Formidable seront mis à jour. */\n.with_frm_style{--form-width:100%;--form-align:left;--direction:ltr;--fieldset:0px;--fieldset-color:#000000;--fieldset-padding:0 0 15px 0;--fieldset-bg-color:transparent;--title-size:40px;--title-color:#444444;--title-margin-top:10px;--title-margin-bottom:60px;--form-desc-size:14px;--form-desc-color:#666666;--form-desc-margin-top:10px;--form-desc-margin-bottom:25px;--form-desc-padding:0;--font-size:15px;--label-color:#3f4b5b;--weight:normal;--position:none;--align:left;--width:150px;--required-color:#B94A48;--required-weight:bold;--label-padding:0 0 3px 0;--description-font-size:12px;--description-color:#666666;--description-weight:normal;--description-style:normal;--description-align:left;--description-margin:0;--field-font-size:14px;--field-height:32px;--line-height:32px;--field-width:100%;--auto-width:100%;--field-pad:6px 10px;--field-margin:20px;--field-weight:normal;--text-color:#555555;--border-color:#BFC3C8;--field-border-width:1px;--field-border-style:solid;--bg-color:#ffffff;--bg-color-active:#ffffff;--border-color-active:#66afe9;--text-color-error:#444444;--bg-color-error:#ffffff;--border-color-error:#B94A48;--border-width-error:1px;--border-style-error:solid;--bg-color-disabled:#ffffff;--border-color-disabled:#E5E5E5;--text-color-disabled:#A1A1A1;--radio-align:block;--check-align:block;--check-font-size:13px;--check-label-color:#444444;--check-weight:normal;--section-font-size:18px;--section-color:#444444;--section-weight:bold;--section-pad:15px 0 3px 0;--section-mar-top:15px;--section-mar-bottom:30px;--section-bg-color:transparent;--section-border-color:#e8e8e8;--section-border-width:2px;--section-border-style:solid;--section-border-loc:-top;--collapse-pos:after;--repeat-icon-color:#ffffff;--submit-font-size:15px;--submit-width:auto;--submit-height:auto;--submit-bg-color:#579AF6;--submit-border-color:#579AF6;--submit-border-width:1px;--submit-text-color:#ffffff;--submit-weight:normal;--submit-border-radius:4px;--submit-margin:10px;--submit-padding:10px 20px;--submit-shadow-color:#eeeeee;--submit-hover-bg-color:#efefef;--submit-hover-color:#444444;--submit-hover-border-color:#cccccc;--submit-active-bg-color:#efefef;--submit-active-color:#444444;--submit-active-border-color:#cccccc;--border-radius:4px;--error-bg:#F2DEDE;--error-border:#EBCCD1;--error-text:#B94A48;--error-font-size:14px;--success-bg-color:#DFF0D8;--success-border-color:#D6E9C6;--success-text-color:#468847;--success-font-size:14px;--progress-bg-color:#eaeaea;--progress-active-color:#ffffff;--progress-active-bg-color:#579AF6;--progress-color:#3f4b5b;--progress-border-color:#E5E5E5;--progress-border-size:2px;--progress-size:24px;--box-shadow:0 1px 1px rgba(0, 0, 0, 0.075) inset;}.frm_hidden,.frm_add_form_row.frm_hidden,.frm_remove_form_row.frm_hidden,.with_frm_style .frm_button.frm_hidden{display:none;}.with_frm_style,.with_frm_style form,.with_frm_style .frm-show-form div.frm_description p{text-align:left;text-align:var(--form-align);}input:-webkit-autofill {-webkit-box-shadow: 0 0 0 30px white inset;}.with_frm_style .frm-show-form div.frm_description p{font-size:14px;font-size:var(--form-desc-size);color:#666666;color:var(--form-desc-color);margin-top:10px;margin-top:var(--form-desc-margin-top);margin-bottom:25px;margin-bottom:var(--form-desc-margin-bottom);padding:0;padding:var(--form-desc-padding);}form .frm__663d1a7145329 {overflow: hidden;width: 0;height: 0;position: absolute;}.with_frm_style fieldset{min-width:0;display: block; }.with_frm_style fieldset fieldset{border:none;margin:0;padding:0;background-color:transparent;}.with_frm_style .frm_form_fields > fieldset{border-width:0px;border-width:var(--fieldset);border-style:solid;border-color:#000000;border-color:var(--fieldset-color);margin:0;padding:0 0 15px 0;padding:var(--fieldset-padding);background-color:transparent;background-color:var(--fieldset-bg-color);}legend.frm_hidden{display:none !important;}.with_frm_style .frm_form_fields{opacity:1;transition: opacity 0.1s linear;}.with_frm_style .frm_doing_ajax{opacity:.5;}.frm_transparent{color:transparent;}.with_frm_style legend + h3,.with_frm_style h3.frm_form_title{font-size:40px;font-size:var(--title-size);color:#444444;color:var(--title-color);margin-top:10px;margin-top:var(--title-margin-top);margin-bottom:60px;margin-bottom:var(--title-margin-bottom);}.with_frm_style .frm_form_field.frm_html_container,.with_frm_style .frm_form_field .frm_show_it{color:#666666;color:var(--form-desc-color);}.with_frm_style .frm_form_field.frm_html_container{font-size:14px;font-size:var(--form-desc-size);}.with_frm_style .frm_form_field .frm_show_it{font-size:14px;font-size:var(--field-font-size);font-weight:normal;font-weight:var(--field-weight);}.with_frm_style .frm_required{color:#B94A48;color:var(--required-color);font-weight:bold;font-weight:var(--required-weight);}.with_frm_style input[type=text],.with_frm_style input[type=password],.with_frm_style input[type=email],.with_frm_style input[type=number],.with_frm_style input[type=url],.with_frm_style input[type=tel],.with_frm_style input[type=search],.with_frm_style select,.with_frm_style textarea,.with_frm_style .frm-card-element.StripeElement,.with_frm_style .chosen-container{font-family:var(--font);font-size:14px;font-size:var(--field-font-size);margin-bottom:0;}.with_frm_style textarea{vertical-align:top;height:auto;}.with_frm_style input[type=text],.with_frm_style input[type=password],.with_frm_style input[type=email],.with_frm_style input[type=number],.with_frm_style input[type=url],.with_frm_style input[type=tel],.with_frm_style input[type=phone],.with_frm_style input[type=search],.with_frm_style select,.with_frm_style textarea,.frm_form_fields_style,.with_frm_style .frm_scroll_box .frm_opt_container,.frm_form_fields_active_style,.frm_form_fields_error_style,.with_frm_style .frm-card-element.StripeElement,.with_frm_style .chosen-container-multi .chosen-choices,.with_frm_style .chosen-container-single .chosen-single,.with_frm_style .frm_slimselect.ss-main {color:#555555;color:var(--text-color);background-color:#ffffff;background-color:var(--bg-color);border-color:#BFC3C8;border-color:var(--border-color);border-width:1px;border-width:var(--field-border-width);border-style:solid;border-style:var(--field-border-style);border-radius:4px;border-radius:var(--border-radius);width:100%;width:var(--field-width);max-width:100%;font-size:14px;font-size:var(--field-font-size);padding:6px 10px;padding:var(--field-pad);box-sizing:border-box;outline:none;font-weight:normal;font-weight:var(--field-weight);box-shadow:var(--box-shadow);}.with_frm_style select option {color:#555555;color:var(--text-color);}.with_frm_style select option.frm-select-placeholder {color:#A1A1A1;color:var(--text-color-disabled);}.with_frm_style input[type=radio],.with_frm_style input[type=checkbox]{border-color:#BFC3C8;border-color:var(--border-color);box-shadow:var(--box-shadow);float: none;}.with_frm_style input[type=radio]:after,.with_frm_style input[type=checkbox]:after {display: none; }.with_frm_style input[type=text],.with_frm_style input[type=password],.with_frm_style input[type=email],.with_frm_style input[type=number],.with_frm_style input[type=url],.with_frm_style input[type=tel],.with_frm_style input[type=file],.with_frm_style input[type=search],.with_frm_style select,.with_frm_style .frm-card-element.StripeElement{min-height:32px;min-height:var(--field-height);line-height:1.3;}.with_frm_style select[multiple=multiple]{height:auto;}.input[type=file].frm_transparent:focus,.with_frm_style input[type=file]{background-color:transparent;border:none;outline:none;box-shadow:none;}.with_frm_style input[type=file]{color:#555555;color:var(--text-color);padding:0px;font-size:14px;font-size:var(--field-font-size);display:initial;}.with_frm_style input[type=file].frm_transparent{color:transparent;}.with_frm_style .wp-editor-wrap{width:100%;width:var(--field-width);max-width:100%;}.with_frm_style .wp-editor-container textarea{border:none;box-shadow:none !important;}.with_frm_style .mceIframeContainer{background-color:#ffffff;background-color:var(--bg-color);}.with_frm_style select{width:100%;width:var(--auto-width);max-width:100%;background-position-y: calc(50% + 3px);}.with_frm_style input[disabled],.with_frm_style select[disabled],.with_frm_style textarea[disabled],.with_frm_style input[readonly],.with_frm_style select[readonly],.with_frm_style textarea[readonly]{background-color:#ffffff;background-color:var(--bg-color-disabled);color:#A1A1A1;color:var(--text-color-disabled);border-color:#E5E5E5;border-color:var(--border-color-disabled);}.frm_preview_page:before{content:normal !important;}.frm_preview_page{padding:25px;}.with_frm_style .frm_primary_label{max-width:100%;font-size:15px;font-size:var(--font-size);color:#3f4b5b;color:var(--label-color);font-weight:normal;font-weight:var(--weight);text-align:left;text-align:var(--align);padding:0 0 3px 0;padding:var(--label-padding);margin:0;width:auto;display:block;}.with_frm_style .frm_top_container .frm_primary_label,.with_frm_style .frm_hidden_container .frm_primary_label,.with_frm_style .frm_pos_top{display:block;float:none;width:auto;}.with_frm_style .frm_inline_container .frm_primary_label{margin-right:10px;}.with_frm_style .frm_right_container .frm_primary_label,.with_frm_style .frm_pos_right{display:inline;float:right;margin-left:10px;}.with_frm_style .frm_pos_center {text-align: center;}.with_frm_style .frm_none_container .frm_primary_label,.with_frm_style .frm_pos_none,.frm_pos_none,.frm_none_container .frm_primary_label{display:none;}.with_frm_style .frm_section_heading.frm_hide_section{margin-top:0 !important;}.with_frm_style .frm_hidden_container .frm_primary_label,.with_frm_style .frm_pos_hidden,.frm_hidden_container .frm_primary_label{visibility:hidden;white-space:nowrap;}.frm_visible{opacity:1;}.with_frm_style .frm_inside_container {position: relative;padding-top: 16px;padding-top: calc(0.5 * var(--field-height));}.with_frm_style .frm_inside_container > input,.with_frm_style .frm_inside_container > select,.with_frm_style .frm_inside_container > textarea {display: block;}.with_frm_style .frm_inside_container > input::-moz-placeholder,.with_frm_style .frm_inside_container > textarea::-moz-placeholder {opacity: 0 !important;transition: opacity 0.3s ease-in;}.with_frm_style .frm_inside_container > input:-ms-input-placeholder,.with_frm_style .frm_inside_container > textarea:-ms-input-placeholder {opacity: 0;transition: opacity 0.3s ease-in;}.with_frm_style .frm_inside_container > input::placeholder,.with_frm_style .frm_inside_container > textarea::placeholder {opacity: 0;transition: opacity 0.3s ease-in;}.with_frm_style .frm_inside_container > label {transition: all 0.3s ease-in;position: absolute;top: 17px;top: calc(1px + .5 * var(--field-height));left: 3px;width: 100%;line-height: 1.3;text-overflow: ellipsis;overflow: hidden;white-space: nowrap;padding: 6px 10px;padding: var(--field-pad);font-size: 14px;font-size: var(--field-font-size);font-weight: normal;font-weight: var(--field-weight);-ms-pointer-events: none;pointer-events: none;}.with_frm_style.frm_style_lines-no-boxes .frm_inside_container > label {line-height: 1;}.with_frm_style .frm_inside_container.frm_label_float_top > label {top: 0;left: 0;padding: 0;font-size: 12px;font-size: calc(0.85 * var(--field-font-size));}.with_frm_style .frm_inside_container.frm_label_float_top > input::-moz-placeholder,.with_frm_style .frm_inside_container.frm_label_float_top > textarea::-moz-placeholder {opacity: 1 !important;transition: opacity 0.3s ease-in;}.with_frm_style .frm_inside_container.frm_label_float_top > input:-ms-input-placeholder,.with_frm_style .frm_inside_container.frm_label_float_top > textarea:-ms-input-placeholder {opacity: 1;transition: opacity 0.3s ease-in;}.with_frm_style .frm_inside_container.frm_label_float_top > input::placeholder,.with_frm_style .frm_inside_container.frm_label_float_top > textarea::placeholder {opacity: 1;transition: opacity 0.3s ease-in;}.with_frm_style .frm_description,.with_frm_style .frm_pro_max_limit_desc{clear:both;}.with_frm_style input[type=number][readonly]{-moz-appearance: textfield;}.with_frm_style select[multiple="multiple"]{height:auto;line-height:normal;}.with_frm_style .frm_catlevel_2,.with_frm_style .frm_catlevel_3,.with_frm_style .frm_catlevel_4,.with_frm_style .frm_catlevel_5{margin-left:18px;}.with_frm_style .wp-editor-container{border:1px solid #e5e5e5;}.with_frm_style .quicktags-toolbar input{font-size:12px !important;}.with_frm_style .wp-editor-container textarea{border:none;}.with_frm_style .auto_width #loginform input,.with_frm_style .auto_width input,.with_frm_style input.auto_width,.with_frm_style select.auto_width,.with_frm_style textarea.auto_width{width:auto;}.with_frm_style .frm_repeat_buttons{white-space:nowrap;}.with_frm_style .frm_button{text-decoration:none !important;;border:1px solid #eee;display:inline-block;padding:10px 20px;padding:var(--submit-padding);border-radius:4px;border-radius:var(--border-radius);font-size:15px;font-size:var(--submit-font-size);font-weight:normal;font-weight:var(--submit-weight);color:#ffffff;color:var(--submit-text-color);background:#579AF6;background:var(--submit-bg-color);border-width:1px;border-width:var(--submit-border-width);border-color:#579AF6;border-color:var(--submit-border-color);height:auto;height:var(--submit-height);}.with_frm_style .frm_button.frm_inverse{color:var(--submit-bg-color);background:var(--submit-text-color);}.with_frm_style .frm_submit{clear:both;}.frm_inline_form .frm_form_field,.frm_inline_form .frm_submit{grid-column: span 1 / span 1;}.frm_inline_form .frm_submit{margin:0;}.frm_submit.frm_inline_submit input[type=submit],.frm_submit.frm_inline_submit button,.frm_inline_form .frm_submit input[type=submit],.frm_inline_form .frm_submit button{margin-top:0;}.with_frm_style.frm_center_submit .frm_submit{text-align:center;}.with_frm_style.frm_center_submit .frm_flex.frm_submit {justify-content: center;}.with_frm_style .frm_inline_success .frm_submit{display: flex;flex-direction: row;align-items: center;margin: 0;}.with_frm_style .frm_inline_success .frm_submit .frm_message{flex: 1;margin: 0;padding-left: 10px;}.with_frm_style .frm_inline_success.frm_alignright_success .frm_submit .frm_message{text-align: right;}.with_frm_style.frm_center_submit .frm_submit input[type=submit],.with_frm_style.frm_center_submit .frm_submit input[type=button],.with_frm_style.frm_center_submit .frm_submit button{margin-bottom:8px !important;}.with_frm_style .frm-edit-page-btn,.with_frm_style .frm_submit input[type=submit],.with_frm_style .frm_submit input[type=button],.with_frm_style .frm_submit button{-webkit-appearance: none;cursor: pointer;}.with_frm_style.frm_center_submit .frm_submit .frm_ajax_loading{display: block;margin: 0 auto;}.with_frm_style .frm_loading_prev .frm_ajax_loading,.with_frm_style .frm_loading_form .frm_ajax_loading{visibility:visible !important;}.with_frm_style .frm_loading_prev .frm_prev_page,.with_frm_style .frm_loading_form .frm_button_submit {position: relative;opacity: .8;color: transparent !important;text-shadow: none !important;}.with_frm_style .frm_loading_prev .frm_prev_page:hover,.with_frm_style .frm_loading_prev .frm_prev_page:active,.with_frm_style .frm_loading_prev .frm_prev_page:focus,.with_frm_style .frm_loading_form .frm_button_submit:hover,.with_frm_style .frm_loading_form .frm_button_submit:active,.with_frm_style .frm_loading_form .frm_button_submit:focus {cursor: not-allowed;color: transparent;outline: none !important;box-shadow: none;}.with_frm_style .frm_loading_prev .frm_prev_page::before,.with_frm_style .frm_loading_form .frm_button_submit:before {content: \'\';display: inline-block;position: absolute;background: transparent;border: 1px solid #fff;border-top-color: transparent;border-left-color: transparent;border-radius: 50%;box-sizing: border-box;top: 50%;left: 50%;margin-top: -10px;margin-left: -10px;width: 20px;height: 20px;animation: spin 2s linear infinite;}.with_frm_style .frm_submit.frm_flex {align-items: center;gap: 2%;}.with_frm_style .frm_submit.frm_flex button.frm_button_submit ~ .frm_prev_page {order: -1;}.frm_style_style-formidable.with_frm_style{}.frm_forms.frm_style_style-formidable.with_frm_style{max-width:100%;direction:ltr;}.frm_style_style-formidable.with_frm_style .frm_icon_font{color:#3f4b5b;}.frm_style_style-formidable.with_frm_style .frm_icon_font.frm_minus_icon:before{content:"\\e600";}.frm_style_style-formidable.with_frm_style .frm_icon_font.frm_plus_icon:before{content:"\\e602";}.frm_style_style-formidable.with_frm_style .frm_icon_font.frm_minus_icon:before,.frm_style_style-formidable.with_frm_style .frm_icon_font.frm_plus_icon:before{color:#ffffff;vertical-align:middle;}.frm_style_style-formidable.with_frm_style .frm_trigger.active .frm_icon_font.frm_arrow_icon:before{content:"\\e62d";color:#444444;}.frm_style_style-formidable.with_frm_style .frm_trigger .frm_icon_font.frm_arrow_icon:before{content:"\\e62a";color:#444444;}.frm_style_style-formidable.with_frm_style .form-field{margin-bottom:20px;}.frm_style_style-formidable.with_frm_style .form-field.frm_section_heading{margin-bottom:0;}.frm_style_style-formidable.with_frm_style p.description,.frm_style_style-formidable.with_frm_style div.description,.frm_style_style-formidable.with_frm_style div.frm_description,.frm_style_style-formidable.with_frm_style .frm-show-form > div.frm_description,.frm_style_style-formidable.with_frm_style .frm_error,.frm_style_style-formidable.with_frm_style .frm_pro_max_limit_desc{padding:0;font-size:12px;color:#666666;font-weight:normal;text-align:left;font-style:normal;max-width:100%;}.frm_style_style-formidable.with_frm_style .frm_form_field.frm_left_container{grid-template-columns: 150px auto;}.frm_style_style-formidable.with_frm_style .frm_form_field.frm_right_container{grid-template-columns: auto 150px;}.frm_form_field.frm_right_container{grid-template-columns: auto 25%;}.frm_style_style-formidable.with_frm_style .frm_inline_container.frm_dynamic_select_container .frm_data_container,.frm_style_style-formidable.with_frm_style .frm_inline_container.frm_dynamic_select_container .frm_opt_container{display:inline;}.frm_style_style-formidable.with_frm_style .frm_pos_right{display:inline;width:150px;}.frm_style_style-formidable.with_frm_style .frm_none_container .frm_primary_label,.frm_style_style-formidable.with_frm_style .frm_pos_none{display:none;}.frm_style_style-formidable.with_frm_style input::placeholder,.frm_style_style-formidable.with_frm_style textarea::placeholder{color: #A1A1A1;}.frm_style_style-formidable.with_frm_style input::-webkit-input-placeholder,.frm_style_style-formidable.with_frm_style textarea::-webkit-input-placeholder{color: #A1A1A1;}.frm_style_style-formidable.with_frm_style input::-moz-placeholder,.frm_style_style-formidable.with_frm_style textarea::-moz-placeholder{color: #A1A1A1;opacity: 1;}.frm_style_style-formidable.with_frm_style input:-ms-input-placeholder,frm_style_style-formidable.with_frm_style textarea:-ms-input-placeholder{color: #A1A1A1;}.frm_style_style-formidable.with_frm_style .frm_default,.frm_style_style-formidable.with_frm_style input.frm_default,.frm_style_style-formidable.with_frm_style textarea.frm_default,.frm_style_style-formidable.with_frm_style select.frm_default,.frm_style_style-formidable.with_frm_style .placeholder,.frm_style_style-formidable.with_frm_style .chosen-container-multi .chosen-choices li.search-field .default,.frm_style_style-formidable.with_frm_style .chosen-container-single .chosen-default{color: #A1A1A1;}.frm_style_style-formidable.with_frm_style .form-field input:not([type=file]):focus,.frm_style_style-formidable.with_frm_style select:focus,.frm_style_style-formidable.with_frm_style textarea:focus,.frm_style_style-formidable.with_frm_style .frm_focus_field input[type=text],.frm_style_style-formidable.with_frm_style .frm_focus_field input[type=password],.frm_style_style-formidable.with_frm_style .frm_focus_field input[type=email],.frm_style_style-formidable.with_frm_style .frm_focus_field input[type=number],.frm_style_style-formidable.with_frm_style .frm_focus_field input[type=url],.frm_style_style-formidable.with_frm_style .frm_focus_field input[type=tel],.frm_style_style-formidable.with_frm_style .frm_focus_field input[type=search],.frm_form_fields_active_style,.frm_style_style-formidable.with_frm_style .frm_focus_field .frm-card-element.StripeElement,.frm_style_style-formidable.with_frm_style .chosen-container-single.chosen-container-active .chosen-single,.frm_style_style-formidable.with_frm_style .chosen-container-active .chosen-choices{background-color:#ffffff;border-color:#66afe9;color: var(--text-color);box-shadow:0 1px 1px rgba(0, 0, 0, 0.075) inset, 0 0 8px rgba(102,175,233, 0.6);}.frm_style_style-formidable.with_frm_style .frm_compact .frm_dropzone.dz-clickable .dz-message,.frm_style_style-formidable.with_frm_style input[type=submit],.frm_style_style-formidable.with_frm_style .frm_submit input[type=button],.frm_style_style-formidable.with_frm_style .frm_submit button,.frm_form_submit_style,.frm_style_style-formidable.with_frm_style .frm-edit-page-btn {width:auto;font-size:15px;height:auto;line-height:normal;text-align:center;background:#579AF6;border-width:1px;border-color: #579AF6;border-style:solid;color:#ffffff;cursor:pointer;font-weight:normal;border-radius:4px;text-shadow:none;padding:10px 20px;box-sizing:border-box;-ms-box-sizing:border-box;box-shadow:0 1px 1px #eeeeee;margin:10px;margin-left:0;margin-right:0;vertical-align:middle;}.frm_style_style-formidable.with_frm_style .frm_compact .frm_dropzone.dz-clickable .dz-message{margin:0;}.frm_style_style-formidable.with_frm_style .frm-edit-page-btn:hover,.frm_style_style-formidable.with_frm_style input[type=submit]:hover,.frm_style_style-formidable.with_frm_style .frm_submit input[type=button]:hover,.frm_style_style-formidable.with_frm_style .frm_submit button:hover{background: #efefef;border-color: #cccccc;color: #444444;}.frm_style_style-formidable.with_frm_style.frm_center_submit .frm_submit .frm_ajax_loading{margin-bottom:10px;}.frm_style_style-formidable.with_frm_style .frm-edit-page-btn:focus,.frm_style_style-formidable.with_frm_style input[type=submit]:focus,.frm_style_style-formidable.with_frm_style .frm_submit input[type=button]:focus,.frm_style_style-formidable.with_frm_style .frm_submit button:focus,.frm_style_style-formidable.with_frm_style input[type=submit]:active,.frm_style_style-formidable.with_frm_style .frm_submit input[type=button]:active,.frm_style_style-formidable.with_frm_style .frm_submit button:active{background: #efefef;border-color: #cccccc;color: #444444;outline: none;}.frm_style_style-formidable.with_frm_style .frm_loading_prev .frm_prev_page,.frm_style_style-formidable.with_frm_style .frm_loading_prev .frm_prev_page:hover,.frm_style_style-formidable.with_frm_style .frm_loading_prev .frm_prev_page:active,.frm_style_style-formidable.with_frm_style .frm_loading_prev .frm_prev_page:focus,.frm_style_style-formidable.with_frm_style .frm_loading_form .frm_button_submit,.frm_style_style-formidable.with_frm_style .frm_loading_form .frm_button_submit:hover,.frm_style_style-formidable.with_frm_style .frm_loading_form .frm_button_submit:active,.frm_style_style-formidable.with_frm_style .frm_loading_form .frm_button_submit:focus{color: transparent ;background: #579AF6;}.frm_style_style-formidable.with_frm_style .frm_loading_prev .frm_prev_page:before,.frm_style_style-formidable.with_frm_style .frm_loading_form .frm_button_submit:before {border-bottom-color: #ffffff;border-right-color: #ffffff;}.frm_style_style-formidable.with_frm_style.frm_inline_top .frm_submit::before,.frm_style_style-formidable.with_frm_style .frm_submit.frm_inline_submit::before {content:"before";font-size:15px;color:#3f4b5b;font-weight:normal;margin:0;padding:0 0 3px 0;width:auto;display:block;visibility:hidden;}.frm_style_style-formidable.with_frm_style.frm_inline_form .frm_submit input,.frm_style_style-formidable.with_frm_style.frm_inline_form .frm_submit button,.frm_style_style-formidable.with_frm_style .frm_submit.frm_inline_submit input,.frm_style_style-formidable.with_frm_style .frm_submit.frm_inline_submit button {margin: 0 !important;}.frm_style_style-formidable.with_frm_style #frm_field_cptch_number_container{font-size:15px;color:#3f4b5b;font-weight:normal;clear:both;}.frm_style_style-formidable.with_frm_style .frm_blank_field input[type=text],.frm_style_style-formidable.with_frm_style .frm_blank_field input[type=password],.frm_style_style-formidable.with_frm_style .frm_blank_field input[type=url],.frm_style_style-formidable.with_frm_style .frm_blank_field input[type=tel],.frm_style_style-formidable.with_frm_style .frm_blank_field input[type=number],.frm_style_style-formidable.with_frm_style .frm_blank_field input[type=email],.frm_style_style-formidable.with_frm_style .frm_blank_field textarea,.frm_style_style-formidable.with_frm_style .frm_blank_field .mce-edit-area iframe,.frm_style_style-formidable.with_frm_style .frm_blank_field select:not(.ui-datepicker-month):not(.ui-datepicker-year),.frm_form_fields_error_style,.frm_style_style-formidable.with_frm_style .frm_blank_field .frm-g-recaptcha iframe,.frm_style_style-formidable.with_frm_style .frm_blank_field .g-recaptcha iframe,.frm_style_style-formidable.with_frm_style .frm_blank_field .frm-card-element.StripeElement,.frm_style_style-formidable.with_frm_style .frm_blank_field .chosen-container-multi .chosen-choices,.frm_style_style-formidable.with_frm_style .frm_blank_field .chosen-container-single .chosen-single,.frm_style_style-formidable.with_frm_style .frm_form_field :invalid{color:#444444;background-color:#ffffff;border-color:#B94A48;border-width:1px;border-style:solid;}.frm_style_style-formidable.with_frm_style .frm_blank_field .sigWrapper{border-color:#B94A48 !important;}.frm_style_style-formidable.with_frm_style .frm_error,.frm_style_style-formidable.with_frm_style .frm_limit_error{font-weight:normal;}.frm_style_style-formidable.with_frm_style .frm_blank_field label,.frm_style_style-formidable.with_frm_style .frm_error,.frm_style_style-formidable.with_frm_style .frm_limit_error{color:#B94A48;}.frm_style_style-formidable.with_frm_style .frm_error_style{background-color:#F2DEDE;border:1px solid #EBCCD1;border-radius:4px;color: #B94A48;font-size:14px;margin:0;margin-bottom:20px;}.frm_style_style-formidable.with_frm_style #frm_loading .progress-striped .progress-bar{background-image:linear-gradient(45deg, #BFC3C8 25%, rgba(0, 0, 0, 0) 25%, rgba(0, 0, 0, 0) 50%, #BFC3C8 50%, #BFC3C8 75%, rgba(0, 0, 0, 0) 75%, rgba(0, 0, 0, 0));}.frm_style_style-formidable.with_frm_style #frm_loading .progress-bar{background-color:#ffffff;}.frm_style_style-formidable.with_frm_style .frm_form_field.frm_total_big input,.frm_style_style-formidable.with_frm_style .frm_form_field.frm_total_big textarea,.frm_style_style-formidable.with_frm_style .frm_form_field.frm_total input,.frm_style_style-formidable.with_frm_style .frm_form_field.frm_total textarea{color: #555555;background-color:transparent;border:none;display:inline;width:auto;padding:0;}.frm_ajax_loading{visibility:hidden;width:auto;}.frm_form_submit_style{height:auto;}a.frm_save_draft{cursor:pointer;}.with_frm_style a.frm_save_draft,.with_frm_style a.frm_start_over{font-size:15px;font-size:var(--submit-font-size);font-weight:normal;font-weight:var(--submit-weight);}.horizontal_radio .frm_radio{margin:0 5px 0 0;}.horizontal_radio .frm_checkbox{margin:0;margin-right:5px;}.vertical_radio .frm_checkbox,.vertical_radio .frm_radio,.vertical_radio .frm_catlevel_1{display:block;}.horizontal_radio .frm_checkbox,.horizontal_radio .frm_radio,.horizontal_radio .frm_catlevel_1{display:inline-block;padding-left: 0;}.with_frm_style .frm_radio{display:block;display:var(--radio-align);}.with_frm_style .frm_checkbox{display:block;display:var(--check-align);}.with_frm_style .vertical_radio .frm_checkbox,.with_frm_style .vertical_radio .frm_radio,.vertical_radio .frm_catlevel_1{display:block;}.with_frm_style .horizontal_radio .frm_checkbox,.with_frm_style .horizontal_radio .frm_radio,.horizontal_radio .frm_catlevel_1{display:inline-block;}.with_frm_style .frm_checkbox label,.with_frm_style .frm_radio label{display: inline;white-space:normal;}.with_frm_style .vertical_radio .frm_checkbox label,.with_frm_style .vertical_radio .frm_radio label{display: block;padding-left: 20px;text-indent: -20px;}.with_frm_style .frm_radio label,.with_frm_style .frm_checkbox label{font-size:13px;font-size:var(--check-font-size);color:#444444;color:var(--check-label-color);font-weight:normal;font-weight:var(--check-weight);line-height: 1.3;}.with_frm_style .frm_radio input[type=radio],.with_frm_style .frm_checkbox input[type=checkbox] {font-size:13px;font-size:var(--check-font-size);position:static;}.frm_file_container .frm_file_link,.with_frm_style .frm_radio label .frm_file_container,.with_frm_style .frm_checkbox label .frm_file_container{display:inline-block;margin:5px;vertical-align:middle;}.with_frm_style .frm_radio input[type=radio]{border-radius:50%;}.with_frm_style .frm_checkbox input[type=checkbox]{border-radius:0;}.with_frm_style .frm_radio input[type=radio],.with_frm_style .frm_checkbox input[type=checkbox]{appearance: none;background-color: var(--bg-color);flex: none;display:inline-block !important;margin: 0 5px 0 0;color: var(--border-color);width: 18px;min-width: 18px;height: 18px;border: 1px solid currentColor;border-color: var(--border-color);vertical-align: middle;position: initial; padding: 0;}.with_frm_style .frm_radio input[type=radio]:before,.with_frm_style .frm_checkbox input[type=checkbox]:before {content: \'\';width: 12px;height: 12px;border-radius: 50%;transform: scale(0);transition: 120ms transform ease-in-out;box-shadow: inset 10px 10px var(--text-color);display: block;margin: 2px 0 0 2px;}.with_frm_style .frm_checkbox input[type=checkbox]:before{clip-path: polygon(14% 44%, 0 65%, 50% 100%, 100% 16%, 80% 0%, 43% 62%);border-radius: 0;}.with_frm_style .frm_radio input[type=radio]:checked:before,.with_frm_style .frm_checkbox input[type=checkbox]:checked:before {transform: scale(1);}.with_frm_style :invalid,.with_frm_style :-moz-submit-invalid,.with_frm_style :-moz-ui-invalid{box-shadow:none;}.with_frm_style .frm_error_style img{padding-right:10px;vertical-align:middle;border:none;}.with_frm_style .frm_trigger{cursor:pointer;}.with_frm_style .frm_error_style,.with_frm_style .frm_message,.frm_success_style{border-radius:4px;padding:15px;}.with_frm_style .frm_message p{margin-bottom:5px;color:#468847;color:var(--success-text-color);}.with_frm_style .frm_message,.frm_success_style{margin:5px 0 15px;border:1px solid #D6E9C6;border-color:var(--success-border-color);background-color:#DFF0D8;background-color:var(--success-bg-color);color:#468847;color:var(--success-text-color);border-radius:4px;border-radius:var(--border-radius);font-size:14px;font-size:var(--success-font-size);}.with_frm_style .frm_plain_success .frm_message {background-color: transparent;padding:0;border:none;font-size:inherit;color:inherit;}.with_frm_style .frm_plain_success .frm_message p {color:inherit;}.frm_form_fields_style,.frm_form_fields_active_style,.frm_form_fields_error_style,.frm_form_submit_style{width:auto;}.with_frm_style .frm_trigger span{float:left;}.with_frm_style table.frm-grid,#content .with_frm_style table.frm-grid{border-collapse:collapse;border:none;}.frm-grid td,.frm-grid th{padding:5px;border-width:1px;border-style:solid;border-color:#BFC3C8;border-color:var(--border-color);border-top:none;border-left:none;border-right:none;}.frm-alt-table {width:100%;border-collapse:separate;margin-top:0.5em;font-size:15px;border-width:1px;}.with_frm_style .frm-alt-table{border-color:#BFC3C8;border-color:var(--border-color);}.frm-alt-table th {width:200px;}.frm-alt-table tr {background-color:transparent;}.frm-alt-table th,.frm-alt-table td {background-color:transparent;vertical-align:top;text-align:left;padding:20px;border-color:transparent;}.frm-alt-table tr:nth-child(even) {background-color:#ecf0f5;}table.form_results.with_frm_style{border:1px solid #BFC3C8;border-width:var(--field-border-width);border-color:var(--border-color);}table.form_results.with_frm_style tr td{text-align:left;padding:7px 9px;color:#555555;color:var(--text-color);border-top:1px solid #BFC3C8;border-top-width:var(--field-border-width);border-top-color:var(--border-color);}table.form_results.with_frm_style tr.frm_even,.frm-grid .frm_even{background-color:#fff;background-color:var(--bg-color);}table.form_results.with_frm_style tr.frm_odd,.frm-grid .frm_odd{background-color:#ffffff;background-color:var(--bg-color);}.frm_color_block {background-color:#ecf0f5;padding: 40px;}.with_frm_style .frm-show-form .frm_color_block.frm_section_heading h3,.frm_color_block.frm_section_heading h3 {border-width: 0 !important;}.frm_collapse .ui-icon{display:inline-block;}.frm_toggle_container{border:1px solid transparent;}.frm_toggle_container ul{margin:5px 0;padding-left:0;list-style-type:none;}.frm_toggle_container .frm_month_heading{text-indent:15px;}.frm_toggle_container .frm_month_listing{margin-left:40px;}#frm_loading{display:none;position:fixed;top:0;left:0;width:100%;height:100%;z-index:99999;}#frm_loading h3{font-weight:500;padding-bottom:15px;color:#fff;font-size:24px;}#frm_loading_content{position:fixed;top:20%;left:33%;width:33%;text-align:center;padding-top:30px;font-weight:bold;z-index:9999999;}#frm_loading img{max-width:100%;}#frm_loading .progress{border-radius:4px;box-shadow:0 1px 2px rgba(0, 0, 0, 0.1) inset;height:20px;margin-bottom:20px;overflow:hidden;}#frm_loading .progress.active .progress-bar{animation:2s linear 0s normal none infinite progress-bar-stripes;}#frm_loading .progress-striped .progress-bar{background-image:linear-gradient(45deg, #BFC3C8 25%, rgba(0, 0, 0, 0) 25%, rgba(0, 0, 0, 0) 50%, #BFC3C8 50%, #BFC3C8 75%, rgba(0, 0, 0, 0) 75%, rgba(0, 0, 0, 0));background-size:40px 40px;}#frm_loading .progress-bar{background-color:#ffffff;background-color:var(--bg-color);box-shadow:0 -1px 0 rgba(0, 0, 0, 0.15) inset;float:left;height:100%;line-height:20px;text-align:center;transition:width 0.6s ease 0s;width:100%;}.frm_image_from_url{height:50px;}.frm-loading-img{background:url(https://hs.vicq.org/wp-content/plugins/formidable/images/ajax_loader.gif) no-repeat center center;padding:6px 12px;}select.frm_loading_lookup{background-image: url(https://hs.vicq.org/wp-content/plugins/formidable/images/ajax_loader.gif) !important;background-position: 10px;background-repeat: no-repeat;color: transparent !important;}.frm_screen_reader {border: 0;clip: rect(1px, 1px, 1px, 1px);-webkit-clip-path: inset(50%);clip-path: inset(50%);height: 1px;margin: -1px;overflow: hidden;padding: 0;position: absolute;width: 1px;word-wrap: normal !important; }.frm_screen_reader.frm_hidden{display:initial;}.frm_clear_none{clear:none;}.frm_clear{clear:both;}.frm_form_field.frm_alignright{float:right !important;}.with_frm_style .frm_form_field{clear:both;}.frm_combo_inputs_container,.frm_grid_container,.frm_form_fields .frm_section_heading,.frm_form_fields .frm_fields_container{display:grid;grid-template-columns: repeat(12, 1fr);grid-auto-rows: max-content;grid-gap: 0 2%;}.frm_combo_inputs_container > *,.frm_grid_container > *,.frm_section_heading > *,.frm_fields_container .frm_form_field,.frm_fields_container > *{grid-column: span 12 / span 12;}.frm_inline,.frm_form_field.frm_left_inline,.frm_form_field.frm_first_inline,.frm_form_field.frm_inline,.frm_submit.frm_inline,.frm_form_field.frm_right_inline,.frm_form_field.frm_last_inline{width:auto;grid-column: span 2 / span 2;}.frm6,.frm_half,.frm_form_field.frm_three_fifths, .frm_form_field.frm6,.frm_submit.frm6,.frm_form_field.frm_left_half,.frm_form_field.frm_right_half,.frm_form_field.frm_first_half,.frm_form_field.frm_last_half,.frm_form_field.frm_half,.frm_submit.frm_half{grid-column:span 6 / span 6;}.frm4,.frm_third,.frm_form_field.frm_two_fifths, .frm_form_field.frm4,.frm_submit.frm4,.frm_form_field.frm_left_third,.frm_form_field.frm_third,.frm_submit.frm_third,.frm_form_field.frm_right_third,.frm_form_field.frm_first_third,.frm_form_field.frm_last_third{grid-column:span 4 / span 4;}.frm8,.frm_two_thirds,.frm_form_field.frm8,.frm_submit.frm8,.frm_form_field.frm_left_two_thirds,.frm_form_field.frm_right_two_thirds,.frm_form_field.frm_first_two_thirds,.frm_form_field.frm_last_two_thirds,.frm_form_field.frm_two_thirds{grid-column: span 8/span 8;}.frm3,.frm_fourth,.frm_form_field.frm3,.frm_submit.frm3,.frm_form_field.frm_left_fourth,.frm_form_field.frm_fourth,.frm_submit.frm_fourth,.frm_form_field.frm_right_fourth,.frm_form_field.frm_first_fourth,.frm_form_field.frm_last_fourth{grid-column: span 3/span 3;}.frm9,.frm_three_fourths,.frm_form_field.frm_four_fifths, .frm_form_field.frm9,.frm_submit.frm9,.frm_form_field.frm_three_fourths{grid-column: span 9/span 9;}.frm_form_field.frm_left_fifth,.frm_form_field.frm_fifth,.frm_submit.frm_fifth,.frm_form_field.frm_right_fifth,.frm_form_field.frm_first_fifth,.frm_form_field.frm_last_fifth{grid-column: span 2/span 2;}.frm2,.frm_sixth,.frm_form_field.frm2,.frm_submit.frm2,.frm_form_field.frm_sixth,.frm_submit.frm_sixth,.frm_form_field.frm_first_sixth,.frm_form_field.frm_last_sixth{grid-column: span 2/span 2;}.frm10,.frm_form_field.frm10,.frm_submit.frm10{grid-column: span 10/span 10;}.frm1,.frm_form_field.frm1,.frm_submit.frm1,.frm_form_field.frm_seventh,.frm_submit.frm_seventh,.frm_form_field.frm_first_seventh,.frm_form_field.frm_last_seventh.frm_form_field.frm_eighth,.frm_submit.frm_eighth,.frm_form_field.frm_first_eighth,.frm_form_field.frm_last_eighth{grid-column: span 1/span 1;}.frm5,.frm_form_field.frm5,.frm_submit.frm5{grid-column: span 5/span 5;}.frm7,.frm_form_field.frm7,.frm_submit.frm7{grid-column: span 7/span 7;}.frm11,.frm_form_field.frm11,.frm_submit.frm11{grid-column: span 11/span 11;}.frm12,.frm_full,.frm_full .wp-editor-wrap,.frm_full > input:not([type=\'checkbox\']):not([type=\'radio\']):not([type=\'button\']),.frm_full select,.frm_full textarea{width:100% !important;grid-column: span 12/span 12;box-sizing: border-box;}.frm_full .wp-editor-wrap input{width:auto !important;}.frm_first,.frm_form_field.frm_left_half,.frm_form_field.frm_left_third,.frm_form_field.frm_left_two_thirds,.frm_form_field.frm_left_fourth,.frm_form_field.frm_left_fifth,.frm_form_field.frm_left_inline,.frm_form_field.frm_first_half,.frm_form_field.frm_first_third,.frm_form_field.frm_first_two_thirds,.frm_form_field.frm_first_fourth,.frm_form_field.frm_first_fifth,.frm_form_field.frm_first_sixth,.frm_form_field.frm_first_seventh,.frm_form_field.frm_first_eighth,.frm_form_field.frm_first_inline,.frm_form_field.frm_first{grid-column-start:1;}.frm_last,.frm_form_field.frm_last,.frm_form_field.frm_alignright{grid-column-end:-1;justify-content: end;}.with_frm_style.frm_rtl .frm_form_fields .star-rating{float:right;}.with_frm_style.frm_rtl .frm_grid .frm_primary_label,.with_frm_style.frm_rtl .frm_grid_first .frm_primary_label,.with_frm_style.frm_rtl .frm_grid_odd .frm_primary_label,.with_frm_style.frm_rtl .frm_grid .frm_radio,.with_frm_style.frm_rtl .frm_grid_first .frm_radio,.with_frm_style.frm_rtl .frm_grid_odd .frm_radio,.with_frm_style.frm_rtl .frm_grid .frm_checkbox,.with_frm_style.frm_rtl .frm_grid_first .frm_checkbox,.with_frm_style.frm_rtl .frm_grid_odd .frm_checkbox{float:right !important;margin-right:0 !important;}.with_frm_style.frm_rtl .frm_grid_first .frm_radio label input,.with_frm_style.frm_rtl .frm_grid .frm_radio label input,.with_frm_style.frm_rtl .frm_grid_odd .frm_radio label input,.with_frm_style.frm_rtl .frm_grid_first .frm_checkbox label input,.with_frm_style.frm_rtl .frm_grid .frm_checkbox label input,.with_frm_style.frm_rtl .frm_grid_odd .frm_checkbox label input{float:left;}.with_frm_style.frm_rtl .frm_catlevel_2,.with_frm_style.frm_rtl .frm_catlevel_3,.with_frm_style.frm_rtl .frm_catlevel_4,.with_frm_style.frm_rtl .frm_catlevel_5{margin-right:18px;}.with_frm_style.frm_rtl div > .frm_time_select{margin-right:5px;}.frm_form_field.frm_inline_container,.frm_form_field.frm_right_container,.frm_form_field.frm_left_container{display: grid;grid-template-columns: 25% auto;width:100%;grid-auto-rows: min-content;}.frm_form_field.frm_right_container{grid-template-columns: auto 25%;}.frm_form_field.frm_inline_container{grid-template-columns: repeat(2, minmax(auto, max-content) );}.frm_form_field.frm_inline_container .frm_primary_label,.frm_form_field.frm_right_container .frm_primary_label,.frm_form_field.frm_left_container .frm_primary_label{margin-right:10px;grid-row:span 2/span 2;padding-top:4px;}.frm_form_field.frm_left_container .frm_primary_label{grid-column:1;grid-row:span 2/span 2; }.frm_form_field.frm_right_container .frm_primary_label{grid-column:2;grid-row:1;margin-right:0;margin-left:10px;}.frm_form_field.frm_inline_container .frm_description,.frm_form_field.frm_left_container .frm_description{grid-column:2;}.frm_form_field.frm_right_container .frm_description{grid-column:1;}.frm_conf_field.frm_left_container{grid-template-columns: 67%;}.frm_conf_field.frm_left_container .frm_description{grid-column:1;}.frm-fade-in {animation-name: fadeIn;animation-duration: 1s;animation-fill-mode: both;}@keyframes spin {0% { transform: rotate(0deg); }100% { transform: rotate(360deg); }}@keyframes fadeIn {   0% {opacity: 0;}   100% {opacity: 1;}}@media only screen and (max-width: 750px) {.frm_grid_container.frm_no_grid_750 > div{grid-column: span 12/span 12;}}@media only screen and (max-width: 600px) {.frm_section_heading > .frm_form_field,.frm_fields_container > .frm_submit,.frm_grid_container > .frm_form_field,.frm_fields_container > .frm_form_field{grid-column: 1 / span 12 !important;}.frm_grid_container.frm_no_grid_600,.frm_form_field.frm_inline_container,.frm_form_field.frm_right_container,.frm_form_field.frm_left_container{display:block;}}.frm_conf_field.frm_left_container .frm_primary_label{display:none;}.wp-editor-wrap *,.wp-editor-wrap *:after,.wp-editor-wrap *:before{box-sizing:content-box;}.with_frm_style .frm_grid,.with_frm_style .frm_grid_first,.with_frm_style .frm_grid_odd{clear:both;margin-bottom:0 !important;padding:5px;border-width:1px;border-style:solid;border-color:#BFC3C8;border-color:var(--border-color);border-left:none;border-right:none;}.with_frm_style .frm_grid,.with_frm_style .frm_grid_odd{border-top:none;}.frm_grid .frm_error,.frm_grid_first .frm_error,.frm_grid_odd .frm_error,.frm_grid .frm_limit_error,.frm_grid_first .frm_limit_error,.frm_grid_odd .frm_limit_error{display:none;}.frm_grid:after,.frm_grid_first:after,.frm_grid_odd:after{visibility:hidden;display:block;font-size:0;content:" ";clear:both;height:0;}.frm_grid_first{margin-top:20px;}.frm_grid_first,.frm_grid_odd{background-color:#ffffff;background-color:var(--bg-color);}.frm_grid{background-color:#ffffff;background-color:var(--bg-color-active);}.with_frm_style .frm_grid.frm_blank_field,.with_frm_style .frm_grid_first.frm_blank_field,.with_frm_style .frm_grid_odd.frm_blank_field{background-color:#F2DEDE;background-color:var(--error-bg);border-color:#EBCCD1;border-color:var(--error-bg);}.frm_grid .frm_primary_label,.frm_grid_first .frm_primary_label,.frm_grid_odd .frm_primary_label,.frm_grid .frm_radio,.frm_grid_first .frm_radio,.frm_grid_odd .frm_radio,.frm_grid .frm_checkbox,.frm_grid_first .frm_checkbox,.frm_grid_odd .frm_checkbox{float:left !important;display:block;margin-top:0;margin-left:0 !important;}.frm_grid_first .frm_radio label,.frm_grid .frm_radio label,.frm_grid_odd .frm_radio label,.frm_grid_first .frm_checkbox label,.frm_grid .frm_checkbox label,.frm_grid_odd .frm_checkbox label{visibility:hidden;white-space:nowrap;text-align:left;}.frm_grid_first .frm_radio label input,.frm_grid .frm_radio label input,.frm_grid_odd .frm_radio label input,.frm_grid_first .frm_checkbox label input,.frm_grid .frm_checkbox label input,.frm_grid_odd .frm_checkbox label input{visibility:visible;margin:2px 0 0;float:right;}.frm_grid .frm_radio,.frm_grid_first .frm_radio,.frm_grid_odd .frm_radio,.frm_grid .frm_checkbox,.frm_grid_first .frm_checkbox,.frm_grid_odd .frm_checkbox{display:inline;}.frm_grid_2 .frm_radio,.frm_grid_2 .frm_checkbox,.frm_grid_2 .frm_primary_label{width:48% !important;}.frm_grid_2 .frm_radio,.frm_grid_2 .frm_checkbox{margin-right:4%;}.frm_grid_3 .frm_radio,.frm_grid_3 .frm_checkbox,.frm_grid_3 .frm_primary_label{width:30% !important;}.frm_grid_3 .frm_radio,.frm_grid_3 .frm_checkbox{margin-right:3%;}.frm_grid_4 .frm_radio,.frm_grid_4 .frm_checkbox{width:20% !important;}.frm_grid_4 .frm_primary_label{width:28% !important;}.frm_grid_4 .frm_radio,.frm_grid_4 .frm_checkbox{margin-right:4%;}.frm_grid_5 .frm_primary_label,.frm_grid_7 .frm_primary_label{width:24% !important;}.frm_grid_5 .frm_radio,.frm_grid_5 .frm_checkbox{width:17% !important;margin-right:2%;}.frm_grid_6 .frm_primary_label{width:25% !important;}.frm_grid_6 .frm_radio,.frm_grid_6 .frm_checkbox{width:14% !important;margin-right:1%;}.frm_grid_7 .frm_primary_label{width:22% !important;}.frm_grid_7 .frm_radio,.frm_grid_7 .frm_checkbox{width:12% !important;margin-right:1%;}.frm_grid_8 .frm_primary_label{width:23% !important;}.frm_grid_8 .frm_radio,.frm_grid_8 .frm_checkbox{width:10% !important;margin-right:1%;}.frm_grid_9 .frm_primary_label{width:20% !important;}.frm_grid_9 .frm_radio,.frm_grid_9 .frm_checkbox{width:9% !important;margin-right:1%;}.frm_grid_10 .frm_primary_label{width:19% !important;}.frm_grid_10 .frm_radio,.frm_grid_10 .frm_checkbox{width:8% !important;margin-right:1%;}.frm_form_field.frm_inline_container .frm_opt_container,.frm_form_field.frm_right_container .frm_opt_container,.frm_form_field.frm_left_container .frm_opt_container{padding-top:4px;}.with_frm_style .frm_inline_container.frm_grid_first .frm_primary_label,.with_frm_style .frm_inline_container.frm_grid .frm_primary_label,.with_frm_style .frm_inline_container.frm_grid_odd .frm_primary_label,.with_frm_style .frm_inline_container.frm_grid_first .frm_opt_container,.with_frm_style .frm_inline_container.frm_grid .frm_opt_container,.with_frm_style .frm_inline_container.frm_grid_odd .frm_opt_container{margin-right:0;}.frm_form_field.frm_two_col .frm_opt_container,.frm_form_field.frm_three_col .frm_opt_container,.frm_form_field.frm_four_col .frm_opt_container{display: grid;grid-template-columns: repeat(2, 1fr);grid-auto-rows: max-content;grid-gap: 0 2.5%;}.frm_form_field.frm_three_col .frm_opt_container{grid-template-columns: repeat(3, 1fr);}.frm_form_field.frm_four_col .frm_opt_container{grid-template-columns: repeat(4, 1fr);}.frm_form_field.frm_two_col .frm_radio,.frm_form_field.frm_two_col .frm_checkbox,.frm_form_field.frm_three_col .frm_radio,.frm_form_field.frm_three_col .frm_checkbox,.frm_form_field.frm_four_col .frm_radio,.frm_form_field.frm_four_col .frm_checkbox{grid-column-end: span 1;}.frm_form_field .frm_checkbox,.frm_form_field .frm_checkbox + .frm_checkbox,.frm_form_field .frm_radio,.frm_form_field .frm_radio + .frm_radio{margin-top: 0;margin-bottom: 0;}.frm_form_field.frm_scroll_box .frm_opt_container{height:100px;overflow:auto;}.frm_html_container.frm_scroll_box,.frm_form_field.frm_html_scroll_box{height:100px;overflow:auto;background-color:#ffffff;background-color:var(--bg-color);border-color:#BFC3C8;border-color:var(--border-color);border-width:1px;border-width:var(--field-border-width);border-style:solid;border-style:var(--field-border-style);border-radius:4px;border-radius:var(--border-radius);width:100%;width:var(--field-width);max-width:100%;font-size:14px;font-size:var(--field-font-size);padding:6px 10px;padding:var(--field-pad);box-sizing:border-box;outline:none;font-weight:normal;box-shadow:var(--box-shadow);}.frm_form_field.frm_total_big input,.frm_form_field.frm_total_big textarea,.frm_form_field.frm_total input,.frm_form_field.frm_total textarea{opacity:1;background-color:transparent !important;border:none !important;font-weight:bold;width:auto !important;height:auto !important;box-shadow:none !important;display:inline;-moz-appearance:textfield;padding:0;}.frm_form_field.frm_total_big input::-webkit-outer-spin-button,.frm_form_field.frm_total_big input::-webkit-inner-spin-button,.frm_form_field.frm_total input::-webkit-outer-spin-button,.frm_form_field.frm_total input::-webkit-inner-spin-button {-webkit-appearance: none;}.frm_form_field.frm_total_big input:focus,.frm_form_field.frm_total_big textarea:focus,.frm_form_field.frm_total input:focus,.frm_form_field.frm_total textarea:focus{background-color:transparent;border:none;box-shadow:none;}.frm_form_field.frm_label_justify .frm_primary_label{text-align:justify !important;}.frm_form_field.frm_capitalize input,.frm_form_field.frm_capitalize select,.frm_form_field.frm_capitalize .frm_opt_container label{text-transform:capitalize;}.frm_clearfix:after{content:".";display:block;clear:both;visibility:hidden;line-height:0;height:0;}.frm_clearfix{display:block;}.with_frm_style .frm_repeat_sec .frm_form_field.frm_repeat_buttons .frm_icon_font::before {color:#ffffff;color:var(--repeat-icon-color);}.with_frm_style .frm_combo_inputs_container > .frm_form_subfield-first,.with_frm_style .frm_combo_inputs_container > .frm_form_subfield-middle,.with_frm_style .frm_combo_inputs_container > .frm_form_subfield-last {margin-bottom: 0 !important;}@media only screen and (max-width: 900px) {.frm_form_field .frm_repeat_grid .frm_form_field.frm_sixth .frm_primary_label,.frm_form_field .frm_repeat_grid .frm_form_field.frm_seventh .frm_primary_label,.frm_form_field .frm_repeat_grid .frm_form_field.frm_eighth .frm_primary_label{display: block !important;}}@media only screen and (max-width: 600px) {.frm_form_field.frm_four_col .frm_opt_container{grid-template-columns: repeat(2, 1fr);}.with_frm_style .frm_repeat_inline,.with_frm_style .frm_repeat_grid{margin: 20px 0;}}@media only screen and (max-width: 500px) {.frm_form_field.frm_two_col .frm_radio,.frm_form_field.frm_two_col .frm_checkbox,.frm_form_field.frm_three_col .frm_radio,.frm_form_field.frm_three_col .frm_checkbox{width: auto;margin-right: 0;float: none;display:block;}.frm_form_field input[type=file] {max-width:220px;}.with_frm_style .frm-g-recaptcha > div > div,.with_frm_style .g-recaptcha > div > div{width:inherit !important;display:block;overflow:hidden;max-width:302px;border-right:1px solid #d3d3d3;border-radius:4px;box-shadow:2px 0px 4px -1px rgba(0,0,0,.08);-moz-box-shadow:2px 0px 4px -1px rgba(0,0,0,.08);}.with_frm_style .g-recaptcha iframe,.with_frm_style .frm-g-recaptcha iframe{width:100%;}}','no');
INSERT INTO `hs_options` VALUES (5915,'frm_addons_l','a:3:{s:7:"timeout";i:1717677136;s:5:"value";s:114298:"{"93790":{"title":"Formidable Pro","name":"Formidable Pro","display_name":"Formidable Pro","slug":"formidable-pro","version":"6.10","new_version":"6.10","location":["fp.strategy11.com\\/releases\\/formidable-pro-6.10.zip"],"excerpt":"","id":93790,"released":"2010-02-01 16:27:26","categories":["Basic","Strategy11"],"docs":"","link":"https:\\/\\/formidableforms.com\\/downloads\\/formidable-pro\\/","changelog":"<h4>v6.10 - May 29, 2024<\\/h4>\\n<ul>\\n<li>New: Field selection data is now stored in memory and reused when determining available fields, significantly improving the time to load the form builder for forms with a lot of fields.<\\/li>\\n<li>Fix: Bulk deleting entries would result in a 404 error because of an invalid redirect introduced in last release.<\\/li>\\n<li>Fix: Custom filtering would break when trying to use the frm_filter_where_val filter to filter for multiple date values.<\\/li>\\n<li>Fix: Page turn transition settings would get unset after saving form settings.<\\/li>\\n<li>Fix: International phone field CSS has been updated to prevent an issue with broken links to flag images resulting in 404 errors.<\\/li>\\n<li>Fix: The way uploaded file names are determined has been updated to improve compatibility with all locale types.<\\/li>\\n<li>Some polyfill code for supporting Internet Explorer has been removed, helping to reduce the size of front end scripts.<\\/li>\\n<\\/ul>\\n<h4>v6.9.2 - May 8, 2024<\\/h4>\\n<ul>\\n<li>Fix: A bug in version 6.9.1 caused Views blocks to not render properly in the Gutenberg editor.<\\/li>\\n<\\/ul>\\n<h4>v6.9.1 - May 1, 2024<\\/h4>\\n<ul>\\n<li>New: Field option data for conditional logic is now stored in memory and reused in order to significantly improve performance in the form builder for forms with a lot of conditional logic.<\\/li>\\n<li>New: A checkbox has been added when deleting all entries. By default, when deleting all entries, \\"Entry was successfully deleted\\" events would only trigger when a form has a post action. Now, when the form has no post action, the event will trigger when this checkbox is selected.<\\/li>\\n<li>New: Embedded fields can now be used in conditional logic for form actions.<\\/li>\\n<li>Fix: Styling issues have been fixed for Slim Select dropdowns with before\\/after input settings defined.<\\/li>\\n<li>Fix: Submit buttons were not displaying Update labels when editing an entry.<\\/li>\\n<li>Fix: JS validation for phone fields using the international format option would pass for incomplete numbers. Previously there were issues with false positive validation errors triggering before auto-formatting changes.<\\/li>\\n<li>Fix: Phone fields using the international format option were not initializing on multiple page forms with AJAX submit enabled.<\\/li>\\n<li>Fix: A conflict with Memberpress has been fixed that would trigger JavaScript errors when signing up on forms with phone fields when a Formidable form was also on the page.<\\/li>\\n<li>Fix: Pagination and submit button conditional logic settings would get unset after saving changes on the form settings page.<\\/li>\\n<li>Fix: The Application column on the forms and views list pages would still display when hidden based on screen options.<\\/li>\\n<li>Fix: A Uncaught TypeError: strpos PHP Fatal error on rich text field display for unexpected array values has been fixed.<\\/li>\\n<li>Fix: Filters would not work for &#091;frm-stats] shortcodes when filtering with a field ID value between 1 and 10.<\\/li>\\n<li>Fix: Rootline settings were not saving properly when saving the form with AJAX is enabled.<\\/li>\\n<li>Fix: &#091;frm-field-value] shortcodes were not working as expected for checkbox field default values.<\\/li>\\n<\\/ul>\\n","plugin":"formidable-pro\\/formidable-pro.php","icons":{"1x":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png"},"banners":{"high":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png","low":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-772x250.png"},"search_terms":"","is_new":false},"163248":{"title":"Signature","name":"Signature","display_name":"Digital Signatures","slug":"signature","version":"3.0.4","new_version":"3.0.4","location":["fp.strategy11.com\\/releases\\/formidable-signature\\/formidable-signature-3.0.4.zip"],"excerpt":"Add an electronic signature to your WordPress form. The visitor may write their signature with a trackpad\\/mouse or type it.","id":163248,"released":"2013-03-04 00:00:00","categories":["Business","Strategy11"],"docs":"\\/knowledgebase\\/formidable-signature\\/","link":"https:\\/\\/formidableforms.com\\/downloads\\/signature\\/","changelog":"<h4>v3.0.4 - March 28, 2024<\\/h4>\\n<ul>\\n<li>New: The way CSS is added has been updated for better compatibility with the Snuffleupagus security module.<\\/li>\\n<li>Fix: Scripts were not properly initializing when editing a form with a signature field in-place using the &#091;editlink] shortcode.<\\/li>\\n<li>Fix: Form validation would trigger on signature draw events, causing error messages to appear on other fields early.<\\/li>\\n<li>Fix: An Uncaught Error: Call to undefined method FrmProFieldDefault::get_signature_image_dimension fatal error has been fixed.<\\/li>\\n<li>Front end signature field icons have been updated to no longer use font icons.<\\/li>\\n<\\/ul>\\n<h4>v3.0.3 - June 15, 2023<\\/h4>\\n<ul>\\n<li>New: Added support for a new show=url shortcode option for signature fields.<\\/li>\\n<li>Fix: Icons were not aligning properly for some button size style settings.<\\/li>\\n<li>Fix: Signature fields would overflow when some field size style settings were applied.<\\/li>\\n<\\/ul>\\n<h4>v3.0.2 - January 11, 2023<\\/h4>\\n<ul>\\n<li>Security: Added validation to signature URLs to guarantee the signature data is coming from a trusted source with the proper expected format.<\\/li>\\n<\\/ul>\\n","plugin":"formidable-signature\\/signature.php","icons":{"1x":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png"},"banners":{"high":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png","low":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png"},"search_terms":"","is_new":false},"163255":{"title":"Math Captcha","name":"Math Captcha","display_name":"Math Captcha","slug":"math-captcha","version":"1.15","new_version":"1.15","location":["fp.strategy11.com\\/releases\\/formidable-math-captcha\\/formidable-math-captcha-1.15.zip"],"excerpt":"","id":163255,"released":"2015-10-12 14:00:35","categories":[],"docs":"","link":"https:\\/\\/formidableforms.com\\/downloads\\/math-captcha\\/","changelog":"","plugin":"math-captcha\\/math-captcha.php","icons":{"1x":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png"},"banners":{"high":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png","low":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png"},"search_terms":"","is_new":false},"163257":{"title":"PayPal Standard","name":"PayPal Standard","display_name":"PayPal Standard","slug":"paypal-standard","version":"3.09","new_version":"3.09","location":["fp.strategy11.com\\/releases\\/formidable-paypal\\/formidable-paypal-3.09.zip"],"excerpt":"Collect instant payments and recurring payments to automate your online business. Calculate a total and send customers on to PayPal.","id":163257,"released":"2012-09-04 00:00:00","categories":["Business","Ecommerce","Strategy11"],"docs":"\\/knowledgebase\\/formidable-paypal\\/","link":"https:\\/\\/formidableforms.com\\/downloads\\/paypal-standard\\/","changelog":"<h4>v3.09 - July 30, 2019<\\/h4>\\n<ul>\\n<li>New: Account for tax when comparing amounts with the IPN<\\/li>\\n<li>Update form action icon and color<\\/li>\\n<li>Replace call to deprecated function with FrmFieldsHelper::get_user_display_name<\\/li>\\n<li>Requires Formidable v3.0+<\\/li>\\n<\\/ul>\\n<h4>v3.08 - November 18, 2017<\\/h4>\\n<ul>\\n<li>Allow field shortcodes in more payments settings so values can be set from the form: PayPal email, trial amount, repeat period, trial length. This also allows payments to go to other members on your site.<\\/li>\\n<li>Allow regular WordPress shortcodes and Formidable dynamic values (ie [email]) in addition to basic field shortcodes<\\/li>\\n<\\/ul>\\n<h4>v3.07 - November 10, 2017<\\/h4>\\n<ul>\\n<li>Process shortcodes in after payment settings. Allow entry values, default values, and other shortcodes.<\\/li>\\n<li>Clarify the payment trigger options with \\"Successful PayPal payment\\"<\\/li>\\n<\\/ul>\\n","plugin":"formidable-paypal\\/formidable-paypal.php","icons":{"1x":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png"},"banners":{"high":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png","low":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png"},"search_terms":"paypal","is_new":false},"168072":{"title":"Formidable API","name":"Formidable API","display_name":"Formidable API","slug":"formidable-api","version":"1.15","new_version":"1.15","location":["fp.strategy11.com\\/releases\\/formidable-api\\/formidable-api-1.15.zip"],"excerpt":"Add a full forms API for forms, form fields, views, and entries. Then send submissions to other sites with REST APIs.","id":168072,"released":"2016-06-08 00:00:00","categories":["Business","Strategy11"],"docs":"\\/knowledgebase\\/formidable-api\\/","link":"https:\\/\\/formidableforms.com\\/downloads\\/formidable-api\\/","changelog":"<h4>v1.15 - February 20, 2024<\\/h4>\\n<ul>\\n<li>New: New stats endpoints have been added. These are used like yoursite.com\\/wp-json\\/frm\\/v2\\/stats\\/{type}\\/{field_id} where type can be any of the type values defined in https:\\/\\/formidableforms.com\\/knowledgebase\\/add-field-totals-and-statistics\\/#kb-required-parameters. This means you can use yoursite.com\\/wp-json\\/frm\\/v2\\/stats\\/maximum\\/{field_id}, yoursite.com\\/wp-json\\/frm\\/v2\\/stats\\/minimum\\/{field_id}, yoursite.com\\/wp-json\\/frm\\/v2\\/stats\\/deviation\\/{field_id}, and more.<\\/li>\\n<li>New: Fields now support PATCH requests for updating a field or for updating multiple fields using the API.<\\/li>\\n<li>New: A frm_api_iframe_use_landing_page_url filter has been added. By default, when using script tags to load a form that requires an iframe, an applicable landing page URL will be used. With this new filter, this can be disabled using add_filter( \'frm_api_iframe_use_landing_page_url\', \'__return_false\' );.<\\/li>\\n<li>Fix: Entries would not get deleted despite having the \\"Do not store entries submitted from this form\\" setting enabled when creating an entry using an API action.<\\/li>\\n<\\/ul>\\n<h4>v1.14 - September 11, 2023<\\/h4>\\n<ul>\\n<li>New: [date] and [user_id] shortcodes are now supported in API actions.<\\/li>\\n<li>New: Fields inside of a repeater are now also deleted when a repeater is deleted through the API endpoint.<\\/li>\\n<li>Fix: A fatal error would happen on front end pages when the Formidable Forms plugin was unavailable.<\\/li>\\n<li>Fix: An undefined array key 1 warning would get logged when trying to make an API request with some invalid header formats.<\\/li>\\n<li>Fix: A fatal error would occur when trying to run migrations when attempting to call a function that doesn\'t exist.<\\/li>\\n<li>Additional validation has been added when deleting a field using an invalid form id.<\\/li>\\n<li>References to old deprecated functions have been updated.<\\/li>\\n<\\/ul>\\n<h4>v1.13 - November 9, 2022<\\/h4>\\n<ul>\\n<li>Fix: API Actions were triggering a \\"Call to a member function has_param\\" fatal error with WordPress 6.1.<\\/li>\\n<li>Fix: Safari browsers were not loading a script in API script iframes as expected, resulting in small iframes without a proper height value set.<\\/li>\\n<\\/ul>\\n","plugin":"formidable-api\\/formidable-api.php","icons":{"1x":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png"},"banners":{"high":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png","low":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png"},"search_terms":"","is_new":false},"168456":{"title":"Upload Importer","name":"Upload Importer","display_name":"Upload Importer","slug":"upload-importer","version":"1.0.01","new_version":"1.0.01","location":["fp.strategy11.com\\/releases\\/formidable-upload-importer\\/formidable-upload-importer-1.0.01.zip"],"excerpt":"","id":168456,"released":"2015-10-16 17:05:47","categories":["Strategy11"],"docs":"","link":"https:\\/\\/formidableforms.com\\/downloads\\/upload-importer\\/","changelog":"<h4>v1.0.01<\\/h4>\\n<ul>\\n<li>Get updates from FormidablePro.com<\\/li>\\n<\\/ul>\\n<h4>v1.0<\\/h4>\\n<ul>\\n<li>Allow importing of multiple file uploads<\\/li>\\n<li>Replace deprecated mime_content_type with fileinfo<\\/li>\\n<li>Update auto-updating<\\/li>\\n<\\/ul>\\n","plugin":"upload-importer\\/upload-importer.php","icons":{"1x":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png"},"banners":{"high":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png","low":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png"},"search_terms":"","is_new":false},"168460":{"title":"Twilio","name":"Twilio","display_name":"Twilio WordPress SMS","slug":"twilio","version":"1.09","new_version":"1.09","location":["fp.strategy11.com\\/releases\\/formidable-twilio\\/formidable-twilio-1.09.zip"],"excerpt":"Allow users to text their votes for polls created by Formidable Forms, or send SMS notifications when entries are submitted or updated.","id":168460,"released":"2014-03-10 00:00:00","categories":["Business","Strategy11"],"docs":"\\/knowledgebase\\/twilio-add-on\\/","link":"https:\\/\\/formidableforms.com\\/downloads\\/twilio\\/","changelog":"<h4>v1.09 - November 2, 2020<\\/h4>\\n<ul>\\n<li>New: Include sending numbers from the linked Twilio account in a dropdown. This makes it much easier to send messages successfully.<\\/li>\\n<li>New: Process the [default-message] when sending in an SMS message.<\\/li>\\n<li>Add more guidance to connect to the Twilio API and show messages in the form action when connecting fails.<\\/li>\\n<li>Fix: Some responses were not getting saved correctly into radio and checkbox fields.<\\/li>\\n<li>Clean up and update the code including removing support for Formidable &lt;2.0.<\\/li>\\n<\\/ul>\\n<h4>v1.08 - January 16, 2017<\\/h4>\\n<ul>\\n<li>Improved: Removed deprecated instructions and screenshot.<\\/li>\\n<li>Improved: Removed deprecated valign attribute from table HTML.<\\/li>\\n<\\/ul>\\n<h4>v1.07 - November 1, 2016<\\/h4>\\n<ul>\\n<li>When an SMS message is received, run validation and respond with a text that includes any error messages<\\/li>\\n<li>When a text is received successfully, respond with the form success message, filtered list like a form does.<\\/li>\\n<li>Allow for the \\"other\\" fields to be filled from a text submission<\\/li>\\n<li>Check if license number is for correct plugin<\\/li>\\n<li>Don\'t try to send messages to a blank number<\\/li>\\n<\\/ul>\\n","plugin":"formidable-twilio\\/formidable-twilio.php","icons":{"1x":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png"},"banners":{"high":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png","low":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png"},"search_terms":"","is_new":false},"168463":{"title":"Bootstrap","name":"Bootstrap","display_name":"Bootstrap","slug":"bootstrap","version":"2.0","new_version":"2.0","location":["fp.strategy11.com\\/releases\\/formidable-bootstrap\\/formidable-bootstrap-2.0.zip"],"excerpt":"Instantly add Bootstrap styling to all your Formidable forms.","id":168463,"released":"2014-08-05 00:00:00","categories":["Creator","Strategy11"],"docs":"\\/knowledgebase\\/formidable-bootstrap\\/","link":"https:\\/\\/formidableforms.com\\/downloads\\/bootstrap\\/","changelog":"<h4>v2.0 - November 30, 2023<\\/h4>\\n<ul>\\n<li>New: This add on now uses Bootstrap 5 (instead of Bootstrap 3). If moving to Bootstrap 5 is causing issues, the option to change back to Bootstrap 3 is available as a dropdown option in Global Settings.<\\/li>\\n<li>New: Admin page labels for Bootstrap settings have been updated for better accessibility.<\\/li>\\n<li>Fix: Radio button options displayed as buttons had too much left padding when using Bootstrap 3.<\\/li>\\n<li>Fix: Too many migration queries were being made when there was no Bootstrap data to migrate.<\\/li>\\n<li>Fix: The ellipses used in pagination containers was appearing as text outside of the pagination when using the Bootstrap add on.<\\/li>\\n<\\/ul>\\n<h4>vv1.03 - January 18, 2021<\\/h4>\\n<ul>\\n<li>This update requires action. After updating, click the link to migrate the old settings.<strong> If you save a form with Bootstrap field options before running this migration, you risk losing those settings.<\\/strong><\\/li>\\n<li>New: Moved Prepend and Append Bootstrap field options to Before Input and After Input.<\\/li>\\n<li>New: Errors are now shown by default and can no longer be turned off<\\/li>\\n<li>New: Improved plugin security<\\/li>\\n<li>New: Added bootstrap CSS file directly into plugin for GDPR compliance<\\/li>\\n<\\/ul>\\n<h4>v1.02.02 - October 9, 2017<\\/h4>\\n<ul>\\n<li>Enhancement: Allow prepend and append options with dropdowns.<\\/li>\\n<\\/ul>\\n","plugin":"formidable-bootstrap\\/formidable-bootstrap.php","icons":{"1x":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png"},"banners":{"high":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png","low":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png"},"search_terms":"","is_new":false},"168468":{"title":"AWeber","name":"AWeber","display_name":"AWeber","slug":"aweber","version":"2.03","new_version":"2.03","location":["fp.strategy11.com\\/releases\\/formidable-aweber\\/formidable-aweber-2.03.zip"],"excerpt":"AWeber is a powerful email marketing service. Subscribe contacts to an AWeber mailing list when they submit your WordPress contact forms.","id":168468,"released":"2013-11-26 00:00:00","categories":["Creator","Marketing","Strategy11"],"docs":"\\/knowledgebase\\/formidable-aweber\\/","link":"https:\\/\\/formidableforms.com\\/downloads\\/aweber\\/","changelog":"<h4>v2.03 - March 3, 2022<\\/h4>\\n<ul>\\n<li>New: Subscription errors and successful subscriptions will now be logged if the Formidable Logs add on is available.<\\/li>\\n<li>Fix: Accents will now be removed from characters when subscribing to avoid issues with special accented characters breaking in names in AWeber.<\\/li>\\n<\\/ul>\\n<h4>v2.02 - October 14, 2020<\\/h4>\\n<ul>\\n<li>New: Add comma separated tags to your AWeber actions<\\/li>\\n<li>New: Add an ad tracking category to your AWeber actions<\\/li>\\n<li>New: Improved plugin security<\\/li>\\n<li>New: Updated the icon for AWeber in settings<\\/li>\\n<li>Fix: Support PHP 7+<\\/li>\\n<li>Fix: Add download id for more autoupdating<\\/li>\\n<li>Code: Removed Formidable &lt; v2.0 fallbacks. This version will not work with a Formidable version below 2.0.<\\/li>\\n<\\/ul>\\n<h4>v2.01 - February 4, 2016<\\/h4>\\n<ul>\\n<li>Make sure the update notice doesn\'t show if the plugin is up to date<\\/li>\\n<\\/ul>\\n","plugin":"formidable-aweber\\/formidable-aweber.php","icons":{"1x":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png"},"banners":{"high":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png","low":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png"},"search_terms":"","is_new":false},"169998":{"title":"WP Multilingual","name":"WP Multilingual","display_name":"WP Multilingual","slug":"wp-multilingual","version":"1.12","new_version":"1.12","location":["fp.strategy11.com\\/releases\\/formidable-wpml\\/formidable-wpml-1.12.zip"],"excerpt":"Translate your forms into multiple languages using the Formidable-integrated WPML plugin.","id":169998,"released":"2013-04-29 00:00:00","categories":["Business","Strategy11"],"docs":"\\/knowledgebase\\/formidable-multi-language\\/","link":"https:\\/\\/formidableforms.com\\/downloads\\/wp-multilingual\\/","changelog":"<h4>v1.12 - August 8, 2022<\\/h4>\\n<ul>\\n<li>New: Translations are now copied when a field or form is duplicated.<\\/li>\\n<li>New: Confirmation field validation messages can now be translated.<\\/li>\\n<li>Fix: Placeholders for Lookup dropdowns were not translating.<\\/li>\\n<li>Fix: Updated translations were not properly updating.<\\/li>\\n<\\/ul>\\n<h4>v1.11 - March 25, 2022<\\/h4>\\n<ul>\\n<li>Fix: Likert column headings were not translating properly.<\\/li>\\n<li>Fix: Incorrect and occasionally duplicate field translation options were appearing on translation pages.<\\/li>\\n<li>Fix: Formidable was appearing as an option in the WPML item dropdown, and has been removed.<\\/li>\\n<\\/ul>\\n<h4>v1.10 - July 29, 2021<\\/h4>\\n<ul>\\n<li>New: Placeholders can now be translated for credit card, address, and name fields.<\\/li>\\n<li>New: Options can now be translated for radio, checkbox, and dropdown fields inside of repeaters.<\\/li>\\n<li>Fix: Translations were not properly getting saved if the target language contained an underscore.<\\/li>\\n<\\/ul>\\n<h4>v1.04 - October 25th, 2016<\\/h4>\\n<ul>\\n<li>Allow translation of Add\\/Remove buttons<\\/li>\\n<li>Replace some deprecated WPML function calls and constants<\\/li>\\n<li>Make sure wpml strings are updated when form is updated<\\/li>\\n<li>Do not translate default value for all field types<\\/li>\\n<li>Make sure incorrect field message is translated with ajax submit<\\/li>\\n<\\/ul>\\n<h4>v1.03.03 - March 28, 2016<\\/h4>\\n<ul>\\n<li>Send the language in the ajax url differently to prevent 404s during ajax calls. This should help with duplicate submissions.<\\/li>\\n<li>Prevent a license key from being saved for another plugin<\\/li>\\n<\\/ul>\\n<h4>v1.03.02<\\/h4>\\n<ul>\\n<li>Get updates from FormidablePro.com<\\/li>\\n<li>Make it compatible with the free version of Formidable<\\/li>\\n<li>Fix errors when Formidable or WPML are deactivated<\\/li>\\n<li>Include the current language during ajax calls<\\/li>\\n<li>Force an English start language for strings for v2.2.6 of the WPML strings plugin<\\/li>\\n<li>Fix the issue with the default language in WPML being set different than the string language<\\/li>\\n<li>If values in the form settings page changed, update them when going to the translation settings<\\/li>\\n<li>Make sure the \\"previous\\" label is translatable when drafts are not enabled<\\/li>\\n<li>Don\'t show strings for inactive languages<\\/li>\\n<li>Translate fields in repeating sections<\\/li>\\n<\\/ul>\\n","plugin":"formidable-wpml\\/formidable-wpml.php","icons":{"1x":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png"},"banners":{"high":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png","low":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png"},"search_terms":"","is_new":false},"170641":{"title":"Locations","name":"Locations","display_name":"Locations","slug":"locations","version":"2.03","new_version":"2.03","location":["fp.strategy11.com\\/releases\\/formidable-locations\\/formidable-locations-2.03.zip"],"excerpt":"Populate fields with Countries, States\\/Provinces, U.S. Counties, and U.S. Cities. This data can then be used in dependent Data from Entries fields.","id":170641,"released":"2014-06-21 00:00:00","categories":["Creator","Strategy11"],"docs":"\\/knowledgebase\\/formidable-locations\\/","link":"https:\\/\\/formidableforms.com\\/downloads\\/locations\\/","changelog":"<h4>v2.03 - April 20, 2023<\\/h4>\\n<ul>\\n<li>Fix: Importing cities would stop at \\"8 remaining\\" and never stop making requests to import additional cities.<\\/li>\\n<li>Fix: Form ids are are no longer retrieved using a deprecated function.<\\/li>\\n<li>Fix: Some city values were importing incorrectly, displaying \\"1920\\" as the state.<\\/li>\\n<\\/ul>\\n<h4>v2.02 - September 11, 2017<\\/h4>\\n<ul>\\n<li>Fix: Remove invalid city data.<\\/li>\\n<\\/ul>\\n<h4>v2.01 - May 10, 2016<\\/h4>\\n<ul>\\n<li>Switch to using Lookup fields<\\/li>\\n<li>Add a link to reset the locations data<\\/li>\\n<\\/ul>\\n","plugin":"formidable-locations\\/us_locations.php","icons":{"1x":"https:\\/\\/formidableforms.com\\/wp-content\\/uploads\\/2013\\/04\\/locations.png"},"banners":{"high":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png","low":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png"},"search_terms":"","is_new":false},"170645":{"title":"Zapier","name":"Zapier","display_name":"Zapier","slug":"zapier","version":"2.03","new_version":"2.03","location":["fp.strategy11.com\\/releases\\/formidable-zapier\\/formidable-zapier-2.03.zip"],"excerpt":"Connect with hundreds of applications through Zapier. Automatically insert a Google spreadsheet row, tweet, or upload to Dropbox.","id":170645,"released":"2014-06-04 00:00:00","categories":["Business","Strategy11"],"docs":"\\/knowledgebase\\/formidable-zapier\\/","link":"https:\\/\\/formidableforms.com\\/downloads\\/zapier\\/","changelog":"<h4>v2.03 - March 11, 2024<\\/h4>\\n<ul>\\n<li>Fix: When polling for entries, the first entry would always get returned. Now the newest entry is returned as expected.<\\/li>\\n<\\/ul>\\n<h4>v2.02 - March 21, 2023<\\/h4>\\n<ul>\\n<li>New: Referrer checks for protected files are now allowed for Zapier requests so a protected file can be uploaded to Google Drive using a Zapier action. Protected files also need to be available to everyone or Zapier still will not have access.<\\/li>\\n<li>New: Added translation support.<\\/li>\\n<li>Fix: The \\/form API endpoint was calling a deprecated function.<\\/li>\\n<li>Fix: Prevent a fatal error when Formidable lite is inactive.<\\/li>\\n<li>Fix: The link to edit a zap would lead to a 404 page.<\\/li>\\n<li>Additional validation has been added to prevent notices for an incomplete API URL.<\\/li>\\n<li>The message to migrate will no longer be shown when no legacy Zapier posts exist.<\\/li>\\n<li>A warning will now be displayed on any temporary Zapier actions that get created for testing before publishing a zap.<\\/li>\\n<\\/ul>\\n<h4>v2.0 - September 14, 2020<\\/h4>\\n<ul>\\n<li>This update requires action. After updating, click the link to migrate the old settings. <strong>Zaps will not be triggered after updating until this is completed.<\\/strong><\\/li>\\n<li>New: Move Zapier settings to form actions. This allows for conditional logic and form action automation to be used from the Formidable end.<\\/li>\\n<li>New: Better logging for more info for both incoming and outgoing API calls for easier debugging.<\\/li>\\n<\\/ul>\\n","plugin":"formidable-zapier\\/formidable-zapier.php","icons":{"1x":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png"},"banners":{"high":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png","low":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png"},"search_terms":"","is_new":false},"170649":{"title":"User Tracking","name":"User Tracking","display_name":"User Flow","slug":"user-tracking","version":"2.0","new_version":"2.0","location":["s3.amazonaws.com\\/fp.strategy11.com\\/releases\\/formidable-user-tracking\\/formidable-user-tracking-2.0.zip"],"excerpt":"Track the pages a user visits and the time spent on each page prior to submitting a form.","id":170649,"released":"2015-10-19 00:00:00","categories":["Creator","Strategy11"],"docs":"\\/knowledgebase\\/formidable-user-tracking\\/","link":"https:\\/\\/formidableforms.com\\/downloads\\/user-tracking\\/","changelog":"<h4>v2.0 - November 1, 2022<\\/h4>\\n<ul>\\n<li>Update the display of the user flow through the site for better readability and more actionable data.<\\/li>\\n<li>Include timestamps in the session tracking so we know how much time was spent on each page.<\\/li>\\n<li>Show the page name for better readability.<\\/li>\\n<li>Add form submissions into session tracking so we know what forms were submitted before this one.<\\/li>\\n<li>Show a summary of how much time between the first time we logged the user and when the form was submitted.<\\/li>\\n<li>Fix: Do not start session when running a Cron.<\\/li>\\n<\\/ul>\\n<h4>v1.0 - August 25, 2016<\\/h4>\\n<ul>\\n<li>Save the tracking info before the email is sent<\\/li>\\n<li>Make sure license key is correct before saving<\\/li>\\n<\\/ul>\\n","plugin":"formidable-user-tracking\\/formidable-user-tracking.php","icons":{"1x":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png"},"banners":{"high":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png","low":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png"},"search_terms":"","is_new":false},"170655":{"title":"Mailchimp","name":"Mailchimp","display_name":"Mailchimp","slug":"mailchimp","version":"2.06","new_version":"2.06","location":["fp.strategy11.com\\/releases\\/formidable-mailchimp\\/formidable-mailchimp-2.06.zip"],"excerpt":"Get on the path to more leads in minutes. Add and update leads in a Mailchimp mailing list when a form is submitted.","id":170655,"released":"2013-10-17 00:00:00","categories":["Creator","Strategy11"],"docs":"\\/knowledgebase\\/formidable-mailchimp\\/","link":"https:\\/\\/formidableforms.com\\/downloads\\/mailchimp\\/","changelog":"<h4>v2.06 - June 23, 2021<\\/h4>\\n<ul>\\n<li>New: Name fields will now automatically map the proper first and last name values when sending to MailChimp.<\\/li>\\n<li>Fix: Prevent a warning when loading MailChimp action settings.<\\/li>\\n<\\/ul>\\n<h4>v2.05 - July 24, 2020<\\/h4>\\n<ul>\\n<li>New: Add support for MailChimp GDPR marketing settings. There must be a contact in the selected list before the settings will show in the form action.<\\/li>\\n<li>New: Add frm_mlcmp_tags hook for adding or removing tags.<\\/li>\\n<li>Fix: The email field wasn\'t showing in the unsubscribe settings<\\/li>\\n<\\/ul>\\n<h4>v2.04 - July 12, 2019<\\/h4>\\n<ul>\\n<li>Add support for MailChimp tags<\\/li>\\n<li>Add double opt-in for unsubscribed users that are resubscribing<\\/li>\\n<li>Add German translation<\\/li>\\n<li>Log API requests in the Formidable Logs<\\/li>\\n<li>Update the styling for the MailChimp icon in the form actions to better match 4.0<\\/li>\\n<li>Clean up the MailChimp form action settings<\\/li>\\n<li>Clarify the groups settings to make them a bit more intuitive<\\/li>\\n<li>Allow text fields to be selected for groups<\\/li>\\n<li>Show error messages along with the \'no mailing lists found\' message for easier debugging<\\/li>\\n<\\/ul>\\n","plugin":"formidable-mailchimp\\/formidable-mailchimp.php","icons":{"1x":"https:\\/\\/formidableforms.com\\/wp-content\\/uploads\\/2013\\/04\\/mailchimp.png"},"banners":{"high":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png","low":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png"},"search_terms":"","is_new":false},"172715":{"title":"PayPal Basic","name":"PayPal Basic","display_name":"PayPal Basic","slug":"paypal-standard-single-payments","version":"3.08","new_version":"3.08","location":["fp.strategy11.com\\/releases\\/formidable-paypal\\/formidable-paypal-3.08.zip"],"excerpt":"","id":172715,"released":"2015-10-21 12:20:35","categories":["Ecommerce","Strategy11"],"docs":"","link":"https:\\/\\/formidableforms.com\\/downloads\\/paypal-standard-single-payments\\/","changelog":"<h4>v3.02 - September 14, 2018<\\/h4>\\n<ul>\\n<li>Merge the older grandfathered PayPal addon with the updated version.<\\/li>\\n<\\/ul>\\n<h4>v2.04.07 - January 25, 2015<\\/h4>\\n<ul>\\n<li>Allow amounts with . for thousands and , for decimal. If a . is used in the decimal place for the amount when the currency uses a , make it work anyway<\\/li>\\n<li>Redirect to PayPal correctly without Pro<\\/li>\\n<li>Make sure email setting is trimmed before comparing<\\/li>\\n<li>Add download ID to make sure correct license is used<\\/li>\\n<\\/ul>\\n<h4>v2.04.06 - November 17, 2015<\\/h4>\\n<ul>\\n<li>Prevent errors when updating Formidable<\\/li>\\n<\\/ul>\\n<h4>v2.04.05<\\/h4>\\n<ul>\\n<li>Format decimals with . to allow float to work correctly<\\/li>\\n<li>Get updates from FormidablePro.com<\\/li>\\n<\\/ul>\\n<h4>v2.04.04<\\/h4>\\n<ul>\\n<li>Allow the amount to be included in the \\"other\\" option<\\/li>\\n<li>Modify the user-agent in the IPN verification to prevent errors from PayPal<\\/li>\\n<\\/ul>\\n<h4>v2.04.03<\\/h4>\\n<ul>\\n<li>Save the IPN parameters with the payment in the format that allows for multiple IPN notifications<\\/li>\\n<li>Fix sending users to Paypal when 2.x is installed, but the old settings haven\'t been moved to a form action<\\/li>\\n<li>Increased security related to XSS add_query_arg vulnerability<\\/li>\\n<\\/ul>\\n","plugin":"paypal-standard-single-payments\\/paypal-standard-single-payments.php","icons":{"1x":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png"},"banners":{"high":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png","low":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png"},"search_terms":"","is_new":false},"173984":{"title":"User Registration","name":"User Registration","display_name":"User Registration","slug":"user-registration","version":"2.13","new_version":"2.13","location":["s3.amazonaws.com\\/fp.strategy11.com\\/releases\\/formidable-registration\\/formidable-registration-2.13.zip"],"excerpt":"Give new users access to your site quickly and painlessly. Plus edit profiles and login from the front end.","id":173984,"released":"2011-12-21 00:00:00","categories":["Business","Strategy11"],"docs":"\\/knowledgebase\\/user-registration\\/","link":"https:\\/\\/formidableforms.com\\/downloads\\/user-registration\\/","changelog":"<h4>v2.13 - April 4, 2024<\\/h4>\\n<ul>\\n<li>New: User moderation redirects now support a new option to Redirect to a URL.<\\/li>\\n<li>New: Links and forms have been updated to use the site URL for logging in instead of the network site URL.<\\/li>\\n<li>New: The &#091;frm-login] shortcode now support several new options including register_link, label_register, class_register for adding registration links to login forms.<\\/li>\\n<li>New: The logout_redirect option used in &#091;frm-login] shortcodes now supports numeric page ID values.<\\/li>\\n<li>New: &#091;frm-reset-password] shortcodes now support new password_strength=\\"1\\" and password_visibility_toggle=\\"1\\" options.<\\/li>\\n<li>Fix: Errors messages will now show on page load when using the slide=1 option with a &#091;frm-login] shortcode.<\\/li>\\n<li>Several old deprecated functions have been removed.<\\/li>\\n<\\/ul>\\n<h4>v2.12 - February 15, 2024<\\/h4>\\n<ul>\\n<li>Security: The &#091;frm-set-password-link] shortcode can no longer be used anywhere but in email actions. Any user without the frm_edit_users capability will also not be allowed to save a &#091;frm-set-password-link] shortcode as part of their email action content.<\\/li>\\n<li>New: The meta table displayed on the User Profile page has been updated to look better. It now also includes links to edit the Formidable entry in a new table column for users with the capability to edit entries on admin pages.<\\/li>\\n<li>Fix: User meta would not update when updating a field value using the &#091;frm-entry-update-field] shortcode.<\\/li>\\n<\\/ul>\\n<h4>v2.11 - November 1, 2023<\\/h4>\\n<ul>\\n<li>New: Translations have been added for Polish, Portuguese (Brazil), French, German, Dutch, Slovak, and Italian.<\\/li>\\n<li>New: Roles will no longer get added on entry update by default. This can be enabled with a new frm_reg_update_user_role hook.<\\/li>\\n<li>New: The way CSS is added has been modified for better compatibility with the Snuffleupagus security module.<\\/li>\\n<li>Fix: The error message for missing special characters when resetting a password would only show a Password is invalid message. The new message is now more detailed.<\\/li>\\n<li>Fix: When using the slide=1 option in frm-login shortcodes, the remember me and lost password elements would never appear.<\\/li>\\n<\\/ul>\\n","plugin":"formidable-registration\\/formidable-registration.php","icons":{"1x":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png"},"banners":{"high":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png","low":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png"},"search_terms":"registration, user registration, register","is_new":false},"174006":{"title":"WooCommerce","name":"WooCommerce","display_name":"WooCommerce","slug":"woocommerce","version":"1.12","new_version":"1.12","location":["fp.strategy11.com\\/releases\\/formidable-woocommerce\\/formidable-woocommerce-1.12.zip"],"excerpt":"Are your WooCommerce product forms too basic? Add custom fields to a product form and collect more data when it is added to the cart.","id":174006,"released":"2016-01-19 00:00:00","categories":["Ecommerce","Elite","Strategy11"],"docs":"\\/knowledgebase\\/formidable-woocommerce\\/","link":"https:\\/\\/formidableforms.com\\/downloads\\/woocommerce\\/","changelog":"","plugin":"formidable-woocommerce\\/formidable-woocommerce.php","icons":{"1x":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png"},"banners":{"high":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png","low":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png"},"search_terms":"","is_new":false},"180495":{"title":"Highrise","name":"Highrise","display_name":"Highrise","slug":"highrise","version":"1.06","new_version":"1.06","location":["fp.strategy11.com\\/releases\\/formidable-highrise\\/formidable-highrise-1.06.zip"],"excerpt":"Capture leads in your WordPress contact forms, and save them in your Highrise CRM account too.","id":180495,"released":"2013-12-12 00:00:00","categories":["Creator","Strategy11"],"docs":"\\/knowledgebase\\/formidable-highrise\\/","link":"https:\\/\\/formidableforms.com\\/downloads\\/highrise\\/","changelog":"<h4>v1.06 - February 29, 2016<\\/h4>\\n<ul>\\n<li>Send the custom fields correctly to Highrise<\\/li>\\n<\\/ul>\\n<h4>v1.05 - February 23, 2016<\\/h4>\\n<ul>\\n<li>Fix email field settings in the Highrise action<\\/li>\\n<li>Make sure the license key is a Highrise license<\\/li>\\n<\\/ul>\\n<h4>v1.04 - February 9, 2016<\\/h4>\\n<ul>\\n<li>Added options to separate out address fields. City, State, Zip, and Country can now be mapped separately.<\\/li>\\n<li>Fixed PHP7 warnings<\\/li>\\n<\\/ul>\\n","plugin":"formidable-highrise\\/formidable-highrise.php","icons":{"1x":"https:\\/\\/formidableforms.com\\/wp-content\\/uploads\\/2012\\/01\\/highrise.png"},"banners":{"high":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png","low":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png"},"search_terms":"","is_new":false},"185013":{"title":"Bootstrap Modal","name":"Bootstrap Modal","display_name":"Bootstrap Modal","slug":"bootstrap-modal","version":"3.0.2","new_version":"3.0.2","location":["fp.strategy11.com\\/releases\\/formidable-modal\\/formidable-modal-3.0.2.zip"],"excerpt":"Open forms, views, other shortcodes, or sections of content in a Bootstrap popup.","id":185013,"released":"2015-08-26 00:00:00","categories":["Creator","Strategy11"],"docs":"https:\\/\\/formidableforms.com\\/knowledgebase\\/bootstrap-modal\\/","link":"https:\\/\\/formidableforms.com\\/downloads\\/bootstrap-modal\\/","changelog":"<h4>v3.0.2 - December 11, 2023<\\/h4>\\n<ul>\\n<li>New: The modal block button will now have a default \\"Click here\\" text instead of an empty input to make quick testing easier.<\\/li>\\n<li>New: The modal close button will now longer appear in the block preview as it was getting in the way and served no purpose.<\\/li>\\n<li>New: The modal block has been updated to work better with white label settings.<\\/li>\\n<li>Fix: The autocomplete popup from the Formidable Geolocation add on would not appear inside of a Bootstrap modal because of a z-index issue.<\\/li>\\n<\\/ul>\\n<h4>v3.0.1 - June 26, 2023<\\/h4>\\n<ul>\\n<li>Fix: Modals were hidden when the Formidable Bootstrap add on was also active.<\\/li>\\n<li>Fix: Modals made with the [frmmodal-content] shortcode were missing a backdrop.<\\/li>\\n<\\/ul>\\n<h4>v3.0 - June 13, 2023<\\/h4>\\n<ul>\\n<li>New: A Gutenberg block has been added to make modals easier to embed.<\\/li>\\n<li>New: A new <span class=\\"blob-code-inner blob-code-marker js-code-nav-pass \\" data-code-marker=\\"+\\"><span class=\\"pl-s x\\">frm_modal_link<\\/span><\\/span> filter has been added for customizing the modal link trigger HTML.<\\/li>\\n<\\/ul>\\n","plugin":"formidable-modal\\/formidable-modal.php","icons":{"1x":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png"},"banners":{"high":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png","low":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png"},"search_terms":"modal, popup","is_new":false},"209561":{"title":"Polylang","name":"Polylang","display_name":"Polylang","slug":"polylang","version":"1.11","new_version":"1.11","location":["fp.strategy11.com\\/releases\\/formidable-polylang\\/formidable-polylang-1.11.zip"],"excerpt":"Create bilingual or multilingual forms with help from Polylang.","id":209561,"released":"2016-01-22 00:00:00","categories":["Business","Strategy11"],"docs":"\\/knowledgebase\\/formidable-polylang\\/","link":"https:\\/\\/formidableforms.com\\/downloads\\/polylang\\/","changelog":"<h4>v1.11 - August 8, 2023<\\/h4>\\n<ul>\\n<li>New: Product options can now be translated.<\\/li>\\n<li>Fix: Likert columns were not translating when the \\"Separate column values\\" option was checked.<\\/li>\\n<\\/ul>\\n<h4>v1.10 - August 16, 2021<\\/h4>\\n<ul>\\n<li>New: Submitted options will now be translated for radio, checkbox and dropdown fields, including translated views and email actions.<\\/li>\\n<li>Fix: Added additional checks to prevent notices for fields missing placeholders.<\\/li>\\n<li>Fix: Prevent a warning that would trigger when uploading.<\\/li>\\n<\\/ul>\\n<h4>v1.09 - May 5, 2021<\\/h4>\\n<ul>\\n<li>New: Placeholders can now be translated for all field types.<\\/li>\\n<li>New: Descriptions can now be translated for Address and Credit Card fields.<\\/li>\\n<li>Fix: Translated default values were saving the translated value for radio buttons, check boxes, and dropdowns in some forms with multiple pages.<\\/li>\\n<li>Fix: Default values were not selected for radio buttons and check boxes in translated languages in some forms with multiple pages.<\\/li>\\n<\\/ul>\\n","plugin":"formidable-polylang\\/frm-poly.php","icons":{"1x":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png"},"banners":{"high":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png","low":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png"},"search_terms":"","is_new":false},"310430":{"title":"Stripe","name":"Stripe","display_name":"Stripe","slug":"stripe","version":"3.1.5","new_version":"3.1.5","location":["fp.strategy11.com\\/releases\\/formidable-stripe\\/formidable-stripe-3.1.5.zip"],"excerpt":"Any Formidable forms on your site can accept credit card payments without users ever leaving your site.","id":310430,"released":"2016-04-26 00:00:00","categories":["Business","Ecommerce","Strategy11"],"docs":"\\/knowledgebase\\/stripe\\/","link":"https:\\/\\/formidableforms.com\\/downloads\\/stripe\\/","changelog":"<h4>v3.1.5 - March 7, 2024<\\/h4>\\n<ul>\\n<li>New: A new &#091;frm-payment] shortcode has been added. This can be used to display quick details about a payment for a given entry ID. For example, &#091;frm-payment entry=&#091;id] show=amount] can be used in a view to get the payment amount.<\\/li>\\n<li>New: The table output from the &#091;frm-subscriptions] shortcode is now responsive on mobile widths.<\\/li>\\n<li>New: Recurring payments now support a new \\"Recurring Payment Limit\\" setting. Once the limit has been reached, subscriptions will be automatically cancelled.<\\/li>\\n<li>New: The submit button will no longer be disabled when a Stripe link payment method field is conditionally hidden.<\\/li>\\n<li>Fix: Payments using a currency that uses a comma as the decimal separator would have an incorrect amount value when the amount value had a single decimal point like 11,5.<\\/li>\\n<li>Fix: After a recent Stripe update, forms with multiple payment actions would get stuck on a spinning button on submit.<\\/li>\\n<li>Fix: In some cases, a Stripe Link redirect would happen after failing to create an entry, resulting in an unexpected redirect to stripe.com.<\\/li>\\n<li>Fix: Subscription plan details would not update after changing the trial period.<\\/li>\\n<\\/ul>\\n<h4>v3.1.4 - January 23, 2024<\\/h4>\\n<ul>\\n<li>New: Embedded fields can now be used for customer information Name and Address options.<\\/li>\\n<li>New: Payments now support a test mode flag. New payments will display whether a payment was made in test mode or in live mode.<\\/li>\\n<li>New: A new payment refunded event trigger type has been added.<\\/li>\\n<li>New: Stripe subscriptions will now cancel at period end by default instead of cancelling immediately. This can be reverted to the previous behaviour using add_filter( \'frm_stripe_cancel_subscription_at_period_end\', \'__return_false\' );.<\\/li>\\n<li>New: Strings used in the embedded payments plugin can now be translated.<\\/li>\\n<li>Fix: After payment settings would never save properly for a new payment action.<\\/li>\\n<li>Fix: Some currency options were appearing multiple times.<\\/li>\\n<li>Fix: A subscription with a failed charge but a successful payment intent would incorrectly get flagged as a completed successful payment.<\\/li>\\n<li>Fix: An error message wouldn\'t properly appear when using a 3D secure card and failing the payment.<\\/li>\\n<li>Fix: [if x] shortcodes were not working in confirmation action redirects when x is the field ID of a field used for tracking payment status.<\\/li>\\n<li>Fix: Conditionally hidden fields would become visible after card is declined when AJAX submit was enabled.<\\/li>\\n<li>Fix: 3D secure payments would remain pending when a form included a confirmation action with a redirect.<\\/li>\\n<li>Fix: A conflict with the Authorize.Net add-on would trigger a Call to undefined method FrmTransAppHelper::get_formatted_amount_for_currency() fatal error.<\\/li>\\n<li>Many translations have been offloaded to Formidable Lite.<\\/li>\\n<\\/ul>\\n<h4>v3.1.3 - October 4, 2023<\\/h4>\\n<ul>\\n<li>Fix: Stripe subscriptions would fail with a No such plan error if the payment action was created when a different mode was active.<\\/li>\\n<li>Fix: Entries would not get deleted on Stripe payment failure, and old entry data would not get displayed with payment errors, when using Stripe Link or when using a 3D secure credit card.<\\/li>\\n<li>Fix: The payment expire date and next subscription billing date values were not accurate for payment table records when using Stripe Link.<\\/li>\\n<li>Fix: iDEAL, Bancontact, and SOFORT subscriptions would fail with a The payment method must be attached to the customer error.<\\/li>\\n<li>Fix: A return_url must be specified error would prevent the creation of payment intents when using API keys with newer versions of the Stripe API set.<\\/li>\\n<\\/ul>\\n","plugin":"formidable-stripe\\/formidable-stripe.php","icons":{"1x":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png"},"banners":{"high":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png","low":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png"},"search_terms":"","is_new":false},"326042":{"title":"Form Action Automation","name":"Form Action Automation","display_name":"Form Action Automation","slug":"autoresponder","version":"2.07","new_version":"2.07","location":["fp.strategy11.com\\/releases\\/autoresponder\\/formidable-autoresponder-2.07.zip"],"excerpt":"Schedule email notifications, SMS messages, and API actions.","id":326042,"released":"2016-09-21 00:00:00","categories":["Elite","Marketing","Strategy11"],"docs":"\\/knowledgebase\\/schedule-autoresponder\\/","link":"https:\\/\\/formidableforms.com\\/downloads\\/autoresponder\\/","changelog":"<h4>v2.07 - April 29, 2024<\\/h4>\\n<ul>\\n<li>New: The frm_autoresponder_time filter is now always applied. Previously this filter was only used when date or time fields were defined as the send date setting.<\\/li>\\n<li>New: Strings used in this plugin can now be translated.<\\/li>\\n<li>Fix: A bug has been fixed that would strip &#091;] shortcode characters after duplicating a form action with dashes in the value like a date format.<\\/li>\\n<\\/ul>\\n<h4>v2.06 - January 2, 2024<\\/h4>\\n<ul>\\n<li>Fix: Some inputs had styling issues in Automation action settings.<\\/li>\\n<li>Fix: A delayed form action automation would sometimes never trigger when set to trigger 1 minute after form submission, when form actions after form submission would take longer than a minute to complete reporting that the time had already passed.<\\/li>\\n<\\/ul>\\n<h4>v2.05 - June 13, 2022<\\/h4>\\n<ul>\\n<li>Fix: Automation events were not getting unscheduled when an action or automation setting was deleted.<\\/li>\\n<li>Fix: Changes to automation settings were not saving for disabled actions.<\\/li>\\n<li>Fix: Automated entry creation events were getting triggered when saving drafts.<\\/li>\\n<\\/ul>\\n","plugin":"formidable-autoresponder\\/formidable-autoresponder.php","icons":{"1x":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png"},"banners":{"high":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png","low":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png"},"search_terms":"automate, automation","is_new":false},"337527":{"title":"Authorize.net AIM","name":"Authorize.net AIM","display_name":"Authorize.net AIM","slug":"authorize-net-aim","version":"2.03","new_version":"2.03","location":["fp.strategy11.com\\/releases\\/authorize-net\\/formidable-authorize-net-2.03.zip"],"excerpt":"Accept one-time payments directly on your site, using Authorize.net AIM.","id":337527,"released":"2016-04-29 00:00:00","categories":["Ecommerce","Elite","Strategy11"],"docs":"\\/knowledgebase\\/authorize-net-aim\\/","link":"https:\\/\\/formidableforms.com\\/downloads\\/authorize-net-aim\\/","changelog":"<h4>v2.03 - April 24, 2024<\\/h4>\\n<ul>\\n<li>Fix: A FrmTransActionsController not found fatal error related to autoloading occuring on some server configurations has been fixed.<\\/li>\\n<\\/ul>\\n<h4>v2.02 - March 7, 2022<\\/h4>\\n<ul>\\n<li>New: Name fields will now automatically map the proper first and last name values when sending to Authorize.net.<\\/li>\\n<li>New: Set the default currency to the one selected in global settings.<\\/li>\\n<li>New: Added additional currencies from Pro.<\\/li>\\n<li>Fix: Payments would not work if the amount specified was formatted as currency.<\\/li>\\n<li>Fix: Prevent a fatal error that happens in PHP8 when filling payment information.<\\/li>\\n<li>Fix: Expire dates were not properly calculating.<\\/li>\\n<li>Fix: Some echecks were not getting approved.<\\/li>\\n<li>Fix: Updated incorrect text domains.<\\/li>\\n<\\/ul>\\n<h4>v2.01 - March 18, 2019<\\/h4>\\n<ul>\\n<li>Fix: Increase the timeout for creating the payment on Authorize.net in order to prevent false failures.<\\/li>\\n<li>Save the full API response in the log instead of only the body of the response for more helpful debugging messages.<\\/li>\\n<\\/ul>\\n","plugin":"formidable-authorize-net\\/formidable-authorize-net.php","icons":{"1x":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png"},"banners":{"high":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png","low":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png"},"search_terms":"Authorize.net","is_new":false},"11927748":{"title":"Logs","name":"Logs","display_name":"Logs","slug":"logs","version":"1.0.1","new_version":"1.0.1","location":["fp.strategy11.com\\/releases\\/logs\\/formidable-logs-1.0.1.zip"],"excerpt":"See your API requests along with their responses from add-ons including Zapier, Formidable API Webhooks, Salesforce and more.","id":11927748,"released":"2016-12-19 00:00:00","categories":["Basic","Strategy11"],"docs":"https:\\/\\/formidableforms.com\\/knowledgebase\\/logging\\/","link":"https:\\/\\/formidableforms.com\\/downloads\\/logs\\/","changelog":"","plugin":"formidable-logs\\/formidable-logs.php","icons":{"1x":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png"},"banners":{"high":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png","low":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png"},"search_terms":"","is_new":false},"19366992":{"title":"Formidable Pro Elite Package","name":"Formidable Pro Elite Package","display_name":"Formidable Pro Elite Package","slug":"formidable-pro-enterprise-package","version":"","new_version":"","location":[],"excerpt":"","id":19366992,"released":"2017-09-01 12:09:38","categories":["Strategy11"],"docs":"","link":"https:\\/\\/formidableforms.com\\/downloads\\/formidable-pro-enterprise-package\\/","changelog":"","plugin":"formidable-pro-enterprise-package\\/formidable-pro-enterprise-package.php","icons":{"1x":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png"},"banners":{"high":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png","low":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png"},"search_terms":"","is_new":false},"19366995":{"title":"Formidable Pro Business Package","name":"Formidable Pro Business Package","display_name":"Formidable Pro Business Package","slug":"formidable-pro-small-business-package","version":"","new_version":"","location":[],"excerpt":"","id":19366995,"released":"2017-09-01 12:09:09","categories":["Strategy11"],"docs":"","link":"https:\\/\\/formidableforms.com\\/downloads\\/formidable-pro-small-business-package\\/","changelog":"","plugin":"formidable-pro-small-business-package\\/formidable-pro-small-business-package.php","icons":{"1x":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png"},"banners":{"high":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png","low":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png"},"search_terms":"","is_new":false},"19367001":{"title":"Formidable Pro Creator Package","name":"Formidable Pro Creator Package","display_name":"Formidable Pro Creator Package","slug":"formidable-pro-professional-package","version":"","new_version":"","location":[],"excerpt":"","id":19367001,"released":"2017-09-01 12:10:24","categories":["Strategy11"],"docs":"","link":"https:\\/\\/formidableforms.com\\/downloads\\/formidable-pro-professional-package\\/","changelog":"","plugin":"formidable-pro-professional-package\\/formidable-pro-professional-package.php","icons":{"1x":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png"},"banners":{"high":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png","low":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png"},"search_terms":"","is_new":false},"19367654":{"title":"Formidable Pro Single Site","name":"Formidable Pro Single Site","display_name":"Formidable Pro Single Site","slug":"formidable-pro-single-site","version":"","new_version":"","location":[],"excerpt":"","id":19367654,"released":"2017-09-01 13:36:16","categories":["Strategy11"],"docs":"","link":"https:\\/\\/formidableforms.com\\/downloads\\/formidable-pro-single-site\\/","changelog":"","plugin":"formidable-pro-single-site\\/formidable-pro-single-site.php","icons":{"1x":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png"},"banners":{"high":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png","low":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png"},"search_terms":"","is_new":false},"20247260":{"title":"Datepicker Options","name":"Datepicker Options","display_name":"Datepicker Options","slug":"datepicker-options","version":"2.0.4","new_version":"2.0.4","location":["fp.strategy11.com\\/releases\\/dates\\/formidable-dates-2.0.4.zip"],"excerpt":"Add more options to date fields in your forms for so only the dates you choose can be chosen.","id":20247260,"released":"2018-07-30 00:00:00","categories":["Business","Strategy11"],"docs":"\\/knowledgebase\\/datepicker-options\\/","link":"https:\\/\\/formidableforms.com\\/downloads\\/datepicker-options\\/","changelog":"<h4>v2.0.4 - March 28, 2024<\\/h4>\\n<ul>\\n<li>New: Blocked dates are no longer counted in &#091;date_calc] shortcode calculations by default when using the format=\\"days\\" option. In order to count blocked out dates, you must now include a new count_blackout_dates=\\"1\\" option.<\\/li>\\n<li>New: The strings used in this add-on can now be translated.<\\/li>\\n<li>Fix: Date calculations would trigger an error pop up on the edit entry admin page.<\\/li>\\n<li>Fix: Some date field validation checks would fail when sending a date value in Y-m-d format instead of the global date format setting.<\\/li>\\n<li>Fix: When validating if a date value is greater than or less than today, the value for today was based on the UTC timezone instead of the server timezone.<\\/li>\\n<\\/ul>\\n<h4>v2.0.3 - November 6, 2023<\\/h4>\\n<ul>\\n<li>Fix: Some inline datepickers were breaking because of a <span class=\\"message-body-wrapper\\"><span class=\\"message-flex-body\\"><span class=\\"message-body devtools-monospace\\"><span class=\\"objectBox-stackTrace reps-custom-format\\" data-link-actor-id=\\"server0.conn0.windowGlobal450971566097\\/obj74\\"><span class=\\"objectBox objectBox-string\\">settings is undefined<\\/span><\\/span><\\/span><\\/span><\\/span> JavaScript error.<\\/li>\\n<\\/ul>\\n<h4>v2.0.2 - November 1, 2023<\\/h4>\\n<ul>\\n<li>New: Inline datepickers will now reset when the start over button is clicked.<\\/li>\\n<li>New: Date calculations will now automatically exclude blacked out dates. This can be disabled using a new frm_dates_skip_blocked_dates_from_calc filter.<\\/li>\\n<li>Fix: Date calculations would break in multiple page forms when the calculations are not on the first page.<\\/li>\\n<li>Fix: Clicking on the + icon to add blackout or exception dates would not trigger the datepicker pop up.<\\/li>\\n<\\/ul>\\n","plugin":"formidable-dates\\/formidable-dates.php","icons":{"1x":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png"},"banners":{"high":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png","low":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png"},"search_terms":"datepicker","is_new":false},"20266559":{"title":"Salesforce","name":"Salesforce","display_name":"Salesforce","slug":"salesforce","version":"2.04","new_version":"2.04","location":["fp.strategy11.com\\/releases\\/salesforce\\/formidable-salesforce-2.04.zip"],"excerpt":"Add new contacts and leads into your Salesforce CRM directly from the WordPress forms on your site.","id":20266559,"released":"2018-05-31 00:00:00","categories":["CRM","Elite"],"docs":"https:\\/\\/formidableforms.com\\/knowledgebase\\/salesforce-forms\\/","link":"https:\\/\\/formidableforms.com\\/downloads\\/salesforce\\/","changelog":"<h4>v2.04 - December 10, 2019<\\/h4>\\n<ul>\\n<li>New: Show Salesforce Authentication errors on the global settings page<\\/li>\\n<li>Add icon in global settings<\\/li>\\n<li>Use font icon instead of image in form action<\\/li>\\n<li>Remove debug mode in favor of logging<\\/li>\\n<li>Tweak: Clear the settings cache with a link instead of ajax for more reliable cache clearing<\\/li>\\n<li>Fix: Updating data in Salesforce wasn\'t working correctly<\\/li>\\n<li>Fix: There was an error when Formidable was disabled<\\/li>\\n<\\/ul>\\n<h4>v2.03 - October 11, 2018<\\/h4>\\n<ul>\\n<li>New: Add option to update Salesforce records<\\/li>\\n<li>New: Add support for Salesforce Boolean fields<\\/li>\\n<li>Fix: Multiselect picklist fields weren\'t getting correct values from a checkbox<\\/li>\\n<li>Fix: Date fields set as a post field were sending the wrong date format<\\/li>\\n<li>Fix: Fatal error caused by date fields in certain formats<\\/li>\\n<\\/ul>\\n<h4>v2.02 - June 14, 2018<\\/h4>\\n<ul>\\n<li>Add API calls to <a href=\\"https:\\/\\/formidableforms.com\\/features\\/api-logs\\/\\">Logs plugin<\\/a><\\/li>\\n<li>Add more messages for debugging<\\/li>\\n<li>Fix issue with authenticating on an SSL site<\\/li>\\n<\\/ul>\\n","plugin":"formidable-salesforce\\/formidable-salesforce.php","icons":{"1x":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png"},"banners":{"high":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png","low":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png"},"search_terms":"","is_new":false},"20781560":{"title":"MailPoet Newsletters","name":"MailPoet Newsletters","display_name":"MailPoet Newsletters","slug":"mailpoet-newsletters","version":"1.02","new_version":"1.02","location":["fp.strategy11.com\\/releases\\/mailpoet\\/formidable-mailpoet-1.02.zip"],"excerpt":"Send WordPress newsletters from your own site with MailPoet. And use Formidable to for your newsletter signup forms.","id":20781560,"released":"2018-06-05 00:00:00","categories":["Creator","Marketing"],"docs":"https:\\/\\/formidableforms.com\\/knowledgebase\\/mailpoet-newsletter-signup-forms\\/","link":"https:\\/\\/formidableforms.com\\/downloads\\/mailpoet-newsletters\\/","changelog":"<h4>v1.02 - July 12, 2022<\\/h4>\\n<ul>\\n<li>New: Added support for logging MailPoet subscriptions when the Logs add on is active.<\\/li>\\n<li>New: Name fields will now automatically map the proper first and last name values when sending to MailPoet.<\\/li>\\n<li>Fix: Users could not subscribe to multiple lists when the active language was not in English because the error check was specific to language.<\\/li>\\n<li>Fix: Prevent a warning when sending data with MailPoet action.<\\/li>\\n<li>Fix: Nothing would get sent when a user id field was set to something other than a name or email option.<\\/li>\\n<\\/ul>\\n<h4>v1.01 - September 14, 2018<\\/h4>\\n<ul>\\n<li>Fix error after form submit on some sites<\\/li>\\n<\\/ul>\\n","plugin":"formidable-mailpoet\\/formidable-mailpoet.php","icons":{"1x":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png"},"banners":{"high":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png","low":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png"},"search_terms":"","is_new":false},"20790298":{"title":"Active Campaign","name":"Active Campaign","display_name":"ActiveCampaign","slug":"activecampaign-wordpress-plugin","version":"1.09","new_version":"1.09","location":["fp.strategy11.com\\/releases\\/activecampaign\\/formidable-activecampaign-1.09.zip"],"excerpt":"Add contacts to any ActiveCampaign list from your WordPress forms.","id":20790298,"released":"2018-07-05 00:00:00","categories":["Elite","Marketing"],"docs":"https:\\/\\/formidableforms.com\\/knowledgebase\\/activecampaign-forms\\/","link":"https:\\/\\/formidableforms.com\\/downloads\\/activecampaign-wordpress-plugin\\/","changelog":"<h4>v1.09 - March 25, 2024<\\/h4>\\n<ul>\\n<li>New: The strings used in this add-on can now be translated.<\\/li>\\n<li>Fix: An Uncaught Error: Class \\"FrmFormAction\\" not found fatal error has been fixed that happens on WPEngine hosted servers using PHP 8.2.<\\/li>\\n<\\/ul>\\n<h4>v1.08 - June 16, 2021<\\/h4>\\n<ul>\\n<li>New: Name fields will now automatically map the proper first and last name values when sending to ActiveCampaign.<\\/li>\\n<li>Fix: Errors messages were not displaying properly in settings when an ActiveCampaign trial had expired.<\\/li>\\n<li>Fix: Nothing would get sent when a user id field was set to something other than a name or email option.<\\/li>\\n<\\/ul>\\n<h4>v1.07 - April 12, 2021<\\/h4>\\n<p>- Fix: Contacts were not always properly being resubscribed after unsubscribing, even when the resubscribe checkbox was checked.<br \\/>\\n- Fix: Properly send data as an array when sending data to a custom Active Campaign Checkbox field.<br \\/>\\n- Fix: Only send the file url to Active Campaign instead of the HTML display value when a file field is set.<\\/p>\\n","plugin":"formidable-activecampaign\\/formidable-activecampaign.php","icons":{"1x":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png"},"banners":{"high":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png","low":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png"},"search_terms":"ActiveCampaign","is_new":false},"20811871":{"title":"HubSpot","name":"HubSpot","display_name":"HubSpot","slug":"hubspot-wordpress","version":"2.0","new_version":"2.0","location":["fp.strategy11.com\\/releases\\/hubspot\\/formidable-hubspot-2.0.zip"],"excerpt":"HubSpot is a complete CRM platform with tools for increased leads, accelerated sales, or streamlined customer service.","id":20811871,"released":"2018-09-04 00:00:00","categories":["CRM","Elite"],"docs":"https:\\/\\/formidableforms.com\\/knowledgebase\\/hubspot-forms\\/","link":"https:\\/\\/formidableforms.com\\/downloads\\/hubspot-wordpress\\/","changelog":"<h4>v2.0 - March 27, 2023<\\/h4>\\n<ul class=\\"p-rich_text_list p-rich_text_list__bullet\\" data-stringify-type=\\"unordered-list\\" data-indent=\\"0\\" data-border=\\"0\\">\\n<li data-stringify-indent=\\"0\\" data-stringify-border=\\"0\\">New: Added a new OAuth2 authentication method.<\\/li>\\n<li data-stringify-indent=\\"0\\" data-stringify-border=\\"0\\">New: While using the new OAuth2 authentication, contacts will now get deleted with a webhook after they are removed from HubSpot for GDPR compliance.<\\/li>\\n<li data-stringify-indent=\\"0\\" data-stringify-border=\\"0\\">New: Added translation support.<\\/li>\\n<li data-stringify-indent=\\"0\\" data-stringify-border=\\"0\\">New: Improved error handling when inputting an invalid Private App Access token.<\\/li>\\n<li data-stringify-indent=\\"0\\" data-stringify-border=\\"0\\">Fix: List data would display as an error after successfully authenticating HubSpot and after successfully clearing the cache.<\\/li>\\n<li data-stringify-indent=\\"0\\" data-stringify-border=\\"0\\">Fix: HubSpot access tokens would fail to save while the Geolocation add on was also active.<\\/li>\\n<li data-stringify-indent=\\"0\\" data-stringify-border=\\"0\\">Deprecated HubSpot API Keys are no longer supported.<\\/li>\\n<\\/ul>\\n<h4>v1.10 - January 27, 2022<\\/h4>\\n<ul>\\n<li>New: Added support for Private Apps. You can integrate with HubSpot using a Private App Access Token instead of your Public App API key.<\\/li>\\n<li>New: Added additional instructions for getting started with HubSpot.<\\/li>\\n<\\/ul>\\n<h4>v1.09 - June 21, 2021<\\/h4>\\n<ul>\\n<li>New: Name fields will now automatically map the proper first and last name values when sending to HubSpot.<\\/li>\\n<li>Fix: Nothing would get sent when a user id field was set to something other than a name or email option.<\\/li>\\n<\\/ul>\\n","plugin":"formidable-hubspot\\/formidable-hubspot.php","icons":{"1x":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png"},"banners":{"high":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png","low":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png"},"search_terms":"","is_new":false},"20813244":{"title":"GetResponse","name":"GetResponse","display_name":"GetResponse","slug":"getresponse-wordpress-plugin","version":"1.05","new_version":"1.05","location":["fp.strategy11.com\\/releases\\/getresponse\\/formidable-getresponse-1.05.zip"],"excerpt":"Collect leads in WordPress forms and automatically add them in GetResponse. Then trigger automatic emails and other GetResponse marketing automations.","id":20813244,"released":"2018-09-06 00:00:00","categories":["Business","Marketing"],"docs":"https:\\/\\/formidableforms.com\\/knowledgebase\\/getresponse-forms\\/","link":"https:\\/\\/formidableforms.com\\/downloads\\/getresponse-wordpress-plugin\\/","changelog":"<h4>v1.05 - June 21, 2021<\\/h4>\\n<ul>\\n<li>New: Name fields will now automatically map the proper first and last name values when sending to GetResponse.<\\/li>\\n<li>Fix: Nothing would get sent when a user id field was set to something other than a name or email option.<\\/li>\\n<\\/ul>\\n<h4>v1.04 - October 2, 2019<\\/h4>\\n<ul>\\n<li>Allow 0 for the cycle start day<\\/li>\\n<li>Show more helpful messages in the form action if the GetResponse lists cannot be fetched<\\/li>\\n<li>Update the form action icon for 4.0<\\/li>\\n<li>Remove the debug mode option and use the Logging plugin instead<\\/li>\\n<li>Load all custom fields right away since they aren\'t different for each list. Also don\'t hide the custom fields when a list changes.<\\/li>\\n<li>Prevent error with Formidable disabled<\\/li>\\n<\\/ul>\\n","plugin":"formidable-getresponse\\/formidable-getresponse.php","icons":{"1x":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png"},"banners":{"high":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png","low":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png"},"search_terms":"","is_new":false},"20815759":{"title":"Quiz Maker","name":"Quiz Maker","display_name":"Quiz Maker","slug":"quiz-maker","version":"3.1.4","new_version":"3.1.4","location":["fp.strategy11.com\\/releases\\/quiz\\/formidable-quizzes-3.1.4.zip"],"excerpt":"Turn your forms into automated quizzes. Add questions and submit the quiz key. Then all the grading is done for you.","id":20815759,"released":"2018-09-13 00:00:00","categories":["Business","Strategy11"],"docs":"\\/knowledgebase\\/quiz-maker-forms\\/","link":"https:\\/\\/formidableforms.com\\/downloads\\/quiz-maker\\/","changelog":"<h4>v3.1.4 - June 3, 2024<\\/h4>\\n<ul>\\n<li>Fix: A styling has has been applied to the + and - buttons for adding and removing quiz grade options in global settings.<\\/li>\\n<li>Fix: Forms with CAPTCHA fields would fail validation when submitting on forms using the format=\\"quiz_correct_answers\\" option for &#091;default-message] shortcodes used in email actions.<\\/li>\\n<li>Fix: Multiple scores would appear when using the scored quiz options to show the score after submitting a form multiple times when submitting with AJAX.<\\/li>\\n<li>Fix: An incorrect error message would appear when trying to add quiz outcomes and scored quiz actions to the same form.<\\/li>\\n<li>Confirmation action messages with scripts would always get stripped when included in a quiz score message. This is now only stripped based on site rules for handling unfiltered HTML.<\\/li>\\n<\\/ul>\\n<h4>v3.1.3 - February 5, 2024<\\/h4>\\n<ul>\\n<li>New: Embedded fields can now be used in scored quizzes.<\\/li>\\n<li>Fix: A database query would happen too often when there was no data to migrate from old versions of this add-on.<\\/li>\\n<li>Fix: A Undefined array key \\"entry_id\\" warning has been fixed.<\\/li>\\n<li>Fix: Quiz scores would be inaccurate when a target scored field was also used in a Post action. The old value would be used when scoring instead of the updated value.<\\/li>\\n<\\/ul>\\n<h4>v3.1.2 - October 26, 2023<\\/h4>\\n<ul>\\n<li>New: Quiz score field shortcodes now support a show=\\"percentile\\" option.<\\/li>\\n<li>Fix: Conditional logic options for quiz outcomes were not properly mapping the outcome ID value. Conditional logic based on quiz outcome values wouldn\'t work as expected.<\\/li>\\n<\\/ul>\\n","plugin":"formidable-quizzes\\/formidable-quizzes.php","icons":{"1x":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png"},"banners":{"high":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png","low":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png"},"search_terms":"quiz, quizzes","is_new":false},"20826884":{"title":"Constant Contact","name":"Constant Contact","display_name":"Constant Contact","slug":"constant-contact","version":"1.06","new_version":"1.06","location":["fp.strategy11.com\\/releases\\/constant-contact\\/formidable-constantcontact-1.06.zip"],"excerpt":"Setup WordPress forms to create leads automatically in Constant Contact. Just select a list and match up form fields.","id":20826884,"released":"2018-10-15 00:00:00","categories":["Business","Marketing"],"docs":"\\/knowledgebase\\/constant-contact-forms\\/","link":"https:\\/\\/formidableforms.com\\/downloads\\/constant-contact\\/","changelog":"<h4>v1.06 - March 25, 2024<\\/h4>\\n<ul>\\n<li>New: The strings used in this add-on can now be translated.<\\/li>\\n<li>Fix: An Uncaught Error: Class \\"FrmFormAction\\" not found fatal error has been fixed that happens on WPEngine hosted servers using PHP 8.2.<\\/li>\\n<\\/ul>\\n<h4>v1.05 - October 3, 2023<\\/h4>\\n<ul>\\n<li>New: Contact list options are now sorted alphabetically to make it easier to locate a target list.<\\/li>\\n<li>Fix: Address values were not getting set properly for new contacts.<\\/li>\\n<\\/ul>\\n<h4>v1.04 - June 22, 2022<\\/h4>\\n<ul>\\n<li>New: Updated the Authorization service for Constant Contact. Please re-connect as soon as possible to the new service to ensure that your connection does not break in the future when the old service is removed.<\\/li>\\n<li>Fix: Refresh tokens would become expired and break connections when trying to use the same Constant Contact account with multiple websites.<\\/li>\\n<li>Fix: A 409 error was getting triggered when sending an email to multiple lists with a single form submission throwing an error that the email already exists for the contact.<\\/li>\\n<\\/ul>\\n","plugin":"formidable-constantcontact\\/formidable-constantcontact.php","icons":{"1x":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png"},"banners":{"high":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png","low":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png"},"search_terms":"","is_new":false},"20834175":{"title":"Formidable Payments","name":"Formidable Payments","display_name":"Formidable Payments","slug":"formidable-payments","version":"1.14","new_version":"1.14","location":["fp.strategy11.com\\/releases\\/payments\\/formidable-payments-1.14.zip"],"excerpt":"","id":20834175,"released":"2018-11-06 12:08:25","categories":[],"docs":"","link":"https:\\/\\/formidableforms.com\\/downloads\\/formidable-payments\\/","changelog":"","plugin":"formidable-payments\\/formidable-payments.php","icons":{"1x":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png"},"banners":{"high":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png","low":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png"},"search_terms":"","is_new":false},"20891694":{"title":"Campaign Monitor","name":"Campaign Monitor","display_name":"Campaign Monitor","slug":"campaign-monitor","version":"1.04","new_version":"1.04","location":["fp.strategy11.com\\/releases\\/campaign-monitor\\/formidable-campaignmonitor-1.04.zip"],"excerpt":"Save time by automatically sending leads from WordPress forms to Campaign Monitor.","id":20891694,"released":"2019-06-17 00:00:00","categories":["Business","Marketing"],"docs":"\\/knowledgebase\\/campaign-monitor-forms\\/","link":"https:\\/\\/formidableforms.com\\/downloads\\/campaign-monitor\\/","changelog":"<h4>v1.04 - June 23, 2021<\\/h4>\\n<ul>\\n<li>New: Name fields will now automatically map the proper first and last name values when sending to Campaign Monitor.<\\/li>\\n<li>Fix: Nothing would get sent when a user id field was set to something other than a name or email option.<\\/li>\\n<li>Fix: Prevent a fatal error that happens in PHP8 after trying to save Campaign Monitor API keys.<\\/li>\\n<li>Fix: Prevent a fatal error that happens in PHP8 after trying to load the fields for a specific contact list.<\\/li>\\n<\\/ul>\\n","plugin":"formidable-campaignmonitor\\/formidable-campaignmonitor.php","icons":{"1x":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png"},"banners":{"high":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png","low":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png"},"search_terms":"","is_new":false},"20896934":{"title":"Formidable Pro Plus","name":"Formidable Pro Plus","display_name":"Formidable Pro Plus","slug":"formidable-basic","version":"","new_version":"","location":[],"excerpt":"","id":20896934,"released":"2019-07-22 09:03:39","categories":["Strategy11"],"docs":"","link":"https:\\/\\/formidableforms.com\\/downloads\\/formidable-basic\\/","changelog":"","plugin":"formidable-basic\\/formidable-basic.php","icons":{"1x":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png"},"banners":{"high":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png","low":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png"},"search_terms":"","is_new":false},"20897348":{"title":"Export View to CSV","name":"Export View to CSV","display_name":"Export View to CSV","slug":"export-view","version":"1.09","new_version":"1.09","location":["fp.strategy11.com\\/releases\\/export-view\\/formidable-export-view-1.09.zip"],"excerpt":"Easily create custom CSV files and allow users to export their data from the front-end of your site.","id":20897348,"released":"2019-08-01 00:00:00","categories":["Business","Strategy11"],"docs":"https:\\/\\/formidableforms.com\\/knowledgebase\\/table-view-to-csv\\/","link":"https:\\/\\/formidableforms.com\\/downloads\\/export-view\\/","changelog":"<h4>v1.09 - September 19, 2023<\\/h4>\\n<ul>\\n<li>New: A new UTF-8 with BOM format option has been added to the Export Views global settings section.<\\/li>\\n<\\/ul>\\n<h4>v1.08 - June 26, 2023<\\/h4>\\n<ul>\\n<li>Fix: Some admin pages, including the WooCommerce orders page, were broken because of a fatal error when Formidable Views was inactive. Now this plugin will no longer load when Formidable Views is unavailable.<\\/li>\\n<\\/ul>\\n<h4>v1.07 - June 15, 2023<\\/h4>\\n<ul>\\n<li>New: The utf8_encode function has been replaced as it is deprecated in PHP 8.2.<\\/li>\\n<li>New: Downloaded CSVs will now use the global CSV format setting instead of using the blog_charset option.<\\/li>\\n<li>Fix: Trying to download more than 5,000 rows at once would result in an error when memory limits were being exceeded.<\\/li>\\n<li>Fix: Some UI elements were not positioned properly on the global settings page.<\\/li>\\n<\\/ul>\\n","plugin":"formidable-export-view\\/formidable-export-view.php","icons":{"1x":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png"},"banners":{"high":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png","low":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png"},"search_terms":"export table","is_new":false},"26596685":{"title":"Directory","name":"Directory","display_name":"Directory","slug":"directory","version":"1.0.01","new_version":"1.0.01","location":["fp.strategy11.com\\/releases\\/directory\\/formidable-directory-1.0.01.zip"],"excerpt":"","id":26596685,"released":"2020-06-29 00:00:00","categories":["Business+Views","Solution"],"docs":"https:\\/\\/formidableforms.com\\/knowledgebase\\/formidable-directory\\/","link":"https:\\/\\/formidableforms.com\\/wordpress-directory-plugin\\/","changelog":"<h4>v1.0.01 - October 4, 2021<\\/h4>\\n<ul>\\n<li>Fix: The frm-letter-filter shortcode would always filter by lname instead of using the custom param option.<\\/li>\\n<\\/ul>\\n","plugin":"formidable-directory\\/formidable-directory.php","icons":{"1x":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png"},"banners":{"high":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png","low":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png"},"search_terms":"","beta":{"version":"100","location":["fp.strategy11.com\\/form-templates\\/business-directory.xml"]},"is_new":false},"28027505":{"title":"Views","name":"Views","display_name":"Legacy Views","slug":"views","version":"4.0.05","new_version":"4.0.05","location":["fp.strategy11.com\\/releases\\/views\\/formidable-views-4.0.05.zip"],"excerpt":"Add the power of views to your Formidable Forms to display your form submissions in listings, tables, calendars, and more.","id":28027505,"released":"2010-10-28 00:00:00","categories":["Strategy11"],"docs":"https:\\/\\/formidableforms.com\\/knowledgebase-category\\/views\\/","link":"https:\\/\\/formidableforms.com\\/downloads\\/views\\/","changelog":"<h4>v5.4.2 - October 25, 2023<\\/h4>\\n<ul>\\n<li>New: A new <span class=\\"blob-code-inner blob-code-marker js-code-nav-pass \\" data-code-marker=\\"+\\"><span class=\\"pl-s\\">frm_filter_final_view filter has been added for modifying the final result of a view.<\\/span><\\/span><\\/li>\\n<li>New: A few UI enhancements have been made. Now sliders for grid view settings include additional input fields with matching numeric values.<\\/li>\\n<li>New: The way CSS is added has been modified for better compatibility with the Snuffleupagus security module.<\\/li>\\n<li>New: The ID column is now sortable on the views list admin page.<\\/li>\\n<li>New: Some accessibility improvements have been added for view editor labels.<\\/li>\\n<li>New: A new filter has been added to support the new entry status types introduced with the form abandonment add on.<\\/li>\\n<li>Fix: Multiple warnings would get logged when sorting a view by a deleted field.<\\/li>\\n<li>Fix: Long view content would scroll underneath the type toggle elements.<\\/li>\\n<li>Fix: The preview result for address field shortcodes was not consistent with the front end result.<\\/li>\\n<li>Fix: The views editor would break with a fatal error when using the Google Listings and Ads plugin by WooCommerce. This conflict has been resolved.<\\/li>\\n<li>Fix: A Undefined array key PHP warning would get logged when loading the view editor if only a single view exists in the database.<\\/li>\\n<li>Fix: A deprecated use of self message would get logged when using the Gutenberg block for views.<\\/li>\\n<\\/ul>\\n<h4>v5.4 - March 13, 2023<\\/h4>\\n<ul>\\n<li>New: Added <span class=\\"blob-code-inner blob-code-marker js-code-nav-pass \\" data-code-marker=\\"+\\"><span class=\\"pl-s\\">frm_views_table_class<\\/span><\\/span> and <span class=\\"blob-code-inner blob-code-marker js-code-nav-pass \\" data-code-marker=\\"+\\"><span class=\\"pl-s\\">frm_display_inner_content_before_add_wrapper<\\/span><\\/span> filters.<\\/li>\\n<li>Fix: Prevent a PHP 8.2 deprecation message when handling hidden column screen option preferences for the table on the view list page.<\\/li>\\n<li>Fix: Detail page content would incorrectly be detected as not empty in grid views, causing issues with nested views displaying a \\"No entries found\\" message unexpectedly. This fix may require that a nested detail page with no content gets saved again in order to resolve.<\\/li>\\n<li>Updated styling so the visual view editor looks nicer with the v6.0 core update.<\\/li>\\n<li>Removed a deprecated jQuery function reference used when dismissing modals.<\\/li>\\n<\\/ul>\\n<h4>v5.2.1 - June 2, 2022<\\/h4>\\n<ul>\\n<li>New: Added a new Application column to the views list page.<\\/li>\\n<li>New: Improved support for the new Add\\/Edit Applications and Access Application Dashboard permission settings added in Pro.<\\/li>\\n<\\/ul>\\n","plugin":"formidable-views\\/formidable-views.php","icons":{"1x":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png"},"banners":{"high":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png","low":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png"},"search_terms":"","is_new":false},"28029934":{"title":"Formidable Pro Basic","name":"Formidable Pro Basic","display_name":"Formidable Pro Basic","slug":"formidable-basic2","version":"","new_version":"","location":[],"excerpt":"","id":28029934,"released":"2020-11-13 12:10:10","categories":[],"docs":"","link":"https:\\/\\/formidableforms.com\\/downloads\\/formidable-basic2\\/","changelog":"","plugin":"formidable-basic2\\/formidable-basic2.php","icons":{"1x":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png"},"banners":{"high":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png","low":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png"},"search_terms":"","is_new":false},"28058856":{"title":"Visual Views","name":"Visual Views","display_name":"Visual Views","slug":"visual-views","version":"5.6.1","new_version":"5.6.1","location":["fp.strategy11.com\\/releases\\/views\\/formidable-views-5.6.1.zip"],"excerpt":"Create WordPress web apps to display your form submissions in grids, tables, calendars, and more.","id":28058856,"released":"2021-05-31 00:00:00","categories":["Creator","Strategy11"],"docs":"https:\\/\\/formidableforms.com\\/knowledgebase-category\\/views\\/","link":"https:\\/\\/formidableforms.com\\/downloads\\/visual-views\\/","changelog":"<h4>v5.6.1 - May 15, 2024<\\/h4>\\n<ul>\\n<li>Fix: A JavaScript error introduced in last release that would cause issues with editing some views has been fixed.<\\/li>\\n<\\/ul>\\n<h4>v5.6 - May 14, 2024<\\/h4>\\n<ul>\\n<li>New: A new Show Event Details Pop-up setting has been added to Calendar views, as well as several new settings for customizing the content of the new pop up.<\\/li>\\n<li>New: New settings have been added to customize Calendar views in the Gutenberg block editor.<\\/li>\\n<li>New: Support for map views has been added. This also requires v1.3 of the Geolocation add-on.<\\/li>\\n<li>New: Views now support a new option to refresh with AJAX when a form is submitted.<\\/li>\\n<li>New: Calendar views will now show a calendar preview in the visual views editor.<\\/li>\\n<li>New: Views sorted by random are now seeded. This allows for consistent randomized results when switching between multiple pages.<\\/li>\\n<li>New: The collapsible sections in the visual views editor have been updated to improve screen reader accessibility.<\\/li>\\n<li>Fix: Detail pages were not working as expected when using the offset setting.<\\/li>\\n<li>Fix: A JavaScript error would get triggered when dragging a table view column for forms without entries.<\\/li>\\n<li>Views sorted by random are now randomized with PHP instead of with SQL. This fixes a conflict with WP Engine hosting where ordering by random using SQL is disabled.<\\/li>\\n<\\/ul>\\n<h4>v5.5.1 - January 29, 2024<\\/h4>\\n<ul>\\n<li>New: Views can now be filtered by a name field, including new (First) and (Last) options.<\\/li>\\n<li>Fix: AJAX pagination would break for classic views structured like a list using ul or ol tags in the before and after content with li tags in the content.<\\/li>\\n<li>Fix: The options for a year dropdown in a calendar view were missing expected year filter options when using field data for the event date.<\\/li>\\n<li>The \\"like\\" filtering condition option has been renamed to \\"contains\\", and \\"NOT like\\" has been renamed to \\"does not contain\\".<\\/li>\\n<\\/ul>\\n","plugin":"formidable-views\\/formidable-views.php","icons":{"1x":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png"},"banners":{"high":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png","low":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png"},"search_terms":"","is_new":false},"28058858":{"title":"Formidable Views + Forms Basic","name":"Formidable Views + Forms Basic","display_name":"Formidable Views + Forms Basic","slug":"formidable-views-basic","version":"","new_version":"","location":[],"excerpt":"","id":28058858,"released":"2021-05-12 12:29:57","categories":[],"docs":"","link":"https:\\/\\/formidableforms.com\\/downloads\\/formidable-views-basic\\/","changelog":"","plugin":"formidable-views-basic\\/formidable-views-basic.php","icons":{"1x":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png"},"banners":{"high":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png","low":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png"},"search_terms":"","is_new":false},"28058860":{"title":"Formidable Apps + Forms Elite","name":"Formidable Apps + Forms Elite","display_name":"Formidable Apps + Forms Elite","slug":"formidable-views-elite","version":"","new_version":"","location":[],"excerpt":"","id":28058860,"released":"2021-05-12 12:22:02","categories":[],"docs":"","link":"https:\\/\\/formidableforms.com\\/downloads\\/formidable-views-elite\\/","changelog":"","plugin":"formidable-views-elite\\/formidable-views-elite.php","icons":{"1x":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png"},"banners":{"high":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png","low":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png"},"search_terms":"","is_new":false},"28058862":{"title":"Formidable Apps + Forms Business","name":"Formidable Apps + Forms Business","display_name":"Formidable Apps + Forms Business","slug":"formidable-views-business","version":"","new_version":"","location":[],"excerpt":"","id":28058862,"released":"2021-05-12 12:27:07","categories":[],"docs":"","link":"https:\\/\\/formidableforms.com\\/downloads\\/formidable-views-business\\/","changelog":"","plugin":"formidable-views-business\\/formidable-views-business.php","icons":{"1x":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png"},"banners":{"high":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png","low":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png"},"search_terms":"","is_new":false},"28058864":{"title":"Formidable Views + Forms Plus","name":"Formidable Views + Forms Plus","display_name":"Formidable Views + Forms Plus","slug":"formidable-views-plus","version":"","new_version":"","location":[],"excerpt":"","id":28058864,"released":"2021-05-12 12:28:21","categories":[],"docs":"","link":"https:\\/\\/formidableforms.com\\/downloads\\/formidable-views-plus\\/","changelog":"","plugin":"formidable-views-plus\\/formidable-views-plus.php","icons":{"1x":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png"},"banners":{"high":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png","low":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png"},"search_terms":"","is_new":false},"28067256":{"title":"Surveys and Polls","name":"Surveys and Polls","display_name":"Surveys and Polls","slug":"surveys","version":"1.1.1","new_version":"1.1.1","location":["fp.strategy11.com\\/releases\\/surveys\\/formidable-surveys-1.1.1.zip"],"excerpt":"Transform your WordPress site into a data collection machine with our user-friendly survey form builder.","id":28067256,"released":"2021-09-16 00:00:00","categories":["Business","Strategy11"],"docs":"https:\\/\\/formidableforms.com\\/knowledgebase\\/surveys-and-polls-forms\\/","link":"https:\\/\\/formidableforms.com\\/downloads\\/surveys\\/","changelog":"<h4>v1.1.1 - May 30, 2024<\\/h4>\\n<ul>\\n<li>New: Ranking field dropdowns have been made slightly larger by default, to avoid issues where dropdown options would appear cut off on some browsers, including mobile browsers.<\\/li>\\n<li>New: Strings used in this plugin can now be translated.<\\/li>\\n<li>New: Field IDs for likert field questions are now displayed in the form builder for an easier reference.<\\/li>\\n<li>Fix: The wrong page would load when displaying errors for a required likert field.<\\/li>\\n<li>Fix: Likert field values would not appear in a view when used in an embedded form.<\\/li>\\n<li>A few field type checks have been optimized, fixing an issue where the form builder would take significantly more time to load forms with a lot of fields and conditional logic when the Surveys add-0n was active.<\\/li>\\n<\\/ul>\\n<h4>v1.1 - March 12, 2024<\\/h4>\\n<ul>\\n<li>New: A new Ranking field type has been added. Now you can easily rank a list of options.<\\/li>\\n<li>Fix: In some cases likert rows would be missing from CSV exports.<\\/li>\\n<li>Fix: Read only radio buttons displayed as buttons no longer have hover styles.<\\/li>\\n<li>Fix: Unexpected empty boxes would appear in summary fields in forms with likert fields.<\\/li>\\n<li>The placeholder image is no longer visible on the front end when using the button display type with images and no image uploaded.<\\/li>\\n<\\/ul>\\n<h4>v1.0.12 - January 29, 2024<\\/h4>\\n<ul>\\n<li>New: Likert questions will now appear as options in the field calculation shortcode options pop up.<\\/li>\\n<li>Fix: NPS graphs on the reports page were not properly filtering for a specified date range.<\\/li>\\n<li>Fix: Likert fields would were not appearing in the expected layout when inside of a collapsible section.<\\/li>\\n<li>Fix: [[frm-graph]] shortcodes were not working when including an NPS field and another field in the graph data.<\\/li>\\n<li>Fix: Likert questions would not display when setting the likert field label position to hidden.<\\/li>\\n<li>New likert field descriptions are now displayed underneath the questions by default like other field descriptions.<\\/li>\\n<\\/ul>\\n","plugin":"formidable-surveys\\/formidable-surveys.php","icons":{"1x":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png"},"banners":{"high":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png","low":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png"},"search_terms":"","is_new":false},"28074303":{"title":"Landing Pages","name":"Landing Pages","display_name":"Landing Pages","slug":"landing-pages","version":"1.0.01","new_version":"1.0.01","location":["fp.strategy11.com\\/releases\\/landing\\/formidable-landing-1.0.01.zip"],"excerpt":"Create beautiful landing pages fast and rake in new leads.","id":28074303,"released":"2022-01-06 00:00:00","categories":["Creator","Strategy11"],"docs":"https:\\/\\/formidableforms.com\\/knowledgebase\\/landing-pages\\/","link":"https:\\/\\/formidableforms.com\\/downloads\\/landing-pages\\/","changelog":"<p>No Changes Found<\\/p>\\n","plugin":"formidable-landing\\/formidable-landing.php","icons":{"1x":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png"},"banners":{"high":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png","low":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png"},"search_terms":"","is_new":false},"28100793":{"title":"Conversational Forms","name":"Conversational Forms","display_name":"Conversational Forms","slug":"conversational-forms","version":"1.1.3","new_version":"1.1.3","location":["fp.strategy11.com\\/releases\\/chat\\/formidable-chat-1.1.3.zip"],"excerpt":"Ask one question at a time to humanize forms and boost their conversion rates.","id":28100793,"released":"2022-01-25 00:00:00","categories":["Business"],"docs":"https:\\/\\/formidableforms.com\\/knowledgebase\\/conversational-forms\\/","link":"https:\\/\\/formidableforms.com\\/downloads\\/conversational-forms\\/","changelog":"<h4>v1.1.3 - April 18, 2024<\\/h4>\\n<ul>\\n<li>Fix: Submit button fields were appearing as a conversational form question. These are now skipped.<\\/li>\\n<li>Completed Turnstile CAPTCHA fields are now skipped automatically.<\\/li>\\n<\\/ul>\\n<h4>v1.1.2 - March 11, 2024<\\/h4>\\n<ul>\\n<li>Fix: A conditionally hidden field would be visible when inside of a conditionally visible section regardless of the conditional logic on the field itself.<\\/li>\\n<li>Fix: A conversational form would advance to the next question after a disabled radio button was clicked.<\\/li>\\n<li>Fix: A conversational form would break when clicking the previous button when the form included a quiz score field.<\\/li>\\n<\\/ul>\\n<h4>v1.1.1 - January 15, 2024<\\/h4>\\n<ul>\\n<li>New: Shortcodes can now be used in fields labels and HTML field descriptions in conversational forms without the need to add page breaks.<\\/li>\\n<li>New: The way CSS is added has been updated for better compatibility with the Snuffleupagus security module.<\\/li>\\n<li>Fix: Fields that have associated likert data but are no longer children of a likert field were not rendering as expected in a conversational form, appearing on the start page instead.<\\/li>\\n<li>Fix: An attempt to read property \\"id\\" on null PHP warning has been fixed.<\\/li>\\n<li>Fix: Radio buttons in sections would get partially cut off in a conversational form.<\\/li>\\n<li>Fix: Remove buttons were never appearing in repeaters in conversational forms.<\\/li>\\n<li>Fix: SVG icons were not properly getting copied in repeater add\\/remove buttons in conversational forms.<\\/li>\\n<\\/ul>\\n","plugin":"formidable-chat\\/formidable-chat.php","icons":{"1x":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png"},"banners":{"high":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png","low":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png"},"search_terms":"","is_new":false},"28118399":{"title":"Geolocation","name":"Geolocation","display_name":"Geolocation","slug":"geolocation","version":"1.3","new_version":"1.3","location":["fp.strategy11.com\\/releases\\/geo\\/formidable-geo-1.3.zip"],"excerpt":"Get more accurate data and make forms faster to complete with address autocomplete.","id":28118399,"released":"2022-04-12 00:00:00","categories":["Business"],"docs":"https:\\/\\/formidableforms.com\\/knowledgebase\\/geolocation\\/","link":"https:\\/\\/formidableforms.com\\/downloads\\/geolocation\\/","changelog":"<h4>v1.3 - May 14, 2024<\\/h4>\\n<ul>\\n<li>New: Support for a new map view type has been added. This also requires version 5.6 of Visual Views.<\\/li>\\n<li>New: When the line1 input in an Address field is empty, the place name will be used for the line1 value instead. And when using a text field, the place name will always be added unless the place name was already included. This is useful for getting more accurate autofill results for some location types including airports.<\\/li>\\n<li>Fix: The show=\\"lat\\" and show=\\"long\\" options were not working when used in email actions.<\\/li>\\n<\\/ul>\\n<h4>v1.2.1 - January 15, 2024<\\/h4>\\n<ul>\\n<li>New: Autocomplete results are no longer restricted to only show geocoding results. This setting was preventing some search result types including locations like the Eiffel Tower and the Great Wall of China. A new frm_geo_autocomplete_options filter has been added to make this more flexible, as well as a few new helper functions. To restore the previous autocomplete behaviour, use add_filter( \'frm_geo_autocomplete_options\', \'FrmGeoAppController::use_geocode_autocomplete_type\' );.<\\/li>\\n<li>New: Fewer fields will be retrieved when making API requests. This should help to reduce API-related costs.<\\/li>\\n<li>New: Addresses with subpremise address details will now conditionally populate additional information either as part of the street number like 10\\/27, or as part of line2 for values like \\"apt 123\\".<\\/li>\\n<li>New: The exact latitude and longitude will now be used when dragging and dropping a pin marker.<\\/li>\\n<li>New: The map will now update to show the geocoded match result when processing a visitor\'s location.<\\/li>\\n<li>Fix: The fallback default location will no longer get set when editing an entry and declining to use the visitor\'s location.<\\/li>\\n<\\/ul>\\n<h4>v1.2 - November 28, 2023<\\/h4>\\n<ul>\\n<li>New: When auto-completing an address field for special types of locations without addresses like the Statue of Liberty or Times Square, the line1 field will now be populated with the premise or town_square place types, not just the route.<\\/li>\\n<li>New: Address fields using location data now support show=long, show=lat, and show=map shortcode options. Note that in order for show=map to work, you will also need to include keepjs=1.<\\/li>\\n<li>New: When a location does not have an available locality, administrative_area_level_3, or sublocality, the city input will be filled by a postal_town address type if it is available.<\\/li>\\n<li>New: Event listeners have been updated to no longer use the deprecated addDomListener function.<\\/li>\\n<li>Fix: A required address field inside of a repeater would still fail validation when the state abbreviation data was unavailable.<\\/li>\\n<li>Fix: A place.geometry is undefined error would get logged in the JavaScript console when pressing enter with no location selected.<\\/li>\\n<li>Fix: Third party map plugins were breaking on pages without Formidable forms because the Google script was being disabled. This has been updated to only disable third party scripts when Formidable Forms is loading the Google script instead.<\\/li>\\n<\\/ul>\\n","plugin":"formidable-geo\\/formidable-geo.php","icons":{"1x":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png"},"banners":{"high":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png","low":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png"},"search_terms":"","is_new":false},"28123662":{"title":"FAQ","name":"FAQ","display_name":"FAQ","slug":"faq","version":"","new_version":"","location":[],"excerpt":"","id":28123662,"released":"2022-05-02 13:25:45","categories":["Solution","Strategy11"],"docs":"","link":"https:\\/\\/formidableforms.com\\/downloads\\/faq\\/","changelog":"","plugin":"faq\\/faq.php","icons":{"1x":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png"},"banners":{"high":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png","low":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png"},"search_terms":"","is_new":false},"28123664":{"title":"Restaurant Menu","name":"Restaurant Menu","display_name":"Restaurant Menu","slug":"restaurant-menu","version":"","new_version":"","location":[],"excerpt":"","id":28123664,"released":"2022-05-02 13:25:31","categories":["Solution","Strategy11"],"docs":"","link":"https:\\/\\/formidableforms.com\\/downloads\\/restaurant-menu\\/","changelog":"","plugin":"restaurant-menu\\/restaurant-menu.php","icons":{"1x":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png"},"banners":{"high":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png","low":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png"},"search_terms":"","is_new":false},"28123666":{"title":"Business Hours","name":"Business Hours","display_name":"Business Hours","slug":"business-hours","version":"","new_version":"","location":[],"excerpt":"","id":28123666,"released":"2022-05-02 13:25:15","categories":["Solution","Strategy11"],"docs":"","link":"https:\\/\\/formidableforms.com\\/downloads\\/business-hours\\/","changelog":"","plugin":"business-hours\\/business-hours.php","icons":{"1x":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png"},"banners":{"high":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png","low":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png"},"search_terms":"","is_new":false},"28123668":{"title":"Team Directory","name":"Team Directory","display_name":"Team Directory","slug":"team-directory","version":"","new_version":"","location":[],"excerpt":"","id":28123668,"released":"2022-05-02 13:24:48","categories":["Solution","Strategy11"],"docs":"","link":"https:\\/\\/formidableforms.com\\/downloads\\/team-directory\\/","changelog":"","plugin":"team-directory\\/team-directory.php","icons":{"1x":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png"},"banners":{"high":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png","low":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png"},"search_terms":"","is_new":false},"28123670":{"title":"Application Shortcuts","name":"Application Shortcuts","display_name":"Application Shortcuts","slug":"application-shortcuts","version":"","new_version":"","location":[],"excerpt":"","id":28123670,"released":"2022-05-02 13:38:05","categories":["Solution","Strategy11"],"docs":"","link":"https:\\/\\/formidableforms.com\\/downloads\\/application-shortcuts\\/","changelog":"","plugin":"application-shortcuts\\/application-shortcuts.php","icons":{"1x":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png"},"banners":{"high":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png","low":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png"},"search_terms":"","is_new":false},"28124331":{"title":"Real Estate Listings","name":"Real Estate Listings","display_name":"Real Estate Listings","slug":"real-estate-listings","version":"","new_version":"","location":[],"excerpt":"","id":28124331,"released":"2022-05-05 13:53:10","categories":["Solution","Strategy11"],"docs":"","link":"https:\\/\\/formidableforms.com\\/downloads\\/real-estate-listings\\/","changelog":"","plugin":"real-estate-listings\\/real-estate-listings.php","icons":{"1x":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png"},"banners":{"high":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png","low":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png"},"search_terms":"","is_new":false},"28124372":{"title":"Product Reviews","name":"Product Reviews","display_name":"Product Reviews","slug":"product-reviews","version":"","new_version":"","location":[],"excerpt":"","id":28124372,"released":"2022-05-05 16:39:04","categories":["Solution","Strategy11"],"docs":"","link":"https:\\/\\/formidableforms.com\\/downloads\\/product-reviews\\/","changelog":"","plugin":"product-reviews\\/product-reviews.php","icons":{"1x":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png"},"banners":{"high":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png","low":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png"},"search_terms":"","is_new":false},"28127946":{"title":"Link in Bio Instagram Grid","name":"Link in Bio Instagram Grid","display_name":"Link in Bio Instagram Grid","slug":"link-in-bio-instagram-grid","version":"","new_version":"","location":[],"excerpt":"","id":28127946,"released":"2022-05-25 14:13:43","categories":["Solution","Strategy11"],"docs":"","link":"https:\\/\\/formidableforms.com\\/downloads\\/link-in-bio-instagram-grid\\/","changelog":"","plugin":"link-in-bio-instagram-grid\\/link-in-bio-instagram-grid.php","icons":{"1x":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png"},"banners":{"high":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png","low":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png"},"search_terms":"","is_new":false},"28136428":{"title":"PDFs","name":"PDFs","display_name":"PDFs","slug":"pdfs","version":"2.0.3","new_version":"2.0.3","location":["fp.strategy11.com\\/releases\\/pdfs\\/formidable-pdfs-2.0.3.zip"],"excerpt":"Create PDFs from form entries automatically. Email them or let visitors download PDFs from your site.","id":28136428,"released":"2022-08-09 00:00:00","categories":["Business"],"docs":"https:\\/\\/formidableforms.com\\/knowledgebase\\/pdfs\\/","link":"https:\\/\\/formidableforms.com\\/downloads\\/pdfs\\/","changelog":"<h4>v2.0.3 - December 14, 2023<\\/h4>\\n<ul>\\n<li>Fix: An update in the previous release caused PDFs with special characters to appear broken with unexpected characters in place.<\\/li>\\n<\\/ul>\\n<h4>v2.0.2 - December 13, 2023<\\/h4>\\n<ul>\\n<li>New: PDF shortcodes now support a show_pagination=1 option. When this is included, pagination will be added to each page.<\\/li>\\n<li>New: New frm_pdfs_before_render and frm_pdfs_after_render actions have been added to allow for customization of PDFs with code. This allows developers to add custom page_script calls in their custom code.<\\/li>\\n<li>Fix: SVG icons would appear blank in generated PDFs. This included thumbnails for some file types including docx and xlsx, as well as star rating icons.<\\/li>\\n<li>Fix: Images would appear broken in generated PDFs when file protection was enabled.<\\/li>\\n<li>Fix: Grid views would trigger fatal errors when generating PDFs.<\\/li>\\n<li>Fix: A conflict with the iThemes Security plugin would block images in generated PDFs.<\\/li>\\n<\\/ul>\\n<h4>v2.0.1 - June 5, 2023<\\/h4>\\n<ul>\\n<li>New: Field shortcodes will now process in field labels inside of PDFs.<\\/li>\\n<li>New: The ctype_alpha function is now polyfilled when the ctype extension is unavailable for better compatibility.<\\/li>\\n<li>Fix: The frm_pdfs_export_content filter was missing the entry value, causing some custom code to break in version 2.0.<\\/li>\\n<li>The toggle to enable PDF attachments in emails will appear more consistent with other toggles.<\\/li>\\n<\\/ul>\\n","plugin":"formidable-pdfs\\/formidable-pdfs.php","icons":{"1x":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png"},"banners":{"high":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png","low":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png"},"search_terms":"","is_new":false},"28144027":{"title":"Member Directory","name":"Member Directory","display_name":"Member Directory","slug":"member-directory","version":"","new_version":"","location":[],"excerpt":"","id":28144027,"released":"2022-08-24 15:18:56","categories":["Solution","Strategy11"],"docs":"","link":"https:\\/\\/formidableforms.com\\/downloads\\/member-directory\\/","changelog":"","plugin":"member-directory\\/member-directory.php","icons":{"1x":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png"},"banners":{"high":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png","low":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png"},"search_terms":"","is_new":false},"28144089":{"title":"Business Directory","name":"Business Directory","display_name":"Business Directory","slug":"business-directory","version":"","new_version":"","location":[],"excerpt":"","id":28144089,"released":"2022-08-24 16:41:02","categories":["Solution","Strategy11"],"docs":"","link":"https:\\/\\/formidableforms.com\\/downloads\\/business-directory\\/","changelog":"","plugin":"business-directory\\/business-directory.php","icons":{"1x":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png"},"banners":{"high":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png","low":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png"},"search_terms":"","is_new":false},"28149579":{"title":"Google Sheets","name":"Google Sheets","display_name":"Google Sheets","slug":"google-sheets","version":"1.0.2","new_version":"1.0.2","location":["fp.strategy11.com\\/releases\\/google-sheets\\/formidable-googlespreadsheet-1.0.2.zip"],"excerpt":"Send form entries to a Google spreadsheet as a backup or for extra processing.","id":28149579,"released":"2022-10-18 00:00:00","categories":["Business"],"docs":"https:\\/\\/formidableforms.com\\/knowledgebase\\/google-spreadsheet-forms\\/","link":"https:\\/\\/formidableforms.com\\/downloads\\/google-sheets\\/","changelog":"<h4>v1.0.2 - October 18, 2023<\\/h4>\\n<ul>\\n<li>New: Currency symbols in total fields are no longer sent as encoded HTML entities. These symbols will now appear in Google Sheets as the proper symbol.<\\/li>\\n<li>Fix: Signature field shortcodes would always display a signature as a URL instead of an image when the Google Sheets add on was active.<\\/li>\\n<\\/ul>\\n<h4>v1.0.1 - February 9, 2023<\\/h4>\\n<ul>\\n<li>Fix: Trying to deactivate Google Sheets wouldn\'t work if removed from the Google console first with an error stating that deauthorization failed.<\\/li>\\n<\\/ul>\\n","plugin":"formidable-googlespreadsheet\\/formidable-googlespreadsheet.php","icons":{"1x":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png"},"banners":{"high":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png","low":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png"},"search_terms":"","is_new":false},"28158728":{"title":"ACF Forms","name":"ACF Forms","display_name":"ACF Forms","slug":"acf-forms","version":"1.0.1","new_version":"1.0.1","location":["fp.strategy11.com\\/releases\\/acf\\/formidable-acf-1.0.1.zip"],"excerpt":"Sync custom fields between Formidable and Advanced Custom Fields or ACF Pro.","id":28158728,"released":"2022-12-13 00:00:00","categories":["Business"],"docs":"https:\\/\\/formidableforms.com\\/knowledgebase\\/acf-form\\/","link":"https:\\/\\/formidableforms.com\\/downloads\\/acf-forms\\/","changelog":"<h4>v1.0.1 - July 6, 2023<\\/h4>\\n<ul>\\n<li>Fix: Repeater values were not appearing for posts until the post was manually updated.<\\/li>\\n<\\/ul>\\n","plugin":"formidable-acf\\/formidable-acf.php","icons":{"1x":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png"},"banners":{"high":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png","low":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png"},"search_terms":"advanced, custom fields","is_new":false},"28189169":{"title":"AI","name":"AI","display_name":"AI Forms","slug":"ai","version":"1.0.1","new_version":"1.0.1","location":["fp.strategy11.com\\/releases\\/ai\\/formidable-ai-1.0.1.zip"],"excerpt":"Get back your time by autogenerating a response from ChatGPT and inserting it into a field.","id":28189169,"released":"2023-04-11 00:00:00","categories":["Business"],"docs":"https:\\/\\/formidableforms.com\\/knowledgebase\\/form-ai\\/","link":"https:\\/\\/formidableforms.com\\/downloads\\/ai\\/","changelog":"<h4>v1.0.1 - May 3, 2023<\\/h4>\\n<ul>\\n<li>New: AI fields will now watch more types of fields including address fields, name fields, radio buttons, dropdowns, checkboxes, embedded fields.<\\/li>\\n<li>New: Line breaks in AI responses will now be preserved.<\\/li>\\n<li>Fix: A missing null check would cause a JavaScript error to break some forms when the AI answer isn\'t included in the form.<\\/li>\\n<li>An ongoing AI request will now be aborted early when a new request begins.<\\/li>\\n<\\/ul>\\n","plugin":"formidable-ai\\/formidable-ai.php","icons":{"1x":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png"},"banners":{"high":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png","low":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png"},"search_terms":"chatgpt, openai, automate","is_new":false},"28217763":{"title":"Abandonment","name":"Abandonment","display_name":"Form Abandonment","slug":"abandonment","version":"1.1.3","new_version":"1.1.3","location":["fp.strategy11.com\\/releases\\/abandonment\\/formidable-abandonment-1.1.3.zip"],"excerpt":"Capture form data before it\'s submitted to save more leads and optimize forms. Plus, auto save drafts and allow logged out editing.","id":28217763,"released":"2023-10-24 00:00:00","categories":["Business"],"docs":"https:\\/\\/formidableforms.com\\/knowledgebase\\/form-abandonment\\/","link":"https:\\/\\/formidableforms.com\\/downloads\\/abandonment\\/","changelog":"<h4>v1.1.3 - April 16, 2024<\\/h4>\\n<ul>\\n<li>Fix: Forms with repeaters would change to submitted status after auto-saving, resulting in a \\"You do not have permission to view this form\\" error after submitting the form for users that are not logged in.<\\/li>\\n<\\/ul>\\n<h4>v1.1.2 - March 11, 2024<\\/h4>\\n<ul>\\n<li>Fix: Checkbox values were not properly saving when auto-saving form data.<\\/li>\\n<li>Fix: Actions that trigger when an entry is created would not trigger as expected when changing from In-Progress status to Submitted status.<\\/li>\\n<\\/ul>\\n<h4>v1.1.1 - February 27, 2024<\\/h4>\\n<ul>\\n<li>Fix: A new entry would get created on every autosave event when the form included redirect confirmation actions.<\\/li>\\n<li>Fix: Create actions would trigger instead of update actions on entry update when the abandonment plugin was active.<\\/li>\\n<li>Fix: The created_at entry value would update every time an entry is updated when the abandonment plugin was active.<\\/li>\\n<\\/ul>\\n","plugin":"formidable-abandonment\\/formidable-abandonment.php","icons":{"1x":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png"},"banners":{"high":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png","low":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png"},"search_terms":"partial, save, continue","is_new":false},"28248560":{"title":"Charts","name":"Charts","display_name":"Charts","slug":"charts","version":"1.0.2","new_version":"1.0.2","location":["fp.strategy11.com\\/releases\\/charts\\/formidable-charts-1.0.2.zip"],"excerpt":"Transform form data into insightful graphs with ease.","id":28248560,"released":"2024-01-09 00:00:00","categories":["Creator"],"docs":"https:\\/\\/formidableforms.com\\/knowledgebase\\/graphs\\/","link":"https:\\/\\/formidableforms.com\\/downloads\\/charts\\/","changelog":"<h4>v1.0.2 - April 29, 2024<\\/h4>\\n<ul>\\n<li>New: Field options can now be dragged and dropped to define which order they are applied in the graph.<\\/li>\\n<li>Fix: Apostrophes used for title options were getting encoded as HTML entities.<\\/li>\\n<li>Fix: Long form names would cause UI issues in the data source dropdown.<\\/li>\\n<\\/ul>\\n<h4>v1.0.1 - March 11, 2024<\\/h4>\\n<ul>\\n<li>New: The data type dropdown setting now supports new options for the highest and lowest values in a set.<\\/li>\\n<li>Fix: The horizontal axis data source was not saving as expected.<\\/li>\\n<\\/ul>\\n","plugin":"formidable-charts\\/formidable-charts.php","icons":{"1x":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png"},"banners":{"high":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png","low":"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png"},"search_terms":"graph","is_new":false},"response_code":200}";s:7:"version";s:5:"6.9.1";}','no');
INSERT INTO `hs_options` VALUES (5917,'frm_summary_emails_options','a:3:{s:12:"last_monthly";s:10:"2024-05-24";s:11:"last_yearly";s:0:"";s:12:"renewal_date";s:10:"2025-05-09";}','yes');
INSERT INTO `hs_options` VALUES (5932,'frm_inbox','a:2:{s:5:"usage";a:9:{s:7:"message";s:541:"Gathering usage data allows us to improve Formidable. Your forms will be considered as we evaluate new features, judge the quality of an update, or determine if an improvement makes sense. You can always visit the <a href="https://hs.vicq.org/wp-admin/admin.php?page=formidable-settings&#038;t=misc_settings">Global Settings</a> and choose to stop sharing data. <a href="https://formidableforms.com/knowledgebase/global-settings-overview/#kb-usage-tracking" target="_blank" rel="noopener noreferrer">Read more about what data we collect</a>.";s:7:"subject";s:67:"Aidez Formidable à s’améliorer avec le suivi de l’utilisation";s:4:"icon";s:16:"frm_tooltip_icon";s:3:"cta";s:253:"<a href="#" class="frm-button-secondary frm_inbox_dismiss">Dismiss</a> <a href="https://hs.vicq.org/wp-admin/admin.php?page=formidable-settings&#038;t=misc_settings" class="button-primary frm-button-primary frm_inbox_dismiss">Activate usage tracking</a>";s:7:"expires";b:0;s:3:"who";s:3:"all";s:4:"type";s:8:"feedback";s:3:"key";s:5:"usage";s:7:"created";i:1715280597;}s:14:"free_templates";a:9:{s:7:"message";s:65:"Add your email address to get a code for 20+ free form templates.";s:7:"subject";s:27:"Get 20+ Free Form Templates";s:4:"icon";s:16:"frm_tooltip_icon";s:3:"cta";s:226:"<a href="#" class="frm-button-secondary frm_inbox_dismiss">Dismiss</a> <a href="https://hs.vicq.org/wp-admin/admin.php?page=formidable-form-templates&#038;free-templates=1" class="button-primary frm-button-primary">Get Now</a>";s:7:"expires";b:0;s:3:"who";s:3:"all";s:4:"type";s:8:"feedback";s:3:"key";s:14:"free_templates";s:7:"created";i:1715280597;}}','no');
INSERT INTO `hs_options` VALUES (5935,'frm_yt_videos','a:3:{s:7:"timeout";i:1715302197;s:5:"value";s:21:"{"response_code":403}";s:7:"version";s:5:"6.9.1";}','no');
INSERT INTO `hs_options` VALUES (5938,'frm_form_templates_l','a:3:{s:7:"timeout";i:1715323797;s:5:"value";s:21:"{"response_code":403}";s:7:"version";s:5:"6.9.1";}','no');
INSERT INTO `hs_options` VALUES (5939,'frm_connect_token','6819c07d5a1ca7e15b752453815c49adc849d05fa3d1cdd27d72f8b1d30649ed3be4a12231dd91672b7f7c8fe62404ade34eda6674a301f510a16c1cf37fde29','no');
INSERT INTO `hs_options` VALUES (6042,'frm_dismiss_ip_address_notice','1','no');
INSERT INTO `hs_options` VALUES (6106,'_transient_is_multi_author','0','yes');
INSERT INTO `hs_options` VALUES (6743,'_site_transient_update_core','O:8:"stdClass":4:{s:7:"updates";a:1:{i:0;O:8:"stdClass":10:{s:8:"response";s:6:"latest";s:8:"download";s:65:"https://downloads.wordpress.org/release/fr_FR/wordpress-6.5.4.zip";s:6:"locale";s:5:"fr_FR";s:8:"packages";O:8:"stdClass":5:{s:4:"full";s:65:"https://downloads.wordpress.org/release/fr_FR/wordpress-6.5.4.zip";s:10:"no_content";s:0:"";s:11:"new_bundled";s:0:"";s:7:"partial";s:0:"";s:8:"rollback";s:0:"";}s:7:"current";s:5:"6.5.4";s:7:"version";s:5:"6.5.4";s:11:"php_version";s:5:"7.0.0";s:13:"mysql_version";s:3:"5.0";s:11:"new_bundled";s:3:"6.4";s:15:"partial_version";s:0:"";}}s:12:"last_checked";i:1717690232;s:15:"version_checked";s:5:"6.5.4";s:12:"translations";a:0:{}}','no');
INSERT INTO `hs_options` VALUES (6776,'_site_transient_timeout_theme_roots','1717692033','no');
INSERT INTO `hs_options` VALUES (6777,'_site_transient_theme_roots','a:4:{s:16:"agriculture-farm";s:7:"/themes";s:19:"agriculture-farming";s:7:"/themes";s:12:"organic-farm";s:7:"/themes";s:16:"twentytwentyfour";s:7:"/themes";}','no');
INSERT INTO `hs_options` VALUES (6778,'_site_transient_update_themes','O:8:"stdClass":5:{s:12:"last_checked";i:1717690236;s:7:"checked";a:4:{s:16:"agriculture-farm";s:5:"0.6.4";s:19:"agriculture-farming";s:3:"3.5";s:12:"organic-farm";s:3:"1.5";s:16:"twentytwentyfour";s:3:"1.0";}s:8:"response";a:1:{s:16:"twentytwentyfour";a:6:{s:5:"theme";s:16:"twentytwentyfour";s:11:"new_version";s:3:"1.1";s:3:"url";s:46:"https://wordpress.org/themes/twentytwentyfour/";s:7:"package";s:62:"https://downloads.wordpress.org/theme/twentytwentyfour.1.1.zip";s:8:"requires";s:3:"6.4";s:12:"requires_php";s:3:"7.0";}}s:9:"no_update";a:3:{s:16:"agriculture-farm";a:6:{s:5:"theme";s:16:"agriculture-farm";s:11:"new_version";s:5:"0.6.4";s:3:"url";s:46:"https://wordpress.org/themes/agriculture-farm/";s:7:"package";s:64:"https://downloads.wordpress.org/theme/agriculture-farm.0.6.4.zip";s:8:"requires";s:3:"5.0";s:12:"requires_php";s:3:"7.2";}s:19:"agriculture-farming";a:6:{s:5:"theme";s:19:"agriculture-farming";s:11:"new_version";s:3:"3.5";s:3:"url";s:49:"https://wordpress.org/themes/agriculture-farming/";s:7:"package";s:65:"https://downloads.wordpress.org/theme/agriculture-farming.3.5.zip";s:8:"requires";s:3:"5.0";s:12:"requires_php";s:3:"5.6";}s:12:"organic-farm";a:6:{s:5:"theme";s:12:"organic-farm";s:11:"new_version";s:3:"1.5";s:3:"url";s:42:"https://wordpress.org/themes/organic-farm/";s:7:"package";s:58:"https://downloads.wordpress.org/theme/organic-farm.1.5.zip";s:8:"requires";s:3:"5.0";s:12:"requires_php";s:3:"5.6";}}s:12:"translations";a:0:{}}','no');
INSERT INTO `hs_options` VALUES (6779,'_site_transient_update_plugins','O:8:"stdClass":5:{s:12:"last_checked";i:1717690237;s:8:"response";a:1:{s:25:"formidable/formidable.php";O:8:"stdClass":13:{s:2:"id";s:24:"w.org/plugins/formidable";s:4:"slug";s:10:"formidable";s:6:"plugin";s:25:"formidable/formidable.php";s:11:"new_version";s:4:"6.10";s:3:"url";s:41:"https://wordpress.org/plugins/formidable/";s:7:"package";s:58:"https://downloads.wordpress.org/plugin/formidable.6.10.zip";s:5:"icons";a:2:{s:2:"2x";s:63:"https://ps.w.org/formidable/assets/icon-256x256.png?rev=2588749";s:2:"1x";s:63:"https://ps.w.org/formidable/assets/icon-128x128.png?rev=2588749";}s:7:"banners";a:2:{s:2:"2x";s:66:"https://ps.w.org/formidable/assets/banner-1544x500.png?rev=2588749";s:2:"1x";s:65:"https://ps.w.org/formidable/assets/banner-772x250.png?rev=2588749";}s:11:"banners_rtl";a:0:{}s:8:"requires";s:3:"5.2";s:6:"tested";s:5:"6.5.4";s:12:"requires_php";s:3:"7.0";s:16:"requires_plugins";a:0:{}}}s:12:"translations";a:0:{}s:9:"no_update";a:4:{s:19:"akismet/akismet.php";O:8:"stdClass":10:{s:2:"id";s:21:"w.org/plugins/akismet";s:4:"slug";s:7:"akismet";s:6:"plugin";s:19:"akismet/akismet.php";s:11:"new_version";s:5:"5.3.2";s:3:"url";s:38:"https://wordpress.org/plugins/akismet/";s:7:"package";s:56:"https://downloads.wordpress.org/plugin/akismet.5.3.2.zip";s:5:"icons";a:2:{s:2:"2x";s:60:"https://ps.w.org/akismet/assets/icon-256x256.png?rev=2818463";s:2:"1x";s:60:"https://ps.w.org/akismet/assets/icon-128x128.png?rev=2818463";}s:7:"banners";a:2:{s:2:"2x";s:63:"https://ps.w.org/akismet/assets/banner-1544x500.png?rev=2900731";s:2:"1x";s:62:"https://ps.w.org/akismet/assets/banner-772x250.png?rev=2900731";}s:11:"banners_rtl";a:0:{}s:8:"requires";s:3:"5.8";}s:9:"hello.php";O:8:"stdClass":10:{s:2:"id";s:25:"w.org/plugins/hello-dolly";s:4:"slug";s:11:"hello-dolly";s:6:"plugin";s:9:"hello.php";s:11:"new_version";s:5:"1.7.2";s:3:"url";s:42:"https://wordpress.org/plugins/hello-dolly/";s:7:"package";s:60:"https://downloads.wordpress.org/plugin/hello-dolly.1.7.3.zip";s:5:"icons";a:2:{s:2:"2x";s:64:"https://ps.w.org/hello-dolly/assets/icon-256x256.jpg?rev=2052855";s:2:"1x";s:64:"https://ps.w.org/hello-dolly/assets/icon-128x128.jpg?rev=2052855";}s:7:"banners";a:2:{s:2:"2x";s:67:"https://ps.w.org/hello-dolly/assets/banner-1544x500.jpg?rev=2645582";s:2:"1x";s:66:"https://ps.w.org/hello-dolly/assets/banner-772x250.jpg?rev=2052855";}s:11:"banners_rtl";a:0:{}s:8:"requires";s:3:"4.6";}s:25:"tablepress/tablepress.php";O:8:"stdClass":10:{s:2:"id";s:24:"w.org/plugins/tablepress";s:4:"slug";s:10:"tablepress";s:6:"plugin";s:25:"tablepress/tablepress.php";s:11:"new_version";s:5:"2.3.2";s:3:"url";s:41:"https://wordpress.org/plugins/tablepress/";s:7:"package";s:59:"https://downloads.wordpress.org/plugin/tablepress.2.3.2.zip";s:5:"icons";a:2:{s:2:"2x";s:63:"https://ps.w.org/tablepress/assets/icon-256x256.png?rev=3028601";s:2:"1x";s:63:"https://ps.w.org/tablepress/assets/icon-128x128.png?rev=3028601";}s:7:"banners";a:2:{s:2:"2x";s:66:"https://ps.w.org/tablepress/assets/banner-1544x500.png?rev=3028601";s:2:"1x";s:65:"https://ps.w.org/tablepress/assets/banner-772x250.png?rev=3028601";}s:11:"banners_rtl";a:2:{s:2:"2x";s:70:"https://ps.w.org/tablepress/assets/banner-1544x500-rtl.png?rev=3028601";s:2:"1x";s:69:"https://ps.w.org/tablepress/assets/banner-772x250-rtl.png?rev=3028601";}s:8:"requires";s:3:"6.0";}s:47:"wpvivid-backuprestore/wpvivid-backuprestore.php";O:8:"stdClass":10:{s:2:"id";s:35:"w.org/plugins/wpvivid-backuprestore";s:4:"slug";s:21:"wpvivid-backuprestore";s:6:"plugin";s:47:"wpvivid-backuprestore/wpvivid-backuprestore.php";s:11:"new_version";s:7:"0.9.101";s:3:"url";s:52:"https://wordpress.org/plugins/wpvivid-backuprestore/";s:7:"package";s:72:"https://downloads.wordpress.org/plugin/wpvivid-backuprestore.0.9.101.zip";s:5:"icons";a:2:{s:2:"2x";s:74:"https://ps.w.org/wpvivid-backuprestore/assets/icon-256x256.png?rev=2899202";s:2:"1x";s:74:"https://ps.w.org/wpvivid-backuprestore/assets/icon-128x128.png?rev=2899202";}s:7:"banners";a:2:{s:2:"2x";s:77:"https://ps.w.org/wpvivid-backuprestore/assets/banner-1544x500.png?rev=2899202";s:2:"1x";s:76:"https://ps.w.org/wpvivid-backuprestore/assets/banner-772x250.png?rev=2899202";}s:11:"banners_rtl";a:0:{}s:8:"requires";s:3:"4.5";}}s:7:"checked";a:5:{s:19:"akismet/akismet.php";s:5:"5.3.2";s:25:"formidable/formidable.php";s:5:"6.9.1";s:9:"hello.php";s:5:"1.7.2";s:25:"tablepress/tablepress.php";s:5:"2.3.2";s:47:"wpvivid-backuprestore/wpvivid-backuprestore.php";s:7:"0.9.101";}}','no');
INSERT INTO `hs_options` VALUES (6787,'_transient_doing_cron','1717726031.2496430873870849609375','yes');
/*!40000 ALTER TABLE `hs_options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hs_posts`
--

DROP TABLE IF EXISTS `hs_posts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `hs_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=156 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hs_posts`
--

LOCK TABLES `hs_posts` WRITE;
/*!40000 ALTER TABLE `hs_posts` DISABLE KEYS */;
INSERT INTO `hs_posts` VALUES (2,1,'2023-07-09 16:43:05','2023-07-09 14:43:05','<!-- wp:heading -->\n<h2 class="wp-block-heading">Ce blog est consacré à l\'hydroponie et la bioponie domestique urbaine. </h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Ces deux techniques de culture font partie de la famille des cultures hors-sol sur substrat neutre. Elles consistent à faire pousser des plantes sans terre, sur un substrat neutre (billes d\'argile par exemple), en mettant en place un dispositif efficace pour leur fournir les nutriments nécessaire pour assurer une croissance efficace des racines et des plantes. La recirculation du liquide nutritif évite une grande partie de la consommation d\'eau qui est induite dans la culture en sol. Je raconte ici les différentes étapes qui m\'ont amené à expérimenter et perfectionner ces technique.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Origine du projet et cheminement</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>J\'ai commencé à m\'intéresser aux questions de culture urbaines pendant l\'épidémie de COVID. Cet épisode anxiogène m\'a fait m\'interroger sur certaines questions d\'organisation de la société, et aux risques associés à l\'approvisionnement en ville des denrées alimentaires. En effet, il semble qu\'en cas de gros dysfonctionnement de la logistique d\'approvisionnement en nourriture, en quelque jours les villes pourraient se retrouver privées d\'une partie importante de leurs ressources alimentaires. Face à cette potentielle fragilité des flux de transport, il semble intéressant de développer des dispositifs urbains assurant une partie (même réduite) de la production de légumes dans la ville. Des études sur ces sujets existent, mais je ne suis pas un spécialiste de la recherche en agriculture urbaine, j\'essayerai de faire un peu de bibliographie à ce sujet quand j\'aurai le temps.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>De plus, les questions d\'épuisement de la planète sont maintenant au centre des débats, et cultiver des légumes en étant économe en eau et en énergie est un sujet qui m\'intéresse et me semble prometteur pour les temps qui viennent.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Culture hors sol, définitions</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Le web pullule d\'explications sur ces techniques de culture hors sol. Vous pouvez trouver <a href="https://fermedecagnolle.fr/hydroponie-bioponie-aquaponie-definitions/"><strong>ici</strong></a> par exemple des définitions simples de l\'<strong>hydroponie</strong>, <strong>bioponie</strong> et <strong>aquaponie</strong> proposées par Marion Sarlé (<a href="https://lessourciers.com/fr/">les sourciers</a>). Une page très bien conçue par Ecologia présente l\'aquaponie <a rel="noreferrer noopener" href="https://www.aquaponia.com/aquaponie-by-echologia/index.php/monde-aquaponia/qu-est-ce-que-l-aquaponie-definition" target="_blank">ici</a>. Ecologia propose des formation vers Laval. Marion Sarlé propose le livre «&nbsp;<em><strong>Monter sa microferme en hydroponie, bioponie et aquaponie</strong></em>&nbsp;», en vente sur le site <a href="https://lessourciers.com/fr/livre-sourciers/">Les Sourciers</a>&nbsp;. Les sourciers proposent aussi des <a href="https://lessourciers.com/fr/les-formations/">formations</a> en ligne et dans leur ferme du Gers. J\'ai suivi la partie en ligne de la formation <a href="https://lessourciers.com/fr/les-formations/microferme-hydroponique/">Microferme Hydroponique</a> qui m\'a bien aidé à comprendre les rudiments de base.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Une fois ces grandes définitions comprises, on trouve de très facilement des informations sur les <strong><a href="https://jardinfute.com/culture-hors-sol/page/2/">nombreux types de dispositifs</a></strong> utilisés pour ce type de culture (ex : <a href="https://jardinfute.com/methode-kratky/">Kratky</a>, <a href="https://jardinfute.com/systeme-dwc-hydroponie/">DWC</a>, <a href="https://jardinfute.com/systeme-nft-hydroponie/">NFT</a>, <a href="https://jardinfute.com/table-a-maree-ebb-flow/">table à marée</a>, etc.). J\'ai choisi les explications sur le site <a href="https://jardinfute.com/">jardinfute.com</a>, mais vous trouverez facilement d\'autres systèmes et d\'autres explications sur internet.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Si l\'on évalue la complexité de ces techniques, on comprend que l\'<strong>hydroponie</strong> est la plus simple des trois, puisqu\'elle se base sur la circulation d\'une solution nutritive contenant des nutriments minéraux (engrais) directement assimilables par les racines des plantes cultivées. En gros, il suffit de faire circuler de l\'eau additionnée d\'engrais sur les racines des plantes.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Quand on regarde les principes de la <strong>bioponie</strong> et l\'<strong>aquaponie</strong>, on comprend que le principe est plus complexe. Dans les deux cas on va transformer des éléments organiques en éléments minéraux pouvant être assimilés par les plantes (minéralisation). Cela est réalisé en deux étapes par l\'action de deux types de bactéries qui vont assurer tout d\'abord la transformation des éléments organiques en nitrites (bactéries <strong>Nitrosomonas</strong>) puis des nitrites en nitrates (bactéries <strong>Nitrobacter</strong>). Dans les deux cas, il faut offrir à ces bactéries un lieu et des conditions de vie, ce qui représente une complexité supplémentaire. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Enfin, pour l\'<strong>aquaponie</strong> il faut aussi s\'occuper de ses poissons, et en particulier gérer les caractéristiques de l\'eau. Des déséquilibres dans le système peuvent rapidement tuer une partie du cheptel, ce qui est plus impactant que de voir mourir un pied de ciboulette.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Bénéfices des systèmes hors-sol</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Les bénéfices de systèmes industriels ne sont pas analysés ici. Mais voici les bénéfices que produit un système opérationnel :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>très faible consommation d\'eau (environ 90 % d\'économie),</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>très faible consommation d\'électricité (pompe 10 W),</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>fort rendement au m2,</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>fierté de produire sa nourriture,</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>systèmes en hauteur, hors de portée des nuisibles rampants,</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>intérêt pédagogique de la culture des plantes, pour tous (des plus petits aux plus grands),</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>système de circulation d\'eau produisant un bruit très agréable sans gêner les voisins.</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Premier objectif : construire un système hydroponique</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Pour avoir les meilleures chances de réussite en limitant la complexité du savoir nécessaire et m\'y mettre rapidement, j\'ai choisi de commencer par l\'hydroponie.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>On peut vouloir créer des fermes hydroponiques de taille plus ou moins importante, mais j\'ai décidé de m\'intéresser à des dispositifs mis en œuvre à l\'échelle individuelle ou de proche voisinage, car cela représente des investissements réduits, une capacité de réalisation rapide et un investissement en temps acceptable. De plus, même si l\'ambition de tels systèmes n\'est pas de produire des bénéfices financiers, elle semble intéressante à l\'échelle de l\'individu ou du voisinage.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Prototypes</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Durant l\'hiver 2021, j\'ai fait des recherches des différents systèmes hydroponiques disponibles et de comment réaliser sois-même ce genre de choses, et j\'ai été rapidement convaincu de l\'idée de commencer petit, afin d\'être prêt et de pouvoir planter dès le printemps 2022. Le retour d\'expérience des personnes expérimentées est unanime : il faut commencer simple et petit. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>De plus, commencer avec un petit système simple n\'a que des avantages pour quelqu\'un comme moi qui aime bricoler : </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Un petit prototype opérationnel est complet, donc on apprendra presque qu\'autant de choses que sur un plus gros système.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Le temps de développement est plus court, on aura ainsi plus de chances d\'aboutir dans des délais imposés par ses propres contraintes quotidiennes et l\'implacable chef d\'orchestre que sont les saisons. Par exemple, en France, il n\'est pas vraiment facile de planter des tomates à l\'automne, il faudra avoir été prêt pour le printemps, ou attendre le printemps suivant. </li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>On réduit le coût de fabrication, le risque financier et le temps passé si l\'on rate sa réalisation ou si on renonce avant la fin.</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:paragraph -->\n<p>J\'ai donc recherché les systèmes hydroponiques disponibles sur le marché ; j\'ai trouvé pas mal de systèmes clés en main, plus ou moins aboutis et plus ou moins chers. Pourtant, j\'ai décidé de construire moi-même mon premier système, pour plusieurs raisons :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Je suis convaincu que "mettre la main à la pâte" est souvent une bonne idée pour comprendre plus profondément ce qui se passe dans un dispositif technique,</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>j\'aime bien réaliser des prototypes en adaptant une solution technique existante à mon besoin personnel, cela m\'aide à imaginer comment envisager une généralisation à d\'autres cas d\'usages.</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading">Étape 1 : 2022, un petit système hydroponique (pour Marseille et la région parisienne)</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>J\'ai donc choisi de réaliser un système hydroponique vertical, pour prendre peu de place au sol. Pratiquant l\'impression impression 3D, j\'ai décidé de partir d\'un système déjà conçu avec cette technique de fabrication, et de l\'adapter un peu. De plus, j\'ai décidé de fabriquer plusieurs systèmes identiques testés entre la Provence et la région parisienne.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Voici à quoi ce système ressemblait dans sa <a rel="noreferrer noopener" href="https://www.thingiverse.com/thing:3405964/" target="_blank">version originale</a> trouvée sur un site internet d\'impression 3D : </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:columns -->\n<div class="wp-block-columns"><!-- wp:column -->\n<div class="wp-block-column"><!-- wp:image {"width":"535px","height":"402px","sizeSlug":"large"} -->\n<figure class="wp-block-image size-large is-resized"><img src="https://cdn.thingiverse.com/renders/33/b6/37/85/85/59b0c38e5b805c7dd9b9f5abeee79ca0_preview_featured.jpg" alt="" style="width:535px;height:402px"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class="wp-block-column"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>La colonne est creuse est composée de modules empilables, ce qui permet de choisir le nombre de plantes,</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>le réservoir en bas contient une pompe, cette dernière remonte l\'eau via un tuyau au centre de la tour jusqu\'à l\'étage supérieur qui est lui même percé de trous...</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>l\'eau passe par ces trous et redescend par gravité jusqu\'au réservoir, en arrosant au passage les racines des plantes maintenues en position dans des billes d\'argile dans les paniers amovibles (couleur ocre sur la photo) installés dans la tour.</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:paragraph -->\n<p>J\'ai du adapter le système de fixation entre le bas de la tour avec mon réservoirs, ainsi que certaines autres modifications mineures.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Au printemps 2022 J\'ai imprimé et mis en service 4 systèmes modulaires hydroponiques (que l\'on pourrait les qualifier d\'aéro-hydroponiques car le liquide nutritif ruisselle sur les racines, celles ci ne trempent pas dans le liquide). Ces systèmes avaient la forme d\'un cylindre creux dans lequel étaient insérés des paniers contenant des billes d\'argile. En bas de la tour un réservoir de 10 à 20 litres dans lequel une pompe alimentait le haut de la tour par un tuyau, le liquide redescendant dans la tour en imprégnant les racines par gravité. Ce système est modulaire et permet d\'adapter plus ou moins d\'étages de plantation.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Trois ont été déployés dans les bouches du Rhône (2 à Marseille, un à Aix-en-Provence), un à Saint-Germain-en-Laye. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Merci à Aurélie, Martine et Friquette (ma maman) pour les avoir fait fonctionner et testés.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Le détail et les photos sont disponibles sur la page dédiée</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Les résultats étaient intéressants, j\'ai beaucoup appris de ce système. Mais je suis resté sur ma fin, pour les raisons suivantes :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>J\'ai planté des tomates ! Et cela a fonctionné ! Sauf que les tomates produisent des volumes de racines gigantesques, et qu\'elles ont envahi l\'intérieur, ne laissant pas beaucoup de place au basilic et autres tentatives. De plus, je devait couper les racines des tomates très souvent...</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Les tomates consommaient plusieurs litres d\'eau par jour (surtout par évapo-transpiration), ce qui impliquait un remplissage quotidien du bac (2 à 4 litres consommés par jour en plein été dans un bac de 15 puis 30 litres), et donc une assez forte variation de la concentration des nutriments (ce que les plantes n\'aiment pas beaucoup).</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Les fraises ont végété,</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>J\'avais tenté de planter un chou fleur, qui était assez en forme mais n\'a jamais rien produit,</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>La ciboulette n\'a pas tenu, pas plus que le basilic,</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:paragraph -->\n<p>Les deux autres systèmes installés dans la région ont produit des tomates et des poivrons pour l\'un, rien pour l\'autre (par manque de lumière semble-t-il) ; l\'expérimentation en région parisienne, avec un climat moins chaud, a été bien meilleure. Et ma maman, qui s\'en occupait, était certainement plus performante... Beaucoup de tomates, quelques fraises... </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>En résumé, oui, ça a fonctionné, mais à part les tomates, le résultat était décevant. Je pense aussi que j\'aurais dû ne pas placer mon dispositif en plein soleil en juillet et aout à Marseille, car même les tomates ont souffert de la chaleur !! Je pense même que la sud de la France n\'est pas perticulièrement approprié à la culture de tomate en hors sol en juillet/août. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading">Étape 2 : choix du système pour l\'année 2023</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Après ce premier essai, je voulais changer et faire évoluer mon système, et j\'ai continuer de chercher des informations. Début 2022, j\'ai été très motivé par les principes de l\'aquaponie. La nature symbiotique poissons + plantes, la création d\'un écosystème économe et vertueux, la double production poissons + plantes sur une surface réduite m\'ont donné très envie d\'aller voir de plus près ce genre de systèmes. J\'ai, bien sur, beaucoup exploré internet, vu des réalisations magnifiques (par exemple la chaine de <a rel="noreferrer noopener" href="https://www.youtube.com/@ChrisPagns" target="_blank">Chris Pagns</a> sur youtube).</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>J\'ai cherché si il existait des formations près de chez moi. J\'ai finalement opté pour une initiation à l\'aquaponie en mai 2022 chez <a rel="noreferrer noopener" href="https://www.aquaponia.com/aquaponie-by-echologia/" target="_blank">Aquaponia, by Ecologia</a>, tout près de Laval (en Mayenne). J\'ai choisi ce stage pour les compétences reconnues de Guillaume Beucher, et pour le lieu magique. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Je n\'ai pas été déçu ! Après avoir surfé sur internet pendant un an, j\'ai ainsi pu accéder à une idée plus proche de la réalité de ce qui est possible quand on suit les enseignements de pros qui savent. Voici les principales évolutions de ma vision initiale de l\'aquaponie :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Dans le sud de la France, sans mettre en place une infrastructure solide, coûteuse et complexe, il est difficile (et/ou couteux) d\'élever des truites (ce que je souhaitais faire initialement) : la truite meurt dans une eau au delà de 26°. Donc il faut choisir des poissons compatibles avec les températures élevées, comme le poissons rouge (non comestible) ou la carpe. Cela fut un constat un peu amer, mais après avoir vu comment Aquaponia gère ses poissons, après avoir visionné les <a rel="noreferrer noopener" href="https://www.youtube.com/watch?v=x4hBJlt6PMI&amp;t=425s" target="_blank">vidéos de Chris Pagns</a> et lu les <a rel="noreferrer noopener" href="https://www.amazon.fr/Aquaponie-guide-r%C3%A9f%C3%A9rence-Fran%C3%A7ois-Petitet-Gosgnach/dp/2815310252/ref=sr_1_1?__mk_fr_FR=%C3%85M%C3%85%C5%BD%C3%95%C3%91&amp;crid=1XD7AW59VAHUS&amp;keywords=aquaponie+petitet&amp;qid=1692551785&amp;sprefix=aquaponie+petitet%2Caps%2C126&amp;sr=8-1" target="_blank">livres de référence de l\'aquaponie de François Petitet-Gosgnach</a> (Adanat). <br>J\'ai ainsi été convaincu de renoncer (temporairement au moins) à la truite (le rêve de chacun). J\'aurais bien opté pour le Tilapia, mais il est interdit en France pour des risque d\'invasion si il aboutissait dans une rivière. Dommage, il adore l\'eau chaude ! <br></li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>De plus, même si j\'ai la chance d\'avoir un jardin, pour réduire la température de l\'eau le bac à poissons doit être enterré. Comme je suis locataire, j\'ai renoncé à creuser dans le jardin.<br></li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Enfin, l\'aquaponie n\'est pas simple (surtout au début semble-t-il) et représente une charge mentale forte au quotidien : il faut être un minimum compétent :<!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>en chimie (pour l\'eau : cyclage, nitrates, nitrites, PH, KH, EC, Oxygène), </li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>en plomberie (étanchéité, maintenance), </li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>en élevage des poisson (nourrissage, gestion des maladies, etc), </li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>en connaissance des plantes (semis, croissance, maladies). </li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Et cela après avoir réussi à concevoir et réalisr son système , qui demandent des compétences en bricolage (même si on peut aussi acheter un système "clé en main").  </li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:paragraph -->\n<p>Malgré le désir de l\'aquaponie qui n\'a pas faibli, il faut parfois réduire ses ambitions. Après réflexion, j\'ai donc décidé de ne pas me lancer immédiatement dans cette aventure.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Je précise que des installations aquaponiques sont possibles dans le sud. En particulier, un système très simple commercialisé par la société <a rel="noreferrer noopener" href="https://www.taireau.fr/" target="_blank">T\'air E</a><a href="https://www.taireau.fr/">au</a> a été installé avec succès jusque dans le Vaucluse. La simplicité de la conception du système : 2 cuves de 500 litres enterrées reliées ensemble via des air-lifts (définition <a rel="noreferrer noopener" href="https://www.aquaportail.com/dictionnaire/definition/6587/pompe-air-lift" target="_blank">ici</a> ou <a rel="noreferrer noopener" href="https://www.truitesaquaponiques.com/2018/01/11/construire-des-airlifts-pour-faciliter-lelevage-des-truites-en-aquaponie/" target="_blank">ici</a>), sans pompe à eau, limite les risques de fuites et de mauvais fonctionnement au maximum.  C\'est d\'ailleurs un système que je vais étudier car il rompt un peu avec les systèmes classiques et pourrait rendre l\'aquaponie plus accessible au débutants...</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading">Étape 3 : 2023, un système hydroponique à Saint-Germain-en-laye (78) et un système bioponique à Marseille (13)</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>L\'aquaponie m\'a amené à considérer la bioponie avec un intérêt nouveau : la <a rel="noreferrer noopener" href="https://fermedecagnolle.fr/hydroponie-bioponie-aquaponie-definitions/" target="_blank">biop</a><a rel="noreferrer noopener" href="https://fermedecagnolle.fr/hydroponie-bioponie-aquaponie-definitions/#bioponie" target="_blank">onie</a>, c\'est finalement déjà une forme de symbiose entre les bactéries et les plantes. Ce processus de minéralisation (les bactéries qui transforment l\'organique en minéral), c\'est précisément ce que fait la nature dans le sol (en plus complet car en plus des bactérie, des animaux et champignons participent à cette transformation de l\'organique en minéral). Et on peut penser que cette transformation qui n\'existe pas en <a href="http://fermedecagnolle.fr/hydroponie-bioponie-aquaponie-definitions/#hydroponie">hydroponie</a> , peut, par sa plus grande complexité, produire une meilleure inertie et stabilité dans le temps ! </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>La bioponie demande un biofiltre (ou une <strong>maison pour les bactéries</strong> - expression favorite de Marion Sarlé des sourciers). Cela signifie qu\'il faut un récipient suffisamment volumineux contenant des billes d\'argile et du liquide pour héberger les bactéries réalisant la minéralisation. Or, si on revient aux différents dispositifs de culture hors-sol, tous ne sont pas conçus comme cela : mon premier système de tour, tout comme le système NFC ou le système DWC utilisent une petite quantité de billes d\'argile situées dans les pots-paniers, mais la fonction de ces billes est de servir de support aux racines de la plante. Il n\'y a pas assez de billes pour héberger les bactéries les bactéries. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>En revanche, un grand bac de billes d\'argiles (équipé ou non de système de marées) peut constituer un biofiltre.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>J\'ai donc décidé de réaliser un système en bioponie à Marseille, dans mon jardin, et de réaliser un système hydroponique (dépourvu de biofiltre) pour ma maman à Saint-Germain-en-Laye. Dans les deux cas, je voulais augmenter le volume d\'eau pour avoir une réserve plus importante et ainsi réduire les contraintes de remplissage quasi quotidiennes en été. J\'avais aussi des contraintes de dimensions : </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>le système hydroponique devait être implanté sur une terrasse en limitant l\'encombrement de ce fait organisé "en longueur",</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>le système bioponique dans mon jardin devait tenir dans le bassin à poissons rouges vide situé au centre du petit jardin.</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:paragraph -->\n<p>Pour les systèmes de culture, j\'ai essayé de les multiplier pour tester plusieurs systèmes simultanément, afin de déterminer lesquels étaient les mieux adaptés aux légumes et saisons :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Biofiltre + DWC + NFT + Dutch Buckets pour la bioponie à Marseille (volume total 450 litres)</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>NFT + Dutch Buckets pour l\'hydroponie à Saint-Germain-en-Laye (volume total 150 litres)</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:paragraph -->\n<p>Durant l\'hiver 2022 j\'ai donc réalisé les deux systèmes à Marseille. J\'ai démonté le système destiné à la terrasse en région parisienne et je l\'ai envoyée par la poste. Le détail, les plans et les résultats sont accessibles via le menu, dans des pages dédiées, avec des photos.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading">Prochaine étape : quelques améliorations sur les deux systèmes</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>A l\'usage, on imagine de nombreuses choses à améliorer : </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Dans les deux systèmes, il serait pratique de multiplier les vannes, afin de mieux régler les débits en particulier à l\'entrée les NFT, qui demandent un réglage fin.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>La gestion des tomates devient vite compliquée : les tomates sont des plantes qui poussent très vite, mais qu\'il faut tutorer et ou attacher afin de ne pas les laisser pousser n\'importe comment. J\'avais prévu des supports pour installer des ficelles au dessus des Dutch Buckets dans lesquels sont plantées les tomates : cela a fonctionné, mais le volume des tomates demanderait des grillages ou des systèmes d\'attache supplémentaires.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Les Dutch Buckets (20 litres) ont été envahis par les racines des tomates, qui sont allées boucher les évacuations. Le risque est un débordement du seau. J\'ai donc testé avec succès un tube de confinement qui interdit aux racines d\'aller boucher les tubes (d\'un Ø 25 mm)</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Comment multiplier ces systèmes pour les diffuser</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>C\'est très agréable de réussir à faire pousser des légumes en ville avec un joli rendement, mais ce serait plus intéressant de permettre la diffusion facile de ce types de systèmes pour que chacun puisse installer cela chez lui. Nous sortons alors du prototypage et nous entrons dans une nouvelle dimension : le projet de multiplication.  Ici, de nouveaux problèmes apparaissent...</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading">Vers une industrialisation classique du matériel ?</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Classiquement, on se dit qu\'en simplifiant et rationalisant les éléments des prototypes, on peut imaginer produire et multiplier multiplier facilement les systèmes. C\'est séduisant au premier abord, mais :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Si plusieurs entreprises ont essayé de produire du matériel "clé en main", cela ne semble pas avoir très bien fonctionné. (ici réfs) </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Les quelques acteurs </p>\n<!-- /wp:paragraph -->','Bienvenue','','publish','closed','open','','page-d-exemple','','','2024-02-29 17:48:41','2024-02-29 16:48:41','',0,'http://vicq.org/hs/?page_id=2',0,'page','',0);
INSERT INTO `hs_posts` VALUES (3,1,'2023-07-09 16:43:05','2023-07-09 14:43:05','<!-- wp:heading --><h2>Qui sommes-nous ?</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class="privacy-policy-tutorial">Texte suggéré : </strong>L’adresse de notre site est : http://hs.vicq.org.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>Commentaires</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class="privacy-policy-tutorial">Texte suggéré : </strong>Quand vous laissez un commentaire sur notre site, les données inscrites dans le formulaire de commentaire, ainsi que votre adresse IP et l’agent utilisateur de votre navigateur sont collectés pour nous aider à la détection des commentaires indésirables.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Une chaîne anonymisée créée à partir de votre adresse e-mail (également appelée hash) peut être envoyée au service Gravatar pour vérifier si vous utilisez ce dernier. Les clauses de confidentialité du service Gravatar sont disponibles ici : https://automattic.com/privacy/. Après validation de votre commentaire, votre photo de profil sera visible publiquement à coté de votre commentaire.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>Médias</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class="privacy-policy-tutorial">Texte suggéré : </strong>Si vous téléversez des images sur le site, nous vous conseillons d’éviter de téléverser des images contenant des données EXIF de coordonnées GPS. Les personnes visitant votre site peuvent télécharger et extraire des données de localisation depuis ces images.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>Cookies</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class="privacy-policy-tutorial">Texte suggéré : </strong>Si vous déposez un commentaire sur notre site, il vous sera proposé d’enregistrer votre nom, adresse e-mail et site dans des cookies. C’est uniquement pour votre confort afin de ne pas avoir à saisir ces informations si vous déposez un autre commentaire plus tard. Ces cookies expirent au bout d’un an.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Si vous vous rendez sur la page de connexion, un cookie temporaire sera créé afin de déterminer si votre navigateur accepte les cookies. Il ne contient pas de données personnelles et sera supprimé automatiquement à la fermeture de votre navigateur.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Lorsque vous vous connecterez, nous mettrons en place un certain nombre de cookies pour enregistrer vos informations de connexion et vos préférences d’écran. La durée de vie d’un cookie de connexion est de deux jours, celle d’un cookie d’option d’écran est d’un an. Si vous cochez « Se souvenir de moi », votre cookie de connexion sera conservé pendant deux semaines. Si vous vous déconnectez de votre compte, le cookie de connexion sera effacé.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>En modifiant ou en publiant une publication, un cookie supplémentaire sera enregistré dans votre navigateur. Ce cookie ne comprend aucune donnée personnelle. Il indique simplement l’ID de la publication que vous venez de modifier. Il expire au bout d’un jour.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>Contenu embarqué depuis d’autres sites</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class="privacy-policy-tutorial">Texte suggéré : </strong>Les articles de ce site peuvent inclure des contenus intégrés (par exemple des vidéos, images, articles…). Le contenu intégré depuis d’autres sites se comporte de la même manière que si le visiteur se rendait sur cet autre site.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Ces sites web pourraient collecter des données sur vous, utiliser des cookies, embarquer des outils de suivis tiers, suivre vos interactions avec ces contenus embarqués si vous disposez d’un compte connecté sur leur site web.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>Utilisation et transmission de vos données personnelles</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class="privacy-policy-tutorial">Texte suggéré : </strong>Si vous demandez une réinitialisation de votre mot de passe, votre adresse IP sera incluse dans l’e-mail de réinitialisation.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>Durées de stockage de vos données</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class="privacy-policy-tutorial">Texte suggéré : </strong>Si vous laissez un commentaire, le commentaire et ses métadonnées sont conservés indéfiniment. Cela permet de reconnaître et approuver automatiquement les commentaires suivants au lieu de les laisser dans la file de modération.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Pour les comptes qui s’inscrivent sur notre site (le cas échéant), nous stockons également les données personnelles indiquées dans leur profil. Tous les comptes peuvent voir, modifier ou supprimer leurs informations personnelles à tout moment (à l’exception de leur identifiant). Les gestionnaires du site peuvent aussi voir et modifier ces informations.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>Les droits que vous avez sur vos données</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class="privacy-policy-tutorial">Texte suggéré : </strong>Si vous avez un compte ou si vous avez laissé des commentaires sur le site, vous pouvez demander à recevoir un fichier contenant toutes les données personnelles que nous possédons à votre sujet, incluant celles que vous nous avez fournies. Vous pouvez également demander la suppression des données personnelles vous concernant. Cela ne prend pas en compte les données stockées à des fins administratives, légales ou pour des raisons de sécurité.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>Où vos données sont envoyées</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class="privacy-policy-tutorial">Texte suggéré : </strong>Les commentaires des visiteurs peuvent être vérifiés à l’aide d’un service automatisé de détection des commentaires indésirables.</p><!-- /wp:paragraph -->','Politique de confidentialité','','draft','closed','open','','politique-de-confidentialite','','','2023-07-09 16:43:05','2023-07-09 14:43:05','',0,'http://vicq.org/hs/?page_id=3',0,'page','',0);
INSERT INTO `hs_posts` VALUES (7,1,'2023-07-09 17:02:06','2023-07-09 15:02:06','<!-- wp:paragraph -->\n<p>Ce blog est dédié à la culture hors sol : hydroponie et bioponie. J\'y présente mes activités de test et d\'apprentissage de ces techniques réalisées depuis le printemps 2022. </p>\n<!-- /wp:paragraph -->','Bienvenue','','inherit','closed','closed','','2-revision-v1','','','2023-07-09 17:02:06','2023-07-09 15:02:06','',2,'http://vicq.org/hs/?p=7',0,'revision','',0);
INSERT INTO `hs_posts` VALUES (8,1,'2023-07-09 17:10:51','2023-07-09 15:10:51','<!-- wp:buttons -->\n<div class="wp-block-buttons"><!-- wp:button -->\n<div class="wp-block-button"><a class="wp-block-button__link wp-element-button" href="https://photos.app.goo.gl/9unhagDPNbqhikj4A">PHOTOS ICI</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons -->\n\n<!-- wp:paragraph -->\n<p>Pendant l’hiver 2023, j’ai conçu un système bioponique pour l’installer dans mon jardin dans le centre de Marseille. Je suis parti des contraintes existantes (surface limitée, orientation du soleil, etc.) pour réaliser les plans avec sketchup. Voici une petite animation pour parcourir le résultat :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:embed {"url":"https://youtu.be/MCo0lrLJxGQ","type":"video","providerNameSlug":"youtube","responsive":true,"className":"wp-embed-aspect-4-3 wp-has-aspect-ratio"} -->\n<figure class="wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-4-3 wp-has-aspect-ratio"><div class="wp-block-embed__wrapper">\nhttps://youtu.be/MCo0lrLJxGQ\n</div></figure>\n<!-- /wp:embed -->\n\n<!-- wp:paragraph -->\n<p>Caractéristiques du système :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:table -->\n<figure class="wp-block-table"><table><tbody><tr><td>Volume d\'eau circulante</td><td>440 litres</td></tr><tr><td>Surface plantée</td><td>2 m2</td></tr><tr><td>plantations</td><td>4 Tomates<br>1 concombre<br>1 poivron "petit marseillais"<br>1 piment<br>1 aubergine<br>1 ciboulette<br>1 fraise<br>1 menthe<br>salades (batavia, frisée, roquette)<br>basilic<br>coriandre vietnamienne</td></tr><tr><td>Pompe à eau</td><td>3000 l/h 10 W (marque <a href="https://www.amazon.fr/gp/product/B07MYSHHQX/ref=ppx_yo_dt_b_search_asin_title?ie=UTF8&amp;psc=1">EXLECO</a>)</td></tr><tr><td>Pompe à air</td><td>300 l/h</td></tr></tbody></table></figure>\n<!-- /wp:table -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->','Bioponie 2023','','publish','closed','closed','','bioponie-marseille-2023','','','2023-07-14 12:30:26','2023-07-14 10:30:26','',0,'http://vicq.org/hs/?page_id=8',0,'page','',0);
INSERT INTO `hs_posts` VALUES (9,1,'2023-07-09 17:10:51','2023-07-09 15:10:51','<!-- wp:paragraph -->\n<p>Pendant l\'hiver 2023, j\'ai conçu un système bioponique pour l\'installer dans mon jardin dans le centre de Marseille. Je suis parti des contraintes existantes (surface limitée, orientation du soleil, etc.) pour réaliser les plans avec sketchup. Voici une petite animation pour parcourir le résultat :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->','Bioponie Marseille 2023','','inherit','closed','closed','','8-revision-v1','','','2023-07-09 17:10:51','2023-07-09 15:10:51','',8,'http://vicq.org/hs/?p=9',0,'revision','',0);
INSERT INTO `hs_posts` VALUES (11,1,'2023-07-09 17:12:43','2023-07-09 15:12:43',' ','','','publish','closed','closed','','11','','','2023-07-09 17:12:43','2023-07-09 15:12:43','',0,'http://vicq.org/hs/2023/07/09/11/',1,'nav_menu_item','',0);
INSERT INTO `hs_posts` VALUES (14,1,'2023-07-09 17:14:57','2023-07-09 15:14:57','<!-- wp:paragraph -->\n<p>Ce blog est dédié à la culture hors sol : hydroponie et bioponie. J\'y présente mes activités de test et d\'apprentissage de ces techniques réalisées depuis le printemps 2022 à Saint-germain-en-Laye (78, Yvelines) et Marseille (13, Bouches du Rhône). </p>\n<!-- /wp:paragraph -->','Bienvenue','','inherit','closed','closed','','2-revision-v1','','','2023-07-09 17:14:57','2023-07-09 15:14:57','',2,'http://vicq.org/hs/?p=14',0,'revision','',0);
INSERT INTO `hs_posts` VALUES (15,1,'2023-07-09 17:17:21','2023-07-09 15:17:21','<!-- wp:buttons -->\n<div class="wp-block-buttons"><!-- wp:button -->\n<div class="wp-block-button"><a class="wp-block-button__link wp-element-button" href="https://photos.app.goo.gl/z4envoGfzvAShT5L6">PHOTOS ICI</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons -->\n\n<!-- wp:paragraph -->\n<p>Pendant l’hiver 2023, j’ai conçu un système hydroponique pour l’installer sur la terrasse de ma mère à Saint-Germain-en-Laye. Je suis parti des contraintes existantes (surface limitée, orientation du soleil, etc.) pour réaliser les plans avec sketchup. Voici une petite animation pour présenter le système : </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:embed {"url":"https://youtu.be/6_k53IJklnw","type":"video","providerNameSlug":"youtube","responsive":true,"className":"wp-embed-aspect-16-9 wp-has-aspect-ratio"} -->\n<figure class="wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio"><div class="wp-block-embed__wrapper">\nhttps://youtu.be/6_k53IJklnw\n</div></figure>\n<!-- /wp:embed -->','Hydroponie 2023','','publish','closed','closed','','hydroponie-saint-germain-en-laye-2023','','','2023-12-10 17:21:59','2023-12-10 16:21:59','',0,'http://vicq.org/hs/?page_id=15',0,'page','',0);
INSERT INTO `hs_posts` VALUES (16,1,'2023-07-09 17:17:21','2023-07-09 15:17:21','<!-- wp:paragraph -->\n<p>Pendant l’hiver 2023, j’ai conçu un système Hydroponique pour l’installer sur la terrasse de ma maman à Saint-Germain-en-Laye. Je suis parti des contraintes existantes (surface limitée, orientation du soleil, etc.) pour réaliser les plans avec sketchup. Voici une petite animation pour parcourir le résultat :</p>\n<!-- /wp:paragraph -->','Hydroponie Saint-germain en Laye 2023','','inherit','closed','closed','','15-revision-v1','','','2023-07-09 17:17:21','2023-07-09 15:17:21','',15,'http://vicq.org/hs/?p=16',0,'revision','',0);
INSERT INTO `hs_posts` VALUES (18,1,'2023-07-09 17:18:42','2023-07-09 15:18:42',' ','','','publish','closed','closed','','18','','','2023-07-09 17:18:42','2023-07-09 15:18:42','',0,'http://vicq.org/hs/2023/07/09/18/',2,'nav_menu_item','',0);
INSERT INTO `hs_posts` VALUES (19,1,'2023-07-09 17:24:22','2023-07-09 15:24:22','<!-- wp:paragraph {"align":"left","fontSize":"large"} -->\n<p class="has-text-align-left has-large-font-size"></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons -->\n<div class="wp-block-buttons"><!-- wp:button -->\n<div class="wp-block-button"><a class="wp-block-button__link wp-element-button">En construction</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons -->\n\n<!-- wp:paragraph -->\n<p>Plusieurs mois avant le printemps 2022, j\'ai mis au point un système aéro-hydroponique pour réaliser les premiers tests de culture hors-sol sur paniers de billes d\'argiles, imprimé en 3D. Je n\'ai pas inventé le système, j\'ai simplement adapté un modèle existant. J\'en ai réalisé 4 identiques, qui ont été installés à Marseille (2), à Aix-en-Provence (1) et à Saint Germain-en-Laye.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->','Aéro-hydroponie 2022','','publish','closed','closed','','aero-hydroponie-marseille-et-saint-germain-en-laye-2022','','','2023-07-09 18:26:14','2023-07-09 16:26:14','',0,'http://vicq.org/hs/?page_id=19',0,'page','',0);
INSERT INTO `hs_posts` VALUES (20,1,'2023-07-09 17:24:22','2023-07-09 15:24:22','<!-- wp:paragraph {"align":"center","fontSize":"large"} -->\n<p class="has-text-align-center has-large-font-size"><strong><em>En cours de construction</em></strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Plusieurs mois avant le printemps 2022, j\'ai mis au point un système aéro-hydroponique pour réaliser les premiers tests de culture hors-sol sur paniers de billes d\'argiles, imprimé en 3D. Je n\'ai pas inventé le système, j\'ai simplement adapté un modèle existant. J\'en ai réalisé 4 identiques, qui ont été installés à Marseille (2), à Aix-en-Provence (1) et à Saint Germain-en-Laye.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->','Aéro-hydroponie Marseille et Saint-Germain-en-Laye 2022','','inherit','closed','closed','','19-revision-v1','','','2023-07-09 17:24:22','2023-07-09 15:24:22','',19,'http://vicq.org/hs/?p=20',0,'revision','',0);
INSERT INTO `hs_posts` VALUES (21,1,'2023-07-09 17:24:36','2023-07-09 15:24:36','<!-- wp:paragraph {"align":"center","fontSize":"large"} -->\n<p class="has-text-align-center has-large-font-size"><strong><em>En cours de construction</em></strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Plusieurs mois avant le printemps 2022, j\'ai mis au point un système aéro-hydroponique pour réaliser les premiers tests de culture hors-sol sur paniers de billes d\'argiles, imprimé en 3D. Je n\'ai pas inventé le système, j\'ai simplement adapté un modèle existant. J\'en ai réalisé 4 identiques, qui ont été installés à Marseille (2), à Aix-en-Provence (1) et à Saint Germain-en-Laye.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->','Aéro-hydroponie 2022','','inherit','closed','closed','','19-revision-v1','','','2023-07-09 17:24:36','2023-07-09 15:24:36','',19,'http://vicq.org/hs/?p=21',0,'revision','',0);
INSERT INTO `hs_posts` VALUES (22,1,'2023-07-09 17:24:51','2023-07-09 15:24:51','<!-- wp:paragraph -->\n<p>Pendant l\'hiver 2023, j\'ai conçu un système bioponique pour l\'installer dans mon jardin dans le centre de Marseille. Je suis parti des contraintes existantes (surface limitée, orientation du soleil, etc.) pour réaliser les plans avec sketchup. Voici une petite animation pour parcourir le résultat :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->','Bioponie 2023','','inherit','closed','closed','','8-revision-v1','','','2023-07-09 17:24:51','2023-07-09 15:24:51','',8,'http://vicq.org/hs/?p=22',0,'revision','',0);
INSERT INTO `hs_posts` VALUES (23,1,'2023-07-09 17:25:08','2023-07-09 15:25:08','<!-- wp:paragraph -->\n<p>Pendant l’hiver 2023, j’ai conçu un système Hydroponique pour l’installer sur la terrasse de ma maman à Saint-Germain-en-Laye. Je suis parti des contraintes existantes (surface limitée, orientation du soleil, etc.) pour réaliser les plans avec sketchup. Voici une petite animation pour parcourir le résultat :</p>\n<!-- /wp:paragraph -->','Hydroponie 2023','','inherit','closed','closed','','15-revision-v1','','','2023-07-09 17:25:08','2023-07-09 15:25:08','',15,'http://vicq.org/hs/?p=23',0,'revision','',0);
INSERT INTO `hs_posts` VALUES (25,1,'2023-07-09 17:26:05','2023-07-09 15:26:05','<!-- wp:paragraph -->\n<p>Pendant l’hiver 2023, j’ai conçu un système Hydroponique pour l’installer sur la terrasse de ma maman à Saint-Germain-en-Laye. Je suis parti des contraintes existantes (surface limitée, orientation du soleil, etc.) pour réaliser les plans avec sketchup. Voici une petite animation pour présenter le système :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->','Hydroponie 2023','','inherit','closed','closed','','15-revision-v1','','','2023-07-09 17:26:05','2023-07-09 15:26:05','',15,'http://vicq.org/hs/?p=25',0,'revision','',0);
INSERT INTO `hs_posts` VALUES (27,1,'2023-07-09 17:26:54','2023-07-09 15:26:54',' ','','','publish','closed','closed','','27','','','2023-07-09 17:26:54','2023-07-09 15:26:54','',0,'http://vicq.org/hs/2023/07/09/27/',3,'nav_menu_item','',0);
INSERT INTO `hs_posts` VALUES (28,1,'2023-07-09 17:28:21','2023-07-09 15:28:21','<!-- wp:paragraph -->\n<p>Ce blog est dédié à la culture hors sol : hydroponie et bioponie. J\'y présente les activités de test et d\'apprentissage de ces techniques réalisées depuis le printemps 2022 à Saint-germain-en-Laye (78, Yvelines), Aix-en-Provence et Marseille (13, Bouches du Rhône). </p>\n<!-- /wp:paragraph -->','Bienvenue','','inherit','closed','closed','','2-revision-v1','','','2023-07-09 17:28:21','2023-07-09 15:28:21','',2,'http://vicq.org/hs/?p=28',0,'revision','',0);
INSERT INTO `hs_posts` VALUES (30,1,'2023-07-09 17:55:36','2023-07-09 15:55:36','<!-- wp:paragraph -->\n<p>Pendant l\'hiver 2023, j\'ai conçu un système bioponique pour l\'installer dans mon jardin dans le centre de Marseille. Je suis parti des contraintes existantes (surface limitée, orientation du soleil, etc.) pour réaliser les plans avec sketchup. Voici une petite animation pour parcourir le résultat :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:embed {"url":"https://youtu.be/MCo0lrLJxGQ","type":"video","providerNameSlug":"youtube","responsive":true,"className":"wp-embed-aspect-4-3 wp-has-aspect-ratio"} -->\n<figure class="wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-4-3 wp-has-aspect-ratio"><div class="wp-block-embed__wrapper">\nhttps://youtu.be/MCo0lrLJxGQ\n</div></figure>\n<!-- /wp:embed -->','Bioponie 2023','','inherit','closed','closed','','8-revision-v1','','','2023-07-09 17:55:36','2023-07-09 15:55:36','',8,'http://vicq.org/hs/?p=30',0,'revision','',0);
INSERT INTO `hs_posts` VALUES (32,1,'2023-07-09 17:56:39','2023-07-09 15:56:39','<!-- wp:paragraph -->\n<p>Pendant l\'hiver 2023, j\'ai conçu un système bioponique pour l\'installer dans mon jardin dans le centre de Marseille. Je suis parti des contraintes existantes (surface limitée, orientation du soleil, etc.) pour réaliser les plans avec sketchup. Voici une petite animation pour parcourir le résultat :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:embed {"url":"https://youtu.be/MCo0lrLJxGQ","type":"video","providerNameSlug":"youtube","responsive":true,"className":"wp-embed-aspect-4-3 wp-has-aspect-ratio"} -->\n<figure class="wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-4-3 wp-has-aspect-ratio"><div class="wp-block-embed__wrapper">\nhttps://youtu.be/MCo0lrLJxGQ\n</div></figure>\n<!-- /wp:embed -->','Bioponie 2023 - photos','','inherit','closed','closed','','8-revision-v1','','','2023-07-09 17:56:39','2023-07-09 15:56:39','',8,'http://vicq.org/hs/?p=32',0,'revision','',0);
INSERT INTO `hs_posts` VALUES (33,1,'2023-07-09 18:00:47','2023-07-09 16:00:47','<!-- wp:paragraph -->\n<p><strong><a href="https://photos.app.goo.gl/9unhagDPNbqhikj4A">&lt;Photos ici></a></strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {"fontSize":"medium"} -->\n<p class="has-medium-font-size"><br>Pendant l\'hiver 2023, j\'ai conçu un système bioponique pour l\'installer dans mon jardin dans le centre de Marseille. Je suis parti des contraintes existantes (surface limitée, orientation du soleil, etc.) pour réaliser les plans avec sketchup. Voici une petite animation pour parcourir le résultat :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:embed {"url":"https://youtu.be/MCo0lrLJxGQ","type":"video","providerNameSlug":"youtube","responsive":true,"className":"wp-embed-aspect-4-3 wp-has-aspect-ratio"} -->\n<figure class="wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-4-3 wp-has-aspect-ratio"><div class="wp-block-embed__wrapper">\nhttps://youtu.be/MCo0lrLJxGQ\n</div></figure>\n<!-- /wp:embed -->\n\n<!-- wp:paragraph -->\n<p>dsds</p>\n<!-- /wp:paragraph -->','Bioponie 2023','','inherit','closed','closed','','8-revision-v1','','','2023-07-09 18:00:47','2023-07-09 16:00:47','',8,'http://vicq.org/hs/?p=33',0,'revision','',0);
INSERT INTO `hs_posts` VALUES (34,1,'2023-07-09 18:02:23','2023-07-09 16:02:23','<!-- wp:paragraph -->\n<p><strong><a href="https://photos.app.goo.gl/z4envoGfzvAShT5L6">&lt;Photos ici></a></strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Pendant l’hiver 2023, j’ai conçu un système Hydroponique pour l’installer sur la terrasse de ma maman à Saint-Germain-en-Laye. Je suis parti des contraintes existantes (surface limitée, orientation du soleil, etc.) pour réaliser les plans avec sketchup. Voici une petite animation pour présenter le système :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->','Hydroponie 2023','','inherit','closed','closed','','15-revision-v1','','','2023-07-09 18:02:23','2023-07-09 16:02:23','',15,'http://vicq.org/hs/?p=34',0,'revision','',0);
INSERT INTO `hs_posts` VALUES (36,1,'2023-07-09 18:08:49','2023-07-09 16:08:49','<!-- wp:paragraph -->\n<p><strong><a href="https://photos.app.goo.gl/9unhagDPNbqhikj4A">&lt;Photos ici&gt;</a></strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:image {"id":35,"sizeSlug":"full","linkDestination":"custom"} -->\n<figure class="wp-block-image size-full"><a href="https://photos.app.goo.gl/9unhagDPNbqhikj4A"><img src="http://hs.vicq.org/wp-content/uploads/2023/07/galerie-de-photos-e1688918850721.png" alt="" class="wp-image-35"/></a></figure>\n<!-- /wp:image -->\n\n<!-- wp:paragraph {"fontSize":"medium"} -->\n<p class="has-medium-font-size"><br>Pendant l\'hiver 2023, j\'ai conçu un système bioponique pour l\'installer dans mon jardin dans le centre de Marseille. Je suis parti des contraintes existantes (surface limitée, orientation du soleil, etc.) pour réaliser les plans avec sketchup. Voici une petite animation pour parcourir le résultat :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:embed {"url":"https://youtu.be/MCo0lrLJxGQ","type":"video","providerNameSlug":"youtube","responsive":true,"className":"wp-embed-aspect-4-3 wp-has-aspect-ratio"} -->\n<figure class="wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-4-3 wp-has-aspect-ratio"><div class="wp-block-embed__wrapper">\nhttps://youtu.be/MCo0lrLJxGQ\n</div></figure>\n<!-- /wp:embed -->\n\n<!-- wp:paragraph -->\n<p>dsds</p>\n<!-- /wp:paragraph -->','Bioponie 2023','','inherit','closed','closed','','8-revision-v1','','','2023-07-09 18:08:49','2023-07-09 16:08:49','',8,'http://vicq.org/hs/?p=36',0,'revision','',0);
INSERT INTO `hs_posts` VALUES (38,1,'2023-07-09 18:11:35','2023-07-09 16:11:35','','galerie-de-photos','','inherit','open','closed','','galerie-de-photos','','','2023-07-09 18:11:35','2023-07-09 16:11:35','',0,'http://vicq.org/hs/wp-content/uploads/2023/07/galerie-de-photos.png',0,'attachment','image/png',0);
INSERT INTO `hs_posts` VALUES (39,1,'2023-07-09 18:12:12','2023-07-09 16:12:12','<!-- wp:paragraph -->\n<p><strong><a href="https://photos.app.goo.gl/9unhagDPNbqhikj4A">&lt;Photos ici&gt;</a></strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:image {"id":38,"width":69,"height":69,"sizeSlug":"full","linkDestination":"none"} -->\n<figure class="wp-block-image size-full is-resized"><img src="http://hs.vicq.org/wp-content/uploads/2023/07/galerie-de-photos.png" alt="" class="wp-image-38" width="69" height="69"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:paragraph {"fontSize":"medium"} -->\n<p class="has-medium-font-size"><br>Pendant l\'hiver 2023, j\'ai conçu un système bioponique pour l\'installer dans mon jardin dans le centre de Marseille. Je suis parti des contraintes existantes (surface limitée, orientation du soleil, etc.) pour réaliser les plans avec sketchup. Voici une petite animation pour parcourir le résultat :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:embed {"url":"https://youtu.be/MCo0lrLJxGQ","type":"video","providerNameSlug":"youtube","responsive":true,"className":"wp-embed-aspect-4-3 wp-has-aspect-ratio"} -->\n<figure class="wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-4-3 wp-has-aspect-ratio"><div class="wp-block-embed__wrapper">\nhttps://youtu.be/MCo0lrLJxGQ\n</div></figure>\n<!-- /wp:embed -->\n\n<!-- wp:paragraph -->\n<p>dsds</p>\n<!-- /wp:paragraph -->','Bioponie 2023','','inherit','closed','closed','','8-revision-v1','','','2023-07-09 18:12:12','2023-07-09 16:12:12','',8,'http://vicq.org/hs/?p=39',0,'revision','',0);
INSERT INTO `hs_posts` VALUES (40,1,'2023-07-09 18:15:57','2023-07-09 16:15:57','[["Photos ici","<img src=\\"http://hs.vicq.org/wp-content/uploads/2023/07/galerie-de-photos-300x300.png\\" alt=\\"\\" width=\\"300\\" height=\\"300\\" class=\\"alignnone size-medium wp-image-38\\" /><a href=\\"https://photos.app.goo.gl/9unhagDPNbqhikj4A\\" rel=\\"noopener\\" target=\\"_blank\\">Photos</a>"]]','photos_bio_2023','','publish','closed','closed','','photos','','','2023-07-09 18:18:34','2023-07-09 16:18:34','',0,'http://vicq.org/hs/?post_type=tablepress_table&#038;p=40',0,'tablepress_table','application/json',0);
INSERT INTO `hs_posts` VALUES (41,1,'2023-07-09 18:17:38','2023-07-09 16:17:38','[["","<img src=\\"http://hs.vicq.org/wp-content/uploads/2023/07/galerie-de-photos-300x300.png\\" alt=\\"\\" width=\\"300\\" height=\\"300\\" class=\\"alignnone size-medium wp-image-38\\" /><a href=\\"https://photos.app.goo.gl/9unhagDPNbqhikj4A\\" rel=\\"noopener\\" target=\\"_blank\\">Photos</a>"]]','photos','','inherit','closed','closed','','40-revision-v1','','','2023-07-09 18:17:38','2023-07-09 16:17:38','',40,'http://vicq.org/hs/?p=41',0,'revision','',0);
INSERT INTO `hs_posts` VALUES (42,1,'2023-07-09 18:18:14','2023-07-09 16:18:14','[["","<img src=\\"http://hs.vicq.org/wp-content/uploads/2023/07/galerie-de-photos-300x300.png\\" alt=\\"\\" width=\\"300\\" height=\\"300\\" class=\\"alignnone size-medium wp-image-38\\" /><a href=\\"https://photos.app.goo.gl/9unhagDPNbqhikj4A\\" rel=\\"noopener\\" target=\\"_blank\\">Photos</a>"]]','photos_bio_2023','','inherit','closed','closed','','40-revision-v1','','','2023-07-09 18:18:14','2023-07-09 16:18:14','',40,'http://vicq.org/hs/?p=42',0,'revision','',0);
INSERT INTO `hs_posts` VALUES (43,1,'2023-07-09 18:18:34','2023-07-09 16:18:34','[["Photos ici","<img src=\\"http://hs.vicq.org/wp-content/uploads/2023/07/galerie-de-photos-300x300.png\\" alt=\\"\\" width=\\"300\\" height=\\"300\\" class=\\"alignnone size-medium wp-image-38\\" /><a href=\\"https://photos.app.goo.gl/9unhagDPNbqhikj4A\\" rel=\\"noopener\\" target=\\"_blank\\">Photos</a>"]]','photos_bio_2023','','inherit','closed','closed','','40-revision-v1','','','2023-07-09 18:18:34','2023-07-09 16:18:34','',40,'http://vicq.org/hs/?p=43',0,'revision','',0);
INSERT INTO `hs_posts` VALUES (45,1,'2023-07-09 18:20:06','2023-07-09 16:20:06','<!-- wp:paragraph -->\n<p><strong><a href="https://photos.app.goo.gl/9unhagDPNbqhikj4A">&lt;Photos ici&gt;</a></strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:table {"align":"left"} -->\n<figure class="wp-block-table alignleft"><table><tbody><tr><td>Photos ici</td><td></td></tr></tbody></table></figure>\n<!-- /wp:table -->\n\n<!-- wp:buttons -->\n<div class="wp-block-buttons"><!-- wp:button -->\n<div class="wp-block-button"><a class="wp-block-button__link wp-element-button">Photos ici</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons -->\n\n<!-- wp:paragraph {"fontSize":"medium"} -->\n<p class="has-medium-font-size"><br>Pendant l\'hiver 2023, j\'ai conçu un système bioponique pour l\'installer dans mon jardin dans le centre de Marseille. Je suis parti des contraintes existantes (surface limitée, orientation du soleil, etc.) pour réaliser les plans avec sketchup. Voici une petite animation pour parcourir le résultat :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:embed {"url":"https://youtu.be/MCo0lrLJxGQ","type":"video","providerNameSlug":"youtube","responsive":true,"className":"wp-embed-aspect-4-3 wp-has-aspect-ratio"} -->\n<figure class="wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-4-3 wp-has-aspect-ratio"><div class="wp-block-embed__wrapper">\nhttps://youtu.be/MCo0lrLJxGQ\n</div></figure>\n<!-- /wp:embed -->\n\n<!-- wp:paragraph -->\n<p>dsds</p>\n<!-- /wp:paragraph -->','Bioponie 2023','','inherit','closed','closed','','8-revision-v1','','','2023-07-09 18:20:06','2023-07-09 16:20:06','',8,'http://vicq.org/hs/?p=45',0,'revision','',0);
INSERT INTO `hs_posts` VALUES (46,1,'2023-07-09 18:22:29','2023-07-09 16:22:29','<!-- wp:buttons -->\n<div class="wp-block-buttons"><!-- wp:button -->\n<div class="wp-block-button"><a class="wp-block-button__link wp-element-button" href="https://photos.app.goo.gl/9unhagDPNbqhikj4A">Photos ici</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons -->\n\n<!-- wp:paragraph -->\n<p>Pendant l’hiver 2023, j’ai conçu un système bioponique pour l’installer dans mon jardin dans le centre de Marseille. Je suis parti des contraintes existantes (surface limitée, orientation du soleil, etc.) pour réaliser les plans avec sketchup. Voici une petite animation pour parcourir le résultat :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:embed {"url":"https://youtu.be/MCo0lrLJxGQ","type":"video","providerNameSlug":"youtube","responsive":true,"className":"wp-embed-aspect-4-3 wp-has-aspect-ratio"} -->\n<figure class="wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-4-3 wp-has-aspect-ratio"><div class="wp-block-embed__wrapper">\nhttps://youtu.be/MCo0lrLJxGQ\n</div></figure>\n<!-- /wp:embed -->\n\n<!-- wp:paragraph -->\n<p>dsds</p>\n<!-- /wp:paragraph -->','Bioponie 2023','','inherit','closed','closed','','8-revision-v1','','','2023-07-09 18:22:29','2023-07-09 16:22:29','',8,'http://vicq.org/hs/?p=46',0,'revision','',0);
INSERT INTO `hs_posts` VALUES (47,1,'2023-07-09 18:23:38','2023-07-09 16:23:38','<!-- wp:buttons -->\n<div class="wp-block-buttons"><!-- wp:button -->\n<div class="wp-block-button"><a class="wp-block-button__link wp-element-button" href="https://photos.app.goo.gl/z4envoGfzvAShT5L6">Photos ici</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons -->\n\n<!-- wp:paragraph -->\n<p>Pendant l’hiver 2023, j’ai conçu un système Hydroponique pour l’installer sur la terrasse de ma maman à Saint-Germain-en-Laye. Je suis parti des contraintes existantes (surface limitée, orientation du soleil, etc.) pour réaliser les plans avec sketchup. Voici une petite animation pour présenter le système :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->','Hydroponie 2023','','inherit','closed','closed','','15-revision-v1','','','2023-07-09 18:23:38','2023-07-09 16:23:38','',15,'http://vicq.org/hs/?p=47',0,'revision','',0);
INSERT INTO `hs_posts` VALUES (48,1,'2023-07-09 18:26:14','2023-07-09 16:26:14','<!-- wp:paragraph {"align":"left","fontSize":"large"} -->\n<p class="has-text-align-left has-large-font-size"></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons -->\n<div class="wp-block-buttons"><!-- wp:button -->\n<div class="wp-block-button"><a class="wp-block-button__link wp-element-button">En construction</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons -->\n\n<!-- wp:paragraph -->\n<p>Plusieurs mois avant le printemps 2022, j\'ai mis au point un système aéro-hydroponique pour réaliser les premiers tests de culture hors-sol sur paniers de billes d\'argiles, imprimé en 3D. Je n\'ai pas inventé le système, j\'ai simplement adapté un modèle existant. J\'en ai réalisé 4 identiques, qui ont été installés à Marseille (2), à Aix-en-Provence (1) et à Saint Germain-en-Laye.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->','Aéro-hydroponie 2022','','inherit','closed','closed','','19-revision-v1','','','2023-07-09 18:26:14','2023-07-09 16:26:14','',19,'http://vicq.org/hs/?p=48',0,'revision','',0);
INSERT INTO `hs_posts` VALUES (49,1,'2023-07-09 18:29:11','2023-07-09 16:29:11','<!-- wp:buttons -->\n<div class="wp-block-buttons"><!-- wp:button -->\n<div class="wp-block-button"><a class="wp-block-button__link wp-element-button" href="https://photos.app.goo.gl/9unhagDPNbqhikj4A">PHOTOS ICI</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons -->\n\n<!-- wp:paragraph -->\n<p>Pendant l’hiver 2023, j’ai conçu un système bioponique pour l’installer dans mon jardin dans le centre de Marseille. Je suis parti des contraintes existantes (surface limitée, orientation du soleil, etc.) pour réaliser les plans avec sketchup. Voici une petite animation pour parcourir le résultat :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:embed {"url":"https://youtu.be/MCo0lrLJxGQ","type":"video","providerNameSlug":"youtube","responsive":true,"className":"wp-embed-aspect-4-3 wp-has-aspect-ratio"} -->\n<figure class="wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-4-3 wp-has-aspect-ratio"><div class="wp-block-embed__wrapper">\nhttps://youtu.be/MCo0lrLJxGQ\n</div></figure>\n<!-- /wp:embed -->\n\n<!-- wp:paragraph -->\n<p>dsds</p>\n<!-- /wp:paragraph -->','Bioponie 2023','','inherit','closed','closed','','8-revision-v1','','','2023-07-09 18:29:11','2023-07-09 16:29:11','',8,'http://vicq.org/hs/?p=49',0,'revision','',0);
INSERT INTO `hs_posts` VALUES (50,1,'2023-07-09 18:29:26','2023-07-09 16:29:26','<!-- wp:buttons -->\n<div class="wp-block-buttons"><!-- wp:button -->\n<div class="wp-block-button"><a class="wp-block-button__link wp-element-button" href="https://photos.app.goo.gl/z4envoGfzvAShT5L6">PHOTOS ICI</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons -->\n\n<!-- wp:paragraph -->\n<p>Pendant l’hiver 2023, j’ai conçu un système Hydroponique pour l’installer sur la terrasse de ma maman à Saint-Germain-en-Laye. Je suis parti des contraintes existantes (surface limitée, orientation du soleil, etc.) pour réaliser les plans avec sketchup. Voici une petite animation pour présenter le système :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->','Hydroponie 2023','','inherit','closed','closed','','15-revision-v1','','','2023-07-09 18:29:26','2023-07-09 16:29:26','',15,'http://vicq.org/hs/?p=50',0,'revision','',0);
INSERT INTO `hs_posts` VALUES (51,1,'2023-07-14 11:33:15','2023-07-14 09:33:15','<!-- wp:buttons -->\n<div class="wp-block-buttons"><!-- wp:button -->\n<div class="wp-block-button"><a class="wp-block-button__link wp-element-button" href="https://photos.app.goo.gl/z4envoGfzvAShT5L6">PHOTOS ICI</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons -->\n\n<!-- wp:paragraph -->\n<p>Pendant l’hiver 2023, j’ai conçu un système hydroponique pour l’installer sur la terrasse de ma mère à Saint-Germain-en-Laye. Je suis parti des contraintes existantes (surface limitée, orientation du soleil, etc.) pour réaliser les plans avec sketchup. Voici une petite animation pour présenter le système :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->','Hydroponie 2023','','inherit','closed','closed','','15-revision-v1','','','2023-07-14 11:33:15','2023-07-14 09:33:15','',15,'http://vicq.org/hs/?p=51',0,'revision','',0);
INSERT INTO `hs_posts` VALUES (53,1,'2023-07-14 11:34:33','2023-07-14 09:34:33','<!-- wp:buttons -->\n<div class="wp-block-buttons"><!-- wp:button -->\n<div class="wp-block-button"><a class="wp-block-button__link wp-element-button" href="https://photos.app.goo.gl/z4envoGfzvAShT5L6">PHOTOS ICI</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons -->\n\n<!-- wp:paragraph -->\n<p>Pendant l’hiver 2023, j’ai conçu un système hydroponique pour l’installer sur la terrasse de ma mère à Saint-Germain-en-Laye. Je suis parti des contraintes existantes (surface limitée, orientation du soleil, etc.) pour réaliser les plans avec sketchup. Voici une petite animation pour présenter le système :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->','Hydroponie 2023','','inherit','closed','closed','','15-revision-v1','','','2023-07-14 11:34:33','2023-07-14 09:34:33','',15,'http://vicq.org/hs/?p=53',0,'revision','',0);
INSERT INTO `hs_posts` VALUES (55,1,'2023-07-14 12:30:14','2023-07-14 10:30:14','<!-- wp:buttons -->\n<div class="wp-block-buttons"><!-- wp:button -->\n<div class="wp-block-button"><a class="wp-block-button__link wp-element-button" href="https://photos.app.goo.gl/9unhagDPNbqhikj4A">PHOTOS ICI</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons -->\n\n<!-- wp:paragraph -->\n<p>Pendant l’hiver 2023, j’ai conçu un système bioponique pour l’installer dans mon jardin dans le centre de Marseille. Je suis parti des contraintes existantes (surface limitée, orientation du soleil, etc.) pour réaliser les plans avec sketchup. Voici une petite animation pour parcourir le résultat :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:embed {"url":"https://youtu.be/MCo0lrLJxGQ","type":"video","providerNameSlug":"youtube","responsive":true,"className":"wp-embed-aspect-4-3 wp-has-aspect-ratio"} -->\n<figure class="wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-4-3 wp-has-aspect-ratio"><div class="wp-block-embed__wrapper">\nhttps://youtu.be/MCo0lrLJxGQ\n</div></figure>\n<!-- /wp:embed -->\n\n<!-- wp:paragraph -->\n<p>Caractéristiques du système :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:table -->\n<figure class="wp-block-table"><table><tbody><tr><td>Volume d\'eau circulante</td><td>440 litres</td></tr><tr><td>Surface plantée</td><td>2 m2</td></tr><tr><td>plantations</td><td>4 Tomates<br>1 concombre<br>1 poivron "petit marseillais"<br>1 piment<br>1 aubergine<br>1 ciboulette<br>1 fraise<br>1 menthe<br>salades (batavia, frisée, roquette)<br>basilic<br>coriandre vietnamienne<br></td></tr><tr><td>Pompe à eau</td><td>3000 l/h 10 W (marque <a href="https://www.amazon.fr/gp/product/B07MYSHHQX/ref=ppx_yo_dt_b_search_asin_title?ie=UTF8&amp;psc=1">EXLECO</a>)</td></tr><tr><td>Pompe à air</td><td>300 l/h</td></tr></tbody></table></figure>\n<!-- /wp:table -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->','Bioponie 2023','','inherit','closed','closed','','8-revision-v1','','','2023-07-14 12:30:14','2023-07-14 10:30:14','',8,'http://vicq.org/hs/?p=55',0,'revision','',0);
INSERT INTO `hs_posts` VALUES (56,1,'2023-07-14 12:30:26','2023-07-14 10:30:26','<!-- wp:buttons -->\n<div class="wp-block-buttons"><!-- wp:button -->\n<div class="wp-block-button"><a class="wp-block-button__link wp-element-button" href="https://photos.app.goo.gl/9unhagDPNbqhikj4A">PHOTOS ICI</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons -->\n\n<!-- wp:paragraph -->\n<p>Pendant l’hiver 2023, j’ai conçu un système bioponique pour l’installer dans mon jardin dans le centre de Marseille. Je suis parti des contraintes existantes (surface limitée, orientation du soleil, etc.) pour réaliser les plans avec sketchup. Voici une petite animation pour parcourir le résultat :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:embed {"url":"https://youtu.be/MCo0lrLJxGQ","type":"video","providerNameSlug":"youtube","responsive":true,"className":"wp-embed-aspect-4-3 wp-has-aspect-ratio"} -->\n<figure class="wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-4-3 wp-has-aspect-ratio"><div class="wp-block-embed__wrapper">\nhttps://youtu.be/MCo0lrLJxGQ\n</div></figure>\n<!-- /wp:embed -->\n\n<!-- wp:paragraph -->\n<p>Caractéristiques du système :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:table -->\n<figure class="wp-block-table"><table><tbody><tr><td>Volume d\'eau circulante</td><td>440 litres</td></tr><tr><td>Surface plantée</td><td>2 m2</td></tr><tr><td>plantations</td><td>4 Tomates<br>1 concombre<br>1 poivron "petit marseillais"<br>1 piment<br>1 aubergine<br>1 ciboulette<br>1 fraise<br>1 menthe<br>salades (batavia, frisée, roquette)<br>basilic<br>coriandre vietnamienne</td></tr><tr><td>Pompe à eau</td><td>3000 l/h 10 W (marque <a href="https://www.amazon.fr/gp/product/B07MYSHHQX/ref=ppx_yo_dt_b_search_asin_title?ie=UTF8&amp;psc=1">EXLECO</a>)</td></tr><tr><td>Pompe à air</td><td>300 l/h</td></tr></tbody></table></figure>\n<!-- /wp:table -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->','Bioponie 2023','','inherit','closed','closed','','8-revision-v1','','','2023-07-14 12:30:26','2023-07-14 10:30:26','',8,'http://vicq.org/hs/?p=56',0,'revision','',0);
INSERT INTO `hs_posts` VALUES (60,1,'2023-08-12 21:54:41','2023-08-12 19:54:41','<!-- wp:paragraph -->\n<p>Ce blog est dédié à la culture hors sol : hydroponie et bioponie. Sont présentées les activités de test et d\'apprentissage de ces techniques réalisées depuis le printemps 2022 à Saint-germain-en-Laye (78, Yvelines), Aix-en-Provence et Marseille (13, Bouches du Rhône). </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Au printemps 2022 ont été mis en service 4 systèmes modulaires hydroponiques (que l\'on pourrait les qualifier d\'aéro-hydroponiques). Ces systèmes avaient une forme de tour dans laquelle était insérée des paniers contenant des billes d\'argile. En bas de la tour un réservoir de 10 à 20 litres dans lequel une pompe alimentait le haut de la tour par un tuyau, le liquide redescendant dans la tour en imprégnant les racines par gravité.</p>\n<!-- /wp:paragraph -->','Bienvenue','','inherit','closed','closed','','2-revision-v1','','','2023-08-12 21:54:41','2023-08-12 19:54:41','',2,'https://hs.vicq.org/?p=60',0,'revision','',0);
INSERT INTO `hs_posts` VALUES (61,1,'2023-08-12 22:52:39','2023-08-12 20:52:39','<!-- wp:paragraph -->\n<p>Ce blog est dédié à la culture hors sol : hydroponie et bioponie. Y sont présentées les activités de test et d\'apprentissage de ces techniques réalisées depuis le printemps 2022 à Saint-germain-en-Laye (78, Yvelines), Aix-en-Provence et Marseille (13, Bouches du Rhône). </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Au printemps 2022 J\'ai fabriqué et mis en service 4 systèmes modulaires hydroponiques (que l\'on pourrait les qualifier d\'aéro-hydroponiques). Ces systèmes avaient une forme de cylindre creux lequel étaient insérés des paniers contenant des billes d\'argile. En bas de la tour un réservoir de 10 à 20 litres dans lequel une pompe alimentait le haut de la tour par un tuyau, le liquide redescendant dans la tour en imprégnant les racines par gravité.</p>\n<!-- /wp:paragraph -->','Bienvenue','','inherit','closed','closed','','2-revision-v1','','','2023-08-12 22:52:39','2023-08-12 20:52:39','',2,'https://hs.vicq.org/?p=61',0,'revision','',0);
INSERT INTO `hs_posts` VALUES (63,1,'2023-08-13 07:51:36','2023-08-13 05:51:36','<!-- wp:paragraph -->\n<p>Ce blog est dédié à l\'hydroponie et la bioponie. Ces deux techniques de culture font partie de la famille plus vaste des cultures hors-sol sur substrat neutre utilisant une recirculation de liquide nutritif. Elle consiste à faire pousser des plantes sans terre, sur un substrat neutre (billes d\'argile par exemple), en mettant en place un dispositif suffisamment efficace pour leur permettre une croissance efficace. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Définitions</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>vous pouvez trouver les définitions de ces termes <a href="https://fermedecagnolle.fr/hydroponie-bioponie-aquaponie-definitions/">ici</a> par exemple). </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Travaux prése,tés</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Y sont présentées les activités de test et d\'apprentissage de ces techniques réalisées depuis le printemps 2022 à Saint-germain-en-Laye (78, Yvelines), Aix-en-Provence et Marseille (13, Bouches du Rhône). </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Au printemps 2022 J\'ai fabriqué et mis en service 4 systèmes modulaires hydroponiques (que l\'on pourrait les qualifier d\'aéro-hydroponiques). Ces systèmes avaient une forme de cylindre creux lequel étaient insérés des paniers contenant des billes d\'argile. En bas de la tour un réservoir de 10 à 20 litres dans lequel une pompe alimentait le haut de la tour par un tuyau, le liquide redescendant dans la tour en imprégnant les racines par gravité.</p>\n<!-- /wp:paragraph -->','Bienvenue','','inherit','closed','closed','','2-revision-v1','','','2023-08-13 07:51:36','2023-08-13 05:51:36','',2,'https://hs.vicq.org/?p=63',0,'revision','',0);
INSERT INTO `hs_posts` VALUES (64,1,'2023-08-13 08:11:15','2023-08-13 06:11:15','<!-- wp:paragraph -->\n<p>Ce blog est consacré à l\'hydroponie et la bioponie domestiques. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Ces deux techniques de culture font partie de la famille des cultures hors-sol sur substrat neutre. Elle consiste à faire pousser des plantes sans terre, sur un substrat neutre (billes d\'argile par exemple), en mettant en place un dispositif efficace pour leur fournir les nutriments nécessaire pour assurer une croissance efficace. La recirculation du liquide nutritif évite la perte d\'eau inévitable dans la culture en sol.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Définitions</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Le web pullule d\'explications sur ces techniques de culture. Il existe de très nombreux dispositifs Vous pouvez trouver <a href="https://fermedecagnolle.fr/hydroponie-bioponie-aquaponie-definitions/">ici</a> par exemple des définitions de l\'hydroponie, bioponie et aquaponie proposées par Marion Sarlé (<a href="https://lessourciers.com/fr/">les sourciers</a>). </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Travaux prése,tés</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Y sont présentées les activités de test et d\'apprentissage de ces techniques réalisées depuis le printemps 2022 à Saint-germain-en-Laye (78, Yvelines), Aix-en-Provence et Marseille (13, Bouches du Rhône). </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Au printemps 2022 J\'ai fabriqué et mis en service 4 systèmes modulaires hydroponiques (que l\'on pourrait les qualifier d\'aéro-hydroponiques). Ces systèmes avaient une forme de cylindre creux lequel étaient insérés des paniers contenant des billes d\'argile. En bas de la tour un réservoir de 10 à 20 litres dans lequel une pompe alimentait le haut de la tour par un tuyau, le liquide redescendant dans la tour en imprégnant les racines par gravité.</p>\n<!-- /wp:paragraph -->','Bienvenue','','inherit','closed','closed','','2-revision-v1','','','2023-08-13 08:11:15','2023-08-13 06:11:15','',2,'https://hs.vicq.org/?p=64',0,'revision','',0);
INSERT INTO `hs_posts` VALUES (65,1,'2023-08-13 08:22:19','2023-08-13 06:22:19','<!-- wp:heading -->\n<h2 class="wp-block-heading">Ce blog est consacré à l\'hydroponie et la bioponie domestiques. </h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Ces deux techniques de culture font partie de la famille des cultures hors-sol sur substrat neutre. Elles consistent à faire pousser des plantes sans terre, sur un substrat neutre (billes d\'argile par exemple), en mettant en place un dispositif efficace pour leur fournir les nutriments nécessaire pour assurer une croissance efficace. La recirculation du liquide nutritif évite la perte d\'eau dans la culture en sol.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Définitions</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Le web pullule d\'explications sur ces techniques de culture. Vous pouvez trouver <a href="https://fermedecagnolle.fr/hydroponie-bioponie-aquaponie-definitions/">ici</a> par exemple des définitions de l\'<strong>hydroponie</strong>, <strong>bioponie</strong> et <strong>aquaponie</strong> proposées par Marion Sarlé (<a href="https://lessourciers.com/fr/">les sourciers</a>). Une fois ces grandes définitions comprises, on trouve de très nombreuses techniques et dispositifs utilisés dans ce type de culture (ex : <a href="https://jardinfute.com/systeme-dwc-hydroponie/">DWC</a>, <a href="https://jardinfute.com/systeme-nft-hydroponie/">NFT</a>, etc.). </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Origine du projet</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>J\'ai commencé à m\'intéresser</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Y sont présentées les activités de test et d\'apprentissage de ces techniques réalisées depuis le printemps 2022 à Saint-germain-en-Laye (78, Yvelines), Aix-en-Provence et Marseille (13, Bouches du Rhône). </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Au printemps 2022 J\'ai fabriqué et mis en service 4 systèmes modulaires hydroponiques (que l\'on pourrait les qualifier d\'aéro-hydroponiques). Ces systèmes avaient une forme de cylindre creux lequel étaient insérés des paniers contenant des billes d\'argile. En bas de la tour un réservoir de 10 à 20 litres dans lequel une pompe alimentait le haut de la tour par un tuyau, le liquide redescendant dans la tour en imprégnant les racines par gravité.</p>\n<!-- /wp:paragraph -->','Bienvenue','','inherit','closed','closed','','2-revision-v1','','','2023-08-13 08:22:19','2023-08-13 06:22:19','',2,'https://hs.vicq.org/?p=65',0,'revision','',0);
INSERT INTO `hs_posts` VALUES (66,1,'2023-08-13 08:59:30','2023-08-13 06:59:30','<!-- wp:heading -->\n<h2 class="wp-block-heading">Ce blog est consacré à l\'hydroponie et la bioponie domestiques. </h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Ces deux techniques de culture font partie de la famille des cultures hors-sol sur substrat neutre. Elles consistent à faire pousser des plantes sans terre, sur un substrat neutre (billes d\'argile par exemple), en mettant en place un dispositif efficace pour leur fournir les nutriments nécessaire pour assurer une croissance efficace. La recirculation du liquide nutritif évite la perte d\'eau dans la culture en sol.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Définitions</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Le web pullule d\'explications sur ces techniques de culture. Vous pouvez trouver <a href="https://fermedecagnolle.fr/hydroponie-bioponie-aquaponie-definitions/">ici</a> par exemple des définitions de l\'<strong>hydroponie</strong>, <strong>bioponie</strong> et <strong>aquaponie</strong> proposées par Marion Sarlé (<a href="https://lessourciers.com/fr/">les sourciers</a>). Une fois ces grandes définitions comprises, on trouve de très nombreuses techniques et dispositifs utilisés dans ce type de culture (ex : <a href="https://jardinfute.com/systeme-dwc-hydroponie/">DWC</a>, <a href="https://jardinfute.com/systeme-nft-hydroponie/">NFT</a>, etc.). </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Origine du projet et cheminement</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>J\'ai commencé à m\'intéresser aux questions de culture urbaines pendant l\'épidémie de COVID. Cet épisode anxiogène m\'a fait m\'interroger sur certaines questions d\'organisation de la société, et aux risques associés à l\'approvisionnement en ville des denrées alimentaires. En effet, il semble qu\'en cas de gros dysfonctionnement de la logistique d\'approvisionnement en nourriture, en quelque jours les villes pourraient se retrouver privées d\'une partie importante de leurs ressources alimentaires. Face à cette fragilité de l\'organisation de ces flux de transport, il semble intéressant de développer des dispositifs urbains assurant la production de légumes dans la ville. Des études sur ces sujets existent, mais je ne suis pas un spécialiste de la recherche en agriculture urbaine. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Définition du périmètre</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>On peut vouloir créer des fermes urbaines de taille plus ou moins importante, mais j\'ai décider de m\'intéresser à des dispositifs mis en œuvre à l\'échelle individuelle ou de proche voisinage, car cela représente des investissements réduits et une capacité de réalisation rapide. De plus, même si l\'ambition de tels systèmes n\'est pas de produire des bénéfices financiers, elle semble riche de bénéfices à l\'échelle de l\'individu ou du voisinage</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Y sont présentées les activités de test et d\'apprentissage de ces techniques réalisées depuis le printemps 2022 à Saint-germain-en-Laye (78, Yvelines), Aix-en-Provence et Marseille (13, Bouches du Rhône). </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Au printemps 2022 J\'ai fabriqué et mis en service 4 systèmes modulaires hydroponiques (que l\'on pourrait les qualifier d\'aéro-hydroponiques). Ces systèmes avaient une forme de cylindre creux lequel étaient insérés des paniers contenant des billes d\'argile. En bas de la tour un réservoir de 10 à 20 litres dans lequel une pompe alimentait le haut de la tour par un tuyau, le liquide redescendant dans la tour en imprégnant les racines par gravité.</p>\n<!-- /wp:paragraph -->','Bienvenue','','inherit','closed','closed','','2-revision-v1','','','2023-08-13 08:59:30','2023-08-13 06:59:30','',2,'https://hs.vicq.org/?p=66',0,'revision','',0);
INSERT INTO `hs_posts` VALUES (67,1,'2023-08-13 09:04:27','2023-08-13 07:04:27','<!-- wp:heading -->\n<h2 class="wp-block-heading">Ce blog est consacré à l\'hydroponie et la bioponie domestiques. </h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Ces deux techniques de culture font partie de la famille des cultures hors-sol sur substrat neutre. Elles consistent à faire pousser des plantes sans terre, sur un substrat neutre (billes d\'argile par exemple), en mettant en place un dispositif efficace pour leur fournir les nutriments nécessaire pour assurer une croissance efficace. La recirculation du liquide nutritif évite la perte d\'eau dans la culture en sol.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Définitions</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Le web pullule d\'explications sur ces techniques de culture. Vous pouvez trouver <a href="https://fermedecagnolle.fr/hydroponie-bioponie-aquaponie-definitions/">ici</a> par exemple des définitions de l\'<strong>hydroponie</strong>, <strong>bioponie</strong> et <strong>aquaponie</strong> proposées par Marion Sarlé (<a href="https://lessourciers.com/fr/">les sourciers</a>). Une fois ces grandes définitions comprises, on trouve de très nombreuses techniques et dispositifs utilisés dans ce type de culture (ex : <a href="https://jardinfute.com/systeme-dwc-hydroponie/">DWC</a>, <a href="https://jardinfute.com/systeme-nft-hydroponie/">NFT</a>, etc.). </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Origine du projet et cheminement</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>J\'ai commencé à m\'intéresser aux questions de culture urbaines pendant l\'épidémie de COVID. Cet épisode anxiogène m\'a fait m\'interroger sur certaines questions d\'organisation de la société, et aux risques associés à l\'approvisionnement en ville des denrées alimentaires. En effet, il semble qu\'en cas de gros dysfonctionnement de la logistique d\'approvisionnement en nourriture, en quelque jours les villes pourraient se retrouver privées d\'une partie importante de leurs ressources alimentaires. Face à cette fragilité de l\'organisation de ces flux de transport, il semble intéressant de développer des dispositifs urbains assurant la production de légumes dans la ville. Des études sur ces sujets existent, mais je ne suis pas un spécialiste de la recherche en agriculture urbaine. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Définition du périmètre</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>On peut vouloir créer des fermes urbaines de taille plus ou moins importante, mais j\'ai décider de m\'intéresser à des dispositifs mis en œuvre à l\'échelle individuelle ou de proche voisinage, car cela représente des investissements réduits et une capacité de réalisation rapide. De plus, même si l\'ambition de tels systèmes n\'est pas de produire des bénéfices financiers, elle semble riche de bénéfices à l\'échelle de l\'individu ou du voisinage :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Faible coût de développement</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Très faible coût énergétique</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Très faible consommation d\'eau</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Bénéfice éducatif évident sur la compréhension de la culture des plantes</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Partage des cultures et des savoir faire avec les voisins</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>etc.</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p>Y sont présentées les activités de test et d\'apprentissage de ces techniques réalisées depuis le printemps 2022 à Saint-germain-en-Laye (78, Yvelines), Aix-en-Provence et Marseille (13, Bouches du Rhône). </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Au printemps 2022 J\'ai fabriqué et mis en service 4 systèmes modulaires hydroponiques (que l\'on pourrait les qualifier d\'aéro-hydroponiques). Ces systèmes avaient une forme de cylindre creux lequel étaient insérés des paniers contenant des billes d\'argile. En bas de la tour un réservoir de 10 à 20 litres dans lequel une pompe alimentait le haut de la tour par un tuyau, le liquide redescendant dans la tour en imprégnant les racines par gravité.</p>\n<!-- /wp:paragraph -->','Bienvenue','','inherit','closed','closed','','2-revision-v1','','','2023-08-13 09:04:27','2023-08-13 07:04:27','',2,'https://hs.vicq.org/?p=67',0,'revision','',0);
INSERT INTO `hs_posts` VALUES (68,1,'2023-08-13 09:07:41','2023-08-13 07:07:41','<!-- wp:heading -->\n<h2 class="wp-block-heading">Ce blog est consacré à l\'hydroponie et la bioponie domestiques. </h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Ces deux techniques de culture font partie de la famille des cultures hors-sol sur substrat neutre. Elles consistent à faire pousser des plantes sans terre, sur un substrat neutre (billes d\'argile par exemple), en mettant en place un dispositif efficace pour leur fournir les nutriments nécessaire pour assurer une croissance efficace. La recirculation du liquide nutritif évite la perte d\'eau dans la culture en sol.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Définitions</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Le web pullule d\'explications sur ces techniques de culture. Vous pouvez trouver <a href="https://fermedecagnolle.fr/hydroponie-bioponie-aquaponie-definitions/">ici</a> par exemple des définitions de l\'<strong>hydroponie</strong>, <strong>bioponie</strong> et <strong>aquaponie</strong> proposées par Marion Sarlé (<a href="https://lessourciers.com/fr/">les sourciers</a>). Une fois ces grandes définitions comprises, on trouve de très nombreuses techniques et dispositifs utilisés dans ce type de culture (ex : <a href="https://jardinfute.com/systeme-dwc-hydroponie/">DWC</a>, <a href="https://jardinfute.com/systeme-nft-hydroponie/">NFT</a>, etc.). </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Origine du projet et cheminement</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>J\'ai commencé à m\'intéresser aux questions de culture urbaines pendant l\'épidémie de COVID. Cet épisode anxiogène m\'a fait m\'interroger sur certaines questions d\'organisation de la société, et aux risques associés à l\'approvisionnement en ville des denrées alimentaires. En effet, il semble qu\'en cas de gros dysfonctionnement de la logistique d\'approvisionnement en nourriture, en quelque jours les villes pourraient se retrouver privées d\'une partie importante de leurs ressources alimentaires. Face à cette fragilité de l\'organisation de ces flux de transport, il semble intéressant de développer des dispositifs urbains assurant la production de légumes dans la ville. Des études sur ces sujets existent, mais je ne suis pas un spécialiste de la recherche en agriculture urbaine. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Définition du périmètre</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>On peut vouloir créer des fermes urbaines de taille plus ou moins importante, mais j\'ai décider de m\'intéresser à des dispositifs mis en œuvre à l\'échelle individuelle ou de proche voisinage, car cela représente des investissements réduits et une capacité de réalisation rapide. De plus, même si l\'ambition de tels systèmes n\'est pas de produire des bénéfices financiers, elle semble riche de bénéfices à l\'échelle de l\'individu ou du voisinage :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:quote -->\n<blockquote class="wp-block-quote"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Faible coût de développement</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Très faible coût énergétique</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Très faible consommation d\'eau</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Bénéfice éducatif évident sur la compréhension de la culture des plantes</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Partage des cultures et des savoir faire avec les voisins</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>etc.</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></blockquote>\n<!-- /wp:quote -->\n\n<!-- wp:paragraph -->\n<p>Y sont présentées les activités de test et d\'apprentissage de ces techniques réalisées depuis le printemps 2022 à Saint-germain-en-Laye (78, Yvelines), Aix-en-Provence et Marseille (13, Bouches du Rhône). </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Au printemps 2022 J\'ai fabriqué et mis en service 4 systèmes modulaires hydroponiques (que l\'on pourrait les qualifier d\'aéro-hydroponiques). Ces systèmes avaient une forme de cylindre creux lequel étaient insérés des paniers contenant des billes d\'argile. En bas de la tour un réservoir de 10 à 20 litres dans lequel une pompe alimentait le haut de la tour par un tuyau, le liquide redescendant dans la tour en imprégnant les racines par gravité.</p>\n<!-- /wp:paragraph -->','Bienvenue','','inherit','closed','closed','','2-revision-v1','','','2023-08-13 09:07:41','2023-08-13 07:07:41','',2,'https://hs.vicq.org/?p=68',0,'revision','',0);
INSERT INTO `hs_posts` VALUES (69,1,'2023-08-13 09:09:04','2023-08-13 07:09:04','<!-- wp:heading -->\n<h2 class="wp-block-heading">Ce blog est consacré à l\'hydroponie et la bioponie domestiques. </h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Ces deux techniques de culture font partie de la famille des cultures hors-sol sur substrat neutre. Elles consistent à faire pousser des plantes sans terre, sur un substrat neutre (billes d\'argile par exemple), en mettant en place un dispositif efficace pour leur fournir les nutriments nécessaire pour assurer une croissance efficace. La recirculation du liquide nutritif évite la perte d\'eau dans la culture en sol.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Définitions</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Le web pullule d\'explications sur ces techniques de culture. Vous pouvez trouver <a href="https://fermedecagnolle.fr/hydroponie-bioponie-aquaponie-definitions/">ici</a> par exemple des définitions de l\'<strong>hydroponie</strong>, <strong>bioponie</strong> et <strong>aquaponie</strong> proposées par Marion Sarlé (<a href="https://lessourciers.com/fr/">les sourciers</a>). Une fois ces grandes définitions comprises, on trouve de très nombreuses techniques et dispositifs utilisés dans ce type de culture (ex : <a href="https://jardinfute.com/systeme-dwc-hydroponie/">DWC</a>, <a href="https://jardinfute.com/systeme-nft-hydroponie/">NFT</a>, etc.). </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Origine du projet et cheminement</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>J\'ai commencé à m\'intéresser aux questions de culture urbaines pendant l\'épidémie de COVID. Cet épisode anxiogène m\'a fait m\'interroger sur certaines questions d\'organisation de la société, et aux risques associés à l\'approvisionnement en ville des denrées alimentaires. En effet, il semble qu\'en cas de gros dysfonctionnement de la logistique d\'approvisionnement en nourriture, en quelque jours les villes pourraient se retrouver privées d\'une partie importante de leurs ressources alimentaires. Face à cette fragilité de l\'organisation de ces flux de transport, il semble intéressant de développer des dispositifs urbains assurant la production de légumes dans la ville. Des études sur ces sujets existent, mais je ne suis pas un spécialiste de la recherche en agriculture urbaine. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Définition du périmètre</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>On peut vouloir créer des fermes urbaines de taille plus ou moins importante, mais j\'ai décider de m\'intéresser à des dispositifs mis en œuvre à l\'échelle individuelle ou de proche voisinage, car cela représente des investissements réduits et une capacité de réalisation rapide. De plus, même si l\'ambition de tels systèmes n\'est pas de produire des bénéfices financiers, elle semble riche de bénéfices à l\'échelle de l\'individu ou du voisinage :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:quote -->\n<blockquote class="wp-block-quote"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Qualité des légumes</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>rendement élévé </li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Bénéfice éducatif évident sur la compréhension de la culture des plantes</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Partage des cultures et des savoir faire avec les voisins</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Faible coût de développement</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Très faible coût énergétique</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Très faible consommation d\'eau</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>etc.</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></blockquote>\n<!-- /wp:quote -->\n\n<!-- wp:paragraph -->\n<p>Y sont présentées les activités de test et d\'apprentissage de ces techniques réalisées depuis le printemps 2022 à Saint-germain-en-Laye (78, Yvelines), Aix-en-Provence et Marseille (13, Bouches du Rhône). </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Au printemps 2022 J\'ai fabriqué et mis en service 4 systèmes modulaires hydroponiques (que l\'on pourrait les qualifier d\'aéro-hydroponiques). Ces systèmes avaient une forme de cylindre creux lequel étaient insérés des paniers contenant des billes d\'argile. En bas de la tour un réservoir de 10 à 20 litres dans lequel une pompe alimentait le haut de la tour par un tuyau, le liquide redescendant dans la tour en imprégnant les racines par gravité.</p>\n<!-- /wp:paragraph -->','Bienvenue','','inherit','closed','closed','','2-revision-v1','','','2023-08-13 09:09:04','2023-08-13 07:09:04','',2,'https://hs.vicq.org/?p=69',0,'revision','',0);
INSERT INTO `hs_posts` VALUES (70,1,'2023-08-13 09:09:22','2023-08-13 07:09:22','<!-- wp:heading -->\n<h2 class="wp-block-heading">Ce blog est consacré à l\'hydroponie et la bioponie domestiques. </h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Ces deux techniques de culture font partie de la famille des cultures hors-sol sur substrat neutre. Elles consistent à faire pousser des plantes sans terre, sur un substrat neutre (billes d\'argile par exemple), en mettant en place un dispositif efficace pour leur fournir les nutriments nécessaire pour assurer une croissance efficace. La recirculation du liquide nutritif évite la perte d\'eau dans la culture en sol.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Définitions</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Le web pullule d\'explications sur ces techniques de culture. Vous pouvez trouver <a href="https://fermedecagnolle.fr/hydroponie-bioponie-aquaponie-definitions/">ici</a> par exemple des définitions de l\'<strong>hydroponie</strong>, <strong>bioponie</strong> et <strong>aquaponie</strong> proposées par Marion Sarlé (<a href="https://lessourciers.com/fr/">les sourciers</a>). Une fois ces grandes définitions comprises, on trouve de très nombreuses techniques et dispositifs utilisés dans ce type de culture (ex : <a href="https://jardinfute.com/systeme-dwc-hydroponie/">DWC</a>, <a href="https://jardinfute.com/systeme-nft-hydroponie/">NFT</a>, etc.). </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Origine du projet et cheminement</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>J\'ai commencé à m\'intéresser aux questions de culture urbaines pendant l\'épidémie de COVID. Cet épisode anxiogène m\'a fait m\'interroger sur certaines questions d\'organisation de la société, et aux risques associés à l\'approvisionnement en ville des denrées alimentaires. En effet, il semble qu\'en cas de gros dysfonctionnement de la logistique d\'approvisionnement en nourriture, en quelque jours les villes pourraient se retrouver privées d\'une partie importante de leurs ressources alimentaires. Face à cette fragilité de l\'organisation de ces flux de transport, il semble intéressant de développer des dispositifs urbains assurant la production de légumes dans la ville. Des études sur ces sujets existent, mais je ne suis pas un spécialiste de la recherche en agriculture urbaine. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Définition du périmètre</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>On peut vouloir créer des fermes urbaines de taille plus ou moins importante, mais j\'ai décider de m\'intéresser à des dispositifs mis en œuvre à l\'échelle individuelle ou de proche voisinage, car cela représente des investissements réduits et une capacité de réalisation rapide. De plus, même si l\'ambition de tels systèmes n\'est pas de produire des bénéfices financiers, elle semble riche de bénéfices à l\'échelle de l\'individu ou du voisinage :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:quote -->\n<blockquote class="wp-block-quote"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Qualité des légumes</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>rendement élevé </li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Bénéfice éducatif évident sur la compréhension de la culture des plantes</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Partage des cultures et des savoir faire avec les voisins</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Faible coût de développement</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Très faible coût énergétique</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Très faible consommation d\'eau</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>etc.</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></blockquote>\n<!-- /wp:quote -->\n\n<!-- wp:paragraph -->\n<p>Y sont présentées les activités de test et d\'apprentissage de ces techniques réalisées depuis le printemps 2022 à Saint-germain-en-Laye (78, Yvelines), Aix-en-Provence et Marseille (13, Bouches du Rhône). </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Au printemps 2022 J\'ai fabriqué et mis en service 4 systèmes modulaires hydroponiques (que l\'on pourrait les qualifier d\'aéro-hydroponiques). Ces systèmes avaient une forme de cylindre creux lequel étaient insérés des paniers contenant des billes d\'argile. En bas de la tour un réservoir de 10 à 20 litres dans lequel une pompe alimentait le haut de la tour par un tuyau, le liquide redescendant dans la tour en imprégnant les racines par gravité.</p>\n<!-- /wp:paragraph -->','Bienvenue','','inherit','closed','closed','','2-revision-v1','','','2023-08-13 09:09:22','2023-08-13 07:09:22','',2,'https://hs.vicq.org/?p=70',0,'revision','',0);
INSERT INTO `hs_posts` VALUES (71,1,'2023-08-14 09:42:15','2023-08-14 07:42:15','<!-- wp:heading -->\n<h2 class="wp-block-heading">Ce blog est consacré à l\'hydroponie et la bioponie domestiques. </h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Ces deux techniques de culture font partie de la famille des cultures hors-sol sur substrat neutre. Elles consistent à faire pousser des plantes sans terre, sur un substrat neutre (billes d\'argile par exemple), en mettant en place un dispositif efficace pour leur fournir les nutriments nécessaire pour assurer une croissance efficace. La recirculation du liquide nutritif évite la perte d\'eau dans la culture en sol.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Définitions</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Le web pullule d\'explications sur ces techniques de culture. Vous pouvez trouver <a href="https://fermedecagnolle.fr/hydroponie-bioponie-aquaponie-definitions/">ici</a> par exemple des définitions de l\'<strong>hydroponie</strong>, <strong>bioponie</strong> et <strong>aquaponie</strong> proposées par Marion Sarlé (<a href="https://lessourciers.com/fr/">les sourciers</a>). Une fois ces grandes définitions comprises, on trouve de très nombreuses techniques et dispositifs utilisés dans ce type de culture (ex : <a href="https://jardinfute.com/systeme-dwc-hydroponie/">DWC</a>, <a href="https://jardinfute.com/systeme-nft-hydroponie/">NFT</a>, etc.). </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Origine du projet et cheminement</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>J\'ai commencé à m\'intéresser aux questions de culture urbaines pendant l\'épidémie de COVID. Cet épisode anxiogène m\'a fait m\'interroger sur certaines questions d\'organisation de la société, et aux risques associés à l\'approvisionnement en ville des denrées alimentaires. En effet, il semble qu\'en cas de gros dysfonctionnement de la logistique d\'approvisionnement en nourriture, en quelque jours les villes pourraient se retrouver privées d\'une partie importante de leurs ressources alimentaires. Face à cette fragilité de l\'organisation de ces flux de transport, il semble intéressant de développer des dispositifs urbains assurant la production de légumes dans la ville. Des études sur ces sujets existent, mais je ne suis pas un spécialiste de la recherche en agriculture urbaine. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Définition du périmètre</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>On peut vouloir créer des fermes urbaines de taille plus ou moins importante, mais j\'ai décider de m\'intéresser à des dispositifs mis en œuvre à l\'échelle individuelle ou de proche voisinage, car cela représente des investissements réduits, une capacité de réalisation rapide et un investissement en temps acceptable. De plus, même si l\'ambition de tels systèmes n\'est pas de produire des bénéfices financiers, elle semble riche à l\'échelle de l\'individu ou du voisinage :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:quote -->\n<blockquote class="wp-block-quote"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Qualité des légumes</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>rendement élevé au m2</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Bénéfice éducatif évident sur la compréhension de la culture des plantes</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Partage des cultures et des savoir faire avec les voisins</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Faible coût de développement et de mise en oeuvre</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Très faible coût énergétique</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Très faible consommation d\'eau</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>etc.</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></blockquote>\n<!-- /wp:quote -->\n\n<!-- wp:paragraph -->\n<p>Y sont présentées les activités de test et d\'apprentissage de ces techniques réalisées depuis le printemps 2022 à Saint-germain-en-Laye (78, Yvelines), Aix-en-Provence et Marseille (13, Bouches du Rhône). </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Au printemps 2022 J\'ai fabriqué et mis en service 4 systèmes modulaires hydroponiques (que l\'on pourrait les qualifier d\'aéro-hydroponiques). Ces systèmes avaient une forme de cylindre creux lequel étaient insérés des paniers contenant des billes d\'argile. En bas de la tour un réservoir de 10 à 20 litres dans lequel une pompe alimentait le haut de la tour par un tuyau, le liquide redescendant dans la tour en imprégnant les racines par gravité.</p>\n<!-- /wp:paragraph -->','Bienvenue','','inherit','closed','closed','','2-revision-v1','','','2023-08-14 09:42:15','2023-08-14 07:42:15','',2,'https://hs.vicq.org/?p=71',0,'revision','',0);
INSERT INTO `hs_posts` VALUES (72,1,'2023-08-14 09:56:31','2023-08-14 07:56:31','<!-- wp:heading -->\n<h2 class="wp-block-heading">Ce blog est consacré à l\'hydroponie et la bioponie domestiques. </h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Ces deux techniques de culture font partie de la famille des cultures hors-sol sur substrat neutre. Elles consistent à faire pousser des plantes sans terre, sur un substrat neutre (billes d\'argile par exemple), en mettant en place un dispositif efficace pour leur fournir les nutriments nécessaire pour assurer une croissance efficace. La recirculation du liquide nutritif évite la perte d\'eau dans la culture en sol.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Définitions</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Le web pullule d\'explications sur ces techniques de culture. Vous pouvez trouver <a href="https://fermedecagnolle.fr/hydroponie-bioponie-aquaponie-definitions/">ici</a> par exemple des définitions de l\'<strong>hydroponie</strong>, <strong>bioponie</strong> et <strong>aquaponie</strong> proposées par Marion Sarlé (<a href="https://lessourciers.com/fr/">les sourciers</a>). Une fois ces grandes définitions comprises, on trouve de très nombreuses techniques et dispositifs utilisés dans ce type de culture (ex : <a href="https://jardinfute.com/systeme-dwc-hydroponie/">DWC</a>, <a href="https://jardinfute.com/systeme-nft-hydroponie/">NFT</a>, etc.). </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Origine du projet et cheminement</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>J\'ai commencé à m\'intéresser aux questions de culture urbaines pendant l\'épidémie de COVID. Cet épisode anxiogène m\'a fait m\'interroger sur certaines questions d\'organisation de la société, et aux risques associés à l\'approvisionnement en ville des denrées alimentaires. En effet, il semble qu\'en cas de gros dysfonctionnement de la logistique d\'approvisionnement en nourriture, en quelque jours les villes pourraient se retrouver privées d\'une partie importante de leurs ressources alimentaires. Face à cette fragilité de l\'organisation de ces flux de transport, il semble intéressant de développer des dispositifs urbains assurant la production de légumes dans la ville. Des études sur ces sujets existent, mais je ne suis pas un spécialiste de la recherche en agriculture urbaine. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Début 2022, j\'étais très motivé par les principes de l\'aquaponie. La nature symbiotique poissons + plantes, la création d\'un écosystème économe et vertueux, la double production poissons + plantes sur une surface réduite m\'ont donné très envie d\'aller voir de plus près ce genre de systèmes. J\'ai bien sur beaucoup cherché sur internet, vu des réalisations magnifiques (par exemple la chaine de <a href="https://www.youtube.com/@ChrisPagns">Chris Pagns</a> sur youtube).</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Périmètre d\'expérimentation</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>On peut vouloir créer des fermes urbaines de taille plus ou moins importante, mais j\'ai décider de m\'intéresser à des dispositifs mis en œuvre à l\'échelle individuelle ou de proche voisinage, car cela représente des investissements réduits, une capacité de réalisation rapide et un investissement en temps acceptable. De plus, même si l\'ambition de tels systèmes n\'est pas de produire des bénéfices financiers, elle semble intéressante à l\'échelle de l\'individu ou du voisinage :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:quote -->\n<blockquote class="wp-block-quote"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Qualité des légumes</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>rendement élevé au m2</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Éloignement des ravageurs venant de la terre (limaces, etc.)</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Bénéfice éducatif venant de la compréhension de la culture des plantes (en particulier pour les citadins)</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Partage des productions et des savoir faire avec les voisins</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Pas besoin de terre</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Faible coût de développement et de mise en œuvre</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Très faible coût énergétique</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Très faible consommation d\'eau</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>etc.</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></blockquote>\n<!-- /wp:quote -->\n\n<!-- wp:paragraph -->\n<p>Taille du système</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Y sont présentées les activités de test et d\'apprentissage de ces techniques réalisées depuis le printemps 2022 à Saint-germain-en-Laye (78, Yvelines), Aix-en-Provence et Marseille (13, Bouches du Rhône). </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Au printemps 2022 J\'ai fabriqué et mis en service 4 systèmes modulaires hydroponiques (que l\'on pourrait les qualifier d\'aéro-hydroponiques). Ces systèmes avaient une forme de cylindre creux lequel étaient insérés des paniers contenant des billes d\'argile. En bas de la tour un réservoir de 10 à 20 litres dans lequel une pompe alimentait le haut de la tour par un tuyau, le liquide redescendant dans la tour en imprégnant les racines par gravité.</p>\n<!-- /wp:paragraph -->','Bienvenue','','inherit','closed','closed','','2-revision-v1','','','2023-08-14 09:56:31','2023-08-14 07:56:31','',2,'https://hs.vicq.org/?p=72',0,'revision','',0);
INSERT INTO `hs_posts` VALUES (73,1,'2023-08-14 11:12:36','2023-08-14 09:12:36','<!-- wp:heading -->\n<h2 class="wp-block-heading">Ce blog est consacré à l\'hydroponie et la bioponie domestiques. </h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Ces deux techniques de culture font partie de la famille des cultures hors-sol sur substrat neutre. Elles consistent à faire pousser des plantes sans terre, sur un substrat neutre (billes d\'argile par exemple), en mettant en place un dispositif efficace pour leur fournir les nutriments nécessaire pour assurer une croissance efficace des racines et des plantes. La recirculation du liquide nutritif évite la perte d\'eau dans la culture en sol. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Origine du projet et cheminement</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>J\'ai commencé à m\'intéresser aux questions de culture urbaines pendant l\'épidémie de COVID. Cet épisode anxiogène m\'a fait m\'interroger sur certaines questions d\'organisation de la société, et aux risques associés à l\'approvisionnement en ville des denrées alimentaires. En effet, il semble qu\'en cas de gros dysfonctionnement de la logistique d\'approvisionnement en nourriture, en quelque jours les villes pourraient se retrouver privées d\'une partie importante de leurs ressources alimentaires. Face à cette fragilité de l\'organisation de ces flux de transport, il semble intéressant de développer des dispositifs urbains assurant la production de légumes dans la ville. Des études sur ces sujets existent, mais je ne suis pas un spécialiste de la recherche en agriculture urbaine. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Définitions</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Le web pullule d\'explications sur ces techniques de culture. Vous pouvez trouver <a href="https://fermedecagnolle.fr/hydroponie-bioponie-aquaponie-definitions/">ici</a> par exemple des définitions de l\'<strong>hydroponie</strong>, <strong>bioponie</strong> et <strong>aquaponie</strong> proposées par Marion Sarlé (<a href="https://lessourciers.com/fr/">les sourciers</a>). </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Une fois ces grandes définitions comprises, on trouve de très facilement des informations sur les <strong><a href="https://jardinfute.com/culture-hors-sol/page/2/">nombreux types de dispositifs</a></strong> utilisés pour ce type de culture (ex : <a href="https://jardinfute.com/methode-kratky/">Kratky</a>, <a href="https://jardinfute.com/systeme-dwc-hydroponie/">DWC</a>, <a href="https://jardinfute.com/systeme-nft-hydroponie/">NFT</a>, <a href="https://jardinfute.com/table-a-maree-ebb-flow/">table à marée</a>, etc.). J\'ai choisi les explications sur le site <a href="https://jardinfute.com/">jardinfute.com</a>, mais vous trouverez facilement d\'autres systèmes et d\'autres explications sur internet.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Si l\'on évalue la complexité de ces techniques, on comprend que l\'<strong>hydroponie</strong> est la plus simple des trois, puisqu\'elle se base sur la circulation d\'une solution nutritive contenant des nutriments minéraux directement assimilables par les racines des plantes cultivées. En gros, il suffit de faire circuler de l\'eau additionnée d\'engrais sur les racines des plantes.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Quand on regarde les principes de la <strong>bioponie</strong> et l\'<strong>aquaponie</strong>, on comprend que le principe est plus complexe. Dans les deux cas on va transformer des éléments organiques en éléments minéraux (nitrates) pouvant être assimilés par les plantes. Cela est réalisé en deux étapes par l\'action de deux bactéries qui vont assurer tout d\'abord la transformation des éléments organiques en nitrites (bactéries <strong>Nitrosomonas</strong>) puis des nitrites en nitrates (bactéries <strong>Nitrobacter</strong>). Dans les deux cas, il faut offrir à ces bactéries un lieu et des conditions de vie, et finalement pour l\'aquaponie il faut s\'occuper aussi de ses poissons.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>J\'ai choisi de commencer par l\'hydroponie.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Prototypes</h2>\n<!-- /wp:heading -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading">Etape 1 : 2021-2022, un petit système hydroponique</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Durant l\'hiver 2021, j\'ai fait des recherches des différents systèmes hydroponiques disponibles et de comment réaliser sois même ce genre de choses, et j\'ai été convaincu de l\'idée de commencer petit, afin de pouvoir planter dès le printemps 2022. Les retours d\'expérience unanimes des personnes expérimentées sont qu\'il faut commencer simple et petit. L\'idée de commencer avec un petit système simple n\'a, à mon avis, que des avantages pour quelqu\'un qui aime un peu bricoler : </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>un petit prototype opérationnel est complet, donc on apprendra presque qu\'autant de choses que sur un plus gros système</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li></li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Le temps de développement est court, donc on a plus de chances d\'aboutir dans des délais imposés par ses propres activités quotidiennes d\'une part et l\'implacable chef d\'orchestre que sont les saisons d\'autre part. Par exemple, en France, il n\'est pas vraiment facile de planter des tomates à l\'automne, il faudra avoir été prêt pour le printemps, ou attendre le printemps suivant. </li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>On réduit le coût de fabrication, le risque financier et le temps passé si l\'on rate sa réalisation ou si on renonce avant la fin.</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:paragraph -->\n<p>J\'ai donc recherché les systèmes hydroponiques disponibles sur le marché ; j\'ai trouvé pas mal de systèmes clés en main, plus ou moins aboutis et plus ou moins chers. Pourtant, j\'ai décidé de construire moi-même mon premier système, pour plusieurs raisons :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Je suis convaincu que "mettre la main à la pâte" est souvent une bonne idée pour comprendre plus profondément un système technique</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>J\'aime bien réaliser des prototypes en adaptant une solution technique existante à mon besoin personnel, avant de réfléchir à une généralisation possible pour tous</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Début 2022, j\'étais très motivé par les principes de l\'aquaponie. La nature symbiotique poissons + plantes, la création d\'un écosystème économe et vertueux, la double production poissons + plantes sur une surface réduite m\'ont donné très envie d\'aller voir de plus près ce genre de systèmes. J\'ai bien sur beaucoup cherché sur internet, vu des réalisations magnifiques (par exemple la chaine de <a href="https://www.youtube.com/@ChrisPagns">Chris Pagns</a> sur youtube).</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Mes premiers ensignements</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Périmètre d\'expérimentation</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>On peut vouloir créer des fermes urbaines de taille plus ou moins importante, mais j\'ai décider de m\'intéresser à des dispositifs mis en œuvre à l\'échelle individuelle ou de proche voisinage, car cela représente des investissements réduits, une capacité de réalisation rapide et un investissement en temps acceptable. De plus, même si l\'ambition de tels systèmes n\'est pas de produire des bénéfices financiers, elle semble intéressante à l\'échelle de l\'individu ou du voisinage :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:quote -->\n<blockquote class="wp-block-quote"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Qualité des légumes</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>rendement élevé au m2</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Éloignement des ravageurs venant de la terre (limaces, etc.)</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Bénéfice éducatif venant de la compréhension de la culture des plantes (en particulier pour les citadins)</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Partage des productions et des savoir faire avec les voisins</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Pas besoin de terre</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Faible coût de développement et de mise en œuvre</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Très faible coût énergétique</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Très faible consommation d\'eau</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>etc.</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></blockquote>\n<!-- /wp:quote -->\n\n<!-- wp:paragraph -->\n<p>Taille du système</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Y sont présentées les activités de test et d\'apprentissage de ces techniques réalisées depuis le printemps 2022 à Saint-germain-en-Laye (78, Yvelines), Aix-en-Provence et Marseille (13, Bouches du Rhône). </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Au printemps 2022 J\'ai fabriqué et mis en service 4 systèmes modulaires hydroponiques (que l\'on pourrait les qualifier d\'aéro-hydroponiques). Ces systèmes avaient une forme de cylindre creux lequel étaient insérés des paniers contenant des billes d\'argile. En bas de la tour un réservoir de 10 à 20 litres dans lequel une pompe alimentait le haut de la tour par un tuyau, le liquide redescendant dans la tour en imprégnant les racines par gravité.</p>\n<!-- /wp:paragraph -->','Bienvenue','','inherit','closed','closed','','2-revision-v1','','','2023-08-14 11:12:36','2023-08-14 09:12:36','',2,'https://hs.vicq.org/?p=73',0,'revision','',0);
INSERT INTO `hs_posts` VALUES (74,1,'2023-08-14 11:35:12','2023-08-14 09:35:12','<!-- wp:heading -->\n<h2 class="wp-block-heading">Ce blog est consacré à l\'hydroponie et la bioponie domestiques. </h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Ces deux techniques de culture font partie de la famille des cultures hors-sol sur substrat neutre. Elles consistent à faire pousser des plantes sans terre, sur un substrat neutre (billes d\'argile par exemple), en mettant en place un dispositif efficace pour leur fournir les nutriments nécessaire pour assurer une croissance efficace des racines et des plantes. La recirculation du liquide nutritif évite la perte d\'eau dans la culture en sol. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Origine du projet et cheminement</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>J\'ai commencé à m\'intéresser aux questions de culture urbaines pendant l\'épidémie de COVID. Cet épisode anxiogène m\'a fait m\'interroger sur certaines questions d\'organisation de la société, et aux risques associés à l\'approvisionnement en ville des denrées alimentaires. En effet, il semble qu\'en cas de gros dysfonctionnement de la logistique d\'approvisionnement en nourriture, en quelque jours les villes pourraient se retrouver privées d\'une partie importante de leurs ressources alimentaires. Face à cette fragilité de l\'organisation de ces flux de transport, il semble intéressant de développer des dispositifs urbains assurant la production de légumes dans la ville. Des études sur ces sujets existent, mais je ne suis pas un spécialiste de la recherche en agriculture urbaine. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>De plus, les questions d\'épuisement de la planète sont maintenant au centre des débats, et la culture économe en eau et en énergie est un sujet intéressant pour les années à venir.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Culture hors sol, définitions</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Le web pullule d\'explications sur ces techniques de culture. Vous pouvez trouver <a href="https://fermedecagnolle.fr/hydroponie-bioponie-aquaponie-definitions/"><strong>ici</strong></a> par exemple des définitions simples de l\'<strong>hydroponie</strong>, <strong>bioponie</strong> et <strong>aquaponie</strong> proposées par Marion Sarlé (<a href="https://lessourciers.com/fr/">les sourciers</a>). Marion Sarlé propose aussi le livre « <em><strong>Monter sa microferme en hydroponie, bioponie et aquaponie</strong></em> », en vente sur le site <a href="https://lessourciers.com/fr/livre-sourciers/">Les Sourciers</a> . Les sourciers proposent aussi des <a href="https://lessourciers.com/fr/les-formations/">formations</a> en ligne et dans leur ferme du Gers. J\'ai suivi la partie en ligne de la formation <a href="https://lessourciers.com/fr/les-formations/microferme-hydroponique/">Microferme Hydroponique</a> qui m\'a bien aidé à comprendre les rudiments de base.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Une fois ces grandes définitions comprises, on trouve de très facilement des informations sur les <strong><a href="https://jardinfute.com/culture-hors-sol/page/2/">nombreux types de dispositifs</a></strong> utilisés pour ce type de culture (ex : <a href="https://jardinfute.com/methode-kratky/">Kratky</a>, <a href="https://jardinfute.com/systeme-dwc-hydroponie/">DWC</a>, <a href="https://jardinfute.com/systeme-nft-hydroponie/">NFT</a>, <a href="https://jardinfute.com/table-a-maree-ebb-flow/">table à marée</a>, etc.). J\'ai choisi les explications sur le site <a href="https://jardinfute.com/">jardinfute.com</a>, mais vous trouverez facilement d\'autres systèmes et d\'autres explications sur internet.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Si l\'on évalue la complexité de ces techniques, on comprend que l\'<strong>hydroponie</strong> est la plus simple des trois, puisqu\'elle se base sur la circulation d\'une solution nutritive contenant des nutriments minéraux directement assimilables par les racines des plantes cultivées. En gros, il suffit de faire circuler de l\'eau additionnée d\'engrais sur les racines des plantes.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Quand on regarde les principes de la <strong>bioponie</strong> et l\'<strong>aquaponie</strong>, on comprend que le principe est plus complexe. Dans les deux cas on va transformer des éléments organiques en éléments minéraux pouvant être assimilés par les plantes (minéralisation). Cela est réalisé en deux étapes par l\'action de deux bactéries qui vont assurer tout d\'abord la transformation des éléments organiques en nitrites (bactéries <strong>Nitrosomonas</strong>) puis des nitrites en nitrates (bactéries <strong>Nitrobacter</strong>). Dans les deux cas, il faut offrir à ces bactéries un lieu et des conditions de vie, et finalement pour l\'aquaponie il faut s\'occuper aussi de ses poissons, et en particulier gérer les caractéristiques de l\'eau.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Pour avoir les meilleurs chances ai choisi de commencer par l\'hydroponie.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Prototypes</h2>\n<!-- /wp:heading -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading">Etape 1 : 2021-2022, un petit système hydroponique</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Durant l\'hiver 2021, j\'ai fait des recherches des différents systèmes hydroponiques disponibles et de comment réaliser sois même ce genre de choses, et j\'ai été convaincu de l\'idée de commencer petit, afin de pouvoir planter dès le printemps 2022. Les retours d\'expérience unanimes des personnes expérimentées sont qu\'il faut commencer simple et petit. L\'idée de commencer avec un petit système simple n\'a, à mon avis, que des avantages pour quelqu\'un comme moi qui aime bricoler : </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>un petit prototype opérationnel est complet, donc on apprendra presque qu\'autant de choses que sur un plus gros système</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li></li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Le temps de développement est court, donc on a plus de chances d\'aboutir dans des délais imposés par ses propres activités quotidiennes d\'une part et l\'implacable chef d\'orchestre que sont les saisons d\'autre part. Par exemple, en France, il n\'est pas vraiment facile de planter des tomates à l\'automne, il faudra avoir été prêt pour le printemps, ou attendre le printemps suivant. </li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>On réduit le coût de fabrication, le risque financier et le temps passé si l\'on rate sa réalisation ou si on renonce avant la fin.</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:paragraph -->\n<p>J\'ai donc recherché les systèmes hydroponiques disponibles sur le marché ; j\'ai trouvé pas mal de systèmes clés en main, plus ou moins aboutis et plus ou moins chers. Pourtant, j\'ai décidé de construire moi-même mon premier système, pour plusieurs raisons :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Je suis convaincu que "mettre la main à la pâte" est souvent une bonne idée pour comprendre plus profondément un système technique</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>J\'aime bien réaliser des prototypes en adaptant une solution technique existante à mon besoin personnel, avant de réfléchir à une généralisation possible pour tous</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Début 2022, j\'étais très motivé par les principes de l\'aquaponie. La nature symbiotique poissons + plantes, la création d\'un écosystème économe et vertueux, la double production poissons + plantes sur une surface réduite m\'ont donné très envie d\'aller voir de plus près ce genre de systèmes. J\'ai bien sur beaucoup cherché sur internet, vu des réalisations magnifiques (par exemple la chaine de <a href="https://www.youtube.com/@ChrisPagns">Chris Pagns</a> sur youtube).</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Mes premiers ensignements</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Périmètre d\'expérimentation</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>On peut vouloir créer des fermes urbaines de taille plus ou moins importante, mais j\'ai décider de m\'intéresser à des dispositifs mis en œuvre à l\'échelle individuelle ou de proche voisinage, car cela représente des investissements réduits, une capacité de réalisation rapide et un investissement en temps acceptable. De plus, même si l\'ambition de tels systèmes n\'est pas de produire des bénéfices financiers, elle semble intéressante à l\'échelle de l\'individu ou du voisinage :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:quote -->\n<blockquote class="wp-block-quote"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Qualité des légumes</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>rendement élevé au m2</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Éloignement des ravageurs venant de la terre (limaces, etc.)</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Bénéfice éducatif venant de la compréhension de la culture des plantes (en particulier pour les citadins)</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Partage des productions et des savoir faire avec les voisins</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Pas besoin de terre</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Faible coût de développement et de mise en œuvre</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Très faible coût énergétique</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Très faible consommation d\'eau</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>etc.</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></blockquote>\n<!-- /wp:quote -->\n\n<!-- wp:paragraph -->\n<p>Taille du système</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Y sont présentées les activités de test et d\'apprentissage de ces techniques réalisées depuis le printemps 2022 à Saint-germain-en-Laye (78, Yvelines), Aix-en-Provence et Marseille (13, Bouches du Rhône). </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Au printemps 2022 J\'ai fabriqué et mis en service 4 systèmes modulaires hydroponiques (que l\'on pourrait les qualifier d\'aéro-hydroponiques). Ces systèmes avaient une forme de cylindre creux lequel étaient insérés des paniers contenant des billes d\'argile. En bas de la tour un réservoir de 10 à 20 litres dans lequel une pompe alimentait le haut de la tour par un tuyau, le liquide redescendant dans la tour en imprégnant les racines par gravité.</p>\n<!-- /wp:paragraph -->','Bienvenue','','inherit','closed','closed','','2-revision-v1','','','2023-08-14 11:35:12','2023-08-14 09:35:12','',2,'https://hs.vicq.org/?p=74',0,'revision','',0);
INSERT INTO `hs_posts` VALUES (75,1,'2023-08-14 11:40:31','2023-08-14 09:40:31','<!-- wp:heading -->\n<h2 class="wp-block-heading">Ce blog est consacré à l\'hydroponie et la bioponie domestiques. </h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Ces deux techniques de culture font partie de la famille des cultures hors-sol sur substrat neutre. Elles consistent à faire pousser des plantes sans terre, sur un substrat neutre (billes d\'argile par exemple), en mettant en place un dispositif efficace pour leur fournir les nutriments nécessaire pour assurer une croissance efficace des racines et des plantes. La recirculation du liquide nutritif évite la perte d\'eau dans la culture en sol. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Origine du projet et cheminement</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>J\'ai commencé à m\'intéresser aux questions de culture urbaines pendant l\'épidémie de COVID. Cet épisode anxiogène m\'a fait m\'interroger sur certaines questions d\'organisation de la société, et aux risques associés à l\'approvisionnement en ville des denrées alimentaires. En effet, il semble qu\'en cas de gros dysfonctionnement de la logistique d\'approvisionnement en nourriture, en quelque jours les villes pourraient se retrouver privées d\'une partie importante de leurs ressources alimentaires. Face à cette fragilité de l\'organisation de ces flux de transport, il semble intéressant de développer des dispositifs urbains assurant la production de légumes dans la ville. Des études sur ces sujets existent, mais je ne suis pas un spécialiste de la recherche en agriculture urbaine. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>De plus, les questions d\'épuisement de la planète sont maintenant au centre des débats, et la culture économe en eau et en énergie est un sujet intéressant pour les années à venir.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Culture hors sol, définitions</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Le web pullule d\'explications sur ces techniques de culture. Vous pouvez trouver <a href="https://fermedecagnolle.fr/hydroponie-bioponie-aquaponie-definitions/"><strong>ici</strong></a> par exemple des définitions simples de l\'<strong>hydroponie</strong>, <strong>bioponie</strong> et <strong>aquaponie</strong> proposées par Marion Sarlé (<a href="https://lessourciers.com/fr/">les sourciers</a>). Marion Sarlé propose aussi le livre « <em><strong>Monter sa microferme en hydroponie, bioponie et aquaponie</strong></em> », en vente sur le site <a href="https://lessourciers.com/fr/livre-sourciers/">Les Sourciers</a> . Les sourciers proposent aussi des <a href="https://lessourciers.com/fr/les-formations/">formations</a> en ligne et dans leur ferme du Gers. J\'ai suivi la partie en ligne de la formation <a href="https://lessourciers.com/fr/les-formations/microferme-hydroponique/">Microferme Hydroponique</a> qui m\'a bien aidé à comprendre les rudiments de base.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Une fois ces grandes définitions comprises, on trouve de très facilement des informations sur les <strong><a href="https://jardinfute.com/culture-hors-sol/page/2/">nombreux types de dispositifs</a></strong> utilisés pour ce type de culture (ex : <a href="https://jardinfute.com/methode-kratky/">Kratky</a>, <a href="https://jardinfute.com/systeme-dwc-hydroponie/">DWC</a>, <a href="https://jardinfute.com/systeme-nft-hydroponie/">NFT</a>, <a href="https://jardinfute.com/table-a-maree-ebb-flow/">table à marée</a>, etc.). J\'ai choisi les explications sur le site <a href="https://jardinfute.com/">jardinfute.com</a>, mais vous trouverez facilement d\'autres systèmes et d\'autres explications sur internet.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Si l\'on évalue la complexité de ces techniques, on comprend que l\'<strong>hydroponie</strong> est la plus simple des trois, puisqu\'elle se base sur la circulation d\'une solution nutritive contenant des nutriments minéraux directement assimilables par les racines des plantes cultivées. En gros, il suffit de faire circuler de l\'eau additionnée d\'engrais sur les racines des plantes.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Quand on regarde les principes de la <strong>bioponie</strong> et l\'<strong>aquaponie</strong>, on comprend que le principe est plus complexe. Dans les deux cas on va transformer des éléments organiques en éléments minéraux pouvant être assimilés par les plantes (minéralisation). Cela est réalisé en deux étapes par l\'action de deux bactéries qui vont assurer tout d\'abord la transformation des éléments organiques en nitrites (bactéries <strong>Nitrosomonas</strong>) puis des nitrites en nitrates (bactéries <strong>Nitrobacter</strong>). Dans les deux cas, il faut offrir à ces bactéries un lieu et des conditions de vie, et finalement pour l\'aquaponie il faut s\'occuper aussi de ses poissons, et en particulier gérer les caractéristiques de l\'eau.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Pour avoir les meilleurs chances ai choisi de commencer par l\'hydroponie.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Prototypes</h2>\n<!-- /wp:heading -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading">Etape 1 : 2021-2022, un petit système hydroponique</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Durant l\'hiver 2021, j\'ai fait des recherches des différents systèmes hydroponiques disponibles et de comment réaliser sois même ce genre de choses, et j\'ai été convaincu de l\'idée de commencer petit, afin de pouvoir planter dès le printemps 2022. Les retours d\'expérience unanimes des personnes expérimentées sont qu\'il faut commencer simple et petit. L\'idée de commencer avec un petit système simple n\'a, à mon avis, que des avantages pour quelqu\'un comme moi qui aime bricoler : </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Un petit prototype opérationnel est complet, donc on apprendra presque qu\'autant de choses que sur un plus gros système.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Le temps de développement est plus court, on aura ainsi plus de chances d\'aboutir dans des délais imposés par ses propres contraintes quotidiennes et l\'implacable chef d\'orchestre que sont les saisons. Par exemple, en France, il n\'est pas vraiment facile de planter des tomates à l\'automne, il faudra avoir été prêt pour le printemps, ou attendre le printemps suivant. </li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>On réduit le coût de fabrication, le risque financier et le temps passé si l\'on rate sa réalisation ou si on renonce avant la fin.</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:paragraph -->\n<p>J\'ai donc recherché les systèmes hydroponiques disponibles sur le marché ; j\'ai trouvé pas mal de systèmes clés en main, plus ou moins aboutis et plus ou moins chers. Pourtant, j\'ai décidé de construire moi-même mon premier système, pour plusieurs raisons :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Je suis convaincu que "mettre la main à la pâte" est souvent une bonne idée pour comprendre plus profondément un système technique,</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>j\'aime bien réaliser des prototypes en adaptant une solution technique existante à mon besoin personnel, cela m\'aide à  réfléchir à une généralisation possible les autres.</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Début 2022, j\'étais très motivé par les principes de l\'aquaponie. La nature symbiotique poissons + plantes, la création d\'un écosystème économe et vertueux, la double production poissons + plantes sur une surface réduite m\'ont donné très envie d\'aller voir de plus près ce genre de systèmes. J\'ai bien sur beaucoup cherché sur internet, vu des réalisations magnifiques (par exemple la chaine de <a href="https://www.youtube.com/@ChrisPagns">Chris Pagns</a> sur youtube).</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Mes premiers ensignements</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Périmètre d\'expérimentation</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>On peut vouloir créer des fermes urbaines de taille plus ou moins importante, mais j\'ai décider de m\'intéresser à des dispositifs mis en œuvre à l\'échelle individuelle ou de proche voisinage, car cela représente des investissements réduits, une capacité de réalisation rapide et un investissement en temps acceptable. De plus, même si l\'ambition de tels systèmes n\'est pas de produire des bénéfices financiers, elle semble intéressante à l\'échelle de l\'individu ou du voisinage :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:quote -->\n<blockquote class="wp-block-quote"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Qualité des légumes</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>rendement élevé au m2</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Éloignement des ravageurs venant de la terre (limaces, etc.)</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Bénéfice éducatif venant de la compréhension de la culture des plantes (en particulier pour les citadins)</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Partage des productions et des savoir faire avec les voisins</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Pas besoin de terre</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Faible coût de développement et de mise en œuvre</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Très faible coût énergétique</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Très faible consommation d\'eau</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>etc.</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></blockquote>\n<!-- /wp:quote -->\n\n<!-- wp:paragraph -->\n<p>Taille du système</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Y sont présentées les activités de test et d\'apprentissage de ces techniques réalisées depuis le printemps 2022 à Saint-germain-en-Laye (78, Yvelines), Aix-en-Provence et Marseille (13, Bouches du Rhône). </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Au printemps 2022 J\'ai fabriqué et mis en service 4 systèmes modulaires hydroponiques (que l\'on pourrait les qualifier d\'aéro-hydroponiques). Ces systèmes avaient une forme de cylindre creux lequel étaient insérés des paniers contenant des billes d\'argile. En bas de la tour un réservoir de 10 à 20 litres dans lequel une pompe alimentait le haut de la tour par un tuyau, le liquide redescendant dans la tour en imprégnant les racines par gravité.</p>\n<!-- /wp:paragraph -->','Bienvenue','','inherit','closed','closed','','2-revision-v1','','','2023-08-14 11:40:31','2023-08-14 09:40:31','',2,'https://hs.vicq.org/?p=75',0,'revision','',0);
INSERT INTO `hs_posts` VALUES (76,1,'2023-08-14 13:20:13','2023-08-14 11:20:13','<!-- wp:heading -->\n<h2 class="wp-block-heading">Ce blog est consacré à l\'hydroponie et la bioponie domestiques. </h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Ces deux techniques de culture font partie de la famille des cultures hors-sol sur substrat neutre. Elles consistent à faire pousser des plantes sans terre, sur un substrat neutre (billes d\'argile par exemple), en mettant en place un dispositif efficace pour leur fournir les nutriments nécessaire pour assurer une croissance efficace des racines et des plantes. La recirculation du liquide nutritif évite la perte d\'eau dans la culture en sol. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Origine du projet et cheminement</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>J\'ai commencé à m\'intéresser aux questions de culture urbaines pendant l\'épidémie de COVID. Cet épisode anxiogène m\'a fait m\'interroger sur certaines questions d\'organisation de la société, et aux risques associés à l\'approvisionnement en ville des denrées alimentaires. En effet, il semble qu\'en cas de gros dysfonctionnement de la logistique d\'approvisionnement en nourriture, en quelque jours les villes pourraient se retrouver privées d\'une partie importante de leurs ressources alimentaires. Face à cette fragilité de l\'organisation de ces flux de transport, il semble intéressant de développer des dispositifs urbains assurant la production de légumes dans la ville. Des études sur ces sujets existent, mais je ne suis pas un spécialiste de la recherche en agriculture urbaine. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>De plus, les questions d\'épuisement de la planète sont maintenant au centre des débats, et la culture économe en eau et en énergie est un sujet intéressant pour les années à venir.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Culture hors sol, définitions</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Le web pullule d\'explications sur ces techniques de culture. Vous pouvez trouver <a href="https://fermedecagnolle.fr/hydroponie-bioponie-aquaponie-definitions/"><strong>ici</strong></a> par exemple des définitions simples de l\'<strong>hydroponie</strong>, <strong>bioponie</strong> et <strong>aquaponie</strong> proposées par Marion Sarlé (<a href="https://lessourciers.com/fr/">les sourciers</a>). Marion Sarlé propose aussi le livre « <em><strong>Monter sa microferme en hydroponie, bioponie et aquaponie</strong></em> », en vente sur le site <a href="https://lessourciers.com/fr/livre-sourciers/">Les Sourciers</a> . Les sourciers proposent aussi des <a href="https://lessourciers.com/fr/les-formations/">formations</a> en ligne et dans leur ferme du Gers. J\'ai suivi la partie en ligne de la formation <a href="https://lessourciers.com/fr/les-formations/microferme-hydroponique/">Microferme Hydroponique</a> qui m\'a bien aidé à comprendre les rudiments de base.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Une fois ces grandes définitions comprises, on trouve de très facilement des informations sur les <strong><a href="https://jardinfute.com/culture-hors-sol/page/2/">nombreux types de dispositifs</a></strong> utilisés pour ce type de culture (ex : <a href="https://jardinfute.com/methode-kratky/">Kratky</a>, <a href="https://jardinfute.com/systeme-dwc-hydroponie/">DWC</a>, <a href="https://jardinfute.com/systeme-nft-hydroponie/">NFT</a>, <a href="https://jardinfute.com/table-a-maree-ebb-flow/">table à marée</a>, etc.). J\'ai choisi les explications sur le site <a href="https://jardinfute.com/">jardinfute.com</a>, mais vous trouverez facilement d\'autres systèmes et d\'autres explications sur internet.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Si l\'on évalue la complexité de ces techniques, on comprend que l\'<strong>hydroponie</strong> est la plus simple des trois, puisqu\'elle se base sur la circulation d\'une solution nutritive contenant des nutriments minéraux directement assimilables par les racines des plantes cultivées. En gros, il suffit de faire circuler de l\'eau additionnée d\'engrais sur les racines des plantes.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Quand on regarde les principes de la <strong>bioponie</strong> et l\'<strong>aquaponie</strong>, on comprend que le principe est plus complexe. Dans les deux cas on va transformer des éléments organiques en éléments minéraux pouvant être assimilés par les plantes (minéralisation). Cela est réalisé en deux étapes par l\'action de deux bactéries qui vont assurer tout d\'abord la transformation des éléments organiques en nitrites (bactéries <strong>Nitrosomonas</strong>) puis des nitrites en nitrates (bactéries <strong>Nitrobacter</strong>). Dans les deux cas, il faut offrir à ces bactéries un lieu et des conditions de vie, et finalement pour l\'aquaponie il faut s\'occuper aussi de ses poissons, et en particulier gérer les caractéristiques de l\'eau.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Pour avoir les meilleurs chances ai choisi de commencer par l\'hydroponie.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Prototypes</h2>\n<!-- /wp:heading -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading">Etape 1 : 2021-2022, un petit système hydroponique</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Durant l\'hiver 2021, j\'ai fait des recherches des différents systèmes hydroponiques disponibles et de comment réaliser sois même ce genre de choses, et j\'ai été convaincu de l\'idée de commencer petit, afin de pouvoir planter dès le printemps 2022. Les retours d\'expérience unanimes des personnes expérimentées sont qu\'il faut commencer simple et petit. L\'idée de commencer avec un petit système simple n\'a, à mon avis, que des avantages pour quelqu\'un comme moi qui aime bricoler : </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Un petit prototype opérationnel est complet, donc on apprendra presque qu\'autant de choses que sur un plus gros système.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Le temps de développement est plus court, on aura ainsi plus de chances d\'aboutir dans des délais imposés par ses propres contraintes quotidiennes et l\'implacable chef d\'orchestre que sont les saisons. Par exemple, en France, il n\'est pas vraiment facile de planter des tomates à l\'automne, il faudra avoir été prêt pour le printemps, ou attendre le printemps suivant. </li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>On réduit le coût de fabrication, le risque financier et le temps passé si l\'on rate sa réalisation ou si on renonce avant la fin.</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:paragraph -->\n<p>J\'ai donc recherché les systèmes hydroponiques disponibles sur le marché ; j\'ai trouvé pas mal de systèmes clés en main, plus ou moins aboutis et plus ou moins chers. Pourtant, j\'ai décidé de construire moi-même mon premier système, pour plusieurs raisons :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Je suis convaincu que "mettre la main à la pâte" est souvent une bonne idée pour comprendre plus profondément un système technique,</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>j\'aime bien réaliser des prototypes en adaptant une solution technique existante à mon besoin personnel, cela m\'aide à  réfléchir à une généralisation possible les autres.</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading">Un mini-système hydroponique</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Durant l\'hiver 2021, j\'ai choisi de réaliser un système hydroponique vertical. Etant compétent en impression 3D, j\'ai décider de partir d\'un système déjà conçu, et de l\'adapter un peu.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>voici à quoi ce système ressemblait dans sa <a href="https://www.thingiverse.com/thing:3405964/">version originale</a> : </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:columns -->\n<div class="wp-block-columns"><!-- wp:column -->\n<div class="wp-block-column"><!-- wp:image {"width":535,"height":402,"sizeSlug":"large"} -->\n<figure class="wp-block-image size-large is-resized"><img src="https://cdn.thingiverse.com/renders/33/b6/37/85/85/59b0c38e5b805c7dd9b9f5abeee79ca0_preview_featured.jpg" alt="" style="width:535px;height:402px" width="535" height="402"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class="wp-block-column"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>La colonne creuse est composée de modules, ce qui permet de choisir le nombre de plantes</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>le réservoir en bas contient une pompe, cette dernière remonte l\'eau via un tuyau au centre de la tour jusqu\'à l\'étage supérieur qui et lui même percé de trous...</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>l\'eau passe par ces trous et redescend par gravité jusqu\'au réservoir, en arrosant au passage les racines des plantes maintenues en position dans des billes d\'argile dans les paniers amovibles (couleur ocre) installés dans la tour</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:paragraph -->\n<p>J\'ai du adapter le système de de fixation entre le bas de la tour et mon réservoirs, ainsi que certaines modifications mineures.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Le détail et les photos sont disponibles ici</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Les résultats étaient intéressants, j\'ai beaucoup appris de ce système. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p> </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Début 2022, j\'étais très motivé par les principes de l\'aquaponie. La nature symbiotique poissons + plantes, la création d\'un écosystème économe et vertueux, la double production poissons + plantes sur une surface réduite m\'ont donné très envie d\'aller voir de plus près ce genre de systèmes. J\'ai bien sur beaucoup cherché sur internet, vu des réalisations magnifiques (par exemple la chaine de <a href="https://www.youtube.com/@ChrisPagns">Chris Pagns</a> sur youtube).</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Mes premiers ensignements</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Périmètre d\'expérimentation</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>On peut vouloir créer des fermes urbaines de taille plus ou moins importante, mais j\'ai décider de m\'intéresser à des dispositifs mis en œuvre à l\'échelle individuelle ou de proche voisinage, car cela représente des investissements réduits, une capacité de réalisation rapide et un investissement en temps acceptable. De plus, même si l\'ambition de tels systèmes n\'est pas de produire des bénéfices financiers, elle semble intéressante à l\'échelle de l\'individu ou du voisinage :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:quote -->\n<blockquote class="wp-block-quote"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Qualité des légumes</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>rendement élevé au m2</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Éloignement des ravageurs venant de la terre (limaces, etc.)</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Bénéfice éducatif venant de la compréhension de la culture des plantes (en particulier pour les citadins)</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Partage des productions et des savoir faire avec les voisins</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Pas besoin de terre</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Faible coût de développement et de mise en œuvre</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Très faible coût énergétique</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Très faible consommation d\'eau</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>etc.</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></blockquote>\n<!-- /wp:quote -->\n\n<!-- wp:paragraph -->\n<p>Taille du système</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Y sont présentées les activités de test et d\'apprentissage de ces techniques réalisées depuis le printemps 2022 à Saint-germain-en-Laye (78, Yvelines), Aix-en-Provence et Marseille (13, Bouches du Rhône). </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Au printemps 2022 J\'ai fabriqué et mis en service 4 systèmes modulaires hydroponiques (que l\'on pourrait les qualifier d\'aéro-hydroponiques). Ces systèmes avaient une forme de cylindre creux lequel étaient insérés des paniers contenant des billes d\'argile. En bas de la tour un réservoir de 10 à 20 litres dans lequel une pompe alimentait le haut de la tour par un tuyau, le liquide redescendant dans la tour en imprégnant les racines par gravité.</p>\n<!-- /wp:paragraph -->','Bienvenue','','inherit','closed','closed','','2-revision-v1','','','2023-08-14 13:20:13','2023-08-14 11:20:13','',2,'https://hs.vicq.org/?p=76',0,'revision','',0);
INSERT INTO `hs_posts` VALUES (77,1,'2023-08-14 13:25:38','2023-08-14 11:25:38','<!-- wp:heading -->\n<h2 class="wp-block-heading">Ce blog est consacré à l\'hydroponie et la bioponie domestiques. </h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Ces deux techniques de culture font partie de la famille des cultures hors-sol sur substrat neutre. Elles consistent à faire pousser des plantes sans terre, sur un substrat neutre (billes d\'argile par exemple), en mettant en place un dispositif efficace pour leur fournir les nutriments nécessaire pour assurer une croissance efficace des racines et des plantes. La recirculation du liquide nutritif évite la perte d\'eau dans la culture en sol. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Origine du projet et cheminement</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>J\'ai commencé à m\'intéresser aux questions de culture urbaines pendant l\'épidémie de COVID. Cet épisode anxiogène m\'a fait m\'interroger sur certaines questions d\'organisation de la société, et aux risques associés à l\'approvisionnement en ville des denrées alimentaires. En effet, il semble qu\'en cas de gros dysfonctionnement de la logistique d\'approvisionnement en nourriture, en quelque jours les villes pourraient se retrouver privées d\'une partie importante de leurs ressources alimentaires. Face à cette fragilité de l\'organisation de ces flux de transport, il semble intéressant de développer des dispositifs urbains assurant la production de légumes dans la ville. Des études sur ces sujets existent, mais je ne suis pas un spécialiste de la recherche en agriculture urbaine. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>De plus, les questions d\'épuisement de la planète sont maintenant au centre des débats, et la culture économe en eau et en énergie est un sujet intéressant pour les années à venir.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Culture hors sol, définitions</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Le web pullule d\'explications sur ces techniques de culture. Vous pouvez trouver <a href="https://fermedecagnolle.fr/hydroponie-bioponie-aquaponie-definitions/"><strong>ici</strong></a> par exemple des définitions simples de l\'<strong>hydroponie</strong>, <strong>bioponie</strong> et <strong>aquaponie</strong> proposées par Marion Sarlé (<a href="https://lessourciers.com/fr/">les sourciers</a>). Marion Sarlé propose aussi le livre « <em><strong>Monter sa microferme en hydroponie, bioponie et aquaponie</strong></em> », en vente sur le site <a href="https://lessourciers.com/fr/livre-sourciers/">Les Sourciers</a> . Les sourciers proposent aussi des <a href="https://lessourciers.com/fr/les-formations/">formations</a> en ligne et dans leur ferme du Gers. J\'ai suivi la partie en ligne de la formation <a href="https://lessourciers.com/fr/les-formations/microferme-hydroponique/">Microferme Hydroponique</a> qui m\'a bien aidé à comprendre les rudiments de base.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Une fois ces grandes définitions comprises, on trouve de très facilement des informations sur les <strong><a href="https://jardinfute.com/culture-hors-sol/page/2/">nombreux types de dispositifs</a></strong> utilisés pour ce type de culture (ex : <a href="https://jardinfute.com/methode-kratky/">Kratky</a>, <a href="https://jardinfute.com/systeme-dwc-hydroponie/">DWC</a>, <a href="https://jardinfute.com/systeme-nft-hydroponie/">NFT</a>, <a href="https://jardinfute.com/table-a-maree-ebb-flow/">table à marée</a>, etc.). J\'ai choisi les explications sur le site <a href="https://jardinfute.com/">jardinfute.com</a>, mais vous trouverez facilement d\'autres systèmes et d\'autres explications sur internet.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Si l\'on évalue la complexité de ces techniques, on comprend que l\'<strong>hydroponie</strong> est la plus simple des trois, puisqu\'elle se base sur la circulation d\'une solution nutritive contenant des nutriments minéraux directement assimilables par les racines des plantes cultivées. En gros, il suffit de faire circuler de l\'eau additionnée d\'engrais sur les racines des plantes.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Quand on regarde les principes de la <strong>bioponie</strong> et l\'<strong>aquaponie</strong>, on comprend que le principe est plus complexe. Dans les deux cas on va transformer des éléments organiques en éléments minéraux pouvant être assimilés par les plantes (minéralisation). Cela est réalisé en deux étapes par l\'action de deux bactéries qui vont assurer tout d\'abord la transformation des éléments organiques en nitrites (bactéries <strong>Nitrosomonas</strong>) puis des nitrites en nitrates (bactéries <strong>Nitrobacter</strong>). Dans les deux cas, il faut offrir à ces bactéries un lieu et des conditions de vie, et finalement pour l\'aquaponie il faut s\'occuper aussi de ses poissons, et en particulier gérer les caractéristiques de l\'eau.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Pour avoir les meilleurs chances ai choisi de commencer par l\'hydroponie.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Prototypes</h2>\n<!-- /wp:heading -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading">Etape 1 : 2021-2022, un petit système hydroponique</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Durant l\'hiver 2021, j\'ai fait des recherches des différents systèmes hydroponiques disponibles et de comment réaliser sois même ce genre de choses, et j\'ai été convaincu de l\'idée de commencer petit, afin de pouvoir planter dès le printemps 2022. Les retours d\'expérience unanimes des personnes expérimentées sont qu\'il faut commencer simple et petit. L\'idée de commencer avec un petit système simple n\'a, à mon avis, que des avantages pour quelqu\'un comme moi qui aime bricoler : </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Un petit prototype opérationnel est complet, donc on apprendra presque qu\'autant de choses que sur un plus gros système.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Le temps de développement est plus court, on aura ainsi plus de chances d\'aboutir dans des délais imposés par ses propres contraintes quotidiennes et l\'implacable chef d\'orchestre que sont les saisons. Par exemple, en France, il n\'est pas vraiment facile de planter des tomates à l\'automne, il faudra avoir été prêt pour le printemps, ou attendre le printemps suivant. </li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>On réduit le coût de fabrication, le risque financier et le temps passé si l\'on rate sa réalisation ou si on renonce avant la fin.</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:paragraph -->\n<p>J\'ai donc recherché les systèmes hydroponiques disponibles sur le marché ; j\'ai trouvé pas mal de systèmes clés en main, plus ou moins aboutis et plus ou moins chers. Pourtant, j\'ai décidé de construire moi-même mon premier système, pour plusieurs raisons :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Je suis convaincu que "mettre la main à la pâte" est souvent une bonne idée pour comprendre plus profondément un système technique,</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>j\'aime bien réaliser des prototypes en adaptant une solution technique existante à mon besoin personnel, cela m\'aide à  réfléchir à une généralisation possible les autres.</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading">Un mini-système hydroponique</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Durant l\'hiver 2021, j\'ai choisi de réaliser un système hydroponique vertical. Etant compétent en impression 3D, j\'ai décider de partir d\'un système déjà conçu, et de l\'adapter un peu.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>voici à quoi ce système ressemblait dans sa <a href="https://www.thingiverse.com/thing:3405964/">version originale</a> : </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:columns -->\n<div class="wp-block-columns"><!-- wp:column -->\n<div class="wp-block-column"><!-- wp:image {"width":535,"height":402,"sizeSlug":"large"} -->\n<figure class="wp-block-image size-large is-resized"><img src="https://cdn.thingiverse.com/renders/33/b6/37/85/85/59b0c38e5b805c7dd9b9f5abeee79ca0_preview_featured.jpg" alt="" style="width:535px;height:402px" width="535" height="402"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class="wp-block-column"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>La colonne est creuse est composée de modules empilables, ce qui permet de choisir le nombre de plantes</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>le réservoir en bas contient une pompe, cette dernière remonte l\'eau via un tuyau au centre de la tour jusqu\'à l\'étage supérieur qui et lui même percé de trous...</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>l\'eau passe par ces trous et redescend par gravité jusqu\'au réservoir, en arrosant au passage les racines des plantes maintenues en position dans des billes d\'argile dans les paniers amovibles (couleur ocre) installés dans la tour</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:paragraph -->\n<p>J\'ai du adapter le système de de fixation entre le bas de la tour et mon réservoirs, ainsi que certaines modifications mineures.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Le détail et les photos sont disponibles ici</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Les résultats étaient intéressants, j\'ai beaucoup appris de ce système. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p> </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Début 2022, j\'étais très motivé par les principes de l\'aquaponie. La nature symbiotique poissons + plantes, la création d\'un écosystème économe et vertueux, la double production poissons + plantes sur une surface réduite m\'ont donné très envie d\'aller voir de plus près ce genre de systèmes. J\'ai bien sur beaucoup cherché sur internet, vu des réalisations magnifiques (par exemple la chaine de <a href="https://www.youtube.com/@ChrisPagns">Chris Pagns</a> sur youtube).</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Mes premiers ensignements</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Périmètre d\'expérimentation</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>On peut vouloir créer des fermes urbaines de taille plus ou moins importante, mais j\'ai décider de m\'intéresser à des dispositifs mis en œuvre à l\'échelle individuelle ou de proche voisinage, car cela représente des investissements réduits, une capacité de réalisation rapide et un investissement en temps acceptable. De plus, même si l\'ambition de tels systèmes n\'est pas de produire des bénéfices financiers, elle semble intéressante à l\'échelle de l\'individu ou du voisinage :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:quote -->\n<blockquote class="wp-block-quote"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Qualité des légumes</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>rendement élevé au m2</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Éloignement des ravageurs venant de la terre (limaces, etc.)</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Bénéfice éducatif venant de la compréhension de la culture des plantes (en particulier pour les citadins)</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Partage des productions et des savoir faire avec les voisins</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Pas besoin de terre</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Faible coût de développement et de mise en œuvre</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Très faible coût énergétique</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Très faible consommation d\'eau</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>etc.</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></blockquote>\n<!-- /wp:quote -->\n\n<!-- wp:paragraph -->\n<p>Taille du système</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Y sont présentées les activités de test et d\'apprentissage de ces techniques réalisées depuis le printemps 2022 à Saint-germain-en-Laye (78, Yvelines), Aix-en-Provence et Marseille (13, Bouches du Rhône). </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Au printemps 2022 J\'ai fabriqué et mis en service 4 systèmes modulaires hydroponiques (que l\'on pourrait les qualifier d\'aéro-hydroponiques). Ces systèmes avaient une forme de cylindre creux lequel étaient insérés des paniers contenant des billes d\'argile. En bas de la tour un réservoir de 10 à 20 litres dans lequel une pompe alimentait le haut de la tour par un tuyau, le liquide redescendant dans la tour en imprégnant les racines par gravité.</p>\n<!-- /wp:paragraph -->','Bienvenue','','inherit','closed','closed','','2-revision-v1','','','2023-08-14 13:25:38','2023-08-14 11:25:38','',2,'https://hs.vicq.org/?p=77',0,'revision','',0);
INSERT INTO `hs_posts` VALUES (78,1,'2023-08-14 16:56:48','2023-08-14 14:56:48','<!-- wp:heading -->\n<h2 class="wp-block-heading">Ce blog est consacré à l\'hydroponie et la bioponie domestiques. </h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Ces deux techniques de culture font partie de la famille des cultures hors-sol sur substrat neutre. Elles consistent à faire pousser des plantes sans terre, sur un substrat neutre (billes d\'argile par exemple), en mettant en place un dispositif efficace pour leur fournir les nutriments nécessaire pour assurer une croissance efficace des racines et des plantes. La recirculation du liquide nutritif évite la perte d\'eau dans la culture en sol. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Origine du projet et cheminement</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>J\'ai commencé à m\'intéresser aux questions de culture urbaines pendant l\'épidémie de COVID. Cet épisode anxiogène m\'a fait m\'interroger sur certaines questions d\'organisation de la société, et aux risques associés à l\'approvisionnement en ville des denrées alimentaires. En effet, il semble qu\'en cas de gros dysfonctionnement de la logistique d\'approvisionnement en nourriture, en quelque jours les villes pourraient se retrouver privées d\'une partie importante de leurs ressources alimentaires. Face à cette fragilité de l\'organisation de ces flux de transport, il semble intéressant de développer des dispositifs urbains assurant la production de légumes dans la ville. Des études sur ces sujets existent, mais je ne suis pas un spécialiste de la recherche en agriculture urbaine. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>De plus, les questions d\'épuisement de la planète sont maintenant au centre des débats, et la culture économe en eau et en énergie est un sujet intéressant pour les années à venir.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Culture hors sol, définitions</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Le web pullule d\'explications sur ces techniques de culture. Vous pouvez trouver <a href="https://fermedecagnolle.fr/hydroponie-bioponie-aquaponie-definitions/"><strong>ici</strong></a> par exemple des définitions simples de l\'<strong>hydroponie</strong>, <strong>bioponie</strong> et <strong>aquaponie</strong> proposées par Marion Sarlé (<a href="https://lessourciers.com/fr/">les sourciers</a>). Marion Sarlé propose aussi le livre «&nbsp;<em><strong>Monter sa microferme en hydroponie, bioponie et aquaponie</strong></em>&nbsp;», en vente sur le site <a href="https://lessourciers.com/fr/livre-sourciers/">Les Sourciers</a>&nbsp;. Les sourciers proposent aussi des <a href="https://lessourciers.com/fr/les-formations/">formations</a> en ligne et dans leur ferme du Gers. J\'ai suivi la partie en ligne de la formation <a href="https://lessourciers.com/fr/les-formations/microferme-hydroponique/">Microferme Hydroponique</a> qui m\'a bien aidé à comprendre les rudiments de base.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Une fois ces grandes définitions comprises, on trouve de très facilement des informations sur les <strong><a href="https://jardinfute.com/culture-hors-sol/page/2/">nombreux types de dispositifs</a></strong> utilisés pour ce type de culture (ex : <a href="https://jardinfute.com/methode-kratky/">Kratky</a>, <a href="https://jardinfute.com/systeme-dwc-hydroponie/">DWC</a>, <a href="https://jardinfute.com/systeme-nft-hydroponie/">NFT</a>, <a href="https://jardinfute.com/table-a-maree-ebb-flow/">table à marée</a>, etc.). J\'ai choisi les explications sur le site <a href="https://jardinfute.com/">jardinfute.com</a>, mais vous trouverez facilement d\'autres systèmes et d\'autres explications sur internet.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Si l\'on évalue la complexité de ces techniques, on comprend que l\'<strong>hydroponie</strong> est la plus simple des trois, puisqu\'elle se base sur la circulation d\'une solution nutritive contenant des nutriments minéraux directement assimilables par les racines des plantes cultivées. En gros, il suffit de faire circuler de l\'eau additionnée d\'engrais sur les racines des plantes.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Quand on regarde les principes de la <strong>bioponie</strong> et l\'<strong>aquaponie</strong>, on comprend que le principe est plus complexe. Dans les deux cas on va transformer des éléments organiques en éléments minéraux pouvant être assimilés par les plantes (minéralisation). Cela est réalisé en deux étapes par l\'action de deux bactéries qui vont assurer tout d\'abord la transformation des éléments organiques en nitrites (bactéries <strong>Nitrosomonas</strong>) puis des nitrites en nitrates (bactéries <strong>Nitrobacter</strong>). Dans les deux cas, il faut offrir à ces bactéries un lieu et des conditions de vie, et finalement pour l\'aquaponie il faut s\'occuper aussi de ses poissons, et en particulier gérer les caractéristiques de l\'eau.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Pour avoir les meilleurs chances ai choisi de commencer par l\'hydroponie.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Prototypes</h2>\n<!-- /wp:heading -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading">Etape 1 : 2021-2022, un petit système hydroponique</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Durant l\'hiver 2021, j\'ai fait des recherches des différents systèmes hydroponiques disponibles et de comment réaliser sois même ce genre de choses, et j\'ai été convaincu de l\'idée de commencer petit, afin de pouvoir planter dès le printemps 2022. Les retours d\'expérience unanimes des personnes expérimentées sont qu\'il faut commencer simple et petit. L\'idée de commencer avec un petit système simple n\'a, à mon avis, que des avantages pour quelqu\'un comme moi qui aime bricoler : </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Un petit prototype opérationnel est complet, donc on apprendra presque qu\'autant de choses que sur un plus gros système.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Le temps de développement est plus court, on aura ainsi plus de chances d\'aboutir dans des délais imposés par ses propres contraintes quotidiennes et l\'implacable chef d\'orchestre que sont les saisons. Par exemple, en France, il n\'est pas vraiment facile de planter des tomates à l\'automne, il faudra avoir été prêt pour le printemps, ou attendre le printemps suivant. </li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>On réduit le coût de fabrication, le risque financier et le temps passé si l\'on rate sa réalisation ou si on renonce avant la fin.</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:paragraph -->\n<p>J\'ai donc recherché les systèmes hydroponiques disponibles sur le marché ; j\'ai trouvé pas mal de systèmes clés en main, plus ou moins aboutis et plus ou moins chers. Pourtant, j\'ai décidé de construire moi-même mon premier système, pour plusieurs raisons :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Je suis convaincu que "mettre la main à la pâte" est souvent une bonne idée pour comprendre plus profondément un système technique,</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>j\'aime bien réaliser des prototypes en adaptant une solution technique existante à mon besoin personnel, cela m\'aide à  réfléchir à une généralisation possible les autres.</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading">Un mini-système hydroponique</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Durant l\'hiver 2021, j\'ai choisi de réaliser un système hydroponique vertical. Etant compétent en impression 3D, j\'ai décider de partir d\'un système déjà conçu, et de l\'adapter un peu.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>voici à quoi ce système ressemblait dans sa <a href="https://www.thingiverse.com/thing:3405964/">version originale</a> : </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:columns -->\n<div class="wp-block-columns"><!-- wp:column -->\n<div class="wp-block-column"><!-- wp:image {"width":535,"height":402,"sizeSlug":"large"} -->\n<figure class="wp-block-image size-large is-resized"><img src="https://cdn.thingiverse.com/renders/33/b6/37/85/85/59b0c38e5b805c7dd9b9f5abeee79ca0_preview_featured.jpg" alt="" style="width:535px;height:402px" width="535" height="402"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class="wp-block-column"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>La colonne est creuse est composée de modules empilables, ce qui permet de choisir le nombre de plantes</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>le réservoir en bas contient une pompe, cette dernière remonte l\'eau via un tuyau au centre de la tour jusqu\'à l\'étage supérieur qui et lui même percé de trous...</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>l\'eau passe par ces trous et redescend par gravité jusqu\'au réservoir, en arrosant au passage les racines des plantes maintenues en position dans des billes d\'argile dans les paniers amovibles (couleur ocre) installés dans la tour</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:paragraph -->\n<p>J\'ai du adapter le système de de fixation entre le bas de la tour et mon réservoirs, ainsi que certaines modifications mineures.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Au printemps 2022 J\'ai fabriqué et mis en service 4 systèmes modulaires hydroponiques (que l\'on pourrait les qualifier d\'aéro-hydroponiques). Ces systèmes avaient une forme de cylindre creux lequel étaient insérés des paniers contenant des billes d\'argile. En bas de la tour un réservoir de 10 à 20 litres dans lequel une pompe alimentait le haut de la tour par un tuyau, le liquide redescendant dans la tour en imprégnant les racines par gravité.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Le détail et les photos sont disponibles ici</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Les résultats étaient intéressants, j\'ai beaucoup appris de ce système. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p> </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Début 2022, j\'étais très motivé par les principes de l\'aquaponie. La nature symbiotique poissons + plantes, la création d\'un écosystème économe et vertueux, la double production poissons + plantes sur une surface réduite m\'ont donné très envie d\'aller voir de plus près ce genre de systèmes. J\'ai bien sur beaucoup cherché sur internet, vu des réalisations magnifiques (par exemple la chaine de <a href="https://www.youtube.com/@ChrisPagns">Chris Pagns</a> sur youtube).</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Taille du dispositif</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>On peut vouloir créer des fermes urbaines de taille plus ou moins importante, mais j\'ai décider de m\'intéresser à des dispositifs mis en œuvre à l\'échelle individuelle ou de proche voisinage, car cela représente des investissements réduits, une capacité de réalisation rapide et un investissement en temps acceptable. De plus, même si l\'ambition de tels systèmes n\'est pas de produire des bénéfices financiers, elle semble intéressante à l\'échelle de l\'individu ou du voisinage.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Bénéfices du système</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Voici plusieurs raisons pour mettre en place ce type de systèmes :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:quote -->\n<blockquote class="wp-block-quote"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Qualité des légumes</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>rendement élevé au m2</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Éloignement des ravageurs venant de la terre (limaces, etc.)</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Bénéfice éducatif venant de la compréhension de la culture des plantes (en particulier pour les citadins)</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Partage des productions et des savoir faire avec les voisins</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Pas besoin de terre</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Faible coût de développement et de mise en œuvre</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Très faible coût énergétique</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Très faible consommation d\'eau</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>etc.</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></blockquote>\n<!-- /wp:quote -->\n\n<!-- wp:paragraph -->\n<p>A completer...</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Y sont présentées les activités de test et d\'apprentissage de ces techniques réalisées depuis le printemps 2022 à Saint-germain-en-Laye (78, Yvelines), Aix-en-Provence et Marseille (13, Bouches du Rhône). </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->','Bienvenue','','inherit','closed','closed','','2-revision-v1','','','2023-08-14 16:56:48','2023-08-14 14:56:48','',2,'https://hs.vicq.org/?p=78',0,'revision','',0);
INSERT INTO `hs_posts` VALUES (79,1,'2023-08-14 16:57:19','2023-08-14 14:57:19','<!-- wp:heading -->\n<h2 class="wp-block-heading">Ce blog est consacré à l\'hydroponie et la bioponie domestiques. </h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Ces deux techniques de culture font partie de la famille des cultures hors-sol sur substrat neutre. Elles consistent à faire pousser des plantes sans terre, sur un substrat neutre (billes d\'argile par exemple), en mettant en place un dispositif efficace pour leur fournir les nutriments nécessaire pour assurer une croissance efficace des racines et des plantes. La recirculation du liquide nutritif évite la perte d\'eau dans la culture en sol. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Origine du projet et cheminement</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>J\'ai commencé à m\'intéresser aux questions de culture urbaines pendant l\'épidémie de COVID. Cet épisode anxiogène m\'a fait m\'interroger sur certaines questions d\'organisation de la société, et aux risques associés à l\'approvisionnement en ville des denrées alimentaires. En effet, il semble qu\'en cas de gros dysfonctionnement de la logistique d\'approvisionnement en nourriture, en quelque jours les villes pourraient se retrouver privées d\'une partie importante de leurs ressources alimentaires. Face à cette fragilité de l\'organisation de ces flux de transport, il semble intéressant de développer des dispositifs urbains assurant la production de légumes dans la ville. Des études sur ces sujets existent, mais je ne suis pas un spécialiste de la recherche en agriculture urbaine. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>De plus, les questions d\'épuisement de la planète sont maintenant au centre des débats, et la culture économe en eau et en énergie est un sujet intéressant pour les années à venir.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Culture hors sol, définitions</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Le web pullule d\'explications sur ces techniques de culture. Vous pouvez trouver <a href="https://fermedecagnolle.fr/hydroponie-bioponie-aquaponie-definitions/"><strong>ici</strong></a> par exemple des définitions simples de l\'<strong>hydroponie</strong>, <strong>bioponie</strong> et <strong>aquaponie</strong> proposées par Marion Sarlé (<a href="https://lessourciers.com/fr/">les sourciers</a>). Marion Sarlé propose aussi le livre «&nbsp;<em><strong>Monter sa microferme en hydroponie, bioponie et aquaponie</strong></em>&nbsp;», en vente sur le site <a href="https://lessourciers.com/fr/livre-sourciers/">Les Sourciers</a>&nbsp;. Les sourciers proposent aussi des <a href="https://lessourciers.com/fr/les-formations/">formations</a> en ligne et dans leur ferme du Gers. J\'ai suivi la partie en ligne de la formation <a href="https://lessourciers.com/fr/les-formations/microferme-hydroponique/">Microferme Hydroponique</a> qui m\'a bien aidé à comprendre les rudiments de base.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Une fois ces grandes définitions comprises, on trouve de très facilement des informations sur les <strong><a href="https://jardinfute.com/culture-hors-sol/page/2/">nombreux types de dispositifs</a></strong> utilisés pour ce type de culture (ex : <a href="https://jardinfute.com/methode-kratky/">Kratky</a>, <a href="https://jardinfute.com/systeme-dwc-hydroponie/">DWC</a>, <a href="https://jardinfute.com/systeme-nft-hydroponie/">NFT</a>, <a href="https://jardinfute.com/table-a-maree-ebb-flow/">table à marée</a>, etc.). J\'ai choisi les explications sur le site <a href="https://jardinfute.com/">jardinfute.com</a>, mais vous trouverez facilement d\'autres systèmes et d\'autres explications sur internet.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Si l\'on évalue la complexité de ces techniques, on comprend que l\'<strong>hydroponie</strong> est la plus simple des trois, puisqu\'elle se base sur la circulation d\'une solution nutritive contenant des nutriments minéraux directement assimilables par les racines des plantes cultivées. En gros, il suffit de faire circuler de l\'eau additionnée d\'engrais sur les racines des plantes.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Quand on regarde les principes de la <strong>bioponie</strong> et l\'<strong>aquaponie</strong>, on comprend que le principe est plus complexe. Dans les deux cas on va transformer des éléments organiques en éléments minéraux pouvant être assimilés par les plantes (minéralisation). Cela est réalisé en deux étapes par l\'action de deux bactéries qui vont assurer tout d\'abord la transformation des éléments organiques en nitrites (bactéries <strong>Nitrosomonas</strong>) puis des nitrites en nitrates (bactéries <strong>Nitrobacter</strong>). Dans les deux cas, il faut offrir à ces bactéries un lieu et des conditions de vie, et finalement pour l\'aquaponie il faut s\'occuper aussi de ses poissons, et en particulier gérer les caractéristiques de l\'eau.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Pour avoir les meilleurs chances ai choisi de commencer par l\'hydroponie.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Prototypes</h2>\n<!-- /wp:heading -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading">Etape 1 : 2021-2022, un petit système hydroponique</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Durant l\'hiver 2021, j\'ai fait des recherches des différents systèmes hydroponiques disponibles et de comment réaliser sois même ce genre de choses, et j\'ai été convaincu de l\'idée de commencer petit, afin de pouvoir planter dès le printemps 2022. Les retours d\'expérience unanimes des personnes expérimentées sont qu\'il faut commencer simple et petit. L\'idée de commencer avec un petit système simple n\'a, à mon avis, que des avantages pour quelqu\'un comme moi qui aime bricoler : </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Un petit prototype opérationnel est complet, donc on apprendra presque qu\'autant de choses que sur un plus gros système.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Le temps de développement est plus court, on aura ainsi plus de chances d\'aboutir dans des délais imposés par ses propres contraintes quotidiennes et l\'implacable chef d\'orchestre que sont les saisons. Par exemple, en France, il n\'est pas vraiment facile de planter des tomates à l\'automne, il faudra avoir été prêt pour le printemps, ou attendre le printemps suivant. </li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>On réduit le coût de fabrication, le risque financier et le temps passé si l\'on rate sa réalisation ou si on renonce avant la fin.</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:paragraph -->\n<p>J\'ai donc recherché les systèmes hydroponiques disponibles sur le marché ; j\'ai trouvé pas mal de systèmes clés en main, plus ou moins aboutis et plus ou moins chers. Pourtant, j\'ai décidé de construire moi-même mon premier système, pour plusieurs raisons :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Je suis convaincu que "mettre la main à la pâte" est souvent une bonne idée pour comprendre plus profondément un système technique,</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>j\'aime bien réaliser des prototypes en adaptant une solution technique existante à mon besoin personnel, cela m\'aide à  réfléchir à une généralisation possible les autres.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Taille du dispositif</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>On peut vouloir créer des fermes urbaines de taille plus ou moins importante, mais j\'ai décider de m\'intéresser à des dispositifs mis en œuvre à l\'échelle individuelle ou de proche voisinage, car cela représente des investissements réduits, une capacité de réalisation rapide et un investissement en temps acceptable. De plus, même si l\'ambition de tels systèmes n\'est pas de produire des bénéfices financiers, elle semble intéressante à l\'échelle de l\'individu ou du voisinage.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Bénéfices du système</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Voici plusieurs raisons pour mettre en place ce type de systèmes :</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading">Un mini-système hydroponique</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Durant l\'hiver 2021, j\'ai choisi de réaliser un système hydroponique vertical. Etant compétent en impression 3D, j\'ai décider de partir d\'un système déjà conçu, et de l\'adapter un peu.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>voici à quoi ce système ressemblait dans sa <a href="https://www.thingiverse.com/thing:3405964/">version originale</a> : </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:columns -->\n<div class="wp-block-columns"><!-- wp:column -->\n<div class="wp-block-column"><!-- wp:image {"width":535,"height":402,"sizeSlug":"large"} -->\n<figure class="wp-block-image size-large is-resized"><img src="https://cdn.thingiverse.com/renders/33/b6/37/85/85/59b0c38e5b805c7dd9b9f5abeee79ca0_preview_featured.jpg" alt="" style="width:535px;height:402px" width="535" height="402"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class="wp-block-column"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>La colonne est creuse est composée de modules empilables, ce qui permet de choisir le nombre de plantes</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>le réservoir en bas contient une pompe, cette dernière remonte l\'eau via un tuyau au centre de la tour jusqu\'à l\'étage supérieur qui et lui même percé de trous...</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>l\'eau passe par ces trous et redescend par gravité jusqu\'au réservoir, en arrosant au passage les racines des plantes maintenues en position dans des billes d\'argile dans les paniers amovibles (couleur ocre) installés dans la tour</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:paragraph -->\n<p>J\'ai du adapter le système de de fixation entre le bas de la tour et mon réservoirs, ainsi que certaines modifications mineures.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Au printemps 2022 J\'ai fabriqué et mis en service 4 systèmes modulaires hydroponiques (que l\'on pourrait les qualifier d\'aéro-hydroponiques). Ces systèmes avaient une forme de cylindre creux lequel étaient insérés des paniers contenant des billes d\'argile. En bas de la tour un réservoir de 10 à 20 litres dans lequel une pompe alimentait le haut de la tour par un tuyau, le liquide redescendant dans la tour en imprégnant les racines par gravité.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Le détail et les photos sont disponibles ici</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Les résultats étaient intéressants, j\'ai beaucoup appris de ce système. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p> </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Début 2022, j\'étais très motivé par les principes de l\'aquaponie. La nature symbiotique poissons + plantes, la création d\'un écosystème économe et vertueux, la double production poissons + plantes sur une surface réduite m\'ont donné très envie d\'aller voir de plus près ce genre de systèmes. J\'ai bien sur beaucoup cherché sur internet, vu des réalisations magnifiques (par exemple la chaine de <a href="https://www.youtube.com/@ChrisPagns">Chris Pagns</a> sur youtube).</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>A completer...</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Y sont présentées les activités de test et d\'apprentissage de ces techniques réalisées depuis le printemps 2022 à Saint-germain-en-Laye (78, Yvelines), Aix-en-Provence et Marseille (13, Bouches du Rhône). </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->','Bienvenue','','inherit','closed','closed','','2-revision-v1','','','2023-08-14 16:57:19','2023-08-14 14:57:19','',2,'https://hs.vicq.org/?p=79',0,'revision','',0);
INSERT INTO `hs_posts` VALUES (81,1,'2023-08-14 18:07:59','2023-08-14 16:07:59','<!-- wp:heading -->\n<h2 class="wp-block-heading">Ce blog est consacré à l\'hydroponie et la bioponie domestiques. </h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Ces deux techniques de culture font partie de la famille des cultures hors-sol sur substrat neutre. Elles consistent à faire pousser des plantes sans terre, sur un substrat neutre (billes d\'argile par exemple), en mettant en place un dispositif efficace pour leur fournir les nutriments nécessaire pour assurer une croissance efficace des racines et des plantes. La recirculation du liquide nutritif évite une grande partie de la consommation d\'eau qui est induite dans la culture en sol. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Origine du projet et cheminement</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>J\'ai commencé à m\'intéresser aux questions de culture urbaines pendant l\'épidémie de COVID. Cet épisode anxiogène m\'a fait m\'interroger sur certaines questions d\'organisation de la société, et aux risques associés à l\'approvisionnement en ville des denrées alimentaires. En effet, il semble qu\'en cas de gros dysfonctionnement de la logistique d\'approvisionnement en nourriture, en quelque jours les villes pourraient se retrouver privées d\'une partie importante de leurs ressources alimentaires. Face à cette fragilité de l\'organisation de ces flux de transport, il semble intéressant de développer des dispositifs urbains assurant la production de légumes dans la ville. Des études sur ces sujets existent, mais je ne suis pas un spécialiste de la recherche en agriculture urbaine. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>De plus, les questions d\'épuisement de la planète sont maintenant au centre des débats, et la culture économe en eau et en énergie est un sujet intéressant pour les années à venir.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Culture hors sol, définitions</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Le web pullule d\'explications sur ces techniques de culture. Vous pouvez trouver <a href="https://fermedecagnolle.fr/hydroponie-bioponie-aquaponie-definitions/"><strong>ici</strong></a> par exemple des définitions simples de l\'<strong>hydroponie</strong>, <strong>bioponie</strong> et <strong>aquaponie</strong> proposées par Marion Sarlé (<a href="https://lessourciers.com/fr/">les sourciers</a>). Marion Sarlé propose aussi le livre «&nbsp;<em><strong>Monter sa microferme en hydroponie, bioponie et aquaponie</strong></em>&nbsp;», en vente sur le site <a href="https://lessourciers.com/fr/livre-sourciers/">Les Sourciers</a>&nbsp;. Les sourciers proposent aussi des <a href="https://lessourciers.com/fr/les-formations/">formations</a> en ligne et dans leur ferme du Gers. J\'ai suivi la partie en ligne de la formation <a href="https://lessourciers.com/fr/les-formations/microferme-hydroponique/">Microferme Hydroponique</a> qui m\'a bien aidé à comprendre les rudiments de base.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Une fois ces grandes définitions comprises, on trouve de très facilement des informations sur les <strong><a href="https://jardinfute.com/culture-hors-sol/page/2/">nombreux types de dispositifs</a></strong> utilisés pour ce type de culture (ex : <a href="https://jardinfute.com/methode-kratky/">Kratky</a>, <a href="https://jardinfute.com/systeme-dwc-hydroponie/">DWC</a>, <a href="https://jardinfute.com/systeme-nft-hydroponie/">NFT</a>, <a href="https://jardinfute.com/table-a-maree-ebb-flow/">table à marée</a>, etc.). J\'ai choisi les explications sur le site <a href="https://jardinfute.com/">jardinfute.com</a>, mais vous trouverez facilement d\'autres systèmes et d\'autres explications sur internet.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Si l\'on évalue la complexité de ces techniques, on comprend que l\'<strong>hydroponie</strong> est la plus simple des trois, puisqu\'elle se base sur la circulation d\'une solution nutritive contenant des nutriments minéraux directement assimilables par les racines des plantes cultivées. En gros, il suffit de faire circuler de l\'eau additionnée d\'engrais sur les racines des plantes.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Quand on regarde les principes de la <strong>bioponie</strong> et l\'<strong>aquaponie</strong>, on comprend que le principe est plus complexe. Dans les deux cas on va transformer des éléments organiques en éléments minéraux pouvant être assimilés par les plantes (minéralisation). Cela est réalisé en deux étapes par l\'action de deux bactéries qui vont assurer tout d\'abord la transformation des éléments organiques en nitrites (bactéries <strong>Nitrosomonas</strong>) puis des nitrites en nitrates (bactéries <strong>Nitrobacter</strong>). Dans les deux cas, il faut offrir à ces bactéries un lieu et des conditions de vie, et finalement pour l\'aquaponie il faut s\'occuper aussi de ses poissons, et en particulier gérer les caractéristiques de l\'eau.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Pour avoir les meilleurs chances ai choisi de commencer par l\'hydroponie.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Prototypes</h2>\n<!-- /wp:heading -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading">Etape 1 : 2021-2022, un petit système hydroponique</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Durant l\'hiver 2021, j\'ai fait des recherches des différents systèmes hydroponiques disponibles et de comment réaliser sois même ce genre de choses, et j\'ai été convaincu de l\'idée de commencer petit, afin de pouvoir planter dès le printemps 2022. Les retours d\'expérience unanimes des personnes expérimentées sont qu\'il faut commencer simple et petit. L\'idée de commencer avec un petit système simple n\'a, à mon avis, que des avantages pour quelqu\'un comme moi qui aime bricoler : </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Un petit prototype opérationnel est complet, donc on apprendra presque qu\'autant de choses que sur un plus gros système.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Le temps de développement est plus court, on aura ainsi plus de chances d\'aboutir dans des délais imposés par ses propres contraintes quotidiennes et l\'implacable chef d\'orchestre que sont les saisons. Par exemple, en France, il n\'est pas vraiment facile de planter des tomates à l\'automne, il faudra avoir été prêt pour le printemps, ou attendre le printemps suivant. </li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>On réduit le coût de fabrication, le risque financier et le temps passé si l\'on rate sa réalisation ou si on renonce avant la fin.</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:paragraph -->\n<p>J\'ai donc recherché les systèmes hydroponiques disponibles sur le marché ; j\'ai trouvé pas mal de systèmes clés en main, plus ou moins aboutis et plus ou moins chers. Pourtant, j\'ai décidé de construire moi-même mon premier système, pour plusieurs raisons :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Je suis convaincu que "mettre la main à la pâte" est souvent une bonne idée pour comprendre plus profondément un système technique,</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>j\'aime bien réaliser des prototypes en adaptant une solution technique existante à mon besoin personnel, cela m\'aide à  réfléchir à une généralisation possible les autres.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Taille du dispositif</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>On peut vouloir créer des fermes urbaines de taille plus ou moins importante, mais j\'ai décider de m\'intéresser à des dispositifs mis en œuvre à l\'échelle individuelle ou de proche voisinage, car cela représente des investissements réduits, une capacité de réalisation rapide et un investissement en temps acceptable. De plus, même si l\'ambition de tels systèmes n\'est pas de produire des bénéfices financiers, elle semble intéressante à l\'échelle de l\'individu ou du voisinage.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Bénéfices du système</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Voici plusieurs raisons pour mettre en place ce type de systèmes :</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading">Un mini-système hydroponique</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Durant l\'hiver 2021, j\'ai choisi de réaliser un système hydroponique vertical. Etant compétent en impression 3D, j\'ai décider de partir d\'un système déjà conçu, et de l\'adapter un peu.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>voici à quoi ce système ressemblait dans sa <a href="https://www.thingiverse.com/thing:3405964/">version originale</a> : </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:columns -->\n<div class="wp-block-columns"><!-- wp:column -->\n<div class="wp-block-column"><!-- wp:image {"width":535,"height":402,"sizeSlug":"large"} -->\n<figure class="wp-block-image size-large is-resized"><img src="https://cdn.thingiverse.com/renders/33/b6/37/85/85/59b0c38e5b805c7dd9b9f5abeee79ca0_preview_featured.jpg" alt="" style="width:535px;height:402px" width="535" height="402"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class="wp-block-column"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>La colonne est creuse est composée de modules empilables, ce qui permet de choisir le nombre de plantes</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>le réservoir en bas contient une pompe, cette dernière remonte l\'eau via un tuyau au centre de la tour jusqu\'à l\'étage supérieur qui et lui même percé de trous...</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>l\'eau passe par ces trous et redescend par gravité jusqu\'au réservoir, en arrosant au passage les racines des plantes maintenues en position dans des billes d\'argile dans les paniers amovibles (couleur ocre) installés dans la tour</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:paragraph -->\n<p>J\'ai du adapter le système de de fixation entre le bas de la tour et mon réservoirs, ainsi que certaines modifications mineures.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Au printemps 2022 J\'ai fabriqué et mis en service 4 systèmes modulaires hydroponiques (que l\'on pourrait les qualifier d\'aéro-hydroponiques). Ces systèmes avaient une forme de cylindre creux lequel étaient insérés des paniers contenant des billes d\'argile. En bas de la tour un réservoir de 10 à 20 litres dans lequel une pompe alimentait le haut de la tour par un tuyau, le liquide redescendant dans la tour en imprégnant les racines par gravité.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Le détail et les photos sont disponibles ici</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Les résultats étaient intéressants, j\'ai beaucoup appris de ce système. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p> </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Début 2022, j\'étais très motivé par les principes de l\'aquaponie. La nature symbiotique poissons + plantes, la création d\'un écosystème économe et vertueux, la double production poissons + plantes sur une surface réduite m\'ont donné très envie d\'aller voir de plus près ce genre de systèmes. J\'ai bien sur beaucoup cherché sur internet, vu des réalisations magnifiques (par exemple la chaine de <a href="https://www.youtube.com/@ChrisPagns">Chris Pagns</a> sur youtube).</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>A completer...</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Y sont présentées les activités de test et d\'apprentissage de ces techniques réalisées depuis le printemps 2022 à Saint-germain-en-Laye (78, Yvelines), Aix-en-Provence et Marseille (13, Bouches du Rhône). </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->','Bienvenue','','inherit','closed','closed','','2-revision-v1','','','2023-08-14 18:07:59','2023-08-14 16:07:59','',2,'https://hs.vicq.org/?p=81',0,'revision','',0);
INSERT INTO `hs_posts` VALUES (82,1,'2023-08-14 18:10:09','2023-08-14 16:10:09','<!-- wp:heading -->\n<h2 class="wp-block-heading">Ce blog est consacré à l\'hydroponie et la bioponie domestiques. </h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Ces deux techniques de culture font partie de la famille des cultures hors-sol sur substrat neutre. Elles consistent à faire pousser des plantes sans terre, sur un substrat neutre (billes d\'argile par exemple), en mettant en place un dispositif efficace pour leur fournir les nutriments nécessaire pour assurer une croissance efficace des racines et des plantes. La recirculation du liquide nutritif évite une grande partie de la consommation d\'eau qui est induite dans la culture en sol. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Origine du projet et cheminement</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>J\'ai commencé à m\'intéresser aux questions de culture urbaines pendant l\'épidémie de COVID. Cet épisode anxiogène m\'a fait m\'interroger sur certaines questions d\'organisation de la société, et aux risques associés à l\'approvisionnement en ville des denrées alimentaires. En effet, il semble qu\'en cas de gros dysfonctionnement de la logistique d\'approvisionnement en nourriture, en quelque jours les villes pourraient se retrouver privées d\'une partie importante de leurs ressources alimentaires. Face à cette potentielle fragilité des flux de transport, il semble intéressant de développer des dispositifs urbains assurant une partie (même réduite) de la production de légumes dans la ville. Des études sur ces sujets existent, mais je ne suis pas un spécialiste de la recherche en agriculture urbaine, j\'essayerai de faire un peu de bibliographie à ce sujet quand j\'aurai le temps.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>De plus, les questions d\'épuisement de la planète sont maintenant au centre des débats, et la culture économe en eau et en énergie est un sujet intéressant pour les années à venir.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Culture hors sol, définitions</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Le web pullule d\'explications sur ces techniques de culture. Vous pouvez trouver <a href="https://fermedecagnolle.fr/hydroponie-bioponie-aquaponie-definitions/"><strong>ici</strong></a> par exemple des définitions simples de l\'<strong>hydroponie</strong>, <strong>bioponie</strong> et <strong>aquaponie</strong> proposées par Marion Sarlé (<a href="https://lessourciers.com/fr/">les sourciers</a>). Marion Sarlé propose aussi le livre «&nbsp;<em><strong>Monter sa microferme en hydroponie, bioponie et aquaponie</strong></em>&nbsp;», en vente sur le site <a href="https://lessourciers.com/fr/livre-sourciers/">Les Sourciers</a>&nbsp;. Les sourciers proposent aussi des <a href="https://lessourciers.com/fr/les-formations/">formations</a> en ligne et dans leur ferme du Gers. J\'ai suivi la partie en ligne de la formation <a href="https://lessourciers.com/fr/les-formations/microferme-hydroponique/">Microferme Hydroponique</a> qui m\'a bien aidé à comprendre les rudiments de base.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Une fois ces grandes définitions comprises, on trouve de très facilement des informations sur les <strong><a href="https://jardinfute.com/culture-hors-sol/page/2/">nombreux types de dispositifs</a></strong> utilisés pour ce type de culture (ex : <a href="https://jardinfute.com/methode-kratky/">Kratky</a>, <a href="https://jardinfute.com/systeme-dwc-hydroponie/">DWC</a>, <a href="https://jardinfute.com/systeme-nft-hydroponie/">NFT</a>, <a href="https://jardinfute.com/table-a-maree-ebb-flow/">table à marée</a>, etc.). J\'ai choisi les explications sur le site <a href="https://jardinfute.com/">jardinfute.com</a>, mais vous trouverez facilement d\'autres systèmes et d\'autres explications sur internet.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Si l\'on évalue la complexité de ces techniques, on comprend que l\'<strong>hydroponie</strong> est la plus simple des trois, puisqu\'elle se base sur la circulation d\'une solution nutritive contenant des nutriments minéraux directement assimilables par les racines des plantes cultivées. En gros, il suffit de faire circuler de l\'eau additionnée d\'engrais sur les racines des plantes.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Quand on regarde les principes de la <strong>bioponie</strong> et l\'<strong>aquaponie</strong>, on comprend que le principe est plus complexe. Dans les deux cas on va transformer des éléments organiques en éléments minéraux pouvant être assimilés par les plantes (minéralisation). Cela est réalisé en deux étapes par l\'action de deux bactéries qui vont assurer tout d\'abord la transformation des éléments organiques en nitrites (bactéries <strong>Nitrosomonas</strong>) puis des nitrites en nitrates (bactéries <strong>Nitrobacter</strong>). Dans les deux cas, il faut offrir à ces bactéries un lieu et des conditions de vie, et finalement pour l\'aquaponie il faut s\'occuper aussi de ses poissons, et en particulier gérer les caractéristiques de l\'eau.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Pour avoir les meilleurs chances ai choisi de commencer par l\'hydroponie.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Prototypes</h2>\n<!-- /wp:heading -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading">Etape 1 : 2021-2022, un petit système hydroponique</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Durant l\'hiver 2021, j\'ai fait des recherches des différents systèmes hydroponiques disponibles et de comment réaliser sois même ce genre de choses, et j\'ai été convaincu de l\'idée de commencer petit, afin de pouvoir planter dès le printemps 2022. Les retours d\'expérience unanimes des personnes expérimentées sont qu\'il faut commencer simple et petit. L\'idée de commencer avec un petit système simple n\'a, à mon avis, que des avantages pour quelqu\'un comme moi qui aime bricoler : </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Un petit prototype opérationnel est complet, donc on apprendra presque qu\'autant de choses que sur un plus gros système.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Le temps de développement est plus court, on aura ainsi plus de chances d\'aboutir dans des délais imposés par ses propres contraintes quotidiennes et l\'implacable chef d\'orchestre que sont les saisons. Par exemple, en France, il n\'est pas vraiment facile de planter des tomates à l\'automne, il faudra avoir été prêt pour le printemps, ou attendre le printemps suivant. </li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>On réduit le coût de fabrication, le risque financier et le temps passé si l\'on rate sa réalisation ou si on renonce avant la fin.</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:paragraph -->\n<p>J\'ai donc recherché les systèmes hydroponiques disponibles sur le marché ; j\'ai trouvé pas mal de systèmes clés en main, plus ou moins aboutis et plus ou moins chers. Pourtant, j\'ai décidé de construire moi-même mon premier système, pour plusieurs raisons :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Je suis convaincu que "mettre la main à la pâte" est souvent une bonne idée pour comprendre plus profondément un système technique,</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>j\'aime bien réaliser des prototypes en adaptant une solution technique existante à mon besoin personnel, cela m\'aide à  réfléchir à une généralisation possible les autres.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Taille du dispositif</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>On peut vouloir créer des fermes urbaines de taille plus ou moins importante, mais j\'ai décider de m\'intéresser à des dispositifs mis en œuvre à l\'échelle individuelle ou de proche voisinage, car cela représente des investissements réduits, une capacité de réalisation rapide et un investissement en temps acceptable. De plus, même si l\'ambition de tels systèmes n\'est pas de produire des bénéfices financiers, elle semble intéressante à l\'échelle de l\'individu ou du voisinage.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Bénéfices du système</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Voici plusieurs raisons pour mettre en place ce type de systèmes :</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading">Un mini-système hydroponique</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Durant l\'hiver 2021, j\'ai choisi de réaliser un système hydroponique vertical. Etant compétent en impression 3D, j\'ai décider de partir d\'un système déjà conçu, et de l\'adapter un peu.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>voici à quoi ce système ressemblait dans sa <a href="https://www.thingiverse.com/thing:3405964/">version originale</a> : </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:columns -->\n<div class="wp-block-columns"><!-- wp:column -->\n<div class="wp-block-column"><!-- wp:image {"width":535,"height":402,"sizeSlug":"large"} -->\n<figure class="wp-block-image size-large is-resized"><img src="https://cdn.thingiverse.com/renders/33/b6/37/85/85/59b0c38e5b805c7dd9b9f5abeee79ca0_preview_featured.jpg" alt="" style="width:535px;height:402px" width="535" height="402"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class="wp-block-column"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>La colonne est creuse est composée de modules empilables, ce qui permet de choisir le nombre de plantes</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>le réservoir en bas contient une pompe, cette dernière remonte l\'eau via un tuyau au centre de la tour jusqu\'à l\'étage supérieur qui et lui même percé de trous...</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>l\'eau passe par ces trous et redescend par gravité jusqu\'au réservoir, en arrosant au passage les racines des plantes maintenues en position dans des billes d\'argile dans les paniers amovibles (couleur ocre) installés dans la tour</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:paragraph -->\n<p>J\'ai du adapter le système de de fixation entre le bas de la tour et mon réservoirs, ainsi que certaines modifications mineures.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Au printemps 2022 J\'ai fabriqué et mis en service 4 systèmes modulaires hydroponiques (que l\'on pourrait les qualifier d\'aéro-hydroponiques). Ces systèmes avaient une forme de cylindre creux lequel étaient insérés des paniers contenant des billes d\'argile. En bas de la tour un réservoir de 10 à 20 litres dans lequel une pompe alimentait le haut de la tour par un tuyau, le liquide redescendant dans la tour en imprégnant les racines par gravité.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Le détail et les photos sont disponibles ici</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Les résultats étaient intéressants, j\'ai beaucoup appris de ce système. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p> </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Début 2022, j\'étais très motivé par les principes de l\'aquaponie. La nature symbiotique poissons + plantes, la création d\'un écosystème économe et vertueux, la double production poissons + plantes sur une surface réduite m\'ont donné très envie d\'aller voir de plus près ce genre de systèmes. J\'ai bien sur beaucoup cherché sur internet, vu des réalisations magnifiques (par exemple la chaine de <a href="https://www.youtube.com/@ChrisPagns">Chris Pagns</a> sur youtube).</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>A completer...</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Y sont présentées les activités de test et d\'apprentissage de ces techniques réalisées depuis le printemps 2022 à Saint-germain-en-Laye (78, Yvelines), Aix-en-Provence et Marseille (13, Bouches du Rhône). </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->','Bienvenue','','inherit','closed','closed','','2-revision-v1','','','2023-08-14 18:10:09','2023-08-14 16:10:09','',2,'https://hs.vicq.org/?p=82',0,'revision','',0);
INSERT INTO `hs_posts` VALUES (83,1,'2023-08-14 18:10:50','2023-08-14 16:10:50','<!-- wp:heading -->\n<h2 class="wp-block-heading">Ce blog est consacré à l\'hydroponie et la bioponie domestiques. </h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Ces deux techniques de culture font partie de la famille des cultures hors-sol sur substrat neutre. Elles consistent à faire pousser des plantes sans terre, sur un substrat neutre (billes d\'argile par exemple), en mettant en place un dispositif efficace pour leur fournir les nutriments nécessaire pour assurer une croissance efficace des racines et des plantes. La recirculation du liquide nutritif évite une grande partie de la consommation d\'eau qui est induite dans la culture en sol. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Origine du projet et cheminement</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>J\'ai commencé à m\'intéresser aux questions de culture urbaines pendant l\'épidémie de COVID. Cet épisode anxiogène m\'a fait m\'interroger sur certaines questions d\'organisation de la société, et aux risques associés à l\'approvisionnement en ville des denrées alimentaires. En effet, il semble qu\'en cas de gros dysfonctionnement de la logistique d\'approvisionnement en nourriture, en quelque jours les villes pourraient se retrouver privées d\'une partie importante de leurs ressources alimentaires. Face à cette potentielle fragilité des flux de transport, il semble intéressant de développer des dispositifs urbains assurant une partie (même réduite) de la production de légumes dans la ville. Des études sur ces sujets existent, mais je ne suis pas un spécialiste de la recherche en agriculture urbaine, j\'essayerai de faire un peu de bibliographie à ce sujet quand j\'aurai le temps.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>De plus, les questions d\'épuisement de la planète sont maintenant au centre des débats, et cultiver des légumes en étant économe en eau et en énergie est un sujet intéressant et prometteur pour les temps à venir.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Culture hors sol, définitions</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Le web pullule d\'explications sur ces techniques de culture. Vous pouvez trouver <a href="https://fermedecagnolle.fr/hydroponie-bioponie-aquaponie-definitions/"><strong>ici</strong></a> par exemple des définitions simples de l\'<strong>hydroponie</strong>, <strong>bioponie</strong> et <strong>aquaponie</strong> proposées par Marion Sarlé (<a href="https://lessourciers.com/fr/">les sourciers</a>). Marion Sarlé propose aussi le livre «&nbsp;<em><strong>Monter sa microferme en hydroponie, bioponie et aquaponie</strong></em>&nbsp;», en vente sur le site <a href="https://lessourciers.com/fr/livre-sourciers/">Les Sourciers</a>&nbsp;. Les sourciers proposent aussi des <a href="https://lessourciers.com/fr/les-formations/">formations</a> en ligne et dans leur ferme du Gers. J\'ai suivi la partie en ligne de la formation <a href="https://lessourciers.com/fr/les-formations/microferme-hydroponique/">Microferme Hydroponique</a> qui m\'a bien aidé à comprendre les rudiments de base.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Une fois ces grandes définitions comprises, on trouve de très facilement des informations sur les <strong><a href="https://jardinfute.com/culture-hors-sol/page/2/">nombreux types de dispositifs</a></strong> utilisés pour ce type de culture (ex : <a href="https://jardinfute.com/methode-kratky/">Kratky</a>, <a href="https://jardinfute.com/systeme-dwc-hydroponie/">DWC</a>, <a href="https://jardinfute.com/systeme-nft-hydroponie/">NFT</a>, <a href="https://jardinfute.com/table-a-maree-ebb-flow/">table à marée</a>, etc.). J\'ai choisi les explications sur le site <a href="https://jardinfute.com/">jardinfute.com</a>, mais vous trouverez facilement d\'autres systèmes et d\'autres explications sur internet.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Si l\'on évalue la complexité de ces techniques, on comprend que l\'<strong>hydroponie</strong> est la plus simple des trois, puisqu\'elle se base sur la circulation d\'une solution nutritive contenant des nutriments minéraux directement assimilables par les racines des plantes cultivées. En gros, il suffit de faire circuler de l\'eau additionnée d\'engrais sur les racines des plantes.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Quand on regarde les principes de la <strong>bioponie</strong> et l\'<strong>aquaponie</strong>, on comprend que le principe est plus complexe. Dans les deux cas on va transformer des éléments organiques en éléments minéraux pouvant être assimilés par les plantes (minéralisation). Cela est réalisé en deux étapes par l\'action de deux bactéries qui vont assurer tout d\'abord la transformation des éléments organiques en nitrites (bactéries <strong>Nitrosomonas</strong>) puis des nitrites en nitrates (bactéries <strong>Nitrobacter</strong>). Dans les deux cas, il faut offrir à ces bactéries un lieu et des conditions de vie, et finalement pour l\'aquaponie il faut s\'occuper aussi de ses poissons, et en particulier gérer les caractéristiques de l\'eau.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Pour avoir les meilleurs chances ai choisi de commencer par l\'hydroponie.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Prototypes</h2>\n<!-- /wp:heading -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading">Etape 1 : 2021-2022, un petit système hydroponique</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Durant l\'hiver 2021, j\'ai fait des recherches des différents systèmes hydroponiques disponibles et de comment réaliser sois même ce genre de choses, et j\'ai été convaincu de l\'idée de commencer petit, afin de pouvoir planter dès le printemps 2022. Les retours d\'expérience unanimes des personnes expérimentées sont qu\'il faut commencer simple et petit. L\'idée de commencer avec un petit système simple n\'a, à mon avis, que des avantages pour quelqu\'un comme moi qui aime bricoler : </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Un petit prototype opérationnel est complet, donc on apprendra presque qu\'autant de choses que sur un plus gros système.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Le temps de développement est plus court, on aura ainsi plus de chances d\'aboutir dans des délais imposés par ses propres contraintes quotidiennes et l\'implacable chef d\'orchestre que sont les saisons. Par exemple, en France, il n\'est pas vraiment facile de planter des tomates à l\'automne, il faudra avoir été prêt pour le printemps, ou attendre le printemps suivant. </li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>On réduit le coût de fabrication, le risque financier et le temps passé si l\'on rate sa réalisation ou si on renonce avant la fin.</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:paragraph -->\n<p>J\'ai donc recherché les systèmes hydroponiques disponibles sur le marché ; j\'ai trouvé pas mal de systèmes clés en main, plus ou moins aboutis et plus ou moins chers. Pourtant, j\'ai décidé de construire moi-même mon premier système, pour plusieurs raisons :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Je suis convaincu que "mettre la main à la pâte" est souvent une bonne idée pour comprendre plus profondément un système technique,</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>j\'aime bien réaliser des prototypes en adaptant une solution technique existante à mon besoin personnel, cela m\'aide à  réfléchir à une généralisation possible les autres.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Taille du dispositif</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>On peut vouloir créer des fermes urbaines de taille plus ou moins importante, mais j\'ai décider de m\'intéresser à des dispositifs mis en œuvre à l\'échelle individuelle ou de proche voisinage, car cela représente des investissements réduits, une capacité de réalisation rapide et un investissement en temps acceptable. De plus, même si l\'ambition de tels systèmes n\'est pas de produire des bénéfices financiers, elle semble intéressante à l\'échelle de l\'individu ou du voisinage.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Bénéfices du système</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Voici plusieurs raisons pour mettre en place ce type de systèmes :</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading">Un mini-système hydroponique</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Durant l\'hiver 2021, j\'ai choisi de réaliser un système hydroponique vertical. Etant compétent en impression 3D, j\'ai décider de partir d\'un système déjà conçu, et de l\'adapter un peu.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>voici à quoi ce système ressemblait dans sa <a href="https://www.thingiverse.com/thing:3405964/">version originale</a> : </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:columns -->\n<div class="wp-block-columns"><!-- wp:column -->\n<div class="wp-block-column"><!-- wp:image {"width":535,"height":402,"sizeSlug":"large"} -->\n<figure class="wp-block-image size-large is-resized"><img src="https://cdn.thingiverse.com/renders/33/b6/37/85/85/59b0c38e5b805c7dd9b9f5abeee79ca0_preview_featured.jpg" alt="" style="width:535px;height:402px" width="535" height="402"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class="wp-block-column"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>La colonne est creuse est composée de modules empilables, ce qui permet de choisir le nombre de plantes</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>le réservoir en bas contient une pompe, cette dernière remonte l\'eau via un tuyau au centre de la tour jusqu\'à l\'étage supérieur qui et lui même percé de trous...</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>l\'eau passe par ces trous et redescend par gravité jusqu\'au réservoir, en arrosant au passage les racines des plantes maintenues en position dans des billes d\'argile dans les paniers amovibles (couleur ocre) installés dans la tour</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:paragraph -->\n<p>J\'ai du adapter le système de de fixation entre le bas de la tour et mon réservoirs, ainsi que certaines modifications mineures.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Au printemps 2022 J\'ai fabriqué et mis en service 4 systèmes modulaires hydroponiques (que l\'on pourrait les qualifier d\'aéro-hydroponiques). Ces systèmes avaient une forme de cylindre creux lequel étaient insérés des paniers contenant des billes d\'argile. En bas de la tour un réservoir de 10 à 20 litres dans lequel une pompe alimentait le haut de la tour par un tuyau, le liquide redescendant dans la tour en imprégnant les racines par gravité.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Le détail et les photos sont disponibles ici</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Les résultats étaient intéressants, j\'ai beaucoup appris de ce système. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p> </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Début 2022, j\'étais très motivé par les principes de l\'aquaponie. La nature symbiotique poissons + plantes, la création d\'un écosystème économe et vertueux, la double production poissons + plantes sur une surface réduite m\'ont donné très envie d\'aller voir de plus près ce genre de systèmes. J\'ai bien sur beaucoup cherché sur internet, vu des réalisations magnifiques (par exemple la chaine de <a href="https://www.youtube.com/@ChrisPagns">Chris Pagns</a> sur youtube).</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>A completer...</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Y sont présentées les activités de test et d\'apprentissage de ces techniques réalisées depuis le printemps 2022 à Saint-germain-en-Laye (78, Yvelines), Aix-en-Provence et Marseille (13, Bouches du Rhône). </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->','Bienvenue','','inherit','closed','closed','','2-revision-v1','','','2023-08-14 18:10:50','2023-08-14 16:10:50','',2,'https://hs.vicq.org/?p=83',0,'revision','',0);
INSERT INTO `hs_posts` VALUES (84,1,'2023-08-14 18:11:14','2023-08-14 16:11:14','<!-- wp:heading -->\n<h2 class="wp-block-heading">Ce blog est consacré à l\'hydroponie et la bioponie domestiques. </h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Ces deux techniques de culture font partie de la famille des cultures hors-sol sur substrat neutre. Elles consistent à faire pousser des plantes sans terre, sur un substrat neutre (billes d\'argile par exemple), en mettant en place un dispositif efficace pour leur fournir les nutriments nécessaire pour assurer une croissance efficace des racines et des plantes. La recirculation du liquide nutritif évite une grande partie de la consommation d\'eau qui est induite dans la culture en sol. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Origine du projet et cheminement</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>J\'ai commencé à m\'intéresser aux questions de culture urbaines pendant l\'épidémie de COVID. Cet épisode anxiogène m\'a fait m\'interroger sur certaines questions d\'organisation de la société, et aux risques associés à l\'approvisionnement en ville des denrées alimentaires. En effet, il semble qu\'en cas de gros dysfonctionnement de la logistique d\'approvisionnement en nourriture, en quelque jours les villes pourraient se retrouver privées d\'une partie importante de leurs ressources alimentaires. Face à cette potentielle fragilité des flux de transport, il semble intéressant de développer des dispositifs urbains assurant une partie (même réduite) de la production de légumes dans la ville. Des études sur ces sujets existent, mais je ne suis pas un spécialiste de la recherche en agriculture urbaine, j\'essayerai de faire un peu de bibliographie à ce sujet quand j\'aurai le temps.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>De plus, les questions d\'épuisement de la planète sont maintenant au centre des débats, et cultiver des légumes en étant économe en eau et en énergie est un sujet intéressant et prometteur pour les temps à venir.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Culture hors sol, définitions</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Le web pullule d\'explications sur ces techniques de culture hors sol. Vous pouvez trouver <a href="https://fermedecagnolle.fr/hydroponie-bioponie-aquaponie-definitions/"><strong>ici</strong></a> par exemple des définitions simples de l\'<strong>hydroponie</strong>, <strong>bioponie</strong> et <strong>aquaponie</strong> proposées par Marion Sarlé (<a href="https://lessourciers.com/fr/">les sourciers</a>). Marion Sarlé propose aussi le livre « <em><strong>Monter sa microferme en hydroponie, bioponie et aquaponie</strong></em> », en vente sur le site <a href="https://lessourciers.com/fr/livre-sourciers/">Les Sourciers</a> . Les sourciers proposent aussi des <a href="https://lessourciers.com/fr/les-formations/">formations</a> en ligne et dans leur ferme du Gers. J\'ai suivi la partie en ligne de la formation <a href="https://lessourciers.com/fr/les-formations/microferme-hydroponique/">Microferme Hydroponique</a> qui m\'a bien aidé à comprendre les rudiments de base.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Une fois ces grandes définitions comprises, on trouve de très facilement des informations sur les <strong><a href="https://jardinfute.com/culture-hors-sol/page/2/">nombreux types de dispositifs</a></strong> utilisés pour ce type de culture (ex : <a href="https://jardinfute.com/methode-kratky/">Kratky</a>, <a href="https://jardinfute.com/systeme-dwc-hydroponie/">DWC</a>, <a href="https://jardinfute.com/systeme-nft-hydroponie/">NFT</a>, <a href="https://jardinfute.com/table-a-maree-ebb-flow/">table à marée</a>, etc.). J\'ai choisi les explications sur le site <a href="https://jardinfute.com/">jardinfute.com</a>, mais vous trouverez facilement d\'autres systèmes et d\'autres explications sur internet.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Si l\'on évalue la complexité de ces techniques, on comprend que l\'<strong>hydroponie</strong> est la plus simple des trois, puisqu\'elle se base sur la circulation d\'une solution nutritive contenant des nutriments minéraux directement assimilables par les racines des plantes cultivées. En gros, il suffit de faire circuler de l\'eau additionnée d\'engrais sur les racines des plantes.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Quand on regarde les principes de la <strong>bioponie</strong> et l\'<strong>aquaponie</strong>, on comprend que le principe est plus complexe. Dans les deux cas on va transformer des éléments organiques en éléments minéraux pouvant être assimilés par les plantes (minéralisation). Cela est réalisé en deux étapes par l\'action de deux bactéries qui vont assurer tout d\'abord la transformation des éléments organiques en nitrites (bactéries <strong>Nitrosomonas</strong>) puis des nitrites en nitrates (bactéries <strong>Nitrobacter</strong>). Dans les deux cas, il faut offrir à ces bactéries un lieu et des conditions de vie, et finalement pour l\'aquaponie il faut s\'occuper aussi de ses poissons, et en particulier gérer les caractéristiques de l\'eau.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Pour avoir les meilleurs chances ai choisi de commencer par l\'hydroponie.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Prototypes</h2>\n<!-- /wp:heading -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading">Etape 1 : 2021-2022, un petit système hydroponique</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Durant l\'hiver 2021, j\'ai fait des recherches des différents systèmes hydroponiques disponibles et de comment réaliser sois même ce genre de choses, et j\'ai été convaincu de l\'idée de commencer petit, afin de pouvoir planter dès le printemps 2022. Les retours d\'expérience unanimes des personnes expérimentées sont qu\'il faut commencer simple et petit. L\'idée de commencer avec un petit système simple n\'a, à mon avis, que des avantages pour quelqu\'un comme moi qui aime bricoler : </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Un petit prototype opérationnel est complet, donc on apprendra presque qu\'autant de choses que sur un plus gros système.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Le temps de développement est plus court, on aura ainsi plus de chances d\'aboutir dans des délais imposés par ses propres contraintes quotidiennes et l\'implacable chef d\'orchestre que sont les saisons. Par exemple, en France, il n\'est pas vraiment facile de planter des tomates à l\'automne, il faudra avoir été prêt pour le printemps, ou attendre le printemps suivant. </li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>On réduit le coût de fabrication, le risque financier et le temps passé si l\'on rate sa réalisation ou si on renonce avant la fin.</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:paragraph -->\n<p>J\'ai donc recherché les systèmes hydroponiques disponibles sur le marché ; j\'ai trouvé pas mal de systèmes clés en main, plus ou moins aboutis et plus ou moins chers. Pourtant, j\'ai décidé de construire moi-même mon premier système, pour plusieurs raisons :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Je suis convaincu que "mettre la main à la pâte" est souvent une bonne idée pour comprendre plus profondément un système technique,</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>j\'aime bien réaliser des prototypes en adaptant une solution technique existante à mon besoin personnel, cela m\'aide à  réfléchir à une généralisation possible les autres.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Taille du dispositif</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>On peut vouloir créer des fermes urbaines de taille plus ou moins importante, mais j\'ai décider de m\'intéresser à des dispositifs mis en œuvre à l\'échelle individuelle ou de proche voisinage, car cela représente des investissements réduits, une capacité de réalisation rapide et un investissement en temps acceptable. De plus, même si l\'ambition de tels systèmes n\'est pas de produire des bénéfices financiers, elle semble intéressante à l\'échelle de l\'individu ou du voisinage.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Bénéfices du système</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Voici plusieurs raisons pour mettre en place ce type de systèmes :</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading">Un mini-système hydroponique</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Durant l\'hiver 2021, j\'ai choisi de réaliser un système hydroponique vertical. Etant compétent en impression 3D, j\'ai décider de partir d\'un système déjà conçu, et de l\'adapter un peu.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>voici à quoi ce système ressemblait dans sa <a href="https://www.thingiverse.com/thing:3405964/">version originale</a> : </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:columns -->\n<div class="wp-block-columns"><!-- wp:column -->\n<div class="wp-block-column"><!-- wp:image {"width":535,"height":402,"sizeSlug":"large"} -->\n<figure class="wp-block-image size-large is-resized"><img src="https://cdn.thingiverse.com/renders/33/b6/37/85/85/59b0c38e5b805c7dd9b9f5abeee79ca0_preview_featured.jpg" alt="" style="width:535px;height:402px" width="535" height="402"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class="wp-block-column"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>La colonne est creuse est composée de modules empilables, ce qui permet de choisir le nombre de plantes</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>le réservoir en bas contient une pompe, cette dernière remonte l\'eau via un tuyau au centre de la tour jusqu\'à l\'étage supérieur qui et lui même percé de trous...</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>l\'eau passe par ces trous et redescend par gravité jusqu\'au réservoir, en arrosant au passage les racines des plantes maintenues en position dans des billes d\'argile dans les paniers amovibles (couleur ocre) installés dans la tour</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:paragraph -->\n<p>J\'ai du adapter le système de de fixation entre le bas de la tour et mon réservoirs, ainsi que certaines modifications mineures.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Au printemps 2022 J\'ai fabriqué et mis en service 4 systèmes modulaires hydroponiques (que l\'on pourrait les qualifier d\'aéro-hydroponiques). Ces systèmes avaient une forme de cylindre creux lequel étaient insérés des paniers contenant des billes d\'argile. En bas de la tour un réservoir de 10 à 20 litres dans lequel une pompe alimentait le haut de la tour par un tuyau, le liquide redescendant dans la tour en imprégnant les racines par gravité.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Le détail et les photos sont disponibles ici</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Les résultats étaient intéressants, j\'ai beaucoup appris de ce système. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p> </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Début 2022, j\'étais très motivé par les principes de l\'aquaponie. La nature symbiotique poissons + plantes, la création d\'un écosystème économe et vertueux, la double production poissons + plantes sur une surface réduite m\'ont donné très envie d\'aller voir de plus près ce genre de systèmes. J\'ai bien sur beaucoup cherché sur internet, vu des réalisations magnifiques (par exemple la chaine de <a href="https://www.youtube.com/@ChrisPagns">Chris Pagns</a> sur youtube).</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>A completer...</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Y sont présentées les activités de test et d\'apprentissage de ces techniques réalisées depuis le printemps 2022 à Saint-germain-en-Laye (78, Yvelines), Aix-en-Provence et Marseille (13, Bouches du Rhône). </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->','Bienvenue','','inherit','closed','closed','','2-revision-v1','','','2023-08-14 18:11:14','2023-08-14 16:11:14','',2,'https://hs.vicq.org/?p=84',0,'revision','',0);
INSERT INTO `hs_posts` VALUES (85,1,'2023-08-14 18:16:00','2023-08-14 16:16:00','<!-- wp:heading -->\n<h2 class="wp-block-heading">Ce blog est consacré à l\'hydroponie et la bioponie domestiques. </h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Ces deux techniques de culture font partie de la famille des cultures hors-sol sur substrat neutre. Elles consistent à faire pousser des plantes sans terre, sur un substrat neutre (billes d\'argile par exemple), en mettant en place un dispositif efficace pour leur fournir les nutriments nécessaire pour assurer une croissance efficace des racines et des plantes. La recirculation du liquide nutritif évite une grande partie de la consommation d\'eau qui est induite dans la culture en sol. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Origine du projet et cheminement</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>J\'ai commencé à m\'intéresser aux questions de culture urbaines pendant l\'épidémie de COVID. Cet épisode anxiogène m\'a fait m\'interroger sur certaines questions d\'organisation de la société, et aux risques associés à l\'approvisionnement en ville des denrées alimentaires. En effet, il semble qu\'en cas de gros dysfonctionnement de la logistique d\'approvisionnement en nourriture, en quelque jours les villes pourraient se retrouver privées d\'une partie importante de leurs ressources alimentaires. Face à cette potentielle fragilité des flux de transport, il semble intéressant de développer des dispositifs urbains assurant une partie (même réduite) de la production de légumes dans la ville. Des études sur ces sujets existent, mais je ne suis pas un spécialiste de la recherche en agriculture urbaine, j\'essayerai de faire un peu de bibliographie à ce sujet quand j\'aurai le temps.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>De plus, les questions d\'épuisement de la planète sont maintenant au centre des débats, et cultiver des légumes en étant économe en eau et en énergie est un sujet intéressant et prometteur pour les temps à venir.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Culture hors sol, définitions</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Le web pullule d\'explications sur ces techniques de culture hors sol. Vous pouvez trouver <a href="https://fermedecagnolle.fr/hydroponie-bioponie-aquaponie-definitions/"><strong>ici</strong></a> par exemple des définitions simples de l\'<strong>hydroponie</strong>, <strong>bioponie</strong> et <strong>aquaponie</strong> proposées par Marion Sarlé (<a href="https://lessourciers.com/fr/">les sourciers</a>). Marion Sarlé propose aussi le livre « <em><strong>Monter sa microferme en hydroponie, bioponie et aquaponie</strong></em> », en vente sur le site <a href="https://lessourciers.com/fr/livre-sourciers/">Les Sourciers</a> . Les sourciers proposent aussi des <a href="https://lessourciers.com/fr/les-formations/">formations</a> en ligne et dans leur ferme du Gers. J\'ai suivi la partie en ligne de la formation <a href="https://lessourciers.com/fr/les-formations/microferme-hydroponique/">Microferme Hydroponique</a> qui m\'a bien aidé à comprendre les rudiments de base.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Une fois ces grandes définitions comprises, on trouve de très facilement des informations sur les <strong><a href="https://jardinfute.com/culture-hors-sol/page/2/">nombreux types de dispositifs</a></strong> utilisés pour ce type de culture (ex : <a href="https://jardinfute.com/methode-kratky/">Kratky</a>, <a href="https://jardinfute.com/systeme-dwc-hydroponie/">DWC</a>, <a href="https://jardinfute.com/systeme-nft-hydroponie/">NFT</a>, <a href="https://jardinfute.com/table-a-maree-ebb-flow/">table à marée</a>, etc.). J\'ai choisi les explications sur le site <a href="https://jardinfute.com/">jardinfute.com</a>, mais vous trouverez facilement d\'autres systèmes et d\'autres explications sur internet.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Si l\'on évalue la complexité de ces techniques, on comprend que l\'<strong>hydroponie</strong> est la plus simple des trois, puisqu\'elle se base sur la circulation d\'une solution nutritive contenant des nutriments minéraux directement assimilables par les racines des plantes cultivées. En gros, il suffit de faire circuler de l\'eau additionnée d\'engrais sur les racines des plantes.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Quand on regarde les principes de la <strong>bioponie</strong> et l\'<strong>aquaponie</strong>, on comprend que le principe est plus complexe. Dans les deux cas on va transformer des éléments organiques en éléments minéraux pouvant être assimilés par les plantes (minéralisation). Cela est réalisé en deux étapes par l\'action de deux types de bactéries qui vont assurer tout d\'abord la transformation des éléments organiques en nitrites (bactéries <strong>Nitrosomonas</strong>) puis des nitrites en nitrates (bactéries <strong>Nitrobacter</strong>). Dans les deux cas, il faut offrir à ces bactéries un lieu et des conditions de vie, ce qui représente une complexité supplémentaire. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Enfin, pour l\'aquaponie il faut aussi s\'occuper de ses poissons, et en particulier gérer les caractéristiques de l\'eau. Des déséquilibres dans le système peuvent rapidement tuer une partie de votre cheptel, ce qui est un peu plus impactant que de voir mourir un pied de ciboulette.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Pour avoir les meilleures chances de réussite en limitant la complexité du savoir nécessaire, j\'ai choisi de commencer par l\'hydroponie.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Prototypes</h2>\n<!-- /wp:heading -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading">Etape 1 : 2021-2022, un petit système hydroponique</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Durant l\'hiver 2021, j\'ai fait des recherches des différents systèmes hydroponiques disponibles et de comment réaliser sois même ce genre de choses, et j\'ai été convaincu de l\'idée de commencer petit, afin de pouvoir planter dès le printemps 2022. Les retours d\'expérience unanimes des personnes expérimentées sont qu\'il faut commencer simple et petit. L\'idée de commencer avec un petit système simple n\'a, à mon avis, que des avantages pour quelqu\'un comme moi qui aime bricoler : </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Un petit prototype opérationnel est complet, donc on apprendra presque qu\'autant de choses que sur un plus gros système.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Le temps de développement est plus court, on aura ainsi plus de chances d\'aboutir dans des délais imposés par ses propres contraintes quotidiennes et l\'implacable chef d\'orchestre que sont les saisons. Par exemple, en France, il n\'est pas vraiment facile de planter des tomates à l\'automne, il faudra avoir été prêt pour le printemps, ou attendre le printemps suivant. </li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>On réduit le coût de fabrication, le risque financier et le temps passé si l\'on rate sa réalisation ou si on renonce avant la fin.</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:paragraph -->\n<p>J\'ai donc recherché les systèmes hydroponiques disponibles sur le marché ; j\'ai trouvé pas mal de systèmes clés en main, plus ou moins aboutis et plus ou moins chers. Pourtant, j\'ai décidé de construire moi-même mon premier système, pour plusieurs raisons :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Je suis convaincu que "mettre la main à la pâte" est souvent une bonne idée pour comprendre plus profondément un système technique,</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>j\'aime bien réaliser des prototypes en adaptant une solution technique existante à mon besoin personnel, cela m\'aide à  réfléchir à une généralisation possible les autres.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Taille du dispositif</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>On peut vouloir créer des fermes urbaines de taille plus ou moins importante, mais j\'ai décider de m\'intéresser à des dispositifs mis en œuvre à l\'échelle individuelle ou de proche voisinage, car cela représente des investissements réduits, une capacité de réalisation rapide et un investissement en temps acceptable. De plus, même si l\'ambition de tels systèmes n\'est pas de produire des bénéfices financiers, elle semble intéressante à l\'échelle de l\'individu ou du voisinage.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Bénéfices du système</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Voici plusieurs raisons pour mettre en place ce type de systèmes :</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading">Un mini-système hydroponique</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Durant l\'hiver 2021, j\'ai choisi de réaliser un système hydroponique vertical. Etant compétent en impression 3D, j\'ai décider de partir d\'un système déjà conçu, et de l\'adapter un peu.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>voici à quoi ce système ressemblait dans sa <a href="https://www.thingiverse.com/thing:3405964/">version originale</a> : </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:columns -->\n<div class="wp-block-columns"><!-- wp:column -->\n<div class="wp-block-column"><!-- wp:image {"width":535,"height":402,"sizeSlug":"large"} -->\n<figure class="wp-block-image size-large is-resized"><img src="https://cdn.thingiverse.com/renders/33/b6/37/85/85/59b0c38e5b805c7dd9b9f5abeee79ca0_preview_featured.jpg" alt="" style="width:535px;height:402px" width="535" height="402"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class="wp-block-column"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>La colonne est creuse est composée de modules empilables, ce qui permet de choisir le nombre de plantes</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>le réservoir en bas contient une pompe, cette dernière remonte l\'eau via un tuyau au centre de la tour jusqu\'à l\'étage supérieur qui et lui même percé de trous...</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>l\'eau passe par ces trous et redescend par gravité jusqu\'au réservoir, en arrosant au passage les racines des plantes maintenues en position dans des billes d\'argile dans les paniers amovibles (couleur ocre) installés dans la tour</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:paragraph -->\n<p>J\'ai du adapter le système de de fixation entre le bas de la tour et mon réservoirs, ainsi que certaines modifications mineures.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Au printemps 2022 J\'ai fabriqué et mis en service 4 systèmes modulaires hydroponiques (que l\'on pourrait les qualifier d\'aéro-hydroponiques). Ces systèmes avaient une forme de cylindre creux lequel étaient insérés des paniers contenant des billes d\'argile. En bas de la tour un réservoir de 10 à 20 litres dans lequel une pompe alimentait le haut de la tour par un tuyau, le liquide redescendant dans la tour en imprégnant les racines par gravité.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Le détail et les photos sont disponibles ici</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Les résultats étaient intéressants, j\'ai beaucoup appris de ce système. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p> </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Début 2022, j\'étais très motivé par les principes de l\'aquaponie. La nature symbiotique poissons + plantes, la création d\'un écosystème économe et vertueux, la double production poissons + plantes sur une surface réduite m\'ont donné très envie d\'aller voir de plus près ce genre de systèmes. J\'ai bien sur beaucoup cherché sur internet, vu des réalisations magnifiques (par exemple la chaine de <a href="https://www.youtube.com/@ChrisPagns">Chris Pagns</a> sur youtube).</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>A completer...</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Y sont présentées les activités de test et d\'apprentissage de ces techniques réalisées depuis le printemps 2022 à Saint-germain-en-Laye (78, Yvelines), Aix-en-Provence et Marseille (13, Bouches du Rhône). </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->','Bienvenue','','inherit','closed','closed','','2-revision-v1','','','2023-08-14 18:16:00','2023-08-14 16:16:00','',2,'https://hs.vicq.org/?p=85',0,'revision','',0);
INSERT INTO `hs_posts` VALUES (86,1,'2023-08-14 18:17:50','2023-08-14 16:17:50','<!-- wp:heading -->\n<h2 class="wp-block-heading">Ce blog est consacré à l\'hydroponie et la bioponie domestiques. </h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Ces deux techniques de culture font partie de la famille des cultures hors-sol sur substrat neutre. Elles consistent à faire pousser des plantes sans terre, sur un substrat neutre (billes d\'argile par exemple), en mettant en place un dispositif efficace pour leur fournir les nutriments nécessaire pour assurer une croissance efficace des racines et des plantes. La recirculation du liquide nutritif évite une grande partie de la consommation d\'eau qui est induite dans la culture en sol. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Origine du projet et cheminement</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>J\'ai commencé à m\'intéresser aux questions de culture urbaines pendant l\'épidémie de COVID. Cet épisode anxiogène m\'a fait m\'interroger sur certaines questions d\'organisation de la société, et aux risques associés à l\'approvisionnement en ville des denrées alimentaires. En effet, il semble qu\'en cas de gros dysfonctionnement de la logistique d\'approvisionnement en nourriture, en quelque jours les villes pourraient se retrouver privées d\'une partie importante de leurs ressources alimentaires. Face à cette potentielle fragilité des flux de transport, il semble intéressant de développer des dispositifs urbains assurant une partie (même réduite) de la production de légumes dans la ville. Des études sur ces sujets existent, mais je ne suis pas un spécialiste de la recherche en agriculture urbaine, j\'essayerai de faire un peu de bibliographie à ce sujet quand j\'aurai le temps.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>De plus, les questions d\'épuisement de la planète sont maintenant au centre des débats, et cultiver des légumes en étant économe en eau et en énergie est un sujet intéressant et prometteur pour les temps à venir.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Culture hors sol, définitions</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Le web pullule d\'explications sur ces techniques de culture hors sol. Vous pouvez trouver <a href="https://fermedecagnolle.fr/hydroponie-bioponie-aquaponie-definitions/"><strong>ici</strong></a> par exemple des définitions simples de l\'<strong>hydroponie</strong>, <strong>bioponie</strong> et <strong>aquaponie</strong> proposées par Marion Sarlé (<a href="https://lessourciers.com/fr/">les sourciers</a>). Marion Sarlé propose aussi le livre « <em><strong>Monter sa microferme en hydroponie, bioponie et aquaponie</strong></em> », en vente sur le site <a href="https://lessourciers.com/fr/livre-sourciers/">Les Sourciers</a> . Les sourciers proposent aussi des <a href="https://lessourciers.com/fr/les-formations/">formations</a> en ligne et dans leur ferme du Gers. J\'ai suivi la partie en ligne de la formation <a href="https://lessourciers.com/fr/les-formations/microferme-hydroponique/">Microferme Hydroponique</a> qui m\'a bien aidé à comprendre les rudiments de base.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Une fois ces grandes définitions comprises, on trouve de très facilement des informations sur les <strong><a href="https://jardinfute.com/culture-hors-sol/page/2/">nombreux types de dispositifs</a></strong> utilisés pour ce type de culture (ex : <a href="https://jardinfute.com/methode-kratky/">Kratky</a>, <a href="https://jardinfute.com/systeme-dwc-hydroponie/">DWC</a>, <a href="https://jardinfute.com/systeme-nft-hydroponie/">NFT</a>, <a href="https://jardinfute.com/table-a-maree-ebb-flow/">table à marée</a>, etc.). J\'ai choisi les explications sur le site <a href="https://jardinfute.com/">jardinfute.com</a>, mais vous trouverez facilement d\'autres systèmes et d\'autres explications sur internet.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Si l\'on évalue la complexité de ces techniques, on comprend que l\'<strong>hydroponie</strong> est la plus simple des trois, puisqu\'elle se base sur la circulation d\'une solution nutritive contenant des nutriments minéraux directement assimilables par les racines des plantes cultivées. En gros, il suffit de faire circuler de l\'eau additionnée d\'engrais sur les racines des plantes.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Quand on regarde les principes de la <strong>bioponie</strong> et l\'<strong>aquaponie</strong>, on comprend que le principe est plus complexe. Dans les deux cas on va transformer des éléments organiques en éléments minéraux pouvant être assimilés par les plantes (minéralisation). Cela est réalisé en deux étapes par l\'action de deux types de bactéries qui vont assurer tout d\'abord la transformation des éléments organiques en nitrites (bactéries <strong>Nitrosomonas</strong>) puis des nitrites en nitrates (bactéries <strong>Nitrobacter</strong>). Dans les deux cas, il faut offrir à ces bactéries un lieu et des conditions de vie, ce qui représente une complexité supplémentaire. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Enfin, pour l\'aquaponie il faut aussi s\'occuper de ses poissons, et en particulier gérer les caractéristiques de l\'eau. Des déséquilibres dans le système peuvent rapidement tuer une partie de votre cheptel, ce qui est un peu plus impactant que de voir mourir un pied de ciboulette.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Pour avoir les meilleures chances de réussite en limitant la complexité du savoir nécessaire, j\'ai choisi de commencer par l\'hydroponie.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Prototypes</h2>\n<!-- /wp:heading -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading">Etape 1 : 2021-2022, un petit système hydroponique</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Durant l\'hiver 2021, j\'ai fait des recherches des différents systèmes hydroponiques disponibles et de comment réaliser sois-même ce genre de choses, et j\'ai été rapidement convaincu de l\'idée de commencer petit, afin d\'être prêt et de pouvoir planter dès le printemps 2022. Le retour d\'expérience des personnes expérimentées est unanime : il faut commencer simple et petit. L\'idée de commencer avec un petit système simple n\'a que des avantages pour quelqu\'un comme moi qui aime bricoler : </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Un petit prototype opérationnel est complet, donc on apprendra presque qu\'autant de choses que sur un plus gros système.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Le temps de développement est plus court, on aura ainsi plus de chances d\'aboutir dans des délais imposés par ses propres contraintes quotidiennes et l\'implacable chef d\'orchestre que sont les saisons. Par exemple, en France, il n\'est pas vraiment facile de planter des tomates à l\'automne, il faudra avoir été prêt pour le printemps, ou attendre le printemps suivant. </li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>On réduit le coût de fabrication, le risque financier et le temps passé si l\'on rate sa réalisation ou si on renonce avant la fin.</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:paragraph -->\n<p>J\'ai donc recherché les systèmes hydroponiques disponibles sur le marché ; j\'ai trouvé pas mal de systèmes clés en main, plus ou moins aboutis et plus ou moins chers. Pourtant, j\'ai décidé de construire moi-même mon premier système, pour plusieurs raisons :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Je suis convaincu que "mettre la main à la pâte" est souvent une bonne idée pour comprendre plus profondément un système technique,</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>j\'aime bien réaliser des prototypes en adaptant une solution technique existante à mon besoin personnel, cela m\'aide à  réfléchir à une généralisation possible les autres.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Taille du dispositif</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>On peut vouloir créer des fermes urbaines de taille plus ou moins importante, mais j\'ai décider de m\'intéresser à des dispositifs mis en œuvre à l\'échelle individuelle ou de proche voisinage, car cela représente des investissements réduits, une capacité de réalisation rapide et un investissement en temps acceptable. De plus, même si l\'ambition de tels systèmes n\'est pas de produire des bénéfices financiers, elle semble intéressante à l\'échelle de l\'individu ou du voisinage.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Bénéfices du système</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Voici plusieurs raisons pour mettre en place ce type de systèmes :</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading">Un mini-système hydroponique</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Durant l\'hiver 2021, j\'ai choisi de réaliser un système hydroponique vertical. Etant compétent en impression 3D, j\'ai décider de partir d\'un système déjà conçu, et de l\'adapter un peu.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>voici à quoi ce système ressemblait dans sa <a href="https://www.thingiverse.com/thing:3405964/">version originale</a> : </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:columns -->\n<div class="wp-block-columns"><!-- wp:column -->\n<div class="wp-block-column"><!-- wp:image {"width":535,"height":402,"sizeSlug":"large"} -->\n<figure class="wp-block-image size-large is-resized"><img src="https://cdn.thingiverse.com/renders/33/b6/37/85/85/59b0c38e5b805c7dd9b9f5abeee79ca0_preview_featured.jpg" alt="" style="width:535px;height:402px" width="535" height="402"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class="wp-block-column"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>La colonne est creuse est composée de modules empilables, ce qui permet de choisir le nombre de plantes</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>le réservoir en bas contient une pompe, cette dernière remonte l\'eau via un tuyau au centre de la tour jusqu\'à l\'étage supérieur qui et lui même percé de trous...</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>l\'eau passe par ces trous et redescend par gravité jusqu\'au réservoir, en arrosant au passage les racines des plantes maintenues en position dans des billes d\'argile dans les paniers amovibles (couleur ocre) installés dans la tour</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:paragraph -->\n<p>J\'ai du adapter le système de de fixation entre le bas de la tour et mon réservoirs, ainsi que certaines modifications mineures.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Au printemps 2022 J\'ai fabriqué et mis en service 4 systèmes modulaires hydroponiques (que l\'on pourrait les qualifier d\'aéro-hydroponiques). Ces systèmes avaient une forme de cylindre creux lequel étaient insérés des paniers contenant des billes d\'argile. En bas de la tour un réservoir de 10 à 20 litres dans lequel une pompe alimentait le haut de la tour par un tuyau, le liquide redescendant dans la tour en imprégnant les racines par gravité.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Le détail et les photos sont disponibles ici</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Les résultats étaient intéressants, j\'ai beaucoup appris de ce système. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p> </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Début 2022, j\'étais très motivé par les principes de l\'aquaponie. La nature symbiotique poissons + plantes, la création d\'un écosystème économe et vertueux, la double production poissons + plantes sur une surface réduite m\'ont donné très envie d\'aller voir de plus près ce genre de systèmes. J\'ai bien sur beaucoup cherché sur internet, vu des réalisations magnifiques (par exemple la chaine de <a href="https://www.youtube.com/@ChrisPagns">Chris Pagns</a> sur youtube).</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>A completer...</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Y sont présentées les activités de test et d\'apprentissage de ces techniques réalisées depuis le printemps 2022 à Saint-germain-en-Laye (78, Yvelines), Aix-en-Provence et Marseille (13, Bouches du Rhône). </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->','Bienvenue','','inherit','closed','closed','','2-revision-v1','','','2023-08-14 18:17:50','2023-08-14 16:17:50','',2,'https://hs.vicq.org/?p=86',0,'revision','',0);
INSERT INTO `hs_posts` VALUES (89,1,'2023-08-20 18:22:41','2023-08-20 16:22:41','<!-- wp:heading -->\n<h2 class="wp-block-heading">Ce blog est consacré à l\'hydroponie et la bioponie domestiques. </h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Ces deux techniques de culture font partie de la famille des cultures hors-sol sur substrat neutre. Elles consistent à faire pousser des plantes sans terre, sur un substrat neutre (billes d\'argile par exemple), en mettant en place un dispositif efficace pour leur fournir les nutriments nécessaire pour assurer une croissance efficace des racines et des plantes. La recirculation du liquide nutritif évite une grande partie de la consommation d\'eau qui est induite dans la culture en sol. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Origine du projet et cheminement</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>J\'ai commencé à m\'intéresser aux questions de culture urbaines pendant l\'épidémie de COVID. Cet épisode anxiogène m\'a fait m\'interroger sur certaines questions d\'organisation de la société, et aux risques associés à l\'approvisionnement en ville des denrées alimentaires. En effet, il semble qu\'en cas de gros dysfonctionnement de la logistique d\'approvisionnement en nourriture, en quelque jours les villes pourraient se retrouver privées d\'une partie importante de leurs ressources alimentaires. Face à cette potentielle fragilité des flux de transport, il semble intéressant de développer des dispositifs urbains assurant une partie (même réduite) de la production de légumes dans la ville. Des études sur ces sujets existent, mais je ne suis pas un spécialiste de la recherche en agriculture urbaine, j\'essayerai de faire un peu de bibliographie à ce sujet quand j\'aurai le temps.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>De plus, les questions d\'épuisement de la planète sont maintenant au centre des débats, et cultiver des légumes en étant économe en eau et en énergie est un sujet qui m\'intéresse et me semble prometteur pour les temps qui viennent.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Culture hors sol, définitions</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Le web pullule d\'explications sur ces techniques de culture hors sol. Vous pouvez trouver <a href="https://fermedecagnolle.fr/hydroponie-bioponie-aquaponie-definitions/"><strong>ici</strong></a> par exemple des définitions simples de l\'<strong>hydroponie</strong>, <strong>bioponie</strong> et <strong>aquaponie</strong> proposées par Marion Sarlé (<a href="https://lessourciers.com/fr/">les sourciers</a>). Marion Sarlé propose aussi le livre «&nbsp;<em><strong>Monter sa microferme en hydroponie, bioponie et aquaponie</strong></em>&nbsp;», en vente sur le site <a href="https://lessourciers.com/fr/livre-sourciers/">Les Sourciers</a>&nbsp;. Les sourciers proposent aussi des <a href="https://lessourciers.com/fr/les-formations/">formations</a> en ligne et dans leur ferme du Gers. J\'ai suivi la partie en ligne de la formation <a href="https://lessourciers.com/fr/les-formations/microferme-hydroponique/">Microferme Hydroponique</a> qui m\'a bien aidé à comprendre les rudiments de base.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Une fois ces grandes définitions comprises, on trouve de très facilement des informations sur les <strong><a href="https://jardinfute.com/culture-hors-sol/page/2/">nombreux types de dispositifs</a></strong> utilisés pour ce type de culture (ex : <a href="https://jardinfute.com/methode-kratky/">Kratky</a>, <a href="https://jardinfute.com/systeme-dwc-hydroponie/">DWC</a>, <a href="https://jardinfute.com/systeme-nft-hydroponie/">NFT</a>, <a href="https://jardinfute.com/table-a-maree-ebb-flow/">table à marée</a>, etc.). J\'ai choisi les explications sur le site <a href="https://jardinfute.com/">jardinfute.com</a>, mais vous trouverez facilement d\'autres systèmes et d\'autres explications sur internet.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Si l\'on évalue la complexité de ces techniques, on comprend que l\'<strong>hydroponie</strong> est la plus simple des trois, puisqu\'elle se base sur la circulation d\'une solution nutritive contenant des nutriments minéraux (engrais) directement assimilables par les racines des plantes cultivées. En gros, il suffit de faire circuler de l\'eau additionnée d\'engrais sur les racines des plantes.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Quand on regarde les principes de la <strong>bioponie</strong> et l\'<strong>aquaponie</strong>, on comprend que le principe est plus complexe. Dans les deux cas on va transformer des éléments organiques en éléments minéraux pouvant être assimilés par les plantes (minéralisation). Cela est réalisé en deux étapes par l\'action de deux types de bactéries qui vont assurer tout d\'abord la transformation des éléments organiques en nitrites (bactéries <strong>Nitrosomonas</strong>) puis des nitrites en nitrates (bactéries <strong>Nitrobacter</strong>). Dans les deux cas, il faut offrir à ces bactéries un lieu et des conditions de vie, ce qui représente une complexité supplémentaire. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Enfin, pour l\'aquaponie il faut aussi s\'occuper de ses poissons, et en particulier gérer les caractéristiques de l\'eau. Des déséquilibres dans le système peuvent rapidement tuer une partie de votre cheptel, ce qui est un peu plus impactant que de voir mourir un pied de ciboulette.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Pour avoir les meilleures chances de réussite en limitant la complexité du savoir nécessaire, j\'ai choisi de commencer par l\'hydroponie.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Prototypes</h2>\n<!-- /wp:heading -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading">Etape 1 : 2021-2022, un petit système hydroponique</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Durant l\'hiver 2021, j\'ai fait des recherches des différents systèmes hydroponiques disponibles et de comment réaliser sois-même ce genre de choses, et j\'ai été rapidement convaincu de l\'idée de commencer petit, afin d\'être prêt et de pouvoir planter dès le printemps 2022. Le retour d\'expérience des personnes expérimentées est unanime : il faut commencer simple et petit. L\'idée de commencer avec un petit système simple n\'a que des avantages pour quelqu\'un comme moi qui aime bricoler : </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Un petit prototype opérationnel est complet, donc on apprendra presque qu\'autant de choses que sur un plus gros système.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Le temps de développement est plus court, on aura ainsi plus de chances d\'aboutir dans des délais imposés par ses propres contraintes quotidiennes et l\'implacable chef d\'orchestre que sont les saisons. Par exemple, en France, il n\'est pas vraiment facile de planter des tomates à l\'automne, il faudra avoir été prêt pour le printemps, ou attendre le printemps suivant. </li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>On réduit le coût de fabrication, le risque financier et le temps passé si l\'on rate sa réalisation ou si on renonce avant la fin.</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:paragraph -->\n<p>J\'ai donc recherché les systèmes hydroponiques disponibles sur le marché ; j\'ai trouvé pas mal de systèmes clés en main, plus ou moins aboutis et plus ou moins chers. Pourtant, j\'ai décidé de construire moi-même mon premier système, pour plusieurs raisons :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Je suis convaincu que "mettre la main à la pâte" est souvent une bonne idée pour comprendre plus profondément un système technique,</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>j\'aime bien réaliser des prototypes en adaptant une solution technique existante à mon besoin personnel, cela m\'aide à  réfléchir à une généralisation possible les autres.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Taille du dispositif</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>On peut vouloir créer des fermes urbaines de taille plus ou moins importante, mais j\'ai décider de m\'intéresser à des dispositifs mis en œuvre à l\'échelle individuelle ou de proche voisinage, car cela représente des investissements réduits, une capacité de réalisation rapide et un investissement en temps acceptable. De plus, même si l\'ambition de tels systèmes n\'est pas de produire des bénéfices financiers, elle semble intéressante à l\'échelle de l\'individu ou du voisinage.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Bénéfices du système</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Voici plusieurs raisons pour mettre en place ce type de systèmes :</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading">Un mini-système hydroponique</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Durant l\'hiver 2021, j\'ai choisi de réaliser un système hydroponique vertical. Etant compétent en impression 3D, j\'ai décider de partir d\'un système déjà conçu, et de l\'adapter un peu.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>voici à quoi ce système ressemblait dans sa <a href="https://www.thingiverse.com/thing:3405964/">version originale</a> : </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:columns -->\n<div class="wp-block-columns"><!-- wp:column -->\n<div class="wp-block-column"><!-- wp:image {"width":535,"height":402,"sizeSlug":"large"} -->\n<figure class="wp-block-image size-large is-resized"><img src="https://cdn.thingiverse.com/renders/33/b6/37/85/85/59b0c38e5b805c7dd9b9f5abeee79ca0_preview_featured.jpg" alt="" style="width:535px;height:402px" width="535" height="402"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class="wp-block-column"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>La colonne est creuse est composée de modules empilables, ce qui permet de choisir le nombre de plantes</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>le réservoir en bas contient une pompe, cette dernière remonte l\'eau via un tuyau au centre de la tour jusqu\'à l\'étage supérieur qui et lui même percé de trous...</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>l\'eau passe par ces trous et redescend par gravité jusqu\'au réservoir, en arrosant au passage les racines des plantes maintenues en position dans des billes d\'argile dans les paniers amovibles (couleur ocre) installés dans la tour</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:paragraph -->\n<p>J\'ai du adapter le système de de fixation entre le bas de la tour et mon réservoirs, ainsi que certaines modifications mineures.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Au printemps 2022 J\'ai fabriqué et mis en service 4 systèmes modulaires hydroponiques (que l\'on pourrait les qualifier d\'aéro-hydroponiques). Ces systèmes avaient une forme de cylindre creux lequel étaient insérés des paniers contenant des billes d\'argile. En bas de la tour un réservoir de 10 à 20 litres dans lequel une pompe alimentait le haut de la tour par un tuyau, le liquide redescendant dans la tour en imprégnant les racines par gravité.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Le détail et les photos sont disponibles ici</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Les résultats étaient intéressants, j\'ai beaucoup appris de ce système. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p> </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Début 2022, j\'étais très motivé par les principes de l\'aquaponie. La nature symbiotique poissons + plantes, la création d\'un écosystème économe et vertueux, la double production poissons + plantes sur une surface réduite m\'ont donné très envie d\'aller voir de plus près ce genre de systèmes. J\'ai bien sur beaucoup cherché sur internet, vu des réalisations magnifiques (par exemple la chaine de <a href="https://www.youtube.com/@ChrisPagns">Chris Pagns</a> sur youtube).</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>A completer...</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Y sont présentées les activités de test et d\'apprentissage de ces techniques réalisées depuis le printemps 2022 à Saint-germain-en-Laye (78, Yvelines), Aix-en-Provence et Marseille (13, Bouches du Rhône). </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->','Bienvenue','','inherit','closed','closed','','2-revision-v1','','','2023-08-20 18:22:41','2023-08-20 16:22:41','',2,'http://hs.vicq.org/?p=89',0,'revision','',0);
INSERT INTO `hs_posts` VALUES (90,1,'2023-08-20 18:23:36','2023-08-20 16:23:36','<!-- wp:heading -->\n<h2 class="wp-block-heading">Ce blog est consacré à l\'hydroponie et la bioponie domestiques. </h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Ces deux techniques de culture font partie de la famille des cultures hors-sol sur substrat neutre. Elles consistent à faire pousser des plantes sans terre, sur un substrat neutre (billes d\'argile par exemple), en mettant en place un dispositif efficace pour leur fournir les nutriments nécessaire pour assurer une croissance efficace des racines et des plantes. La recirculation du liquide nutritif évite une grande partie de la consommation d\'eau qui est induite dans la culture en sol. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Origine du projet et cheminement</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>J\'ai commencé à m\'intéresser aux questions de culture urbaines pendant l\'épidémie de COVID. Cet épisode anxiogène m\'a fait m\'interroger sur certaines questions d\'organisation de la société, et aux risques associés à l\'approvisionnement en ville des denrées alimentaires. En effet, il semble qu\'en cas de gros dysfonctionnement de la logistique d\'approvisionnement en nourriture, en quelque jours les villes pourraient se retrouver privées d\'une partie importante de leurs ressources alimentaires. Face à cette potentielle fragilité des flux de transport, il semble intéressant de développer des dispositifs urbains assurant une partie (même réduite) de la production de légumes dans la ville. Des études sur ces sujets existent, mais je ne suis pas un spécialiste de la recherche en agriculture urbaine, j\'essayerai de faire un peu de bibliographie à ce sujet quand j\'aurai le temps.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>De plus, les questions d\'épuisement de la planète sont maintenant au centre des débats, et cultiver des légumes en étant économe en eau et en énergie est un sujet qui m\'intéresse et me semble prometteur pour les temps qui viennent.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Culture hors sol, définitions</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Le web pullule d\'explications sur ces techniques de culture hors sol. Vous pouvez trouver <a href="https://fermedecagnolle.fr/hydroponie-bioponie-aquaponie-definitions/"><strong>ici</strong></a> par exemple des définitions simples de l\'<strong>hydroponie</strong>, <strong>bioponie</strong> et <strong>aquaponie</strong> proposées par Marion Sarlé (<a href="https://lessourciers.com/fr/">les sourciers</a>). Marion Sarlé propose aussi le livre «&nbsp;<em><strong>Monter sa microferme en hydroponie, bioponie et aquaponie</strong></em>&nbsp;», en vente sur le site <a href="https://lessourciers.com/fr/livre-sourciers/">Les Sourciers</a>&nbsp;. Les sourciers proposent aussi des <a href="https://lessourciers.com/fr/les-formations/">formations</a> en ligne et dans leur ferme du Gers. J\'ai suivi la partie en ligne de la formation <a href="https://lessourciers.com/fr/les-formations/microferme-hydroponique/">Microferme Hydroponique</a> qui m\'a bien aidé à comprendre les rudiments de base.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Une fois ces grandes définitions comprises, on trouve de très facilement des informations sur les <strong><a href="https://jardinfute.com/culture-hors-sol/page/2/">nombreux types de dispositifs</a></strong> utilisés pour ce type de culture (ex : <a href="https://jardinfute.com/methode-kratky/">Kratky</a>, <a href="https://jardinfute.com/systeme-dwc-hydroponie/">DWC</a>, <a href="https://jardinfute.com/systeme-nft-hydroponie/">NFT</a>, <a href="https://jardinfute.com/table-a-maree-ebb-flow/">table à marée</a>, etc.). J\'ai choisi les explications sur le site <a href="https://jardinfute.com/">jardinfute.com</a>, mais vous trouverez facilement d\'autres systèmes et d\'autres explications sur internet.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Si l\'on évalue la complexité de ces techniques, on comprend que l\'<strong>hydroponie</strong> est la plus simple des trois, puisqu\'elle se base sur la circulation d\'une solution nutritive contenant des nutriments minéraux (engrais) directement assimilables par les racines des plantes cultivées. En gros, il suffit de faire circuler de l\'eau additionnée d\'engrais sur les racines des plantes.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Quand on regarde les principes de la <strong>bioponie</strong> et l\'<strong>aquaponie</strong>, on comprend que le principe est plus complexe. Dans les deux cas on va transformer des éléments organiques en éléments minéraux pouvant être assimilés par les plantes (minéralisation). Cela est réalisé en deux étapes par l\'action de deux types de bactéries qui vont assurer tout d\'abord la transformation des éléments organiques en nitrites (bactéries <strong>Nitrosomonas</strong>) puis des nitrites en nitrates (bactéries <strong>Nitrobacter</strong>). Dans les deux cas, il faut offrir à ces bactéries un lieu et des conditions de vie, ce qui représente une complexité supplémentaire. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Enfin, pour l\'<strong>aquaponie</strong> il faut aussi s\'occuper de ses poissons, et en particulier gérer les caractéristiques de l\'eau. Des déséquilibres dans le système peuvent rapidement tuer une partie du cheptel, ce qui est plus impactant que de voir mourir un pied de ciboulette.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Pour avoir les meilleures chances de réussite en limitant la complexité du savoir nécessaire, j\'ai choisi de commencer par l\'hydroponie.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Prototypes</h2>\n<!-- /wp:heading -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading">Etape 1 : 2021-2022, un petit système hydroponique</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Durant l\'hiver 2021, j\'ai fait des recherches des différents systèmes hydroponiques disponibles et de comment réaliser sois-même ce genre de choses, et j\'ai été rapidement convaincu de l\'idée de commencer petit, afin d\'être prêt et de pouvoir planter dès le printemps 2022. Le retour d\'expérience des personnes expérimentées est unanime : il faut commencer simple et petit. L\'idée de commencer avec un petit système simple n\'a que des avantages pour quelqu\'un comme moi qui aime bricoler : </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Un petit prototype opérationnel est complet, donc on apprendra presque qu\'autant de choses que sur un plus gros système.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Le temps de développement est plus court, on aura ainsi plus de chances d\'aboutir dans des délais imposés par ses propres contraintes quotidiennes et l\'implacable chef d\'orchestre que sont les saisons. Par exemple, en France, il n\'est pas vraiment facile de planter des tomates à l\'automne, il faudra avoir été prêt pour le printemps, ou attendre le printemps suivant. </li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>On réduit le coût de fabrication, le risque financier et le temps passé si l\'on rate sa réalisation ou si on renonce avant la fin.</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:paragraph -->\n<p>J\'ai donc recherché les systèmes hydroponiques disponibles sur le marché ; j\'ai trouvé pas mal de systèmes clés en main, plus ou moins aboutis et plus ou moins chers. Pourtant, j\'ai décidé de construire moi-même mon premier système, pour plusieurs raisons :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Je suis convaincu que "mettre la main à la pâte" est souvent une bonne idée pour comprendre plus profondément un système technique,</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>j\'aime bien réaliser des prototypes en adaptant une solution technique existante à mon besoin personnel, cela m\'aide à  réfléchir à une généralisation possible les autres.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Taille du dispositif</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>On peut vouloir créer des fermes urbaines de taille plus ou moins importante, mais j\'ai décider de m\'intéresser à des dispositifs mis en œuvre à l\'échelle individuelle ou de proche voisinage, car cela représente des investissements réduits, une capacité de réalisation rapide et un investissement en temps acceptable. De plus, même si l\'ambition de tels systèmes n\'est pas de produire des bénéfices financiers, elle semble intéressante à l\'échelle de l\'individu ou du voisinage.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Bénéfices du système</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Voici plusieurs raisons pour mettre en place ce type de systèmes :</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading">Un mini-système hydroponique</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Durant l\'hiver 2021, j\'ai choisi de réaliser un système hydroponique vertical. Etant compétent en impression 3D, j\'ai décider de partir d\'un système déjà conçu, et de l\'adapter un peu.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>voici à quoi ce système ressemblait dans sa <a href="https://www.thingiverse.com/thing:3405964/">version originale</a> : </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:columns -->\n<div class="wp-block-columns"><!-- wp:column -->\n<div class="wp-block-column"><!-- wp:image {"width":535,"height":402,"sizeSlug":"large"} -->\n<figure class="wp-block-image size-large is-resized"><img src="https://cdn.thingiverse.com/renders/33/b6/37/85/85/59b0c38e5b805c7dd9b9f5abeee79ca0_preview_featured.jpg" alt="" style="width:535px;height:402px" width="535" height="402"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class="wp-block-column"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>La colonne est creuse est composée de modules empilables, ce qui permet de choisir le nombre de plantes</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>le réservoir en bas contient une pompe, cette dernière remonte l\'eau via un tuyau au centre de la tour jusqu\'à l\'étage supérieur qui et lui même percé de trous...</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>l\'eau passe par ces trous et redescend par gravité jusqu\'au réservoir, en arrosant au passage les racines des plantes maintenues en position dans des billes d\'argile dans les paniers amovibles (couleur ocre) installés dans la tour</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:paragraph -->\n<p>J\'ai du adapter le système de de fixation entre le bas de la tour et mon réservoirs, ainsi que certaines modifications mineures.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Au printemps 2022 J\'ai fabriqué et mis en service 4 systèmes modulaires hydroponiques (que l\'on pourrait les qualifier d\'aéro-hydroponiques). Ces systèmes avaient une forme de cylindre creux lequel étaient insérés des paniers contenant des billes d\'argile. En bas de la tour un réservoir de 10 à 20 litres dans lequel une pompe alimentait le haut de la tour par un tuyau, le liquide redescendant dans la tour en imprégnant les racines par gravité.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Le détail et les photos sont disponibles ici</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Les résultats étaient intéressants, j\'ai beaucoup appris de ce système. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p> </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Début 2022, j\'étais très motivé par les principes de l\'aquaponie. La nature symbiotique poissons + plantes, la création d\'un écosystème économe et vertueux, la double production poissons + plantes sur une surface réduite m\'ont donné très envie d\'aller voir de plus près ce genre de systèmes. J\'ai bien sur beaucoup cherché sur internet, vu des réalisations magnifiques (par exemple la chaine de <a href="https://www.youtube.com/@ChrisPagns">Chris Pagns</a> sur youtube).</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>A completer...</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Y sont présentées les activités de test et d\'apprentissage de ces techniques réalisées depuis le printemps 2022 à Saint-germain-en-Laye (78, Yvelines), Aix-en-Provence et Marseille (13, Bouches du Rhône). </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->','Bienvenue','','inherit','closed','closed','','2-revision-v1','','','2023-08-20 18:23:36','2023-08-20 16:23:36','',2,'http://hs.vicq.org/?p=90',0,'revision','',0);
INSERT INTO `hs_posts` VALUES (91,1,'2023-08-20 18:23:55','2023-08-20 16:23:55','<!-- wp:heading -->\n<h2 class="wp-block-heading">Ce blog est consacré à l\'hydroponie et la bioponie domestiques. </h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Ces deux techniques de culture font partie de la famille des cultures hors-sol sur substrat neutre. Elles consistent à faire pousser des plantes sans terre, sur un substrat neutre (billes d\'argile par exemple), en mettant en place un dispositif efficace pour leur fournir les nutriments nécessaire pour assurer une croissance efficace des racines et des plantes. La recirculation du liquide nutritif évite une grande partie de la consommation d\'eau qui est induite dans la culture en sol. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Origine du projet et cheminement</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>J\'ai commencé à m\'intéresser aux questions de culture urbaines pendant l\'épidémie de COVID. Cet épisode anxiogène m\'a fait m\'interroger sur certaines questions d\'organisation de la société, et aux risques associés à l\'approvisionnement en ville des denrées alimentaires. En effet, il semble qu\'en cas de gros dysfonctionnement de la logistique d\'approvisionnement en nourriture, en quelque jours les villes pourraient se retrouver privées d\'une partie importante de leurs ressources alimentaires. Face à cette potentielle fragilité des flux de transport, il semble intéressant de développer des dispositifs urbains assurant une partie (même réduite) de la production de légumes dans la ville. Des études sur ces sujets existent, mais je ne suis pas un spécialiste de la recherche en agriculture urbaine, j\'essayerai de faire un peu de bibliographie à ce sujet quand j\'aurai le temps.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>De plus, les questions d\'épuisement de la planète sont maintenant au centre des débats, et cultiver des légumes en étant économe en eau et en énergie est un sujet qui m\'intéresse et me semble prometteur pour les temps qui viennent.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Culture hors sol, définitions</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Le web pullule d\'explications sur ces techniques de culture hors sol. Vous pouvez trouver <a href="https://fermedecagnolle.fr/hydroponie-bioponie-aquaponie-definitions/"><strong>ici</strong></a> par exemple des définitions simples de l\'<strong>hydroponie</strong>, <strong>bioponie</strong> et <strong>aquaponie</strong> proposées par Marion Sarlé (<a href="https://lessourciers.com/fr/">les sourciers</a>). Marion Sarlé propose aussi le livre «&nbsp;<em><strong>Monter sa microferme en hydroponie, bioponie et aquaponie</strong></em>&nbsp;», en vente sur le site <a href="https://lessourciers.com/fr/livre-sourciers/">Les Sourciers</a>&nbsp;. Les sourciers proposent aussi des <a href="https://lessourciers.com/fr/les-formations/">formations</a> en ligne et dans leur ferme du Gers. J\'ai suivi la partie en ligne de la formation <a href="https://lessourciers.com/fr/les-formations/microferme-hydroponique/">Microferme Hydroponique</a> qui m\'a bien aidé à comprendre les rudiments de base.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Une fois ces grandes définitions comprises, on trouve de très facilement des informations sur les <strong><a href="https://jardinfute.com/culture-hors-sol/page/2/">nombreux types de dispositifs</a></strong> utilisés pour ce type de culture (ex : <a href="https://jardinfute.com/methode-kratky/">Kratky</a>, <a href="https://jardinfute.com/systeme-dwc-hydroponie/">DWC</a>, <a href="https://jardinfute.com/systeme-nft-hydroponie/">NFT</a>, <a href="https://jardinfute.com/table-a-maree-ebb-flow/">table à marée</a>, etc.). J\'ai choisi les explications sur le site <a href="https://jardinfute.com/">jardinfute.com</a>, mais vous trouverez facilement d\'autres systèmes et d\'autres explications sur internet.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Si l\'on évalue la complexité de ces techniques, on comprend que l\'<strong>hydroponie</strong> est la plus simple des trois, puisqu\'elle se base sur la circulation d\'une solution nutritive contenant des nutriments minéraux (engrais) directement assimilables par les racines des plantes cultivées. En gros, il suffit de faire circuler de l\'eau additionnée d\'engrais sur les racines des plantes.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Quand on regarde les principes de la <strong>bioponie</strong> et l\'<strong>aquaponie</strong>, on comprend que le principe est plus complexe. Dans les deux cas on va transformer des éléments organiques en éléments minéraux pouvant être assimilés par les plantes (minéralisation). Cela est réalisé en deux étapes par l\'action de deux types de bactéries qui vont assurer tout d\'abord la transformation des éléments organiques en nitrites (bactéries <strong>Nitrosomonas</strong>) puis des nitrites en nitrates (bactéries <strong>Nitrobacter</strong>). Dans les deux cas, il faut offrir à ces bactéries un lieu et des conditions de vie, ce qui représente une complexité supplémentaire. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Enfin, pour l\'<strong>aquaponie</strong> il faut aussi s\'occuper de ses poissons, et en particulier gérer les caractéristiques de l\'eau. Des déséquilibres dans le système peuvent rapidement tuer une partie du cheptel, ce qui est plus impactant que de voir mourir un pied de ciboulette.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Pour avoir les meilleures chances de réussite en limitant la complexité du savoir nécessaire et m\'y mettre rapidement, j\'ai choisi de commencer par l\'hydroponie.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Prototypes</h2>\n<!-- /wp:heading -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading">Etape 1 : 2021-2022, un petit système hydroponique</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Durant l\'hiver 2021, j\'ai fait des recherches des différents systèmes hydroponiques disponibles et de comment réaliser sois-même ce genre de choses, et j\'ai été rapidement convaincu de l\'idée de commencer petit, afin d\'être prêt et de pouvoir planter dès le printemps 2022. Le retour d\'expérience des personnes expérimentées est unanime : il faut commencer simple et petit. L\'idée de commencer avec un petit système simple n\'a que des avantages pour quelqu\'un comme moi qui aime bricoler : </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Un petit prototype opérationnel est complet, donc on apprendra presque qu\'autant de choses que sur un plus gros système.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Le temps de développement est plus court, on aura ainsi plus de chances d\'aboutir dans des délais imposés par ses propres contraintes quotidiennes et l\'implacable chef d\'orchestre que sont les saisons. Par exemple, en France, il n\'est pas vraiment facile de planter des tomates à l\'automne, il faudra avoir été prêt pour le printemps, ou attendre le printemps suivant. </li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>On réduit le coût de fabrication, le risque financier et le temps passé si l\'on rate sa réalisation ou si on renonce avant la fin.</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:paragraph -->\n<p>J\'ai donc recherché les systèmes hydroponiques disponibles sur le marché ; j\'ai trouvé pas mal de systèmes clés en main, plus ou moins aboutis et plus ou moins chers. Pourtant, j\'ai décidé de construire moi-même mon premier système, pour plusieurs raisons :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Je suis convaincu que "mettre la main à la pâte" est souvent une bonne idée pour comprendre plus profondément un système technique,</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>j\'aime bien réaliser des prototypes en adaptant une solution technique existante à mon besoin personnel, cela m\'aide à  réfléchir à une généralisation possible les autres.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Taille du dispositif</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>On peut vouloir créer des fermes urbaines de taille plus ou moins importante, mais j\'ai décider de m\'intéresser à des dispositifs mis en œuvre à l\'échelle individuelle ou de proche voisinage, car cela représente des investissements réduits, une capacité de réalisation rapide et un investissement en temps acceptable. De plus, même si l\'ambition de tels systèmes n\'est pas de produire des bénéfices financiers, elle semble intéressante à l\'échelle de l\'individu ou du voisinage.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Bénéfices du système</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Voici plusieurs raisons pour mettre en place ce type de systèmes :</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading">Un mini-système hydroponique</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Durant l\'hiver 2021, j\'ai choisi de réaliser un système hydroponique vertical. Etant compétent en impression 3D, j\'ai décider de partir d\'un système déjà conçu, et de l\'adapter un peu.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>voici à quoi ce système ressemblait dans sa <a href="https://www.thingiverse.com/thing:3405964/">version originale</a> : </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:columns -->\n<div class="wp-block-columns"><!-- wp:column -->\n<div class="wp-block-column"><!-- wp:image {"width":535,"height":402,"sizeSlug":"large"} -->\n<figure class="wp-block-image size-large is-resized"><img src="https://cdn.thingiverse.com/renders/33/b6/37/85/85/59b0c38e5b805c7dd9b9f5abeee79ca0_preview_featured.jpg" alt="" style="width:535px;height:402px" width="535" height="402"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class="wp-block-column"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>La colonne est creuse est composée de modules empilables, ce qui permet de choisir le nombre de plantes</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>le réservoir en bas contient une pompe, cette dernière remonte l\'eau via un tuyau au centre de la tour jusqu\'à l\'étage supérieur qui et lui même percé de trous...</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>l\'eau passe par ces trous et redescend par gravité jusqu\'au réservoir, en arrosant au passage les racines des plantes maintenues en position dans des billes d\'argile dans les paniers amovibles (couleur ocre) installés dans la tour</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:paragraph -->\n<p>J\'ai du adapter le système de de fixation entre le bas de la tour et mon réservoirs, ainsi que certaines modifications mineures.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Au printemps 2022 J\'ai fabriqué et mis en service 4 systèmes modulaires hydroponiques (que l\'on pourrait les qualifier d\'aéro-hydroponiques). Ces systèmes avaient une forme de cylindre creux lequel étaient insérés des paniers contenant des billes d\'argile. En bas de la tour un réservoir de 10 à 20 litres dans lequel une pompe alimentait le haut de la tour par un tuyau, le liquide redescendant dans la tour en imprégnant les racines par gravité.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Le détail et les photos sont disponibles ici</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Les résultats étaient intéressants, j\'ai beaucoup appris de ce système. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p> </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Début 2022, j\'étais très motivé par les principes de l\'aquaponie. La nature symbiotique poissons + plantes, la création d\'un écosystème économe et vertueux, la double production poissons + plantes sur une surface réduite m\'ont donné très envie d\'aller voir de plus près ce genre de systèmes. J\'ai bien sur beaucoup cherché sur internet, vu des réalisations magnifiques (par exemple la chaine de <a href="https://www.youtube.com/@ChrisPagns">Chris Pagns</a> sur youtube).</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>A completer...</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Y sont présentées les activités de test et d\'apprentissage de ces techniques réalisées depuis le printemps 2022 à Saint-germain-en-Laye (78, Yvelines), Aix-en-Provence et Marseille (13, Bouches du Rhône). </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->','Bienvenue','','inherit','closed','closed','','2-revision-v1','','','2023-08-20 18:23:55','2023-08-20 16:23:55','',2,'http://hs.vicq.org/?p=91',0,'revision','',0);
INSERT INTO `hs_posts` VALUES (92,1,'2023-08-20 18:29:15','2023-08-20 16:29:15','<!-- wp:heading -->\n<h2 class="wp-block-heading">Ce blog est consacré à l\'hydroponie et la bioponie domestiques. </h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Ces deux techniques de culture font partie de la famille des cultures hors-sol sur substrat neutre. Elles consistent à faire pousser des plantes sans terre, sur un substrat neutre (billes d\'argile par exemple), en mettant en place un dispositif efficace pour leur fournir les nutriments nécessaire pour assurer une croissance efficace des racines et des plantes. La recirculation du liquide nutritif évite une grande partie de la consommation d\'eau qui est induite dans la culture en sol. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Origine du projet et cheminement</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>J\'ai commencé à m\'intéresser aux questions de culture urbaines pendant l\'épidémie de COVID. Cet épisode anxiogène m\'a fait m\'interroger sur certaines questions d\'organisation de la société, et aux risques associés à l\'approvisionnement en ville des denrées alimentaires. En effet, il semble qu\'en cas de gros dysfonctionnement de la logistique d\'approvisionnement en nourriture, en quelque jours les villes pourraient se retrouver privées d\'une partie importante de leurs ressources alimentaires. Face à cette potentielle fragilité des flux de transport, il semble intéressant de développer des dispositifs urbains assurant une partie (même réduite) de la production de légumes dans la ville. Des études sur ces sujets existent, mais je ne suis pas un spécialiste de la recherche en agriculture urbaine, j\'essayerai de faire un peu de bibliographie à ce sujet quand j\'aurai le temps.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>De plus, les questions d\'épuisement de la planète sont maintenant au centre des débats, et cultiver des légumes en étant économe en eau et en énergie est un sujet qui m\'intéresse et me semble prometteur pour les temps qui viennent.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Culture hors sol, définitions</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Le web pullule d\'explications sur ces techniques de culture hors sol. Vous pouvez trouver <a href="https://fermedecagnolle.fr/hydroponie-bioponie-aquaponie-definitions/"><strong>ici</strong></a> par exemple des définitions simples de l\'<strong>hydroponie</strong>, <strong>bioponie</strong> et <strong>aquaponie</strong> proposées par Marion Sarlé (<a href="https://lessourciers.com/fr/">les sourciers</a>). Marion Sarlé propose aussi le livre «&nbsp;<em><strong>Monter sa microferme en hydroponie, bioponie et aquaponie</strong></em>&nbsp;», en vente sur le site <a href="https://lessourciers.com/fr/livre-sourciers/">Les Sourciers</a>&nbsp;. Les sourciers proposent aussi des <a href="https://lessourciers.com/fr/les-formations/">formations</a> en ligne et dans leur ferme du Gers. J\'ai suivi la partie en ligne de la formation <a href="https://lessourciers.com/fr/les-formations/microferme-hydroponique/">Microferme Hydroponique</a> qui m\'a bien aidé à comprendre les rudiments de base.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Une fois ces grandes définitions comprises, on trouve de très facilement des informations sur les <strong><a href="https://jardinfute.com/culture-hors-sol/page/2/">nombreux types de dispositifs</a></strong> utilisés pour ce type de culture (ex : <a href="https://jardinfute.com/methode-kratky/">Kratky</a>, <a href="https://jardinfute.com/systeme-dwc-hydroponie/">DWC</a>, <a href="https://jardinfute.com/systeme-nft-hydroponie/">NFT</a>, <a href="https://jardinfute.com/table-a-maree-ebb-flow/">table à marée</a>, etc.). J\'ai choisi les explications sur le site <a href="https://jardinfute.com/">jardinfute.com</a>, mais vous trouverez facilement d\'autres systèmes et d\'autres explications sur internet.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Si l\'on évalue la complexité de ces techniques, on comprend que l\'<strong>hydroponie</strong> est la plus simple des trois, puisqu\'elle se base sur la circulation d\'une solution nutritive contenant des nutriments minéraux (engrais) directement assimilables par les racines des plantes cultivées. En gros, il suffit de faire circuler de l\'eau additionnée d\'engrais sur les racines des plantes.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Quand on regarde les principes de la <strong>bioponie</strong> et l\'<strong>aquaponie</strong>, on comprend que le principe est plus complexe. Dans les deux cas on va transformer des éléments organiques en éléments minéraux pouvant être assimilés par les plantes (minéralisation). Cela est réalisé en deux étapes par l\'action de deux types de bactéries qui vont assurer tout d\'abord la transformation des éléments organiques en nitrites (bactéries <strong>Nitrosomonas</strong>) puis des nitrites en nitrates (bactéries <strong>Nitrobacter</strong>). Dans les deux cas, il faut offrir à ces bactéries un lieu et des conditions de vie, ce qui représente une complexité supplémentaire. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Enfin, pour l\'<strong>aquaponie</strong> il faut aussi s\'occuper de ses poissons, et en particulier gérer les caractéristiques de l\'eau. Des déséquilibres dans le système peuvent rapidement tuer une partie du cheptel, ce qui est plus impactant que de voir mourir un pied de ciboulette.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Pour avoir les meilleures chances de réussite en limitant la complexité du savoir nécessaire et m\'y mettre rapidement, j\'ai choisi de commencer par l\'hydroponie.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Prototypes</h2>\n<!-- /wp:heading -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading">Etape 1 : 2021-2022, un petit système hydroponique</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Durant l\'hiver 2021, j\'ai fait des recherches des différents systèmes hydroponiques disponibles et de comment réaliser sois-même ce genre de choses, et j\'ai été rapidement convaincu de l\'idée de commencer petit, afin d\'être prêt et de pouvoir planter dès le printemps 2022. Le retour d\'expérience des personnes expérimentées est unanime : il faut commencer simple et petit. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>De plus, commencer avec un petit système simple n\'a que des avantages pour quelqu\'un comme moi qui aime bricoler : </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Un petit prototype opérationnel est complet, donc on apprendra presque qu\'autant de choses que sur un plus gros système.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Le temps de développement est plus court, on aura ainsi plus de chances d\'aboutir dans des délais imposés par ses propres contraintes quotidiennes et l\'implacable chef d\'orchestre que sont les saisons. Par exemple, en France, il n\'est pas vraiment facile de planter des tomates à l\'automne, il faudra avoir été prêt pour le printemps, ou attendre le printemps suivant. </li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>On réduit le coût de fabrication, le risque financier et le temps passé si l\'on rate sa réalisation ou si on renonce avant la fin.</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:paragraph -->\n<p>J\'ai donc recherché les systèmes hydroponiques disponibles sur le marché ; j\'ai trouvé pas mal de systèmes clés en main, plus ou moins aboutis et plus ou moins chers. Pourtant, j\'ai décidé de construire moi-même mon premier système, pour plusieurs raisons :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Je suis convaincu que "mettre la main à la pâte" est souvent une bonne idée pour comprendre plus profondément un système technique,</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>j\'aime bien réaliser des prototypes en adaptant une solution technique existante à mon besoin personnel, cela m\'aide à  réfléchir à une généralisation possible les autres.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>On peut vouloir créer des fermes urbaines de taille plus ou moins importante, mais j\'ai décider de m\'intéresser à des dispositifs mis en œuvre à l\'échelle individuelle ou de proche voisinage, car cela représente des investissements réduits, une capacité de réalisation rapide et un investissement en temps acceptable. De plus, même si l\'ambition de tels systèmes n\'est pas de produire des bénéfices financiers, elle semble intéressante à l\'échelle de l\'individu ou du voisinage.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Bénéfices du système. Voici plusieurs (bonnes) raisons pour mettre en place ce type de systèmes :</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading">Un mini-système hydroponique</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Durant l\'hiver 2021, j\'ai choisi de réaliser un système hydroponique vertical. Pratiquant l\'impression impression 3D, j\'ai décidé de partir d\'un système déjà conçu, et de l\'adapter un peu.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>voici à quoi ce système ressemblait dans sa <a href="https://www.thingiverse.com/thing:3405964/">version originale</a> : </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:columns -->\n<div class="wp-block-columns"><!-- wp:column -->\n<div class="wp-block-column"><!-- wp:image {"width":535,"height":402,"sizeSlug":"large"} -->\n<figure class="wp-block-image size-large is-resized"><img src="https://cdn.thingiverse.com/renders/33/b6/37/85/85/59b0c38e5b805c7dd9b9f5abeee79ca0_preview_featured.jpg" alt="" style="width:535px;height:402px" width="535" height="402"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class="wp-block-column"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>La colonne est creuse est composée de modules empilables, ce qui permet de choisir le nombre de plantes</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>le réservoir en bas contient une pompe, cette dernière remonte l\'eau via un tuyau au centre de la tour jusqu\'à l\'étage supérieur qui et lui même percé de trous...</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>l\'eau passe par ces trous et redescend par gravité jusqu\'au réservoir, en arrosant au passage les racines des plantes maintenues en position dans des billes d\'argile dans les paniers amovibles (couleur ocre) installés dans la tour</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:paragraph -->\n<p>J\'ai du adapter le système de de fixation entre le bas de la tour et mon réservoirs, ainsi que certaines modifications mineures.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Au printemps 2022 J\'ai imprimé et mis en service 4 systèmes modulaires hydroponiques (que l\'on pourrait les qualifier d\'aéro-hydroponiques). Ces systèmes avaient une forme de cylindre creux lequel étaient insérés des paniers contenant des billes d\'argile. En bas de la tour un réservoir de 10 à 20 litres dans lequel une pompe alimentait le haut de la tour par un tuyau, le liquide redescendant dans la tour en imprégnant les racines par gravité.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Le détail et les photos sont disponibles ici</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Les résultats étaient intéressants, j\'ai beaucoup appris de ce système. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p> </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Début 2022, j\'étais très motivé par les principes de l\'aquaponie. La nature symbiotique poissons + plantes, la création d\'un écosystème économe et vertueux, la double production poissons + plantes sur une surface réduite m\'ont donné très envie d\'aller voir de plus près ce genre de systèmes. J\'ai bien sur beaucoup cherché sur internet, vu des réalisations magnifiques (par exemple la chaine de <a href="https://www.youtube.com/@ChrisPagns">Chris Pagns</a> sur youtube).</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>A completer...</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Y sont présentées les activités de test et d\'apprentissage de ces techniques réalisées depuis le printemps 2022 à Saint-germain-en-Laye (78, Yvelines), Aix-en-Provence et Marseille (13, Bouches du Rhône). </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->','Bienvenue','','inherit','closed','closed','','2-revision-v1','','','2023-08-20 18:29:15','2023-08-20 16:29:15','',2,'http://hs.vicq.org/?p=92',0,'revision','',0);
INSERT INTO `hs_posts` VALUES (94,1,'2023-08-20 18:34:12','2023-08-20 16:34:12','<!-- wp:heading -->\n<h2 class="wp-block-heading">Ce blog est consacré à l\'hydroponie et la bioponie domestiques. </h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Ces deux techniques de culture font partie de la famille des cultures hors-sol sur substrat neutre. Elles consistent à faire pousser des plantes sans terre, sur un substrat neutre (billes d\'argile par exemple), en mettant en place un dispositif efficace pour leur fournir les nutriments nécessaire pour assurer une croissance efficace des racines et des plantes. La recirculation du liquide nutritif évite une grande partie de la consommation d\'eau qui est induite dans la culture en sol. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Origine du projet et cheminement</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>J\'ai commencé à m\'intéresser aux questions de culture urbaines pendant l\'épidémie de COVID. Cet épisode anxiogène m\'a fait m\'interroger sur certaines questions d\'organisation de la société, et aux risques associés à l\'approvisionnement en ville des denrées alimentaires. En effet, il semble qu\'en cas de gros dysfonctionnement de la logistique d\'approvisionnement en nourriture, en quelque jours les villes pourraient se retrouver privées d\'une partie importante de leurs ressources alimentaires. Face à cette potentielle fragilité des flux de transport, il semble intéressant de développer des dispositifs urbains assurant une partie (même réduite) de la production de légumes dans la ville. Des études sur ces sujets existent, mais je ne suis pas un spécialiste de la recherche en agriculture urbaine, j\'essayerai de faire un peu de bibliographie à ce sujet quand j\'aurai le temps.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>De plus, les questions d\'épuisement de la planète sont maintenant au centre des débats, et cultiver des légumes en étant économe en eau et en énergie est un sujet qui m\'intéresse et me semble prometteur pour les temps qui viennent.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Culture hors sol, définitions</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Le web pullule d\'explications sur ces techniques de culture hors sol. Vous pouvez trouver <a href="https://fermedecagnolle.fr/hydroponie-bioponie-aquaponie-definitions/"><strong>ici</strong></a> par exemple des définitions simples de l\'<strong>hydroponie</strong>, <strong>bioponie</strong> et <strong>aquaponie</strong> proposées par Marion Sarlé (<a href="https://lessourciers.com/fr/">les sourciers</a>). Marion Sarlé propose aussi le livre «&nbsp;<em><strong>Monter sa microferme en hydroponie, bioponie et aquaponie</strong></em>&nbsp;», en vente sur le site <a href="https://lessourciers.com/fr/livre-sourciers/">Les Sourciers</a>&nbsp;. Les sourciers proposent aussi des <a href="https://lessourciers.com/fr/les-formations/">formations</a> en ligne et dans leur ferme du Gers. J\'ai suivi la partie en ligne de la formation <a href="https://lessourciers.com/fr/les-formations/microferme-hydroponique/">Microferme Hydroponique</a> qui m\'a bien aidé à comprendre les rudiments de base.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Une fois ces grandes définitions comprises, on trouve de très facilement des informations sur les <strong><a href="https://jardinfute.com/culture-hors-sol/page/2/">nombreux types de dispositifs</a></strong> utilisés pour ce type de culture (ex : <a href="https://jardinfute.com/methode-kratky/">Kratky</a>, <a href="https://jardinfute.com/systeme-dwc-hydroponie/">DWC</a>, <a href="https://jardinfute.com/systeme-nft-hydroponie/">NFT</a>, <a href="https://jardinfute.com/table-a-maree-ebb-flow/">table à marée</a>, etc.). J\'ai choisi les explications sur le site <a href="https://jardinfute.com/">jardinfute.com</a>, mais vous trouverez facilement d\'autres systèmes et d\'autres explications sur internet.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Si l\'on évalue la complexité de ces techniques, on comprend que l\'<strong>hydroponie</strong> est la plus simple des trois, puisqu\'elle se base sur la circulation d\'une solution nutritive contenant des nutriments minéraux (engrais) directement assimilables par les racines des plantes cultivées. En gros, il suffit de faire circuler de l\'eau additionnée d\'engrais sur les racines des plantes.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Quand on regarde les principes de la <strong>bioponie</strong> et l\'<strong>aquaponie</strong>, on comprend que le principe est plus complexe. Dans les deux cas on va transformer des éléments organiques en éléments minéraux pouvant être assimilés par les plantes (minéralisation). Cela est réalisé en deux étapes par l\'action de deux types de bactéries qui vont assurer tout d\'abord la transformation des éléments organiques en nitrites (bactéries <strong>Nitrosomonas</strong>) puis des nitrites en nitrates (bactéries <strong>Nitrobacter</strong>). Dans les deux cas, il faut offrir à ces bactéries un lieu et des conditions de vie, ce qui représente une complexité supplémentaire. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Enfin, pour l\'<strong>aquaponie</strong> il faut aussi s\'occuper de ses poissons, et en particulier gérer les caractéristiques de l\'eau. Des déséquilibres dans le système peuvent rapidement tuer une partie du cheptel, ce qui est plus impactant que de voir mourir un pied de ciboulette.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Premier objectif : construire un système hydroponique</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Pour avoir les meilleures chances de réussite en limitant la complexité du savoir nécessaire et m\'y mettre rapidement, j\'ai choisi de commencer par l\'hydroponie.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>On peut vouloir créer des fermes hydroponiques de taille plus ou moins importante, mais j\'ai décidé de m\'intéresser à des dispositifs mis en œuvre à l\'échelle individuelle ou de proche voisinage, car cela représente des investissements réduits, une capacité de réalisation rapide et un investissement en temps acceptable. De plus, même si l\'ambition de tels systèmes n\'est pas de produire des bénéfices financiers, elle semble intéressante à l\'échelle de l\'individu ou du voisinage.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Prototypes</h2>\n<!-- /wp:heading -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading">Etape 1 : 2021-2022, un petit système hydroponique</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Durant l\'hiver 2021, j\'ai fait des recherches des différents systèmes hydroponiques disponibles et de comment réaliser sois-même ce genre de choses, et j\'ai été rapidement convaincu de l\'idée de commencer petit, afin d\'être prêt et de pouvoir planter dès le printemps 2022. Le retour d\'expérience des personnes expérimentées est unanime : il faut commencer simple et petit. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>De plus, commencer avec un petit système simple n\'a que des avantages pour quelqu\'un comme moi qui aime bricoler : </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Un petit prototype opérationnel est complet, donc on apprendra presque qu\'autant de choses que sur un plus gros système.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Le temps de développement est plus court, on aura ainsi plus de chances d\'aboutir dans des délais imposés par ses propres contraintes quotidiennes et l\'implacable chef d\'orchestre que sont les saisons. Par exemple, en France, il n\'est pas vraiment facile de planter des tomates à l\'automne, il faudra avoir été prêt pour le printemps, ou attendre le printemps suivant. </li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>On réduit le coût de fabrication, le risque financier et le temps passé si l\'on rate sa réalisation ou si on renonce avant la fin.</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:paragraph -->\n<p>J\'ai donc recherché les systèmes hydroponiques disponibles sur le marché ; j\'ai trouvé pas mal de systèmes clés en main, plus ou moins aboutis et plus ou moins chers. Pourtant, j\'ai décidé de construire moi-même mon premier système, pour plusieurs raisons :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Je suis convaincu que "mettre la main à la pâte" est souvent une bonne idée pour comprendre plus profondément un système technique,</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>j\'aime bien réaliser des prototypes en adaptant une solution technique existante à mon besoin personnel, cela m\'aide à  réfléchir à une généralisation possible les autres.</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading">Un mini-système hydroponique</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Durant l\'hiver 2021, j\'ai choisi de réaliser un système hydroponique vertical. Pratiquant l\'impression impression 3D, j\'ai décidé de partir d\'un système déjà conçu, et de l\'adapter un peu.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>voici à quoi ce système ressemblait dans sa <a href="https://www.thingiverse.com/thing:3405964/">version originale</a> : </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:columns -->\n<div class="wp-block-columns"><!-- wp:column -->\n<div class="wp-block-column"><!-- wp:image {"width":535,"height":402,"sizeSlug":"large"} -->\n<figure class="wp-block-image size-large is-resized"><img src="https://cdn.thingiverse.com/renders/33/b6/37/85/85/59b0c38e5b805c7dd9b9f5abeee79ca0_preview_featured.jpg" alt="" style="width:535px;height:402px" width="535" height="402"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class="wp-block-column"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>La colonne est creuse est composée de modules empilables, ce qui permet de choisir le nombre de plantes</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>le réservoir en bas contient une pompe, cette dernière remonte l\'eau via un tuyau au centre de la tour jusqu\'à l\'étage supérieur qui et lui même percé de trous...</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>l\'eau passe par ces trous et redescend par gravité jusqu\'au réservoir, en arrosant au passage les racines des plantes maintenues en position dans des billes d\'argile dans les paniers amovibles (couleur ocre) installés dans la tour</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:paragraph -->\n<p>J\'ai du adapter le système de de fixation entre le bas de la tour et mon réservoirs, ainsi que certaines modifications mineures.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Au printemps 2022 J\'ai imprimé et mis en service 4 systèmes modulaires hydroponiques (que l\'on pourrait les qualifier d\'aéro-hydroponiques). Ces systèmes avaient une forme de cylindre creux lequel étaient insérés des paniers contenant des billes d\'argile. En bas de la tour un réservoir de 10 à 20 litres dans lequel une pompe alimentait le haut de la tour par un tuyau, le liquide redescendant dans la tour en imprégnant les racines par gravité.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Le détail et les photos sont disponibles ici</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Les résultats étaient intéressants, j\'ai beaucoup appris de ce système. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p> </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Début 2022, j\'étais très motivé par les principes de l\'aquaponie. La nature symbiotique poissons + plantes, la création d\'un écosystème économe et vertueux, la double production poissons + plantes sur une surface réduite m\'ont donné très envie d\'aller voir de plus près ce genre de systèmes. J\'ai bien sur beaucoup cherché sur internet, vu des réalisations magnifiques (par exemple la chaine de <a href="https://www.youtube.com/@ChrisPagns">Chris Pagns</a> sur youtube).</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>A completer...</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Y sont présentées les activités de test et d\'apprentissage de ces techniques réalisées depuis le printemps 2022 à Saint-germain-en-Laye (78, Yvelines), Aix-en-Provence et Marseille (13, Bouches du Rhône). </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->','Bienvenue','','inherit','closed','closed','','2-revision-v1','','','2023-08-20 18:34:12','2023-08-20 16:34:12','',2,'http://hs.vicq.org/?p=94',0,'revision','',0);
INSERT INTO `hs_posts` VALUES (95,1,'2023-08-20 18:44:19','2023-08-20 16:44:19','<!-- wp:heading -->\n<h2 class="wp-block-heading">Ce blog est consacré à l\'hydroponie et la bioponie domestiques. </h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Ces deux techniques de culture font partie de la famille des cultures hors-sol sur substrat neutre. Elles consistent à faire pousser des plantes sans terre, sur un substrat neutre (billes d\'argile par exemple), en mettant en place un dispositif efficace pour leur fournir les nutriments nécessaire pour assurer une croissance efficace des racines et des plantes. La recirculation du liquide nutritif évite une grande partie de la consommation d\'eau qui est induite dans la culture en sol. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Origine du projet et cheminement</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>J\'ai commencé à m\'intéresser aux questions de culture urbaines pendant l\'épidémie de COVID. Cet épisode anxiogène m\'a fait m\'interroger sur certaines questions d\'organisation de la société, et aux risques associés à l\'approvisionnement en ville des denrées alimentaires. En effet, il semble qu\'en cas de gros dysfonctionnement de la logistique d\'approvisionnement en nourriture, en quelque jours les villes pourraient se retrouver privées d\'une partie importante de leurs ressources alimentaires. Face à cette potentielle fragilité des flux de transport, il semble intéressant de développer des dispositifs urbains assurant une partie (même réduite) de la production de légumes dans la ville. Des études sur ces sujets existent, mais je ne suis pas un spécialiste de la recherche en agriculture urbaine, j\'essayerai de faire un peu de bibliographie à ce sujet quand j\'aurai le temps.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>De plus, les questions d\'épuisement de la planète sont maintenant au centre des débats, et cultiver des légumes en étant économe en eau et en énergie est un sujet qui m\'intéresse et me semble prometteur pour les temps qui viennent.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Culture hors sol, définitions</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Le web pullule d\'explications sur ces techniques de culture hors sol. Vous pouvez trouver <a href="https://fermedecagnolle.fr/hydroponie-bioponie-aquaponie-definitions/"><strong>ici</strong></a> par exemple des définitions simples de l\'<strong>hydroponie</strong>, <strong>bioponie</strong> et <strong>aquaponie</strong> proposées par Marion Sarlé (<a href="https://lessourciers.com/fr/">les sourciers</a>). Marion Sarlé propose aussi le livre «&nbsp;<em><strong>Monter sa microferme en hydroponie, bioponie et aquaponie</strong></em>&nbsp;», en vente sur le site <a href="https://lessourciers.com/fr/livre-sourciers/">Les Sourciers</a>&nbsp;. Les sourciers proposent aussi des <a href="https://lessourciers.com/fr/les-formations/">formations</a> en ligne et dans leur ferme du Gers. J\'ai suivi la partie en ligne de la formation <a href="https://lessourciers.com/fr/les-formations/microferme-hydroponique/">Microferme Hydroponique</a> qui m\'a bien aidé à comprendre les rudiments de base.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Une fois ces grandes définitions comprises, on trouve de très facilement des informations sur les <strong><a href="https://jardinfute.com/culture-hors-sol/page/2/">nombreux types de dispositifs</a></strong> utilisés pour ce type de culture (ex : <a href="https://jardinfute.com/methode-kratky/">Kratky</a>, <a href="https://jardinfute.com/systeme-dwc-hydroponie/">DWC</a>, <a href="https://jardinfute.com/systeme-nft-hydroponie/">NFT</a>, <a href="https://jardinfute.com/table-a-maree-ebb-flow/">table à marée</a>, etc.). J\'ai choisi les explications sur le site <a href="https://jardinfute.com/">jardinfute.com</a>, mais vous trouverez facilement d\'autres systèmes et d\'autres explications sur internet.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Si l\'on évalue la complexité de ces techniques, on comprend que l\'<strong>hydroponie</strong> est la plus simple des trois, puisqu\'elle se base sur la circulation d\'une solution nutritive contenant des nutriments minéraux (engrais) directement assimilables par les racines des plantes cultivées. En gros, il suffit de faire circuler de l\'eau additionnée d\'engrais sur les racines des plantes.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Quand on regarde les principes de la <strong>bioponie</strong> et l\'<strong>aquaponie</strong>, on comprend que le principe est plus complexe. Dans les deux cas on va transformer des éléments organiques en éléments minéraux pouvant être assimilés par les plantes (minéralisation). Cela est réalisé en deux étapes par l\'action de deux types de bactéries qui vont assurer tout d\'abord la transformation des éléments organiques en nitrites (bactéries <strong>Nitrosomonas</strong>) puis des nitrites en nitrates (bactéries <strong>Nitrobacter</strong>). Dans les deux cas, il faut offrir à ces bactéries un lieu et des conditions de vie, ce qui représente une complexité supplémentaire. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Enfin, pour l\'<strong>aquaponie</strong> il faut aussi s\'occuper de ses poissons, et en particulier gérer les caractéristiques de l\'eau. Des déséquilibres dans le système peuvent rapidement tuer une partie du cheptel, ce qui est plus impactant que de voir mourir un pied de ciboulette.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Bénéfices des systèmes hors-sol</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Les bénéfices de systèmes industriels ne sont pas analysés ici. Mais voici les bénéfices que produit un système opérationnel :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Très faible consommation d\'eau (environ 90 % d\'économie)</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Très faible consommation d\'électricité (pompe 10 W)</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Fort rendement au m2</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Fierté de produire sa nourriture</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>systèmes en hauteur, hors de portée des nuisibles rampants</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Intérêt pédagogique de la culture des plantes, pour tous (des plus petits aux plus grands)</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Système de circulation d\'eau produisant un bruit très agréable sans gêner les voisins</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Premier objectif : construire un système hydroponique</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Pour avoir les meilleures chances de réussite en limitant la complexité du savoir nécessaire et m\'y mettre rapidement, j\'ai choisi de commencer par l\'hydroponie.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>On peut vouloir créer des fermes hydroponiques de taille plus ou moins importante, mais j\'ai décidé de m\'intéresser à des dispositifs mis en œuvre à l\'échelle individuelle ou de proche voisinage, car cela représente des investissements réduits, une capacité de réalisation rapide et un investissement en temps acceptable. De plus, même si l\'ambition de tels systèmes n\'est pas de produire des bénéfices financiers, elle semble intéressante à l\'échelle de l\'individu ou du voisinage.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Prototypes</h2>\n<!-- /wp:heading -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading">Etape 1 : 2021-2022, un petit système hydroponique</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Durant l\'hiver 2021, j\'ai fait des recherches des différents systèmes hydroponiques disponibles et de comment réaliser sois-même ce genre de choses, et j\'ai été rapidement convaincu de l\'idée de commencer petit, afin d\'être prêt et de pouvoir planter dès le printemps 2022. Le retour d\'expérience des personnes expérimentées est unanime : il faut commencer simple et petit. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>De plus, commencer avec un petit système simple n\'a que des avantages pour quelqu\'un comme moi qui aime bricoler : </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Un petit prototype opérationnel est complet, donc on apprendra presque qu\'autant de choses que sur un plus gros système.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Le temps de développement est plus court, on aura ainsi plus de chances d\'aboutir dans des délais imposés par ses propres contraintes quotidiennes et l\'implacable chef d\'orchestre que sont les saisons. Par exemple, en France, il n\'est pas vraiment facile de planter des tomates à l\'automne, il faudra avoir été prêt pour le printemps, ou attendre le printemps suivant. </li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>On réduit le coût de fabrication, le risque financier et le temps passé si l\'on rate sa réalisation ou si on renonce avant la fin.</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:paragraph -->\n<p>J\'ai donc recherché les systèmes hydroponiques disponibles sur le marché ; j\'ai trouvé pa!s mal de systèmes clés en main, plus ou moins aboutis et plus ou moins chers. Pourtant, j\'ai décidé de construire moi-même mon premier système, pour plusieurs raisons :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Je suis convaincu que "mettre la main à la pâte" est souvent une bonne idée pour comprendre plus profondément un système technique,</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>j\'aime bien réaliser des prototypes en adaptant une solution technique existante à mon besoin personnel, cela m\'aide à  réfléchir à une généralisation possible les autres.</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading">Un mini-système hydroponique vertical</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>J\'ai choisi de réaliser un système hydroponique vertical, pour prendre peu de place au sol. Pratiquant l\'impression impression 3D, j\'ai décidé de partir d\'un système déjà conçu, et de l\'adapter un peu.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>voici à quoi ce système ressemblait dans sa <a href="https://www.thingiverse.com/thing:3405964/">version originale</a> : </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:columns -->\n<div class="wp-block-columns"><!-- wp:column -->\n<div class="wp-block-column"><!-- wp:image {"width":535,"height":402,"sizeSlug":"large"} -->\n<figure class="wp-block-image size-large is-resized"><img src="https://cdn.thingiverse.com/renders/33/b6/37/85/85/59b0c38e5b805c7dd9b9f5abeee79ca0_preview_featured.jpg" alt="" style="width:535px;height:402px" width="535" height="402"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class="wp-block-column"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>La colonne est creuse est composée de modules empilables, ce qui permet de choisir le nombre de plantes</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>le réservoir en bas contient une pompe, cette dernière remonte l\'eau via un tuyau au centre de la tour jusqu\'à l\'étage supérieur qui et lui même percé de trous...</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>l\'eau passe par ces trous et redescend par gravité jusqu\'au réservoir, en arrosant au passage les racines des plantes maintenues en position dans des billes d\'argile dans les paniers amovibles (couleur ocre) installés dans la tour</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:paragraph -->\n<p>J\'ai du adapter le système de de fixation entre le bas de la tour et mon réservoirs, ainsi que certaines modifications mineures.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Au printemps 2022 J\'ai imprimé et mis en service 4 systèmes modulaires hydroponiques (que l\'on pourrait les qualifier d\'aéro-hydroponiques). Ces systèmes avaient une forme de cylindre creux lequel étaient insérés des paniers contenant des billes d\'argile. En bas de la tour un réservoir de 10 à 20 litres dans lequel une pompe alimentait le haut de la tour par un tuyau, le liquide redescendant dans la tour en imprégnant les racines par gravité.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Le détail et les photos sont disponibles ici</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Les résultats étaient intéressants, j\'ai beaucoup appris de ce système. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p> </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Début 2022, j\'étais très motivé par les principes de l\'aquaponie. La nature symbiotique poissons + plantes, la création d\'un écosystème économe et vertueux, la double production poissons + plantes sur une surface réduite m\'ont donné très envie d\'aller voir de plus près ce genre de systèmes. J\'ai bien sur beaucoup cherché sur internet, vu des réalisations magnifiques (par exemple la chaine de <a href="https://www.youtube.com/@ChrisPagns">Chris Pagns</a> sur youtube).</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>A completer...</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Y sont présentées les activités de test et d\'apprentissage de ces techniques réalisées depuis le printemps 2022 à Saint-germain-en-Laye (78, Yvelines), Aix-en-Provence et Marseille (13, Bouches du Rhône). </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->','Bienvenue','','inherit','closed','closed','','2-revision-v1','','','2023-08-20 18:44:19','2023-08-20 16:44:19','',2,'http://hs.vicq.org/?p=95',0,'revision','',0);
INSERT INTO `hs_posts` VALUES (96,1,'2023-08-20 18:47:16','2023-08-20 16:47:16','<!-- wp:heading -->\n<h2 class="wp-block-heading">Ce blog est consacré à l\'hydroponie et la bioponie domestiques. </h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Ces deux techniques de culture font partie de la famille des cultures hors-sol sur substrat neutre. Elles consistent à faire pousser des plantes sans terre, sur un substrat neutre (billes d\'argile par exemple), en mettant en place un dispositif efficace pour leur fournir les nutriments nécessaire pour assurer une croissance efficace des racines et des plantes. La recirculation du liquide nutritif évite une grande partie de la consommation d\'eau qui est induite dans la culture en sol. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Origine du projet et cheminement</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>J\'ai commencé à m\'intéresser aux questions de culture urbaines pendant l\'épidémie de COVID. Cet épisode anxiogène m\'a fait m\'interroger sur certaines questions d\'organisation de la société, et aux risques associés à l\'approvisionnement en ville des denrées alimentaires. En effet, il semble qu\'en cas de gros dysfonctionnement de la logistique d\'approvisionnement en nourriture, en quelque jours les villes pourraient se retrouver privées d\'une partie importante de leurs ressources alimentaires. Face à cette potentielle fragilité des flux de transport, il semble intéressant de développer des dispositifs urbains assurant une partie (même réduite) de la production de légumes dans la ville. Des études sur ces sujets existent, mais je ne suis pas un spécialiste de la recherche en agriculture urbaine, j\'essayerai de faire un peu de bibliographie à ce sujet quand j\'aurai le temps.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>De plus, les questions d\'épuisement de la planète sont maintenant au centre des débats, et cultiver des légumes en étant économe en eau et en énergie est un sujet qui m\'intéresse et me semble prometteur pour les temps qui viennent.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Culture hors sol, définitions</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Le web pullule d\'explications sur ces techniques de culture hors sol. Vous pouvez trouver <a href="https://fermedecagnolle.fr/hydroponie-bioponie-aquaponie-definitions/"><strong>ici</strong></a> par exemple des définitions simples de l\'<strong>hydroponie</strong>, <strong>bioponie</strong> et <strong>aquaponie</strong> proposées par Marion Sarlé (<a href="https://lessourciers.com/fr/">les sourciers</a>). Marion Sarlé propose aussi le livre «&nbsp;<em><strong>Monter sa microferme en hydroponie, bioponie et aquaponie</strong></em>&nbsp;», en vente sur le site <a href="https://lessourciers.com/fr/livre-sourciers/">Les Sourciers</a>&nbsp;. Les sourciers proposent aussi des <a href="https://lessourciers.com/fr/les-formations/">formations</a> en ligne et dans leur ferme du Gers. J\'ai suivi la partie en ligne de la formation <a href="https://lessourciers.com/fr/les-formations/microferme-hydroponique/">Microferme Hydroponique</a> qui m\'a bien aidé à comprendre les rudiments de base.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Une fois ces grandes définitions comprises, on trouve de très facilement des informations sur les <strong><a href="https://jardinfute.com/culture-hors-sol/page/2/">nombreux types de dispositifs</a></strong> utilisés pour ce type de culture (ex : <a href="https://jardinfute.com/methode-kratky/">Kratky</a>, <a href="https://jardinfute.com/systeme-dwc-hydroponie/">DWC</a>, <a href="https://jardinfute.com/systeme-nft-hydroponie/">NFT</a>, <a href="https://jardinfute.com/table-a-maree-ebb-flow/">table à marée</a>, etc.). J\'ai choisi les explications sur le site <a href="https://jardinfute.com/">jardinfute.com</a>, mais vous trouverez facilement d\'autres systèmes et d\'autres explications sur internet.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Si l\'on évalue la complexité de ces techniques, on comprend que l\'<strong>hydroponie</strong> est la plus simple des trois, puisqu\'elle se base sur la circulation d\'une solution nutritive contenant des nutriments minéraux (engrais) directement assimilables par les racines des plantes cultivées. En gros, il suffit de faire circuler de l\'eau additionnée d\'engrais sur les racines des plantes.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Quand on regarde les principes de la <strong>bioponie</strong> et l\'<strong>aquaponie</strong>, on comprend que le principe est plus complexe. Dans les deux cas on va transformer des éléments organiques en éléments minéraux pouvant être assimilés par les plantes (minéralisation). Cela est réalisé en deux étapes par l\'action de deux types de bactéries qui vont assurer tout d\'abord la transformation des éléments organiques en nitrites (bactéries <strong>Nitrosomonas</strong>) puis des nitrites en nitrates (bactéries <strong>Nitrobacter</strong>). Dans les deux cas, il faut offrir à ces bactéries un lieu et des conditions de vie, ce qui représente une complexité supplémentaire. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Enfin, pour l\'<strong>aquaponie</strong> il faut aussi s\'occuper de ses poissons, et en particulier gérer les caractéristiques de l\'eau. Des déséquilibres dans le système peuvent rapidement tuer une partie du cheptel, ce qui est plus impactant que de voir mourir un pied de ciboulette.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Bénéfices des systèmes hors-sol</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Les bénéfices de systèmes industriels ne sont pas analysés ici. Mais voici les bénéfices que produit un système opérationnel :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Très faible consommation d\'eau (environ 90 % d\'économie)</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Très faible consommation d\'électricité (pompe 10 W)</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Fort rendement au m2</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Fierté de produire sa nourriture</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>systèmes en hauteur, hors de portée des nuisibles rampants</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Intérêt pédagogique de la culture des plantes, pour tous (des plus petits aux plus grands)</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Système de circulation d\'eau produisant un bruit très agréable sans gêner les voisins</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Premier objectif : construire un système hydroponique</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Pour avoir les meilleures chances de réussite en limitant la complexité du savoir nécessaire et m\'y mettre rapidement, j\'ai choisi de commencer par l\'hydroponie.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>On peut vouloir créer des fermes hydroponiques de taille plus ou moins importante, mais j\'ai décidé de m\'intéresser à des dispositifs mis en œuvre à l\'échelle individuelle ou de proche voisinage, car cela représente des investissements réduits, une capacité de réalisation rapide et un investissement en temps acceptable. De plus, même si l\'ambition de tels systèmes n\'est pas de produire des bénéfices financiers, elle semble intéressante à l\'échelle de l\'individu ou du voisinage.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Prototypes</h2>\n<!-- /wp:heading -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading">Etape 1 : 2021-2022, un petit système hydroponique</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Durant l\'hiver 2021, j\'ai fait des recherches des différents systèmes hydroponiques disponibles et de comment réaliser sois-même ce genre de choses, et j\'ai été rapidement convaincu de l\'idée de commencer petit, afin d\'être prêt et de pouvoir planter dès le printemps 2022. Le retour d\'expérience des personnes expérimentées est unanime : il faut commencer simple et petit. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>De plus, commencer avec un petit système simple n\'a que des avantages pour quelqu\'un comme moi qui aime bricoler : </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Un petit prototype opérationnel est complet, donc on apprendra presque qu\'autant de choses que sur un plus gros système.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Le temps de développement est plus court, on aura ainsi plus de chances d\'aboutir dans des délais imposés par ses propres contraintes quotidiennes et l\'implacable chef d\'orchestre que sont les saisons. Par exemple, en France, il n\'est pas vraiment facile de planter des tomates à l\'automne, il faudra avoir été prêt pour le printemps, ou attendre le printemps suivant. </li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>On réduit le coût de fabrication, le risque financier et le temps passé si l\'on rate sa réalisation ou si on renonce avant la fin.</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:paragraph -->\n<p>J\'ai donc recherché les systèmes hydroponiques disponibles sur le marché ; j\'ai trouvé pa!s mal de systèmes clés en main, plus ou moins aboutis et plus ou moins chers. Pourtant, j\'ai décidé de construire moi-même mon premier système, pour plusieurs raisons :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Je suis convaincu que "mettre la main à la pâte" est souvent une bonne idée pour comprendre plus profondément un système technique,</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>j\'aime bien réaliser des prototypes en adaptant une solution technique existante à mon besoin personnel, cela m\'aide à  réfléchir à une généralisation possible les autres.</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading">Un mini-système hydroponique vertical</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>J\'ai choisi de réaliser un système hydroponique vertical, pour prendre peu de place au sol. Pratiquant l\'impression impression 3D, j\'ai décidé de partir d\'un système déjà conçu, et de l\'adapter un peu.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>voici à quoi ce système ressemblait dans sa <a href="https://www.thingiverse.com/thing:3405964/">version originale</a> : </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:columns -->\n<div class="wp-block-columns"><!-- wp:column -->\n<div class="wp-block-column"><!-- wp:image {"width":535,"height":402,"sizeSlug":"large"} -->\n<figure class="wp-block-image size-large is-resized"><img src="https://cdn.thingiverse.com/renders/33/b6/37/85/85/59b0c38e5b805c7dd9b9f5abeee79ca0_preview_featured.jpg" alt="" style="width:535px;height:402px" width="535" height="402"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class="wp-block-column"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>La colonne est creuse est composée de modules empilables, ce qui permet de choisir le nombre de plantes</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>le réservoir en bas contient une pompe, cette dernière remonte l\'eau via un tuyau au centre de la tour jusqu\'à l\'étage supérieur qui et lui même percé de trous...</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>l\'eau passe par ces trous et redescend par gravité jusqu\'au réservoir, en arrosant au passage les racines des plantes maintenues en position dans des billes d\'argile dans les paniers amovibles (couleur ocre) installés dans la tour</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:paragraph -->\n<p>J\'ai du adapter le système de de fixation entre le bas de la tour et mon réservoirs, ainsi que certaines modifications mineures.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Au printemps 2022 J\'ai imprimé et mis en service 4 systèmes modulaires hydroponiques (que l\'on pourrait les qualifier d\'aéro-hydroponiques). Ces systèmes avaient une forme de cylindre creux lequel étaient insérés des paniers contenant des billes d\'argile. En bas de la tour un réservoir de 10 à 20 litres dans lequel une pompe alimentait le haut de la tour par un tuyau, le liquide redescendant dans la tour en imprégnant les racines par gravité.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Le détail et les photos sont disponibles ici</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Les résultats étaient intéressants, j\'ai beaucoup appris de ce système. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading">Etape 1 : 2022-2023, un système hydroponique à Saint-Germain en laye (78) et un système bioponique</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p> </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Début 2022, j\'étais très motivé par les principes de l\'aquaponie. La nature symbiotique poissons + plantes, la création d\'un écosystème économe et vertueux, la double production poissons + plantes sur une surface réduite m\'ont donné très envie d\'aller voir de plus près ce genre de systèmes. J\'ai bien sur beaucoup cherché sur internet, vu des réalisations magnifiques (par exemple la chaine de <a href="https://www.youtube.com/@ChrisPagns">Chris Pagns</a> sur youtube).</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>A completer...</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Y sont présentées les activités de test et d\'apprentissage de ces techniques réalisées depuis le printemps 2022 à Saint-germain-en-Laye (78, Yvelines), Aix-en-Provence et Marseille (13, Bouches du Rhône). </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->','Bienvenue','','inherit','closed','closed','','2-revision-v1','','','2023-08-20 18:47:16','2023-08-20 16:47:16','',2,'http://hs.vicq.org/?p=96',0,'revision','',0);
INSERT INTO `hs_posts` VALUES (97,1,'2023-08-20 19:06:27','2023-08-20 17:06:27','<!-- wp:heading -->\n<h2 class="wp-block-heading">Ce blog est consacré à l\'hydroponie et la bioponie domestiques. </h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Ces deux techniques de culture font partie de la famille des cultures hors-sol sur substrat neutre. Elles consistent à faire pousser des plantes sans terre, sur un substrat neutre (billes d\'argile par exemple), en mettant en place un dispositif efficace pour leur fournir les nutriments nécessaire pour assurer une croissance efficace des racines et des plantes. La recirculation du liquide nutritif évite une grande partie de la consommation d\'eau qui est induite dans la culture en sol. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Origine du projet et cheminement</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>J\'ai commencé à m\'intéresser aux questions de culture urbaines pendant l\'épidémie de COVID. Cet épisode anxiogène m\'a fait m\'interroger sur certaines questions d\'organisation de la société, et aux risques associés à l\'approvisionnement en ville des denrées alimentaires. En effet, il semble qu\'en cas de gros dysfonctionnement de la logistique d\'approvisionnement en nourriture, en quelque jours les villes pourraient se retrouver privées d\'une partie importante de leurs ressources alimentaires. Face à cette potentielle fragilité des flux de transport, il semble intéressant de développer des dispositifs urbains assurant une partie (même réduite) de la production de légumes dans la ville. Des études sur ces sujets existent, mais je ne suis pas un spécialiste de la recherche en agriculture urbaine, j\'essayerai de faire un peu de bibliographie à ce sujet quand j\'aurai le temps.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>De plus, les questions d\'épuisement de la planète sont maintenant au centre des débats, et cultiver des légumes en étant économe en eau et en énergie est un sujet qui m\'intéresse et me semble prometteur pour les temps qui viennent.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Culture hors sol, définitions</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Le web pullule d\'explications sur ces techniques de culture hors sol. Vous pouvez trouver <a href="https://fermedecagnolle.fr/hydroponie-bioponie-aquaponie-definitions/"><strong>ici</strong></a> par exemple des définitions simples de l\'<strong>hydroponie</strong>, <strong>bioponie</strong> et <strong>aquaponie</strong> proposées par Marion Sarlé (<a href="https://lessourciers.com/fr/">les sourciers</a>). Marion Sarlé propose aussi le livre «&nbsp;<em><strong>Monter sa microferme en hydroponie, bioponie et aquaponie</strong></em>&nbsp;», en vente sur le site <a href="https://lessourciers.com/fr/livre-sourciers/">Les Sourciers</a>&nbsp;. Les sourciers proposent aussi des <a href="https://lessourciers.com/fr/les-formations/">formations</a> en ligne et dans leur ferme du Gers. J\'ai suivi la partie en ligne de la formation <a href="https://lessourciers.com/fr/les-formations/microferme-hydroponique/">Microferme Hydroponique</a> qui m\'a bien aidé à comprendre les rudiments de base.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Une fois ces grandes définitions comprises, on trouve de très facilement des informations sur les <strong><a href="https://jardinfute.com/culture-hors-sol/page/2/">nombreux types de dispositifs</a></strong> utilisés pour ce type de culture (ex : <a href="https://jardinfute.com/methode-kratky/">Kratky</a>, <a href="https://jardinfute.com/systeme-dwc-hydroponie/">DWC</a>, <a href="https://jardinfute.com/systeme-nft-hydroponie/">NFT</a>, <a href="https://jardinfute.com/table-a-maree-ebb-flow/">table à marée</a>, etc.). J\'ai choisi les explications sur le site <a href="https://jardinfute.com/">jardinfute.com</a>, mais vous trouverez facilement d\'autres systèmes et d\'autres explications sur internet.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Si l\'on évalue la complexité de ces techniques, on comprend que l\'<strong>hydroponie</strong> est la plus simple des trois, puisqu\'elle se base sur la circulation d\'une solution nutritive contenant des nutriments minéraux (engrais) directement assimilables par les racines des plantes cultivées. En gros, il suffit de faire circuler de l\'eau additionnée d\'engrais sur les racines des plantes.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Quand on regarde les principes de la <strong>bioponie</strong> et l\'<strong>aquaponie</strong>, on comprend que le principe est plus complexe. Dans les deux cas on va transformer des éléments organiques en éléments minéraux pouvant être assimilés par les plantes (minéralisation). Cela est réalisé en deux étapes par l\'action de deux types de bactéries qui vont assurer tout d\'abord la transformation des éléments organiques en nitrites (bactéries <strong>Nitrosomonas</strong>) puis des nitrites en nitrates (bactéries <strong>Nitrobacter</strong>). Dans les deux cas, il faut offrir à ces bactéries un lieu et des conditions de vie, ce qui représente une complexité supplémentaire. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Enfin, pour l\'<strong>aquaponie</strong> il faut aussi s\'occuper de ses poissons, et en particulier gérer les caractéristiques de l\'eau. Des déséquilibres dans le système peuvent rapidement tuer une partie du cheptel, ce qui est plus impactant que de voir mourir un pied de ciboulette.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Bénéfices des systèmes hors-sol</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Les bénéfices de systèmes industriels ne sont pas analysés ici. Mais voici les bénéfices que produit un système opérationnel :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Très faible consommation d\'eau (environ 90 % d\'économie)</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Très faible consommation d\'électricité (pompe 10 W)</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Fort rendement au m2</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Fierté de produire sa nourriture</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>systèmes en hauteur, hors de portée des nuisibles rampants</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Intérêt pédagogique de la culture des plantes, pour tous (des plus petits aux plus grands)</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Système de circulation d\'eau produisant un bruit très agréable sans gêner les voisins</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Premier objectif : construire un système hydroponique</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Pour avoir les meilleures chances de réussite en limitant la complexité du savoir nécessaire et m\'y mettre rapidement, j\'ai choisi de commencer par l\'hydroponie.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>On peut vouloir créer des fermes hydroponiques de taille plus ou moins importante, mais j\'ai décidé de m\'intéresser à des dispositifs mis en œuvre à l\'échelle individuelle ou de proche voisinage, car cela représente des investissements réduits, une capacité de réalisation rapide et un investissement en temps acceptable. De plus, même si l\'ambition de tels systèmes n\'est pas de produire des bénéfices financiers, elle semble intéressante à l\'échelle de l\'individu ou du voisinage.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Prototypes</h2>\n<!-- /wp:heading -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading">Etape 1 : 2021-2022, un petit système hydroponique</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Durant l\'hiver 2021, j\'ai fait des recherches des différents systèmes hydroponiques disponibles et de comment réaliser sois-même ce genre de choses, et j\'ai été rapidement convaincu de l\'idée de commencer petit, afin d\'être prêt et de pouvoir planter dès le printemps 2022. Le retour d\'expérience des personnes expérimentées est unanime : il faut commencer simple et petit. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>De plus, commencer avec un petit système simple n\'a que des avantages pour quelqu\'un comme moi qui aime bricoler : </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Un petit prototype opérationnel est complet, donc on apprendra presque qu\'autant de choses que sur un plus gros système.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Le temps de développement est plus court, on aura ainsi plus de chances d\'aboutir dans des délais imposés par ses propres contraintes quotidiennes et l\'implacable chef d\'orchestre que sont les saisons. Par exemple, en France, il n\'est pas vraiment facile de planter des tomates à l\'automne, il faudra avoir été prêt pour le printemps, ou attendre le printemps suivant. </li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>On réduit le coût de fabrication, le risque financier et le temps passé si l\'on rate sa réalisation ou si on renonce avant la fin.</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:paragraph -->\n<p>J\'ai donc recherché les systèmes hydroponiques disponibles sur le marché ; j\'ai trouvé pa!s mal de systèmes clés en main, plus ou moins aboutis et plus ou moins chers. Pourtant, j\'ai décidé de construire moi-même mon premier système, pour plusieurs raisons :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Je suis convaincu que "mettre la main à la pâte" est souvent une bonne idée pour comprendre plus profondément un système technique,</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>j\'aime bien réaliser des prototypes en adaptant une solution technique existante à mon besoin personnel, cela m\'aide à  réfléchir à une généralisation possible les autres.</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading">Un mini-système hydroponique vertical (4 systèmes identiques testés entre la Provence et la région parisienne)</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>J\'ai choisi de réaliser un système hydroponique vertical, pour prendre peu de place au sol. Pratiquant l\'impression impression 3D, j\'ai décidé de partir d\'un système déjà conçu, et de l\'adapter un peu.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>voici à quoi ce système ressemblait dans sa <a href="https://www.thingiverse.com/thing:3405964/">version originale</a> : </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:columns -->\n<div class="wp-block-columns"><!-- wp:column -->\n<div class="wp-block-column"><!-- wp:image {"width":535,"height":402,"sizeSlug":"large"} -->\n<figure class="wp-block-image size-large is-resized"><img src="https://cdn.thingiverse.com/renders/33/b6/37/85/85/59b0c38e5b805c7dd9b9f5abeee79ca0_preview_featured.jpg" alt="" style="width:535px;height:402px" width="535" height="402"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class="wp-block-column"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>La colonne est creuse est composée de modules empilables, ce qui permet de choisir le nombre de plantes</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>le réservoir en bas contient une pompe, cette dernière remonte l\'eau via un tuyau au centre de la tour jusqu\'à l\'étage supérieur qui et lui même percé de trous...</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>l\'eau passe par ces trous et redescend par gravité jusqu\'au réservoir, en arrosant au passage les racines des plantes maintenues en position dans des billes d\'argile dans les paniers amovibles (couleur ocre) installés dans la tour</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:paragraph -->\n<p>J\'ai du adapter le système de de fixation entre le bas de la tour et mon réservoirs, ainsi que certaines modifications mineures.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Au printemps 2022 J\'ai imprimé et mis en service 4 systèmes modulaires hydroponiques (que l\'on pourrait les qualifier d\'aéro-hydroponiques). Ces systèmes avaient une forme de cylindre creux lequel étaient insérés des paniers contenant des billes d\'argile. En bas de la tour un réservoir de 10 à 20 litres dans lequel une pompe alimentait le haut de la tour par un tuyau, le liquide redescendant dans la tour en imprégnant les racines par gravité.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Trois ont été déployés dans les bouches du Rhône (2 à Marseille, un à Aix-en-Provence), un à Saint-Germain-en-Laye. Merci à Aurélie, Martine et Friquette (ma maman) pour les avoir fait fonctionner.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Le détail et les photos sont disponibles ici</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Les résultats étaient intéressants, j\'ai beaucoup appris de ce système. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading">Etape 2 : 2022-2023, un système hydroponique à Saint-Germain-en-laye (78) et un système bioponique à Marseille (13)</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p> Début 2022, j\'étais très motivé par les principes de l\'aquaponie. La nature symbiotique poissons + plantes, la création d\'un écosystème économe et vertueux, la double production poissons + plantes sur une surface réduite m\'ont donné très envie d\'aller voir de plus près ce genre de systèmes. J\'ai bien sur beaucoup cherché sur internet, vu des réalisations magnifiques (par exemple la chaine de <a href="https://www.youtube.com/@ChrisPagns">Chris Pagns</a> sur youtube).</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>J\'ai cherché si il existant des stages près de chez moi. J\'ai finalement opté pour une initiation à l\'aquaponie chez Aquaponia, by Ecologia, tout près de Laval (en Mayenne). J\'ai choisi ce stage pour les compétences reconnues de Guillaume Beucher, et pour le lieu magique. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Je n\'ai pas été déçu ! J\'ai pu passer de la première idée que l\'on se fait quand on surfe sur internet à une idée plus proche de la réalité, quand on suit des enseignements par des sachants. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Voici les principales évolutions de ma vision initiale</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Dans le sud de la France,, sans mettre en place une infrastructure solide, coûteuse et complexe, il n\'est pas possible d\'élever des truites (ce que j\'imaginais initialement) : la truite meurt dans une eau au delà de 26°. Donc il faut en gros choisir des poissons compatibles avec les températures, comme les poissons rouges (non comestibles) ou la carpe. C\'était un peu décevant, mais après avoir vu comment Aquaponia gère ses poissons, après avoir visionné les vidéos de Chris Pagns et François Petite-Gosgnach (Adanat), j\'ai été convaincu de renoncer (temporairement au moins) à la truite. J\'aurais bien opté pour le Tilapia, mais il est interdit en France pour des risque d\'invasion si il aboutissait dans une rivière. Dommage, il adore l\'eau chaude ! </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->','Bienvenue','','inherit','closed','closed','','2-revision-v1','','','2023-08-20 19:06:27','2023-08-20 17:06:27','',2,'http://hs.vicq.org/?p=97',0,'revision','',0);
INSERT INTO `hs_posts` VALUES (98,1,'2023-08-20 19:17:13','2023-08-20 17:17:13','<!-- wp:heading -->\n<h2 class="wp-block-heading">Ce blog est consacré à l\'hydroponie et la bioponie domestiques. </h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Ces deux techniques de culture font partie de la famille des cultures hors-sol sur substrat neutre. Elles consistent à faire pousser des plantes sans terre, sur un substrat neutre (billes d\'argile par exemple), en mettant en place un dispositif efficace pour leur fournir les nutriments nécessaire pour assurer une croissance efficace des racines et des plantes. La recirculation du liquide nutritif évite une grande partie de la consommation d\'eau qui est induite dans la culture en sol. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Origine du projet et cheminement</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>J\'ai commencé à m\'intéresser aux questions de culture urbaines pendant l\'épidémie de COVID. Cet épisode anxiogène m\'a fait m\'interroger sur certaines questions d\'organisation de la société, et aux risques associés à l\'approvisionnement en ville des denrées alimentaires. En effet, il semble qu\'en cas de gros dysfonctionnement de la logistique d\'approvisionnement en nourriture, en quelque jours les villes pourraient se retrouver privées d\'une partie importante de leurs ressources alimentaires. Face à cette potentielle fragilité des flux de transport, il semble intéressant de développer des dispositifs urbains assurant une partie (même réduite) de la production de légumes dans la ville. Des études sur ces sujets existent, mais je ne suis pas un spécialiste de la recherche en agriculture urbaine, j\'essayerai de faire un peu de bibliographie à ce sujet quand j\'aurai le temps.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>De plus, les questions d\'épuisement de la planète sont maintenant au centre des débats, et cultiver des légumes en étant économe en eau et en énergie est un sujet qui m\'intéresse et me semble prometteur pour les temps qui viennent.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Culture hors sol, définitions</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Le web pullule d\'explications sur ces techniques de culture hors sol. Vous pouvez trouver <a href="https://fermedecagnolle.fr/hydroponie-bioponie-aquaponie-definitions/"><strong>ici</strong></a> par exemple des définitions simples de l\'<strong>hydroponie</strong>, <strong>bioponie</strong> et <strong>aquaponie</strong> proposées par Marion Sarlé (<a href="https://lessourciers.com/fr/">les sourciers</a>). Marion Sarlé propose aussi le livre «&nbsp;<em><strong>Monter sa microferme en hydroponie, bioponie et aquaponie</strong></em>&nbsp;», en vente sur le site <a href="https://lessourciers.com/fr/livre-sourciers/">Les Sourciers</a>&nbsp;. Les sourciers proposent aussi des <a href="https://lessourciers.com/fr/les-formations/">formations</a> en ligne et dans leur ferme du Gers. J\'ai suivi la partie en ligne de la formation <a href="https://lessourciers.com/fr/les-formations/microferme-hydroponique/">Microferme Hydroponique</a> qui m\'a bien aidé à comprendre les rudiments de base.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Une fois ces grandes définitions comprises, on trouve de très facilement des informations sur les <strong><a href="https://jardinfute.com/culture-hors-sol/page/2/">nombreux types de dispositifs</a></strong> utilisés pour ce type de culture (ex : <a href="https://jardinfute.com/methode-kratky/">Kratky</a>, <a href="https://jardinfute.com/systeme-dwc-hydroponie/">DWC</a>, <a href="https://jardinfute.com/systeme-nft-hydroponie/">NFT</a>, <a href="https://jardinfute.com/table-a-maree-ebb-flow/">table à marée</a>, etc.). J\'ai choisi les explications sur le site <a href="https://jardinfute.com/">jardinfute.com</a>, mais vous trouverez facilement d\'autres systèmes et d\'autres explications sur internet.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Si l\'on évalue la complexité de ces techniques, on comprend que l\'<strong>hydroponie</strong> est la plus simple des trois, puisqu\'elle se base sur la circulation d\'une solution nutritive contenant des nutriments minéraux (engrais) directement assimilables par les racines des plantes cultivées. En gros, il suffit de faire circuler de l\'eau additionnée d\'engrais sur les racines des plantes.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Quand on regarde les principes de la <strong>bioponie</strong> et l\'<strong>aquaponie</strong>, on comprend que le principe est plus complexe. Dans les deux cas on va transformer des éléments organiques en éléments minéraux pouvant être assimilés par les plantes (minéralisation). Cela est réalisé en deux étapes par l\'action de deux types de bactéries qui vont assurer tout d\'abord la transformation des éléments organiques en nitrites (bactéries <strong>Nitrosomonas</strong>) puis des nitrites en nitrates (bactéries <strong>Nitrobacter</strong>). Dans les deux cas, il faut offrir à ces bactéries un lieu et des conditions de vie, ce qui représente une complexité supplémentaire. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Enfin, pour l\'<strong>aquaponie</strong> il faut aussi s\'occuper de ses poissons, et en particulier gérer les caractéristiques de l\'eau. Des déséquilibres dans le système peuvent rapidement tuer une partie du cheptel, ce qui est plus impactant que de voir mourir un pied de ciboulette.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Bénéfices des systèmes hors-sol</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Les bénéfices de systèmes industriels ne sont pas analysés ici. Mais voici les bénéfices que produit un système opérationnel :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Très faible consommation d\'eau (environ 90 % d\'économie)</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Très faible consommation d\'électricité (pompe 10 W)</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Fort rendement au m2</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Fierté de produire sa nourriture</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>systèmes en hauteur, hors de portée des nuisibles rampants</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Intérêt pédagogique de la culture des plantes, pour tous (des plus petits aux plus grands)</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Système de circulation d\'eau produisant un bruit très agréable sans gêner les voisins</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Premier objectif : construire un système hydroponique</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Pour avoir les meilleures chances de réussite en limitant la complexité du savoir nécessaire et m\'y mettre rapidement, j\'ai choisi de commencer par l\'hydroponie.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>On peut vouloir créer des fermes hydroponiques de taille plus ou moins importante, mais j\'ai décidé de m\'intéresser à des dispositifs mis en œuvre à l\'échelle individuelle ou de proche voisinage, car cela représente des investissements réduits, une capacité de réalisation rapide et un investissement en temps acceptable. De plus, même si l\'ambition de tels systèmes n\'est pas de produire des bénéfices financiers, elle semble intéressante à l\'échelle de l\'individu ou du voisinage.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Prototypes</h2>\n<!-- /wp:heading -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading">Etape 1 : 2021-2022, un petit système hydroponique</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Durant l\'hiver 2021, j\'ai fait des recherches des différents systèmes hydroponiques disponibles et de comment réaliser sois-même ce genre de choses, et j\'ai été rapidement convaincu de l\'idée de commencer petit, afin d\'être prêt et de pouvoir planter dès le printemps 2022. Le retour d\'expérience des personnes expérimentées est unanime : il faut commencer simple et petit. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>De plus, commencer avec un petit système simple n\'a que des avantages pour quelqu\'un comme moi qui aime bricoler : </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Un petit prototype opérationnel est complet, donc on apprendra presque qu\'autant de choses que sur un plus gros système.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Le temps de développement est plus court, on aura ainsi plus de chances d\'aboutir dans des délais imposés par ses propres contraintes quotidiennes et l\'implacable chef d\'orchestre que sont les saisons. Par exemple, en France, il n\'est pas vraiment facile de planter des tomates à l\'automne, il faudra avoir été prêt pour le printemps, ou attendre le printemps suivant. </li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>On réduit le coût de fabrication, le risque financier et le temps passé si l\'on rate sa réalisation ou si on renonce avant la fin.</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:paragraph -->\n<p>J\'ai donc recherché les systèmes hydroponiques disponibles sur le marché ; j\'ai trouvé pa!s mal de systèmes clés en main, plus ou moins aboutis et plus ou moins chers. Pourtant, j\'ai décidé de construire moi-même mon premier système, pour plusieurs raisons :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Je suis convaincu que "mettre la main à la pâte" est souvent une bonne idée pour comprendre plus profondément un système technique,</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>j\'aime bien réaliser des prototypes en adaptant une solution technique existante à mon besoin personnel, cela m\'aide à  réfléchir à une généralisation possible les autres.</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading">Un mini-système hydroponique vertical (4 systèmes identiques testés entre la Provence et la région parisienne)</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>J\'ai choisi de réaliser un système hydroponique vertical, pour prendre peu de place au sol. Pratiquant l\'impression impression 3D, j\'ai décidé de partir d\'un système déjà conçu, et de l\'adapter un peu.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>voici à quoi ce système ressemblait dans sa <a href="https://www.thingiverse.com/thing:3405964/">version originale</a> : </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:columns -->\n<div class="wp-block-columns"><!-- wp:column -->\n<div class="wp-block-column"><!-- wp:image {"width":535,"height":402,"sizeSlug":"large"} -->\n<figure class="wp-block-image size-large is-resized"><img src="https://cdn.thingiverse.com/renders/33/b6/37/85/85/59b0c38e5b805c7dd9b9f5abeee79ca0_preview_featured.jpg" alt="" style="width:535px;height:402px" width="535" height="402"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class="wp-block-column"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>La colonne est creuse est composée de modules empilables, ce qui permet de choisir le nombre de plantes</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>le réservoir en bas contient une pompe, cette dernière remonte l\'eau via un tuyau au centre de la tour jusqu\'à l\'étage supérieur qui et lui même percé de trous...</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>l\'eau passe par ces trous et redescend par gravité jusqu\'au réservoir, en arrosant au passage les racines des plantes maintenues en position dans des billes d\'argile dans les paniers amovibles (couleur ocre) installés dans la tour</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:paragraph -->\n<p>J\'ai du adapter le système de de fixation entre le bas de la tour et mon réservoirs, ainsi que certaines modifications mineures.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Au printemps 2022 J\'ai imprimé et mis en service 4 systèmes modulaires hydroponiques (que l\'on pourrait les qualifier d\'aéro-hydroponiques). Ces systèmes avaient une forme de cylindre creux lequel étaient insérés des paniers contenant des billes d\'argile. En bas de la tour un réservoir de 10 à 20 litres dans lequel une pompe alimentait le haut de la tour par un tuyau, le liquide redescendant dans la tour en imprégnant les racines par gravité.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Trois ont été déployés dans les bouches du Rhône (2 à Marseille, un à Aix-en-Provence), un à Saint-Germain-en-Laye. Merci à Aurélie, Martine et Friquette (ma maman) pour les avoir fait fonctionner.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Le détail et les photos sont disponibles ici</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Les résultats étaient intéressants, j\'ai beaucoup appris de ce système. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading">Etape 2 : 2022-2023, un système hydroponique à Saint-Germain-en-laye (78) et un système bioponique à Marseille (13)</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p> Début 2022, j\'étais très motivé par les principes de l\'aquaponie. La nature symbiotique poissons + plantes, la création d\'un écosystème économe et vertueux, la double production poissons + plantes sur une surface réduite m\'ont donné très envie d\'aller voir de plus près ce genre de systèmes. J\'ai bien sur beaucoup cherché sur internet, vu des réalisations magnifiques (par exemple la chaine de <a href="https://www.youtube.com/@ChrisPagns">Chris Pagns</a> sur youtube).</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>J\'ai cherché si il existant des stages près de chez moi. J\'ai finalement opté pour une initiation à l\'aquaponie chez Aquaponia, by Ecologia, tout près de Laval (en Mayenne). J\'ai choisi ce stage pour les compétences reconnues de Guillaume Beucher, et pour le lieu magique. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Je n\'ai pas été déçu ! J\'ai pu passer de la première idée que l\'on se fait quand on surfe sur internet à une idée plus proche de la réalité, quand on suit des enseignements par des sachants. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Voici les principales évolutions de ma vision initiale</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Dans le sud de la France,, sans mettre en place une infrastructure solide, coûteuse et complexe, il n\'est pas possible d\'élever des truites (ce que j\'imaginais initialement) : la truite meurt dans une eau au delà de 26°. Donc il faut en gros choisir des poissons compatibles avec les températures, comme les poissons rouges (non comestibles) ou la carpe. C\'était un peu décevant, mais après avoir vu comment Aquaponia gère ses poissons, après avoir visionné les <a href="https://www.youtube.com/watch?v=x4hBJlt6PMI&amp;t=425s">vidéos de Chris Pagns</a> et lu les <a href="https://www.amazon.fr/Aquaponie-guide-r%C3%A9f%C3%A9rence-Fran%C3%A7ois-Petitet-Gosgnach/dp/2815310252/ref=sr_1_1?__mk_fr_FR=%C3%85M%C3%85%C5%BD%C3%95%C3%91&amp;crid=1XD7AW59VAHUS&amp;keywords=aquaponie+petitet&amp;qid=1692551785&amp;sprefix=aquaponie+petitet%2Caps%2C126&amp;sr=8-1">livres de référence de l\'aquaponie de François Petitet-Gosgnach</a> (Adanat), j\'ai été convaincu de renoncer (temporairement au moins) à la truite. J\'aurais bien opté pour le Tilapia, mais il est interdit en France pour des risque d\'invasion si il aboutissait dans une rivière. Dommage, il adore l\'eau chaude ! </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->','Bienvenue','','inherit','closed','closed','','2-revision-v1','','','2023-08-20 19:17:13','2023-08-20 17:17:13','',2,'http://hs.vicq.org/?p=98',0,'revision','',0);
INSERT INTO `hs_posts` VALUES (99,1,'2023-08-20 19:18:27','2023-08-20 17:18:27','<!-- wp:heading -->\n<h2 class="wp-block-heading">Ce blog est consacré à l\'hydroponie et la bioponie domestiques. </h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Ces deux techniques de culture font partie de la famille des cultures hors-sol sur substrat neutre. Elles consistent à faire pousser des plantes sans terre, sur un substrat neutre (billes d\'argile par exemple), en mettant en place un dispositif efficace pour leur fournir les nutriments nécessaire pour assurer une croissance efficace des racines et des plantes. La recirculation du liquide nutritif évite une grande partie de la consommation d\'eau qui est induite dans la culture en sol. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Origine du projet et cheminement</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>J\'ai commencé à m\'intéresser aux questions de culture urbaines pendant l\'épidémie de COVID. Cet épisode anxiogène m\'a fait m\'interroger sur certaines questions d\'organisation de la société, et aux risques associés à l\'approvisionnement en ville des denrées alimentaires. En effet, il semble qu\'en cas de gros dysfonctionnement de la logistique d\'approvisionnement en nourriture, en quelque jours les villes pourraient se retrouver privées d\'une partie importante de leurs ressources alimentaires. Face à cette potentielle fragilité des flux de transport, il semble intéressant de développer des dispositifs urbains assurant une partie (même réduite) de la production de légumes dans la ville. Des études sur ces sujets existent, mais je ne suis pas un spécialiste de la recherche en agriculture urbaine, j\'essayerai de faire un peu de bibliographie à ce sujet quand j\'aurai le temps.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>De plus, les questions d\'épuisement de la planète sont maintenant au centre des débats, et cultiver des légumes en étant économe en eau et en énergie est un sujet qui m\'intéresse et me semble prometteur pour les temps qui viennent.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Culture hors sol, définitions</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Le web pullule d\'explications sur ces techniques de culture hors sol. Vous pouvez trouver <a href="https://fermedecagnolle.fr/hydroponie-bioponie-aquaponie-definitions/"><strong>ici</strong></a> par exemple des définitions simples de l\'<strong>hydroponie</strong>, <strong>bioponie</strong> et <strong>aquaponie</strong> proposées par Marion Sarlé (<a href="https://lessourciers.com/fr/">les sourciers</a>). Marion Sarlé propose aussi le livre «&nbsp;<em><strong>Monter sa microferme en hydroponie, bioponie et aquaponie</strong></em>&nbsp;», en vente sur le site <a href="https://lessourciers.com/fr/livre-sourciers/">Les Sourciers</a>&nbsp;. Les sourciers proposent aussi des <a href="https://lessourciers.com/fr/les-formations/">formations</a> en ligne et dans leur ferme du Gers. J\'ai suivi la partie en ligne de la formation <a href="https://lessourciers.com/fr/les-formations/microferme-hydroponique/">Microferme Hydroponique</a> qui m\'a bien aidé à comprendre les rudiments de base.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Une fois ces grandes définitions comprises, on trouve de très facilement des informations sur les <strong><a href="https://jardinfute.com/culture-hors-sol/page/2/">nombreux types de dispositifs</a></strong> utilisés pour ce type de culture (ex : <a href="https://jardinfute.com/methode-kratky/">Kratky</a>, <a href="https://jardinfute.com/systeme-dwc-hydroponie/">DWC</a>, <a href="https://jardinfute.com/systeme-nft-hydroponie/">NFT</a>, <a href="https://jardinfute.com/table-a-maree-ebb-flow/">table à marée</a>, etc.). J\'ai choisi les explications sur le site <a href="https://jardinfute.com/">jardinfute.com</a>, mais vous trouverez facilement d\'autres systèmes et d\'autres explications sur internet.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Si l\'on évalue la complexité de ces techniques, on comprend que l\'<strong>hydroponie</strong> est la plus simple des trois, puisqu\'elle se base sur la circulation d\'une solution nutritive contenant des nutriments minéraux (engrais) directement assimilables par les racines des plantes cultivées. En gros, il suffit de faire circuler de l\'eau additionnée d\'engrais sur les racines des plantes.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Quand on regarde les principes de la <strong>bioponie</strong> et l\'<strong>aquaponie</strong>, on comprend que le principe est plus complexe. Dans les deux cas on va transformer des éléments organiques en éléments minéraux pouvant être assimilés par les plantes (minéralisation). Cela est réalisé en deux étapes par l\'action de deux types de bactéries qui vont assurer tout d\'abord la transformation des éléments organiques en nitrites (bactéries <strong>Nitrosomonas</strong>) puis des nitrites en nitrates (bactéries <strong>Nitrobacter</strong>). Dans les deux cas, il faut offrir à ces bactéries un lieu et des conditions de vie, ce qui représente une complexité supplémentaire. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Enfin, pour l\'<strong>aquaponie</strong> il faut aussi s\'occuper de ses poissons, et en particulier gérer les caractéristiques de l\'eau. Des déséquilibres dans le système peuvent rapidement tuer une partie du cheptel, ce qui est plus impactant que de voir mourir un pied de ciboulette.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Bénéfices des systèmes hors-sol</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Les bénéfices de systèmes industriels ne sont pas analysés ici. Mais voici les bénéfices que produit un système opérationnel :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Très faible consommation d\'eau (environ 90 % d\'économie)</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Très faible consommation d\'électricité (pompe 10 W)</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Fort rendement au m2</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Fierté de produire sa nourriture</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>systèmes en hauteur, hors de portée des nuisibles rampants</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Intérêt pédagogique de la culture des plantes, pour tous (des plus petits aux plus grands)</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Système de circulation d\'eau produisant un bruit très agréable sans gêner les voisins</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Premier objectif : construire un système hydroponique</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Pour avoir les meilleures chances de réussite en limitant la complexité du savoir nécessaire et m\'y mettre rapidement, j\'ai choisi de commencer par l\'hydroponie.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>On peut vouloir créer des fermes hydroponiques de taille plus ou moins importante, mais j\'ai décidé de m\'intéresser à des dispositifs mis en œuvre à l\'échelle individuelle ou de proche voisinage, car cela représente des investissements réduits, une capacité de réalisation rapide et un investissement en temps acceptable. De plus, même si l\'ambition de tels systèmes n\'est pas de produire des bénéfices financiers, elle semble intéressante à l\'échelle de l\'individu ou du voisinage.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Prototypes</h2>\n<!-- /wp:heading -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading">Etape 1 : 2021-2022, un petit système hydroponique</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Durant l\'hiver 2021, j\'ai fait des recherches des différents systèmes hydroponiques disponibles et de comment réaliser sois-même ce genre de choses, et j\'ai été rapidement convaincu de l\'idée de commencer petit, afin d\'être prêt et de pouvoir planter dès le printemps 2022. Le retour d\'expérience des personnes expérimentées est unanime : il faut commencer simple et petit. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>De plus, commencer avec un petit système simple n\'a que des avantages pour quelqu\'un comme moi qui aime bricoler : </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Un petit prototype opérationnel est complet, donc on apprendra presque qu\'autant de choses que sur un plus gros système.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Le temps de développement est plus court, on aura ainsi plus de chances d\'aboutir dans des délais imposés par ses propres contraintes quotidiennes et l\'implacable chef d\'orchestre que sont les saisons. Par exemple, en France, il n\'est pas vraiment facile de planter des tomates à l\'automne, il faudra avoir été prêt pour le printemps, ou attendre le printemps suivant. </li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>On réduit le coût de fabrication, le risque financier et le temps passé si l\'on rate sa réalisation ou si on renonce avant la fin.</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:paragraph -->\n<p>J\'ai donc recherché les systèmes hydroponiques disponibles sur le marché ; j\'ai trouvé pa!s mal de systèmes clés en main, plus ou moins aboutis et plus ou moins chers. Pourtant, j\'ai décidé de construire moi-même mon premier système, pour plusieurs raisons :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Je suis convaincu que "mettre la main à la pâte" est souvent une bonne idée pour comprendre plus profondément un système technique,</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>j\'aime bien réaliser des prototypes en adaptant une solution technique existante à mon besoin personnel, cela m\'aide à  réfléchir à une généralisation possible les autres.</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading">Un mini-système hydroponique vertical (4 systèmes identiques testés entre la Provence et la région parisienne)</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>J\'ai choisi de réaliser un système hydroponique vertical, pour prendre peu de place au sol. Pratiquant l\'impression impression 3D, j\'ai décidé de partir d\'un système déjà conçu, et de l\'adapter un peu.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>voici à quoi ce système ressemblait dans sa <a href="https://www.thingiverse.com/thing:3405964/">version originale</a> : </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:columns -->\n<div class="wp-block-columns"><!-- wp:column -->\n<div class="wp-block-column"><!-- wp:image {"width":535,"height":402,"sizeSlug":"large"} -->\n<figure class="wp-block-image size-large is-resized"><img src="https://cdn.thingiverse.com/renders/33/b6/37/85/85/59b0c38e5b805c7dd9b9f5abeee79ca0_preview_featured.jpg" alt="" style="width:535px;height:402px" width="535" height="402"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class="wp-block-column"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>La colonne est creuse est composée de modules empilables, ce qui permet de choisir le nombre de plantes</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>le réservoir en bas contient une pompe, cette dernière remonte l\'eau via un tuyau au centre de la tour jusqu\'à l\'étage supérieur qui et lui même percé de trous...</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>l\'eau passe par ces trous et redescend par gravité jusqu\'au réservoir, en arrosant au passage les racines des plantes maintenues en position dans des billes d\'argile dans les paniers amovibles (couleur ocre) installés dans la tour</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:paragraph -->\n<p>J\'ai du adapter le système de de fixation entre le bas de la tour et mon réservoirs, ainsi que certaines modifications mineures.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Au printemps 2022 J\'ai imprimé et mis en service 4 systèmes modulaires hydroponiques (que l\'on pourrait les qualifier d\'aéro-hydroponiques). Ces systèmes avaient une forme de cylindre creux lequel étaient insérés des paniers contenant des billes d\'argile. En bas de la tour un réservoir de 10 à 20 litres dans lequel une pompe alimentait le haut de la tour par un tuyau, le liquide redescendant dans la tour en imprégnant les racines par gravité.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Trois ont été déployés dans les bouches du Rhône (2 à Marseille, un à Aix-en-Provence), un à Saint-Germain-en-Laye. Merci à Aurélie, Martine et Friquette (ma maman) pour les avoir fait fonctionner.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Le détail et les photos sont disponibles ici</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Les résultats étaient intéressants, j\'ai beaucoup appris de ce système. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading">Etape 2 : 2022-2023, un système hydroponique à Saint-Germain-en-laye (78) et un système bioponique à Marseille (13)</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p> Début 2022, j\'étais très motivé par les principes de l\'aquaponie. La nature symbiotique poissons + plantes, la création d\'un écosystème économe et vertueux, la double production poissons + plantes sur une surface réduite m\'ont donné très envie d\'aller voir de plus près ce genre de systèmes. J\'ai bien sur beaucoup cherché sur internet, vu des réalisations magnifiques (par exemple la chaine de <a href="https://www.youtube.com/@ChrisPagns" target="_blank" rel="noreferrer noopener">Chris Pagns</a> sur youtube).</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>J\'ai cherché si il existant des stages près de chez moi. J\'ai finalement opté pour une initiation à l\'aquaponie chez Aquaponia, by Ecologia, tout près de Laval (en Mayenne). J\'ai choisi ce stage pour les compétences reconnues de Guillaume Beucher, et pour le lieu magique. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Je n\'ai pas été déçu ! J\'ai pu passer de la première idée que l\'on se fait quand on surfe sur internet à une idée plus proche de la réalité, quand on suit des enseignements par des sachants. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Voici les principales évolutions de ma vision initiale</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Dans le sud de la France,, sans mettre en place une infrastructure solide, coûteuse et complexe, il n\'est pas possible d\'élever des truites (ce que j\'imaginais initialement) : la truite meurt dans une eau au delà de 26°. Donc il faut en gros choisir des poissons compatibles avec les températures, comme les poissons rouges (non comestibles) ou la carpe. C\'était un peu décevant, mais après avoir vu comment Aquaponia gère ses poissons, après avoir visionné les <a href="https://www.youtube.com/watch?v=x4hBJlt6PMI&amp;t=425s" target="_blank" rel="noreferrer noopener">vidéos de Chris Pagns</a> et lu les <a href="https://www.amazon.fr/Aquaponie-guide-r%C3%A9f%C3%A9rence-Fran%C3%A7ois-Petitet-Gosgnach/dp/2815310252/ref=sr_1_1?__mk_fr_FR=%C3%85M%C3%85%C5%BD%C3%95%C3%91&amp;crid=1XD7AW59VAHUS&amp;keywords=aquaponie+petitet&amp;qid=1692551785&amp;sprefix=aquaponie+petitet%2Caps%2C126&amp;sr=8-1" target="_blank" rel="noreferrer noopener">livres de référence de l\'aquaponie de François Petitet-Gosgnach</a> (Adanat), j\'ai été convaincu de renoncer (temporairement au moins) à la truite. J\'aurais bien opté pour le Tilapia, mais il est interdit en France pour des risque d\'invasion si il aboutissait dans une rivière. Dommage, il adore l\'eau chaude ! </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->','Bienvenue','','inherit','closed','closed','','2-revision-v1','','','2023-08-20 19:18:27','2023-08-20 17:18:27','',2,'http://hs.vicq.org/?p=99',0,'revision','',0);
INSERT INTO `hs_posts` VALUES (100,1,'2023-08-20 19:21:56','2023-08-20 17:21:56','<!-- wp:heading -->\n<h2 class="wp-block-heading">Ce blog est consacré à l\'hydroponie et la bioponie domestiques. </h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Ces deux techniques de culture font partie de la famille des cultures hors-sol sur substrat neutre. Elles consistent à faire pousser des plantes sans terre, sur un substrat neutre (billes d\'argile par exemple), en mettant en place un dispositif efficace pour leur fournir les nutriments nécessaire pour assurer une croissance efficace des racines et des plantes. La recirculation du liquide nutritif évite une grande partie de la consommation d\'eau qui est induite dans la culture en sol. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Origine du projet et cheminement</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>J\'ai commencé à m\'intéresser aux questions de culture urbaines pendant l\'épidémie de COVID. Cet épisode anxiogène m\'a fait m\'interroger sur certaines questions d\'organisation de la société, et aux risques associés à l\'approvisionnement en ville des denrées alimentaires. En effet, il semble qu\'en cas de gros dysfonctionnement de la logistique d\'approvisionnement en nourriture, en quelque jours les villes pourraient se retrouver privées d\'une partie importante de leurs ressources alimentaires. Face à cette potentielle fragilité des flux de transport, il semble intéressant de développer des dispositifs urbains assurant une partie (même réduite) de la production de légumes dans la ville. Des études sur ces sujets existent, mais je ne suis pas un spécialiste de la recherche en agriculture urbaine, j\'essayerai de faire un peu de bibliographie à ce sujet quand j\'aurai le temps.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>De plus, les questions d\'épuisement de la planète sont maintenant au centre des débats, et cultiver des légumes en étant économe en eau et en énergie est un sujet qui m\'intéresse et me semble prometteur pour les temps qui viennent.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Culture hors sol, définitions</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Le web pullule d\'explications sur ces techniques de culture hors sol. Vous pouvez trouver <a href="https://fermedecagnolle.fr/hydroponie-bioponie-aquaponie-definitions/"><strong>ici</strong></a> par exemple des définitions simples de l\'<strong>hydroponie</strong>, <strong>bioponie</strong> et <strong>aquaponie</strong> proposées par Marion Sarlé (<a href="https://lessourciers.com/fr/">les sourciers</a>). Marion Sarlé propose aussi le livre «&nbsp;<em><strong>Monter sa microferme en hydroponie, bioponie et aquaponie</strong></em>&nbsp;», en vente sur le site <a href="https://lessourciers.com/fr/livre-sourciers/">Les Sourciers</a>&nbsp;. Les sourciers proposent aussi des <a href="https://lessourciers.com/fr/les-formations/">formations</a> en ligne et dans leur ferme du Gers. J\'ai suivi la partie en ligne de la formation <a href="https://lessourciers.com/fr/les-formations/microferme-hydroponique/">Microferme Hydroponique</a> qui m\'a bien aidé à comprendre les rudiments de base.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Une fois ces grandes définitions comprises, on trouve de très facilement des informations sur les <strong><a href="https://jardinfute.com/culture-hors-sol/page/2/">nombreux types de dispositifs</a></strong> utilisés pour ce type de culture (ex : <a href="https://jardinfute.com/methode-kratky/">Kratky</a>, <a href="https://jardinfute.com/systeme-dwc-hydroponie/">DWC</a>, <a href="https://jardinfute.com/systeme-nft-hydroponie/">NFT</a>, <a href="https://jardinfute.com/table-a-maree-ebb-flow/">table à marée</a>, etc.). J\'ai choisi les explications sur le site <a href="https://jardinfute.com/">jardinfute.com</a>, mais vous trouverez facilement d\'autres systèmes et d\'autres explications sur internet.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Si l\'on évalue la complexité de ces techniques, on comprend que l\'<strong>hydroponie</strong> est la plus simple des trois, puisqu\'elle se base sur la circulation d\'une solution nutritive contenant des nutriments minéraux (engrais) directement assimilables par les racines des plantes cultivées. En gros, il suffit de faire circuler de l\'eau additionnée d\'engrais sur les racines des plantes.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Quand on regarde les principes de la <strong>bioponie</strong> et l\'<strong>aquaponie</strong>, on comprend que le principe est plus complexe. Dans les deux cas on va transformer des éléments organiques en éléments minéraux pouvant être assimilés par les plantes (minéralisation). Cela est réalisé en deux étapes par l\'action de deux types de bactéries qui vont assurer tout d\'abord la transformation des éléments organiques en nitrites (bactéries <strong>Nitrosomonas</strong>) puis des nitrites en nitrates (bactéries <strong>Nitrobacter</strong>). Dans les deux cas, il faut offrir à ces bactéries un lieu et des conditions de vie, ce qui représente une complexité supplémentaire. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Enfin, pour l\'<strong>aquaponie</strong> il faut aussi s\'occuper de ses poissons, et en particulier gérer les caractéristiques de l\'eau. Des déséquilibres dans le système peuvent rapidement tuer une partie du cheptel, ce qui est plus impactant que de voir mourir un pied de ciboulette.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Bénéfices des systèmes hors-sol</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Les bénéfices de systèmes industriels ne sont pas analysés ici. Mais voici les bénéfices que produit un système opérationnel :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Très faible consommation d\'eau (environ 90 % d\'économie)</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Très faible consommation d\'électricité (pompe 10 W)</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Fort rendement au m2</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Fierté de produire sa nourriture</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>systèmes en hauteur, hors de portée des nuisibles rampants</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Intérêt pédagogique de la culture des plantes, pour tous (des plus petits aux plus grands)</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Système de circulation d\'eau produisant un bruit très agréable sans gêner les voisins</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Premier objectif : construire un système hydroponique</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Pour avoir les meilleures chances de réussite en limitant la complexité du savoir nécessaire et m\'y mettre rapidement, j\'ai choisi de commencer par l\'hydroponie.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>On peut vouloir créer des fermes hydroponiques de taille plus ou moins importante, mais j\'ai décidé de m\'intéresser à des dispositifs mis en œuvre à l\'échelle individuelle ou de proche voisinage, car cela représente des investissements réduits, une capacité de réalisation rapide et un investissement en temps acceptable. De plus, même si l\'ambition de tels systèmes n\'est pas de produire des bénéfices financiers, elle semble intéressante à l\'échelle de l\'individu ou du voisinage.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Prototypes</h2>\n<!-- /wp:heading -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading">Etape 1 : 2021-2022, un petit système hydroponique</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Durant l\'hiver 2021, j\'ai fait des recherches des différents systèmes hydroponiques disponibles et de comment réaliser sois-même ce genre de choses, et j\'ai été rapidement convaincu de l\'idée de commencer petit, afin d\'être prêt et de pouvoir planter dès le printemps 2022. Le retour d\'expérience des personnes expérimentées est unanime : il faut commencer simple et petit. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>De plus, commencer avec un petit système simple n\'a que des avantages pour quelqu\'un comme moi qui aime bricoler : </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Un petit prototype opérationnel est complet, donc on apprendra presque qu\'autant de choses que sur un plus gros système.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Le temps de développement est plus court, on aura ainsi plus de chances d\'aboutir dans des délais imposés par ses propres contraintes quotidiennes et l\'implacable chef d\'orchestre que sont les saisons. Par exemple, en France, il n\'est pas vraiment facile de planter des tomates à l\'automne, il faudra avoir été prêt pour le printemps, ou attendre le printemps suivant. </li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>On réduit le coût de fabrication, le risque financier et le temps passé si l\'on rate sa réalisation ou si on renonce avant la fin.</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:paragraph -->\n<p>J\'ai donc recherché les systèmes hydroponiques disponibles sur le marché ; j\'ai trouvé pa!s mal de systèmes clés en main, plus ou moins aboutis et plus ou moins chers. Pourtant, j\'ai décidé de construire moi-même mon premier système, pour plusieurs raisons :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Je suis convaincu que "mettre la main à la pâte" est souvent une bonne idée pour comprendre plus profondément un système technique,</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>j\'aime bien réaliser des prototypes en adaptant une solution technique existante à mon besoin personnel, cela m\'aide à  réfléchir à une généralisation possible les autres.</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading">Un mini-système hydroponique vertical (4 systèmes identiques testés entre la Provence et la région parisienne)</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>J\'ai choisi de réaliser un système hydroponique vertical, pour prendre peu de place au sol. Pratiquant l\'impression impression 3D, j\'ai décidé de partir d\'un système déjà conçu, et de l\'adapter un peu.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>voici à quoi ce système ressemblait dans sa <a href="https://www.thingiverse.com/thing:3405964/">version originale</a> : </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:columns -->\n<div class="wp-block-columns"><!-- wp:column -->\n<div class="wp-block-column"><!-- wp:image {"width":535,"height":402,"sizeSlug":"large"} -->\n<figure class="wp-block-image size-large is-resized"><img src="https://cdn.thingiverse.com/renders/33/b6/37/85/85/59b0c38e5b805c7dd9b9f5abeee79ca0_preview_featured.jpg" alt="" style="width:535px;height:402px" width="535" height="402"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class="wp-block-column"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>La colonne est creuse est composée de modules empilables, ce qui permet de choisir le nombre de plantes</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>le réservoir en bas contient une pompe, cette dernière remonte l\'eau via un tuyau au centre de la tour jusqu\'à l\'étage supérieur qui et lui même percé de trous...</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>l\'eau passe par ces trous et redescend par gravité jusqu\'au réservoir, en arrosant au passage les racines des plantes maintenues en position dans des billes d\'argile dans les paniers amovibles (couleur ocre) installés dans la tour</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:paragraph -->\n<p>J\'ai du adapter le système de de fixation entre le bas de la tour et mon réservoirs, ainsi que certaines modifications mineures.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Au printemps 2022 J\'ai imprimé et mis en service 4 systèmes modulaires hydroponiques (que l\'on pourrait les qualifier d\'aéro-hydroponiques). Ces systèmes avaient une forme de cylindre creux lequel étaient insérés des paniers contenant des billes d\'argile. En bas de la tour un réservoir de 10 à 20 litres dans lequel une pompe alimentait le haut de la tour par un tuyau, le liquide redescendant dans la tour en imprégnant les racines par gravité.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Trois ont été déployés dans les bouches du Rhône (2 à Marseille, un à Aix-en-Provence), un à Saint-Germain-en-Laye. Merci à Aurélie, Martine et Friquette (ma maman) pour les avoir fait fonctionner.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Le détail et les photos sont disponibles ici</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Les résultats étaient intéressants, j\'ai beaucoup appris de ce système. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading">Etape 2 : 2022-2023, un système hydroponique à Saint-Germain-en-laye (78) et un système bioponique à Marseille (13)</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p> Début 2022, j\'étais très motivé par les principes de l\'aquaponie. La nature symbiotique poissons + plantes, la création d\'un écosystème économe et vertueux, la double production poissons + plantes sur une surface réduite m\'ont donné très envie d\'aller voir de plus près ce genre de systèmes. J\'ai bien sur beaucoup cherché sur internet, vu des réalisations magnifiques (par exemple la chaine de <a href="https://www.youtube.com/@ChrisPagns" target="_blank" rel="noreferrer noopener">Chris Pagns</a> sur youtube).</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>J\'ai cherché si il existant des stages près de chez moi. J\'ai finalement opté pour une initiation à l\'aquaponie chez Aquaponia, by Ecologia, tout près de Laval (en Mayenne). J\'ai choisi ce stage pour les compétences reconnues de Guillaume Beucher, et pour le lieu magique. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Je n\'ai pas été déçu ! J\'ai pu passer de la première idée que l\'on se fait quand on surfe sur internet à une idée plus proche de la réalité, quand on suit des enseignements par des sachants. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Voici les principales évolutions de ma vision initiale</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Dans le sud de la France, sans mettre en place une infrastructure solide, coûteuse et complexe, il est très complexe (ou couteux) d\'élever des truites (ce que je souhaitais faire initialement) : la truite meurt dans une eau au delà de 26°. Donc il faut en gros choisir des poissons compatibles avec les températures, comme les poissons rouges (non comestibles) ou la carpe. C\'était un peu décevant, mais après avoir vu comment Aquaponia gère ses poissons, après avoir visionné les <a rel="noreferrer noopener" href="https://www.youtube.com/watch?v=x4hBJlt6PMI&amp;t=425s" target="_blank">vidéos de Chris Pagns</a> et lu les <a rel="noreferrer noopener" href="https://www.amazon.fr/Aquaponie-guide-r%C3%A9f%C3%A9rence-Fran%C3%A7ois-Petitet-Gosgnach/dp/2815310252/ref=sr_1_1?__mk_fr_FR=%C3%85M%C3%85%C5%BD%C3%95%C3%91&amp;crid=1XD7AW59VAHUS&amp;keywords=aquaponie+petitet&amp;qid=1692551785&amp;sprefix=aquaponie+petitet%2Caps%2C126&amp;sr=8-1" target="_blank">livres de référence de l\'aquaponie de François Petitet-Gosgnach</a> (Adanat), j\'ai été convaincu de renoncer (temporairement au moins) à la truite. J\'aurais bien opté pour le Tilapia, mais il est interdit en France pour des risque d\'invasion si il aboutissait dans une rivière. Dommage, il adore l\'eau chaude ! </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>De plus, même si j\'ai la chance d\'avoir un jardin, pour réduire la température de l\'eau le bac à poissons doit être enterré. Comme je suis locataire, j\'ai renoncé à creuser dans le jardin. Il faut parfois réduire ses ambitions. Après mures réflexions, j\'ai donc décidé de ne pas me lancer immédiatement dans l\'aquaponie.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->','Bienvenue','','inherit','closed','closed','','2-revision-v1','','','2023-08-20 19:21:56','2023-08-20 17:21:56','',2,'http://hs.vicq.org/?p=100',0,'revision','',0);
INSERT INTO `hs_posts` VALUES (102,1,'2023-08-23 19:19:15','2023-08-23 17:19:15','<!-- wp:heading -->\n<h2 class="wp-block-heading">Ce blog est consacré à l\'hydroponie et la bioponie domestiques. </h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Ces deux techniques de culture font partie de la famille des cultures hors-sol sur substrat neutre. Elles consistent à faire pousser des plantes sans terre, sur un substrat neutre (billes d\'argile par exemple), en mettant en place un dispositif efficace pour leur fournir les nutriments nécessaire pour assurer une croissance efficace des racines et des plantes. La recirculation du liquide nutritif évite une grande partie de la consommation d\'eau qui est induite dans la culture en sol. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Origine du projet et cheminement</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>J\'ai commencé à m\'intéresser aux questions de culture urbaines pendant l\'épidémie de COVID. Cet épisode anxiogène m\'a fait m\'interroger sur certaines questions d\'organisation de la société, et aux risques associés à l\'approvisionnement en ville des denrées alimentaires. En effet, il semble qu\'en cas de gros dysfonctionnement de la logistique d\'approvisionnement en nourriture, en quelque jours les villes pourraient se retrouver privées d\'une partie importante de leurs ressources alimentaires. Face à cette potentielle fragilité des flux de transport, il semble intéressant de développer des dispositifs urbains assurant une partie (même réduite) de la production de légumes dans la ville. Des études sur ces sujets existent, mais je ne suis pas un spécialiste de la recherche en agriculture urbaine, j\'essayerai de faire un peu de bibliographie à ce sujet quand j\'aurai le temps.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>De plus, les questions d\'épuisement de la planète sont maintenant au centre des débats, et cultiver des légumes en étant économe en eau et en énergie est un sujet qui m\'intéresse et me semble prometteur pour les temps qui viennent.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Culture hors sol, définitions</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Le web pullule d\'explications sur ces techniques de culture hors sol. Vous pouvez trouver <a href="https://fermedecagnolle.fr/hydroponie-bioponie-aquaponie-definitions/"><strong>ici</strong></a> par exemple des définitions simples de l\'<strong>hydroponie</strong>, <strong>bioponie</strong> et <strong>aquaponie</strong> proposées par Marion Sarlé (<a href="https://lessourciers.com/fr/">les sourciers</a>). Marion Sarlé propose aussi le livre «&nbsp;<em><strong>Monter sa microferme en hydroponie, bioponie et aquaponie</strong></em>&nbsp;», en vente sur le site <a href="https://lessourciers.com/fr/livre-sourciers/">Les Sourciers</a>&nbsp;. Les sourciers proposent aussi des <a href="https://lessourciers.com/fr/les-formations/">formations</a> en ligne et dans leur ferme du Gers. J\'ai suivi la partie en ligne de la formation <a href="https://lessourciers.com/fr/les-formations/microferme-hydroponique/">Microferme Hydroponique</a> qui m\'a bien aidé à comprendre les rudiments de base.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Une fois ces grandes définitions comprises, on trouve de très facilement des informations sur les <strong><a href="https://jardinfute.com/culture-hors-sol/page/2/">nombreux types de dispositifs</a></strong> utilisés pour ce type de culture (ex : <a href="https://jardinfute.com/methode-kratky/">Kratky</a>, <a href="https://jardinfute.com/systeme-dwc-hydroponie/">DWC</a>, <a href="https://jardinfute.com/systeme-nft-hydroponie/">NFT</a>, <a href="https://jardinfute.com/table-a-maree-ebb-flow/">table à marée</a>, etc.). J\'ai choisi les explications sur le site <a href="https://jardinfute.com/">jardinfute.com</a>, mais vous trouverez facilement d\'autres systèmes et d\'autres explications sur internet.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Si l\'on évalue la complexité de ces techniques, on comprend que l\'<strong>hydroponie</strong> est la plus simple des trois, puisqu\'elle se base sur la circulation d\'une solution nutritive contenant des nutriments minéraux (engrais) directement assimilables par les racines des plantes cultivées. En gros, il suffit de faire circuler de l\'eau additionnée d\'engrais sur les racines des plantes.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Quand on regarde les principes de la <strong>bioponie</strong> et l\'<strong>aquaponie</strong>, on comprend que le principe est plus complexe. Dans les deux cas on va transformer des éléments organiques en éléments minéraux pouvant être assimilés par les plantes (minéralisation). Cela est réalisé en deux étapes par l\'action de deux types de bactéries qui vont assurer tout d\'abord la transformation des éléments organiques en nitrites (bactéries <strong>Nitrosomonas</strong>) puis des nitrites en nitrates (bactéries <strong>Nitrobacter</strong>). Dans les deux cas, il faut offrir à ces bactéries un lieu et des conditions de vie, ce qui représente une complexité supplémentaire. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Enfin, pour l\'<strong>aquaponie</strong> il faut aussi s\'occuper de ses poissons, et en particulier gérer les caractéristiques de l\'eau. Des déséquilibres dans le système peuvent rapidement tuer une partie du cheptel, ce qui est plus impactant que de voir mourir un pied de ciboulette.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Bénéfices des systèmes hors-sol</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Les bénéfices de systèmes industriels ne sont pas analysés ici. Mais voici les bénéfices que produit un système opérationnel :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Très faible consommation d\'eau (environ 90 % d\'économie)</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Très faible consommation d\'électricité (pompe 10 W)</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Fort rendement au m2</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Fierté de produire sa nourriture</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>systèmes en hauteur, hors de portée des nuisibles rampants</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Intérêt pédagogique de la culture des plantes, pour tous (des plus petits aux plus grands)</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Système de circulation d\'eau produisant un bruit très agréable sans gêner les voisins</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Premier objectif : construire un système hydroponique</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Pour avoir les meilleures chances de réussite en limitant la complexité du savoir nécessaire et m\'y mettre rapidement, j\'ai choisi de commencer par l\'hydroponie.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>On peut vouloir créer des fermes hydroponiques de taille plus ou moins importante, mais j\'ai décidé de m\'intéresser à des dispositifs mis en œuvre à l\'échelle individuelle ou de proche voisinage, car cela représente des investissements réduits, une capacité de réalisation rapide et un investissement en temps acceptable. De plus, même si l\'ambition de tels systèmes n\'est pas de produire des bénéfices financiers, elle semble intéressante à l\'échelle de l\'individu ou du voisinage.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Prototypes</h2>\n<!-- /wp:heading -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading">Etape 1 : 2021-2022, un petit système hydroponique</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Durant l\'hiver 2021, j\'ai fait des recherches des différents systèmes hydroponiques disponibles et de comment réaliser sois-même ce genre de choses, et j\'ai été rapidement convaincu de l\'idée de commencer petit, afin d\'être prêt et de pouvoir planter dès le printemps 2022. Le retour d\'expérience des personnes expérimentées est unanime : il faut commencer simple et petit. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>De plus, commencer avec un petit système simple n\'a que des avantages pour quelqu\'un comme moi qui aime bricoler : </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Un petit prototype opérationnel est complet, donc on apprendra presque qu\'autant de choses que sur un plus gros système.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Le temps de développement est plus court, on aura ainsi plus de chances d\'aboutir dans des délais imposés par ses propres contraintes quotidiennes et l\'implacable chef d\'orchestre que sont les saisons. Par exemple, en France, il n\'est pas vraiment facile de planter des tomates à l\'automne, il faudra avoir été prêt pour le printemps, ou attendre le printemps suivant. </li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>On réduit le coût de fabrication, le risque financier et le temps passé si l\'on rate sa réalisation ou si on renonce avant la fin.</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:paragraph -->\n<p>J\'ai donc recherché les systèmes hydroponiques disponibles sur le marché ; j\'ai trouvé pa!s mal de systèmes clés en main, plus ou moins aboutis et plus ou moins chers. Pourtant, j\'ai décidé de construire moi-même mon premier système, pour plusieurs raisons :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Je suis convaincu que "mettre la main à la pâte" est souvent une bonne idée pour comprendre plus profondément un système technique,</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>j\'aime bien réaliser des prototypes en adaptant une solution technique existante à mon besoin personnel, cela m\'aide à  réfléchir à une généralisation possible les autres.</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading">Un mini-système hydroponique vertical (4 systèmes identiques testés entre la Provence et la région parisienne)</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>J\'ai choisi de réaliser un système hydroponique vertical, pour prendre peu de place au sol. Pratiquant l\'impression impression 3D, j\'ai décidé de partir d\'un système déjà conçu, et de l\'adapter un peu.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>voici à quoi ce système ressemblait dans sa <a href="https://www.thingiverse.com/thing:3405964/">version originale</a> : </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:columns -->\n<div class="wp-block-columns"><!-- wp:column -->\n<div class="wp-block-column"><!-- wp:image {"width":535,"height":402,"sizeSlug":"large"} -->\n<figure class="wp-block-image size-large is-resized"><img src="https://cdn.thingiverse.com/renders/33/b6/37/85/85/59b0c38e5b805c7dd9b9f5abeee79ca0_preview_featured.jpg" alt="" style="width:535px;height:402px" width="535" height="402"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class="wp-block-column"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>La colonne est creuse est composée de modules empilables, ce qui permet de choisir le nombre de plantes</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>le réservoir en bas contient une pompe, cette dernière remonte l\'eau via un tuyau au centre de la tour jusqu\'à l\'étage supérieur qui et lui même percé de trous...</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>l\'eau passe par ces trous et redescend par gravité jusqu\'au réservoir, en arrosant au passage les racines des plantes maintenues en position dans des billes d\'argile dans les paniers amovibles (couleur ocre) installés dans la tour</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:paragraph -->\n<p>J\'ai du adapter le système de de fixation entre le bas de la tour et mon réservoirs, ainsi que certaines modifications mineures.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Au printemps 2022 J\'ai imprimé et mis en service 4 systèmes modulaires hydroponiques (que l\'on pourrait les qualifier d\'aéro-hydroponiques). Ces systèmes avaient une forme de cylindre creux lequel étaient insérés des paniers contenant des billes d\'argile. En bas de la tour un réservoir de 10 à 20 litres dans lequel une pompe alimentait le haut de la tour par un tuyau, le liquide redescendant dans la tour en imprégnant les racines par gravité.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Trois ont été déployés dans les bouches du Rhône (2 à Marseille, un à Aix-en-Provence), un à Saint-Germain-en-Laye. Merci à Aurélie, Martine et Friquette (ma maman) pour les avoir fait fonctionner.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Le détail et les photos sont disponibles ici</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Les résultats étaient intéressants, j\'ai beaucoup appris de ce système. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading">Etape 2 : 2022-2023, un système hydroponique à Saint-Germain-en-laye (78) et un système bioponique à Marseille (13)</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p> Début 2022, j\'étais très motivé par les principes de l\'aquaponie. La nature symbiotique poissons + plantes, la création d\'un écosystème économe et vertueux, la double production poissons + plantes sur une surface réduite m\'ont donné très envie d\'aller voir de plus près ce genre de systèmes. J\'ai bien sur beaucoup cherché sur internet, vu des réalisations magnifiques (par exemple la chaine de <a href="https://www.youtube.com/@ChrisPagns" target="_blank" rel="noreferrer noopener">Chris Pagns</a> sur youtube).</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>J\'ai cherché si il existant des stages près de chez moi. J\'ai finalement opté pour une initiation à l\'aquaponie chez Aquaponia, by Ecologia, tout près de Laval (en Mayenne). J\'ai choisi ce stage pour les compétences reconnues de Guillaume Beucher, et pour le lieu magique. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Je n\'ai pas été déçu ! J\'ai pu passer de la première idée que l\'on se fait quand on surfe sur internet à une idée plus proche de la réalité, quand on suit des enseignements par des sachants. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Voici les principales évolutions de ma vision initiale</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Dans le sud de la France, sans mettre en place une infrastructure solide, coûteuse et complexe, il est difficile (et/ou couteux) d\'élever des truites (ce que je souhaitais faire initialement) : la truite meurt dans une eau au delà de 26°. Donc il faut en gros choisir des poissons compatibles avec les températures, comme les poissons rouges (non comestibles) ou la carpe. C\'était un peu décevant, mais après avoir vu comment Aquaponia gère ses poissons, après avoir visionné les <a rel="noreferrer noopener" href="https://www.youtube.com/watch?v=x4hBJlt6PMI&amp;t=425s" target="_blank">vidéos de Chris Pagns</a> et lu les <a rel="noreferrer noopener" href="https://www.amazon.fr/Aquaponie-guide-r%C3%A9f%C3%A9rence-Fran%C3%A7ois-Petitet-Gosgnach/dp/2815310252/ref=sr_1_1?__mk_fr_FR=%C3%85M%C3%85%C5%BD%C3%95%C3%91&amp;crid=1XD7AW59VAHUS&amp;keywords=aquaponie+petitet&amp;qid=1692551785&amp;sprefix=aquaponie+petitet%2Caps%2C126&amp;sr=8-1" target="_blank">livres de référence de l\'aquaponie de François Petitet-Gosgnach</a> (Adanat), j\'ai été convaincu de renoncer (temporairement au moins) à la truite. J\'aurais bien opté pour le Tilapia, mais il est interdit en France pour des risque d\'invasion si il aboutissait dans une rivière. Dommage, il adore l\'eau chaude ! </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>De plus, même si j\'ai la chance d\'avoir un jardin, pour réduire la température de l\'eau le bac à poissons doit être enterré. Comme je suis locataire, j\'ai renoncé à creuser dans le jardin. Il faut parfois réduire ses ambitions. Après mures réflexions, j\'ai donc décidé de ne pas me lancer immédiatement dans l\'aquaponie.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Je précise que des installations aquaponiques sont possibles dans le sud. En particulier, un système très simple commercialisé par la société T\'air Eau a été installé avec succès jusque dans le Vaucluse. La simplicité du système (2  cuves de 500 litres enterrées reliées ensemble) pourrait réduire les risques de fuites et de mauvais fonctionnement au maximum.  C\'est d\'ailleurs un système que je vais étudier car il rompt avec les systèmes classiques et pourrait rendre l\'aquaponie plus accessible...</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->','Bienvenue','','inherit','closed','closed','','2-revision-v1','','','2023-08-23 19:19:15','2023-08-23 17:19:15','',2,'http://hs.vicq.org/?p=102',0,'revision','',0);
INSERT INTO `hs_posts` VALUES (103,1,'2023-08-23 19:31:58','2023-08-23 17:31:58','<!-- wp:heading -->\n<h2 class="wp-block-heading">Ce blog est consacré à l\'hydroponie et la bioponie domestiques. </h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Ces deux techniques de culture font partie de la famille des cultures hors-sol sur substrat neutre. Elles consistent à faire pousser des plantes sans terre, sur un substrat neutre (billes d\'argile par exemple), en mettant en place un dispositif efficace pour leur fournir les nutriments nécessaire pour assurer une croissance efficace des racines et des plantes. La recirculation du liquide nutritif évite une grande partie de la consommation d\'eau qui est induite dans la culture en sol. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Origine du projet et cheminement</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>J\'ai commencé à m\'intéresser aux questions de culture urbaines pendant l\'épidémie de COVID. Cet épisode anxiogène m\'a fait m\'interroger sur certaines questions d\'organisation de la société, et aux risques associés à l\'approvisionnement en ville des denrées alimentaires. En effet, il semble qu\'en cas de gros dysfonctionnement de la logistique d\'approvisionnement en nourriture, en quelque jours les villes pourraient se retrouver privées d\'une partie importante de leurs ressources alimentaires. Face à cette potentielle fragilité des flux de transport, il semble intéressant de développer des dispositifs urbains assurant une partie (même réduite) de la production de légumes dans la ville. Des études sur ces sujets existent, mais je ne suis pas un spécialiste de la recherche en agriculture urbaine, j\'essayerai de faire un peu de bibliographie à ce sujet quand j\'aurai le temps.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>De plus, les questions d\'épuisement de la planète sont maintenant au centre des débats, et cultiver des légumes en étant économe en eau et en énergie est un sujet qui m\'intéresse et me semble prometteur pour les temps qui viennent.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Culture hors sol, définitions</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Le web pullule d\'explications sur ces techniques de culture hors sol. Vous pouvez trouver <a href="https://fermedecagnolle.fr/hydroponie-bioponie-aquaponie-definitions/"><strong>ici</strong></a> par exemple des définitions simples de l\'<strong>hydroponie</strong>, <strong>bioponie</strong> et <strong>aquaponie</strong> proposées par Marion Sarlé (<a href="https://lessourciers.com/fr/">les sourciers</a>). Marion Sarlé propose aussi le livre «&nbsp;<em><strong>Monter sa microferme en hydroponie, bioponie et aquaponie</strong></em>&nbsp;», en vente sur le site <a href="https://lessourciers.com/fr/livre-sourciers/">Les Sourciers</a>&nbsp;. Les sourciers proposent aussi des <a href="https://lessourciers.com/fr/les-formations/">formations</a> en ligne et dans leur ferme du Gers. J\'ai suivi la partie en ligne de la formation <a href="https://lessourciers.com/fr/les-formations/microferme-hydroponique/">Microferme Hydroponique</a> qui m\'a bien aidé à comprendre les rudiments de base.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Une fois ces grandes définitions comprises, on trouve de très facilement des informations sur les <strong><a href="https://jardinfute.com/culture-hors-sol/page/2/">nombreux types de dispositifs</a></strong> utilisés pour ce type de culture (ex : <a href="https://jardinfute.com/methode-kratky/">Kratky</a>, <a href="https://jardinfute.com/systeme-dwc-hydroponie/">DWC</a>, <a href="https://jardinfute.com/systeme-nft-hydroponie/">NFT</a>, <a href="https://jardinfute.com/table-a-maree-ebb-flow/">table à marée</a>, etc.). J\'ai choisi les explications sur le site <a href="https://jardinfute.com/">jardinfute.com</a>, mais vous trouverez facilement d\'autres systèmes et d\'autres explications sur internet.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Si l\'on évalue la complexité de ces techniques, on comprend que l\'<strong>hydroponie</strong> est la plus simple des trois, puisqu\'elle se base sur la circulation d\'une solution nutritive contenant des nutriments minéraux (engrais) directement assimilables par les racines des plantes cultivées. En gros, il suffit de faire circuler de l\'eau additionnée d\'engrais sur les racines des plantes.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Quand on regarde les principes de la <strong>bioponie</strong> et l\'<strong>aquaponie</strong>, on comprend que le principe est plus complexe. Dans les deux cas on va transformer des éléments organiques en éléments minéraux pouvant être assimilés par les plantes (minéralisation). Cela est réalisé en deux étapes par l\'action de deux types de bactéries qui vont assurer tout d\'abord la transformation des éléments organiques en nitrites (bactéries <strong>Nitrosomonas</strong>) puis des nitrites en nitrates (bactéries <strong>Nitrobacter</strong>). Dans les deux cas, il faut offrir à ces bactéries un lieu et des conditions de vie, ce qui représente une complexité supplémentaire. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Enfin, pour l\'<strong>aquaponie</strong> il faut aussi s\'occuper de ses poissons, et en particulier gérer les caractéristiques de l\'eau. Des déséquilibres dans le système peuvent rapidement tuer une partie du cheptel, ce qui est plus impactant que de voir mourir un pied de ciboulette.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Bénéfices des systèmes hors-sol</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Les bénéfices de systèmes industriels ne sont pas analysés ici. Mais voici les bénéfices que produit un système opérationnel :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Très faible consommation d\'eau (environ 90 % d\'économie)</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Très faible consommation d\'électricité (pompe 10 W)</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Fort rendement au m2</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Fierté de produire sa nourriture</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>systèmes en hauteur, hors de portée des nuisibles rampants</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Intérêt pédagogique de la culture des plantes, pour tous (des plus petits aux plus grands)</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Système de circulation d\'eau produisant un bruit très agréable sans gêner les voisins</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Premier objectif : construire un système hydroponique</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Pour avoir les meilleures chances de réussite en limitant la complexité du savoir nécessaire et m\'y mettre rapidement, j\'ai choisi de commencer par l\'hydroponie.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>On peut vouloir créer des fermes hydroponiques de taille plus ou moins importante, mais j\'ai décidé de m\'intéresser à des dispositifs mis en œuvre à l\'échelle individuelle ou de proche voisinage, car cela représente des investissements réduits, une capacité de réalisation rapide et un investissement en temps acceptable. De plus, même si l\'ambition de tels systèmes n\'est pas de produire des bénéfices financiers, elle semble intéressante à l\'échelle de l\'individu ou du voisinage.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Prototypes</h2>\n<!-- /wp:heading -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading">Etape 1 : 2021-2022, un petit système hydroponique</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Durant l\'hiver 2021, j\'ai fait des recherches des différents systèmes hydroponiques disponibles et de comment réaliser sois-même ce genre de choses, et j\'ai été rapidement convaincu de l\'idée de commencer petit, afin d\'être prêt et de pouvoir planter dès le printemps 2022. Le retour d\'expérience des personnes expérimentées est unanime : il faut commencer simple et petit. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>De plus, commencer avec un petit système simple n\'a que des avantages pour quelqu\'un comme moi qui aime bricoler : </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Un petit prototype opérationnel est complet, donc on apprendra presque qu\'autant de choses que sur un plus gros système.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Le temps de développement est plus court, on aura ainsi plus de chances d\'aboutir dans des délais imposés par ses propres contraintes quotidiennes et l\'implacable chef d\'orchestre que sont les saisons. Par exemple, en France, il n\'est pas vraiment facile de planter des tomates à l\'automne, il faudra avoir été prêt pour le printemps, ou attendre le printemps suivant. </li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>On réduit le coût de fabrication, le risque financier et le temps passé si l\'on rate sa réalisation ou si on renonce avant la fin.</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:paragraph -->\n<p>J\'ai donc recherché les systèmes hydroponiques disponibles sur le marché ; j\'ai trouvé pa!s mal de systèmes clés en main, plus ou moins aboutis et plus ou moins chers. Pourtant, j\'ai décidé de construire moi-même mon premier système, pour plusieurs raisons :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Je suis convaincu que "mettre la main à la pâte" est souvent une bonne idée pour comprendre plus profondément un système technique,</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>j\'aime bien réaliser des prototypes en adaptant une solution technique existante à mon besoin personnel, cela m\'aide à  réfléchir à une généralisation possible les autres.</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading">Un mini-système hydroponique vertical (4 systèmes identiques testés entre la Provence et la région parisienne)</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>J\'ai choisi de réaliser un système hydroponique vertical, pour prendre peu de place au sol. Pratiquant l\'impression impression 3D, j\'ai décidé de partir d\'un système déjà conçu, et de l\'adapter un peu.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>voici à quoi ce système ressemblait dans sa <a href="https://www.thingiverse.com/thing:3405964/">version originale</a> : </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:columns -->\n<div class="wp-block-columns"><!-- wp:column -->\n<div class="wp-block-column"><!-- wp:image {"width":535,"height":402,"sizeSlug":"large"} -->\n<figure class="wp-block-image size-large is-resized"><img src="https://cdn.thingiverse.com/renders/33/b6/37/85/85/59b0c38e5b805c7dd9b9f5abeee79ca0_preview_featured.jpg" alt="" style="width:535px;height:402px" width="535" height="402"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class="wp-block-column"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>La colonne est creuse est composée de modules empilables, ce qui permet de choisir le nombre de plantes</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>le réservoir en bas contient une pompe, cette dernière remonte l\'eau via un tuyau au centre de la tour jusqu\'à l\'étage supérieur qui et lui même percé de trous...</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>l\'eau passe par ces trous et redescend par gravité jusqu\'au réservoir, en arrosant au passage les racines des plantes maintenues en position dans des billes d\'argile dans les paniers amovibles (couleur ocre) installés dans la tour</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:paragraph -->\n<p>J\'ai du adapter le système de de fixation entre le bas de la tour et mon réservoirs, ainsi que certaines modifications mineures.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Au printemps 2022 J\'ai imprimé et mis en service 4 systèmes modulaires hydroponiques (que l\'on pourrait les qualifier d\'aéro-hydroponiques). Ces systèmes avaient une forme de cylindre creux lequel étaient insérés des paniers contenant des billes d\'argile. En bas de la tour un réservoir de 10 à 20 litres dans lequel une pompe alimentait le haut de la tour par un tuyau, le liquide redescendant dans la tour en imprégnant les racines par gravité.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Trois ont été déployés dans les bouches du Rhône (2 à Marseille, un à Aix-en-Provence), un à Saint-Germain-en-Laye. Merci à Aurélie, Martine et Friquette (ma maman) pour les avoir fait fonctionner.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Le détail et les photos sont disponibles ici</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Les résultats étaient intéressants, j\'ai beaucoup appris de ce système. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading">Etape 2 : 2022-2023, un système hydroponique à Saint-Germain-en-laye (78) et un système bioponique à Marseille (13)</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p> Début 2022, j\'étais très motivé par les principes de l\'aquaponie. La nature symbiotique poissons + plantes, la création d\'un écosystème économe et vertueux, la double production poissons + plantes sur une surface réduite m\'ont donné très envie d\'aller voir de plus près ce genre de systèmes. J\'ai bien sur beaucoup cherché sur internet, vu des réalisations magnifiques (par exemple la chaine de <a href="https://www.youtube.com/@ChrisPagns" target="_blank" rel="noreferrer noopener">Chris Pagns</a> sur youtube).</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>J\'ai cherché si il existant des stages près de chez moi. J\'ai finalement opté pour une initiation à l\'aquaponie chez Aquaponia, by Ecologia, tout près de Laval (en Mayenne). J\'ai choisi ce stage pour les compétences reconnues de Guillaume Beucher, et pour le lieu magique. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Je n\'ai pas été déçu ! J\'ai pu passer de la première idée que l\'on se fait quand on surfe sur internet à une idée plus proche de la réalité, quand on suit des enseignements par des sachants. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Voici les principales évolutions de ma vision initiale</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Dans le sud de la France, sans mettre en place une infrastructure solide, coûteuse et complexe, il est difficile (et/ou couteux) d\'élever des truites (ce que je souhaitais faire initialement) : la truite meurt dans une eau au delà de 26°. Donc il faut en gros choisir des poissons compatibles avec les températures, comme les poissons rouges (non comestibles) ou la carpe. C\'était un peu décevant, mais après avoir vu comment Aquaponia gère ses poissons, après avoir visionné les <a rel="noreferrer noopener" href="https://www.youtube.com/watch?v=x4hBJlt6PMI&amp;t=425s" target="_blank">vidéos de Chris Pagns</a> et lu les <a rel="noreferrer noopener" href="https://www.amazon.fr/Aquaponie-guide-r%C3%A9f%C3%A9rence-Fran%C3%A7ois-Petitet-Gosgnach/dp/2815310252/ref=sr_1_1?__mk_fr_FR=%C3%85M%C3%85%C5%BD%C3%95%C3%91&amp;crid=1XD7AW59VAHUS&amp;keywords=aquaponie+petitet&amp;qid=1692551785&amp;sprefix=aquaponie+petitet%2Caps%2C126&amp;sr=8-1" target="_blank">livres de référence de l\'aquaponie de François Petitet-Gosgnach</a> (Adanat), j\'ai été convaincu de renoncer (temporairement au moins) à la truite. J\'aurais bien opté pour le Tilapia, mais il est interdit en France pour des risque d\'invasion si il aboutissait dans une rivière. Dommage, il adore l\'eau chaude ! </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>De plus, même si j\'ai la chance d\'avoir un jardin, pour réduire la température de l\'eau le bac à poissons doit être enterré. Comme je suis locataire, j\'ai renoncé à creuser dans le jardin.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Enfin, l\'aquaponie n\'est pas simple au quotidien : il faut être un minimum compétent en chimie (pour l\'eau) plomberie, en élevage des poisson (maladies, etc), en gestion  Il faut parfois réduire ses ambitions. Après mures réflexions, j\'ai donc décidé de ne pas me lancer immédiatement dans l\'aquaponie.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Je précise que des installations aquaponiques sont possibles dans le sud. En particulier, un système très simple commercialisé par la société T\'air Eau a été installé avec succès jusque dans le Vaucluse. La simplicité du système (2  cuves de 500 litres enterrées reliées ensemble) pourrait réduire les risques de fuites et de mauvais fonctionnement au maximum.  C\'est d\'ailleurs un système que je vais étudier car il rompt avec les systèmes classiques et pourrait rendre l\'aquaponie plus accessible...</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->','Bienvenue','','inherit','closed','closed','','2-revision-v1','','','2023-08-23 19:31:58','2023-08-23 17:31:58','',2,'http://hs.vicq.org/?p=103',0,'revision','',0);
INSERT INTO `hs_posts` VALUES (105,1,'2023-08-24 18:43:07','2023-08-24 16:43:07','<!-- wp:heading -->\n<h2 class="wp-block-heading">Ce blog est consacré à l\'hydroponie et la bioponie domestiques. </h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Ces deux techniques de culture font partie de la famille des cultures hors-sol sur substrat neutre. Elles consistent à faire pousser des plantes sans terre, sur un substrat neutre (billes d\'argile par exemple), en mettant en place un dispositif efficace pour leur fournir les nutriments nécessaire pour assurer une croissance efficace des racines et des plantes. La recirculation du liquide nutritif évite une grande partie de la consommation d\'eau qui est induite dans la culture en sol. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Origine du projet et cheminement</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>J\'ai commencé à m\'intéresser aux questions de culture urbaines pendant l\'épidémie de COVID. Cet épisode anxiogène m\'a fait m\'interroger sur certaines questions d\'organisation de la société, et aux risques associés à l\'approvisionnement en ville des denrées alimentaires. En effet, il semble qu\'en cas de gros dysfonctionnement de la logistique d\'approvisionnement en nourriture, en quelque jours les villes pourraient se retrouver privées d\'une partie importante de leurs ressources alimentaires. Face à cette potentielle fragilité des flux de transport, il semble intéressant de développer des dispositifs urbains assurant une partie (même réduite) de la production de légumes dans la ville. Des études sur ces sujets existent, mais je ne suis pas un spécialiste de la recherche en agriculture urbaine, j\'essayerai de faire un peu de bibliographie à ce sujet quand j\'aurai le temps.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>De plus, les questions d\'épuisement de la planète sont maintenant au centre des débats, et cultiver des légumes en étant économe en eau et en énergie est un sujet qui m\'intéresse et me semble prometteur pour les temps qui viennent.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Culture hors sol, définitions</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Le web pullule d\'explications sur ces techniques de culture hors sol. Vous pouvez trouver <a href="https://fermedecagnolle.fr/hydroponie-bioponie-aquaponie-definitions/"><strong>ici</strong></a> par exemple des définitions simples de l\'<strong>hydroponie</strong>, <strong>bioponie</strong> et <strong>aquaponie</strong> proposées par Marion Sarlé (<a href="https://lessourciers.com/fr/">les sourciers</a>). Une page très bien conçue par Ecologia présente l\'aquaponie <a rel="noreferrer noopener" href="https://www.aquaponia.com/aquaponie-by-echologia/index.php/monde-aquaponia/qu-est-ce-que-l-aquaponie-definition" target="_blank">ici</a>. Ecologia propose des formation vers Laval. Marion Sarlé propose le livre « <em><strong>Monter sa microferme en hydroponie, bioponie et aquaponie</strong></em> », en vente sur le site <a href="https://lessourciers.com/fr/livre-sourciers/">Les Sourciers</a> . Les sourciers proposent aussi des <a href="https://lessourciers.com/fr/les-formations/">formations</a> en ligne et dans leur ferme du Gers. J\'ai suivi la partie en ligne de la formation <a href="https://lessourciers.com/fr/les-formations/microferme-hydroponique/">Microferme Hydroponique</a> qui m\'a bien aidé à comprendre les rudiments de base.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Une fois ces grandes définitions comprises, on trouve de très facilement des informations sur les <strong><a href="https://jardinfute.com/culture-hors-sol/page/2/">nombreux types de dispositifs</a></strong> utilisés pour ce type de culture (ex : <a href="https://jardinfute.com/methode-kratky/">Kratky</a>, <a href="https://jardinfute.com/systeme-dwc-hydroponie/">DWC</a>, <a href="https://jardinfute.com/systeme-nft-hydroponie/">NFT</a>, <a href="https://jardinfute.com/table-a-maree-ebb-flow/">table à marée</a>, etc.). J\'ai choisi les explications sur le site <a href="https://jardinfute.com/">jardinfute.com</a>, mais vous trouverez facilement d\'autres systèmes et d\'autres explications sur internet.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Si l\'on évalue la complexité de ces techniques, on comprend que l\'<strong>hydroponie</strong> est la plus simple des trois, puisqu\'elle se base sur la circulation d\'une solution nutritive contenant des nutriments minéraux (engrais) directement assimilables par les racines des plantes cultivées. En gros, il suffit de faire circuler de l\'eau additionnée d\'engrais sur les racines des plantes.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Quand on regarde les principes de la <strong>bioponie</strong> et l\'<strong>aquaponie</strong>, on comprend que le principe est plus complexe. Dans les deux cas on va transformer des éléments organiques en éléments minéraux pouvant être assimilés par les plantes (minéralisation). Cela est réalisé en deux étapes par l\'action de deux types de bactéries qui vont assurer tout d\'abord la transformation des éléments organiques en nitrites (bactéries <strong>Nitrosomonas</strong>) puis des nitrites en nitrates (bactéries <strong>Nitrobacter</strong>). Dans les deux cas, il faut offrir à ces bactéries un lieu et des conditions de vie, ce qui représente une complexité supplémentaire. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Enfin, pour l\'<strong>aquaponie</strong> il faut aussi s\'occuper de ses poissons, et en particulier gérer les caractéristiques de l\'eau. Des déséquilibres dans le système peuvent rapidement tuer une partie du cheptel, ce qui est plus impactant que de voir mourir un pied de ciboulette.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Bénéfices des systèmes hors-sol</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Les bénéfices de systèmes industriels ne sont pas analysés ici. Mais voici les bénéfices que produit un système opérationnel :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Très faible consommation d\'eau (environ 90 % d\'économie)</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Très faible consommation d\'électricité (pompe 10 W)</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Fort rendement au m2</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Fierté de produire sa nourriture</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>systèmes en hauteur, hors de portée des nuisibles rampants</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Intérêt pédagogique de la culture des plantes, pour tous (des plus petits aux plus grands)</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Système de circulation d\'eau produisant un bruit très agréable sans gêner les voisins</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Premier objectif : construire un système hydroponique</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Pour avoir les meilleures chances de réussite en limitant la complexité du savoir nécessaire et m\'y mettre rapidement, j\'ai choisi de commencer par l\'hydroponie.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>On peut vouloir créer des fermes hydroponiques de taille plus ou moins importante, mais j\'ai décidé de m\'intéresser à des dispositifs mis en œuvre à l\'échelle individuelle ou de proche voisinage, car cela représente des investissements réduits, une capacité de réalisation rapide et un investissement en temps acceptable. De plus, même si l\'ambition de tels systèmes n\'est pas de produire des bénéfices financiers, elle semble intéressante à l\'échelle de l\'individu ou du voisinage.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Prototypes</h2>\n<!-- /wp:heading -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading">Etape 1 : 2021-2022, un petit système hydroponique</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Durant l\'hiver 2021, j\'ai fait des recherches des différents systèmes hydroponiques disponibles et de comment réaliser sois-même ce genre de choses, et j\'ai été rapidement convaincu de l\'idée de commencer petit, afin d\'être prêt et de pouvoir planter dès le printemps 2022. Le retour d\'expérience des personnes expérimentées est unanime : il faut commencer simple et petit. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>De plus, commencer avec un petit système simple n\'a que des avantages pour quelqu\'un comme moi qui aime bricoler : </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Un petit prototype opérationnel est complet, donc on apprendra presque qu\'autant de choses que sur un plus gros système.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Le temps de développement est plus court, on aura ainsi plus de chances d\'aboutir dans des délais imposés par ses propres contraintes quotidiennes et l\'implacable chef d\'orchestre que sont les saisons. Par exemple, en France, il n\'est pas vraiment facile de planter des tomates à l\'automne, il faudra avoir été prêt pour le printemps, ou attendre le printemps suivant. </li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>On réduit le coût de fabrication, le risque financier et le temps passé si l\'on rate sa réalisation ou si on renonce avant la fin.</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:paragraph -->\n<p>J\'ai donc recherché les systèmes hydroponiques disponibles sur le marché ; j\'ai trouvé pa!s mal de systèmes clés en main, plus ou moins aboutis et plus ou moins chers. Pourtant, j\'ai décidé de construire moi-même mon premier système, pour plusieurs raisons :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Je suis convaincu que "mettre la main à la pâte" est souvent une bonne idée pour comprendre plus profondément un système technique,</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>j\'aime bien réaliser des prototypes en adaptant une solution technique existante à mon besoin personnel, cela m\'aide à  réfléchir à une généralisation possible les autres.</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading">Un mini-système hydroponique vertical (4 systèmes identiques testés entre la Provence et la région parisienne)</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>J\'ai choisi de réaliser un système hydroponique vertical, pour prendre peu de place au sol. Pratiquant l\'impression impression 3D, j\'ai décidé de partir d\'un système déjà conçu, et de l\'adapter un peu.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>voici à quoi ce système ressemblait dans sa <a href="https://www.thingiverse.com/thing:3405964/">version originale</a> : </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:columns -->\n<div class="wp-block-columns"><!-- wp:column -->\n<div class="wp-block-column"><!-- wp:image {"width":535,"height":402,"sizeSlug":"large"} -->\n<figure class="wp-block-image size-large is-resized"><img src="https://cdn.thingiverse.com/renders/33/b6/37/85/85/59b0c38e5b805c7dd9b9f5abeee79ca0_preview_featured.jpg" alt="" style="width:535px;height:402px" width="535" height="402"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class="wp-block-column"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>La colonne est creuse est composée de modules empilables, ce qui permet de choisir le nombre de plantes</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>le réservoir en bas contient une pompe, cette dernière remonte l\'eau via un tuyau au centre de la tour jusqu\'à l\'étage supérieur qui et lui même percé de trous...</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>l\'eau passe par ces trous et redescend par gravité jusqu\'au réservoir, en arrosant au passage les racines des plantes maintenues en position dans des billes d\'argile dans les paniers amovibles (couleur ocre) installés dans la tour</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:paragraph -->\n<p>J\'ai du adapter le système de de fixation entre le bas de la tour et mon réservoirs, ainsi que certaines modifications mineures.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Au printemps 2022 J\'ai imprimé et mis en service 4 systèmes modulaires hydroponiques (que l\'on pourrait les qualifier d\'aéro-hydroponiques). Ces systèmes avaient une forme de cylindre creux lequel étaient insérés des paniers contenant des billes d\'argile. En bas de la tour un réservoir de 10 à 20 litres dans lequel une pompe alimentait le haut de la tour par un tuyau, le liquide redescendant dans la tour en imprégnant les racines par gravité.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Trois ont été déployés dans les bouches du Rhône (2 à Marseille, un à Aix-en-Provence), un à Saint-Germain-en-Laye. Merci à Aurélie, Martine et Friquette (ma maman) pour les avoir fait fonctionner.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Le détail et les photos sont disponibles ici</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Les résultats étaient intéressants, j\'ai beaucoup appris de ce système. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading">Etape 2 : 2022-2023, un système hydroponique à Saint-Germain-en-laye (78) et un système bioponique à Marseille (13)</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Début 2022, j\'étais très motivé par les principes de l\'aquaponie. La nature symbiotique poissons + plantes, la création d\'un écosystème économe et vertueux, la double production poissons + plantes sur une surface réduite m\'ont donné très envie d\'aller voir de plus près ce genre de systèmes. J\'ai bien sur beaucoup cherché sur internet, vu des réalisations magnifiques (par exemple la chaine de <a rel="noreferrer noopener" href="https://www.youtube.com/@ChrisPagns" target="_blank">Chris Pagns</a> sur youtube).</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>J\'ai cherché si il existant des formations près de chez moi. J\'ai finalement opté pour une initiation à l\'aquaponie chez <a href="https://www.aquaponia.com/aquaponie-by-echologia/" target="_blank" rel="noreferrer noopener">Aquaponia, by Ecologia</a>, tout près de Laval (en Mayenne). J\'ai choisi ce stage pour les compétences reconnues de Guillaume Beucher, et pour le lieu magique. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Je n\'ai pas été déçu ! J\'ai pu passer de la première idée que l\'on se fait quand on surfe sur internet à une idée plus proche de la réalité, quand on suit des enseignements par des sachants. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Voici les principales évolutions de ma vision initiale</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Dans le sud de la France, sans mettre en place une infrastructure solide, coûteuse et complexe, il est difficile (et/ou couteux) d\'élever des truites (ce que je souhaitais faire initialement) : la truite meurt dans une eau au delà de 26°. Donc il faut en gros choisir des poissons compatibles avec les températures, comme les poissons rouges (non comestibles) ou la carpe. C\'était un peu décevant, mais après avoir vu comment Aquaponia gère ses poissons, après avoir visionné les <a rel="noreferrer noopener" href="https://www.youtube.com/watch?v=x4hBJlt6PMI&amp;t=425s" target="_blank">vidéos de Chris Pagns</a> et lu les <a rel="noreferrer noopener" href="https://www.amazon.fr/Aquaponie-guide-r%C3%A9f%C3%A9rence-Fran%C3%A7ois-Petitet-Gosgnach/dp/2815310252/ref=sr_1_1?__mk_fr_FR=%C3%85M%C3%85%C5%BD%C3%95%C3%91&amp;crid=1XD7AW59VAHUS&amp;keywords=aquaponie+petitet&amp;qid=1692551785&amp;sprefix=aquaponie+petitet%2Caps%2C126&amp;sr=8-1" target="_blank">livres de référence de l\'aquaponie de François Petitet-Gosgnach</a> (Adanat), j\'ai été convaincu de renoncer (temporairement au moins) à la truite. J\'aurais bien opté pour le Tilapia, mais il est interdit en France pour des risque d\'invasion si il aboutissait dans une rivière. Dommage, il adore l\'eau chaude ! </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>De plus, même si j\'ai la chance d\'avoir un jardin, pour réduire la température de l\'eau le bac à poissons doit être enterré. Comme je suis locataire, j\'ai renoncé à creuser dans le jardin.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Enfin, l\'aquaponie n\'est pas simple au quotidien : il faut être un minimum compétent en chimie (pour l\'eau) plomberie, en élevage des poisson (maladies, etc), en gestion  Il faut parfois réduire ses ambitions. Après mures réflexions, j\'ai donc décidé de ne pas me lancer immédiatement dans l\'aquaponie.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Je précise que des installations aquaponiques sont possibles dans le sud. En particulier, un système très simple commercialisé par la société T\'air Eau a été installé avec succès jusque dans le Vaucluse. La simplicité du système (2  cuves de 500 litres enterrées reliées ensemble) pourrait réduire les risques de fuites et de mauvais fonctionnement au maximum.  C\'est d\'ailleurs un système que je vais étudier car il rompt avec les systèmes classiques et pourrait rendre l\'aquaponie plus accessible...</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->','Bienvenue','','inherit','closed','closed','','2-revision-v1','','','2023-08-24 18:43:07','2023-08-24 16:43:07','',2,'https://hs.vicq.org/?p=105',0,'revision','',0);
INSERT INTO `hs_posts` VALUES (106,1,'2023-08-24 19:30:05','2023-08-24 17:30:05','<!-- wp:heading -->\n<h2 class="wp-block-heading">Ce blog est consacré à l\'hydroponie et la bioponie domestiques. </h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Ces deux techniques de culture font partie de la famille des cultures hors-sol sur substrat neutre. Elles consistent à faire pousser des plantes sans terre, sur un substrat neutre (billes d\'argile par exemple), en mettant en place un dispositif efficace pour leur fournir les nutriments nécessaire pour assurer une croissance efficace des racines et des plantes. La recirculation du liquide nutritif évite une grande partie de la consommation d\'eau qui est induite dans la culture en sol. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Origine du projet et cheminement</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>J\'ai commencé à m\'intéresser aux questions de culture urbaines pendant l\'épidémie de COVID. Cet épisode anxiogène m\'a fait m\'interroger sur certaines questions d\'organisation de la société, et aux risques associés à l\'approvisionnement en ville des denrées alimentaires. En effet, il semble qu\'en cas de gros dysfonctionnement de la logistique d\'approvisionnement en nourriture, en quelque jours les villes pourraient se retrouver privées d\'une partie importante de leurs ressources alimentaires. Face à cette potentielle fragilité des flux de transport, il semble intéressant de développer des dispositifs urbains assurant une partie (même réduite) de la production de légumes dans la ville. Des études sur ces sujets existent, mais je ne suis pas un spécialiste de la recherche en agriculture urbaine, j\'essayerai de faire un peu de bibliographie à ce sujet quand j\'aurai le temps.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>De plus, les questions d\'épuisement de la planète sont maintenant au centre des débats, et cultiver des légumes en étant économe en eau et en énergie est un sujet qui m\'intéresse et me semble prometteur pour les temps qui viennent.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Culture hors sol, définitions</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Le web pullule d\'explications sur ces techniques de culture hors sol. Vous pouvez trouver <a href="https://fermedecagnolle.fr/hydroponie-bioponie-aquaponie-definitions/"><strong>ici</strong></a> par exemple des définitions simples de l\'<strong>hydroponie</strong>, <strong>bioponie</strong> et <strong>aquaponie</strong> proposées par Marion Sarlé (<a href="https://lessourciers.com/fr/">les sourciers</a>). Une page très bien conçue par Ecologia présente l\'aquaponie <a rel="noreferrer noopener" href="https://www.aquaponia.com/aquaponie-by-echologia/index.php/monde-aquaponia/qu-est-ce-que-l-aquaponie-definition" target="_blank">ici</a>. Ecologia propose des formation vers Laval. Marion Sarlé propose le livre « <em><strong>Monter sa microferme en hydroponie, bioponie et aquaponie</strong></em> », en vente sur le site <a href="https://lessourciers.com/fr/livre-sourciers/">Les Sourciers</a> . Les sourciers proposent aussi des <a href="https://lessourciers.com/fr/les-formations/">formations</a> en ligne et dans leur ferme du Gers. J\'ai suivi la partie en ligne de la formation <a href="https://lessourciers.com/fr/les-formations/microferme-hydroponique/">Microferme Hydroponique</a> qui m\'a bien aidé à comprendre les rudiments de base.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Une fois ces grandes définitions comprises, on trouve de très facilement des informations sur les <strong><a href="https://jardinfute.com/culture-hors-sol/page/2/">nombreux types de dispositifs</a></strong> utilisés pour ce type de culture (ex : <a href="https://jardinfute.com/methode-kratky/">Kratky</a>, <a href="https://jardinfute.com/systeme-dwc-hydroponie/">DWC</a>, <a href="https://jardinfute.com/systeme-nft-hydroponie/">NFT</a>, <a href="https://jardinfute.com/table-a-maree-ebb-flow/">table à marée</a>, etc.). J\'ai choisi les explications sur le site <a href="https://jardinfute.com/">jardinfute.com</a>, mais vous trouverez facilement d\'autres systèmes et d\'autres explications sur internet.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Si l\'on évalue la complexité de ces techniques, on comprend que l\'<strong>hydroponie</strong> est la plus simple des trois, puisqu\'elle se base sur la circulation d\'une solution nutritive contenant des nutriments minéraux (engrais) directement assimilables par les racines des plantes cultivées. En gros, il suffit de faire circuler de l\'eau additionnée d\'engrais sur les racines des plantes.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Quand on regarde les principes de la <strong>bioponie</strong> et l\'<strong>aquaponie</strong>, on comprend que le principe est plus complexe. Dans les deux cas on va transformer des éléments organiques en éléments minéraux pouvant être assimilés par les plantes (minéralisation). Cela est réalisé en deux étapes par l\'action de deux types de bactéries qui vont assurer tout d\'abord la transformation des éléments organiques en nitrites (bactéries <strong>Nitrosomonas</strong>) puis des nitrites en nitrates (bactéries <strong>Nitrobacter</strong>). Dans les deux cas, il faut offrir à ces bactéries un lieu et des conditions de vie, ce qui représente une complexité supplémentaire. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Enfin, pour l\'<strong>aquaponie</strong> il faut aussi s\'occuper de ses poissons, et en particulier gérer les caractéristiques de l\'eau. Des déséquilibres dans le système peuvent rapidement tuer une partie du cheptel, ce qui est plus impactant que de voir mourir un pied de ciboulette.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Bénéfices des systèmes hors-sol</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Les bénéfices de systèmes industriels ne sont pas analysés ici. Mais voici les bénéfices que produit un système opérationnel :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Très faible consommation d\'eau (environ 90 % d\'économie)</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Très faible consommation d\'électricité (pompe 10 W)</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Fort rendement au m2</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Fierté de produire sa nourriture</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>systèmes en hauteur, hors de portée des nuisibles rampants</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Intérêt pédagogique de la culture des plantes, pour tous (des plus petits aux plus grands)</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Système de circulation d\'eau produisant un bruit très agréable sans gêner les voisins</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Premier objectif : construire un système hydroponique</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Pour avoir les meilleures chances de réussite en limitant la complexité du savoir nécessaire et m\'y mettre rapidement, j\'ai choisi de commencer par l\'hydroponie.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>On peut vouloir créer des fermes hydroponiques de taille plus ou moins importante, mais j\'ai décidé de m\'intéresser à des dispositifs mis en œuvre à l\'échelle individuelle ou de proche voisinage, car cela représente des investissements réduits, une capacité de réalisation rapide et un investissement en temps acceptable. De plus, même si l\'ambition de tels systèmes n\'est pas de produire des bénéfices financiers, elle semble intéressante à l\'échelle de l\'individu ou du voisinage.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Prototypes</h2>\n<!-- /wp:heading -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading"></h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Durant l\'hiver 2021, j\'ai fait des recherches des différents systèmes hydroponiques disponibles et de comment réaliser sois-même ce genre de choses, et j\'ai été rapidement convaincu de l\'idée de commencer petit, afin d\'être prêt et de pouvoir planter dès le printemps 2022. Le retour d\'expérience des personnes expérimentées est unanime : il faut commencer simple et petit. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>De plus, commencer avec un petit système simple n\'a que des avantages pour quelqu\'un comme moi qui aime bricoler : </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Un petit prototype opérationnel est complet, donc on apprendra presque qu\'autant de choses que sur un plus gros système.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Le temps de développement est plus court, on aura ainsi plus de chances d\'aboutir dans des délais imposés par ses propres contraintes quotidiennes et l\'implacable chef d\'orchestre que sont les saisons. Par exemple, en France, il n\'est pas vraiment facile de planter des tomates à l\'automne, il faudra avoir été prêt pour le printemps, ou attendre le printemps suivant. </li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>On réduit le coût de fabrication, le risque financier et le temps passé si l\'on rate sa réalisation ou si on renonce avant la fin.</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:paragraph -->\n<p>J\'ai donc recherché les systèmes hydroponiques disponibles sur le marché ; j\'ai trouvé pas mal de systèmes clés en main, plus ou moins aboutis et plus ou moins chers. Pourtant, j\'ai décidé de construire moi-même mon premier système, pour plusieurs raisons :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Je suis convaincu que "mettre la main à la pâte" est souvent une bonne idée pour comprendre plus profondément un système technique,</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>j\'aime bien réaliser des prototypes en adaptant une solution technique existante à mon besoin personnel, cela m\'aide à  réfléchir à une généralisation possible les autres.</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading">Étape 1 : 2022, un petit système hydroponique (pour Marseille et la région parisienne)</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>J\'ai choisi de réaliser un système hydroponique vertical, pour prendre peu de place au sol. Pratiquant l\'impression impression 3D, j\'ai décidé de partir d\'un système déjà conçu, et de l\'adapter un peu. De plus, j\'ai décidé de fabriquer plusieurs systèmes identiques testés entre la Provence et la région parisienne.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Voici à quoi ce système ressemblait dans sa <a href="https://www.thingiverse.com/thing:3405964/">version originale</a> trouvée sur un site d\'impression 3D : </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:columns -->\n<div class="wp-block-columns"><!-- wp:column -->\n<div class="wp-block-column"><!-- wp:image {"width":535,"height":402,"sizeSlug":"large"} -->\n<figure class="wp-block-image size-large is-resized"><img src="https://cdn.thingiverse.com/renders/33/b6/37/85/85/59b0c38e5b805c7dd9b9f5abeee79ca0_preview_featured.jpg" alt="" style="width:535px;height:402px" width="535" height="402"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class="wp-block-column"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>La colonne est creuse est composée de modules empilables, ce qui permet de choisir le nombre de plantes</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>le réservoir en bas contient une pompe, cette dernière remonte l\'eau via un tuyau au centre de la tour jusqu\'à l\'étage supérieur qui et lui même percé de trous...</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>l\'eau passe par ces trous et redescend par gravité jusqu\'au réservoir, en arrosant au passage les racines des plantes maintenues en position dans des billes d\'argile dans les paniers amovibles (couleur ocre) installés dans la tour</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:paragraph -->\n<p>J\'ai du adapter le système de de fixation entre le bas de la tour et mon réservoirs, ainsi que certaines modifications mineures.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Au printemps 2022 J\'ai imprimé et mis en service 4 systèmes modulaires hydroponiques (que l\'on pourrait les qualifier d\'aéro-hydroponiques car le liquide nutritif ruisselle sur les racines, celles ci ne trempent pas dans le liquide). Ces systèmes avaient une forme de cylindre creux lequel étaient insérés des paniers contenant des billes d\'argile. En bas de la tour un réservoir de 10 à 20 litres dans lequel une pompe alimentait le haut de la tour par un tuyau, le liquide redescendant dans la tour en imprégnant les racines par gravité. Ce système est modulaire et permet d\'adapter plus ou moins d\'étages de plantation.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Trois ont été déployés dans les bouches du Rhône (2 à Marseille, un à Aix-en-Provence), un à Saint-Germain-en-Laye. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Merci à Aurélie, Martine et Friquette (ma maman) pour les avoir fait fonctionner et testés.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Le détail et les photos sont disponibles ici</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Les résultats étaient intéressants, j\'ai beaucoup appris de ce système. Mais je suis resté sur ma fin, pour les raisons suivantes :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>J\'ai planté des tomates ! Et cela a fonctionné. Sauf que les tomates produisent des volumes de racines gigantesques, et qu\'elles ont envahi l\'intérieur, ne laissant pas beaucoup de place au basilic et autres tentatives. De plus, je devait couper les racines des tomates très souvent...</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Les fraises ont végété,</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>J\'avais tenté de planter un chou fleur, qui était assez en forme mais n\'a jamais rien produit,</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>La ciboulette n\'a pas tenu, pas plus que le basilic,</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>La consommation d\'eau était importante : jusqu\'à 2 litres par jour. Le contenant (10 puis 20 litres) nécessitait d\'intervenir quotidiennement!</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:paragraph -->\n<p>La tentative en région parisienne, avec un climat plus frais, a été bien meilleure. Et ma maman, qui s\'en occupait, était certainement plus performante... Beaucoup de tomates, quelques fraises... </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>En résumé, oui, ça a fonctionné, mais à part les tomates, le résultat était décevant. Je pense aussi que j\'aurais dû ne pas placer le système en plein soleil en juillet et aout à Marseille, car même les tomates ont souffert !!</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading">Étape 2 : choix du système pour l\'année 2023</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Je voulais changer et faire évoluer mes systèmes, et j\'ai continuer de chercher des informations. Début 2022, j\'étais très motivé par les principes de l\'aquaponie. La nature symbiotique poissons + plantes, la création d\'un écosystème économe et vertueux, la double production poissons + plantes sur une surface réduite m\'ont donné très envie d\'aller voir de plus près ce genre de systèmes. J\'ai bien sur beaucoup cherché sur internet, vu des réalisations magnifiques (par exemple la chaine de <a rel="noreferrer noopener" href="https://www.youtube.com/@ChrisPagns" target="_blank">Chris Pagns</a> sur youtube).</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>J\'ai cherché si il existant des formations près de chez moi. J\'ai finalement opté pour une initiation à l\'aquaponie chez <a rel="noreferrer noopener" href="https://www.aquaponia.com/aquaponie-by-echologia/" target="_blank">Aquaponia, by Ecologia</a>, tout près de Laval (en Mayenne). J\'ai choisi ce stage pour les compétences reconnues de Guillaume Beucher, et pour le lieu magique. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Je n\'ai pas été déçu ! Après avoir surfé sur internet, j\'ai pu accéder à une idée plus proche de la réalité, quand on suit les enseignements de pros qui savent. Voici les principales évolutions de ma vision initiale :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Dans le sud de la France, sans mettre en place une infrastructure solide, coûteuse et complexe, il est difficile (et/ou couteux) d\'élever des truites (ce que je souhaitais faire initialement) : la truite meurt dans une eau au delà de 26°. Donc il faut choisir des poissons compatibles avec les températures élevées, comme le poissons rouge (non comestible) ou la carpe. Cela fut un constat un peu amer, mais après avoir vu comment Aquaponia gère ses poissons, après avoir visionné les <a rel="noreferrer noopener" href="https://www.youtube.com/watch?v=x4hBJlt6PMI&amp;t=425s" target="_blank">vidéos de Chris Pagns</a> et lu les <a rel="noreferrer noopener" href="https://www.amazon.fr/Aquaponie-guide-r%C3%A9f%C3%A9rence-Fran%C3%A7ois-Petitet-Gosgnach/dp/2815310252/ref=sr_1_1?__mk_fr_FR=%C3%85M%C3%85%C5%BD%C3%95%C3%91&amp;crid=1XD7AW59VAHUS&amp;keywords=aquaponie+petitet&amp;qid=1692551785&amp;sprefix=aquaponie+petitet%2Caps%2C126&amp;sr=8-1" target="_blank">livres de référence de l\'aquaponie de François Petitet-Gosgnach</a> (Adanat), j\'ai été convaincu de renoncer (temporairement au moins) à la truite. J\'aurais bien opté pour le Tilapia, mais il est interdit en France pour des risque d\'invasion si il aboutissait dans une rivière. Dommage, il adore l\'eau chaude ! </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>De plus, même si j\'ai la chance d\'avoir un jardin, pour réduire la température de l\'eau le bac à poissons doit être enterré. Comme je suis locataire, j\'ai renoncé à creuser dans le jardin.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Enfin, l\'aquaponie n\'est pas simple et représente une charge au quotidien : il faut être un minimum compétent en chimie (pour l\'eau : cyclage, nitrates, nitrites, PH, KH, EC), en plomberie (étanchéité, maintenance), en élevage des poisson (nourissage, gestion des maladies, etc), en connaissance des plantes (semis, croissance, maladies). Et cela après avoir conçu et réalisé son système (compétences en bricolage, même si on peut aussi acheter un système "clé en main").  </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Mais malgré l\'enviequi n\'a pas faibli, il faut parfois réduire ses ambitions. Après réflexion, j\'ai donc décidé de ne pas me lancer immédiatement dans l\'aquaponie.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Je précise que des installations aquaponiques sont possibles dans le sud. En particulier, un système très simple commercialisé par la société T\'air Eau a été installé avec succès jusque dans le Vaucluse. La simplicité du système (2 cuves de 500 litres enterrées reliées ensemble) pourrait réduire les risques de fuites et de mauvais fonctionnement au maximum.  C\'est d\'ailleurs un système que je vais étudier car il rompt avec les systèmes classiques et pourrait rendre l\'aquaponie plus accessible...</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading">Étape 3 : 2022-2023, un système hydroponique à Saint-Germain-en-laye (78) et un système bioponique à Marseille (13)</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->','Bienvenue','','inherit','closed','closed','','2-revision-v1','','','2023-08-24 19:30:05','2023-08-24 17:30:05','',2,'https://hs.vicq.org/?p=106',0,'revision','',0);
INSERT INTO `hs_posts` VALUES (107,1,'2023-08-24 19:34:59','2023-08-24 17:34:59','<!-- wp:heading -->\n<h2 class="wp-block-heading">Ce blog est consacré à l\'hydroponie et la bioponie domestiques. </h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Ces deux techniques de culture font partie de la famille des cultures hors-sol sur substrat neutre. Elles consistent à faire pousser des plantes sans terre, sur un substrat neutre (billes d\'argile par exemple), en mettant en place un dispositif efficace pour leur fournir les nutriments nécessaire pour assurer une croissance efficace des racines et des plantes. La recirculation du liquide nutritif évite une grande partie de la consommation d\'eau qui est induite dans la culture en sol. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Origine du projet et cheminement</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>J\'ai commencé à m\'intéresser aux questions de culture urbaines pendant l\'épidémie de COVID. Cet épisode anxiogène m\'a fait m\'interroger sur certaines questions d\'organisation de la société, et aux risques associés à l\'approvisionnement en ville des denrées alimentaires. En effet, il semble qu\'en cas de gros dysfonctionnement de la logistique d\'approvisionnement en nourriture, en quelque jours les villes pourraient se retrouver privées d\'une partie importante de leurs ressources alimentaires. Face à cette potentielle fragilité des flux de transport, il semble intéressant de développer des dispositifs urbains assurant une partie (même réduite) de la production de légumes dans la ville. Des études sur ces sujets existent, mais je ne suis pas un spécialiste de la recherche en agriculture urbaine, j\'essayerai de faire un peu de bibliographie à ce sujet quand j\'aurai le temps.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>De plus, les questions d\'épuisement de la planète sont maintenant au centre des débats, et cultiver des légumes en étant économe en eau et en énergie est un sujet qui m\'intéresse et me semble prometteur pour les temps qui viennent.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Culture hors sol, définitions</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Le web pullule d\'explications sur ces techniques de culture hors sol. Vous pouvez trouver <a href="https://fermedecagnolle.fr/hydroponie-bioponie-aquaponie-definitions/"><strong>ici</strong></a> par exemple des définitions simples de l\'<strong>hydroponie</strong>, <strong>bioponie</strong> et <strong>aquaponie</strong> proposées par Marion Sarlé (<a href="https://lessourciers.com/fr/">les sourciers</a>). Une page très bien conçue par Ecologia présente l\'aquaponie <a rel="noreferrer noopener" href="https://www.aquaponia.com/aquaponie-by-echologia/index.php/monde-aquaponia/qu-est-ce-que-l-aquaponie-definition" target="_blank">ici</a>. Ecologia propose des formation vers Laval. Marion Sarlé propose le livre « <em><strong>Monter sa microferme en hydroponie, bioponie et aquaponie</strong></em> », en vente sur le site <a href="https://lessourciers.com/fr/livre-sourciers/">Les Sourciers</a> . Les sourciers proposent aussi des <a href="https://lessourciers.com/fr/les-formations/">formations</a> en ligne et dans leur ferme du Gers. J\'ai suivi la partie en ligne de la formation <a href="https://lessourciers.com/fr/les-formations/microferme-hydroponique/">Microferme Hydroponique</a> qui m\'a bien aidé à comprendre les rudiments de base.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Une fois ces grandes définitions comprises, on trouve de très facilement des informations sur les <strong><a href="https://jardinfute.com/culture-hors-sol/page/2/">nombreux types de dispositifs</a></strong> utilisés pour ce type de culture (ex : <a href="https://jardinfute.com/methode-kratky/">Kratky</a>, <a href="https://jardinfute.com/systeme-dwc-hydroponie/">DWC</a>, <a href="https://jardinfute.com/systeme-nft-hydroponie/">NFT</a>, <a href="https://jardinfute.com/table-a-maree-ebb-flow/">table à marée</a>, etc.). J\'ai choisi les explications sur le site <a href="https://jardinfute.com/">jardinfute.com</a>, mais vous trouverez facilement d\'autres systèmes et d\'autres explications sur internet.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Si l\'on évalue la complexité de ces techniques, on comprend que l\'<strong>hydroponie</strong> est la plus simple des trois, puisqu\'elle se base sur la circulation d\'une solution nutritive contenant des nutriments minéraux (engrais) directement assimilables par les racines des plantes cultivées. En gros, il suffit de faire circuler de l\'eau additionnée d\'engrais sur les racines des plantes.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Quand on regarde les principes de la <strong>bioponie</strong> et l\'<strong>aquaponie</strong>, on comprend que le principe est plus complexe. Dans les deux cas on va transformer des éléments organiques en éléments minéraux pouvant être assimilés par les plantes (minéralisation). Cela est réalisé en deux étapes par l\'action de deux types de bactéries qui vont assurer tout d\'abord la transformation des éléments organiques en nitrites (bactéries <strong>Nitrosomonas</strong>) puis des nitrites en nitrates (bactéries <strong>Nitrobacter</strong>). Dans les deux cas, il faut offrir à ces bactéries un lieu et des conditions de vie, ce qui représente une complexité supplémentaire. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Enfin, pour l\'<strong>aquaponie</strong> il faut aussi s\'occuper de ses poissons, et en particulier gérer les caractéristiques de l\'eau. Des déséquilibres dans le système peuvent rapidement tuer une partie du cheptel, ce qui est plus impactant que de voir mourir un pied de ciboulette.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Bénéfices des systèmes hors-sol</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Les bénéfices de systèmes industriels ne sont pas analysés ici. Mais voici les bénéfices que produit un système opérationnel :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Très faible consommation d\'eau (environ 90 % d\'économie)</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Très faible consommation d\'électricité (pompe 10 W)</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Fort rendement au m2</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Fierté de produire sa nourriture</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>systèmes en hauteur, hors de portée des nuisibles rampants</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Intérêt pédagogique de la culture des plantes, pour tous (des plus petits aux plus grands)</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Système de circulation d\'eau produisant un bruit très agréable sans gêner les voisins</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Premier objectif : construire un système hydroponique</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Pour avoir les meilleures chances de réussite en limitant la complexité du savoir nécessaire et m\'y mettre rapidement, j\'ai choisi de commencer par l\'hydroponie.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>On peut vouloir créer des fermes hydroponiques de taille plus ou moins importante, mais j\'ai décidé de m\'intéresser à des dispositifs mis en œuvre à l\'échelle individuelle ou de proche voisinage, car cela représente des investissements réduits, une capacité de réalisation rapide et un investissement en temps acceptable. De plus, même si l\'ambition de tels systèmes n\'est pas de produire des bénéfices financiers, elle semble intéressante à l\'échelle de l\'individu ou du voisinage.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Prototypes</h2>\n<!-- /wp:heading -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading"></h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Durant l\'hiver 2021, j\'ai fait des recherches des différents systèmes hydroponiques disponibles et de comment réaliser sois-même ce genre de choses, et j\'ai été rapidement convaincu de l\'idée de commencer petit, afin d\'être prêt et de pouvoir planter dès le printemps 2022. Le retour d\'expérience des personnes expérimentées est unanime : il faut commencer simple et petit. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>De plus, commencer avec un petit système simple n\'a que des avantages pour quelqu\'un comme moi qui aime bricoler : </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Un petit prototype opérationnel est complet, donc on apprendra presque qu\'autant de choses que sur un plus gros système.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Le temps de développement est plus court, on aura ainsi plus de chances d\'aboutir dans des délais imposés par ses propres contraintes quotidiennes et l\'implacable chef d\'orchestre que sont les saisons. Par exemple, en France, il n\'est pas vraiment facile de planter des tomates à l\'automne, il faudra avoir été prêt pour le printemps, ou attendre le printemps suivant. </li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>On réduit le coût de fabrication, le risque financier et le temps passé si l\'on rate sa réalisation ou si on renonce avant la fin.</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:paragraph -->\n<p>J\'ai donc recherché les systèmes hydroponiques disponibles sur le marché ; j\'ai trouvé pas mal de systèmes clés en main, plus ou moins aboutis et plus ou moins chers. Pourtant, j\'ai décidé de construire moi-même mon premier système, pour plusieurs raisons :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Je suis convaincu que "mettre la main à la pâte" est souvent une bonne idée pour comprendre plus profondément un système technique,</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>j\'aime bien réaliser des prototypes en adaptant une solution technique existante à mon besoin personnel, cela m\'aide à  réfléchir à une généralisation possible les autres.</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading">Étape 1 : 2022, un petit système hydroponique (pour Marseille et la région parisienne)</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>J\'ai choisi de réaliser un système hydroponique vertical, pour prendre peu de place au sol. Pratiquant l\'impression impression 3D, j\'ai décidé de partir d\'un système déjà conçu, et de l\'adapter un peu. De plus, j\'ai décidé de fabriquer plusieurs systèmes identiques testés entre la Provence et la région parisienne.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Voici à quoi ce système ressemblait dans sa <a href="https://www.thingiverse.com/thing:3405964/">version originale</a> trouvée sur un site d\'impression 3D : </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:columns -->\n<div class="wp-block-columns"><!-- wp:column -->\n<div class="wp-block-column"><!-- wp:image {"width":535,"height":402,"sizeSlug":"large"} -->\n<figure class="wp-block-image size-large is-resized"><img src="https://cdn.thingiverse.com/renders/33/b6/37/85/85/59b0c38e5b805c7dd9b9f5abeee79ca0_preview_featured.jpg" alt="" style="width:535px;height:402px" width="535" height="402"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class="wp-block-column"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>La colonne est creuse est composée de modules empilables, ce qui permet de choisir le nombre de plantes</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>le réservoir en bas contient une pompe, cette dernière remonte l\'eau via un tuyau au centre de la tour jusqu\'à l\'étage supérieur qui et lui même percé de trous...</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>l\'eau passe par ces trous et redescend par gravité jusqu\'au réservoir, en arrosant au passage les racines des plantes maintenues en position dans des billes d\'argile dans les paniers amovibles (couleur ocre) installés dans la tour</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:paragraph -->\n<p>J\'ai du adapter le système de de fixation entre le bas de la tour et mon réservoirs, ainsi que certaines modifications mineures.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Au printemps 2022 J\'ai imprimé et mis en service 4 systèmes modulaires hydroponiques (que l\'on pourrait les qualifier d\'aéro-hydroponiques car le liquide nutritif ruisselle sur les racines, celles ci ne trempent pas dans le liquide). Ces systèmes avaient une forme de cylindre creux lequel étaient insérés des paniers contenant des billes d\'argile. En bas de la tour un réservoir de 10 à 20 litres dans lequel une pompe alimentait le haut de la tour par un tuyau, le liquide redescendant dans la tour en imprégnant les racines par gravité. Ce système est modulaire et permet d\'adapter plus ou moins d\'étages de plantation.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Trois ont été déployés dans les bouches du Rhône (2 à Marseille, un à Aix-en-Provence), un à Saint-Germain-en-Laye. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Merci à Aurélie, Martine et Friquette (ma maman) pour les avoir fait fonctionner et testés.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Le détail et les photos sont disponibles ici</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Les résultats étaient intéressants, j\'ai beaucoup appris de ce système. Mais je suis resté sur ma fin, pour les raisons suivantes :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>J\'ai planté des tomates ! Et cela a fonctionné. Sauf que les tomates produisent des volumes de racines gigantesques, et qu\'elles ont envahi l\'intérieur, ne laissant pas beaucoup de place au basilic et autres tentatives. De plus, je devait couper les racines des tomates très souvent...</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Les fraises ont végété,</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>J\'avais tenté de planter un chou fleur, qui était assez en forme mais n\'a jamais rien produit,</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>La ciboulette n\'a pas tenu, pas plus que le basilic,</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>La consommation d\'eau était importante : jusqu\'à 2 litres par jour. Le contenant (10 puis 20 litres) nécessitait d\'intervenir quotidiennement!</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:paragraph -->\n<p>La tentative en région parisienne, avec un climat plus frais, a été bien meilleure. Et ma maman, qui s\'en occupait, était certainement plus performante... Beaucoup de tomates, quelques fraises... </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>En résumé, oui, ça a fonctionné, mais à part les tomates, le résultat était décevant. Je pense aussi que j\'aurais dû ne pas placer le système en plein soleil en juillet et aout à Marseille, car même les tomates ont souffert !!</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading">Étape 2 : choix du système pour l\'année 2023</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Je voulais changer et faire évoluer mes systèmes, et j\'ai continuer de chercher des informations. Début 2022, j\'étais très motivé par les principes de l\'aquaponie. La nature symbiotique poissons + plantes, la création d\'un écosystème économe et vertueux, la double production poissons + plantes sur une surface réduite m\'ont donné très envie d\'aller voir de plus près ce genre de systèmes. J\'ai bien sur beaucoup cherché sur internet, vu des réalisations magnifiques (par exemple la chaine de <a rel="noreferrer noopener" href="https://www.youtube.com/@ChrisPagns" target="_blank">Chris Pagns</a> sur youtube).</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>J\'ai cherché si il existant des formations près de chez moi. J\'ai finalement opté pour une initiation à l\'aquaponie chez <a rel="noreferrer noopener" href="https://www.aquaponia.com/aquaponie-by-echologia/" target="_blank">Aquaponia, by Ecologia</a>, tout près de Laval (en Mayenne). J\'ai choisi ce stage pour les compétences reconnues de Guillaume Beucher, et pour le lieu magique. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Je n\'ai pas été déçu ! Après avoir surfé sur internet, j\'ai pu accéder à une idée plus proche de la réalité, quand on suit les enseignements de pros qui savent. Voici les principales évolutions de ma vision initiale :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Dans le sud de la France, sans mettre en place une infrastructure solide, coûteuse et complexe, il est difficile (et/ou couteux) d\'élever des truites (ce que je souhaitais faire initialement) : la truite meurt dans une eau au delà de 26°. Donc il faut choisir des poissons compatibles avec les températures élevées, comme le poissons rouge (non comestible) ou la carpe. Cela fut un constat un peu amer, mais après avoir vu comment Aquaponia gère ses poissons, après avoir visionné les <a rel="noreferrer noopener" href="https://www.youtube.com/watch?v=x4hBJlt6PMI&amp;t=425s" target="_blank">vidéos de Chris Pagns</a> et lu les <a rel="noreferrer noopener" href="https://www.amazon.fr/Aquaponie-guide-r%C3%A9f%C3%A9rence-Fran%C3%A7ois-Petitet-Gosgnach/dp/2815310252/ref=sr_1_1?__mk_fr_FR=%C3%85M%C3%85%C5%BD%C3%95%C3%91&amp;crid=1XD7AW59VAHUS&amp;keywords=aquaponie+petitet&amp;qid=1692551785&amp;sprefix=aquaponie+petitet%2Caps%2C126&amp;sr=8-1" target="_blank">livres de référence de l\'aquaponie de François Petitet-Gosgnach</a> (Adanat), j\'ai été convaincu de renoncer (temporairement au moins) à la truite. J\'aurais bien opté pour le Tilapia, mais il est interdit en France pour des risque d\'invasion si il aboutissait dans une rivière. Dommage, il adore l\'eau chaude ! </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>De plus, même si j\'ai la chance d\'avoir un jardin, pour réduire la température de l\'eau le bac à poissons doit être enterré. Comme je suis locataire, j\'ai renoncé à creuser dans le jardin.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Enfin, l\'aquaponie n\'est pas simple et représente une charge au quotidien : il faut être un minimum compétent en chimie (pour l\'eau : cyclage, nitrates, nitrites, PH, KH, EC), en plomberie (étanchéité, maintenance), en élevage des poisson (nourissage, gestion des maladies, etc), en connaissance des plantes (semis, croissance, maladies). Et cela après avoir conçu et réalisé son système (compétences en bricolage, même si on peut aussi acheter un système "clé en main").  </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Mais malgré l\'enviequi n\'a pas faibli, il faut parfois réduire ses ambitions. Après réflexion, j\'ai donc décidé de ne pas me lancer immédiatement dans l\'aquaponie.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Je précise que des installations aquaponiques sont possibles dans le sud. En particulier, un système très simple commercialisé par la société T\'air Eau a été installé avec succès jusque dans le Vaucluse. La simplicité du système (2 cuves de 500 litres enterrées reliées ensemble) pourrait réduire les risques de fuites et de mauvais fonctionnement au maximum.  C\'est d\'ailleurs un système que je vais étudier car il rompt avec les systèmes classiques et pourrait rendre l\'aquaponie plus accessible...</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading">Étape 3 : 2023, un système hydroponique à Saint-Germain-en-laye (78) et un système bioponique à Marseille (13)</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>L\'aquaponie m\'a amené à considérer la bioponie avec un intérêt nouveau : La bioponie, c\'est finalement une début de symbiose entre les bactéries et les plantes. C\'est un peu plus près de ce que fait la nature dans le sol. Et on peut penser que cet élément qui n\'existe pas en hydroponie (les bactéries qui transforment l\'organique en minéral), peut aider le système à être stable dans le temps ! </p>\n<!-- /wp:paragraph -->','Bienvenue','','inherit','closed','closed','','2-revision-v1','','','2023-08-24 19:34:59','2023-08-24 17:34:59','',2,'https://hs.vicq.org/?p=107',0,'revision','',0);
INSERT INTO `hs_posts` VALUES (109,1,'2023-08-27 11:08:52','2023-08-27 09:08:52','<!-- wp:heading -->\n<h2 class="wp-block-heading">Ce blog est consacré à l\'hydroponie et la bioponie domestiques. </h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Ces deux techniques de culture font partie de la famille des cultures hors-sol sur substrat neutre. Elles consistent à faire pousser des plantes sans terre, sur un substrat neutre (billes d\'argile par exemple), en mettant en place un dispositif efficace pour leur fournir les nutriments nécessaire pour assurer une croissance efficace des racines et des plantes. La recirculation du liquide nutritif évite une grande partie de la consommation d\'eau qui est induite dans la culture en sol. Je raconte ici les différentes étapes qui m\'ont amené à expérimenter et perfectionner ces technique.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Origine du projet et cheminement</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>J\'ai commencé à m\'intéresser aux questions de culture urbaines pendant l\'épidémie de COVID. Cet épisode anxiogène m\'a fait m\'interroger sur certaines questions d\'organisation de la société, et aux risques associés à l\'approvisionnement en ville des denrées alimentaires. En effet, il semble qu\'en cas de gros dysfonctionnement de la logistique d\'approvisionnement en nourriture, en quelque jours les villes pourraient se retrouver privées d\'une partie importante de leurs ressources alimentaires. Face à cette potentielle fragilité des flux de transport, il semble intéressant de développer des dispositifs urbains assurant une partie (même réduite) de la production de légumes dans la ville. Des études sur ces sujets existent, mais je ne suis pas un spécialiste de la recherche en agriculture urbaine, j\'essayerai de faire un peu de bibliographie à ce sujet quand j\'aurai le temps.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>De plus, les questions d\'épuisement de la planète sont maintenant au centre des débats, et cultiver des légumes en étant économe en eau et en énergie est un sujet qui m\'intéresse et me semble prometteur pour les temps qui viennent.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Culture hors sol, définitions</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Le web pullule d\'explications sur ces techniques de culture hors sol. Vous pouvez trouver <a href="https://fermedecagnolle.fr/hydroponie-bioponie-aquaponie-definitions/"><strong>ici</strong></a> par exemple des définitions simples de l\'<strong>hydroponie</strong>, <strong>bioponie</strong> et <strong>aquaponie</strong> proposées par Marion Sarlé (<a href="https://lessourciers.com/fr/">les sourciers</a>). Une page très bien conçue par Ecologia présente l\'aquaponie <a rel="noreferrer noopener" href="https://www.aquaponia.com/aquaponie-by-echologia/index.php/monde-aquaponia/qu-est-ce-que-l-aquaponie-definition" target="_blank">ici</a>. Ecologia propose des formation vers Laval. Marion Sarlé propose le livre «&nbsp;<em><strong>Monter sa microferme en hydroponie, bioponie et aquaponie</strong></em>&nbsp;», en vente sur le site <a href="https://lessourciers.com/fr/livre-sourciers/">Les Sourciers</a>&nbsp;. Les sourciers proposent aussi des <a href="https://lessourciers.com/fr/les-formations/">formations</a> en ligne et dans leur ferme du Gers. J\'ai suivi la partie en ligne de la formation <a href="https://lessourciers.com/fr/les-formations/microferme-hydroponique/">Microferme Hydroponique</a> qui m\'a bien aidé à comprendre les rudiments de base.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Une fois ces grandes définitions comprises, on trouve de très facilement des informations sur les <strong><a href="https://jardinfute.com/culture-hors-sol/page/2/">nombreux types de dispositifs</a></strong> utilisés pour ce type de culture (ex : <a href="https://jardinfute.com/methode-kratky/">Kratky</a>, <a href="https://jardinfute.com/systeme-dwc-hydroponie/">DWC</a>, <a href="https://jardinfute.com/systeme-nft-hydroponie/">NFT</a>, <a href="https://jardinfute.com/table-a-maree-ebb-flow/">table à marée</a>, etc.). J\'ai choisi les explications sur le site <a href="https://jardinfute.com/">jardinfute.com</a>, mais vous trouverez facilement d\'autres systèmes et d\'autres explications sur internet.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Si l\'on évalue la complexité de ces techniques, on comprend que l\'<strong>hydroponie</strong> est la plus simple des trois, puisqu\'elle se base sur la circulation d\'une solution nutritive contenant des nutriments minéraux (engrais) directement assimilables par les racines des plantes cultivées. En gros, il suffit de faire circuler de l\'eau additionnée d\'engrais sur les racines des plantes.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Quand on regarde les principes de la <strong>bioponie</strong> et l\'<strong>aquaponie</strong>, on comprend que le principe est plus complexe. Dans les deux cas on va transformer des éléments organiques en éléments minéraux pouvant être assimilés par les plantes (minéralisation). Cela est réalisé en deux étapes par l\'action de deux types de bactéries qui vont assurer tout d\'abord la transformation des éléments organiques en nitrites (bactéries <strong>Nitrosomonas</strong>) puis des nitrites en nitrates (bactéries <strong>Nitrobacter</strong>). Dans les deux cas, il faut offrir à ces bactéries un lieu et des conditions de vie, ce qui représente une complexité supplémentaire. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Enfin, pour l\'<strong>aquaponie</strong> il faut aussi s\'occuper de ses poissons, et en particulier gérer les caractéristiques de l\'eau. Des déséquilibres dans le système peuvent rapidement tuer une partie du cheptel, ce qui est plus impactant que de voir mourir un pied de ciboulette.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Bénéfices des systèmes hors-sol</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Les bénéfices de systèmes industriels ne sont pas analysés ici. Mais voici les bénéfices que produit un système opérationnel :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Très faible consommation d\'eau (environ 90 % d\'économie)</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Très faible consommation d\'électricité (pompe 10 W)</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Fort rendement au m2</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Fierté de produire sa nourriture</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>systèmes en hauteur, hors de portée des nuisibles rampants</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Intérêt pédagogique de la culture des plantes, pour tous (des plus petits aux plus grands)</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Système de circulation d\'eau produisant un bruit très agréable sans gêner les voisins</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Premier objectif : construire un système hydroponique</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Pour avoir les meilleures chances de réussite en limitant la complexité du savoir nécessaire et m\'y mettre rapidement, j\'ai choisi de commencer par l\'hydroponie.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>On peut vouloir créer des fermes hydroponiques de taille plus ou moins importante, mais j\'ai décidé de m\'intéresser à des dispositifs mis en œuvre à l\'échelle individuelle ou de proche voisinage, car cela représente des investissements réduits, une capacité de réalisation rapide et un investissement en temps acceptable. De plus, même si l\'ambition de tels systèmes n\'est pas de produire des bénéfices financiers, elle semble intéressante à l\'échelle de l\'individu ou du voisinage.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Prototypes</h2>\n<!-- /wp:heading -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading"></h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Durant l\'hiver 2021, j\'ai fait des recherches des différents systèmes hydroponiques disponibles et de comment réaliser sois-même ce genre de choses, et j\'ai été rapidement convaincu de l\'idée de commencer petit, afin d\'être prêt et de pouvoir planter dès le printemps 2022. Le retour d\'expérience des personnes expérimentées est unanime : il faut commencer simple et petit. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>De plus, commencer avec un petit système simple n\'a que des avantages pour quelqu\'un comme moi qui aime bricoler : </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Un petit prototype opérationnel est complet, donc on apprendra presque qu\'autant de choses que sur un plus gros système.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Le temps de développement est plus court, on aura ainsi plus de chances d\'aboutir dans des délais imposés par ses propres contraintes quotidiennes et l\'implacable chef d\'orchestre que sont les saisons. Par exemple, en France, il n\'est pas vraiment facile de planter des tomates à l\'automne, il faudra avoir été prêt pour le printemps, ou attendre le printemps suivant. </li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>On réduit le coût de fabrication, le risque financier et le temps passé si l\'on rate sa réalisation ou si on renonce avant la fin.</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:paragraph -->\n<p>J\'ai donc recherché les systèmes hydroponiques disponibles sur le marché ; j\'ai trouvé pas mal de systèmes clés en main, plus ou moins aboutis et plus ou moins chers. Pourtant, j\'ai décidé de construire moi-même mon premier système, pour plusieurs raisons :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Je suis convaincu que "mettre la main à la pâte" est souvent une bonne idée pour comprendre plus profondément un système technique,</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>j\'aime bien réaliser des prototypes en adaptant une solution technique existante à mon besoin personnel, cela m\'aide à  réfléchir à une généralisation possible les autres.</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading">Étape 1 : 2022, un petit système hydroponique (pour Marseille et la région parisienne)</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>J\'ai choisi de réaliser un système hydroponique vertical, pour prendre peu de place au sol. Pratiquant l\'impression impression 3D, j\'ai décidé de partir d\'un système déjà conçu, et de l\'adapter un peu. De plus, j\'ai décidé de fabriquer plusieurs systèmes identiques testés entre la Provence et la région parisienne.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Voici à quoi ce système ressemblait dans sa <a href="https://www.thingiverse.com/thing:3405964/">version originale</a> trouvée sur un site d\'impression 3D : </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:columns -->\n<div class="wp-block-columns"><!-- wp:column -->\n<div class="wp-block-column"><!-- wp:image {"width":535,"height":402,"sizeSlug":"large"} -->\n<figure class="wp-block-image size-large is-resized"><img src="https://cdn.thingiverse.com/renders/33/b6/37/85/85/59b0c38e5b805c7dd9b9f5abeee79ca0_preview_featured.jpg" alt="" style="width:535px;height:402px" width="535" height="402"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class="wp-block-column"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>La colonne est creuse est composée de modules empilables, ce qui permet de choisir le nombre de plantes</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>le réservoir en bas contient une pompe, cette dernière remonte l\'eau via un tuyau au centre de la tour jusqu\'à l\'étage supérieur qui et lui même percé de trous...</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>l\'eau passe par ces trous et redescend par gravité jusqu\'au réservoir, en arrosant au passage les racines des plantes maintenues en position dans des billes d\'argile dans les paniers amovibles (couleur ocre) installés dans la tour</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:paragraph -->\n<p>J\'ai du adapter le système de de fixation entre le bas de la tour et mon réservoirs, ainsi que certaines modifications mineures.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Au printemps 2022 J\'ai imprimé et mis en service 4 systèmes modulaires hydroponiques (que l\'on pourrait les qualifier d\'aéro-hydroponiques car le liquide nutritif ruisselle sur les racines, celles ci ne trempent pas dans le liquide). Ces systèmes avaient une forme de cylindre creux lequel étaient insérés des paniers contenant des billes d\'argile. En bas de la tour un réservoir de 10 à 20 litres dans lequel une pompe alimentait le haut de la tour par un tuyau, le liquide redescendant dans la tour en imprégnant les racines par gravité. Ce système est modulaire et permet d\'adapter plus ou moins d\'étages de plantation.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Trois ont été déployés dans les bouches du Rhône (2 à Marseille, un à Aix-en-Provence), un à Saint-Germain-en-Laye. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Merci à Aurélie, Martine et Friquette (ma maman) pour les avoir fait fonctionner et testés.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Le détail et les photos sont disponibles ici</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Les résultats étaient intéressants, j\'ai beaucoup appris de ce système. Mais je suis resté sur ma fin, pour les raisons suivantes :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>J\'ai planté des tomates ! Et cela a fonctionné. Sauf que les tomates produisent des volumes de racines gigantesques, et qu\'elles ont envahi l\'intérieur, ne laissant pas beaucoup de place au basilic et autres tentatives. De plus, je devait couper les racines des tomates très souvent...</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Les fraises ont végété,</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>J\'avais tenté de planter un chou fleur, qui était assez en forme mais n\'a jamais rien produit,</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>La ciboulette n\'a pas tenu, pas plus que le basilic,</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>La consommation d\'eau était importante : jusqu\'à 2 litres par jour. Le contenant (10 puis 20 litres) nécessitait d\'intervenir quotidiennement!</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:paragraph -->\n<p>La tentative en région parisienne, avec un climat plus frais, a été bien meilleure. Et ma maman, qui s\'en occupait, était certainement plus performante... Beaucoup de tomates, quelques fraises... </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>En résumé, oui, ça a fonctionné, mais à part les tomates, le résultat était décevant. Je pense aussi que j\'aurais dû ne pas placer le système en plein soleil en juillet et aout à Marseille, car même les tomates ont souffert !!</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading">Étape 2 : choix du système pour l\'année 2023</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Je voulais changer et faire évoluer mes systèmes, et j\'ai continuer de chercher des informations. Début 2022, j\'étais très motivé par les principes de l\'aquaponie. La nature symbiotique poissons + plantes, la création d\'un écosystème économe et vertueux, la double production poissons + plantes sur une surface réduite m\'ont donné très envie d\'aller voir de plus près ce genre de systèmes. J\'ai bien sur beaucoup cherché sur internet, vu des réalisations magnifiques (par exemple la chaine de <a rel="noreferrer noopener" href="https://www.youtube.com/@ChrisPagns" target="_blank">Chris Pagns</a> sur youtube).</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>J\'ai cherché si il existant des formations près de chez moi. J\'ai finalement opté pour une initiation à l\'aquaponie chez <a rel="noreferrer noopener" href="https://www.aquaponia.com/aquaponie-by-echologia/" target="_blank">Aquaponia, by Ecologia</a>, tout près de Laval (en Mayenne). J\'ai choisi ce stage pour les compétences reconnues de Guillaume Beucher, et pour le lieu magique. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Je n\'ai pas été déçu ! Après avoir surfé sur internet, j\'ai pu accéder à une idée plus proche de la réalité, quand on suit les enseignements de pros qui savent. Voici les principales évolutions de ma vision initiale :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Dans le sud de la France, sans mettre en place une infrastructure solide, coûteuse et complexe, il est difficile (et/ou couteux) d\'élever des truites (ce que je souhaitais faire initialement) : la truite meurt dans une eau au delà de 26°. Donc il faut choisir des poissons compatibles avec les températures élevées, comme le poissons rouge (non comestible) ou la carpe. Cela fut un constat un peu amer, mais après avoir vu comment Aquaponia gère ses poissons, après avoir visionné les <a rel="noreferrer noopener" href="https://www.youtube.com/watch?v=x4hBJlt6PMI&amp;t=425s" target="_blank">vidéos de Chris Pagns</a> et lu les <a rel="noreferrer noopener" href="https://www.amazon.fr/Aquaponie-guide-r%C3%A9f%C3%A9rence-Fran%C3%A7ois-Petitet-Gosgnach/dp/2815310252/ref=sr_1_1?__mk_fr_FR=%C3%85M%C3%85%C5%BD%C3%95%C3%91&amp;crid=1XD7AW59VAHUS&amp;keywords=aquaponie+petitet&amp;qid=1692551785&amp;sprefix=aquaponie+petitet%2Caps%2C126&amp;sr=8-1" target="_blank">livres de référence de l\'aquaponie de François Petitet-Gosgnach</a> (Adanat), j\'ai été convaincu de renoncer (temporairement au moins) à la truite. J\'aurais bien opté pour le Tilapia, mais il est interdit en France pour des risque d\'invasion si il aboutissait dans une rivière. Dommage, il adore l\'eau chaude ! </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>De plus, même si j\'ai la chance d\'avoir un jardin, pour réduire la température de l\'eau le bac à poissons doit être enterré. Comme je suis locataire, j\'ai renoncé à creuser dans le jardin.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Enfin, l\'aquaponie n\'est pas simple et représente une charge au quotidien : il faut être un minimum compétent en chimie (pour l\'eau : cyclage, nitrates, nitrites, PH, KH, EC), en plomberie (étanchéité, maintenance), en élevage des poisson (nourissage, gestion des maladies, etc), en connaissance des plantes (semis, croissance, maladies). Et cela après avoir conçu et réalisé son système (compétences en bricolage, même si on peut aussi acheter un système "clé en main").  </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Mais malgré l\'enviequi n\'a pas faibli, il faut parfois réduire ses ambitions. Après réflexion, j\'ai donc décidé de ne pas me lancer immédiatement dans l\'aquaponie.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Je précise que des installations aquaponiques sont possibles dans le sud. En particulier, un système très simple commercialisé par la société T\'air Eau a été installé avec succès jusque dans le Vaucluse. La simplicité du système (2 cuves de 500 litres enterrées reliées ensemble) pourrait réduire les risques de fuites et de mauvais fonctionnement au maximum.  C\'est d\'ailleurs un système que je vais étudier car il rompt avec les systèmes classiques et pourrait rendre l\'aquaponie plus accessible...</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading">Étape 3 : 2023, un système hydroponique à Saint-Germain-en-laye (78) et un système bioponique à Marseille (13)</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>L\'aquaponie m\'a amené à considérer la bioponie avec un intérêt nouveau : La bioponie, c\'est finalement une début de symbiose entre les bactéries et les plantes. C\'est un peu plus près de ce que fait la nature dans le sol. Et on peut penser que cet élément qui n\'existe pas en hydroponie (les bactéries qui transforment l\'organique en minéral), peut aider le système à être stable dans le temps ! </p>\n<!-- /wp:paragraph -->','Bienvenue','','inherit','closed','closed','','2-revision-v1','','','2023-08-27 11:08:52','2023-08-27 09:08:52','',2,'https://hs.vicq.org/?p=109',0,'revision','',0);
INSERT INTO `hs_posts` VALUES (110,1,'2023-08-27 11:28:21','2023-08-27 09:28:21','<!-- wp:heading -->\n<h2 class="wp-block-heading">Ce blog est consacré à l\'hydroponie et la bioponie domestiques. </h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Ces deux techniques de culture font partie de la famille des cultures hors-sol sur substrat neutre. Elles consistent à faire pousser des plantes sans terre, sur un substrat neutre (billes d\'argile par exemple), en mettant en place un dispositif efficace pour leur fournir les nutriments nécessaire pour assurer une croissance efficace des racines et des plantes. La recirculation du liquide nutritif évite une grande partie de la consommation d\'eau qui est induite dans la culture en sol. Je raconte ici les différentes étapes qui m\'ont amené à expérimenter et perfectionner ces technique.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Origine du projet et cheminement</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>J\'ai commencé à m\'intéresser aux questions de culture urbaines pendant l\'épidémie de COVID. Cet épisode anxiogène m\'a fait m\'interroger sur certaines questions d\'organisation de la société, et aux risques associés à l\'approvisionnement en ville des denrées alimentaires. En effet, il semble qu\'en cas de gros dysfonctionnement de la logistique d\'approvisionnement en nourriture, en quelque jours les villes pourraient se retrouver privées d\'une partie importante de leurs ressources alimentaires. Face à cette potentielle fragilité des flux de transport, il semble intéressant de développer des dispositifs urbains assurant une partie (même réduite) de la production de légumes dans la ville. Des études sur ces sujets existent, mais je ne suis pas un spécialiste de la recherche en agriculture urbaine, j\'essayerai de faire un peu de bibliographie à ce sujet quand j\'aurai le temps.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>De plus, les questions d\'épuisement de la planète sont maintenant au centre des débats, et cultiver des légumes en étant économe en eau et en énergie est un sujet qui m\'intéresse et me semble prometteur pour les temps qui viennent.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Culture hors sol, définitions</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Le web pullule d\'explications sur ces techniques de culture hors sol. Vous pouvez trouver <a href="https://fermedecagnolle.fr/hydroponie-bioponie-aquaponie-definitions/"><strong>ici</strong></a> par exemple des définitions simples de l\'<strong>hydroponie</strong>, <strong>bioponie</strong> et <strong>aquaponie</strong> proposées par Marion Sarlé (<a href="https://lessourciers.com/fr/">les sourciers</a>). Une page très bien conçue par Ecologia présente l\'aquaponie <a rel="noreferrer noopener" href="https://www.aquaponia.com/aquaponie-by-echologia/index.php/monde-aquaponia/qu-est-ce-que-l-aquaponie-definition" target="_blank">ici</a>. Ecologia propose des formation vers Laval. Marion Sarlé propose le livre «&nbsp;<em><strong>Monter sa microferme en hydroponie, bioponie et aquaponie</strong></em>&nbsp;», en vente sur le site <a href="https://lessourciers.com/fr/livre-sourciers/">Les Sourciers</a>&nbsp;. Les sourciers proposent aussi des <a href="https://lessourciers.com/fr/les-formations/">formations</a> en ligne et dans leur ferme du Gers. J\'ai suivi la partie en ligne de la formation <a href="https://lessourciers.com/fr/les-formations/microferme-hydroponique/">Microferme Hydroponique</a> qui m\'a bien aidé à comprendre les rudiments de base.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Une fois ces grandes définitions comprises, on trouve de très facilement des informations sur les <strong><a href="https://jardinfute.com/culture-hors-sol/page/2/">nombreux types de dispositifs</a></strong> utilisés pour ce type de culture (ex : <a href="https://jardinfute.com/methode-kratky/">Kratky</a>, <a href="https://jardinfute.com/systeme-dwc-hydroponie/">DWC</a>, <a href="https://jardinfute.com/systeme-nft-hydroponie/">NFT</a>, <a href="https://jardinfute.com/table-a-maree-ebb-flow/">table à marée</a>, etc.). J\'ai choisi les explications sur le site <a href="https://jardinfute.com/">jardinfute.com</a>, mais vous trouverez facilement d\'autres systèmes et d\'autres explications sur internet.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Si l\'on évalue la complexité de ces techniques, on comprend que l\'<strong>hydroponie</strong> est la plus simple des trois, puisqu\'elle se base sur la circulation d\'une solution nutritive contenant des nutriments minéraux (engrais) directement assimilables par les racines des plantes cultivées. En gros, il suffit de faire circuler de l\'eau additionnée d\'engrais sur les racines des plantes.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Quand on regarde les principes de la <strong>bioponie</strong> et l\'<strong>aquaponie</strong>, on comprend que le principe est plus complexe. Dans les deux cas on va transformer des éléments organiques en éléments minéraux pouvant être assimilés par les plantes (minéralisation). Cela est réalisé en deux étapes par l\'action de deux types de bactéries qui vont assurer tout d\'abord la transformation des éléments organiques en nitrites (bactéries <strong>Nitrosomonas</strong>) puis des nitrites en nitrates (bactéries <strong>Nitrobacter</strong>). Dans les deux cas, il faut offrir à ces bactéries un lieu et des conditions de vie, ce qui représente une complexité supplémentaire. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Enfin, pour l\'<strong>aquaponie</strong> il faut aussi s\'occuper de ses poissons, et en particulier gérer les caractéristiques de l\'eau. Des déséquilibres dans le système peuvent rapidement tuer une partie du cheptel, ce qui est plus impactant que de voir mourir un pied de ciboulette.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Bénéfices des systèmes hors-sol</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Les bénéfices de systèmes industriels ne sont pas analysés ici. Mais voici les bénéfices que produit un système opérationnel :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Très faible consommation d\'eau (environ 90 % d\'économie)</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Très faible consommation d\'électricité (pompe 10 W)</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Fort rendement au m2</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Fierté de produire sa nourriture</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>systèmes en hauteur, hors de portée des nuisibles rampants</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Intérêt pédagogique de la culture des plantes, pour tous (des plus petits aux plus grands)</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Système de circulation d\'eau produisant un bruit très agréable sans gêner les voisins</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Premier objectif : construire un système hydroponique</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Pour avoir les meilleures chances de réussite en limitant la complexité du savoir nécessaire et m\'y mettre rapidement, j\'ai choisi de commencer par l\'hydroponie.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>On peut vouloir créer des fermes hydroponiques de taille plus ou moins importante, mais j\'ai décidé de m\'intéresser à des dispositifs mis en œuvre à l\'échelle individuelle ou de proche voisinage, car cela représente des investissements réduits, une capacité de réalisation rapide et un investissement en temps acceptable. De plus, même si l\'ambition de tels systèmes n\'est pas de produire des bénéfices financiers, elle semble intéressante à l\'échelle de l\'individu ou du voisinage.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Prototypes</h2>\n<!-- /wp:heading -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading"></h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Durant l\'hiver 2021, j\'ai fait des recherches des différents systèmes hydroponiques disponibles et de comment réaliser sois-même ce genre de choses, et j\'ai été rapidement convaincu de l\'idée de commencer petit, afin d\'être prêt et de pouvoir planter dès le printemps 2022. Le retour d\'expérience des personnes expérimentées est unanime : il faut commencer simple et petit. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>De plus, commencer avec un petit système simple n\'a que des avantages pour quelqu\'un comme moi qui aime bricoler : </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Un petit prototype opérationnel est complet, donc on apprendra presque qu\'autant de choses que sur un plus gros système.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Le temps de développement est plus court, on aura ainsi plus de chances d\'aboutir dans des délais imposés par ses propres contraintes quotidiennes et l\'implacable chef d\'orchestre que sont les saisons. Par exemple, en France, il n\'est pas vraiment facile de planter des tomates à l\'automne, il faudra avoir été prêt pour le printemps, ou attendre le printemps suivant. </li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>On réduit le coût de fabrication, le risque financier et le temps passé si l\'on rate sa réalisation ou si on renonce avant la fin.</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:paragraph -->\n<p>J\'ai donc recherché les systèmes hydroponiques disponibles sur le marché ; j\'ai trouvé pas mal de systèmes clés en main, plus ou moins aboutis et plus ou moins chers. Pourtant, j\'ai décidé de construire moi-même mon premier système, pour plusieurs raisons :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Je suis convaincu que "mettre la main à la pâte" est souvent une bonne idée pour comprendre plus profondément ce qui se passe dans un dispositif technique,</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>j\'aime bien réaliser des prototypes en adaptant une solution technique existante à mon besoin personnel, cela m\'aide à imaginer comment envisager une généralisation à d\'autres cas d\'usages.</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading">Étape 1 : 2022, un petit système hydroponique (pour Marseille et la région parisienne)</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>J\'ai donc choisi de réaliser un système hydroponique vertical, pour prendre peu de place au sol. Pratiquant l\'impression impression 3D, j\'ai décidé de partir d\'un système déjà conçu avec cette technique de fabrication, et de l\'adapter un peu. De plus, j\'ai décidé de fabriquer plusieurs systèmes identiques testés entre la Provence et la région parisienne.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Voici à quoi ce système ressemblait dans sa <a href="https://www.thingiverse.com/thing:3405964/" target="_blank" rel="noreferrer noopener">version originale</a> trouvée sur un site d\'impression 3D : </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:columns -->\n<div class="wp-block-columns"><!-- wp:column -->\n<div class="wp-block-column"><!-- wp:image {"width":535,"height":402,"sizeSlug":"large"} -->\n<figure class="wp-block-image size-large is-resized"><img src="https://cdn.thingiverse.com/renders/33/b6/37/85/85/59b0c38e5b805c7dd9b9f5abeee79ca0_preview_featured.jpg" alt="" style="width:535px;height:402px" width="535" height="402"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class="wp-block-column"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>La colonne est creuse est composée de modules empilables, ce qui permet de choisir le nombre de plantes,</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>le réservoir en bas contient une pompe, cette dernière remonte l\'eau via un tuyau au centre de la tour jusqu\'à l\'étage supérieur qui est lui même percé de trous...</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>l\'eau passe par ces trous et redescend par gravité jusqu\'au réservoir, en arrosant au passage les racines des plantes maintenues en position dans des billes d\'argile dans les paniers amovibles (couleur ocre sur la photo) installés dans la tour.</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:paragraph -->\n<p>J\'ai du adapter le système de fixation entre le bas de la tour avec mon réservoirs, ainsi que certaines autres modifications mineures.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Au printemps 2022 J\'ai imprimé et mis en service 4 systèmes modulaires hydroponiques (que l\'on pourrait les qualifier d\'aéro-hydroponiques car le liquide nutritif ruisselle sur les racines, celles ci ne trempent pas dans le liquide). Ces systèmes avaient la forme d\'un cylindre creux dans lequel étaient insérés des paniers contenant des billes d\'argile. En bas de la tour un réservoir de 10 à 20 litres dans lequel une pompe alimentait le haut de la tour par un tuyau, le liquide redescendant dans la tour en imprégnant les racines par gravité. Ce système est modulaire et permet d\'adapter plus ou moins d\'étages de plantation.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Trois ont été déployés dans les bouches du Rhône (2 à Marseille, un à Aix-en-Provence), un à Saint-Germain-en-Laye. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Merci à Aurélie, Martine et Friquette (ma maman) pour les avoir fait fonctionner et testés.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Le détail et les photos sont disponibles sur la page dédiée</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Les résultats étaient intéressants, j\'ai beaucoup appris de ce système. Mais je suis resté sur ma fin, pour les raisons suivantes :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>J\'ai planté des tomates ! Et cela a fonctionné ! Sauf que les tomates produisent des volumes de racines gigantesques, et qu\'elles ont envahi l\'intérieur, ne laissant pas beaucoup de place au basilic et autres tentatives. De plus, je devait couper les racines des tomates très souvent...</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Les tomates consommaient plusieurs litres d\'eau par jour (surtout par évapo-transpiration), ce qui impliquait un remplissage quotidien du bac (2 à 4 litres consommés par jour en plein été dans un bac de 15 puis 30 litres), et donc une assez forte variation de la concentration des nutriments (ce que les plantes n\'aiment pas beaucoup).</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Les fraises ont végété,</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>J\'avais tenté de planter un chou fleur, qui était assez en forme mais n\'a jamais rien produit,</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>La ciboulette n\'a pas tenu, pas plus que le basilic,</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:paragraph -->\n<p>Les deux autres systèmes installés dans la région ont produit des tomates et des poivrons pour l\'un, rien pour l\'autre (par manque de lumière semble-t-il) ; l\'expérimentation en région parisienne, avec un climat moins chaud, a été bien meilleure. Et ma maman, qui s\'en occupait, était certainement plus performante... Beaucoup de tomates, quelques fraises... </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>En résumé, oui, ça a fonctionné, mais à part les tomates, le résultat était décevant. Je pense aussi que j\'aurais dû ne pas placer mon dispositif en plein soleil en juillet et aout à Marseille, car même les tomates ont souffert de la chaleur !! Je pense même que la sud de la France n\'est pas perticulièrement approprié à la culture de tomate en hors sol en juillet/août. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading">Étape 2 : choix du système pour l\'année 2023</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Je voulais changer et faire évoluer mes systèmes, et j\'ai continuer de chercher des informations. Début 2022, j\'étais très motivé par les principes de l\'aquaponie. La nature symbiotique poissons + plantes, la création d\'un écosystème économe et vertueux, la double production poissons + plantes sur une surface réduite m\'ont donné très envie d\'aller voir de plus près ce genre de systèmes. J\'ai bien sur beaucoup cherché sur internet, vu des réalisations magnifiques (par exemple la chaine de <a rel="noreferrer noopener" href="https://www.youtube.com/@ChrisPagns" target="_blank">Chris Pagns</a> sur youtube).</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>J\'ai cherché si il existant des formations près de chez moi. J\'ai finalement opté pour une initiation à l\'aquaponie chez <a rel="noreferrer noopener" href="https://www.aquaponia.com/aquaponie-by-echologia/" target="_blank">Aquaponia, by Ecologia</a>, tout près de Laval (en Mayenne). J\'ai choisi ce stage pour les compétences reconnues de Guillaume Beucher, et pour le lieu magique. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Je n\'ai pas été déçu ! Après avoir surfé sur internet, j\'ai pu accéder à une idée plus proche de la réalité, quand on suit les enseignements de pros qui savent. Voici les principales évolutions de ma vision initiale :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Dans le sud de la France, sans mettre en place une infrastructure solide, coûteuse et complexe, il est difficile (et/ou couteux) d\'élever des truites (ce que je souhaitais faire initialement) : la truite meurt dans une eau au delà de 26°. Donc il faut choisir des poissons compatibles avec les températures élevées, comme le poissons rouge (non comestible) ou la carpe. Cela fut un constat un peu amer, mais après avoir vu comment Aquaponia gère ses poissons, après avoir visionné les <a rel="noreferrer noopener" href="https://www.youtube.com/watch?v=x4hBJlt6PMI&amp;t=425s" target="_blank">vidéos de Chris Pagns</a> et lu les <a rel="noreferrer noopener" href="https://www.amazon.fr/Aquaponie-guide-r%C3%A9f%C3%A9rence-Fran%C3%A7ois-Petitet-Gosgnach/dp/2815310252/ref=sr_1_1?__mk_fr_FR=%C3%85M%C3%85%C5%BD%C3%95%C3%91&amp;crid=1XD7AW59VAHUS&amp;keywords=aquaponie+petitet&amp;qid=1692551785&amp;sprefix=aquaponie+petitet%2Caps%2C126&amp;sr=8-1" target="_blank">livres de référence de l\'aquaponie de François Petitet-Gosgnach</a> (Adanat), j\'ai été convaincu de renoncer (temporairement au moins) à la truite. J\'aurais bien opté pour le Tilapia, mais il est interdit en France pour des risque d\'invasion si il aboutissait dans une rivière. Dommage, il adore l\'eau chaude ! </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>De plus, même si j\'ai la chance d\'avoir un jardin, pour réduire la température de l\'eau le bac à poissons doit être enterré. Comme je suis locataire, j\'ai renoncé à creuser dans le jardin.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Enfin, l\'aquaponie n\'est pas simple et représente une charge au quotidien : il faut être un minimum compétent en chimie (pour l\'eau : cyclage, nitrates, nitrites, PH, KH, EC), en plomberie (étanchéité, maintenance), en élevage des poisson (nourissage, gestion des maladies, etc), en connaissance des plantes (semis, croissance, maladies). Et cela après avoir conçu et réalisé son système (compétences en bricolage, même si on peut aussi acheter un système "clé en main").  </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Mais malgré l\'enviequi n\'a pas faibli, il faut parfois réduire ses ambitions. Après réflexion, j\'ai donc décidé de ne pas me lancer immédiatement dans l\'aquaponie.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Je précise que des installations aquaponiques sont possibles dans le sud. En particulier, un système très simple commercialisé par la société T\'air Eau a été installé avec succès jusque dans le Vaucluse. La simplicité du système (2 cuves de 500 litres enterrées reliées ensemble) pourrait réduire les risques de fuites et de mauvais fonctionnement au maximum.  C\'est d\'ailleurs un système que je vais étudier car il rompt avec les systèmes classiques et pourrait rendre l\'aquaponie plus accessible...</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading">Étape 3 : 2023, un système hydroponique à Saint-Germain-en-laye (78) et un système bioponique à Marseille (13)</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>L\'aquaponie m\'a amené à considérer la bioponie avec un intérêt nouveau : La bioponie, c\'est finalement une début de symbiose entre les bactéries et les plantes. C\'est un peu plus près de ce que fait la nature dans le sol. Et on peut penser que cet élément qui n\'existe pas en hydroponie (les bactéries qui transforment l\'organique en minéral), peut aider le système à être stable dans le temps ! </p>\n<!-- /wp:paragraph -->','Bienvenue','','inherit','closed','closed','','2-revision-v1','','','2023-08-27 11:28:21','2023-08-27 09:28:21','',2,'https://hs.vicq.org/?p=110',0,'revision','',0);
INSERT INTO `hs_posts` VALUES (111,1,'2023-08-27 11:31:19','2023-08-27 09:31:19','<!-- wp:heading -->\n<h2 class="wp-block-heading">Ce blog est consacré à l\'hydroponie et la bioponie domestiques. </h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Ces deux techniques de culture font partie de la famille des cultures hors-sol sur substrat neutre. Elles consistent à faire pousser des plantes sans terre, sur un substrat neutre (billes d\'argile par exemple), en mettant en place un dispositif efficace pour leur fournir les nutriments nécessaire pour assurer une croissance efficace des racines et des plantes. La recirculation du liquide nutritif évite une grande partie de la consommation d\'eau qui est induite dans la culture en sol. Je raconte ici les différentes étapes qui m\'ont amené à expérimenter et perfectionner ces technique.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Origine du projet et cheminement</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>J\'ai commencé à m\'intéresser aux questions de culture urbaines pendant l\'épidémie de COVID. Cet épisode anxiogène m\'a fait m\'interroger sur certaines questions d\'organisation de la société, et aux risques associés à l\'approvisionnement en ville des denrées alimentaires. En effet, il semble qu\'en cas de gros dysfonctionnement de la logistique d\'approvisionnement en nourriture, en quelque jours les villes pourraient se retrouver privées d\'une partie importante de leurs ressources alimentaires. Face à cette potentielle fragilité des flux de transport, il semble intéressant de développer des dispositifs urbains assurant une partie (même réduite) de la production de légumes dans la ville. Des études sur ces sujets existent, mais je ne suis pas un spécialiste de la recherche en agriculture urbaine, j\'essayerai de faire un peu de bibliographie à ce sujet quand j\'aurai le temps.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>De plus, les questions d\'épuisement de la planète sont maintenant au centre des débats, et cultiver des légumes en étant économe en eau et en énergie est un sujet qui m\'intéresse et me semble prometteur pour les temps qui viennent.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Culture hors sol, définitions</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Le web pullule d\'explications sur ces techniques de culture hors sol. Vous pouvez trouver <a href="https://fermedecagnolle.fr/hydroponie-bioponie-aquaponie-definitions/"><strong>ici</strong></a> par exemple des définitions simples de l\'<strong>hydroponie</strong>, <strong>bioponie</strong> et <strong>aquaponie</strong> proposées par Marion Sarlé (<a href="https://lessourciers.com/fr/">les sourciers</a>). Une page très bien conçue par Ecologia présente l\'aquaponie <a rel="noreferrer noopener" href="https://www.aquaponia.com/aquaponie-by-echologia/index.php/monde-aquaponia/qu-est-ce-que-l-aquaponie-definition" target="_blank">ici</a>. Ecologia propose des formation vers Laval. Marion Sarlé propose le livre «&nbsp;<em><strong>Monter sa microferme en hydroponie, bioponie et aquaponie</strong></em>&nbsp;», en vente sur le site <a href="https://lessourciers.com/fr/livre-sourciers/">Les Sourciers</a>&nbsp;. Les sourciers proposent aussi des <a href="https://lessourciers.com/fr/les-formations/">formations</a> en ligne et dans leur ferme du Gers. J\'ai suivi la partie en ligne de la formation <a href="https://lessourciers.com/fr/les-formations/microferme-hydroponique/">Microferme Hydroponique</a> qui m\'a bien aidé à comprendre les rudiments de base.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Une fois ces grandes définitions comprises, on trouve de très facilement des informations sur les <strong><a href="https://jardinfute.com/culture-hors-sol/page/2/">nombreux types de dispositifs</a></strong> utilisés pour ce type de culture (ex : <a href="https://jardinfute.com/methode-kratky/">Kratky</a>, <a href="https://jardinfute.com/systeme-dwc-hydroponie/">DWC</a>, <a href="https://jardinfute.com/systeme-nft-hydroponie/">NFT</a>, <a href="https://jardinfute.com/table-a-maree-ebb-flow/">table à marée</a>, etc.). J\'ai choisi les explications sur le site <a href="https://jardinfute.com/">jardinfute.com</a>, mais vous trouverez facilement d\'autres systèmes et d\'autres explications sur internet.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Si l\'on évalue la complexité de ces techniques, on comprend que l\'<strong>hydroponie</strong> est la plus simple des trois, puisqu\'elle se base sur la circulation d\'une solution nutritive contenant des nutriments minéraux (engrais) directement assimilables par les racines des plantes cultivées. En gros, il suffit de faire circuler de l\'eau additionnée d\'engrais sur les racines des plantes.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Quand on regarde les principes de la <strong>bioponie</strong> et l\'<strong>aquaponie</strong>, on comprend que le principe est plus complexe. Dans les deux cas on va transformer des éléments organiques en éléments minéraux pouvant être assimilés par les plantes (minéralisation). Cela est réalisé en deux étapes par l\'action de deux types de bactéries qui vont assurer tout d\'abord la transformation des éléments organiques en nitrites (bactéries <strong>Nitrosomonas</strong>) puis des nitrites en nitrates (bactéries <strong>Nitrobacter</strong>). Dans les deux cas, il faut offrir à ces bactéries un lieu et des conditions de vie, ce qui représente une complexité supplémentaire. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Enfin, pour l\'<strong>aquaponie</strong> il faut aussi s\'occuper de ses poissons, et en particulier gérer les caractéristiques de l\'eau. Des déséquilibres dans le système peuvent rapidement tuer une partie du cheptel, ce qui est plus impactant que de voir mourir un pied de ciboulette.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Bénéfices des systèmes hors-sol</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Les bénéfices de systèmes industriels ne sont pas analysés ici. Mais voici les bénéfices que produit un système opérationnel :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Très faible consommation d\'eau (environ 90 % d\'économie)</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Très faible consommation d\'électricité (pompe 10 W)</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Fort rendement au m2</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Fierté de produire sa nourriture</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>systèmes en hauteur, hors de portée des nuisibles rampants</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Intérêt pédagogique de la culture des plantes, pour tous (des plus petits aux plus grands)</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Système de circulation d\'eau produisant un bruit très agréable sans gêner les voisins</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Premier objectif : construire un système hydroponique</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Pour avoir les meilleures chances de réussite en limitant la complexité du savoir nécessaire et m\'y mettre rapidement, j\'ai choisi de commencer par l\'hydroponie.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>On peut vouloir créer des fermes hydroponiques de taille plus ou moins importante, mais j\'ai décidé de m\'intéresser à des dispositifs mis en œuvre à l\'échelle individuelle ou de proche voisinage, car cela représente des investissements réduits, une capacité de réalisation rapide et un investissement en temps acceptable. De plus, même si l\'ambition de tels systèmes n\'est pas de produire des bénéfices financiers, elle semble intéressante à l\'échelle de l\'individu ou du voisinage.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Prototypes</h2>\n<!-- /wp:heading -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading"></h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Durant l\'hiver 2021, j\'ai fait des recherches des différents systèmes hydroponiques disponibles et de comment réaliser sois-même ce genre de choses, et j\'ai été rapidement convaincu de l\'idée de commencer petit, afin d\'être prêt et de pouvoir planter dès le printemps 2022. Le retour d\'expérience des personnes expérimentées est unanime : il faut commencer simple et petit. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>De plus, commencer avec un petit système simple n\'a que des avantages pour quelqu\'un comme moi qui aime bricoler : </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Un petit prototype opérationnel est complet, donc on apprendra presque qu\'autant de choses que sur un plus gros système.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Le temps de développement est plus court, on aura ainsi plus de chances d\'aboutir dans des délais imposés par ses propres contraintes quotidiennes et l\'implacable chef d\'orchestre que sont les saisons. Par exemple, en France, il n\'est pas vraiment facile de planter des tomates à l\'automne, il faudra avoir été prêt pour le printemps, ou attendre le printemps suivant. </li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>On réduit le coût de fabrication, le risque financier et le temps passé si l\'on rate sa réalisation ou si on renonce avant la fin.</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:paragraph -->\n<p>J\'ai donc recherché les systèmes hydroponiques disponibles sur le marché ; j\'ai trouvé pas mal de systèmes clés en main, plus ou moins aboutis et plus ou moins chers. Pourtant, j\'ai décidé de construire moi-même mon premier système, pour plusieurs raisons :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Je suis convaincu que "mettre la main à la pâte" est souvent une bonne idée pour comprendre plus profondément ce qui se passe dans un dispositif technique,</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>j\'aime bien réaliser des prototypes en adaptant une solution technique existante à mon besoin personnel, cela m\'aide à imaginer comment envisager une généralisation à d\'autres cas d\'usages.</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading">Étape 1 : 2022, un petit système hydroponique (pour Marseille et la région parisienne)</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>J\'ai donc choisi de réaliser un système hydroponique vertical, pour prendre peu de place au sol. Pratiquant l\'impression impression 3D, j\'ai décidé de partir d\'un système déjà conçu avec cette technique de fabrication, et de l\'adapter un peu. De plus, j\'ai décidé de fabriquer plusieurs systèmes identiques testés entre la Provence et la région parisienne.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Voici à quoi ce système ressemblait dans sa <a href="https://www.thingiverse.com/thing:3405964/" target="_blank" rel="noreferrer noopener">version originale</a> trouvée sur un site d\'impression 3D : </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:columns -->\n<div class="wp-block-columns"><!-- wp:column -->\n<div class="wp-block-column"><!-- wp:image {"width":535,"height":402,"sizeSlug":"large"} -->\n<figure class="wp-block-image size-large is-resized"><img src="https://cdn.thingiverse.com/renders/33/b6/37/85/85/59b0c38e5b805c7dd9b9f5abeee79ca0_preview_featured.jpg" alt="" style="width:535px;height:402px" width="535" height="402"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class="wp-block-column"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>La colonne est creuse est composée de modules empilables, ce qui permet de choisir le nombre de plantes,</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>le réservoir en bas contient une pompe, cette dernière remonte l\'eau via un tuyau au centre de la tour jusqu\'à l\'étage supérieur qui est lui même percé de trous...</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>l\'eau passe par ces trous et redescend par gravité jusqu\'au réservoir, en arrosant au passage les racines des plantes maintenues en position dans des billes d\'argile dans les paniers amovibles (couleur ocre sur la photo) installés dans la tour.</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:paragraph -->\n<p>J\'ai du adapter le système de fixation entre le bas de la tour avec mon réservoirs, ainsi que certaines autres modifications mineures.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Au printemps 2022 J\'ai imprimé et mis en service 4 systèmes modulaires hydroponiques (que l\'on pourrait les qualifier d\'aéro-hydroponiques car le liquide nutritif ruisselle sur les racines, celles ci ne trempent pas dans le liquide). Ces systèmes avaient la forme d\'un cylindre creux dans lequel étaient insérés des paniers contenant des billes d\'argile. En bas de la tour un réservoir de 10 à 20 litres dans lequel une pompe alimentait le haut de la tour par un tuyau, le liquide redescendant dans la tour en imprégnant les racines par gravité. Ce système est modulaire et permet d\'adapter plus ou moins d\'étages de plantation.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Trois ont été déployés dans les bouches du Rhône (2 à Marseille, un à Aix-en-Provence), un à Saint-Germain-en-Laye. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Merci à Aurélie, Martine et Friquette (ma maman) pour les avoir fait fonctionner et testés.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Le détail et les photos sont disponibles sur la page dédiée</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Les résultats étaient intéressants, j\'ai beaucoup appris de ce système. Mais je suis resté sur ma fin, pour les raisons suivantes :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>J\'ai planté des tomates ! Et cela a fonctionné ! Sauf que les tomates produisent des volumes de racines gigantesques, et qu\'elles ont envahi l\'intérieur, ne laissant pas beaucoup de place au basilic et autres tentatives. De plus, je devait couper les racines des tomates très souvent...</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Les tomates consommaient plusieurs litres d\'eau par jour (surtout par évapo-transpiration), ce qui impliquait un remplissage quotidien du bac (2 à 4 litres consommés par jour en plein été dans un bac de 15 puis 30 litres), et donc une assez forte variation de la concentration des nutriments (ce que les plantes n\'aiment pas beaucoup).</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Les fraises ont végété,</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>J\'avais tenté de planter un chou fleur, qui était assez en forme mais n\'a jamais rien produit,</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>La ciboulette n\'a pas tenu, pas plus que le basilic,</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:paragraph -->\n<p>Les deux autres systèmes installés dans la région ont produit des tomates et des poivrons pour l\'un, rien pour l\'autre (par manque de lumière semble-t-il) ; l\'expérimentation en région parisienne, avec un climat moins chaud, a été bien meilleure. Et ma maman, qui s\'en occupait, était certainement plus performante... Beaucoup de tomates, quelques fraises... </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>En résumé, oui, ça a fonctionné, mais à part les tomates, le résultat était décevant. Je pense aussi que j\'aurais dû ne pas placer mon dispositif en plein soleil en juillet et aout à Marseille, car même les tomates ont souffert de la chaleur !! Je pense même que la sud de la France n\'est pas perticulièrement approprié à la culture de tomate en hors sol en juillet/août. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading">Étape 2 : choix du système pour l\'année 2023</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Après ce premier essai, je voulais changer et faire évoluer mon système, et j\'ai continuer de chercher des informations. Début 2022, j\'ai été très motivé par les principes de l\'aquaponie. La nature symbiotique poissons + plantes, la création d\'un écosystème économe et vertueux, la double production poissons + plantes sur une surface réduite m\'ont donné très envie d\'aller voir de plus près ce genre de systèmes. J\'ai, bien sur, beaucoup exploré internet, vu des réalisations magnifiques (par exemple la chaine de <a rel="noreferrer noopener" href="https://www.youtube.com/@ChrisPagns" target="_blank">Chris Pagns</a> sur youtube).</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>J\'ai cherché si il existait des formations près de chez moi. J\'ai finalement opté pour une initiation à l\'aquaponie en mai 2022 chez <a rel="noreferrer noopener" href="https://www.aquaponia.com/aquaponie-by-echologia/" target="_blank">Aquaponia, by Ecologia</a>, tout près de Laval (en Mayenne). J\'ai choisi ce stage pour les compétences reconnues de Guillaume Beucher, et pour le lieu magique. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Je n\'ai pas été déçu ! Après avoir surfé sur internet pendant un an, j\'ai ainsi pu accéder à une idée plus proche de la réalité de ce qui est possible quand on suit les enseignements de pros qui savent. Voici les principales évolutions de ma vision initiale :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Dans le sud de la France, sans mettre en place une infrastructure solide, coûteuse et complexe, il est difficile (et/ou couteux) d\'élever des truites (ce que je souhaitais faire initialement) : la truite meurt dans une eau au delà de 26°. Donc il faut choisir des poissons compatibles avec les températures élevées, comme le poissons rouge (non comestible) ou la carpe. Cela fut un constat un peu amer, mais après avoir vu comment Aquaponia gère ses poissons, après avoir visionné les <a rel="noreferrer noopener" href="https://www.youtube.com/watch?v=x4hBJlt6PMI&amp;t=425s" target="_blank">vidéos de Chris Pagns</a> et lu les <a rel="noreferrer noopener" href="https://www.amazon.fr/Aquaponie-guide-r%C3%A9f%C3%A9rence-Fran%C3%A7ois-Petitet-Gosgnach/dp/2815310252/ref=sr_1_1?__mk_fr_FR=%C3%85M%C3%85%C5%BD%C3%95%C3%91&amp;crid=1XD7AW59VAHUS&amp;keywords=aquaponie+petitet&amp;qid=1692551785&amp;sprefix=aquaponie+petitet%2Caps%2C126&amp;sr=8-1" target="_blank">livres de référence de l\'aquaponie de François Petitet-Gosgnach</a> (Adanat), j\'ai été convaincu de renoncer (temporairement au moins) à la truite. J\'aurais bien opté pour le Tilapia, mais il est interdit en France pour des risque d\'invasion si il aboutissait dans une rivière. Dommage, il adore l\'eau chaude ! </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>De plus, même si j\'ai la chance d\'avoir un jardin, pour réduire la température de l\'eau le bac à poissons doit être enterré. Comme je suis locataire, j\'ai renoncé à creuser dans le jardin.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Enfin, l\'aquaponie n\'est pas simple et représente une charge au quotidien : il faut être un minimum compétent en chimie (pour l\'eau : cyclage, nitrates, nitrites, PH, KH, EC), en plomberie (étanchéité, maintenance), en élevage des poisson (nourissage, gestion des maladies, etc), en connaissance des plantes (semis, croissance, maladies). Et cela après avoir conçu et réalisé son système (compétences en bricolage, même si on peut aussi acheter un système "clé en main").  </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Mais malgré l\'enviequi n\'a pas faibli, il faut parfois réduire ses ambitions. Après réflexion, j\'ai donc décidé de ne pas me lancer immédiatement dans l\'aquaponie.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Je précise que des installations aquaponiques sont possibles dans le sud. En particulier, un système très simple commercialisé par la société T\'air Eau a été installé avec succès jusque dans le Vaucluse. La simplicité du système (2 cuves de 500 litres enterrées reliées ensemble) pourrait réduire les risques de fuites et de mauvais fonctionnement au maximum.  C\'est d\'ailleurs un système que je vais étudier car il rompt avec les systèmes classiques et pourrait rendre l\'aquaponie plus accessible...</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading">Étape 3 : 2023, un système hydroponique à Saint-Germain-en-laye (78) et un système bioponique à Marseille (13)</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>L\'aquaponie m\'a amené à considérer la bioponie avec un intérêt nouveau : La bioponie, c\'est finalement une début de symbiose entre les bactéries et les plantes. C\'est un peu plus près de ce que fait la nature dans le sol. Et on peut penser que cet élément qui n\'existe pas en hydroponie (les bactéries qui transforment l\'organique en minéral), peut aider le système à être stable dans le temps ! </p>\n<!-- /wp:paragraph -->','Bienvenue','','inherit','closed','closed','','2-revision-v1','','','2023-08-27 11:31:19','2023-08-27 09:31:19','',2,'https://hs.vicq.org/?p=111',0,'revision','',0);
INSERT INTO `hs_posts` VALUES (112,1,'2023-08-27 11:43:55','2023-08-27 09:43:55','<!-- wp:heading -->\n<h2 class="wp-block-heading">Ce blog est consacré à l\'hydroponie et la bioponie domestiques. </h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Ces deux techniques de culture font partie de la famille des cultures hors-sol sur substrat neutre. Elles consistent à faire pousser des plantes sans terre, sur un substrat neutre (billes d\'argile par exemple), en mettant en place un dispositif efficace pour leur fournir les nutriments nécessaire pour assurer une croissance efficace des racines et des plantes. La recirculation du liquide nutritif évite une grande partie de la consommation d\'eau qui est induite dans la culture en sol. Je raconte ici les différentes étapes qui m\'ont amené à expérimenter et perfectionner ces technique.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Origine du projet et cheminement</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>J\'ai commencé à m\'intéresser aux questions de culture urbaines pendant l\'épidémie de COVID. Cet épisode anxiogène m\'a fait m\'interroger sur certaines questions d\'organisation de la société, et aux risques associés à l\'approvisionnement en ville des denrées alimentaires. En effet, il semble qu\'en cas de gros dysfonctionnement de la logistique d\'approvisionnement en nourriture, en quelque jours les villes pourraient se retrouver privées d\'une partie importante de leurs ressources alimentaires. Face à cette potentielle fragilité des flux de transport, il semble intéressant de développer des dispositifs urbains assurant une partie (même réduite) de la production de légumes dans la ville. Des études sur ces sujets existent, mais je ne suis pas un spécialiste de la recherche en agriculture urbaine, j\'essayerai de faire un peu de bibliographie à ce sujet quand j\'aurai le temps.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>De plus, les questions d\'épuisement de la planète sont maintenant au centre des débats, et cultiver des légumes en étant économe en eau et en énergie est un sujet qui m\'intéresse et me semble prometteur pour les temps qui viennent.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Culture hors sol, définitions</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Le web pullule d\'explications sur ces techniques de culture hors sol. Vous pouvez trouver <a href="https://fermedecagnolle.fr/hydroponie-bioponie-aquaponie-definitions/"><strong>ici</strong></a> par exemple des définitions simples de l\'<strong>hydroponie</strong>, <strong>bioponie</strong> et <strong>aquaponie</strong> proposées par Marion Sarlé (<a href="https://lessourciers.com/fr/">les sourciers</a>). Une page très bien conçue par Ecologia présente l\'aquaponie <a rel="noreferrer noopener" href="https://www.aquaponia.com/aquaponie-by-echologia/index.php/monde-aquaponia/qu-est-ce-que-l-aquaponie-definition" target="_blank">ici</a>. Ecologia propose des formation vers Laval. Marion Sarlé propose le livre «&nbsp;<em><strong>Monter sa microferme en hydroponie, bioponie et aquaponie</strong></em>&nbsp;», en vente sur le site <a href="https://lessourciers.com/fr/livre-sourciers/">Les Sourciers</a>&nbsp;. Les sourciers proposent aussi des <a href="https://lessourciers.com/fr/les-formations/">formations</a> en ligne et dans leur ferme du Gers. J\'ai suivi la partie en ligne de la formation <a href="https://lessourciers.com/fr/les-formations/microferme-hydroponique/">Microferme Hydroponique</a> qui m\'a bien aidé à comprendre les rudiments de base.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Une fois ces grandes définitions comprises, on trouve de très facilement des informations sur les <strong><a href="https://jardinfute.com/culture-hors-sol/page/2/">nombreux types de dispositifs</a></strong> utilisés pour ce type de culture (ex : <a href="https://jardinfute.com/methode-kratky/">Kratky</a>, <a href="https://jardinfute.com/systeme-dwc-hydroponie/">DWC</a>, <a href="https://jardinfute.com/systeme-nft-hydroponie/">NFT</a>, <a href="https://jardinfute.com/table-a-maree-ebb-flow/">table à marée</a>, etc.). J\'ai choisi les explications sur le site <a href="https://jardinfute.com/">jardinfute.com</a>, mais vous trouverez facilement d\'autres systèmes et d\'autres explications sur internet.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Si l\'on évalue la complexité de ces techniques, on comprend que l\'<strong>hydroponie</strong> est la plus simple des trois, puisqu\'elle se base sur la circulation d\'une solution nutritive contenant des nutriments minéraux (engrais) directement assimilables par les racines des plantes cultivées. En gros, il suffit de faire circuler de l\'eau additionnée d\'engrais sur les racines des plantes.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Quand on regarde les principes de la <strong>bioponie</strong> et l\'<strong>aquaponie</strong>, on comprend que le principe est plus complexe. Dans les deux cas on va transformer des éléments organiques en éléments minéraux pouvant être assimilés par les plantes (minéralisation). Cela est réalisé en deux étapes par l\'action de deux types de bactéries qui vont assurer tout d\'abord la transformation des éléments organiques en nitrites (bactéries <strong>Nitrosomonas</strong>) puis des nitrites en nitrates (bactéries <strong>Nitrobacter</strong>). Dans les deux cas, il faut offrir à ces bactéries un lieu et des conditions de vie, ce qui représente une complexité supplémentaire. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Enfin, pour l\'<strong>aquaponie</strong> il faut aussi s\'occuper de ses poissons, et en particulier gérer les caractéristiques de l\'eau. Des déséquilibres dans le système peuvent rapidement tuer une partie du cheptel, ce qui est plus impactant que de voir mourir un pied de ciboulette.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Bénéfices des systèmes hors-sol</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Les bénéfices de systèmes industriels ne sont pas analysés ici. Mais voici les bénéfices que produit un système opérationnel :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Très faible consommation d\'eau (environ 90 % d\'économie)</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Très faible consommation d\'électricité (pompe 10 W)</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Fort rendement au m2</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Fierté de produire sa nourriture</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>systèmes en hauteur, hors de portée des nuisibles rampants</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Intérêt pédagogique de la culture des plantes, pour tous (des plus petits aux plus grands)</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Système de circulation d\'eau produisant un bruit très agréable sans gêner les voisins</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Premier objectif : construire un système hydroponique</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Pour avoir les meilleures chances de réussite en limitant la complexité du savoir nécessaire et m\'y mettre rapidement, j\'ai choisi de commencer par l\'hydroponie.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>On peut vouloir créer des fermes hydroponiques de taille plus ou moins importante, mais j\'ai décidé de m\'intéresser à des dispositifs mis en œuvre à l\'échelle individuelle ou de proche voisinage, car cela représente des investissements réduits, une capacité de réalisation rapide et un investissement en temps acceptable. De plus, même si l\'ambition de tels systèmes n\'est pas de produire des bénéfices financiers, elle semble intéressante à l\'échelle de l\'individu ou du voisinage.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Prototypes</h2>\n<!-- /wp:heading -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading"></h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Durant l\'hiver 2021, j\'ai fait des recherches des différents systèmes hydroponiques disponibles et de comment réaliser sois-même ce genre de choses, et j\'ai été rapidement convaincu de l\'idée de commencer petit, afin d\'être prêt et de pouvoir planter dès le printemps 2022. Le retour d\'expérience des personnes expérimentées est unanime : il faut commencer simple et petit. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>De plus, commencer avec un petit système simple n\'a que des avantages pour quelqu\'un comme moi qui aime bricoler : </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Un petit prototype opérationnel est complet, donc on apprendra presque qu\'autant de choses que sur un plus gros système.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Le temps de développement est plus court, on aura ainsi plus de chances d\'aboutir dans des délais imposés par ses propres contraintes quotidiennes et l\'implacable chef d\'orchestre que sont les saisons. Par exemple, en France, il n\'est pas vraiment facile de planter des tomates à l\'automne, il faudra avoir été prêt pour le printemps, ou attendre le printemps suivant. </li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>On réduit le coût de fabrication, le risque financier et le temps passé si l\'on rate sa réalisation ou si on renonce avant la fin.</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:paragraph -->\n<p>J\'ai donc recherché les systèmes hydroponiques disponibles sur le marché ; j\'ai trouvé pas mal de systèmes clés en main, plus ou moins aboutis et plus ou moins chers. Pourtant, j\'ai décidé de construire moi-même mon premier système, pour plusieurs raisons :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Je suis convaincu que "mettre la main à la pâte" est souvent une bonne idée pour comprendre plus profondément ce qui se passe dans un dispositif technique,</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>j\'aime bien réaliser des prototypes en adaptant une solution technique existante à mon besoin personnel, cela m\'aide à imaginer comment envisager une généralisation à d\'autres cas d\'usages.</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading">Étape 1 : 2022, un petit système hydroponique (pour Marseille et la région parisienne)</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>J\'ai donc choisi de réaliser un système hydroponique vertical, pour prendre peu de place au sol. Pratiquant l\'impression impression 3D, j\'ai décidé de partir d\'un système déjà conçu avec cette technique de fabrication, et de l\'adapter un peu. De plus, j\'ai décidé de fabriquer plusieurs systèmes identiques testés entre la Provence et la région parisienne.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Voici à quoi ce système ressemblait dans sa <a href="https://www.thingiverse.com/thing:3405964/" target="_blank" rel="noreferrer noopener">version originale</a> trouvée sur un site d\'impression 3D : </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:columns -->\n<div class="wp-block-columns"><!-- wp:column -->\n<div class="wp-block-column"><!-- wp:image {"width":535,"height":402,"sizeSlug":"large"} -->\n<figure class="wp-block-image size-large is-resized"><img src="https://cdn.thingiverse.com/renders/33/b6/37/85/85/59b0c38e5b805c7dd9b9f5abeee79ca0_preview_featured.jpg" alt="" style="width:535px;height:402px" width="535" height="402"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class="wp-block-column"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>La colonne est creuse est composée de modules empilables, ce qui permet de choisir le nombre de plantes,</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>le réservoir en bas contient une pompe, cette dernière remonte l\'eau via un tuyau au centre de la tour jusqu\'à l\'étage supérieur qui est lui même percé de trous...</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>l\'eau passe par ces trous et redescend par gravité jusqu\'au réservoir, en arrosant au passage les racines des plantes maintenues en position dans des billes d\'argile dans les paniers amovibles (couleur ocre sur la photo) installés dans la tour.</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:paragraph -->\n<p>J\'ai du adapter le système de fixation entre le bas de la tour avec mon réservoirs, ainsi que certaines autres modifications mineures.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Au printemps 2022 J\'ai imprimé et mis en service 4 systèmes modulaires hydroponiques (que l\'on pourrait les qualifier d\'aéro-hydroponiques car le liquide nutritif ruisselle sur les racines, celles ci ne trempent pas dans le liquide). Ces systèmes avaient la forme d\'un cylindre creux dans lequel étaient insérés des paniers contenant des billes d\'argile. En bas de la tour un réservoir de 10 à 20 litres dans lequel une pompe alimentait le haut de la tour par un tuyau, le liquide redescendant dans la tour en imprégnant les racines par gravité. Ce système est modulaire et permet d\'adapter plus ou moins d\'étages de plantation.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Trois ont été déployés dans les bouches du Rhône (2 à Marseille, un à Aix-en-Provence), un à Saint-Germain-en-Laye. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Merci à Aurélie, Martine et Friquette (ma maman) pour les avoir fait fonctionner et testés.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Le détail et les photos sont disponibles sur la page dédiée</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Les résultats étaient intéressants, j\'ai beaucoup appris de ce système. Mais je suis resté sur ma fin, pour les raisons suivantes :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>J\'ai planté des tomates ! Et cela a fonctionné ! Sauf que les tomates produisent des volumes de racines gigantesques, et qu\'elles ont envahi l\'intérieur, ne laissant pas beaucoup de place au basilic et autres tentatives. De plus, je devait couper les racines des tomates très souvent...</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Les tomates consommaient plusieurs litres d\'eau par jour (surtout par évapo-transpiration), ce qui impliquait un remplissage quotidien du bac (2 à 4 litres consommés par jour en plein été dans un bac de 15 puis 30 litres), et donc une assez forte variation de la concentration des nutriments (ce que les plantes n\'aiment pas beaucoup).</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Les fraises ont végété,</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>J\'avais tenté de planter un chou fleur, qui était assez en forme mais n\'a jamais rien produit,</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>La ciboulette n\'a pas tenu, pas plus que le basilic,</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:paragraph -->\n<p>Les deux autres systèmes installés dans la région ont produit des tomates et des poivrons pour l\'un, rien pour l\'autre (par manque de lumière semble-t-il) ; l\'expérimentation en région parisienne, avec un climat moins chaud, a été bien meilleure. Et ma maman, qui s\'en occupait, était certainement plus performante... Beaucoup de tomates, quelques fraises... </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>En résumé, oui, ça a fonctionné, mais à part les tomates, le résultat était décevant. Je pense aussi que j\'aurais dû ne pas placer mon dispositif en plein soleil en juillet et aout à Marseille, car même les tomates ont souffert de la chaleur !! Je pense même que la sud de la France n\'est pas perticulièrement approprié à la culture de tomate en hors sol en juillet/août. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading">Étape 2 : choix du système pour l\'année 2023</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Après ce premier essai, je voulais changer et faire évoluer mon système, et j\'ai continuer de chercher des informations. Début 2022, j\'ai été très motivé par les principes de l\'aquaponie. La nature symbiotique poissons + plantes, la création d\'un écosystème économe et vertueux, la double production poissons + plantes sur une surface réduite m\'ont donné très envie d\'aller voir de plus près ce genre de systèmes. J\'ai, bien sur, beaucoup exploré internet, vu des réalisations magnifiques (par exemple la chaine de <a rel="noreferrer noopener" href="https://www.youtube.com/@ChrisPagns" target="_blank">Chris Pagns</a> sur youtube).</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>J\'ai cherché si il existait des formations près de chez moi. J\'ai finalement opté pour une initiation à l\'aquaponie en mai 2022 chez <a rel="noreferrer noopener" href="https://www.aquaponia.com/aquaponie-by-echologia/" target="_blank">Aquaponia, by Ecologia</a>, tout près de Laval (en Mayenne). J\'ai choisi ce stage pour les compétences reconnues de Guillaume Beucher, et pour le lieu magique. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Je n\'ai pas été déçu ! Après avoir surfé sur internet pendant un an, j\'ai ainsi pu accéder à une idée plus proche de la réalité de ce qui est possible quand on suit les enseignements de pros qui savent. Voici les principales évolutions de ma vision initiale de l\'aquaponie :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Dans le sud de la France, sans mettre en place une infrastructure solide, coûteuse et complexe, il est difficile (et/ou couteux) d\'élever des truites (ce que je souhaitais faire initialement) : la truite meurt dans une eau au delà de 26°. Donc il faut choisir des poissons compatibles avec les températures élevées, comme le poissons rouge (non comestible) ou la carpe. Cela fut un constat un peu amer, mais après avoir vu comment Aquaponia gère ses poissons, après avoir visionné les <a rel="noreferrer noopener" href="https://www.youtube.com/watch?v=x4hBJlt6PMI&amp;t=425s" target="_blank">vidéos de Chris Pagns</a> et lu les <a rel="noreferrer noopener" href="https://www.amazon.fr/Aquaponie-guide-r%C3%A9f%C3%A9rence-Fran%C3%A7ois-Petitet-Gosgnach/dp/2815310252/ref=sr_1_1?__mk_fr_FR=%C3%85M%C3%85%C5%BD%C3%95%C3%91&amp;crid=1XD7AW59VAHUS&amp;keywords=aquaponie+petitet&amp;qid=1692551785&amp;sprefix=aquaponie+petitet%2Caps%2C126&amp;sr=8-1" target="_blank">livres de référence de l\'aquaponie de François Petitet-Gosgnach</a> (Adanat). <br>J\'ai ainsi été convaincu de renoncer (temporairement au moins) à la truite (le rêve de chacun). J\'aurais bien opté pour le Tilapia, mais il est interdit en France pour des risque d\'invasion si il aboutissait dans une rivière. Dommage, il adore l\'eau chaude ! <br></li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>De plus, même si j\'ai la chance d\'avoir un jardin, pour réduire la température de l\'eau le bac à poissons doit être enterré. Comme je suis locataire, j\'ai renoncé à creuser dans le jardin.<br></li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Enfin, l\'aquaponie n\'est pas simple (surtout au début semble-t-il) et représente une charge mentale forte au quotidien : il faut être un minimum compétent :<!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>en chimie (pour l\'eau : cyclage, nitrates, nitrites, PH, KH, EC, Oxygène), </li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>en plomberie (étanchéité, maintenance), </li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>en élevage des poisson (nourrissage, gestion des maladies, etc), </li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>en connaissance des plantes (semis, croissance, maladies). </li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Et cela après avoir réussi à concevoir et réalisr son système , qui demandent des compétences en bricolage (même si on peut aussi acheter un système "clé en main").  </li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:paragraph -->\n<p>Malgré le désir de l\'aquaponie qui n\'a pas faibli, il faut parfois réduire ses ambitions. Après réflexion, j\'ai donc décidé de ne pas me lancer immédiatement dans cette aventure.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Je précise que des installations aquaponiques sont possibles dans le sud. En particulier, un système très simple commercialisé par la société <a rel="noreferrer noopener" href="https://www.taireau.fr/" target="_blank">T\'air E</a><a href="https://www.taireau.fr/">au</a> a été installé avec succès jusque dans le Vaucluse. La simplicité de la conception du système (2 cuves de 500 litres enterrées reliées ensemble via des air-lifts - définition <a rel="noreferrer noopener" href="https://www.aquaportail.com/dictionnaire/definition/6587/pompe-air-lift" target="_blank">ici</a> et <a rel="noreferrer noopener" href="https://www.truitesaquaponiques.com/2018/01/11/construire-des-airlifts-pour-faciliter-lelevage-des-truites-en-aquaponie/" target="_blank">ici</a> - sans pompe à eau) limite les risques de fuites et de mauvais fonctionnement au maximum.  C\'est d\'ailleurs un système que je vais étudier car il rompt un peu avec les systèmes classiques et pourrait rendre l\'aquaponie plus accessible au débutants...</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading">Étape 3 : 2023, un système hydroponique à Saint-Germain-en-laye (78) et un système bioponique à Marseille (13)</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>L\'aquaponie m\'a amené à considérer la bioponie avec un intérêt nouveau : La bioponie, c\'est finalement une début de symbiose entre les bactéries et les plantes. C\'est un peu plus près de ce que fait la nature dans le sol. Et on peut penser que cet élément qui n\'existe pas en hydroponie (les bactéries qui transforment l\'organique en minéral), peut aider le système à être stable dans le temps ! </p>\n<!-- /wp:paragraph -->','Bienvenue','','inherit','closed','closed','','2-revision-v1','','','2023-08-27 11:43:55','2023-08-27 09:43:55','',2,'https://hs.vicq.org/?p=112',0,'revision','',0);
INSERT INTO `hs_posts` VALUES (113,1,'2023-08-27 11:51:20','2023-08-27 09:51:20','<!-- wp:heading -->\n<h2 class="wp-block-heading">Ce blog est consacré à l\'hydroponie et la bioponie domestiques. </h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Ces deux techniques de culture font partie de la famille des cultures hors-sol sur substrat neutre. Elles consistent à faire pousser des plantes sans terre, sur un substrat neutre (billes d\'argile par exemple), en mettant en place un dispositif efficace pour leur fournir les nutriments nécessaire pour assurer une croissance efficace des racines et des plantes. La recirculation du liquide nutritif évite une grande partie de la consommation d\'eau qui est induite dans la culture en sol. Je raconte ici les différentes étapes qui m\'ont amené à expérimenter et perfectionner ces technique.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Origine du projet et cheminement</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>J\'ai commencé à m\'intéresser aux questions de culture urbaines pendant l\'épidémie de COVID. Cet épisode anxiogène m\'a fait m\'interroger sur certaines questions d\'organisation de la société, et aux risques associés à l\'approvisionnement en ville des denrées alimentaires. En effet, il semble qu\'en cas de gros dysfonctionnement de la logistique d\'approvisionnement en nourriture, en quelque jours les villes pourraient se retrouver privées d\'une partie importante de leurs ressources alimentaires. Face à cette potentielle fragilité des flux de transport, il semble intéressant de développer des dispositifs urbains assurant une partie (même réduite) de la production de légumes dans la ville. Des études sur ces sujets existent, mais je ne suis pas un spécialiste de la recherche en agriculture urbaine, j\'essayerai de faire un peu de bibliographie à ce sujet quand j\'aurai le temps.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>De plus, les questions d\'épuisement de la planète sont maintenant au centre des débats, et cultiver des légumes en étant économe en eau et en énergie est un sujet qui m\'intéresse et me semble prometteur pour les temps qui viennent.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Culture hors sol, définitions</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Le web pullule d\'explications sur ces techniques de culture hors sol. Vous pouvez trouver <a href="https://fermedecagnolle.fr/hydroponie-bioponie-aquaponie-definitions/"><strong>ici</strong></a> par exemple des définitions simples de l\'<strong>hydroponie</strong>, <strong>bioponie</strong> et <strong>aquaponie</strong> proposées par Marion Sarlé (<a href="https://lessourciers.com/fr/">les sourciers</a>). Une page très bien conçue par Ecologia présente l\'aquaponie <a rel="noreferrer noopener" href="https://www.aquaponia.com/aquaponie-by-echologia/index.php/monde-aquaponia/qu-est-ce-que-l-aquaponie-definition" target="_blank">ici</a>. Ecologia propose des formation vers Laval. Marion Sarlé propose le livre «&nbsp;<em><strong>Monter sa microferme en hydroponie, bioponie et aquaponie</strong></em>&nbsp;», en vente sur le site <a href="https://lessourciers.com/fr/livre-sourciers/">Les Sourciers</a>&nbsp;. Les sourciers proposent aussi des <a href="https://lessourciers.com/fr/les-formations/">formations</a> en ligne et dans leur ferme du Gers. J\'ai suivi la partie en ligne de la formation <a href="https://lessourciers.com/fr/les-formations/microferme-hydroponique/">Microferme Hydroponique</a> qui m\'a bien aidé à comprendre les rudiments de base.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Une fois ces grandes définitions comprises, on trouve de très facilement des informations sur les <strong><a href="https://jardinfute.com/culture-hors-sol/page/2/">nombreux types de dispositifs</a></strong> utilisés pour ce type de culture (ex : <a href="https://jardinfute.com/methode-kratky/">Kratky</a>, <a href="https://jardinfute.com/systeme-dwc-hydroponie/">DWC</a>, <a href="https://jardinfute.com/systeme-nft-hydroponie/">NFT</a>, <a href="https://jardinfute.com/table-a-maree-ebb-flow/">table à marée</a>, etc.). J\'ai choisi les explications sur le site <a href="https://jardinfute.com/">jardinfute.com</a>, mais vous trouverez facilement d\'autres systèmes et d\'autres explications sur internet.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Si l\'on évalue la complexité de ces techniques, on comprend que l\'<strong>hydroponie</strong> est la plus simple des trois, puisqu\'elle se base sur la circulation d\'une solution nutritive contenant des nutriments minéraux (engrais) directement assimilables par les racines des plantes cultivées. En gros, il suffit de faire circuler de l\'eau additionnée d\'engrais sur les racines des plantes.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Quand on regarde les principes de la <strong>bioponie</strong> et l\'<strong>aquaponie</strong>, on comprend que le principe est plus complexe. Dans les deux cas on va transformer des éléments organiques en éléments minéraux pouvant être assimilés par les plantes (minéralisation). Cela est réalisé en deux étapes par l\'action de deux types de bactéries qui vont assurer tout d\'abord la transformation des éléments organiques en nitrites (bactéries <strong>Nitrosomonas</strong>) puis des nitrites en nitrates (bactéries <strong>Nitrobacter</strong>). Dans les deux cas, il faut offrir à ces bactéries un lieu et des conditions de vie, ce qui représente une complexité supplémentaire. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Enfin, pour l\'<strong>aquaponie</strong> il faut aussi s\'occuper de ses poissons, et en particulier gérer les caractéristiques de l\'eau. Des déséquilibres dans le système peuvent rapidement tuer une partie du cheptel, ce qui est plus impactant que de voir mourir un pied de ciboulette.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Bénéfices des systèmes hors-sol</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Les bénéfices de systèmes industriels ne sont pas analysés ici. Mais voici les bénéfices que produit un système opérationnel :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Très faible consommation d\'eau (environ 90 % d\'économie)</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Très faible consommation d\'électricité (pompe 10 W)</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Fort rendement au m2</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Fierté de produire sa nourriture</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>systèmes en hauteur, hors de portée des nuisibles rampants</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Intérêt pédagogique de la culture des plantes, pour tous (des plus petits aux plus grands)</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Système de circulation d\'eau produisant un bruit très agréable sans gêner les voisins</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Premier objectif : construire un système hydroponique</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Pour avoir les meilleures chances de réussite en limitant la complexité du savoir nécessaire et m\'y mettre rapidement, j\'ai choisi de commencer par l\'hydroponie.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>On peut vouloir créer des fermes hydroponiques de taille plus ou moins importante, mais j\'ai décidé de m\'intéresser à des dispositifs mis en œuvre à l\'échelle individuelle ou de proche voisinage, car cela représente des investissements réduits, une capacité de réalisation rapide et un investissement en temps acceptable. De plus, même si l\'ambition de tels systèmes n\'est pas de produire des bénéfices financiers, elle semble intéressante à l\'échelle de l\'individu ou du voisinage.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Prototypes</h2>\n<!-- /wp:heading -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading"></h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Durant l\'hiver 2021, j\'ai fait des recherches des différents systèmes hydroponiques disponibles et de comment réaliser sois-même ce genre de choses, et j\'ai été rapidement convaincu de l\'idée de commencer petit, afin d\'être prêt et de pouvoir planter dès le printemps 2022. Le retour d\'expérience des personnes expérimentées est unanime : il faut commencer simple et petit. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>De plus, commencer avec un petit système simple n\'a que des avantages pour quelqu\'un comme moi qui aime bricoler : </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Un petit prototype opérationnel est complet, donc on apprendra presque qu\'autant de choses que sur un plus gros système.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Le temps de développement est plus court, on aura ainsi plus de chances d\'aboutir dans des délais imposés par ses propres contraintes quotidiennes et l\'implacable chef d\'orchestre que sont les saisons. Par exemple, en France, il n\'est pas vraiment facile 