<?php
/**
 * Agriculture Farm: Block Patterns
 *
 * @package  Agriculture Farm
 * @since   1.0.0
 */

/**
 * Register Block Pattern Category.
 */
if ( function_exists( 'register_block_pattern_category' ) ) {

	register_block_pattern_category(
		'agriculture-farm',
		array( 'label' => __( ' Agriculture Farm', 'agriculture-farm' ) )
	);
}

/**
 * Register Block Patterns.
 */
if ( function_exists( 'register_block_pattern' ) ) {
	register_block_pattern(
		'agriculture-farm/banner-section',
		array(
			'title'      => __( 'Banner Section', 'agriculture-farm' ),
			'categories' => array( 'agriculture-farm' ),
			'content'    => "<!-- wp:cover {\"url\":\"" . esc_url(get_template_directory_uri()) . "/theme-block-pattern/images/banner.png\",\"id\":258,\"dimRatio\":50,\"isDark\":false,\"align\":\"full\",\"className\":\"banner-section px-md-5\"} -->\n<div class=\"wp-block-cover alignfull is-light banner-section px-md-5\"><span aria-hidden=\"true\" class=\"wp-block-cover__background has-background-dim\"></span><img class=\"wp-block-cover__image-background wp-image-258\" alt=\"\" src=\"" . esc_url(get_template_directory_uri()) . "/theme-block-pattern/images/banner.png\" data-object-fit=\"cover\"/><div class=\"wp-block-cover__inner-container\"><!-- wp:columns {\"className\":\"mb-0 mx-lg-5\"} -->\n<div class=\"wp-block-columns mb-0 mx-lg-5\"><!-- wp:column {\"width\":\"50%\",\"className\":\"banner-section-content\"} -->\n<div class=\"wp-block-column banner-section-content\" style=\"flex-basis:50%\"><!-- wp:paragraph {\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|white\"}}},\"typography\":{\"fontSize\":\"15px\",\"textTransform\":\"uppercase\"}},\"textColor\":\"white\",\"className\":\"mb-0\"} -->\n<p class=\"mb-0 has-white-color has-text-color has-link-color\" style=\"font-size:15px;text-transform:uppercase\">farming with new nature</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":1,\"style\":{\"typography\":{\"fontSize\":\"50px\",\"fontStyle\":\"normal\",\"fontWeight\":\"600\"}},\"textColor\":\"white\"} -->\n<h1 class=\"wp-block-heading has-white-color has-text-color\" style=\"font-size:50px;font-style:normal;font-weight:600\">BRINGING GROWTH TO AGRICULTURE FARM</h1>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":\"17px\"}},\"textColor\":\"white\"} -->\n<p class=\"has-white-color has-text-color\" style=\"font-size:17px\">Promoting them continuous improvement of human and technological resources generating competitive.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"style\":{\"color\":{\"background\":\"#50d430\"},\"border\":{\"radius\":\"8px\"},\"typography\":{\"fontSize\":\"16px\",\"textTransform\":\"capitalize\",\"fontStyle\":\"normal\",\"fontWeight\":\"700\"}},\"className\":\"banner-section-btn\"} -->\n<div class=\"wp-block-button has-custom-font-size banner-section-btn\" style=\"font-size:16px;font-style:normal;font-weight:700;text-transform:capitalize\"><a class=\"wp-block-button__link has-background wp-element-button\" style=\"border-radius:8px;background-color:#50d430\">discover</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"50%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:50%\"></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div></div>\n<!-- /wp:cover -->",
		)
	);

	register_block_pattern(
		'agriculture-farm/service-section',
		array(
			'title'      => __( 'service-section', 'agriculture-farm' ),
			'categories' => array( 'agriculture-farm' ),
			'content'    => "<!-- wp:cover {\"overlayColor\":\"white\",\"isDark\":false,\"align\":\"full\",\"className\":\"service-section\"} -->\n<div class=\"wp-block-cover alignfull is-light service-section\"><span aria-hidden=\"true\" class=\"wp-block-cover__background has-white-background-color has-background-dim-100 has-background-dim\"></span><div class=\"wp-block-cover__inner-container\"><!-- wp:group {\"className\":\"service-section-content\"} -->\n<div class=\"wp-block-group service-section-content\"><!-- wp:heading {\"textAlign\":\"center\",\"style\":{\"typography\":{\"fontSize\":\"35px\",\"fontStyle\":\"normal\",\"fontWeight\":\"400\"}}} -->\n<h2 class=\"has-text-align-center\" style=\"font-size:35px;font-style:normal;font-weight:400\">OUR SERVICES</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\"} -->\n<p class=\"has-text-align-center\">Lorem Ipsum is simply dummy text of the printing and typesetting industry</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:columns {\"className\":\"service-boxes\"} -->\n<div class=\"wp-block-columns service-boxes\"><!-- wp:column {\"className\":\"service-box position-relative\"} -->\n<div class=\"wp-block-column service-box position-relative\"><!-- wp:image {\"align\":\"center\",\"id\":263,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"service-img align-items-center\"} -->\n<figure class=\"wp-block-image aligncenter size-full service-img align-items-center\"><img src=\"" . esc_url(get_template_directory_uri()) . "/theme-block-pattern/images/service-icon1.png\" alt=\"\" class=\"wp-image-263\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:heading {\"textAlign\":\"center\",\"level\":3,\"style\":{\"typography\":{\"fontSize\":\"28px\",\"fontStyle\":\"normal\",\"fontWeight\":\"400\"}},\"className\":\"position-relative\"} -->\n<h3 class=\"has-text-align-center position-relative\" style=\"font-size:28px;font-style:normal;font-weight:400\">Fresh Vegetable</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"style\":{\"color\":{\"text\":\"#6e6e6e\"}},\"className\":\"service-box-para pt-4\"} -->\n<p class=\"has-text-align-center service-box-para pt-4 has-text-color\" style=\"color:#6e6e6e\">Lorem Ipsum&nbsp;is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys standard dummy text&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"backgroundColor\":\"white\",\"textColor\":\"black\",\"style\":{\"border\":{\"radius\":\"0px\"},\"typography\":{\"fontSize\":\"17px\"}},\"className\":\"service-box-btn\"} -->\n<div class=\"wp-block-button has-custom-font-size service-box-btn\" style=\"font-size:17px\"><a class=\"wp-block-button__link has-black-color has-white-background-color has-text-color has-background\" style=\"border-radius:0px\">Read More</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"className\":\"service-box position-relative\"} -->\n<div class=\"wp-block-column service-box position-relative\"><!-- wp:image {\"align\":\"center\",\"id\":264,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image aligncenter size-full\"><img src=\"" . esc_url(get_template_directory_uri()) . "/theme-block-pattern/images/service-icon2.png\" alt=\"\" class=\"wp-image-264\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:heading {\"textAlign\":\"center\",\"level\":3,\"style\":{\"typography\":{\"fontSize\":\"28px\",\"fontStyle\":\"normal\",\"fontWeight\":\"400\"}},\"className\":\"position-relative\"} -->\n<h3 class=\"has-text-align-center position-relative\" style=\"font-size:28px;font-style:normal;font-weight:400\">Dairy Products</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"style\":{\"color\":{\"text\":\"#6e6e6e\"}},\"className\":\"service-box-para pt-4\"} -->\n<p class=\"has-text-align-center service-box-para pt-4 has-text-color\" style=\"color:#6e6e6e\">Lorem Ipsum&nbsp;is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys standard dummy text&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"backgroundColor\":\"white\",\"textColor\":\"black\",\"style\":{\"typography\":{\"fontSize\":\"17px\"}},\"className\":\"service-box-btn\"} -->\n<div class=\"wp-block-button has-custom-font-size service-box-btn\" style=\"font-size:17px\"><a class=\"wp-block-button__link has-black-color has-white-background-color has-text-color has-background\">Read More</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"className\":\"service-box position-relative\"} -->\n<div class=\"wp-block-column service-box position-relative\"><!-- wp:image {\"align\":\"center\",\"id\":265,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image aligncenter size-full\"><img src=\"" . esc_url(get_template_directory_uri()) . "/theme-block-pattern/images/service-icon3.png\" alt=\"\" class=\"wp-image-265\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:heading {\"textAlign\":\"center\",\"level\":3,\"style\":{\"typography\":{\"fontSize\":\"28px\",\"fontStyle\":\"normal\",\"fontWeight\":\"400\"}},\"className\":\"position-relative\"} -->\n<h3 class=\"has-text-align-center position-relative\" style=\"font-size:28px;font-style:normal;font-weight:400\">Fresh Products</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"style\":{\"color\":{\"text\":\"#6e6e6e\"}},\"className\":\"service-box-para pt-4\"} -->\n<p class=\"has-text-align-center service-box-para pt-4 has-text-color\" style=\"color:#6e6e6e\">Lorem Ipsum&nbsp;is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys standard dummy text</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"backgroundColor\":\"white\",\"textColor\":\"black\",\"style\":{\"typography\":{\"fontSize\":\"17px\"}},\"className\":\"service-box-btn\"} -->\n<div class=\"wp-block-button has-custom-font-size service-box-btn\" style=\"font-size:17px\"><a class=\"wp-block-button__link has-black-color has-white-background-color has-text-color has-background\">Read More</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:group --></div></div>\n<!-- /wp:cover -->",
		)
	);
}