/* # site_url: http://miam.vicq.org */;
/* # home_url: http://miam.vicq.org */;
/* # content_url: http://miam.vicq.org/wp-content */;
/* # upload_url: http://miam.vicq.org/wp-content/uploads */;
/* # table_prefix: miam_ */;


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `miam_term_relationships`
--

DROP TABLE IF EXISTS `miam_term_relationships`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `miam_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `miam_term_relationships`
--

LOCK TABLES `miam_term_relationships` WRITE;
/*!40000 ALTER TABLE `miam_term_relationships` DISABLE KEYS */;
INSERT INTO `miam_term_relationships` VALUES (1,1,0);
INSERT INTO `miam_term_relationships` VALUES (15,31,0);
INSERT INTO `miam_term_relationships` VALUES (15,33,0);
INSERT INTO `miam_term_relationships` VALUES (15,34,0);
INSERT INTO `miam_term_relationships` VALUES (36,28,0);
INSERT INTO `miam_term_relationships` VALUES (36,29,0);
INSERT INTO `miam_term_relationships` VALUES (36,30,0);
INSERT INTO `miam_term_relationships` VALUES (75,36,0);
INSERT INTO `miam_term_relationships` VALUES (76,36,0);
INSERT INTO `miam_term_relationships` VALUES (77,36,0);
INSERT INTO `miam_term_relationships` VALUES (78,36,0);
INSERT INTO `miam_term_relationships` VALUES (79,36,0);
INSERT INTO `miam_term_relationships` VALUES (87,32,0);
INSERT INTO `miam_term_relationships` VALUES (87,37,0);
INSERT INTO `miam_term_relationships` VALUES (93,33,0);
INSERT INTO `miam_term_relationships` VALUES (93,38,0);
/*!40000 ALTER TABLE `miam_term_relationships` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `miam_links`
--

DROP TABLE IF EXISTS `miam_links`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `miam_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `miam_links`
--

LOCK TABLES `miam_links` WRITE;
/*!40000 ALTER TABLE `miam_links` DISABLE KEYS */;
/*!40000 ALTER TABLE `miam_links` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `miam_commentmeta`
--

DROP TABLE IF EXISTS `miam_commentmeta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `miam_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `miam_commentmeta`
--

LOCK TABLES `miam_commentmeta` WRITE;
/*!40000 ALTER TABLE `miam_commentmeta` DISABLE KEYS */;
INSERT INTO `miam_commentmeta` VALUES (1,2,'rating','5');
INSERT INTO `miam_commentmeta` VALUES (2,3,'rating','5');
/*!40000 ALTER TABLE `miam_commentmeta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `miam_term_taxonomy`
--

DROP TABLE IF EXISTS `miam_term_taxonomy`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `miam_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=39 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `miam_term_taxonomy`
--

LOCK TABLES `miam_term_taxonomy` WRITE;
/*!40000 ALTER TABLE `miam_term_taxonomy` DISABLE KEYS */;
INSERT INTO `miam_term_taxonomy` VALUES (1,1,'category','',0,1);
INSERT INTO `miam_term_taxonomy` VALUES (2,2,'recipe-key','',0,0);
INSERT INTO `miam_term_taxonomy` VALUES (3,3,'recipe-key','',0,0);
INSERT INTO `miam_term_taxonomy` VALUES (4,4,'recipe-key','',0,0);
INSERT INTO `miam_term_taxonomy` VALUES (5,5,'recipe-key','',0,0);
INSERT INTO `miam_term_taxonomy` VALUES (6,6,'recipe-key','',0,0);
INSERT INTO `miam_term_taxonomy` VALUES (7,7,'recipe-key','',0,0);
INSERT INTO `miam_term_taxonomy` VALUES (8,8,'recipe-key','',0,0);
INSERT INTO `miam_term_taxonomy` VALUES (9,9,'recipe-key','',0,0);
INSERT INTO `miam_term_taxonomy` VALUES (10,10,'recipe-key','',0,0);
INSERT INTO `miam_term_taxonomy` VALUES (11,11,'recipe-key','',0,0);
INSERT INTO `miam_term_taxonomy` VALUES (12,12,'recipe-key','',0,0);
INSERT INTO `miam_term_taxonomy` VALUES (13,13,'recipe-key','',0,0);
INSERT INTO `miam_term_taxonomy` VALUES (14,14,'recipe-key','',0,0);
INSERT INTO `miam_term_taxonomy` VALUES (15,15,'recipe-key','',0,0);
INSERT INTO `miam_term_taxonomy` VALUES (16,16,'recipe-key','',0,0);
INSERT INTO `miam_term_taxonomy` VALUES (17,17,'recipe-key','',0,0);
INSERT INTO `miam_term_taxonomy` VALUES (18,18,'recipe-key','',0,0);
INSERT INTO `miam_term_taxonomy` VALUES (19,19,'recipe-key','',0,0);
INSERT INTO `miam_term_taxonomy` VALUES (20,20,'recipe-key','',0,0);
INSERT INTO `miam_term_taxonomy` VALUES (21,21,'recipe-key','',0,0);
INSERT INTO `miam_term_taxonomy` VALUES (22,22,'recipe-key','',0,0);
INSERT INTO `miam_term_taxonomy` VALUES (23,23,'recipe-key','',0,0);
INSERT INTO `miam_term_taxonomy` VALUES (24,24,'recipe-key','',0,0);
INSERT INTO `miam_term_taxonomy` VALUES (25,25,'recipe-key','',0,0);
INSERT INTO `miam_term_taxonomy` VALUES (26,26,'recipe-key','',0,0);
INSERT INTO `miam_term_taxonomy` VALUES (27,27,'recipe-key','',0,0);
INSERT INTO `miam_term_taxonomy` VALUES (28,28,'recipe-cuisine','',0,1);
INSERT INTO `miam_term_taxonomy` VALUES (29,29,'recipe-cooking-method','',0,1);
INSERT INTO `miam_term_taxonomy` VALUES (30,30,'recipe-course','',0,1);
INSERT INTO `miam_term_taxonomy` VALUES (31,31,'recipe-course','',0,1);
INSERT INTO `miam_term_taxonomy` VALUES (32,32,'recipe-course','',0,1);
INSERT INTO `miam_term_taxonomy` VALUES (33,33,'recipe-cuisine','',0,2);
INSERT INTO `miam_term_taxonomy` VALUES (34,34,'recipe-cooking-method','',0,1);
INSERT INTO `miam_term_taxonomy` VALUES (36,36,'nav_menu','',0,5);
INSERT INTO `miam_term_taxonomy` VALUES (37,37,'recipe-cooking-method','',0,1);
INSERT INTO `miam_term_taxonomy` VALUES (38,38,'recipe-course','',0,1);
/*!40000 ALTER TABLE `miam_term_taxonomy` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `miam_termmeta`
--

DROP TABLE IF EXISTS `miam_termmeta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `miam_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `miam_termmeta`
--

LOCK TABLES `miam_termmeta` WRITE;
/*!40000 ALTER TABLE `miam_termmeta` DISABLE KEYS */;
INSERT INTO `miam_termmeta` VALUES (1,2,'dr_taxonomy_metas','a:1:{s:12:"taxonomy_svg";s:16:"vegetarian-meals";}');
INSERT INTO `miam_termmeta` VALUES (2,3,'dr_taxonomy_metas','a:1:{s:12:"taxonomy_svg";s:11:"gluten-free";}');
INSERT INTO `miam_termmeta` VALUES (3,4,'dr_taxonomy_metas','a:1:{s:12:"taxonomy_svg";s:5:"paleo";}');
INSERT INTO `miam_termmeta` VALUES (4,5,'dr_taxonomy_metas','a:1:{s:12:"taxonomy_svg";s:13:"freezer-meals";}');
INSERT INTO `miam_termmeta` VALUES (5,6,'dr_taxonomy_metas','a:1:{s:12:"taxonomy_svg";s:8:"low-carb";}');
INSERT INTO `miam_termmeta` VALUES (6,7,'dr_taxonomy_metas','a:1:{s:12:"taxonomy_svg";s:11:"slow-cooker";}');
INSERT INTO `miam_termmeta` VALUES (7,8,'dr_taxonomy_metas','a:1:{s:12:"taxonomy_svg";s:5:"dairy";}');
INSERT INTO `miam_termmeta` VALUES (8,9,'dr_taxonomy_metas','a:1:{s:12:"taxonomy_svg";s:4:"kids";}');
INSERT INTO `miam_termmeta` VALUES (9,10,'dr_taxonomy_metas','a:1:{s:12:"taxonomy_svg";s:6:"mixing";}');
INSERT INTO `miam_termmeta` VALUES (10,11,'dr_taxonomy_metas','a:1:{s:12:"taxonomy_svg";s:14:"non-vegetarian";}');
INSERT INTO `miam_termmeta` VALUES (11,12,'dr_taxonomy_metas','a:1:{s:12:"taxonomy_svg";s:4:"cold";}');
INSERT INTO `miam_termmeta` VALUES (12,13,'dr_taxonomy_metas','a:1:{s:12:"taxonomy_svg";s:5:"spicy";}');
INSERT INTO `miam_termmeta` VALUES (13,14,'dr_taxonomy_metas','a:1:{s:12:"taxonomy_svg";s:3:"raw";}');
INSERT INTO `miam_termmeta` VALUES (14,15,'dr_taxonomy_metas','a:1:{s:12:"taxonomy_svg";s:10:"dairy-free";}');
INSERT INTO `miam_termmeta` VALUES (15,16,'dr_taxonomy_metas','a:1:{s:12:"taxonomy_svg";s:8:"nut-free";}');
INSERT INTO `miam_termmeta` VALUES (16,17,'dr_taxonomy_metas','a:1:{s:12:"taxonomy_svg";s:11:"pescetarian";}');
INSERT INTO `miam_termmeta` VALUES (17,18,'dr_taxonomy_metas','a:1:{s:12:"taxonomy_svg";s:11:"quick-meals";}');
INSERT INTO `miam_termmeta` VALUES (18,19,'dr_taxonomy_metas','a:1:{s:12:"taxonomy_svg";s:8:"whole-30";}');
INSERT INTO `miam_termmeta` VALUES (19,20,'dr_taxonomy_metas','a:1:{s:12:"taxonomy_svg";s:5:"vegan";}');
INSERT INTO `miam_termmeta` VALUES (20,21,'dr_taxonomy_metas','a:1:{s:12:"taxonomy_svg";s:4:"keto";}');
INSERT INTO `miam_termmeta` VALUES (21,22,'dr_taxonomy_metas','a:1:{s:12:"taxonomy_svg";s:12:"high-protein";}');
INSERT INTO `miam_termmeta` VALUES (22,23,'dr_taxonomy_metas','a:1:{s:12:"taxonomy_svg";s:7:"organic";}');
INSERT INTO `miam_termmeta` VALUES (23,24,'dr_taxonomy_metas','a:1:{s:12:"taxonomy_svg";s:9:"corn-free";}');
INSERT INTO `miam_termmeta` VALUES (24,25,'dr_taxonomy_metas','a:1:{s:12:"taxonomy_svg";s:8:"soy-free";}');
INSERT INTO `miam_termmeta` VALUES (25,26,'dr_taxonomy_metas','a:1:{s:12:"taxonomy_svg";s:10:"sugar-free";}');
INSERT INTO `miam_termmeta` VALUES (26,27,'dr_taxonomy_metas','a:1:{s:12:"taxonomy_svg";s:8:"egg-free";}');
INSERT INTO `miam_termmeta` VALUES (27,30,'dr_taxonomy_metas','a:3:{s:14:"taxonomy_color";s:7:"#81d742";s:14:"taxonomy_image";i:0;s:12:"taxonomy_svg";s:0:"";}');
INSERT INTO `miam_termmeta` VALUES (28,31,'dr_taxonomy_metas','a:3:{s:14:"taxonomy_color";s:7:"#ce871c";s:14:"taxonomy_image";i:0;s:12:"taxonomy_svg";s:0:"";}');
INSERT INTO `miam_termmeta` VALUES (29,32,'dr_taxonomy_metas','a:3:{s:14:"taxonomy_color";s:7:"#8224e3";s:14:"taxonomy_image";i:0;s:12:"taxonomy_svg";s:0:"";}');
/*!40000 ALTER TABLE `miam_termmeta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `miam_terms`
--

DROP TABLE IF EXISTS `miam_terms`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `miam_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=39 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `miam_terms`
--

LOCK TABLES `miam_terms` WRITE;
/*!40000 ALTER TABLE `miam_terms` DISABLE KEYS */;
INSERT INTO `miam_terms` VALUES (1,'Non classé','non-classe',0);
INSERT INTO `miam_terms` VALUES (2,'Repas végétariens','vegetarian-meals',0);
INSERT INTO `miam_terms` VALUES (3,'Sans Gluten','gluten-free',0);
INSERT INTO `miam_terms` VALUES (4,'Paléo','paleo',0);
INSERT INTO `miam_terms` VALUES (5,'Repas à surgeler','freezer-meals',0);
INSERT INTO `miam_terms` VALUES (6,'Faible teneur en glucides','low-carb',0);
INSERT INTO `miam_terms` VALUES (7,'Recettes à la mijoteuse','slow-cooker',0);
INSERT INTO `miam_terms` VALUES (8,'Produits laitiers','dairy',0);
INSERT INTO `miam_terms` VALUES (9,'Enfants','kids',0);
INSERT INTO `miam_terms` VALUES (10,'Mélange','mixing',0);
INSERT INTO `miam_terms` VALUES (11,'Non végétarien','non-vegetarian',0);
INSERT INTO `miam_terms` VALUES (12,'Froid','cold',0);
INSERT INTO `miam_terms` VALUES (13,'Épicé','spicy',0);
INSERT INTO `miam_terms` VALUES (14,'Cru','raw',0);
INSERT INTO `miam_terms` VALUES (15,'Sans produits laitiers','dairy-free',0);
INSERT INTO `miam_terms` VALUES (16,'Sans noix','nut-free',0);
INSERT INTO `miam_terms` VALUES (17,'Pesco-végétarien','pescetarian',0);
INSERT INTO `miam_terms` VALUES (18,'Repas rapides','quick-meals',0);
INSERT INTO `miam_terms` VALUES (19,'Whole30','whole-30',0);
INSERT INTO `miam_terms` VALUES (20,'Végan','vegan',0);
INSERT INTO `miam_terms` VALUES (21,'Cétogène','keto',0);
INSERT INTO `miam_terms` VALUES (22,'Haute teneur en protéines','high-protein',0);
INSERT INTO `miam_terms` VALUES (23,'Biologique','organic',0);
INSERT INTO `miam_terms` VALUES (24,'Sans maïs','corn-free',0);
INSERT INTO `miam_terms` VALUES (25,'Sans soja','soy-free',0);
INSERT INTO `miam_terms` VALUES (26,'Sans sucre','sugar-free',0);
INSERT INTO `miam_terms` VALUES (27,'Sans œufs','egg-free',0);
INSERT INTO `miam_terms` VALUES (28,'Américaine','americaine',0);
INSERT INTO `miam_terms` VALUES (29,'Poêle','poele',0);
INSERT INTO `miam_terms` VALUES (30,'Petit déjeuner','petit-dejeuner',0);
INSERT INTO `miam_terms` VALUES (31,'Repas','repas',0);
INSERT INTO `miam_terms` VALUES (32,'Dessert','dessert',0);
INSERT INTO `miam_terms` VALUES (33,'Asiatique','asiatique',0);
INSERT INTO `miam_terms` VALUES (34,'Barbecue','barbecue',0);
INSERT INTO `miam_terms` VALUES (36,'Menu_principal','menu_principal',0);
INSERT INTO `miam_terms` VALUES (37,'Four','four',0);
INSERT INTO `miam_terms` VALUES (38,'Entrée','entree',0);
/*!40000 ALTER TABLE `miam_terms` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `miam_usermeta`
--

DROP TABLE IF EXISTS `miam_usermeta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `miam_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=44 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `miam_usermeta`
--

LOCK TABLES `miam_usermeta` WRITE;
/*!40000 ALTER TABLE `miam_usermeta` DISABLE KEYS */;
INSERT INTO `miam_usermeta` VALUES (1,1,'nickname','Axl');
INSERT INTO `miam_usermeta` VALUES (2,1,'first_name','');
INSERT INTO `miam_usermeta` VALUES (3,1,'last_name','');
INSERT INTO `miam_usermeta` VALUES (4,1,'description','');
INSERT INTO `miam_usermeta` VALUES (5,1,'rich_editing','true');
INSERT INTO `miam_usermeta` VALUES (6,1,'syntax_highlighting','true');
INSERT INTO `miam_usermeta` VALUES (7,1,'comment_shortcuts','false');
INSERT INTO `miam_usermeta` VALUES (8,1,'admin_color','fresh');
INSERT INTO `miam_usermeta` VALUES (9,1,'use_ssl','0');
INSERT INTO `miam_usermeta` VALUES (10,1,'show_admin_bar_front','true');
INSERT INTO `miam_usermeta` VALUES (11,1,'locale','');
INSERT INTO `miam_usermeta` VALUES (12,1,'miam_capabilities','a:1:{s:13:"administrator";b:1;}');
INSERT INTO `miam_usermeta` VALUES (13,1,'miam_user_level','10');
INSERT INTO `miam_usermeta` VALUES (14,1,'dismissed_wp_pointers','');
INSERT INTO `miam_usermeta` VALUES (15,1,'show_welcome_panel','1');
INSERT INTO `miam_usermeta` VALUES (16,1,'session_tokens','a:2:{s:64:"0d7e5153cb3e921eead768a23ea6ae0515f3b3549aeb1b317905bdffd10a5b18";a:4:{s:10:"expiration";i:1704469734;s:2:"ip";s:37:"2a01:e0a:4ac:1cd0:c5ed:5f1b:dead:6f01";s:2:"ua";s:84:"Mozilla/5.0 (Macintosh; Intel Mac OS X 10.15; rv:121.0) Gecko/20100101 Firefox/121.0";s:5:"login";i:1703260134;}s:64:"51280029a9b14f9dee44eccbc5a279cf946c46af84a358ef33ba97e04774cefd";a:4:{s:10:"expiration";i:1703968066;s:2:"ip";s:38:"2a02:2788:1064:291:587b:f827:f66f:8560";s:2:"ua";s:84:"Mozilla/5.0 (Macintosh; Intel Mac OS X 10.15; rv:120.0) Gecko/20100101 Firefox/120.0";s:5:"login";i:1703795266;}}');
INSERT INTO `miam_usermeta` VALUES (17,1,'miam_dashboard_quick_press_last_post_id','95');
INSERT INTO `miam_usermeta` VALUES (18,1,'community-events-location','a:1:{s:2:"ip";s:20:"2a02:2788:1064:291::";}');
INSERT INTO `miam_usermeta` VALUES (19,1,'miam_persisted_preferences','a:2:{s:14:"core/edit-post";a:3:{s:26:"isComplementaryAreaVisible";b:1;s:12:"welcomeGuide";b:0;s:10:"openPanels";a:10:{i:0;s:11:"post-status";i:1;s:28:"taxonomy-panel-recipe-course";i:2;s:29:"taxonomy-panel-recipe-cuisine";i:3;s:27:"taxonomy-panel-recipe-badge";i:4;s:25:"taxonomy-panel-recipe-key";i:5;s:12:"post-excerpt";i:6;s:36:"taxonomy-panel-recipe-cooking-method";i:7;s:16:"discussion-panel";i:8;s:25:"taxonomy-panel-recipe-tag";i:9;s:14:"featured-image";}}s:9:"_modified";s:24:"2023-12-28T21:18:57.460Z";}');
INSERT INTO `miam_usermeta` VALUES (20,1,'managenav-menuscolumnshidden','a:5:{i:0;s:11:"link-target";i:1;s:11:"css-classes";i:2;s:3:"xfn";i:3;s:11:"description";i:4;s:15:"title-attribute";}');
INSERT INTO `miam_usermeta` VALUES (21,1,'metaboxhidden_nav-menus','a:8:{i:0;s:20:"add-post-type-recipe";i:1;s:12:"add-post_tag";i:2;s:17:"add-recipe-course";i:3;s:18:"add-recipe-cuisine";i:4;s:25:"add-recipe-cooking-method";i:5;s:14:"add-recipe-tag";i:6;s:14:"add-recipe-key";i:7;s:16:"add-recipe-badge";}');
INSERT INTO `miam_usermeta` VALUES (23,1,'miam_user-settings','libraryContent=browse&editor=tinymce');
INSERT INTO `miam_usermeta` VALUES (24,1,'miam_user-settings-time','1691482748');
INSERT INTO `miam_usermeta` VALUES (25,2,'nickname','julia');
INSERT INTO `miam_usermeta` VALUES (26,2,'first_name','Julia');
INSERT INTO `miam_usermeta` VALUES (27,2,'last_name','');
INSERT INTO `miam_usermeta` VALUES (28,2,'description','');
INSERT INTO `miam_usermeta` VALUES (29,2,'rich_editing','true');
INSERT INTO `miam_usermeta` VALUES (30,2,'syntax_highlighting','true');
INSERT INTO `miam_usermeta` VALUES (31,2,'comment_shortcuts','false');
INSERT INTO `miam_usermeta` VALUES (32,2,'admin_color','fresh');
INSERT INTO `miam_usermeta` VALUES (33,2,'use_ssl','0');
INSERT INTO `miam_usermeta` VALUES (34,2,'show_admin_bar_front','true');
INSERT INTO `miam_usermeta` VALUES (35,2,'locale','fr_FR');
INSERT INTO `miam_usermeta` VALUES (36,2,'miam_capabilities','a:1:{s:13:"administrator";b:1;}');
INSERT INTO `miam_usermeta` VALUES (37,2,'miam_user_level','10');
INSERT INTO `miam_usermeta` VALUES (38,2,'dismissed_wp_pointers','');
INSERT INTO `miam_usermeta` VALUES (39,2,'session_tokens','a:1:{s:64:"7ca7e20494df7095baf867cb4873acc144a99b13b15ed0d370b0380716777b29";a:4:{s:10:"expiration";i:1696670038;s:2:"ip";s:36:"2a01:e0a:4ac:1cd0:c00c:7774:8d1:7273";s:2:"ua";s:143:"Mozilla/5.0 (iPhone; CPU iPhone OS 15_6 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) CriOS/108.0.5359.112 Mobile/15E148 Safari/604.1";s:5:"login";i:1695460438;}}');
INSERT INTO `miam_usermeta` VALUES (40,2,'miam_dashboard_quick_press_last_post_id','86');
INSERT INTO `miam_usermeta` VALUES (41,2,'community-events-location','a:1:{s:2:"ip";s:19:"2a01:e0a:4ac:1cd0::";}');
INSERT INTO `miam_usermeta` VALUES (42,1,'nav_menu_recently_edited','36');
INSERT INTO `miam_usermeta` VALUES (43,2,'miam_persisted_preferences','a:2:{s:14:"core/edit-post";a:1:{s:12:"welcomeGuide";b:0;}s:9:"_modified";s:24:"2023-09-03T12:14:14.919Z";}');
/*!40000 ALTER TABLE `miam_usermeta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `miam_users`
--

DROP TABLE IF EXISTS `miam_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `miam_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `miam_users`
--

LOCK TABLES `miam_users` WRITE;
/*!40000 ALTER TABLE `miam_users` DISABLE KEYS */;
INSERT INTO `miam_users` VALUES (1,'miam_admin','$P$BR8/YMDqARQjN1/KT7mIAhXufBtbzP1','miam_admin','alex@vicq.org','http://miam.vicq.org','2023-08-06 11:40:13','',0,'Axl');
INSERT INTO `miam_users` VALUES (2,'julia','$P$BRtebVwkQ//VY.2UXd3CE71c0fghds/','julia','julia.vicq@gmail.com','','2023-08-07 14:17:08','',0,'Julia');
/*!40000 ALTER TABLE `miam_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `miam_comments`
--

DROP TABLE IF EXISTS `miam_comments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `miam_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `miam_comments`
--

LOCK TABLES `miam_comments` WRITE;
/*!40000 ALTER TABLE `miam_comments` DISABLE KEYS */;
INSERT INTO `miam_comments` VALUES (1,1,'Un commentateur ou commentatrice WordPress','wapuu@wordpress.example','https://fr.wordpress.org/','','2023-08-06 13:40:13','2023-08-06 11:40:13','Bonjour, ceci est un commentaire.\nPour débuter avec la modération, la modification et la suppression de commentaires, veuillez visiter l’écran des Commentaires dans le Tableau de bord.\nLes avatars des personnes qui commentent arrivent depuis <a href="https://fr.gravatar.com/">Gravatar</a>.',0,'1','','comment',0,0);
INSERT INTO `miam_comments` VALUES (2,36,'Axl','alex@vicq.org','http://miam.vicq.org','194.146.15.131','2023-08-08 16:41:15','2023-08-08 14:41:15','trop bons',0,'1','Mozilla/5.0 (Macintosh; Intel Mac OS X 10.15; rv:109.0) Gecko/20100101 Firefox/116.0','comment',0,1);
INSERT INTO `miam_comments` VALUES (3,36,'Pete','a82kin203@hotmail.com','','2a09:bac2:330c:1eb::31:a3','2024-04-06 20:51:34','2024-04-06 18:51:34','Excellent et immanquables!',0,'0','Mozilla/5.0 (iPhone; CPU iPhone OS 17_4_1 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/17.4.1 Mobile/15E148 Safari/604.1','comment',0,0);
/*!40000 ALTER TABLE `miam_comments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `miam_posts`
--

DROP TABLE IF EXISTS `miam_posts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `miam_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=102 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `miam_posts`
--

LOCK TABLES `miam_posts` WRITE;
/*!40000 ALTER TABLE `miam_posts` DISABLE KEYS */;
INSERT INTO `miam_posts` VALUES (1,1,'2023-08-06 13:40:13','2023-08-06 11:40:13','<!-- wp:paragraph -->\n<p>Bienvenue sur le miam de la famille !</p>\n<!-- /wp:paragraph -->','Bonjour tout le monde !!!','','publish','open','open','','bonjour-tout-le-monde','','','2023-08-08 17:08:36','2023-08-08 15:08:36','',0,'http://miam.vicq.org/?p=1',0,'post','',1);
INSERT INTO `miam_posts` VALUES (2,1,'2023-08-06 13:40:13','2023-08-06 11:40:13','<!-- wp:paragraph -->\n<p>Ceci est une page d’exemple. C’est différent d’un article de blog parce qu’elle restera au même endroit et apparaîtra dans la navigation de votre site (dans la plupart des thèmes). La plupart des gens commencent par une page « À propos » qui les présente aux personnes visitant le site. Cela pourrait ressembler à quelque chose comme cela :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:quote -->\n<blockquote class="wp-block-quote"><p>Bonjour ! Je suis un mécanicien qui aspire à devenir acteur, et voici mon site. J’habite à Bordeaux, j’ai un super chien baptisé Russell, et j’aime la vodka (ainsi qu’être surpris par la pluie soudaine lors de longues balades sur la plage au coucher du soleil).</p></blockquote>\n<!-- /wp:quote -->\n\n<!-- wp:paragraph -->\n<p>…ou quelque chose comme cela :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:quote -->\n<blockquote class="wp-block-quote"><p>La société 123 Machin Truc a été créée en 1971, et n’a cessé de proposer au public des machins-trucs de qualité depuis lors. Située à Saint-Remy-en-Bouzemont-Saint-Genest-et-Isson, 123 Machin Truc emploie 2 000 personnes, et fabrique toutes sortes de bidules supers pour la communauté bouzemontoise.</p></blockquote>\n<!-- /wp:quote -->\n\n<!-- wp:paragraph -->\n<p>En tant que nouvel utilisateur ou utilisatrice de WordPress, vous devriez vous rendre sur <a href="http://miam.vicq.org/wp-admin/">votre tableau de bord</a> pour supprimer cette page et créer de nouvelles pages pour votre contenu. Amusez-vous bien !</p>\n<!-- /wp:paragraph -->','Page d’exemple','','publish','closed','open','','page-d-exemple','','','2023-08-06 13:40:13','2023-08-06 11:40:13','',0,'http://miam.vicq.org/?page_id=2',0,'page','',0);
INSERT INTO `miam_posts` VALUES (3,1,'2023-08-06 13:40:13','2023-08-06 11:40:13','<!-- wp:heading --><h2>Qui sommes-nous ?</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class="privacy-policy-tutorial">Texte suggéré : </strong>L’adresse de notre site est : http://miam.vicq.org.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>Commentaires</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class="privacy-policy-tutorial">Texte suggéré : </strong>Quand vous laissez un commentaire sur notre site, les données inscrites dans le formulaire de commentaire, ainsi que votre adresse IP et l’agent utilisateur de votre navigateur sont collectés pour nous aider à la détection des commentaires indésirables.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Une chaîne anonymisée créée à partir de votre adresse e-mail (également appelée hash) peut être envoyée au service Gravatar pour vérifier si vous utilisez ce dernier. Les clauses de confidentialité du service Gravatar sont disponibles ici : https://automattic.com/privacy/. Après validation de votre commentaire, votre photo de profil sera visible publiquement à coté de votre commentaire.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>Médias</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class="privacy-policy-tutorial">Texte suggéré : </strong>Si vous téléversez des images sur le site, nous vous conseillons d’éviter de téléverser des images contenant des données EXIF de coordonnées GPS. Les personnes visitant votre site peuvent télécharger et extraire des données de localisation depuis ces images.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>Cookies</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class="privacy-policy-tutorial">Texte suggéré : </strong>Si vous déposez un commentaire sur notre site, il vous sera proposé d’enregistrer votre nom, adresse e-mail et site dans des cookies. C’est uniquement pour votre confort afin de ne pas avoir à saisir ces informations si vous déposez un autre commentaire plus tard. Ces cookies expirent au bout d’un an.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Si vous vous rendez sur la page de connexion, un cookie temporaire sera créé afin de déterminer si votre navigateur accepte les cookies. Il ne contient pas de données personnelles et sera supprimé automatiquement à la fermeture de votre navigateur.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Lorsque vous vous connecterez, nous mettrons en place un certain nombre de cookies pour enregistrer vos informations de connexion et vos préférences d’écran. La durée de vie d’un cookie de connexion est de deux jours, celle d’un cookie d’option d’écran est d’un an. Si vous cochez « Se souvenir de moi », votre cookie de connexion sera conservé pendant deux semaines. Si vous vous déconnectez de votre compte, le cookie de connexion sera effacé.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>En modifiant ou en publiant une publication, un cookie supplémentaire sera enregistré dans votre navigateur. Ce cookie ne comprend aucune donnée personnelle. Il indique simplement l’ID de la publication que vous venez de modifier. Il expire au bout d’un jour.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>Contenu embarqué depuis d’autres sites</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class="privacy-policy-tutorial">Texte suggéré : </strong>Les articles de ce site peuvent inclure des contenus intégrés (par exemple des vidéos, images, articles…). Le contenu intégré depuis d’autres sites se comporte de la même manière que si le visiteur se rendait sur cet autre site.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Ces sites web pourraient collecter des données sur vous, utiliser des cookies, embarquer des outils de suivis tiers, suivre vos interactions avec ces contenus embarqués si vous disposez d’un compte connecté sur leur site web.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>Utilisation et transmission de vos données personnelles</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class="privacy-policy-tutorial">Texte suggéré : </strong>Si vous demandez une réinitialisation de votre mot de passe, votre adresse IP sera incluse dans l’e-mail de réinitialisation.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>Durées de stockage de vos données</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class="privacy-policy-tutorial">Texte suggéré : </strong>Si vous laissez un commentaire, le commentaire et ses métadonnées sont conservés indéfiniment. Cela permet de reconnaître et approuver automatiquement les commentaires suivants au lieu de les laisser dans la file de modération.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Pour les comptes qui s’inscrivent sur notre site (le cas échéant), nous stockons également les données personnelles indiquées dans leur profil. Tous les comptes peuvent voir, modifier ou supprimer leurs informations personnelles à tout moment (à l’exception de leur identifiant). Les gestionnaires du site peuvent aussi voir et modifier ces informations.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>Les droits que vous avez sur vos données</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class="privacy-policy-tutorial">Texte suggéré : </strong>Si vous avez un compte ou si vous avez laissé des commentaires sur le site, vous pouvez demander à recevoir un fichier contenant toutes les données personnelles que nous possédons à votre sujet, incluant celles que vous nous avez fournies. Vous pouvez également demander la suppression des données personnelles vous concernant. Cela ne prend pas en compte les données stockées à des fins administratives, légales ou pour des raisons de sécurité.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>Où vos données sont envoyées</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class="privacy-policy-tutorial">Texte suggéré : </strong>Les commentaires des visiteurs peuvent être vérifiés à l’aide d’un service automatisé de détection des commentaires indésirables.</p><!-- /wp:paragraph -->','Politique de confidentialité','','draft','closed','open','','politique-de-confidentialite','','','2023-08-06 13:40:13','2023-08-06 11:40:13','',0,'http://miam.vicq.org/?page_id=3',0,'page','',0);
INSERT INTO `miam_posts` VALUES (5,1,'2023-08-06 14:14:52','2023-08-06 12:14:52','[recipe_search]','Recherche de recettes','','publish','closed','closed','','recherche-recette','','','2023-08-06 14:14:52','2023-08-06 12:14:52','',0,'http://miam.vicq.org/recherche-recette/',0,'page','',0);
INSERT INTO `miam_posts` VALUES (6,1,'2023-08-06 14:14:52','2023-08-06 12:14:52','[dr_user_dashboard]','Tableau de bord de la recette','','publish','closed','closed','','recette-tableau-de-bord','','','2023-08-06 14:14:52','2023-08-06 12:14:52','',0,'http://miam.vicq.org/recette-tableau-de-bord/',0,'page','',0);
INSERT INTO `miam_posts` VALUES (7,1,'2023-08-06 14:14:52','0000-00-00 00:00:00','<p>Love French Toast Casserole, but don’t time to let it sit overnight? Not to worry, with this <a href="#">Instant PotFrench</a> Toast will be ready in no time!</p>\n            <p><b><em>Note –</em></b> this may look like different pictures than what got you here. We were finding that readers<br>were having issues with the recipe so we totally reworked it! Please give us your feedback in the comments. We welcome constructive comments that will help us serve you better!</p>\n            <h3>Instant Pot French Toast Recipe</h3>\n            <p>You may have made a cinnamon roll french toast casserole or french toast bake, but those can take a long time to make. With the instant pot craze going on, we thought we would try to shorten the preparation time needed for traditional french toast bakes! We love our instant pot and use it for dinners all the time. We have even used it for dessert with our Instant Pot Monkey Bread. The ease and quickness of it are perfect for our busy lifestyle.</p>\n            <p>I honestly had no idea that you could even make french toast in the instant pot! But it is really easy!Feel free to add in some fun additions like pecans, walnuts or chocolate chips! They are all great.</p>\n            <p>This will make the perfect dish for your Christmas Morning Brunch! Looking for some other great Christmas Morning Recipes? We have tons!!</p>','The Best Instant Pot French Toast recipe (vegan &amp; Gluten Free!)','Love French Toast Casserole, but don’t time to let it sit overnight? Not to worry, with this Instant Pot French Toast will be ready in no time!','draft','closed','closed','','','','','2023-08-06 14:14:52','0000-00-00 00:00:00','',0,'http://miam.vicq.org/?p=7',0,'recipe','',0);
INSERT INTO `miam_posts` VALUES (8,1,'2023-08-06 14:14:52','2023-08-06 12:14:52','','dummy-recipe-img','','inherit','open','closed','','dummy-recipe-img','','','2023-08-06 14:14:52','2023-08-06 12:14:52','',7,'http://miam.vicq.org/wp-content/uploads/2023/08/dummy-recipe-img.jpg',0,'attachment','image/jpeg',0);
INSERT INTO `miam_posts` VALUES (9,1,'2023-08-06 14:14:54','2023-08-06 12:14:54','','Plats de la recette','','publish','closed','closed','','plats-de-la-recette','','','2023-08-06 16:11:26','2023-08-06 14:11:26','',0,'http://miam.vicq.org/plats-de-la-recette/',0,'page','',0);
INSERT INTO `miam_posts` VALUES (10,1,'2023-08-06 14:14:54','2023-08-06 12:14:54','','Modes de cuisson de la recette','','publish','closed','closed','','modes-de-cuisson-de-la-recette','','','2023-08-06 16:10:58','2023-08-06 14:10:58','',0,'http://miam.vicq.org/modes-de-cuisson-de-la-recette/',0,'page','',0);
INSERT INTO `miam_posts` VALUES (11,1,'2023-08-06 14:14:54','2023-08-06 12:14:54','','Cuisines de la recette','','publish','closed','closed','','cuisines-de-la-recette','','','2023-08-06 16:10:44','2023-08-06 14:10:44','',0,'http://miam.vicq.org/cuisines-de-la-recette/',0,'page','',0);
INSERT INTO `miam_posts` VALUES (12,1,'2023-08-06 14:14:54','2023-08-06 12:14:54','','Thématiques de recette','','publish','closed','closed','','thematiques-de-recette','','','2023-08-06 14:14:54','2023-08-06 12:14:54','',0,'http://miam.vicq.org/thematiques-de-recette/',0,'page','',0);
INSERT INTO `miam_posts` VALUES (13,1,'2023-08-06 14:14:54','2023-08-06 12:14:54','','Mots-clés de la recette','','publish','closed','closed','','mots-cles-de-la-recette','','','2023-08-06 16:11:08','2023-08-06 14:11:08','',0,'http://miam.vicq.org/mots-cles-de-la-recette/',0,'page','',0);
INSERT INTO `miam_posts` VALUES (14,1,'2023-08-06 14:14:54','2023-08-06 12:14:54','','badges de recettes','','publish','closed','closed','','badges-de-recettes','','','2023-08-06 16:11:54','2023-08-06 14:11:54','',0,'http://miam.vicq.org/badges-de-recettes/',0,'page','',0);
INSERT INTO `miam_posts` VALUES (15,1,'2023-08-08 10:24:18','2023-08-08 08:24:18','','Brochettes de dinde "Yves de Swetschin"','','publish','open','closed','','brochettes-de-dinde-yves-de-swetschin','','','2023-09-23 11:29:12','2023-09-23 09:29:12','',0,'http://miam.vicq.org/?post_type=recipe&#038;p=15',0,'recipe','',0);
INSERT INTO `miam_posts` VALUES (16,1,'2023-08-06 15:40:27','0000-00-00 00:00:00','','Accueil','','draft','closed','closed','','','','','2023-08-06 15:40:27','0000-00-00 00:00:00','',0,'http://miam.vicq.org/?p=16',1,'nav_menu_item','',0);
INSERT INTO `miam_posts` VALUES (17,1,'2023-08-06 15:40:27','0000-00-00 00:00:00',' ','','','draft','closed','closed','','','','','2023-08-06 15:40:27','0000-00-00 00:00:00','',0,'http://miam.vicq.org/?p=17',1,'nav_menu_item','',0);
INSERT INTO `miam_posts` VALUES (18,1,'2023-08-06 15:40:27','0000-00-00 00:00:00',' ','','','draft','closed','closed','','','','','2023-08-06 15:40:27','0000-00-00 00:00:00','',0,'http://miam.vicq.org/?p=18',1,'nav_menu_item','',0);
INSERT INTO `miam_posts` VALUES (19,1,'2023-08-06 15:40:27','0000-00-00 00:00:00',' ','','','draft','closed','closed','','','','','2023-08-06 15:40:27','0000-00-00 00:00:00','',0,'http://miam.vicq.org/?p=19',1,'nav_menu_item','',0);
INSERT INTO `miam_posts` VALUES (20,1,'2023-08-06 15:40:27','0000-00-00 00:00:00',' ','','','draft','closed','closed','','','','','2023-08-06 15:40:27','0000-00-00 00:00:00','',0,'http://miam.vicq.org/?p=20',1,'nav_menu_item','',0);
INSERT INTO `miam_posts` VALUES (21,1,'2023-08-06 15:40:27','0000-00-00 00:00:00',' ','','','draft','closed','closed','','','','','2023-08-06 15:40:27','0000-00-00 00:00:00','',0,'http://miam.vicq.org/?p=21',1,'nav_menu_item','',0);
INSERT INTO `miam_posts` VALUES (22,1,'2023-08-06 15:40:27','0000-00-00 00:00:00',' ','','','draft','closed','closed','','','','','2023-08-06 15:40:27','0000-00-00 00:00:00','',0,'http://miam.vicq.org/?p=22',1,'nav_menu_item','',0);
INSERT INTO `miam_posts` VALUES (23,1,'2023-08-06 15:40:27','0000-00-00 00:00:00',' ','','','draft','closed','closed','','','','','2023-08-06 15:40:27','0000-00-00 00:00:00','',0,'http://miam.vicq.org/?p=23',1,'nav_menu_item','',0);
INSERT INTO `miam_posts` VALUES (24,1,'2023-08-06 15:40:27','0000-00-00 00:00:00',' ','','','draft','closed','closed','','','','','2023-08-06 15:40:27','0000-00-00 00:00:00','',0,'http://miam.vicq.org/?p=24',1,'nav_menu_item','',0);
INSERT INTO `miam_posts` VALUES (25,1,'2023-08-06 15:40:27','0000-00-00 00:00:00',' ','','','draft','closed','closed','','','','','2023-08-06 15:40:27','0000-00-00 00:00:00','',0,'http://miam.vicq.org/?p=25',1,'nav_menu_item','',0);
INSERT INTO `miam_posts` VALUES (29,1,'2023-08-06 16:08:48','2023-08-06 14:08:48','','Cuisines de la recette','','inherit','closed','closed','','11-revision-v1','','','2023-08-06 16:08:48','2023-08-06 14:08:48','',11,'http://miam.vicq.org/?p=29',0,'revision','',0);
INSERT INTO `miam_posts` VALUES (30,1,'2023-08-06 16:09:28','2023-08-06 14:09:28','','badges de recettes','','inherit','closed','closed','','14-revision-v1','','','2023-08-06 16:09:28','2023-08-06 14:09:28','',14,'http://miam.vicq.org/?p=30',0,'revision','',0);
INSERT INTO `miam_posts` VALUES (31,1,'2023-08-06 16:10:58','2023-08-06 14:10:58','','Modes de cuisson de la recette','','inherit','closed','closed','','10-revision-v1','','','2023-08-06 16:10:58','2023-08-06 14:10:58','',10,'http://miam.vicq.org/?p=31',0,'revision','',0);
INSERT INTO `miam_posts` VALUES (32,1,'2023-08-06 16:11:08','2023-08-06 14:11:08','','Mots-clés de la recette','','inherit','closed','closed','','13-revision-v1','','','2023-08-06 16:11:08','2023-08-06 14:11:08','',13,'http://miam.vicq.org/?p=32',0,'revision','',0);
INSERT INTO `miam_posts` VALUES (33,1,'2023-08-06 16:11:26','2023-08-06 14:11:26','','Plats de la recette','','inherit','closed','closed','','9-revision-v1','','','2023-08-06 16:11:26','2023-08-06 14:11:26','',9,'http://miam.vicq.org/?p=33',0,'revision','',0);
INSERT INTO `miam_posts` VALUES (36,1,'2023-08-06 19:32:46','2023-08-06 17:32:46','','Pancakes américains','Pancakes, recette américaine','publish','open','closed','','pancakes-americains','','','2023-08-08 16:17:09','2023-08-08 14:17:09','',0,'http://miam.vicq.org/?post_type=recipe&#038;p=36',0,'recipe','',1);
INSERT INTO `miam_posts` VALUES (37,1,'2023-08-06 19:39:49','2023-08-06 17:39:49','','pancakes','','inherit','open','closed','','pancakes','','','2023-08-06 19:39:49','2023-08-06 17:39:49','',36,'http://miam.vicq.org/wp-content/uploads/2023/08/pancakes.jpg',0,'attachment','image/jpeg',0);
INSERT INTO `miam_posts` VALUES (38,1,'2023-08-07 15:57:50','2023-08-07 13:57:50','<!-- wp:paragraph -->\n<p>Bienvenue sur WordPress. Ceci est votre premier article. Modifiez-le ou supprimez-le, puis commencez à écrire&nbsp;!</p>\n<!-- /wp:paragraph -->','Bonjour tout le monde !!','','inherit','closed','closed','','1-revision-v1','','','2023-08-07 15:57:50','2023-08-07 13:57:50','',1,'http://miam.vicq.org/?p=38',0,'revision','',0);
INSERT INTO `miam_posts` VALUES (39,1,'2023-08-07 15:58:19','2023-08-07 13:58:19','<!-- wp:paragraph -->\n<p>Bienvenue sur WordPress. Ceci est votre premier article. Modifiez-le ou supprimez-le, puis commencez à écrire&nbsp;!</p>\n<!-- /wp:paragraph -->','Bonjour tout le monde !!!','','inherit','closed','closed','','1-revision-v1','','','2023-08-07 15:58:19','2023-08-07 13:58:19','',1,'http://miam.vicq.org/?p=39',0,'revision','',0);
INSERT INTO `miam_posts` VALUES (42,1,'2023-08-08 10:20:38','2023-08-08 08:20:38','','Brochette','composition de la brochette','inherit','open','closed','','brochette','','','2023-08-08 10:21:18','2023-08-08 08:21:18','',0,'http://miam.vicq.org/wp-content/uploads/2023/08/Brochette.png',0,'attachment','image/png',0);
INSERT INTO `miam_posts` VALUES (50,1,'2023-08-08 16:33:28','2023-08-08 14:33:28','','brochette-photo-small','','inherit','open','closed','','brochette-photo-small','','','2023-08-08 16:33:28','2023-08-08 14:33:28','',0,'http://miam.vicq.org/wp-content/uploads/2023/08/brochette-photo-small.png',0,'attachment','image/png',0);
INSERT INTO `miam_posts` VALUES (62,1,'2023-08-08 17:08:33','2023-08-08 15:08:33','<!-- wp:paragraph -->\n<p>Bienvenue sur le miam de la famille !</p>\n<!-- /wp:paragraph -->','Bonjour tout le monde !!!','','inherit','closed','closed','','1-revision-v1','','','2023-08-08 17:08:33','2023-08-08 15:08:33','',1,'http://miam.vicq.org/?p=62',0,'revision','',0);
INSERT INTO `miam_posts` VALUES (63,1,'2023-08-08 18:01:16','2023-08-08 16:01:16','','https://vicq.org/alimentation','','publish','closed','closed','','https-vicq-org-alimentation','','','2023-08-08 18:01:16','2023-08-08 16:01:16','',0,'http://miam.vicq.org/?page_id=63',0,'page','',0);
INSERT INTO `miam_posts` VALUES (65,1,'2023-08-08 18:01:16','2023-08-08 16:01:16','','https://vicq.org/alimentation','','inherit','closed','closed','','63-revision-v1','','','2023-08-08 18:01:16','2023-08-08 16:01:16','',63,'http://miam.vicq.org/?p=65',0,'revision','',0);
INSERT INTO `miam_posts` VALUES (68,1,'2023-08-08 18:04:27','2023-08-08 16:04:27','','https://vicq.org/aliments/','','publish','closed','closed','','https-vicq-org-aliments','','','2023-08-08 18:04:27','2023-08-08 16:04:27','',0,'http://miam.vicq.org/?page_id=68',0,'page','',0);
INSERT INTO `miam_posts` VALUES (69,1,'2023-08-08 18:04:27','2023-08-08 16:04:27','','https://vicq.org/aliments/','','inherit','closed','closed','','68-revision-v1','','','2023-08-08 18:04:27','2023-08-08 16:04:27','',68,'http://miam.vicq.org/?p=69',0,'revision','',0);
INSERT INTO `miam_posts` VALUES (75,1,'2023-08-08 18:12:55','2023-08-08 16:10:44','','Aliments et groupes sanguins','','publish','closed','closed','','aliments-et-groupes-sanguins','','','2023-08-08 18:12:55','2023-08-08 16:12:55','',0,'http://miam.vicq.org/2023/08/08/aliments-et-groupes-sanguins/',6,'nav_menu_item','',0);
INSERT INTO `miam_posts` VALUES (76,1,'2023-08-08 18:10:44','2023-08-08 16:10:44',' ','','','publish','closed','closed','','76','','','2023-08-08 18:10:44','2023-08-08 16:10:44','',0,'http://miam.vicq.org/2023/08/08/76/',1,'nav_menu_item','',0);
INSERT INTO `miam_posts` VALUES (77,1,'2023-08-08 18:12:09','2023-08-08 16:10:44',' ','','','publish','closed','closed','','77','','','2023-08-08 18:12:09','2023-08-08 16:12:09','',0,'http://miam.vicq.org/2023/08/08/77/',1,'nav_menu_item','',0);
INSERT INTO `miam_posts` VALUES (78,1,'2023-08-08 18:12:09','2023-08-08 16:10:44',' ','','','publish','closed','closed','','78','','','2023-08-08 18:12:09','2023-08-08 16:12:09','',0,'http://miam.vicq.org/2023/08/08/78/',2,'nav_menu_item','',0);
INSERT INTO `miam_posts` VALUES (79,1,'2023-08-08 18:12:55','2023-08-08 16:10:44',' ','','','publish','closed','closed','','79','','','2023-08-08 18:12:55','2023-08-08 16:12:55','',0,'http://miam.vicq.org/2023/08/08/79/',3,'nav_menu_item','',0);
INSERT INTO `miam_posts` VALUES (85,1,'2023-12-22 18:27:58','2023-12-22 17:27:58','','Riz à sushi','','publish','open','closed','','riz-a-sushi','','','2023-12-22 18:33:32','2023-12-22 17:33:32','',0,'http://miam.vicq.org/?post_type=recipe&#038;p=85',0,'recipe','',0);
INSERT INTO `miam_posts` VALUES (87,1,'2023-09-23 11:30:57','2023-09-23 09:30:57','','Pâte sablée Christophe Michalak','','publish','open','closed','','pate-sablee-christophe-michalak','','','2023-09-25 12:11:41','2023-09-25 10:11:41','',0,'http://miam.vicq.org/?post_type=recipe&#038;p=87',0,'recipe','',0);
INSERT INTO `miam_posts` VALUES (90,1,'2023-09-25 12:10:17','2023-09-25 10:10:17','','pate-sablee-thermomix','','inherit','open','closed','','pate-sablee-thermomix','','','2023-09-25 12:10:17','2023-09-25 10:10:17','',0,'http://miam.vicq.org/wp-content/uploads/2023/09/pate-sablee-thermomix.webp',0,'attachment','image/webp',0);
INSERT INTO `miam_posts` VALUES (93,1,'2023-10-14 12:12:00','2023-10-14 10:12:00','','Salade de chou mariné (style japonais)','','publish','open','closed','','salade-de-chou-japanese-style','','','2023-12-28 22:18:43','2023-12-28 21:18:43','',0,'http://miam.vicq.org/?post_type=recipe&#038;p=93',0,'recipe','',0);
INSERT INTO `miam_posts` VALUES (94,1,'2023-10-14 12:06:46','2023-10-14 10:06:46','','chou mariné japonais','','inherit','open','closed','','chou-marine-japonais','','','2023-10-14 12:06:46','2023-10-14 10:06:46','',0,'http://miam.vicq.org/wp-content/uploads/2023/10/chou-marine-japonais.png',0,'attachment','image/png',0);
INSERT INTO `miam_posts` VALUES (100,1,'2023-12-22 18:32:40','2023-12-22 17:32:40','','riz-sushi','','inherit','open','closed','','riz-sushi','','','2023-12-22 18:32:40','2023-12-22 17:32:40','',0,'http://miam.vicq.org/wp-content/uploads/2023/12/riz-sushi.jpg',0,'attachment','image/jpeg',0);
INSERT INTO `miam_posts` VALUES (101,1,'2023-12-28 21:40:17','2023-12-28 20:40:17','','Praliné (Conticini)','','publish','open','closed','','praline-conticini','','','2023-12-28 21:40:17','2023-12-28 20:40:17','',0,'http://miam.vicq.org/?post_type=recipe&#038;p=101',0,'recipe','',0);
/*!40000 ALTER TABLE `miam_posts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `miam_postmeta`
--

DROP TABLE IF EXISTS `miam_postmeta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `miam_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=377 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `miam_postmeta`
--

LOCK TABLES `miam_postmeta` WRITE;
/*!40000 ALTER TABLE `miam_postmeta` DISABLE KEYS */;
INSERT INTO `miam_postmeta` VALUES (1,2,'_wp_page_template','default');
INSERT INTO `miam_postmeta` VALUES (2,3,'_wp_page_template','default');
INSERT INTO `miam_postmeta` VALUES (3,7,'delicious_recipes_metadata','a:61:{s:14:"recipeSubtitle";s:95:"The recipe subtitle text goes here. A brief note on the recipe will look great in this section.";s:17:"recipeDescription";s:242:"You may have made a cinnamon roll french toast casserole or french toast bake, but those can take a long time to make. With the instant pot craze going on, we thought we would try to shorten the preparation time needed for traditional french.";s:14:"recipeKeywords";s:29:"home made, vegan, gluten free";s:15:"difficultyLevel";s:8:"beginner";s:8:"prepTime";s:2:"15";s:12:"prepTimeUnit";s:3:"min";s:8:"cookTime";s:2:"15";s:12:"cookTimeUnit";s:3:"min";s:8:"restTime";s:2:"15";s:12:"restTimeUnit";s:3:"min";s:13:"totalDuration";s:0:"";s:17:"totalDurationUnit";s:3:"min";s:10:"bestSeason";s:6:"summer";s:14:"recipeCalories";s:8:"240 kcal";s:12:"noOfServings";s:1:"8";s:15:"ingredientTitle";s:11:"Ingredients";s:17:"recipeIngredients";a:1:{i:0;a:2:{s:12:"sectionTitle";s:0:"";s:11:"ingredients";a:7:{i:0;a:4:{s:8:"quantity";s:1:"4";s:4:"unit";s:3:"cup";s:10:"ingredient";s:12:"French bread";s:5:"notes";s:45:"cut into bite-size pieces and dried overnight";}i:1;a:4:{s:8:"quantity";s:1:"3";s:4:"unit";s:0:"";s:10:"ingredient";s:4:"eggs";s:5:"notes";s:0:"";}i:2;a:4:{s:8:"quantity";s:3:"3/4";s:4:"unit";s:3:"cup";s:10:"ingredient";s:4:"milk";s:5:"notes";s:0:"";}i:3;a:4:{s:8:"quantity";s:1:"1";s:4:"unit";s:3:"tsp";s:10:"ingredient";s:7:"vanilla";s:5:"notes";s:0:"";}i:4;a:4:{s:8:"quantity";s:3:"1/4";s:4:"unit";s:3:"cup";s:10:"ingredient";s:5:"sugar";s:5:"notes";s:0:"";}i:5;a:4:{s:8:"quantity";s:3:"1/4";s:4:"unit";s:3:"cup";s:10:"ingredient";s:11:"brown sugar";s:5:"notes";s:0:"";}i:6;a:4:{s:8:"quantity";s:1:"2";s:4:"unit";s:3:"tsp";s:10:"ingredient";s:8:"cinnamon";s:5:"notes";s:0:"";}}}}s:17:"instructionsTitle";s:12:"Instructions";s:18:"recipeInstructions";a:1:{i:0;a:2:{s:12:"sectionTitle";s:0:"";s:11:"instruction";a:9:{i:0;a:6:{s:16:"instructionTitle";s:0:"";s:11:"instruction";s:85:"Cut the loaf into bite-size pieces and let it dry overnight on a cookie sheet or pan.";s:5:"image";s:0:"";s:13:"image_preview";s:0:"";s:8:"videoURL";s:0:"";s:16:"instructionNotes";s:125:"You can use parchment paper in the bottom too for easy release. (you can use the special pan made for IP too if you have it).";}i:1;a:6:{s:16:"instructionTitle";s:0:"";s:11:"instruction";s:67:"Spray the bottom and sides of your dish with nonstick baking spray.";s:5:"image";s:0:"";s:13:"image_preview";s:0:"";s:8:"videoURL";s:0:"";s:16:"instructionNotes";s:0:"";}i:2;a:6:{s:16:"instructionTitle";s:0:"";s:11:"instruction";s:79:"Whisk the eggs and then add the milk, vanilla, sugar, brown sugar and cinnamon.";s:5:"image";s:0:"";s:13:"image_preview";s:0:"";s:8:"videoURL";s:0:"";s:16:"instructionNotes";s:0:"";}i:3;a:6:{s:16:"instructionTitle";s:0:"";s:11:"instruction";s:147:"Add the dried bread pieces. Let them soak for about 10 minutes. Stirring occasionally to make sure every piece of bread gets into the milk mixture.";s:5:"image";s:0:"";s:13:"image_preview";s:0:"";s:8:"videoURL";s:0:"";s:16:"instructionNotes";s:0:"";}i:4;a:6:{s:16:"instructionTitle";s:0:"";s:11:"instruction";s:79:"Dump the mixture into your prepared dish. Cover the dish really well with foil.";s:5:"image";s:0:"";s:13:"image_preview";s:0:"";s:8:"videoURL";s:0:"";s:16:"instructionNotes";s:168:"I put a piece over the top and then also placed the dish on a piece of foil and brought the edges up around it. (This helps seal out the moisture while it is steaming).";}i:5;a:6:{s:16:"instructionTitle";s:0:"";s:11:"instruction";s:237:"Place your trivet that came with the Instant Pot in the bottom of the pot and pour 1 cup of water into the pot. Place your baking dish on top of the trivet. Place the lid on the instant pot and make sure the vent is turned to “seal”.";s:5:"image";s:0:"";s:13:"image_preview";s:0:"";s:8:"videoURL";s:0:"";s:16:"instructionNotes";s:0:"";}i:6;a:6:{s:16:"instructionTitle";s:0:"";s:11:"instruction";s:47:"Set manual and pressure to high for 40 minutes.";s:5:"image";s:0:"";s:13:"image_preview";s:0:"";s:8:"videoURL";s:0:"";s:16:"instructionNotes";s:0:"";}i:7;a:6:{s:16:"instructionTitle";s:0:"";s:11:"instruction";s:80:"When the timer goes off cover the vent with a towel and quick release the steam.";s:5:"image";s:0:"";s:13:"image_preview";s:0:"";s:8:"videoURL";s:0:"";s:16:"instructionNotes";s:0:"";}i:8;a:6:{s:16:"instructionTitle";s:0:"";s:11:"instruction";s:87:"Remove the dish carefully as it will be hot and remove the foil from the dish draining.";s:5:"image";s:0:"";s:13:"image_preview";s:0:"";s:8:"videoURL";s:0:"";s:16:"instructionNotes";s:101:"Top with powdered sugar, cinnamon, homemade candied pecans, and whipped cream to make it extra yummy!";}}}}s:18:"imageGalleryImages";a:0:{}s:16:"videoGalleryVids";a:0:{}s:11:"servingSize";s:1:"5";s:8:"servings";s:1:"8";s:8:"calories";s:3:"730";s:15:"caloriesFromFat";s:3:"250";s:8:"totalFat";s:2:"27";s:12:"saturatedFat";s:1:"9";s:8:"transFat";s:0:"";s:11:"cholesterol";s:3:"195";s:6:"sodium";s:3:"730";s:9:"potassium";s:0:"";s:17:"totalCarbohydrate";s:2:"19";s:12:"dietaryFiber";s:1:"5";s:6:"sugars";s:2:"10";s:7:"protein";s:2:"97";s:8:"vitaminA";s:0:"";s:8:"vitaminC";s:2:"10";s:7:"calcium";s:0:"";s:4:"iron";s:2:"12";s:8:"vitaminD";s:0:"";s:8:"vitaminE";s:1:"8";s:8:"vitaminK";s:1:"5";s:7:"thiamin";s:0:"";s:10:"riboflavin";s:0:"";s:6:"niacin";s:0:"";s:9:"vitaminB6";s:0:"";s:6:"folate";s:0:"";s:10:"vitaminB12";s:0:"";s:6:"biotin";s:0:"";s:15:"pantothenicAcid";s:0:"";s:10:"phosphorus";s:0:"";s:6:"iodine";s:0:"";s:9:"magnesium";s:0:"";s:4:"zinc";s:0:"";s:8:"selenium";s:0:"";s:6:"copper";s:0:"";s:9:"manganese";s:0:"";s:8:"chromium";s:0:"";s:10:"molybdenum";s:0:"";s:8:"chloride";s:0:"";s:11:"recipeNotes";s:176:"<ul><li>Cook this recipe at low heat.</li><li>Use fresh ingredients for better taste</li>\n            <li>After cooking, wait for at least 15 minutes for better taste</li></ul>";}');
INSERT INTO `miam_postmeta` VALUES (4,7,'_dr_difficulty_level','beginner');
INSERT INTO `miam_postmeta` VALUES (5,7,'_dr_best_season','summer');
INSERT INTO `miam_postmeta` VALUES (6,7,'_dr_recipe_ingredients','a:7:{i:0;s:12:"French bread";i:1;s:4:"Eggs";i:2;s:4:"Milk";i:3;s:7:"Vanilla";i:4;s:5:"Sugar";i:5;s:11:"Brown sugar";i:6;s:8:"Cinnamon";}');
INSERT INTO `miam_postmeta` VALUES (7,7,'_dr_ingredient_count','7');
INSERT INTO `miam_postmeta` VALUES (8,8,'_wp_attached_file','2023/08/dummy-recipe-img.jpg');
INSERT INTO `miam_postmeta` VALUES (9,8,'_wp_attachment_metadata','a:6:{s:5:"width";i:768;s:6:"height";i:1024;s:4:"file";s:28:"2023/08/dummy-recipe-img.jpg";s:8:"filesize";i:96214;s:5:"sizes";a:15:{s:6:"medium";a:5:{s:4:"file";s:28:"dummy-recipe-img-225x300.jpg";s:5:"width";i:225;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:12909;}s:9:"thumbnail";a:5:{s:4:"file";s:28:"dummy-recipe-img-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:7796;}s:21:"blossom-recipe-schema";a:5:{s:4:"file";s:26:"dummy-recipe-img-45x60.jpg";s:5:"width";i:45;s:6:"height";i:60;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:4208;}s:21:"blossom-recipe-slider";a:5:{s:4:"file";s:28:"dummy-recipe-img-480x702.jpg";s:5:"width";i:480;s:6:"height";i:702;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:38037;}s:19:"blossom-recipe-blog";a:5:{s:4:"file";s:28:"dummy-recipe-img-768x840.jpg";s:5:"width";i:768;s:6:"height";i:840;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:70729;}s:23:"blossom-recipe-blog-one";a:5:{s:4:"file";s:28:"dummy-recipe-img-768x840.jpg";s:5:"width";i:768;s:6:"height";i:840;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:70729;}s:21:"recipe-feat-thumbnail";a:5:{s:4:"file";s:28:"dummy-recipe-img-124x166.jpg";s:5:"width";i:124;s:6:"height";i:166;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:7206;}s:16:"recipe-feat-tall";a:5:{s:4:"file";s:28:"dummy-recipe-img-290x386.jpg";s:5:"width";i:290;s:6:"height";i:386;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:17594;}s:17:"recipe-feat-print";a:5:{s:4:"file";s:28:"dummy-recipe-img-595x595.jpg";s:5:"width";i:595;s:6:"height";i:595;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:42722;}s:19:"recipe-archive-list";a:5:{s:4:"file";s:28:"dummy-recipe-img-450x600.jpg";s:5:"width";i:450;s:6:"height";i:600;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:31922;}s:19:"recipe-archive-grid";a:5:{s:4:"file";s:28:"dummy-recipe-img-345x460.jpg";s:5:"width";i:345;s:6:"height";i:460;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:21925;}s:19:"recipe-author-image";a:5:{s:4:"file";s:28:"dummy-recipe-img-156x207.jpg";s:5:"width";i:156;s:6:"height";i:207;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:8720;}s:28:"delrecpe-structured-data-1_1";a:5:{s:4:"file";s:28:"dummy-recipe-img-500x500.jpg";s:5:"width";i:500;s:6:"height";i:500;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:32911;}s:28:"delrecpe-structured-data-4_3";a:5:{s:4:"file";s:28:"dummy-recipe-img-500x375.jpg";s:5:"width";i:500;s:6:"height";i:375;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:30111;}s:29:"delrecpe-structured-data-16_9";a:5:{s:4:"file";s:28:"dummy-recipe-img-480x270.jpg";s:5:"width";i:480;s:6:"height";i:270;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:25699;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `miam_postmeta` VALUES (10,8,'_source_url','http://miam.vicq.org/wp-content/plugins/delicious-recipes//assets/images/dummy-recipe-img.jpg');
INSERT INTO `miam_postmeta` VALUES (11,7,'_thumbnail_id','8');
INSERT INTO `miam_postmeta` VALUES (12,9,'_wp_page_template','templates/pages/recipe-courses.php');
INSERT INTO `miam_postmeta` VALUES (13,10,'_wp_page_template','templates/pages/recipe-cooking-methods.php');
INSERT INTO `miam_postmeta` VALUES (14,11,'_wp_page_template','templates/pages/recipe-cuisines.php');
INSERT INTO `miam_postmeta` VALUES (15,12,'_wp_page_template','templates-pages-recipe-keys-php');
INSERT INTO `miam_postmeta` VALUES (16,13,'_wp_page_template','templates/pages/recipe-tags.php');
INSERT INTO `miam_postmeta` VALUES (17,14,'_wp_page_template','templates/pages/recipe-badges.php');
INSERT INTO `miam_postmeta` VALUES (18,7,'_edit_lock','1693673140:1');
INSERT INTO `miam_postmeta` VALUES (19,15,'_edit_lock','1695636218:1');
INSERT INTO `miam_postmeta` VALUES (20,15,'delicious_recipes_metadata','a:64:{s:14:"recipeSubtitle";s:43:"La célèbre recette des brochettes de Papy";s:17:"recipeDescription";s:117:"<p>Recette de brochettes de dinde marinée dans le mélange original saté-curry, inventé par Yves de Swetschin.</p>";s:14:"recipeKeywords";s:30:"dinde, brochette, saté, curry";s:15:"difficultyLevel";s:8:"beginner";s:8:"prepTime";s:2:"30";s:12:"prepTimeUnit";s:3:"min";s:8:"cookTime";s:2:"30";s:12:"cookTimeUnit";s:3:"min";s:8:"restTime";s:1:"8";s:12:"restTimeUnit";s:4:"hour";s:14:"recipeCalories";s:0:"";s:10:"bestSeason";s:6:"summer";s:12:"noOfServings";s:1:"6";s:15:"ingredientTitle";s:8:"Marinade";s:17:"recipeIngredients";a:3:{i:0;a:3:{s:12:"sectionTitle";s:8:"Marinade";s:11:"ingredients";a:12:{i:0;a:6:{s:8:"quantity";s:1:"1";s:4:"unit";s:2:"kg";s:10:"ingredient";s:14:"Filet de dinde";s:5:"notes";s:0:"";s:6:"chosen";s:0:"";s:8:"selected";s:0:"";}i:1;a:6:{s:8:"quantity";s:1:"1";s:4:"unit";s:1:"v";s:10:"ingredient";s:9:"vin blanc";s:5:"notes";s:0:"";s:6:"chosen";s:0:"";s:8:"selected";s:0:"";}i:2;a:6:{s:8:"quantity";s:3:"0,5";s:4:"unit";s:1:"v";s:10:"ingredient";s:5:"Huile";s:5:"notes";s:5:"olive";s:6:"chosen";s:0:"";s:8:"selected";s:0:"";}i:3;a:6:{s:8:"quantity";s:3:"0,5";s:4:"unit";s:1:"v";s:10:"ingredient";s:5:"Huile";s:5:"notes";s:9:"4 graines";s:6:"chosen";s:0:"";s:8:"selected";s:0:"";}i:4;a:6:{s:8:"quantity";s:1:"3";s:4:"unit";s:5:"clove";s:10:"ingredient";s:4:"aïl";s:5:"notes";s:0:"";s:6:"chosen";s:0:"";s:8:"selected";s:0:"";}i:5;a:6:{s:8:"quantity";s:1:"2";s:4:"unit";s:0:"";s:10:"ingredient";s:7:"oignons";s:5:"notes";s:4:"gros";s:6:"chosen";s:0:"";s:8:"selected";s:0:"";}i:6;a:6:{s:8:"quantity";s:1:"4";s:4:"unit";s:0:"";s:10:"ingredient";s:11:"échalottes";s:5:"notes";s:7:"grosses";s:6:"chosen";s:0:"";s:8:"selected";s:0:"";}i:7;a:6:{s:8:"quantity";s:1:"1";s:4:"unit";s:4:"tbsp";s:10:"ingredient";s:10:"sauce soja";s:5:"notes";s:6:"salée";s:6:"chosen";s:0:"";s:8:"selected";s:0:"";}i:8;a:6:{s:8:"quantity";s:1:"2";s:4:"unit";s:4:"tbsp";s:10:"ingredient";s:13:"pate de curry";s:5:"notes";s:0:"";s:6:"chosen";s:0:"";s:8:"selected";s:0:"";}i:9;a:6:{s:8:"quantity";s:1:"2";s:4:"unit";s:4:"tbsp";s:10:"ingredient";s:5:"saté";s:5:"notes";s:6:"poudre";s:6:"chosen";s:0:"";s:8:"selected";s:0:"";}i:10;a:6:{s:8:"quantity";s:1:"1";s:4:"unit";s:4:"dash";s:10:"ingredient";s:17:"piment de Cayenne";s:5:"notes";s:0:"";s:6:"chosen";s:0:"";s:8:"selected";s:0:"";}i:11;a:4:{s:8:"quantity";s:0:"";s:4:"unit";s:0:"";s:10:"ingredient";s:3:"sel";s:5:"notes";s:0:"";}}s:6:"chosen";s:0:"";}i:1;a:3:{s:12:"sectionTitle";s:10:"Brochettes";s:11:"ingredients";a:4:{i:0;a:6:{s:8:"quantity";s:1:"3";s:4:"unit";s:0:"";s:10:"ingredient";s:7:"tomates";s:5:"notes";s:0:"";s:6:"chosen";s:0:"";s:8:"selected";s:0:"";}i:1;a:6:{s:8:"quantity";s:1:"1";s:4:"unit";s:0:"";s:10:"ingredient";s:7:"poivron";s:5:"notes";s:0:"";s:6:"chosen";s:0:"";s:8:"selected";s:0:"";}i:2;a:6:{s:8:"quantity";s:1:"3";s:4:"unit";s:0:"";s:10:"ingredient";s:7:"oignons";s:5:"notes";s:0:"";s:6:"chosen";s:0:"";s:8:"selected";s:0:"";}i:3;a:6:{s:8:"quantity";s:3:"200";s:4:"unit";s:1:"g";s:10:"ingredient";s:11:"petit salé";s:5:"notes";s:18:"ou poitrine fumée";s:6:"chosen";s:0:"";s:8:"selected";s:0:"";}}s:6:"chosen";s:0:"";}i:2;a:2:{s:12:"sectionTitle";s:5:"Sauce";s:11:"ingredients";a:3:{i:0;a:6:{s:8:"quantity";s:1:"2";s:4:"unit";s:0:"";s:10:"ingredient";s:7:"tomates";s:5:"notes";s:0:"";s:6:"chosen";s:0:"";s:8:"selected";s:0:"";}i:1;a:6:{s:8:"quantity";s:3:"0,5";s:4:"unit";s:0:"";s:10:"ingredient";s:7:"poivron";s:5:"notes";s:0:"";s:6:"chosen";s:0:"";s:8:"selected";s:0:"";}i:2;a:6:{s:8:"quantity";s:0:"";s:4:"unit";s:0:"";s:10:"ingredient";s:20:"reste de la marinade";s:5:"notes";s:0:"";s:6:"chosen";s:0:"";s:8:"selected";s:0:"";}}}}s:17:"instructionsTitle";s:8:"Marinade";s:18:"recipeInstructions";a:4:{i:0;a:2:{s:12:"sectionTitle";s:0:"";s:11:"instruction";a:3:{i:0;a:8:{s:16:"instructionTitle";s:21:"Oignons et échalotes";s:11:"instruction";s:66:"<p>Peler et découper les oignons, échalotes en gros morceaux</p>";s:16:"instructionNotes";s:0:"";s:5:"image";s:0:"";s:13:"image_preview";s:0:"";s:8:"videoURL";s:0:"";s:6:"chosen";s:0:"";s:8:"selected";s:0:"";}i:1;a:8:{s:11:"instruction";s:46:"<p>peler l\'ail et le presser au presse-ail</p>";s:5:"image";s:0:"";s:13:"image_preview";s:0:"";s:8:"videoURL";s:0:"";s:16:"instructionNotes";s:0:"";s:16:"instructionTitle";s:3:"ail";s:6:"chosen";s:0:"";s:8:"selected";s:0:"";}i:2;a:8:{s:11:"instruction";s:214:"<p>Dans un grand saladier, bien mélanger tous les ingrédients de la marinade. Ajouter la dinde coupée en morceaux et bien mélanger à nouveau. Filmer et conserver à température ambiante au moins 12 heures</p>";s:5:"image";s:0:"";s:13:"image_preview";s:0:"";s:8:"videoURL";s:0:"";s:16:"instructionNotes";s:0:"";s:16:"instructionTitle";s:8:"Mélange";s:6:"chosen";s:0:"";s:8:"selected";s:0:"";}}}i:1;a:3:{s:12:"sectionTitle";s:40:"Réservation de la dinde après marinade";s:11:"instruction";a:1:{i:0;a:8:{s:16:"instructionTitle";s:35:"récupération de la dinde marinée";s:11:"instruction";s:89:"<p>Réserver les morceaux de dinde marinés. Mettre au frais le reste de la marinade.</p>";s:16:"instructionNotes";s:0:"";s:5:"image";s:0:"";s:13:"image_preview";s:0:"";s:8:"videoURL";s:0:"";s:6:"chosen";s:0:"";s:8:"selected";s:0:"";}}s:6:"chosen";s:0:"";}i:2;a:2:{s:12:"sectionTitle";s:27:"Réalisation des brochettes";s:11:"instruction";a:1:{i:0;a:8:{s:16:"instructionTitle";s:26:"composition des brochettes";s:11:"instruction";s:413:"<p>dans l\'ordre, composition de la brochette :</p>\n<ul>\n<li>- 1 petit salé</li>\n<li>- 1 poivron</li>\n<li><strong>- 1 dinde</strong></li>\n<li>- 1 oignon</li>\n<li><strong>- 1 dinde</strong></li>\n<li>- 1 tomate</li>\n<li><strong>- 1 dinde</strong></li>\n<li>- 1 tomate</li>\n<li><strong>- 1 dinde</strong></li>\n<li>- 1 oignon</li>\n<li><strong>- 1 dinde</strong></li>\n<li>- 1 poivron</li>\n<li>- 1 petit salé</li>\n</ul>";s:16:"instructionNotes";s:0:"";s:5:"image";s:2:"42";s:13:"image_preview";s:69:"http://miam.vicq.org/wp-content/uploads/2023/08/Brochette-150x150.png";s:8:"videoURL";s:0:"";s:6:"chosen";s:0:"";s:8:"selected";s:0:"";}}}i:3;a:2:{s:12:"sectionTitle";s:5:"Sauce";s:11:"instruction";a:1:{i:0;a:8:{s:16:"instructionTitle";s:7:"Cuisson";s:11:"instruction";s:350:"<p>Égoutter la marinade (en conservant le jus)</p>\n<p>Faire revenir le contenu de la marinade à feu vif pendant 5 minutes, puis baisser pour faire réduire.</p>\n<p>Ajouter le jus de la marinade, les tomates et le demi poivron coupés en dés. Laissez mijoter 15-25 minutes.</p>\n<p>Idéalement passer au mixer pour obtenir une consistance lisse.</p>";s:16:"instructionNotes";s:0:"";s:5:"image";s:0:"";s:13:"image_preview";s:0:"";s:8:"videoURL";s:0:"";s:6:"chosen";s:0:"";s:8:"selected";s:0:"";}}}}s:18:"enableImageGallery";s:2:"no";s:18:"imageGalleryImages";a:0:{}s:18:"enableVideoGallery";s:2:"no";s:16:"videoGalleryVids";a:0:{}s:15:"recipeDelicious";a:1:{i:0;a:2:{s:7:"drImage";s:0:"";s:6:"drLink";s:0:"";}}s:11:"servingSize";s:0:"";s:8:"servings";s:0:"";s:8:"calories";s:0:"";s:15:"caloriesFromFat";s:0:"";s:8:"totalFat";s:0:"";s:12:"saturatedFat";s:0:"";s:8:"transFat";s:0:"";s:11:"cholesterol";s:0:"";s:6:"sodium";s:0:"";s:9:"potassium";s:0:"";s:17:"totalCarbohydrate";s:0:"";s:12:"dietaryFiber";s:0:"";s:6:"sugars";s:0:"";s:7:"protein";s:0:"";s:8:"vitaminA";s:0:"";s:8:"vitaminC";s:0:"";s:7:"calcium";s:0:"";s:4:"iron";s:0:"";s:8:"vitaminD";s:0:"";s:8:"vitaminE";s:0:"";s:8:"vitaminK";s:0:"";s:7:"thiamin";s:0:"";s:10:"riboflavin";s:0:"";s:6:"niacin";s:0:"";s:9:"vitaminB6";s:0:"";s:6:"folate";s:0:"";s:10:"vitaminB12";s:0:"";s:6:"biotin";s:0:"";s:15:"pantothenicAcid";s:0:"";s:10:"phosphorus";s:0:"";s:6:"iodine";s:0:"";s:9:"magnesium";s:0:"";s:4:"zinc";s:0:"";s:8:"selenium";s:0:"";s:6:"copper";s:0:"";s:9:"manganese";s:0:"";s:8:"chromium";s:0:"";s:10:"molybdenum";s:0:"";s:8:"chloride";s:0:"";s:11:"recipeNotes";s:0:"";s:9:"faqsTitle";s:26:"Frequently Asked Questions";s:10:"recipeFAQs";a:0:{}}');
INSERT INTO `miam_postmeta` VALUES (21,15,'_dr_best_season','summer');
INSERT INTO `miam_postmeta` VALUES (22,15,'_dr_difficulty_level','beginner');
INSERT INTO `miam_postmeta` VALUES (23,15,'_dr_recipe_ingredients','a:18:{i:0;s:14:"Filet de dinde";i:1;s:9:"Vin blanc";i:2;s:5:"Huile";i:3;s:4:"Aïl";i:4;s:7:"Oignons";i:5;s:11:"échalottes";i:6;s:10:"Sauce soja";i:7;s:13:"Pate de curry";i:8;s:5:"Saté";i:9;s:17:"Piment de Cayenne";i:10;s:3:"Sel";i:11;s:7:"Tomates";i:12;s:7:"Poivron";i:13;s:7:"Oignons";i:14;s:11:"Petit salé";i:15;s:7:"Tomates";i:16;s:7:"Poivron";i:17;s:20:"Reste de la marinade";}');
INSERT INTO `miam_postmeta` VALUES (24,15,'_dr_ingredient_count','18');
INSERT INTO `miam_postmeta` VALUES (25,15,'_delicious_recipes_view_count','56');
INSERT INTO `miam_postmeta` VALUES (26,16,'_menu_item_type','custom');
INSERT INTO `miam_postmeta` VALUES (27,16,'_menu_item_menu_item_parent','0');
INSERT INTO `miam_postmeta` VALUES (28,16,'_menu_item_object_id','16');
INSERT INTO `miam_postmeta` VALUES (29,16,'_menu_item_object','custom');
INSERT INTO `miam_postmeta` VALUES (30,16,'_menu_item_target','');
INSERT INTO `miam_postmeta` VALUES (31,16,'_menu_item_classes','a:1:{i:0;s:0:"";}');
INSERT INTO `miam_postmeta` VALUES (32,16,'_menu_item_xfn','');
INSERT INTO `miam_postmeta` VALUES (33,16,'_menu_item_url','http://miam.vicq.org/');
INSERT INTO `miam_postmeta` VALUES (34,16,'_menu_item_orphaned','1691329227');
INSERT INTO `miam_postmeta` VALUES (35,17,'_menu_item_type','post_type');
INSERT INTO `miam_postmeta` VALUES (36,17,'_menu_item_menu_item_parent','0');
INSERT INTO `miam_postmeta` VALUES (37,17,'_menu_item_object_id','14');
INSERT INTO `miam_postmeta` VALUES (38,17,'_menu_item_object','page');
INSERT INTO `miam_postmeta` VALUES (39,17,'_menu_item_target','');
INSERT INTO `miam_postmeta` VALUES (40,17,'_menu_item_classes','a:1:{i:0;s:0:"";}');
INSERT INTO `miam_postmeta` VALUES (41,17,'_menu_item_xfn','');
INSERT INTO `miam_postmeta` VALUES (42,17,'_menu_item_url','');
INSERT INTO `miam_postmeta` VALUES (43,17,'_menu_item_orphaned','1691329227');
INSERT INTO `miam_postmeta` VALUES (44,18,'_menu_item_type','post_type');
INSERT INTO `miam_postmeta` VALUES (45,18,'_menu_item_menu_item_parent','0');
INSERT INTO `miam_postmeta` VALUES (46,18,'_menu_item_object_id','11');
INSERT INTO `miam_postmeta` VALUES (47,18,'_menu_item_object','page');
INSERT INTO `miam_postmeta` VALUES (48,18,'_menu_item_target','');
INSERT INTO `miam_postmeta` VALUES (49,18,'_menu_item_classes','a:1:{i:0;s:0:"";}');
INSERT INTO `miam_postmeta` VALUES (50,18,'_menu_item_xfn','');
INSERT INTO `miam_postmeta` VALUES (51,18,'_menu_item_url','');
INSERT INTO `miam_postmeta` VALUES (52,18,'_menu_item_orphaned','1691329227');
INSERT INTO `miam_postmeta` VALUES (53,19,'_menu_item_type','post_type');
INSERT INTO `miam_postmeta` VALUES (54,19,'_menu_item_menu_item_parent','0');
INSERT INTO `miam_postmeta` VALUES (55,19,'_menu_item_object_id','10');
INSERT INTO `miam_postmeta` VALUES (56,19,'_menu_item_object','page');
INSERT INTO `miam_postmeta` VALUES (57,19,'_menu_item_target','');
INSERT INTO `miam_postmeta` VALUES (58,19,'_menu_item_classes','a:1:{i:0;s:0:"";}');
INSERT INTO `miam_postmeta` VALUES (59,19,'_menu_item_xfn','');
INSERT INTO `miam_postmeta` VALUES (60,19,'_menu_item_url','');
INSERT INTO `miam_postmeta` VALUES (61,19,'_menu_item_orphaned','1691329227');
INSERT INTO `miam_postmeta` VALUES (62,20,'_menu_item_type','post_type');
INSERT INTO `miam_postmeta` VALUES (63,20,'_menu_item_menu_item_parent','0');
INSERT INTO `miam_postmeta` VALUES (64,20,'_menu_item_object_id','13');
INSERT INTO `miam_postmeta` VALUES (65,20,'_menu_item_object','page');
INSERT INTO `miam_postmeta` VALUES (66,20,'_menu_item_target','');
INSERT INTO `miam_postmeta` VALUES (67,20,'_menu_item_classes','a:1:{i:0;s:0:"";}');
INSERT INTO `miam_postmeta` VALUES (68,20,'_menu_item_xfn','');
INSERT INTO `miam_postmeta` VALUES (69,20,'_menu_item_url','');
INSERT INTO `miam_postmeta` VALUES (70,20,'_menu_item_orphaned','1691329227');
INSERT INTO `miam_postmeta` VALUES (71,21,'_menu_item_type','post_type');
INSERT INTO `miam_postmeta` VALUES (72,21,'_menu_item_menu_item_parent','0');
INSERT INTO `miam_postmeta` VALUES (73,21,'_menu_item_object_id','2');
INSERT INTO `miam_postmeta` VALUES (74,21,'_menu_item_object','page');
INSERT INTO `miam_postmeta` VALUES (75,21,'_menu_item_target','');
INSERT INTO `miam_postmeta` VALUES (76,21,'_menu_item_classes','a:1:{i:0;s:0:"";}');
INSERT INTO `miam_postmeta` VALUES (77,21,'_menu_item_xfn','');
INSERT INTO `miam_postmeta` VALUES (78,21,'_menu_item_url','');
INSERT INTO `miam_postmeta` VALUES (79,21,'_menu_item_orphaned','1691329227');
INSERT INTO `miam_postmeta` VALUES (80,22,'_menu_item_type','post_type');
INSERT INTO `miam_postmeta` VALUES (81,22,'_menu_item_menu_item_parent','0');
INSERT INTO `miam_postmeta` VALUES (82,22,'_menu_item_object_id','9');
INSERT INTO `miam_postmeta` VALUES (83,22,'_menu_item_object','page');
INSERT INTO `miam_postmeta` VALUES (84,22,'_menu_item_target','');
INSERT INTO `miam_postmeta` VALUES (85,22,'_menu_item_classes','a:1:{i:0;s:0:"";}');
INSERT INTO `miam_postmeta` VALUES (86,22,'_menu_item_xfn','');
INSERT INTO `miam_postmeta` VALUES (87,22,'_menu_item_url','');
INSERT INTO `miam_postmeta` VALUES (88,22,'_menu_item_orphaned','1691329227');
INSERT INTO `miam_postmeta` VALUES (89,23,'_menu_item_type','post_type');
INSERT INTO `miam_postmeta` VALUES (90,23,'_menu_item_menu_item_parent','0');
INSERT INTO `miam_postmeta` VALUES (91,23,'_menu_item_object_id','5');
INSERT INTO `miam_postmeta` VALUES (92,23,'_menu_item_object','page');
INSERT INTO `miam_postmeta` VALUES (93,23,'_menu_item_target','');
INSERT INTO `miam_postmeta` VALUES (94,23,'_menu_item_classes','a:1:{i:0;s:0:"";}');
INSERT INTO `miam_postmeta` VALUES (95,23,'_menu_item_xfn','');
INSERT INTO `miam_postmeta` VALUES (96,23,'_menu_item_url','');
INSERT INTO `miam_postmeta` VALUES (97,23,'_menu_item_orphaned','1691329227');
INSERT INTO `miam_postmeta` VALUES (98,24,'_menu_item_type','post_type');
INSERT INTO `miam_postmeta` VALUES (99,24,'_menu_item_menu_item_parent','0');
INSERT INTO `miam_postmeta` VALUES (100,24,'_menu_item_object_id','6');
INSERT INTO `miam_postmeta` VALUES (101,24,'_menu_item_object','page');
INSERT INTO `miam_postmeta` VALUES (102,24,'_menu_item_target','');
INSERT INTO `miam_postmeta` VALUES (103,24,'_menu_item_classes','a:1:{i:0;s:0:"";}');
INSERT INTO `miam_postmeta` VALUES (104,24,'_menu_item_xfn','');
INSERT INTO `miam_postmeta` VALUES (105,24,'_menu_item_url','');
INSERT INTO `miam_postmeta` VALUES (106,24,'_menu_item_orphaned','1691329227');
INSERT INTO `miam_postmeta` VALUES (107,25,'_menu_item_type','post_type');
INSERT INTO `miam_postmeta` VALUES (108,25,'_menu_item_menu_item_parent','0');
INSERT INTO `miam_postmeta` VALUES (109,25,'_menu_item_object_id','12');
INSERT INTO `miam_postmeta` VALUES (110,25,'_menu_item_object','page');
INSERT INTO `miam_postmeta` VALUES (111,25,'_menu_item_target','');
INSERT INTO `miam_postmeta` VALUES (112,25,'_menu_item_classes','a:1:{i:0;s:0:"";}');
INSERT INTO `miam_postmeta` VALUES (113,25,'_menu_item_xfn','');
INSERT INTO `miam_postmeta` VALUES (114,25,'_menu_item_url','');
INSERT INTO `miam_postmeta` VALUES (115,25,'_menu_item_orphaned','1691329227');
INSERT INTO `miam_postmeta` VALUES (119,11,'_edit_last','1');
INSERT INTO `miam_postmeta` VALUES (120,11,'_edit_lock','1691331044:1');
INSERT INTO `miam_postmeta` VALUES (121,14,'_edit_last','1');
INSERT INTO `miam_postmeta` VALUES (122,14,'_edit_lock','1691344515:1');
INSERT INTO `miam_postmeta` VALUES (123,10,'_edit_last','1');
INSERT INTO `miam_postmeta` VALUES (124,10,'_edit_lock','1691331058:1');
INSERT INTO `miam_postmeta` VALUES (125,13,'_edit_last','1');
INSERT INTO `miam_postmeta` VALUES (126,13,'_edit_lock','1691331068:1');
INSERT INTO `miam_postmeta` VALUES (127,9,'_edit_last','1');
INSERT INTO `miam_postmeta` VALUES (128,9,'_edit_lock','1691331086:1');
INSERT INTO `miam_postmeta` VALUES (131,36,'_edit_lock','1693743163:1');
INSERT INTO `miam_postmeta` VALUES (132,36,'delicious_recipes_metadata','a:64:{s:14:"recipeSubtitle";s:67:"Pancakes américains dont la recette a été affinée avec le temps";s:17:"recipeDescription";s:298:"<p>Il s\'agit de la recette de pancakes américains proposée par un chef américain installé à Paris (Harrys Bar). Il s\'agit de faire cela "à l\'américaine" : simplement et rapidement, en préparant à part les ingrédients secs d\'un coté et les liquides d\'un autre, avant de les mélanger.</p>";s:14:"recipeKeywords";s:25:"pancakes, petit-déjeuner";s:15:"difficultyLevel";s:8:"beginner";s:8:"prepTime";s:1:"5";s:12:"prepTimeUnit";s:3:"min";s:8:"cookTime";s:2:"10";s:12:"cookTimeUnit";s:3:"min";s:8:"restTime";s:1:"0";s:12:"restTimeUnit";s:3:"min";s:14:"recipeCalories";s:0:"";s:10:"bestSeason";s:9:"available";s:12:"noOfServings";s:1:"4";s:15:"ingredientTitle";s:12:"Ingrédients";s:17:"recipeIngredients";a:2:{i:0;a:2:{s:12:"sectionTitle";s:17:"Ingrédients secs";s:11:"ingredients";a:3:{i:0;a:6:{s:8:"quantity";s:3:"125";s:4:"unit";s:1:"g";s:10:"ingredient";s:6:"Farine";s:5:"notes";s:39:"1/3 complète, 1/3 sarasin, 1/3 blanche";s:6:"chosen";s:0:"";s:8:"selected";s:0:"";}i:1;a:6:{s:8:"quantity";s:2:"25";s:4:"unit";s:1:"g";s:10:"ingredient";s:16:"Flocons d\'avoine";s:5:"notes";s:0:"";s:6:"chosen";s:0:"";s:8:"selected";s:0:"";}i:2;a:6:{s:8:"quantity";s:1:"7";s:4:"unit";s:1:"g";s:10:"ingredient";s:15:"Levure chimique";s:5:"notes";s:0:"";s:6:"chosen";s:0:"";s:8:"selected";s:0:"";}}}i:1;a:2:{s:12:"sectionTitle";s:21:"Ingrédients non secs";s:11:"ingredients";a:3:{i:0;a:6:{s:8:"quantity";s:3:"225";s:4:"unit";s:1:"g";s:10:"ingredient";s:4:"lait";s:5:"notes";s:0:"";s:6:"chosen";s:0:"";s:8:"selected";s:0:"";}i:1;a:6:{s:8:"quantity";s:1:"1";s:4:"unit";s:0:"";s:10:"ingredient";s:4:"oeuf";s:5:"notes";s:0:"";s:6:"chosen";s:0:"";s:8:"selected";s:0:"";}i:2;a:6:{s:8:"quantity";s:2:"36";s:4:"unit";s:1:"g";s:10:"ingredient";s:5:"huile";s:5:"notes";s:9:"tournesol";s:6:"chosen";s:0:"";s:8:"selected";s:0:"";}}}}s:17:"instructionsTitle";s:12:"Instructions";s:18:"recipeInstructions";a:1:{i:0;a:2:{s:12:"sectionTitle";s:0:"";s:11:"instruction";a:4:{i:0;a:8:{s:16:"instructionTitle";s:27:"Mélanger les aliments secs";s:11:"instruction";s:111:"<p>Dans un saladier (ou mieux, un shaker), mélanger la (les) farine(s), les flocons d\'avoine et la levure.</p>";s:16:"instructionNotes";s:0:"";s:5:"image";s:0:"";s:13:"image_preview";s:0:"";s:8:"videoURL";s:0:"";s:6:"chosen";s:0:"";s:8:"selected";s:0:"";}i:1;a:8:{s:11:"instruction";s:93:"<p>Dans un récipient, mélanger le lait, l\'huile et l\'oeuf vigoureusement avec un fouet.</p>";s:5:"image";s:0:"";s:13:"image_preview";s:0:"";s:8:"videoURL";s:0:"";s:16:"instructionNotes";s:0:"";s:16:"instructionTitle";s:31:"Mélanger les aliments non secs";s:6:"chosen";s:0:"";s:8:"selected";s:0:"";}i:2;a:8:{s:11:"instruction";s:104:"<p>Dans un récipient, mélanger les deux composants (secs et humides) énergiquement avec un fouet.</p>";s:5:"image";s:0:"";s:13:"image_preview";s:0:"";s:8:"videoURL";s:0:"";s:16:"instructionNotes";s:144:"Pour ma part, j\'utilise un shaker à crêpes. Je mélange les aliments secs, puis j\'ajoute les aliments humides et enfin je remue vigoureusement";s:16:"instructionTitle";s:14:"Mélange final";s:6:"chosen";s:0:"";s:8:"selected";s:0:"";}i:3;a:8:{s:11:"instruction";s:110:"<p>Cuire à la poêle anti-adhésive. Servir chaud avec du miel, du sirop d\'érable, de la confiture, etc.</p>";s:5:"image";s:2:"37";s:13:"image_preview";s:68:"http://miam.vicq.org/wp-content/uploads/2023/08/pancakes-150x150.jpg";s:8:"videoURL";s:0:"";s:16:"instructionNotes";s:0:"";s:16:"instructionTitle";s:7:"Cuisson";s:6:"chosen";s:0:"";s:8:"selected";s:0:"";}}}}s:18:"enableImageGallery";a:1:{i:0;s:3:"yes";}s:18:"imageGalleryImages";a:0:{}s:18:"enableVideoGallery";s:2:"no";s:16:"videoGalleryVids";a:0:{}s:15:"recipeDelicious";a:1:{i:0;a:2:{s:7:"drImage";s:0:"";s:6:"drLink";s:0:"";}}s:11:"servingSize";s:0:"";s:8:"servings";s:0:"";s:8:"calories";s:0:"";s:15:"caloriesFromFat";s:0:"";s:8:"totalFat";s:0:"";s:12:"saturatedFat";s:0:"";s:8:"transFat";s:0:"";s:11:"cholesterol";s:0:"";s:6:"sodium";s:0:"";s:9:"potassium";s:0:"";s:17:"totalCarbohydrate";s:0:"";s:12:"dietaryFiber";s:0:"";s:6:"sugars";s:0:"";s:7:"protein";s:0:"";s:8:"vitaminA";s:0:"";s:8:"vitaminC";s:0:"";s:7:"calcium";s:0:"";s:4:"iron";s:0:"";s:8:"vitaminD";s:0:"";s:8:"vitaminE";s:0:"";s:8:"vitaminK";s:0:"";s:7:"thiamin";s:0:"";s:10:"riboflavin";s:0:"";s:6:"niacin";s:0:"";s:9:"vitaminB6";s:0:"";s:6:"folate";s:0:"";s:10:"vitaminB12";s:0:"";s:6:"biotin";s:0:"";s:15:"pantothenicAcid";s:0:"";s:10:"phosphorus";s:0:"";s:6:"iodine";s:0:"";s:9:"magnesium";s:0:"";s:4:"zinc";s:0:"";s:8:"selenium";s:0:"";s:6:"copper";s:0:"";s:9:"manganese";s:0:"";s:8:"chromium";s:0:"";s:10:"molybdenum";s:0:"";s:8:"chloride";s:0:"";s:11:"recipeNotes";s:0:"";s:9:"faqsTitle";s:26:"Frequently Asked Questions";s:10:"recipeFAQs";a:0:{}}');
INSERT INTO `miam_postmeta` VALUES (133,36,'_dr_best_season','available');
INSERT INTO `miam_postmeta` VALUES (134,36,'_dr_difficulty_level','beginner');
INSERT INTO `miam_postmeta` VALUES (135,36,'_edit_last','1');
INSERT INTO `miam_postmeta` VALUES (136,36,'_delicious_recipes_view_count','77');
INSERT INTO `miam_postmeta` VALUES (137,36,'_dr_recipe_ingredients','a:6:{i:0;s:6:"Farine";i:1;s:16:"Flocons d\'avoine";i:2;s:15:"Levure chimique";i:3;s:4:"Lait";i:4;s:4:"Oeuf";i:5;s:5:"Huile";}');
INSERT INTO `miam_postmeta` VALUES (138,36,'_dr_ingredient_count','6');
INSERT INTO `miam_postmeta` VALUES (139,37,'_wp_attached_file','2023/08/pancakes.jpg');
INSERT INTO `miam_postmeta` VALUES (140,37,'_wp_attachment_metadata','a:6:{s:5:"width";i:225;s:6:"height";i:225;s:4:"file";s:20:"2023/08/pancakes.jpg";s:8:"filesize";i:7994;s:5:"sizes";a:4:{s:9:"thumbnail";a:5:{s:4:"file";s:20:"pancakes-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:5870;}s:21:"recipe-feat-thumbnail";a:5:{s:4:"file";s:20:"pancakes-124x166.jpg";s:5:"width";i:124;s:6:"height";i:166;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:5627;}s:19:"recipe-author-image";a:5:{s:4:"file";s:20:"pancakes-156x207.jpg";s:5:"width";i:156;s:6:"height";i:207;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:7990;}s:21:"blossom-recipe-schema";a:5:{s:4:"file";s:18:"pancakes-60x60.jpg";s:5:"width";i:60;s:6:"height";i:60;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:1505;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `miam_postmeta` VALUES (141,36,'_thumbnail_id','37');
INSERT INTO `miam_postmeta` VALUES (142,1,'_edit_lock','1691507879:1');
INSERT INTO `miam_postmeta` VALUES (145,1,'_edit_last','1');
INSERT INTO `miam_postmeta` VALUES (151,15,'_edit_last','1');
INSERT INTO `miam_postmeta` VALUES (152,42,'_wp_attached_file','2023/08/Brochette.png');
INSERT INTO `miam_postmeta` VALUES (153,42,'_wp_attachment_metadata','a:6:{s:5:"width";i:1746;s:6:"height";i:442;s:4:"file";s:21:"2023/08/Brochette.png";s:8:"filesize";i:56759;s:5:"sizes";a:25:{s:6:"medium";a:5:{s:4:"file";s:20:"Brochette-300x76.png";s:5:"width";i:300;s:6:"height";i:76;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:10740;}s:5:"large";a:5:{s:4:"file";s:22:"Brochette-1024x259.png";s:5:"width";i:1024;s:6:"height";i:259;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:53217;}s:9:"thumbnail";a:5:{s:4:"file";s:21:"Brochette-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:7986;}s:12:"medium_large";a:5:{s:4:"file";s:21:"Brochette-768x194.png";s:5:"width";i:768;s:6:"height";i:194;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:36794;}s:21:"recipe-feat-thumbnail";a:5:{s:4:"file";s:21:"Brochette-124x166.png";s:5:"width";i:124;s:6:"height";i:166;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:7548;}s:16:"recipe-feat-tall";a:5:{s:4:"file";s:21:"Brochette-290x386.png";s:5:"width";i:290;s:6:"height";i:386;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:21619;}s:19:"recipe-feat-gallery";a:5:{s:4:"file";s:21:"Brochette-768x442.png";s:5:"width";i:768;s:6:"height";i:442;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:16403;}s:17:"recipe-feat-print";a:5:{s:4:"file";s:21:"Brochette-595x442.png";s:5:"width";i:595;s:6:"height";i:442;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:12913;}s:19:"recipe-archive-list";a:5:{s:4:"file";s:21:"Brochette-450x442.png";s:5:"width";i:450;s:6:"height";i:442;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:10933;}s:19:"recipe-archive-grid";a:5:{s:4:"file";s:21:"Brochette-345x442.png";s:5:"width";i:345;s:6:"height";i:442;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:9628;}s:19:"recipe-author-image";a:5:{s:4:"file";s:21:"Brochette-156x207.png";s:5:"width";i:156;s:6:"height";i:207;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:10152;}s:28:"delrecpe-structured-data-1_1";a:5:{s:4:"file";s:21:"Brochette-500x442.png";s:5:"width";i:500;s:6:"height";i:442;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:11649;}s:28:"delrecpe-structured-data-4_3";a:5:{s:4:"file";s:21:"Brochette-500x375.png";s:5:"width";i:500;s:6:"height";i:375;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:30238;}s:29:"delrecpe-structured-data-16_9";a:5:{s:4:"file";s:21:"Brochette-480x270.png";s:5:"width";i:480;s:6:"height";i:270;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:30574;}s:9:"1536x1536";a:5:{s:4:"file";s:22:"Brochette-1536x389.png";s:5:"width";i:1536;s:6:"height";i:389;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:87064;}s:19:"cookery-lite-slider";a:5:{s:4:"file";s:21:"Brochette-480x442.png";s:5:"width";i:480;s:6:"height";i:442;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:11364;}s:28:"cookery-lite-featured-recipe";a:5:{s:4:"file";s:21:"Brochette-384x442.png";s:5:"width";i:384;s:6:"height";i:442;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:10090;}s:17:"cookery-lite-blog";a:5:{s:4:"file";s:21:"Brochette-286x382.png";s:5:"width";i:286;s:6:"height";i:382;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:21478;}s:25:"cookery-lite-blog-list-lg";a:5:{s:4:"file";s:21:"Brochette-768x442.png";s:5:"width";i:768;s:6:"height";i:442;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:16403;}s:23:"cookery-lite-blog-large";a:5:{s:4:"file";s:22:"Brochette-1214x442.png";s:5:"width";i:1214;s:6:"height";i:442;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:26398;}s:25:"cookery-lite-blog-archive";a:5:{s:4:"file";s:21:"Brochette-307x410.png";s:5:"width";i:307;s:6:"height";i:410;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:22999;}s:18:"cookery-lite-promo";a:5:{s:4:"file";s:21:"Brochette-366x231.png";s:5:"width";i:366;s:6:"height";i:231;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:22386;}s:19:"cookery-lite-single";a:5:{s:4:"file";s:21:"Brochette-768x442.png";s:5:"width";i:768;s:6:"height";i:442;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:16403;}s:23:"cookery-lite-single-two";a:5:{s:4:"file";s:22:"Brochette-1220x442.png";s:5:"width";i:1220;s:6:"height";i:442;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:26398;}s:20:"cookery-lite-related";a:5:{s:4:"file";s:21:"Brochette-384x442.png";s:5:"width";i:384;s:6:"height";i:442;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:10090;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `miam_postmeta` VALUES (167,50,'_wp_attached_file','2023/08/brochette-photo-small.png');
INSERT INTO `miam_postmeta` VALUES (168,50,'_wp_attachment_metadata','a:6:{s:5:"width";i:672;s:6:"height";i:368;s:4:"file";s:33:"2023/08/brochette-photo-small.png";s:8:"filesize";i:584556;s:5:"sizes";a:17:{s:6:"medium";a:5:{s:4:"file";s:33:"brochette-photo-small-300x164.png";s:5:"width";i:300;s:6:"height";i:164;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:116552;}s:9:"thumbnail";a:5:{s:4:"file";s:33:"brochette-photo-small-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:55328;}s:21:"recipe-feat-thumbnail";a:5:{s:4:"file";s:33:"brochette-photo-small-124x166.png";s:5:"width";i:124;s:6:"height";i:166;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:50034;}s:16:"recipe-feat-tall";a:5:{s:4:"file";s:33:"brochette-photo-small-290x368.png";s:5:"width";i:290;s:6:"height";i:368;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:222516;}s:17:"recipe-feat-print";a:5:{s:4:"file";s:33:"brochette-photo-small-595x368.png";s:5:"width";i:595;s:6:"height";i:368;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:445560;}s:19:"recipe-archive-list";a:5:{s:4:"file";s:33:"brochette-photo-small-450x368.png";s:5:"width";i:450;s:6:"height";i:368;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:343085;}s:19:"recipe-archive-grid";a:5:{s:4:"file";s:33:"brochette-photo-small-345x368.png";s:5:"width";i:345;s:6:"height";i:368;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:264640;}s:19:"recipe-author-image";a:5:{s:4:"file";s:33:"brochette-photo-small-156x207.png";s:5:"width";i:156;s:6:"height";i:207;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:75046;}s:28:"delrecpe-structured-data-1_1";a:5:{s:4:"file";s:33:"brochette-photo-small-500x368.png";s:5:"width";i:500;s:6:"height";i:368;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:379343;}s:28:"delrecpe-structured-data-4_3";a:5:{s:4:"file";s:33:"brochette-photo-small-500x368.png";s:5:"width";i:500;s:6:"height";i:368;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:379343;}s:29:"delrecpe-structured-data-16_9";a:5:{s:4:"file";s:33:"brochette-photo-small-480x270.png";s:5:"width";i:480;s:6:"height";i:270;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:272352;}s:19:"cookery-lite-slider";a:5:{s:4:"file";s:33:"brochette-photo-small-480x368.png";s:5:"width";i:480;s:6:"height";i:368;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:364791;}s:28:"cookery-lite-featured-recipe";a:5:{s:4:"file";s:33:"brochette-photo-small-384x368.png";s:5:"width";i:384;s:6:"height";i:368;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:293843;}s:17:"cookery-lite-blog";a:5:{s:4:"file";s:33:"brochette-photo-small-286x368.png";s:5:"width";i:286;s:6:"height";i:368;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:219566;}s:25:"cookery-lite-blog-archive";a:5:{s:4:"file";s:33:"brochette-photo-small-307x368.png";s:5:"width";i:307;s:6:"height";i:368;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:235237;}s:18:"cookery-lite-promo";a:5:{s:4:"file";s:33:"brochette-photo-small-366x231.png";s:5:"width";i:366;s:6:"height";i:231;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:186660;}s:20:"cookery-lite-related";a:5:{s:4:"file";s:33:"brochette-photo-small-384x368.png";s:5:"width";i:384;s:6:"height";i:368;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:293843;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `miam_postmeta` VALUES (169,15,'_thumbnail_id','50');
INSERT INTO `miam_postmeta` VALUES (231,1,'_cookery_lite_sidebar_layout','default-sidebar');
INSERT INTO `miam_postmeta` VALUES (233,63,'_customize_changeset_uuid','7eb239a3-318a-485b-af64-18f9d9df175f');
INSERT INTO `miam_postmeta` VALUES (247,68,'_customize_changeset_uuid','95e2fe57-07fa-4a17-9838-29999e94c955');
INSERT INTO `miam_postmeta` VALUES (272,75,'_menu_item_type','custom');
INSERT INTO `miam_postmeta` VALUES (273,75,'_menu_item_menu_item_parent','0');
INSERT INTO `miam_postmeta` VALUES (274,75,'_menu_item_object_id','75');
INSERT INTO `miam_postmeta` VALUES (275,75,'_menu_item_object','custom');
INSERT INTO `miam_postmeta` VALUES (276,75,'_menu_item_target','');
INSERT INTO `miam_postmeta` VALUES (277,75,'_menu_item_classes','a:1:{i:0;s:0:"";}');
INSERT INTO `miam_postmeta` VALUES (278,75,'_menu_item_xfn','');
INSERT INTO `miam_postmeta` VALUES (279,75,'_menu_item_url','https://vicq.org/aliments');
INSERT INTO `miam_postmeta` VALUES (280,76,'_menu_item_type','post_type_archive');
INSERT INTO `miam_postmeta` VALUES (281,76,'_menu_item_menu_item_parent','0');
INSERT INTO `miam_postmeta` VALUES (282,76,'_menu_item_object_id','0');
INSERT INTO `miam_postmeta` VALUES (283,76,'_menu_item_object','recipe');
INSERT INTO `miam_postmeta` VALUES (284,76,'_menu_item_target','');
INSERT INTO `miam_postmeta` VALUES (285,76,'_menu_item_classes','a:1:{i:0;s:0:"";}');
INSERT INTO `miam_postmeta` VALUES (286,76,'_menu_item_xfn','');
INSERT INTO `miam_postmeta` VALUES (287,76,'_menu_item_url','');
INSERT INTO `miam_postmeta` VALUES (288,77,'_menu_item_type','taxonomy');
INSERT INTO `miam_postmeta` VALUES (289,77,'_menu_item_menu_item_parent','76');
INSERT INTO `miam_postmeta` VALUES (290,77,'_menu_item_object_id','30');
INSERT INTO `miam_postmeta` VALUES (291,77,'_menu_item_object','recipe-course');
INSERT INTO `miam_postmeta` VALUES (292,77,'_menu_item_target','');
INSERT INTO `miam_postmeta` VALUES (293,77,'_menu_item_classes','a:1:{i:0;s:0:"";}');
INSERT INTO `miam_postmeta` VALUES (294,77,'_menu_item_xfn','');
INSERT INTO `miam_postmeta` VALUES (295,77,'_menu_item_url','');
INSERT INTO `miam_postmeta` VALUES (296,78,'_menu_item_type','taxonomy');
INSERT INTO `miam_postmeta` VALUES (297,78,'_menu_item_menu_item_parent','76');
INSERT INTO `miam_postmeta` VALUES (298,78,'_menu_item_object_id','31');
INSERT INTO `miam_postmeta` VALUES (299,78,'_menu_item_object','recipe-course');
INSERT INTO `miam_postmeta` VALUES (300,78,'_menu_item_target','');
INSERT INTO `miam_postmeta` VALUES (301,78,'_menu_item_classes','a:1:{i:0;s:0:"";}');
INSERT INTO `miam_postmeta` VALUES (302,78,'_menu_item_xfn','');
INSERT INTO `miam_postmeta` VALUES (303,78,'_menu_item_url','');
INSERT INTO `miam_postmeta` VALUES (304,79,'_menu_item_type','taxonomy');
INSERT INTO `miam_postmeta` VALUES (305,79,'_menu_item_menu_item_parent','76');
INSERT INTO `miam_postmeta` VALUES (306,79,'_menu_item_object_id','32');
INSERT INTO `miam_postmeta` VALUES (307,79,'_menu_item_object','recipe-course');
INSERT INTO `miam_postmeta` VALUES (308,79,'_menu_item_target','');
INSERT INTO `miam_postmeta` VALUES (309,79,'_menu_item_classes','a:1:{i:0;s:0:"";}');
INSERT INTO `miam_postmeta` VALUES (310,79,'_menu_item_xfn','');
INSERT INTO `miam_postmeta` VALUES (311,79,'_menu_item_url','');
INSERT INTO `miam_postmeta` VALUES (320,85,'_edit_lock','1703266932:1');
INSERT INTO `miam_postmeta` VALUES (321,85,'delicious_recipes_metadata','a:68:{s:14:"recipeSubtitle";s:12:"Riz à sushi";s:17:"recipeDescription";s:36:"<p>Ma synthèse du riz à sushi.</p>";s:14:"recipeKeywords";s:10:"riz, sushi";s:15:"difficultyLevel";s:12:"intermediate";s:8:"prepTime";s:2:"65";s:12:"prepTimeUnit";s:3:"min";s:8:"cookTime";s:2:"30";s:12:"cookTimeUnit";s:3:"min";s:11:"cookingTemp";s:0:"";s:15:"cookingTempUnit";s:1:"C";s:8:"restTime";s:2:"45";s:12:"restTimeUnit";s:3:"min";s:14:"recipeCalories";s:0:"";s:10:"bestSeason";s:0:"";s:13:"estimatedCost";s:0:"";s:17:"estimatedCostCurr";s:0:"";s:12:"noOfServings";s:1:"1";s:15:"ingredientTitle";s:12:"Riz à sushi";s:17:"recipeIngredients";a:1:{i:0;a:2:{s:12:"sectionTitle";s:0:"";s:11:"ingredients";a:5:{i:0;a:6:{s:8:"quantity";s:3:"150";s:4:"unit";s:1:"g";s:10:"ingredient";s:21:"Riz japonais à sushi";s:5:"notes";s:0:"";s:6:"chosen";s:0:"";s:8:"selected";s:0:"";}i:1;a:6:{s:8:"quantity";s:3:"150";s:4:"unit";s:2:"ml";s:10:"ingredient";s:3:"Eau";s:5:"notes";s:0:"";s:6:"chosen";s:0:"";s:8:"selected";s:0:"";}i:2;a:6:{s:8:"quantity";s:1:"2";s:4:"unit";s:4:"tbsp";s:10:"ingredient";s:15:"Vinaigre de riz";s:5:"notes";s:0:"";s:6:"chosen";s:0:"";s:8:"selected";s:0:"";}i:3;a:6:{s:8:"quantity";s:1:"1";s:4:"unit";s:4:"tbsp";s:10:"ingredient";s:5:"Sucre";s:5:"notes";s:0:"";s:6:"chosen";s:0:"";s:8:"selected";s:0:"";}i:4;a:6:{s:8:"quantity";s:4:"0,25";s:4:"unit";s:4:"tbsp";s:10:"ingredient";s:3:"sel";s:5:"notes";s:0:"";s:6:"chosen";s:0:"";s:8:"selected";s:0:"";}}}}s:17:"instructionsTitle";s:12:"Instructions";s:18:"recipeInstructions";a:3:{i:0;a:2:{s:12:"sectionTitle";s:13:"Lavage du riz";s:11:"instruction";a:2:{i:0;a:8:{s:16:"instructionTitle";s:0:"";s:11:"instruction";s:81:"<p>Laver le riz sans un saladier jusqu\'à laisser l\'eau claire (5, 6 fois...)</p>";s:16:"instructionNotes";s:0:"";s:5:"image";s:0:"";s:13:"image_preview";s:0:"";s:8:"videoURL";s:0:"";s:6:"chosen";s:0:"";s:8:"selected";s:0:"";}i:1;a:8:{s:11:"instruction";s:76:"<p>Égoutter ; attendre 60 min dans l\'égoutoir, le riz est devenu blanc</p>";s:5:"image";s:0:"";s:13:"image_preview";s:0:"";s:8:"videoURL";s:0:"";s:16:"instructionNotes";s:0:"";s:16:"instructionTitle";s:0:"";s:6:"chosen";s:0:"";s:8:"selected";s:0:"";}}}i:1;a:3:{s:12:"sectionTitle";s:50:"Préparation de la sauce (pendant le repos du riz)";s:11:"instruction";a:2:{i:0;a:8:{s:16:"instructionTitle";s:0:"";s:11:"instruction";s:78:"<p>Faire fondre le vinaigre + sucre + sel à feu très doux sans bouillir.</p>";s:16:"instructionNotes";s:0:"";s:5:"image";s:0:"";s:13:"image_preview";s:0:"";s:8:"videoURL";s:0:"";s:6:"chosen";s:0:"";s:8:"selected";s:0:"";}i:1;a:7:{s:11:"instruction";s:48:"<p>Laisser reposer à température ambiante.</p>";s:5:"image";s:0:"";s:13:"image_preview";s:0:"";s:8:"videoURL";s:0:"";s:16:"instructionNotes";s:0:"";s:6:"chosen";s:0:"";s:8:"selected";s:0:"";}}s:6:"chosen";s:0:"";}i:2;a:3:{s:12:"sectionTitle";s:14:"Cuisson du riz";s:11:"instruction";a:8:{i:0;a:7:{s:11:"instruction";s:93:"<p>Verser l\'eau sur le riz bien à plat dans une casserole ou un faitout (avec couvercle)</p>";s:5:"image";s:0:"";s:13:"image_preview";s:0:"";s:8:"videoURL";s:0:"";s:16:"instructionNotes";s:0:"";s:6:"chosen";s:0:"";s:8:"selected";s:0:"";}i:1;a:7:{s:11:"instruction";s:60:"<p>Feu vif (7) : jusqu\'à début d\'ébullition (2,5 min)</p>";s:5:"image";s:0:"";s:13:"image_preview";s:0:"";s:8:"videoURL";s:0:"";s:16:"instructionNotes";s:0:"";s:6:"chosen";s:0:"";s:8:"selected";s:0:"";}i:2;a:7:{s:11:"instruction";s:27:"<p>Feu vif (7) : 10 min</p>";s:5:"image";s:0:"";s:13:"image_preview";s:0:"";s:8:"videoURL";s:0:"";s:16:"instructionNotes";s:0:"";s:6:"chosen";s:0:"";s:8:"selected";s:0:"";}i:3;a:7:{s:11:"instruction";s:28:"<p>Feu doux (2) : 10 min</p>";s:5:"image";s:0:"";s:13:"image_preview";s:0:"";s:8:"videoURL";s:0:"";s:16:"instructionNotes";s:0:"";s:6:"chosen";s:0:"";s:8:"selected";s:0:"";}i:4;a:7:{s:11:"instruction";s:44:"<p>Éteindre et laisser reposer : 10 min</p>";s:5:"image";s:0:"";s:13:"image_preview";s:0:"";s:8:"videoURL";s:0:"";s:16:"instructionNotes";s:0:"";s:6:"chosen";s:0:"";s:8:"selected";s:0:"";}i:5;a:7:{s:11:"instruction";s:51:"<p>Verser le riz dans un saladier ou un hangiri</p>";s:5:"image";s:0:"";s:13:"image_preview";s:0:"";s:8:"videoURL";s:0:"";s:16:"instructionNotes";s:0:"";s:6:"chosen";s:0:"";s:8:"selected";s:0:"";}i:6;a:7:{s:11:"instruction";s:117:"<p>Verser la sauce sur le riz et remuer délicatement en éventant avec un éventail ou un ventilo (encore mieux)</p>";s:5:"image";s:0:"";s:13:"image_preview";s:0:"";s:8:"videoURL";s:0:"";s:16:"instructionNotes";s:0:"";s:6:"chosen";s:0:"";s:8:"selected";s:0:"";}i:7;a:7:{s:11:"instruction";s:92:"<p>Laisser refroidir et reposer le riz avec un torchon mouillé sur le saladier (45 min)</p>";s:5:"image";s:0:"";s:13:"image_preview";s:0:"";s:8:"videoURL";s:0:"";s:16:"instructionNotes";s:0:"";s:6:"chosen";s:0:"";s:8:"selected";s:0:"";}}s:6:"chosen";s:0:"";}}s:18:"enableImageGallery";s:2:"no";s:18:"imageGalleryImages";a:0:{}s:18:"enableVideoGallery";s:2:"no";s:16:"videoGalleryVids";a:0:{}s:15:"recipeDelicious";a:1:{i:0;a:2:{s:7:"drImage";s:0:"";s:6:"drLink";s:0:"";}}s:11:"servingSize";s:0:"";s:8:"servings";s:0:"";s:8:"calories";s:0:"";s:15:"caloriesFromFat";s:0:"";s:8:"totalFat";s:0:"";s:12:"saturatedFat";s:0:"";s:8:"transFat";s:0:"";s:11:"cholesterol";s:0:"";s:6:"sodium";s:0:"";s:9:"potassium";s:0:"";s:17:"totalCarbohydrate";s:0:"";s:12:"dietaryFiber";s:0:"";s:6:"sugars";s:0:"";s:7:"protein";s:0:"";s:8:"vitaminA";s:0:"";s:8:"vitaminC";s:0:"";s:7:"calcium";s:0:"";s:4:"iron";s:0:"";s:8:"vitaminD";s:0:"";s:8:"vitaminE";s:0:"";s:8:"vitaminK";s:0:"";s:7:"thiamin";s:0:"";s:10:"riboflavin";s:0:"";s:6:"niacin";s:0:"";s:9:"vitaminB6";s:0:"";s:6:"folate";s:0:"";s:10:"vitaminB12";s:0:"";s:6:"biotin";s:0:"";s:15:"pantothenicAcid";s:0:"";s:10:"phosphorus";s:0:"";s:6:"iodine";s:0:"";s:9:"magnesium";s:0:"";s:4:"zinc";s:0:"";s:8:"selenium";s:0:"";s:6:"copper";s:0:"";s:9:"manganese";s:0:"";s:8:"chromium";s:0:"";s:10:"molybdenum";s:0:"";s:8:"chloride";s:0:"";s:11:"recipeNotes";s:100:"<p>Je prépare le riz le soir, je laisse reposer la nuit pour une utilisation le lendemain midi.</p>";s:9:"faqsTitle";s:26:"Frequently Asked Questions";s:10:"recipeFAQs";a:0:{}}');
INSERT INTO `miam_postmeta` VALUES (322,85,'_dr_best_season','');
INSERT INTO `miam_postmeta` VALUES (323,85,'_dr_difficulty_level','intermediate');
INSERT INTO `miam_postmeta` VALUES (324,85,'_dr_recipe_ingredients','a:5:{i:0;s:21:"Riz japonais à sushi";i:1;s:3:"Eau";i:2;s:15:"Vinaigre de riz";i:3;s:5:"Sucre";i:4;s:3:"Sel";}');
INSERT INTO `miam_postmeta` VALUES (325,85,'_dr_ingredient_count','5');
INSERT INTO `miam_postmeta` VALUES (326,85,'_delicious_recipes_view_count','64');
INSERT INTO `miam_postmeta` VALUES (327,87,'_edit_lock','1697275923:1');
INSERT INTO `miam_postmeta` VALUES (329,87,'delicious_recipes_metadata','a:68:{s:14:"recipeSubtitle";s:38:"Pâte sablée fondante au beurre salé";s:17:"recipeDescription";s:0:"";s:14:"recipeKeywords";s:0:"";s:15:"difficultyLevel";s:0:"";s:8:"prepTime";s:2:"15";s:12:"prepTimeUnit";s:3:"min";s:8:"cookTime";s:2:"20";s:12:"cookTimeUnit";s:3:"min";s:11:"cookingTemp";s:0:"";s:15:"cookingTempUnit";s:1:"C";s:8:"restTime";s:0:"";s:12:"restTimeUnit";s:3:"min";s:14:"recipeCalories";s:0:"";s:10:"bestSeason";s:0:"";s:13:"estimatedCost";s:0:"";s:17:"estimatedCostCurr";s:0:"";s:12:"noOfServings";s:0:"";s:15:"ingredientTitle";s:0:"";s:17:"recipeIngredients";a:1:{i:0;a:2:{s:12:"sectionTitle";s:0:"";s:11:"ingredients";a:4:{i:0;a:6:{s:8:"quantity";s:3:"220";s:4:"unit";s:1:"g";s:10:"ingredient";s:15:"Beurre demi-sel";s:5:"notes";s:0:"";s:6:"chosen";s:0:"";s:8:"selected";s:0:"";}i:1;a:6:{s:8:"quantity";s:2:"75";s:4:"unit";s:1:"g";s:10:"ingredient";s:11:"Sucre glace";s:5:"notes";s:0:"";s:6:"chosen";s:0:"";s:8:"selected";s:0:"";}i:2;a:6:{s:8:"quantity";s:3:"200";s:4:"unit";s:1:"g";s:10:"ingredient";s:10:"Farine T45";s:5:"notes";s:0:"";s:6:"chosen";s:0:"";s:8:"selected";s:0:"";}i:3;a:6:{s:8:"quantity";s:2:"40";s:4:"unit";s:1:"g";s:10:"ingredient";s:16:"Fécule de maïs";s:5:"notes";s:8:"Maïzena";s:6:"chosen";s:0:"";s:8:"selected";s:0:"";}}}}s:17:"instructionsTitle";s:0:"";s:18:"recipeInstructions";a:1:{i:0;a:2:{s:12:"sectionTitle";s:0:"";s:11:"instruction";a:1:{i:0;a:8:{s:16:"instructionTitle";s:12:"Préparation";s:11:"instruction";s:544:"<ul>\n<li>Préchauffer le four à 160°C (thermostat 5-6)</li>\n<li>Mélanger tous les ingrédients avec une cuillère jusqu\'à obtention d\'une pâte homogène.</li>\n<li>Étaler la pâte entre deux feuilles de papier cuisson (0,5cm)</li>\n<li>Retirer la feuille de papier cuisson supérieure et placer dans un plat à tarte</li>\n<li>Piquer la pâte avec une fourchette sur toute sa surface</li>\n<li>Cuire pendant environ 20-25 min (jusqu\'à ce que la pâte dore légèrement)</li>\n<li>Félicitez vous, vous êtes un chef like Christophe</li>\n</ul>";s:16:"instructionNotes";s:92:"Si la pâte est trop collante et difficile à manipuler, la placer 10min au réfrigérateur.";s:5:"image";s:0:"";s:13:"image_preview";s:0:"";s:8:"videoURL";s:0:"";s:6:"chosen";s:0:"";s:8:"selected";s:0:"";}}}}s:18:"enableImageGallery";s:2:"no";s:18:"imageGalleryImages";a:0:{}s:18:"enableVideoGallery";s:2:"no";s:16:"videoGalleryVids";a:0:{}s:15:"recipeDelicious";a:1:{i:0;a:2:{s:7:"drImage";s:0:"";s:6:"drLink";s:0:"";}}s:11:"servingSize";s:0:"";s:8:"servings";s:0:"";s:8:"calories";s:0:"";s:15:"caloriesFromFat";s:0:"";s:8:"totalFat";s:0:"";s:12:"saturatedFat";s:0:"";s:8:"transFat";s:0:"";s:11:"cholesterol";s:0:"";s:6:"sodium";s:0:"";s:9:"potassium";s:0:"";s:17:"totalCarbohydrate";s:0:"";s:12:"dietaryFiber";s:0:"";s:6:"sugars";s:0:"";s:7:"protein";s:0:"";s:8:"vitaminA";s:0:"";s:8:"vitaminC";s:0:"";s:7:"calcium";s:0:"";s:4:"iron";s:0:"";s:8:"vitaminD";s:0:"";s:8:"vitaminE";s:0:"";s:8:"vitaminK";s:0:"";s:7:"thiamin";s:0:"";s:10:"riboflavin";s:0:"";s:6:"niacin";s:0:"";s:9:"vitaminB6";s:0:"";s:6:"folate";s:0:"";s:10:"vitaminB12";s:0:"";s:6:"biotin";s:0:"";s:15:"pantothenicAcid";s:0:"";s:10:"phosphorus";s:0:"";s:6:"iodine";s:0:"";s:9:"magnesium";s:0:"";s:4:"zinc";s:0:"";s:8:"selenium";s:0:"";s:6:"copper";s:0:"";s:9:"manganese";s:0:"";s:8:"chromium";s:0:"";s:10:"molybdenum";s:0:"";s:8:"chloride";s:0:"";s:11:"recipeNotes";s:0:"";s:9:"faqsTitle";s:26:"Frequently Asked Questions";s:10:"recipeFAQs";a:0:{}}');
INSERT INTO `miam_postmeta` VALUES (330,87,'_dr_best_season','');
INSERT INTO `miam_postmeta` VALUES (331,87,'_dr_difficulty_level','');
INSERT INTO `miam_postmeta` VALUES (332,87,'_dr_recipe_ingredients','a:4:{i:0;s:15:"Beurre demi-sel";i:1;s:11:"Sucre glace";i:2;s:10:"Farine T45";i:3;s:16:"Fécule de maïs";}');
INSERT INTO `miam_postmeta` VALUES (333,87,'_dr_ingredient_count','4');
INSERT INTO `miam_postmeta` VALUES (334,87,'_edit_last','1');
INSERT INTO `miam_postmeta` VALUES (335,87,'_delicious_recipes_view_count','46');
INSERT INTO `miam_postmeta` VALUES (336,90,'_wp_attached_file','2023/09/pate-sablee-thermomix.webp');
INSERT INTO `miam_postmeta` VALUES (337,90,'_wp_attachment_metadata','a:6:{s:5:"width";i:800;s:6:"height";i:600;s:4:"file";s:34:"2023/09/pate-sablee-thermomix.webp";s:8:"filesize";i:19670;s:5:"sizes";a:21:{s:6:"medium";a:5:{s:4:"file";s:34:"pate-sablee-thermomix-300x225.webp";s:5:"width";i:300;s:6:"height";i:225;s:9:"mime-type";s:10:"image/webp";s:8:"filesize";i:6420;}s:9:"thumbnail";a:5:{s:4:"file";s:34:"pate-sablee-thermomix-150x150.webp";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/webp";s:8:"filesize";i:2724;}s:12:"medium_large";a:5:{s:4:"file";s:34:"pate-sablee-thermomix-768x576.webp";s:5:"width";i:768;s:6:"height";i:576;s:9:"mime-type";s:10:"image/webp";s:8:"filesize";i:22306;}s:21:"recipe-feat-thumbnail";a:5:{s:4:"file";s:34:"pate-sablee-thermomix-124x166.webp";s:5:"width";i:124;s:6:"height";i:166;s:9:"mime-type";s:10:"image/webp";s:8:"filesize";i:2312;}s:16:"recipe-feat-tall";a:5:{s:4:"file";s:34:"pate-sablee-thermomix-290x386.webp";s:5:"width";i:290;s:6:"height";i:386;s:9:"mime-type";s:10:"image/webp";s:8:"filesize";i:7656;}s:19:"recipe-feat-gallery";a:5:{s:4:"file";s:34:"pate-sablee-thermomix-768x600.webp";s:5:"width";i:768;s:6:"height";i:600;s:9:"mime-type";s:10:"image/webp";s:8:"filesize";i:22360;}s:17:"recipe-feat-print";a:5:{s:4:"file";s:34:"pate-sablee-thermomix-595x595.webp";s:5:"width";i:595;s:6:"height";i:595;s:9:"mime-type";s:10:"image/webp";s:8:"filesize";i:17360;}s:19:"recipe-archive-list";a:5:{s:4:"file";s:34:"pate-sablee-thermomix-450x600.webp";s:5:"width";i:450;s:6:"height";i:600;s:9:"mime-type";s:10:"image/webp";s:8:"filesize";i:13784;}s:19:"recipe-archive-grid";a:5:{s:4:"file";s:34:"pate-sablee-thermomix-345x460.webp";s:5:"width";i:345;s:6:"height";i:460;s:9:"mime-type";s:10:"image/webp";s:8:"filesize";i:9858;}s:19:"recipe-author-image";a:5:{s:4:"file";s:34:"pate-sablee-thermomix-156x207.webp";s:5:"width";i:156;s:6:"height";i:207;s:9:"mime-type";s:10:"image/webp";s:8:"filesize";i:3034;}s:28:"delrecpe-structured-data-1_1";a:5:{s:4:"file";s:34:"pate-sablee-thermomix-500x500.webp";s:5:"width";i:500;s:6:"height";i:500;s:9:"mime-type";s:10:"image/webp";s:8:"filesize";i:13898;}s:28:"delrecpe-structured-data-4_3";a:5:{s:4:"file";s:34:"pate-sablee-thermomix-500x375.webp";s:5:"width";i:500;s:6:"height";i:375;s:9:"mime-type";s:10:"image/webp";s:8:"filesize";i:13524;}s:29:"delrecpe-structured-data-16_9";a:5:{s:4:"file";s:34:"pate-sablee-thermomix-480x270.webp";s:5:"width";i:480;s:6:"height";i:270;s:9:"mime-type";s:10:"image/webp";s:8:"filesize";i:9140;}s:19:"cookery-lite-slider";a:5:{s:4:"file";s:34:"pate-sablee-thermomix-480x600.webp";s:5:"width";i:480;s:6:"height";i:600;s:9:"mime-type";s:10:"image/webp";s:8:"filesize";i:13706;}s:28:"cookery-lite-featured-recipe";a:5:{s:4:"file";s:34:"pate-sablee-thermomix-384x512.webp";s:5:"width";i:384;s:6:"height";i:512;s:9:"mime-type";s:10:"image/webp";s:8:"filesize";i:10544;}s:17:"cookery-lite-blog";a:5:{s:4:"file";s:34:"pate-sablee-thermomix-286x382.webp";s:5:"width";i:286;s:6:"height";i:382;s:9:"mime-type";s:10:"image/webp";s:8:"filesize";i:7464;}s:25:"cookery-lite-blog-list-lg";a:5:{s:4:"file";s:34:"pate-sablee-thermomix-768x600.webp";s:5:"width";i:768;s:6:"height";i:600;s:9:"mime-type";s:10:"image/webp";s:8:"filesize";i:22360;}s:25:"cookery-lite-blog-archive";a:5:{s:4:"file";s:34:"pate-sablee-thermomix-307x410.webp";s:5:"width";i:307;s:6:"height";i:410;s:9:"mime-type";s:10:"image/webp";s:8:"filesize";i:8392;}s:18:"cookery-lite-promo";a:5:{s:4:"file";s:34:"pate-sablee-thermomix-366x231.webp";s:5:"width";i:366;s:6:"height";i:231;s:9:"mime-type";s:10:"image/webp";s:8:"filesize";i:7274;}s:19:"cookery-lite-single";a:5:{s:4:"file";s:34:"pate-sablee-thermomix-768x500.webp";s:5:"width";i:768;s:6:"height";i:500;s:9:"mime-type";s:10:"image/webp";s:8:"filesize";i:19720;}s:20:"cookery-lite-related";a:5:{s:4:"file";s:34:"pate-sablee-thermomix-384x512.webp";s:5:"width";i:384;s:6:"height";i:512;s:9:"mime-type";s:10:"image/webp";s:8:"filesize";i:10544;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `miam_postmeta` VALUES (338,87,'_thumbnail_id','90');
INSERT INTO `miam_postmeta` VALUES (340,93,'_edit_lock','1703807358:1');
INSERT INTO `miam_postmeta` VALUES (341,93,'delicious_recipes_metadata','a:68:{s:14:"recipeSubtitle";s:0:"";s:17:"recipeDescription";s:0:"";s:14:"recipeKeywords";s:0:"";s:15:"difficultyLevel";s:8:"beginner";s:8:"prepTime";s:2:"15";s:12:"prepTimeUnit";s:3:"min";s:8:"cookTime";s:0:"";s:12:"cookTimeUnit";s:3:"min";s:11:"cookingTemp";s:0:"";s:15:"cookingTempUnit";s:1:"C";s:8:"restTime";s:1:"8";s:12:"restTimeUnit";s:4:"hour";s:14:"recipeCalories";s:0:"";s:10:"bestSeason";s:0:"";s:13:"estimatedCost";s:0:"";s:17:"estimatedCostCurr";s:0:"";s:12:"noOfServings";s:1:"6";s:15:"ingredientTitle";s:0:"";s:17:"recipeIngredients";a:3:{i:0;a:2:{s:12:"sectionTitle";s:12:"Chou mariné";s:11:"ingredients";a:4:{i:0;a:6:{s:8:"quantity";s:3:"0,5";s:4:"unit";s:0:"";s:10:"ingredient";s:10:"Chou blanc";s:5:"notes";s:15:"ou 1 petit chou";s:6:"chosen";s:0:"";s:8:"selected";s:0:"";}i:1;a:5:{s:8:"quantity";s:1:"2";s:4:"unit";s:1:"l";s:10:"ingredient";s:3:"eau";s:5:"notes";s:0:"";s:6:"chosen";s:0:"";}i:2;a:6:{s:8:"quantity";s:2:"15";s:4:"unit";s:2:"cl";s:10:"ingredient";s:15:"Vinaigre de riz";s:5:"notes";s:24:"ou vinaigre blanc dilué";s:6:"chosen";s:0:"";s:8:"selected";s:0:"";}i:3;a:6:{s:8:"quantity";s:2:"30";s:4:"unit";s:1:"g";s:10:"ingredient";s:3:"sel";s:5:"notes";s:0:"";s:6:"chosen";s:0:"";s:8:"selected";s:0:"";}}}i:1;a:3:{s:12:"sectionTitle";s:5:"Sauce";s:11:"ingredients";a:4:{i:0;a:5:{s:8:"quantity";s:1:"4";s:4:"unit";s:3:"tsp";s:10:"ingredient";s:10:"Mayonnaise";s:5:"notes";s:0:"";s:6:"chosen";s:0:"";}i:1;a:6:{s:8:"quantity";s:1:"3";s:4:"unit";s:3:"tsp";s:10:"ingredient";s:15:"Vinaigre de riz";s:5:"notes";s:24:"ou vinaigre blanc dilué";s:6:"chosen";s:0:"";s:8:"selected";s:0:"";}i:2;a:6:{s:8:"quantity";s:1:"2";s:4:"unit";s:4:"tbsp";s:10:"ingredient";s:5:"Mirin";s:5:"notes";s:0:"";s:6:"chosen";s:0:"";s:8:"selected";s:0:"";}i:3;a:6:{s:8:"quantity";s:1:"2";s:4:"unit";s:3:"tsp";s:10:"ingredient";s:10:"Sauce soja";s:5:"notes";s:6:"salée";s:6:"chosen";s:0:"";s:8:"selected";s:0:"";}}s:6:"chosen";s:0:"";}i:2;a:2:{s:12:"sectionTitle";s:11:"Décoration";s:11:"ingredients";a:1:{i:0;a:6:{s:8:"quantity";s:0:"";s:4:"unit";s:0:"";s:10:"ingredient";s:25:"Graines de sésame noires";s:5:"notes";s:0:"";s:6:"chosen";s:0:"";s:8:"selected";s:0:"";}}}}s:17:"instructionsTitle";s:0:"";s:18:"recipeInstructions";a:1:{i:0;a:2:{s:12:"sectionTitle";s:0:"";s:11:"instruction";a:3:{i:0;a:8:{s:16:"instructionTitle";s:8:"Marinade";s:11:"instruction";s:391:"<p>Retirer les première feuilles du chou.</p>\n<p>Retirer le centre (trop dur).</p>\n<p>Passer le chou à la mandoline (réglage le plus fin possible).</p>\n<p>Dans un saladier faire dissoudre dans l\'eau le sel et le vinaigre de riz (remuer 3 minutes).</p>\n<p>Ajouter le chou et bien l’imprégner en remuant avec les mains (propres).</p>\n<p>Filmer et laisser 3 h à température ambiante</p>";s:16:"instructionNotes";s:0:"";s:5:"image";s:0:"";s:13:"image_preview";s:0:"";s:8:"videoURL";s:0:"";s:6:"chosen";s:0:"";s:8:"selected";s:0:"";}i:1;a:8:{s:11:"instruction";s:153:"<p>Rincer le chou à l\'eau claire puis bien l’égoutter.</p>\n<p>Sécher le chou dans du papier absorbant.</p>\n<p>Remettre le chou dans le saladier.</p>";s:5:"image";s:0:"";s:13:"image_preview";s:0:"";s:8:"videoURL";s:0:"";s:16:"instructionNotes";s:0:"";s:16:"instructionTitle";s:16:"Rinçage du chou";s:6:"chosen";s:0:"";s:8:"selected";s:0:"";}i:2;a:8:{s:11:"instruction";s:253:"<p>Dans un bol, mélanger les ingrédients de la sauce, bien remuer</p>\n<p>Verser la sauce sur le chou, et bien imprégner.</p>\n<p>Remettre au réfrigérateur jusqu\'au moment de servir dans des petits bols.</p>\n<p>Ajouter des graines de sésame noir</p>";s:5:"image";s:0:"";s:13:"image_preview";s:0:"";s:8:"videoURL";s:0:"";s:16:"instructionNotes";s:0:"";s:16:"instructionTitle";s:23:"Sauce et assaisonnement";s:6:"chosen";s:0:"";s:8:"selected";s:0:"";}}}}s:18:"enableImageGallery";s:2:"no";s:18:"imageGalleryImages";a:0:{}s:18:"enableVideoGallery";s:2:"no";s:16:"videoGalleryVids";a:0:{}s:15:"recipeDelicious";a:1:{i:0;a:2:{s:7:"drImage";s:0:"";s:6:"drLink";s:0:"";}}s:11:"servingSize";s:0:"";s:8:"servings";s:0:"";s:8:"calories";s:0:"";s:15:"caloriesFromFat";s:0:"";s:8:"totalFat";s:0:"";s:12:"saturatedFat";s:0:"";s:8:"transFat";s:0:"";s:11:"cholesterol";s:0:"";s:6:"sodium";s:0:"";s:9:"potassium";s:0:"";s:17:"totalCarbohydrate";s:0:"";s:12:"dietaryFiber";s:0:"";s:6:"sugars";s:0:"";s:7:"protein";s:0:"";s:8:"vitaminA";s:0:"";s:8:"vitaminC";s:0:"";s:7:"calcium";s:0:"";s:4:"iron";s:0:"";s:8:"vitaminD";s:0:"";s:8:"vitaminE";s:0:"";s:8:"vitaminK";s:0:"";s:7:"thiamin";s:0:"";s:10:"riboflavin";s:0:"";s:6:"niacin";s:0:"";s:9:"vitaminB6";s:0:"";s:6:"folate";s:0:"";s:10:"vitaminB12";s:0:"";s:6:"biotin";s:0:"";s:15:"pantothenicAcid";s:0:"";s:10:"phosphorus";s:0:"";s:6:"iodine";s:0:"";s:9:"magnesium";s:0:"";s:4:"zinc";s:0:"";s:8:"selenium";s:0:"";s:6:"copper";s:0:"";s:9:"manganese";s:0:"";s:8:"chromium";s:0:"";s:10:"molybdenum";s:0:"";s:8:"chloride";s:0:"";s:11:"recipeNotes";s:0:"";s:9:"faqsTitle";s:26:"Frequently Asked Questions";s:10:"recipeFAQs";a:0:{}}');
INSERT INTO `miam_postmeta` VALUES (342,93,'_dr_best_season','');
INSERT INTO `miam_postmeta` VALUES (343,93,'_dr_difficulty_level','beginner');
INSERT INTO `miam_postmeta` VALUES (344,93,'_dr_recipe_ingredients','a:8:{i:0;s:10:"Chou blanc";i:1;s:3:"Eau";i:2;s:15:"Vinaigre de riz";i:3;s:3:"Sel";i:4;s:10:"Mayonnaise";i:5;s:5:"Mirin";i:6;s:10:"Sauce soja";i:7;s:25:"Graines de sésame noires";}');
INSERT INTO `miam_postmeta` VALUES (345,93,'_dr_ingredient_count','8');
INSERT INTO `miam_postmeta` VALUES (346,93,'_edit_last','1');
INSERT INTO `miam_postmeta` VALUES (347,93,'_delicious_recipes_view_count','53');
INSERT INTO `miam_postmeta` VALUES (348,94,'_wp_attached_file','2023/10/chou-marine-japonais.png');
INSERT INTO `miam_postmeta` VALUES (349,94,'_wp_attachment_metadata','a:6:{s:5:"width";i:1241;s:6:"height";i:600;s:4:"file";s:32:"2023/10/chou-marine-japonais.png";s:8:"filesize";i:960817;s:5:"sizes";a:24:{s:6:"medium";a:5:{s:4:"file";s:32:"chou-marine-japonais-300x145.png";s:5:"width";i:300;s:6:"height";i:145;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:89129;}s:5:"large";a:5:{s:4:"file";s:33:"chou-marine-japonais-1024x495.png";s:5:"width";i:1024;s:6:"height";i:495;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:663399;}s:9:"thumbnail";a:5:{s:4:"file";s:32:"chou-marine-japonais-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:48864;}s:12:"medium_large";a:5:{s:4:"file";s:32:"chou-marine-japonais-768x371.png";s:5:"width";i:768;s:6:"height";i:371;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:418427;}s:21:"recipe-feat-thumbnail";a:5:{s:4:"file";s:32:"chou-marine-japonais-124x166.png";s:5:"width";i:124;s:6:"height";i:166;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:42882;}s:16:"recipe-feat-tall";a:5:{s:4:"file";s:32:"chou-marine-japonais-290x386.png";s:5:"width";i:290;s:6:"height";i:386;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:169146;}s:19:"recipe-feat-gallery";a:5:{s:4:"file";s:32:"chou-marine-japonais-768x600.png";s:5:"width";i:768;s:6:"height";i:600;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:624341;}s:17:"recipe-feat-print";a:5:{s:4:"file";s:32:"chou-marine-japonais-595x595.png";s:5:"width";i:595;s:6:"height";i:595;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:461489;}s:19:"recipe-archive-list";a:5:{s:4:"file";s:32:"chou-marine-japonais-450x600.png";s:5:"width";i:450;s:6:"height";i:600;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:351841;}s:19:"recipe-archive-grid";a:5:{s:4:"file";s:32:"chou-marine-japonais-345x460.png";s:5:"width";i:345;s:6:"height";i:460;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:223459;}s:19:"recipe-author-image";a:5:{s:4:"file";s:32:"chou-marine-japonais-156x207.png";s:5:"width";i:156;s:6:"height";i:207;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:62272;}s:28:"delrecpe-structured-data-1_1";a:5:{s:4:"file";s:32:"chou-marine-japonais-500x500.png";s:5:"width";i:500;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:349553;}s:28:"delrecpe-structured-data-4_3";a:5:{s:4:"file";s:32:"chou-marine-japonais-500x375.png";s:5:"width";i:500;s:6:"height";i:375;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:295563;}s:29:"delrecpe-structured-data-16_9";a:5:{s:4:"file";s:32:"chou-marine-japonais-480x270.png";s:5:"width";i:480;s:6:"height";i:270;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:219918;}s:19:"cookery-lite-slider";a:5:{s:4:"file";s:32:"chou-marine-japonais-480x600.png";s:5:"width";i:480;s:6:"height";i:600;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:378518;}s:28:"cookery-lite-featured-recipe";a:5:{s:4:"file";s:32:"chou-marine-japonais-384x512.png";s:5:"width";i:384;s:6:"height";i:512;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:265303;}s:17:"cookery-lite-blog";a:5:{s:4:"file";s:32:"chou-marine-japonais-286x382.png";s:5:"width";i:286;s:6:"height";i:382;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:165314;}s:25:"cookery-lite-blog-list-lg";a:5:{s:4:"file";s:32:"chou-marine-japonais-768x600.png";s:5:"width";i:768;s:6:"height";i:600;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:624341;}s:23:"cookery-lite-blog-large";a:5:{s:4:"file";s:33:"chou-marine-japonais-1214x600.png";s:5:"width";i:1214;s:6:"height";i:600;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:910445;}s:25:"cookery-lite-blog-archive";a:5:{s:4:"file";s:32:"chou-marine-japonais-307x410.png";s:5:"width";i:307;s:6:"height";i:410;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:185282;}s:18:"cookery-lite-promo";a:5:{s:4:"file";s:32:"chou-marine-japonais-366x231.png";s:5:"width";i:366;s:6:"height";i:231;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:155502;}s:19:"cookery-lite-single";a:5:{s:4:"file";s:32:"chou-marine-japonais-768x500.png";s:5:"width";i:768;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:525040;}s:23:"cookery-lite-single-two";a:5:{s:4:"file";s:33:"chou-marine-japonais-1220x600.png";s:5:"width";i:1220;s:6:"height";i:600;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:914346;}s:20:"cookery-lite-related";a:5:{s:4:"file";s:32:"chou-marine-japonais-384x512.png";s:5:"width";i:384;s:6:"height";i:512;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:265303;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `miam_postmeta` VALUES (350,93,'_thumbnail_id','94');
INSERT INTO `miam_postmeta` VALUES (365,85,'_edit_last','1');
INSERT INTO `miam_postmeta` VALUES (366,85,'_thumbnail_id','100');
INSERT INTO `miam_postmeta` VALUES (367,100,'_wp_attached_file','2023/12/riz-sushi.jpg');
INSERT INTO `miam_postmeta` VALUES (368,100,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:683;s:4:"file";s:21:"2023/12/riz-sushi.jpg";s:8:"filesize";i:110324;s:5:"sizes";a:22:{s:6:"medium";a:5:{s:4:"file";s:21:"riz-sushi-300x200.jpg";s:5:"width";i:300;s:6:"height";i:200;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:15229;}s:9:"thumbnail";a:5:{s:4:"file";s:21:"riz-sushi-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:6692;}s:12:"medium_large";a:5:{s:4:"file";s:21:"riz-sushi-768x512.jpg";s:5:"width";i:768;s:6:"height";i:512;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:73367;}s:21:"recipe-feat-thumbnail";a:5:{s:4:"file";s:21:"riz-sushi-124x166.jpg";s:5:"width";i:124;s:6:"height";i:166;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:5784;}s:16:"recipe-feat-tall";a:5:{s:4:"file";s:21:"riz-sushi-290x386.jpg";s:5:"width";i:290;s:6:"height";i:386;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:23124;}s:19:"recipe-feat-gallery";a:5:{s:4:"file";s:21:"riz-sushi-768x683.jpg";s:5:"width";i:768;s:6:"height";i:683;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:88565;}s:17:"recipe-feat-print";a:5:{s:4:"file";s:21:"riz-sushi-595x595.jpg";s:5:"width";i:595;s:6:"height";i:595;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:65587;}s:19:"recipe-archive-list";a:5:{s:4:"file";s:21:"riz-sushi-450x600.jpg";s:5:"width";i:450;s:6:"height";i:600;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:47741;}s:19:"recipe-archive-grid";a:5:{s:4:"file";s:21:"riz-sushi-345x460.jpg";s:5:"width";i:345;s:6:"height";i:460;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:30674;}s:19:"recipe-author-image";a:5:{s:4:"file";s:21:"riz-sushi-156x207.jpg";s:5:"width";i:156;s:6:"height";i:207;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:8257;}s:28:"delrecpe-structured-data-1_1";a:5:{s:4:"file";s:21:"riz-sushi-500x500.jpg";s:5:"width";i:500;s:6:"height";i:500;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:48954;}s:28:"delrecpe-structured-data-4_3";a:5:{s:4:"file";s:21:"riz-sushi-500x375.jpg";s:5:"width";i:500;s:6:"height";i:375;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:39812;}s:29:"delrecpe-structured-data-16_9";a:5:{s:4:"file";s:21:"riz-sushi-480x270.jpg";s:5:"width";i:480;s:6:"height";i:270;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:29004;}s:19:"cookery-lite-slider";a:5:{s:4:"file";s:21:"riz-sushi-480x640.jpg";s:5:"width";i:480;s:6:"height";i:640;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:52354;}s:28:"cookery-lite-featured-recipe";a:5:{s:4:"file";s:21:"riz-sushi-384x512.jpg";s:5:"width";i:384;s:6:"height";i:512;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:36041;}s:17:"cookery-lite-blog";a:5:{s:4:"file";s:21:"riz-sushi-286x382.jpg";s:5:"width";i:286;s:6:"height";i:382;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:22195;}s:25:"cookery-lite-blog-list-lg";a:5:{s:4:"file";s:21:"riz-sushi-768x683.jpg";s:5:"width";i:768;s:6:"height";i:683;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:88565;}s:25:"cookery-lite-blog-archive";a:5:{s:4:"file";s:21:"riz-sushi-307x410.jpg";s:5:"width";i:307;s:6:"height";i:410;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:25490;}s:18:"cookery-lite-promo";a:5:{s:4:"file";s:21:"riz-sushi-366x231.jpg";s:5:"width";i:366;s:6:"height";i:231;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:20387;}s:19:"cookery-lite-single";a:5:{s:4:"file";s:21:"riz-sushi-768x500.jpg";s:5:"width";i:768;s:6:"height";i:500;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:72582;}s:23:"cookery-lite-single-two";a:5:{s:4:"file";s:22:"riz-sushi-1024x600.jpg";s:5:"width";i:1024;s:6:"height";i:600;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:119024;}s:20:"cookery-lite-related";a:5:{s:4:"file";s:21:"riz-sushi-384x512.jpg";s:5:"width";i:384;s:6:"height";i:512;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:36041;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `miam_postmeta` VALUES (369,101,'_edit_lock','1703796080:1');
INSERT INTO `miam_postmeta` VALUES (370,101,'delicious_recipes_metadata','a:68:{s:14:"recipeSubtitle";s:0:"";s:17:"recipeDescription";s:0:"";s:14:"recipeKeywords";s:0:"";s:15:"difficultyLevel";s:0:"";s:8:"prepTime";s:0:"";s:12:"prepTimeUnit";s:3:"min";s:8:"cookTime";s:0:"";s:12:"cookTimeUnit";s:3:"min";s:11:"cookingTemp";s:0:"";s:15:"cookingTempUnit";s:1:"C";s:8:"restTime";s:0:"";s:12:"restTimeUnit";s:3:"min";s:14:"recipeCalories";s:0:"";s:10:"bestSeason";s:0:"";s:13:"estimatedCost";s:0:"";s:17:"estimatedCostCurr";s:0:"";s:12:"noOfServings";s:0:"";s:15:"ingredientTitle";s:0:"";s:17:"recipeIngredients";a:1:{i:0;a:2:{s:12:"sectionTitle";s:0:"";s:11:"ingredients";a:4:{i:0;a:6:{s:8:"quantity";s:3:"200";s:4:"unit";s:1:"g";s:10:"ingredient";s:5:"Sucre";s:5:"notes";s:13:"blanc ou roux";s:6:"chosen";s:0:"";s:8:"selected";s:0:"";}i:1;a:4:{s:8:"quantity";s:2:"50";s:4:"unit";s:1:"g";s:10:"ingredient";s:3:"Eau";s:5:"notes";s:0:"";}i:2;a:4:{s:8:"quantity";s:3:"150";s:4:"unit";s:1:"g";s:10:"ingredient";s:9:"Noisettes";s:5:"notes";s:7:"ou Noix";}i:3;a:4:{s:8:"quantity";s:3:"150";s:4:"unit";s:1:"g";s:10:"ingredient";s:7:"Amandes";s:5:"notes";s:0:"";}}}}s:17:"instructionsTitle";s:7:"Cuisson";s:18:"recipeInstructions";a:1:{i:0;a:2:{s:12:"sectionTitle";s:0:"";s:11:"instruction";a:3:{i:0;a:8:{s:16:"instructionTitle";s:0:"";s:11:"instruction";s:162:"<p>Dans une casserole, faire chauffer sans remuer jusqu a 116 degrés ( donc vérifier avec le thermomètre) . Indication, la surface entière fait des bulles</p>";s:16:"instructionNotes";s:0:"";s:5:"image";s:0:"";s:13:"image_preview";s:0:"";s:8:"videoURL";s:0:"";s:6:"chosen";s:0:"";s:8:"selected";s:0:"";}i:1;a:5:{s:11:"instruction";s:404:"<p>Ensuite à 116 degrés ajouter les noix (150g de noisettes et 150g d’amande)et mettre à feu plutôt doux.<br />Et la mélange avec une spatule en bois plate carré la pour bien racler les bords et mélanger en continu.<br />Le mélanger va redevenir de la poudre blanche, faut continuer jusqu a ce qu’il refonde complètement et ensuite qu’il devienne couleur chocolat (c’est assez long).</p>";s:5:"image";s:0:"";s:13:"image_preview";s:0:"";s:8:"videoURL";s:0:"";s:16:"instructionNotes";s:0:"";}i:2;a:5:{s:11:"instruction";s:382:"<p>Étaler sur du papier cuisson et une fois bien froid on peut le Mixer dans un mixer en plusieurs fois en mélangeant à la Marise de temps en temps...</p>\n<p>C’est magique ça passe vraiment de poudre à pate liquide dans le broyeur sans rien ajouter</p>\n<p>Tu peux d’ailleurs prélever un peu de pralin (le grain avant que ça devienne une pâte) c’est super bon aussi</p>";s:5:"image";s:0:"";s:13:"image_preview";s:0:"";s:8:"videoURL";s:0:"";s:16:"instructionNotes";s:0:"";}}}}s:18:"enableImageGallery";s:2:"no";s:18:"imageGalleryImages";a:0:{}s:18:"enableVideoGallery";s:2:"no";s:16:"videoGalleryVids";a:0:{}s:15:"recipeDelicious";a:1:{i:0;a:2:{s:7:"drImage";s:0:"";s:6:"drLink";s:0:"";}}s:11:"servingSize";s:0:"";s:8:"servings";s:0:"";s:8:"calories";s:0:"";s:15:"caloriesFromFat";s:0:"";s:8:"totalFat";s:0:"";s:12:"saturatedFat";s:0:"";s:8:"transFat";s:0:"";s:11:"cholesterol";s:0:"";s:6:"sodium";s:0:"";s:9:"potassium";s:0:"";s:17:"totalCarbohydrate";s:0:"";s:12:"dietaryFiber";s:0:"";s:6:"sugars";s:0:"";s:7:"protein";s:0:"";s:8:"vitaminA";s:0:"";s:8:"vitaminC";s:0:"";s:7:"calcium";s:0:"";s:4:"iron";s:0:"";s:8:"vitaminD";s:0:"";s:8:"vitaminE";s:0:"";s:8:"vitaminK";s:0:"";s:7:"thiamin";s:0:"";s:10:"riboflavin";s:0:"";s:6:"niacin";s:0:"";s:9:"vitaminB6";s:0:"";s:6:"folate";s:0:"";s:10:"vitaminB12";s:0:"";s:6:"biotin";s:0:"";s:15:"pantothenicAcid";s:0:"";s:10:"phosphorus";s:0:"";s:6:"iodine";s:0:"";s:9:"magnesium";s:0:"";s:4:"zinc";s:0:"";s:8:"selenium";s:0:"";s:6:"copper";s:0:"";s:9:"manganese";s:0:"";s:8:"chromium";s:0:"";s:10:"molybdenum";s:0:"";s:8:"chloride";s:0:"";s:11:"recipeNotes";s:0:"";s:9:"faqsTitle";s:26:"Frequently Asked Questions";s:10:"recipeFAQs";a:0:{}}');
INSERT INTO `miam_postmeta` VALUES (371,101,'_dr_best_season','');
INSERT INTO `miam_postmeta` VALUES (372,101,'_dr_difficulty_level','');
INSERT INTO `miam_postmeta` VALUES (373,101,'_dr_recipe_ingredients','a:4:{i:0;s:5:"Sucre";i:1;s:3:"Eau";i:2;s:9:"Noisettes";i:3;s:7:"Amandes";}');
INSERT INTO `miam_postmeta` VALUES (374,101,'_dr_ingredient_count','4');
INSERT INTO `miam_postmeta` VALUES (375,101,'_edit_last','1');
INSERT INTO `miam_postmeta` VALUES (376,101,'_delicious_recipes_view_count','19');
/*!40000 ALTER TABLE `miam_postmeta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `miam_options`
--

DROP TABLE IF EXISTS `miam_options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `miam_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=10277 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `miam_options`
--

LOCK TABLES `miam_options` WRITE;
/*!40000 ALTER TABLE `miam_options` DISABLE KEYS */;
INSERT INTO `miam_options` VALUES (1,'siteurl','http://miam.vicq.org','yes');
INSERT INTO `miam_options` VALUES (2,'home','http://miam.vicq.org','yes');
INSERT INTO `miam_options` VALUES (3,'blogname','Miam Miam','yes');
INSERT INTO `miam_options` VALUES (4,'blogdescription','Un bon miam','yes');
INSERT INTO `miam_options` VALUES (5,'users_can_register','0','yes');
INSERT INTO `miam_options` VALUES (6,'admin_email','alex@vicq.org','yes');
INSERT INTO `miam_options` VALUES (7,'start_of_week','1','yes');
INSERT INTO `miam_options` VALUES (8,'use_balanceTags','0','yes');
INSERT INTO `miam_options` VALUES (9,'use_smilies','1','yes');
INSERT INTO `miam_options` VALUES (10,'require_name_email','1','yes');
INSERT INTO `miam_options` VALUES (11,'comments_notify','1','yes');
INSERT INTO `miam_options` VALUES (12,'posts_per_rss','10','yes');
INSERT INTO `miam_options` VALUES (13,'rss_use_excerpt','0','yes');
INSERT INTO `miam_options` VALUES (14,'mailserver_url','mail.example.com','yes');
INSERT INTO `miam_options` VALUES (15,'mailserver_login','login@example.com','yes');
INSERT INTO `miam_options` VALUES (16,'mailserver_pass','password','yes');
INSERT INTO `miam_options` VALUES (17,'mailserver_port','110','yes');
INSERT INTO `miam_options` VALUES (18,'default_category','1','yes');
INSERT INTO `miam_options` VALUES (19,'default_comment_status','open','yes');
INSERT INTO `miam_options` VALUES (20,'default_ping_status','open','yes');
INSERT INTO `miam_options` VALUES (21,'default_pingback_flag','1','yes');
INSERT INTO `miam_options` VALUES (22,'posts_per_page','10','yes');
INSERT INTO `miam_options` VALUES (23,'date_format','j F Y','yes');
INSERT INTO `miam_options` VALUES (24,'time_format','G\\hi','yes');
INSERT INTO `miam_options` VALUES (25,'links_updated_date_format','d F Y G\\hi','yes');
INSERT INTO `miam_options` VALUES (26,'comment_moderation','0','yes');
INSERT INTO `miam_options` VALUES (27,'moderation_notify','1','yes');
INSERT INTO `miam_options` VALUES (28,'permalink_structure','/%year%/%monthnum%/%day%/%postname%/','yes');
INSERT INTO `miam_options` VALUES (29,'rewrite_rules','a:149:{s:11:"^wp-json/?$";s:22:"index.php?rest_route=/";s:14:"^wp-json/(.*)?";s:33:"index.php?rest_route=/$matches[1]";s:21:"^index.php/wp-json/?$";s:22:"index.php?rest_route=/";s:24:"^index.php/wp-json/(.*)?";s:33:"index.php?rest_route=/$matches[1]";s:17:"^wp-sitemap\\.xml$";s:23:"index.php?sitemap=index";s:17:"^wp-sitemap\\.xsl$";s:36:"index.php?sitemap-stylesheet=sitemap";s:23:"^wp-sitemap-index\\.xsl$";s:34:"index.php?sitemap-stylesheet=index";s:48:"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$";s:75:"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]";s:34:"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$";s:47:"index.php?sitemap=$matches[1]&paged=$matches[2]";s:10:"recette/?$";s:26:"index.php?post_type=recipe";s:40:"recette/feed/(feed|rdf|rss|rss2|atom)/?$";s:43:"index.php?post_type=recipe&feed=$matches[1]";s:35:"recette/(feed|rdf|rss|rss2|atom)/?$";s:43:"index.php?post_type=recipe&feed=$matches[1]";s:27:"recette/page/([0-9]{1,})/?$";s:44:"index.php?post_type=recipe&paged=$matches[1]";s:47:"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$";s:52:"index.php?category_name=$matches[1]&feed=$matches[2]";s:42:"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$";s:52:"index.php?category_name=$matches[1]&feed=$matches[2]";s:23:"category/(.+?)/embed/?$";s:46:"index.php?category_name=$matches[1]&embed=true";s:35:"category/(.+?)/page/?([0-9]{1,})/?$";s:53:"index.php?category_name=$matches[1]&paged=$matches[2]";s:17:"category/(.+?)/?$";s:35:"index.php?category_name=$matches[1]";s:44:"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?recipe-tag=$matches[1]&feed=$matches[2]";s:39:"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?recipe-tag=$matches[1]&feed=$matches[2]";s:20:"tag/([^/]+)/embed/?$";s:43:"index.php?recipe-tag=$matches[1]&embed=true";s:32:"tag/([^/]+)/page/?([0-9]{1,})/?$";s:50:"index.php?recipe-tag=$matches[1]&paged=$matches[2]";s:14:"tag/([^/]+)/?$";s:32:"index.php?recipe-tag=$matches[1]";s:45:"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:50:"index.php?post_format=$matches[1]&feed=$matches[2]";s:40:"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:50:"index.php?post_format=$matches[1]&feed=$matches[2]";s:21:"type/([^/]+)/embed/?$";s:44:"index.php?post_format=$matches[1]&embed=true";s:33:"type/([^/]+)/page/?([0-9]{1,})/?$";s:51:"index.php?post_format=$matches[1]&paged=$matches[2]";s:15:"type/([^/]+)/?$";s:33:"index.php?post_format=$matches[1]";s:35:"recette/[^/]+/attachment/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:45:"recette/[^/]+/attachment/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:65:"recette/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:60:"recette/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:60:"recette/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:41:"recette/[^/]+/attachment/([^/]+)/embed/?$";s:43:"index.php?attachment=$matches[1]&embed=true";s:24:"recette/([^/]+)/embed/?$";s:39:"index.php?recipe=$matches[1]&embed=true";s:28:"recette/([^/]+)/trackback/?$";s:33:"index.php?recipe=$matches[1]&tb=1";s:48:"recette/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:45:"index.php?recipe=$matches[1]&feed=$matches[2]";s:43:"recette/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:45:"index.php?recipe=$matches[1]&feed=$matches[2]";s:36:"recette/([^/]+)/page/?([0-9]{1,})/?$";s:46:"index.php?recipe=$matches[1]&paged=$matches[2]";s:43:"recette/([^/]+)/comment-page-([0-9]{1,})/?$";s:46:"index.php?recipe=$matches[1]&cpage=$matches[2]";s:32:"recette/([^/]+)(?:/([0-9]+))?/?$";s:45:"index.php?recipe=$matches[1]&page=$matches[2]";s:24:"recette/[^/]+/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:34:"recette/[^/]+/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:54:"recette/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:49:"recette/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:49:"recette/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:30:"recette/[^/]+/([^/]+)/embed/?$";s:43:"index.php?attachment=$matches[1]&embed=true";s:43:"plat/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$";s:52:"index.php?recipe-course=$matches[1]&feed=$matches[2]";s:38:"plat/(.+?)/(feed|rdf|rss|rss2|atom)/?$";s:52:"index.php?recipe-course=$matches[1]&feed=$matches[2]";s:19:"plat/(.+?)/embed/?$";s:46:"index.php?recipe-course=$matches[1]&embed=true";s:31:"plat/(.+?)/page/?([0-9]{1,})/?$";s:53:"index.php?recipe-course=$matches[1]&paged=$matches[2]";s:13:"plat/(.+?)/?$";s:35:"index.php?recipe-course=$matches[1]";s:46:"cuisine/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$";s:53:"index.php?recipe-cuisine=$matches[1]&feed=$matches[2]";s:41:"cuisine/(.+?)/(feed|rdf|rss|rss2|atom)/?$";s:53:"index.php?recipe-cuisine=$matches[1]&feed=$matches[2]";s:22:"cuisine/(.+?)/embed/?$";s:47:"index.php?recipe-cuisine=$matches[1]&embed=true";s:34:"cuisine/(.+?)/page/?([0-9]{1,})/?$";s:54:"index.php?recipe-cuisine=$matches[1]&paged=$matches[2]";s:16:"cuisine/(.+?)/?$";s:36:"index.php?recipe-cuisine=$matches[1]";s:46:"cuisson/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$";s:60:"index.php?recipe-cooking-method=$matches[1]&feed=$matches[2]";s:41:"cuisson/(.+?)/(feed|rdf|rss|rss2|atom)/?$";s:60:"index.php?recipe-cooking-method=$matches[1]&feed=$matches[2]";s:22:"cuisson/(.+?)/embed/?$";s:54:"index.php?recipe-cooking-method=$matches[1]&embed=true";s:34:"cuisson/(.+?)/page/?([0-9]{1,})/?$";s:61:"index.php?recipe-cooking-method=$matches[1]&paged=$matches[2]";s:16:"cuisson/(.+?)/?$";s:43:"index.php?recipe-cooking-method=$matches[1]";s:45:"clef/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?recipe-key=$matches[1]&feed=$matches[2]";s:40:"clef/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?recipe-key=$matches[1]&feed=$matches[2]";s:21:"clef/([^/]+)/embed/?$";s:43:"index.php?recipe-key=$matches[1]&embed=true";s:33:"clef/([^/]+)/page/?([0-9]{1,})/?$";s:50:"index.php?recipe-key=$matches[1]&paged=$matches[2]";s:15:"clef/([^/]+)/?$";s:32:"index.php?recipe-key=$matches[1]";s:46:"badge/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:51:"index.php?recipe-badge=$matches[1]&feed=$matches[2]";s:41:"badge/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:51:"index.php?recipe-badge=$matches[1]&feed=$matches[2]";s:22:"badge/([^/]+)/embed/?$";s:45:"index.php?recipe-badge=$matches[1]&embed=true";s:34:"badge/([^/]+)/page/?([0-9]{1,})/?$";s:52:"index.php?recipe-badge=$matches[1]&paged=$matches[2]";s:16:"badge/([^/]+)/?$";s:34:"index.php?recipe-badge=$matches[1]";s:55:"recipe-dietary/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:53:"index.php?recipe-dietary=$matches[1]&feed=$matches[2]";s:50:"recipe-dietary/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:53:"index.php?recipe-dietary=$matches[1]&feed=$matches[2]";s:31:"recipe-dietary/([^/]+)/embed/?$";s:47:"index.php?recipe-dietary=$matches[1]&embed=true";s:43:"recipe-dietary/([^/]+)/page/?([0-9]{1,})/?$";s:54:"index.php?recipe-dietary=$matches[1]&paged=$matches[2]";s:25:"recipe-dietary/([^/]+)/?$";s:36:"index.php?recipe-dietary=$matches[1]";s:12:"robots\\.txt$";s:18:"index.php?robots=1";s:13:"favicon\\.ico$";s:19:"index.php?favicon=1";s:48:".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$";s:18:"index.php?feed=old";s:20:".*wp-app\\.php(/.*)?$";s:19:"index.php?error=403";s:18:".*wp-register.php$";s:23:"index.php?register=true";s:32:"feed/(feed|rdf|rss|rss2|atom)/?$";s:27:"index.php?&feed=$matches[1]";s:27:"(feed|rdf|rss|rss2|atom)/?$";s:27:"index.php?&feed=$matches[1]";s:8:"embed/?$";s:21:"index.php?&embed=true";s:20:"page/?([0-9]{1,})/?$";s:28:"index.php?&paged=$matches[1]";s:41:"comments/feed/(feed|rdf|rss|rss2|atom)/?$";s:42:"index.php?&feed=$matches[1]&withcomments=1";s:36:"comments/(feed|rdf|rss|rss2|atom)/?$";s:42:"index.php?&feed=$matches[1]&withcomments=1";s:17:"comments/embed/?$";s:21:"index.php?&embed=true";s:44:"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:40:"index.php?s=$matches[1]&feed=$matches[2]";s:39:"search/(.+)/(feed|rdf|rss|rss2|atom)/?$";s:40:"index.php?s=$matches[1]&feed=$matches[2]";s:20:"search/(.+)/embed/?$";s:34:"index.php?s=$matches[1]&embed=true";s:32:"search/(.+)/page/?([0-9]{1,})/?$";s:41:"index.php?s=$matches[1]&paged=$matches[2]";s:14:"search/(.+)/?$";s:23:"index.php?s=$matches[1]";s:47:"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:50:"index.php?author_name=$matches[1]&feed=$matches[2]";s:42:"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:50:"index.php?author_name=$matches[1]&feed=$matches[2]";s:23:"author/([^/]+)/embed/?$";s:44:"index.php?author_name=$matches[1]&embed=true";s:35:"author/([^/]+)/page/?([0-9]{1,})/?$";s:51:"index.php?author_name=$matches[1]&paged=$matches[2]";s:17:"author/([^/]+)/?$";s:33:"index.php?author_name=$matches[1]";s:69:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$";s:80:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]";s:64:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$";s:80:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]";s:45:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$";s:74:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true";s:57:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$";s:81:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]";s:39:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$";s:63:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]";s:56:"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$";s:64:"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]";s:51:"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$";s:64:"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]";s:32:"([0-9]{4})/([0-9]{1,2})/embed/?$";s:58:"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true";s:44:"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$";s:65:"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]";s:26:"([0-9]{4})/([0-9]{1,2})/?$";s:47:"index.php?year=$matches[1]&monthnum=$matches[2]";s:43:"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$";s:43:"index.php?year=$matches[1]&feed=$matches[2]";s:38:"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$";s:43:"index.php?year=$matches[1]&feed=$matches[2]";s:19:"([0-9]{4})/embed/?$";s:37:"index.php?year=$matches[1]&embed=true";s:31:"([0-9]{4})/page/?([0-9]{1,})/?$";s:44:"index.php?year=$matches[1]&paged=$matches[2]";s:13:"([0-9]{4})/?$";s:26:"index.php?year=$matches[1]";s:58:"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:68:"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:88:"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:83:"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:83:"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:64:"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/embed/?$";s:43:"index.php?attachment=$matches[1]&embed=true";s:53:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/embed/?$";s:91:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&embed=true";s:57:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/trackback/?$";s:85:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&tb=1";s:77:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:97:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]";s:72:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:97:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]";s:65:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/page/?([0-9]{1,})/?$";s:98:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&paged=$matches[5]";s:72:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/comment-page-([0-9]{1,})/?$";s:98:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&cpage=$matches[5]";s:61:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)(?:/([0-9]+))?/?$";s:97:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&page=$matches[5]";s:47:"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:57:"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:77:"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:72:"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:72:"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:53:"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/embed/?$";s:43:"index.php?attachment=$matches[1]&embed=true";s:64:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$";s:81:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&cpage=$matches[4]";s:51:"([0-9]{4})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$";s:65:"index.php?year=$matches[1]&monthnum=$matches[2]&cpage=$matches[3]";s:38:"([0-9]{4})/comment-page-([0-9]{1,})/?$";s:44:"index.php?year=$matches[1]&cpage=$matches[2]";s:27:".?.+?/attachment/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:37:".?.+?/attachment/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:57:".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:52:".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:52:".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:33:".?.+?/attachment/([^/]+)/embed/?$";s:43:"index.php?attachment=$matches[1]&embed=true";s:16:"(.?.+?)/embed/?$";s:41:"index.php?pagename=$matches[1]&embed=true";s:20:"(.?.+?)/trackback/?$";s:35:"index.php?pagename=$matches[1]&tb=1";s:40:"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$";s:47:"index.php?pagename=$matches[1]&feed=$matches[2]";s:35:"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$";s:47:"index.php?pagename=$matches[1]&feed=$matches[2]";s:28:"(.?.+?)/page/?([0-9]{1,})/?$";s:48:"index.php?pagename=$matches[1]&paged=$matches[2]";s:35:"(.?.+?)/comment-page-([0-9]{1,})/?$";s:48:"index.php?pagename=$matches[1]&cpage=$matches[2]";s:24:"(.?.+?)(?:/([0-9]+))?/?$";s:47:"index.php?pagename=$matches[1]&page=$matches[2]";}','yes');
INSERT INTO `miam_options` VALUES (30,'hack_file','0','yes');
INSERT INTO `miam_options` VALUES (31,'blog_charset','UTF-8','yes');
INSERT INTO `miam_options` VALUES (32,'moderation_keys','','no');
INSERT INTO `miam_options` VALUES (33,'active_plugins','a:4:{i:1;s:39:"delicious-recipes/delicious-recipes.php";i:2;s:9:"hello.php";i:3;s:47:"regenerate-thumbnails/regenerate-thumbnails.php";i:4;s:47:"wpvivid-backuprestore/wpvivid-backuprestore.php";}','yes');
INSERT INTO `miam_options` VALUES (34,'category_base','','yes');
INSERT INTO `miam_options` VALUES (35,'ping_sites','http://rpc.pingomatic.com/','yes');
INSERT INTO `miam_options` VALUES (36,'comment_max_links','2','yes');
INSERT INTO `miam_options` VALUES (37,'gmt_offset','0','yes');
INSERT INTO `miam_options` VALUES (38,'default_email_category','1','yes');
INSERT INTO `miam_options` VALUES (39,'recently_edited','','no');
INSERT INTO `miam_options` VALUES (40,'template','cookery-lite','yes');
INSERT INTO `miam_options` VALUES (41,'stylesheet','cookery-lite','yes');
INSERT INTO `miam_options` VALUES (42,'comment_registration','0','yes');
INSERT INTO `miam_options` VALUES (43,'html_type','text/html','yes');
INSERT INTO `miam_options` VALUES (44,'use_trackback','0','yes');
INSERT INTO `miam_options` VALUES (45,'default_role','subscriber','yes');
INSERT INTO `miam_options` VALUES (46,'db_version','57155','yes');
INSERT INTO `miam_options` VALUES (47,'uploads_use_yearmonth_folders','1','yes');
INSERT INTO `miam_options` VALUES (48,'upload_path','','yes');
INSERT INTO `miam_options` VALUES (49,'blog_public','1','yes');
INSERT INTO `miam_options` VALUES (50,'default_link_category','2','yes');
INSERT INTO `miam_options` VALUES (51,'show_on_front','posts','yes');
INSERT INTO `miam_options` VALUES (52,'tag_base','','yes');
INSERT INTO `miam_options` VALUES (53,'show_avatars','1','yes');
INSERT INTO `miam_options` VALUES (54,'avatar_rating','G','yes');
INSERT INTO `miam_options` VALUES (55,'upload_url_path','','yes');
INSERT INTO `miam_options` VALUES (56,'thumbnail_size_w','150','yes');
INSERT INTO `miam_options` VALUES (57,'thumbnail_size_h','150','yes');
INSERT INTO `miam_options` VALUES (58,'thumbnail_crop','1','yes');
INSERT INTO `miam_options` VALUES (59,'medium_size_w','300','yes');
INSERT INTO `miam_options` VALUES (60,'medium_size_h','300','yes');
INSERT INTO `miam_options` VALUES (61,'avatar_default','mystery','yes');
INSERT INTO `miam_options` VALUES (62,'large_size_w','1024','yes');
INSERT INTO `miam_options` VALUES (63,'large_size_h','1024','yes');
INSERT INTO `miam_options` VALUES (64,'image_default_link_type','none','yes');
INSERT INTO `miam_options` VALUES (65,'image_default_size','','yes');
INSERT INTO `miam_options` VALUES (66,'image_default_align','','yes');
INSERT INTO `miam_options` VALUES (67,'close_comments_for_old_posts','0','yes');
INSERT INTO `miam_options` VALUES (68,'close_comments_days_old','14','yes');
INSERT INTO `miam_options` VALUES (69,'thread_comments','1','yes');
INSERT INTO `miam_options` VALUES (70,'thread_comments_depth','5','yes');
INSERT INTO `miam_options` VALUES (71,'page_comments','0','yes');
INSERT INTO `miam_options` VALUES (72,'comments_per_page','50','yes');
INSERT INTO `miam_options` VALUES (73,'default_comments_page','newest','yes');
INSERT INTO `miam_options` VALUES (74,'comment_order','asc','yes');
INSERT INTO `miam_options` VALUES (75,'sticky_posts','a:0:{}','yes');
INSERT INTO `miam_options` VALUES (76,'widget_categories','a:2:{i:1;a:0:{}s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `miam_options` VALUES (77,'widget_text','a:2:{i:1;a:0:{}s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `miam_options` VALUES (78,'widget_rss','a:2:{i:1;a:0:{}s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `miam_options` VALUES (79,'uninstall_plugins','a:0:{}','no');
INSERT INTO `miam_options` VALUES (80,'timezone_string','Europe/Paris','yes');
INSERT INTO `miam_options` VALUES (81,'page_for_posts','0','yes');
INSERT INTO `miam_options` VALUES (82,'page_on_front','0','yes');
INSERT INTO `miam_options` VALUES (83,'default_post_format','0','yes');
INSERT INTO `miam_options` VALUES (84,'link_manager_enabled','0','yes');
INSERT INTO `miam_options` VALUES (85,'finished_splitting_shared_terms','1','yes');
INSERT INTO `miam_options` VALUES (86,'site_icon','0','yes');
INSERT INTO `miam_options` VALUES (87,'medium_large_size_w','768','yes');
INSERT INTO `miam_options` VALUES (88,'medium_large_size_h','0','yes');
INSERT INTO `miam_options` VALUES (89,'wp_page_for_privacy_policy','3','yes');
INSERT INTO `miam_options` VALUES (90,'show_comments_cookies_opt_in','1','yes');
INSERT INTO `miam_options` VALUES (91,'admin_email_lifespan','1706874012','yes');
INSERT INTO `miam_options` VALUES (92,'disallowed_keys','','no');
INSERT INTO `miam_options` VALUES (93,'comment_previously_approved','1','yes');
INSERT INTO `miam_options` VALUES (94,'auto_plugin_theme_update_emails','a:0:{}','no');
INSERT INTO `miam_options` VALUES (95,'auto_update_core_dev','enabled','yes');
INSERT INTO `miam_options` VALUES (96,'auto_update_core_minor','enabled','yes');
INSERT INTO `miam_options` VALUES (97,'auto_update_core_major','enabled','yes');
INSERT INTO `miam_options` VALUES (98,'wp_force_deactivated_plugins','a:0:{}','yes');
INSERT INTO `miam_options` VALUES (99,'initial_db_version','53496','yes');
INSERT INTO `miam_options` VALUES (100,'miam_user_roles','a:7:{s:13:"administrator";a:2:{s:4:"name";s:13:"Administrator";s:12:"capabilities";a:63:{s:13:"switch_themes";b:1;s:11:"edit_themes";b:1;s:16:"activate_plugins";b:1;s:12:"edit_plugins";b:1;s:10:"edit_users";b:1;s:10:"edit_files";b:1;s:14:"manage_options";b:1;s:17:"moderate_comments";b:1;s:17:"manage_categories";b:1;s:12:"manage_links";b:1;s:12:"upload_files";b:1;s:6:"import";b:1;s:15:"unfiltered_html";b:1;s:10:"edit_posts";b:1;s:17:"edit_others_posts";b:1;s:20:"edit_published_posts";b:1;s:13:"publish_posts";b:1;s:10:"edit_pages";b:1;s:4:"read";b:1;s:8:"level_10";b:1;s:7:"level_9";b:1;s:7:"level_8";b:1;s:7:"level_7";b:1;s:7:"level_6";b:1;s:7:"level_5";b:1;s:7:"level_4";b:1;s:7:"level_3";b:1;s:7:"level_2";b:1;s:7:"level_1";b:1;s:7:"level_0";b:1;s:17:"edit_others_pages";b:1;s:20:"edit_published_pages";b:1;s:13:"publish_pages";b:1;s:12:"delete_pages";b:1;s:19:"delete_others_pages";b:1;s:22:"delete_published_pages";b:1;s:12:"delete_posts";b:1;s:19:"delete_others_posts";b:1;s:22:"delete_published_posts";b:1;s:20:"delete_private_posts";b:1;s:18:"edit_private_posts";b:1;s:18:"read_private_posts";b:1;s:20:"delete_private_pages";b:1;s:18:"edit_private_pages";b:1;s:18:"read_private_pages";b:1;s:12:"delete_users";b:1;s:12:"create_users";b:1;s:17:"unfiltered_upload";b:1;s:14:"edit_dashboard";b:1;s:14:"update_plugins";b:1;s:14:"delete_plugins";b:1;s:15:"install_plugins";b:1;s:13:"update_themes";b:1;s:14:"install_themes";b:1;s:11:"update_core";b:1;s:10:"list_users";b:1;s:12:"remove_users";b:1;s:13:"promote_users";b:1;s:18:"edit_theme_options";b:1;s:13:"delete_themes";b:1;s:6:"export";b:1;s:22:"edit_delicious_recipes";b:1;s:23:"edit_delicious_settings";b:1;}}s:6:"editor";a:2:{s:4:"name";s:6:"Editor";s:12:"capabilities";a:35:{s:17:"moderate_comments";b:1;s:17:"manage_categories";b:1;s:12:"manage_links";b:1;s:12:"upload_files";b:1;s:15:"unfiltered_html";b:1;s:10:"edit_posts";b:1;s:17:"edit_others_posts";b:1;s:20:"edit_published_posts";b:1;s:13:"publish_posts";b:1;s:10:"edit_pages";b:1;s:4:"read";b:1;s:7:"level_7";b:1;s:7:"level_6";b:1;s:7:"level_5";b:1;s:7:"level_4";b:1;s:7:"level_3";b:1;s:7:"level_2";b:1;s:7:"level_1";b:1;s:7:"level_0";b:1;s:17:"edit_others_pages";b:1;s:20:"edit_published_pages";b:1;s:13:"publish_pages";b:1;s:12:"delete_pages";b:1;s:19:"delete_others_pages";b:1;s:22:"delete_published_pages";b:1;s:12:"delete_posts";b:1;s:19:"delete_others_posts";b:1;s:22:"delete_published_posts";b:1;s:20:"delete_private_posts";b:1;s:18:"edit_private_posts";b:1;s:18:"read_private_posts";b:1;s:20:"delete_private_pages";b:1;s:18:"edit_private_pages";b:1;s:18:"read_private_pages";b:1;s:22:"edit_delicious_recipes";b:1;}}s:6:"author";a:2:{s:4:"name";s:6:"Author";s:12:"capabilities";a:11:{s:12:"upload_files";b:1;s:10:"edit_posts";b:1;s:20:"edit_published_posts";b:1;s:13:"publish_posts";b:1;s:4:"read";b:1;s:7:"level_2";b:1;s:7:"level_1";b:1;s:7:"level_0";b:1;s:12:"delete_posts";b:1;s:22:"delete_published_posts";b:1;s:22:"edit_delicious_recipes";b:1;}}s:11:"contributor";a:2:{s:4:"name";s:11:"Contributor";s:12:"capabilities";a:6:{s:10:"edit_posts";b:1;s:4:"read";b:1;s:7:"level_1";b:1;s:7:"level_0";b:1;s:12:"delete_posts";b:1;s:22:"edit_delicious_recipes";b:1;}}s:10:"subscriber";a:2:{s:4:"name";s:10:"Subscriber";s:12:"capabilities";a:2:{s:4:"read";b:1;s:7:"level_0";b:1;}}s:24:"delicious_recipes_editor";a:2:{s:4:"name";s:22:"Éditeur de la recette";s:12:"capabilities";a:23:{s:17:"manage_categories";i:1;s:12:"upload_files";i:1;s:15:"unfiltered_html";i:1;s:10:"edit_posts";i:1;s:17:"edit_others_posts";i:1;s:20:"edit_published_posts";i:1;s:13:"publish_posts";i:1;s:4:"read";i:1;s:12:"delete_posts";i:1;s:19:"delete_others_posts";i:1;s:22:"delete_published_posts";i:1;s:20:"delete_private_posts";i:1;s:18:"edit_private_posts";i:1;s:18:"read_private_posts";i:1;s:7:"level_7";i:1;s:7:"level_6";i:1;s:7:"level_5";i:1;s:7:"level_4";i:1;s:7:"level_3";i:1;s:7:"level_2";i:1;s:7:"level_1";i:1;s:7:"level_0";i:1;s:22:"edit_delicious_recipes";b:1;}}s:28:"delicious_recipes_subscriber";a:2:{s:4:"name";s:21:"Abonné à la recette";s:12:"capabilities";a:2:{s:4:"read";b:1;s:22:"edit_delicious_recipes";b:1;}}}','yes');
INSERT INTO `miam_options` VALUES (101,'fresh_site','0','yes');
INSERT INTO `miam_options` VALUES (102,'WPLANG','fr_FR','yes');
INSERT INTO `miam_options` VALUES (103,'user_count','2','no');
INSERT INTO `miam_options` VALUES (104,'widget_block','a:6:{i:2;a:1:{s:7:"content";s:19:"<!-- wp:search /-->";}i:3;a:1:{s:7:"content";s:159:"<!-- wp:group --><div class="wp-block-group"><!-- wp:heading --><h2>Articles récents</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->";}i:4;a:1:{s:7:"content";s:233:"<!-- wp:group --><div class="wp-block-group"><!-- wp:heading --><h2>Commentaires récents</h2><!-- /wp:heading --><!-- wp:latest-comments {"displayAvatar":false,"displayDate":false,"displayExcerpt":false} /--></div><!-- /wp:group -->";}i:5;a:1:{s:7:"content";s:146:"<!-- wp:group --><div class="wp-block-group"><!-- wp:heading --><h2>Archives</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->";}i:6;a:1:{s:7:"content";s:151:"<!-- wp:group --><div class="wp-block-group"><!-- wp:heading --><h2>Catégories</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->";}s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `miam_options` VALUES (105,'sidebars_widgets','a:12:{s:19:"wp_inactive_widgets";a:0:{}s:24:"delicious-recipe-sidebar";a:0:{}s:7:"sidebar";a:5:{i:0;s:7:"block-2";i:1;s:7:"block-3";i:2;s:7:"block-4";i:3;s:7:"block-5";i:4;s:7:"block-6";}s:5:"promo";a:0:{}s:5:"about";a:0:{}s:3:"cta";a:0:{}s:6:"client";a:0:{}s:10:"footer-one";a:0:{}s:10:"footer-two";a:0:{}s:12:"footer-three";a:0:{}s:11:"footer-four";a:0:{}s:13:"array_version";i:3;}','yes');
INSERT INTO `miam_options` VALUES (106,'cron','a:11:{i:1722733201;a:1:{s:33:"wpvivid_clean_backup_record_event";a:1:{s:32:"0844e7f0f7784a2801e2e9e5ec32b5ca";a:2:{s:8:"schedule";b:0;s:4:"args";a:1:{i:0;s:21:"wpvivid-66aad855b01eb";}}}}i:1722733261;a:1:{s:28:"wpvivid_task_monitor_event_2";a:1:{s:32:"2e1147941acc862673090e991679950f";a:2:{s:8:"schedule";b:0;s:4:"args";a:1:{i:0;s:21:"wpvivid-66aed255521f8";}}}}i:1722734191;a:1:{s:29:"wp_session_garbage_collection";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:6:"hourly";s:4:"args";a:0:{}s:8:"interval";i:3600;}}}i:1722735613;a:1:{s:34:"wp_privacy_delete_old_export_files";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:6:"hourly";s:4:"args";a:0:{}s:8:"interval";i:3600;}}}i:1722771613;a:5:{s:32:"recovery_mode_clean_expired_keys";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:5:"daily";s:4:"args";a:0:{}s:8:"interval";i:86400;}}s:18:"wp_https_detection";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:10:"twicedaily";s:4:"args";a:0:{}s:8:"interval";i:43200;}}s:16:"wp_version_check";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:10:"twicedaily";s:4:"args";a:0:{}s:8:"interval";i:43200;}}s:17:"wp_update_plugins";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:10:"twicedaily";s:4:"args";a:0:{}s:8:"interval";i:43200;}}s:16:"wp_update_themes";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:10:"twicedaily";s:4:"args";a:0:{}s:8:"interval";i:43200;}}}i:1722771638;a:3:{s:19:"wp_scheduled_delete";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:5:"daily";s:4:"args";a:0:{}s:8:"interval";i:86400;}}s:25:"delete_expired_transients";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:5:"daily";s:4:"args";a:0:{}s:8:"interval";i:86400;}}s:21:"wp_update_user_counts";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:10:"twicedaily";s:4:"args";a:0:{}s:8:"interval";i:43200;}}}i:1722771639;a:1:{s:30:"wp_scheduled_auto_draft_delete";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:5:"daily";s:4:"args";a:0:{}s:8:"interval";i:86400;}}}i:1722816000;a:1:{s:27:"wpvivid_main_schedule_event";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:13:"wpvivid_daily";s:4:"args";a:0:{}s:8:"interval";i:86400;}}}i:1722858013;a:1:{s:30:"wp_site_health_scheduled_check";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:6:"weekly";s:4:"args";a:0:{}s:8:"interval";i:604800;}}}i:1723222873;a:1:{s:30:"wp_delete_temp_updater_backups";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:6:"weekly";s:4:"args";a:0:{}s:8:"interval";i:604800;}}}s:7:"version";i:2;}','yes');
INSERT INTO `miam_options` VALUES (107,'widget_pages','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `miam_options` VALUES (108,'widget_calendar','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `miam_options` VALUES (109,'widget_archives','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `miam_options` VALUES (110,'widget_media_audio','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `miam_options` VALUES (111,'widget_media_image','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `miam_options` VALUES (112,'widget_media_gallery','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `miam_options` VALUES (113,'widget_media_video','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `miam_options` VALUES (114,'widget_meta','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `miam_options` VALUES (115,'widget_search','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `miam_options` VALUES (116,'widget_recent-posts','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `miam_options` VALUES (117,'widget_recent-comments','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `miam_options` VALUES (118,'widget_tag_cloud','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `miam_options` VALUES (119,'widget_nav_menu','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `miam_options` VALUES (120,'widget_custom_html','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `miam_options` VALUES (122,'theme_mods_twentytwentythree','a:2:{s:18:"custom_css_post_id";i:-1;s:16:"sidebars_widgets";a:2:{s:4:"time";i:1691324057;s:4:"data";a:3:{s:19:"wp_inactive_widgets";a:0:{}s:9:"sidebar-1";a:3:{i:0;s:7:"block-2";i:1;s:7:"block-3";i:2;s:7:"block-4";}s:9:"sidebar-2";a:2:{i:0;s:7:"block-5";i:1;s:7:"block-6";}}}}','no');
INSERT INTO `miam_options` VALUES (123,'recovery_keys','a:0:{}','yes');
INSERT INTO `miam_options` VALUES (124,'https_detection_errors','a:0:{}','yes');
INSERT INTO `miam_options` VALUES (155,'recently_activated','a:0:{}','yes');
INSERT INTO `miam_options` VALUES (157,'widget_akismet_widget','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `miam_options` VALUES (160,'finished_updating_comment_type','1','yes');
INSERT INTO `miam_options` VALUES (168,'current_theme','Cookery Lite','yes');
INSERT INTO `miam_options` VALUES (169,'theme_mods_blossom-recipe','a:4:{i:0;b:0;s:18:"nav_menu_locations";a:0:{}s:18:"custom_css_post_id";i:-1;s:16:"sidebars_widgets";a:2:{s:4:"time";i:1691417695;s:4:"data";a:6:{s:19:"wp_inactive_widgets";a:0:{}s:7:"sidebar";a:5:{i:0;s:7:"block-2";i:1;s:7:"block-3";i:2;s:7:"block-4";i:3;s:7:"block-5";i:4;s:7:"block-6";}s:18:"newsletter-section";a:0:{}s:10:"footer-one";a:0:{}s:10:"footer-two";a:0:{}s:12:"footer-three";a:0:{}}}}','no');
INSERT INTO `miam_options` VALUES (170,'theme_switched','','yes');
INSERT INTO `miam_options` VALUES (175,'fs_active_plugins','O:8:"stdClass":3:{s:7:"plugins";a:1:{s:34:"delicious-recipes/src/lib/freemius";O:8:"stdClass":4:{s:7:"version";s:6:"2.5.10";s:4:"type";s:6:"plugin";s:9:"timestamp";i:1691331349;s:11:"plugin_path";s:39:"delicious-recipes/delicious-recipes.php";}}s:7:"abspath";s:22:"/home/vicqorgvmv/miam/";s:6:"newest";O:8:"stdClass":5:{s:11:"plugin_path";s:39:"delicious-recipes/delicious-recipes.php";s:8:"sdk_path";s:34:"delicious-recipes/src/lib/freemius";s:7:"version";s:6:"2.5.10";s:13:"in_activation";b:0;s:9:"timestamp";i:1691331349;}}','yes');
INSERT INTO `miam_options` VALUES (176,'fs_debug_mode','','yes');
INSERT INTO `miam_options` VALUES (177,'fs_accounts','a:6:{s:21:"id_slug_type_path_map";a:1:{i:7284;a:3:{s:4:"slug";s:17:"delicious-recipes";s:4:"type";s:6:"plugin";s:4:"path";s:39:"delicious-recipes/delicious-recipes.php";}}s:11:"plugin_data";a:1:{s:17:"delicious-recipes";a:16:{s:16:"plugin_main_file";O:8:"stdClass":1:{s:4:"path";s:39:"delicious-recipes/delicious-recipes.php";}s:20:"is_network_activated";b:0;s:17:"install_timestamp";i:1691324092;s:17:"was_plugin_loaded";b:1;s:21:"is_plugin_new_install";b:0;s:16:"sdk_last_version";N;s:11:"sdk_version";s:6:"2.5.10";s:16:"sdk_upgrade_mode";b:1;s:18:"sdk_downgrade_mode";b:0;s:19:"plugin_last_version";s:5:"1.6.6";s:14:"plugin_version";s:5:"1.6.7";s:19:"plugin_upgrade_mode";b:1;s:21:"plugin_downgrade_mode";b:0;s:17:"connectivity_test";a:6:{s:12:"is_connected";N;s:4:"host";s:13:"miam.vicq.org";s:9:"server_ip";s:11:"10.11.20.98";s:9:"is_active";b:1;s:9:"timestamp";i:1691324092;s:7:"version";s:5:"1.5.3";}s:15:"prev_is_premium";b:0;s:21:"is_pending_activation";b:1;}}s:13:"file_slug_map";a:1:{s:39:"delicious-recipes/delicious-recipes.php";s:17:"delicious-recipes";}s:7:"plugins";a:1:{s:17:"delicious-recipes";O:9:"FS_Plugin":24:{s:16:"parent_plugin_id";N;s:5:"title";s:12:"WP Delicious";s:4:"slug";s:17:"delicious-recipes";s:12:"premium_slug";s:25:"delicious-recipes-premium";s:4:"type";s:6:"plugin";s:20:"affiliate_moderation";b:0;s:19:"is_wp_org_compliant";b:1;s:22:"premium_releases_count";N;s:4:"file";s:39:"delicious-recipes/delicious-recipes.php";s:7:"version";s:5:"1.6.7";s:11:"auto_update";N;s:4:"info";N;s:10:"is_premium";b:0;s:14:"premium_suffix";s:9:"(Premium)";s:7:"is_live";b:1;s:9:"bundle_id";N;s:17:"bundle_public_key";N;s:17:"opt_in_moderation";N;s:10:"public_key";s:32:"pk_85490c48c376203d6194ac3de232e";s:10:"secret_key";N;s:2:"id";s:4:"7284";s:7:"updated";N;s:7:"created";N;s:22:"\0FS_Entity\0_is_updated";b:1;}}s:9:"unique_id";s:32:"cef976bd18a38cfccff5f70d6ba91ef5";s:13:"admin_notices";a:1:{s:17:"delicious-recipes";a:0:{}}}','yes');
INSERT INTO `miam_options` VALUES (178,'fs_api_cache','a:0:{}','no');
INSERT INTO `miam_options` VALUES (181,'delicious_recipes_recipe-search_page_id','5','yes');
INSERT INTO `miam_options` VALUES (182,'delicious_recipes_recipe-dashboard_page_id','6','yes');
INSERT INTO `miam_options` VALUES (183,'delicious_recipes_demo_imports','a:1:{s:22:"delicious_demo_imports";a:2:{s:19:"created_demo_recipe";b:1;s:23:"created_demo_taxonomies";b:1;}}','yes');
INSERT INTO `miam_options` VALUES (184,'delicious_recipes_queue_flush_rewrite_rules','no','yes');
INSERT INTO `miam_options` VALUES (185,'widget_delicious_featured_recipes_widget','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `miam_options` VALUES (186,'widget_delicious_popular_recipes_widget','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `miam_options` VALUES (187,'widget_delicious_recent_recipes_widget','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `miam_options` VALUES (188,'widget_delicious_recipe_categories_widget','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `miam_options` VALUES (189,'widget_delicious_popular_tags_widget','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `miam_options` VALUES (190,'widget_delicious_recipe_keys_widget','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `miam_options` VALUES (191,'delicious_recipes_first_time_activation_flag','true','yes');
INSERT INTO `miam_options` VALUES (201,'delicious_recipe_settings','a:104:{s:24:"displayRecipesOnHomepage";a:1:{i:0;s:3:"yes";}s:13:"recipePerPage";s:2:"10";s:22:"enableRecipeSingleHead";a:1:{i:0;s:3:"yes";}s:25:"enableRecipeFeaturedImage";a:1:{i:0;s:3:"yes";}s:22:"ingredientStringFormat";s:33:"{qty} {unit} {ingredient} {notes}";s:21:"showAdjustableServing";a:1:{i:0;s:3:"yes";}s:11:"useFraction";a:1:{i:0;s:2:"no";}s:21:"adjustableServingType";s:9:"increment";s:13:"recipeToggles";a:25:{i:0;a:4:{s:5:"label";s:14:"Auteur/autrice";s:3:"key";s:6:"author";s:2:"id";s:9:"dr-author";s:6:"enable";a:1:{i:0;s:3:"yes";}}i:1;a:4:{s:5:"label";s:5:"Plats";s:3:"key";s:8:"category";s:2:"id";s:11:"dr-category";s:6:"enable";a:1:{i:0;s:3:"yes";}}i:2;a:4:{s:5:"label";s:19:"Méthode de cuisson";s:3:"key";s:13:"cookingMethod";s:2:"id";s:17:"dr-cooking-method";s:6:"enable";a:1:{i:0;s:3:"yes";}}i:3;a:4:{s:5:"label";s:7:"Cuisine";s:3:"key";s:7:"cuisine";s:2:"id";s:10:"dr-cuisine";s:6:"enable";a:1:{i:0;s:3:"yes";}}i:4;a:4:{s:5:"label";s:11:"Difficulté";s:3:"key";s:15:"difficultyLevel";s:2:"id";s:19:"dr-difficulty-level";s:6:"enable";a:1:{i:0;s:3:"yes";}}i:5;a:4:{s:5:"label";s:11:"Description";s:3:"key";s:11:"description";s:2:"id";s:14:"dr-description";s:6:"enable";a:1:{i:0;s:3:"yes";}}i:6;a:4:{s:5:"label";s:21:"Temps de préparation";s:3:"key";s:8:"prepTime";s:2:"id";s:12:"dr-prep-time";s:6:"enable";a:1:{i:0;s:3:"yes";}}i:7;a:4:{s:5:"label";s:16:"Temps de cuisson";s:3:"key";s:8:"cookTime";s:2:"id";s:12:"dr-cook-time";s:6:"enable";a:1:{i:0;s:3:"yes";}}i:8;a:4:{s:5:"label";s:14:"Temps de repos";s:3:"key";s:8:"restTime";s:2:"id";s:12:"dr-rest-time";s:6:"enable";a:1:{i:0;s:3:"yes";}}i:9;a:4:{s:5:"label";s:11:"Temps total";s:3:"key";s:9:"totalTime";s:2:"id";s:13:"dr-total-time";s:6:"enable";a:1:{i:0;s:3:"yes";}}i:10;a:4:{s:5:"label";s:8:"Portions";s:3:"key";s:8:"servings";s:2:"id";s:11:"dr-servings";s:6:"enable";a:1:{i:0;s:3:"yes";}}i:11;a:4:{s:5:"label";s:8:"Calories";s:3:"key";s:8:"calories";s:2:"id";s:11:"dr-calories";s:6:"enable";a:0:{}}i:12;a:4:{s:5:"label";s:16:"Meilleure saison";s:3:"key";s:10:"bestSeason";s:2:"id";s:14:"dr-best-season";s:6:"enable";a:1:{i:0;s:3:"yes";}}i:13;a:4:{s:5:"label";s:23:"Thématiques de recette";s:3:"key";s:10:"recipeKeys";s:2:"id";s:14:"dr-recipe-keys";s:6:"enable";a:1:{i:0;s:3:"yes";}}i:14;a:4:{s:5:"label";s:6:"Vidéo";s:3:"key";s:5:"video";s:2:"id";s:8:"dr-video";s:6:"enable";a:1:{i:0;s:3:"yes";}}i:15;a:4:{s:5:"label";s:19:"Aller à la recette";s:3:"key";s:12:"jumpToRecipe";s:2:"id";s:17:"dr-jump-to-recipe";s:6:"enable";a:1:{i:0;s:3:"yes";}}i:16;a:4:{s:5:"label";s:10:"Mots clés";s:3:"key";s:8:"keywords";s:2:"id";s:11:"dr-keywords";s:6:"enable";a:1:{i:0;s:3:"yes";}}i:17;a:4:{s:5:"label";s:13:"Archiver sous";s:3:"key";s:9:"fileUnder";s:2:"id";s:13:"dr-file-under";s:6:"enable";a:1:{i:0;s:3:"yes";}}i:18;a:4:{s:5:"label";s:4:"Note";s:3:"key";s:5:"notes";s:2:"id";s:8:"dr-notes";s:6:"enable";a:1:{i:0;s:3:"yes";}}i:19;a:4:{s:5:"label";s:18:"Aller à la vidéo";s:3:"key";s:11:"jumpToVideo";s:2:"id";s:16:"dr-jump-to-video";s:6:"enable";a:1:{i:0;s:3:"yes";}}i:20;a:4:{s:5:"label";s:23:"Marquer comme réalisé";s:3:"key";s:14:"markAsComplete";s:2:"id";s:19:"dr-mark-as-complete";s:6:"enable";a:0:{}}i:21;a:4:{s:5:"label";s:19:"Ajouter aux Favoris";s:3:"key";s:13:"addToWishlist";s:2:"id";s:18:"dr-add-to-wishlist";s:6:"enable";a:1:{i:0;s:3:"yes";}}i:22;a:4:{s:5:"label";s:12:"Cooking Temp";s:3:"key";s:11:"cookingTemp";s:2:"id";s:15:"dr-cooking-temp";s:6:"enable";a:1:{i:0;s:3:"yes";}}i:23;a:4:{s:5:"label";s:14:"Estimated Cost";s:3:"key";s:13:"estimatedCost";s:2:"id";s:17:"dr-estiamted-cost";s:6:"enable";a:1:{i:0;s:3:"yes";}}i:24;a:4:{s:5:"label";s:7:"Dietary";s:3:"key";s:7:"dietary";s:2:"id";s:10:"dr-dietary";s:6:"enable";a:1:{i:0;s:3:"yes";}}}s:16:"enableNavigation";a:0:{}s:15:"enablePoweredBy";a:0:{}s:13:"affiliateLink";s:0:"";s:18:"enableRecipeAuthor";a:1:{i:0;s:3:"yes";}s:19:"enablePublishedDate";a:1:{i:0;s:3:"yes";}s:14:"enableComments";a:1:{i:0;s:3:"yes";}s:21:"enableRecipeImageCrop";a:1:{i:0;s:3:"yes";}s:28:"enableRecipeArchiveImageCrop";a:1:{i:0;s:3:"yes";}s:11:"enablePinit";a:1:{i:0;s:3:"yes";}s:19:"enableArchiveHeader";a:0:{}s:12:"archiveTitle";s:18:"Index des recettes";s:18:"archiveDescription";s:0:"";s:21:"taxPagesTermsBoxTitle";s:23:"Affinez votre recherche";s:20:"defaultArchiveLayout";s:4:"grid";s:22:"archivePaginationStyle";s:6:"simple";s:12:"primaryColor";s:7:"#2db68d";s:15:"primaryColorRGB";s:12:"45, 182, 141";s:14:"secondaryColor";s:7:"#279bc2";s:17:"secondaryColorRGB";s:11:"232, 78, 59";s:17:"defaultCardLayout";s:7:"default";s:10:"recipeBase";s:7:"recette";s:10:"courseBase";s:4:"plat";s:11:"cuisineBase";s:7:"cuisine";s:17:"cookingMethodBase";s:7:"cuisson";s:7:"keyBase";s:4:"clef";s:7:"tagBase";s:3:"tag";s:9:"badgeBase";s:5:"badge";s:11:"dietaryBase";s:14:"recipe-dietary";s:17:"enableSocialShare";a:0:{}s:16:"recipeShareTitle";s:31:"Avez-vous fait cette recette ?";s:11:"socialShare";a:2:{i:0;a:3:{s:6:"social";s:9:"Instagram";s:6:"enable";a:0:{}s:7:"content";s:0:"";}i:1;a:3:{s:6:"social";s:9:"Pinterest";s:6:"enable";a:0:{}s:7:"content";s:0:"";}}s:13:"enableRatings";a:1:{i:0;s:3:"yes";}s:11:"ratingLabel";s:22:"Évaluer cette recette";s:19:"enableAuthorProfile";s:0:"";s:23:"showAuthorArchiveHeader";s:0:"";s:12:"recipeAuthor";s:0:"";s:10:"authorName";s:0:"";s:14:"authorSubtitle";s:0:"";s:17:"authorDescription";s:0:"";s:11:"authorImage";s:0:"";s:18:"authorImagePreview";s:0:"";s:22:"showAuthorProfileLinks";a:1:{i:0;s:3:"yes";}s:12:"facebookLink";s:0:"";s:13:"instagramLink";s:0:"";s:13:"pinterestLink";s:0:"";s:11:"twitterLink";s:0:"";s:11:"youtubeLink";s:0:"";s:12:"snapchatLink";s:0:"";s:12:"linkedinLink";s:0:"";s:20:"enablePrintRecipeBtn";a:1:{i:0;s:3:"yes";}s:18:"printRecipeBtnText";s:19:"Imprimer la recette";s:14:"printLogoImage";s:0:"";s:21:"printLogoImagePreview";s:0:"";s:17:"printPreviewStyle";s:5:"_self";s:23:"allowPrintCustomization";a:1:{i:0;s:3:"yes";}s:12:"printOptions";a:12:{i:0;a:2:{s:3:"key";s:5:"Titre";s:6:"enable";a:1:{i:0;s:3:"yes";}}i:1;a:2:{s:3:"key";s:4:"Info";s:6:"enable";a:1:{i:0;s:3:"yes";}}i:2;a:2:{s:3:"key";s:11:"Description";s:6:"enable";a:1:{i:0;s:3:"yes";}}i:3;a:2:{s:3:"key";s:6:"Images";s:6:"enable";a:1:{i:0;s:3:"yes";}}i:4;a:2:{s:3:"key";s:12:"Ingrédients";s:6:"enable";a:1:{i:0;s:3:"yes";}}i:5;a:2:{s:3:"key";s:12:"Instructions";s:6:"enable";a:1:{i:0;s:3:"yes";}}i:6;a:2:{s:3:"key";s:23:"Valeurs nutritionnelles";s:6:"enable";a:1:{i:0;s:3:"yes";}}i:7;a:2:{s:3:"key";s:5:"Notes";s:6:"enable";a:1:{i:0;s:3:"yes";}}i:8;a:2:{s:3:"key";s:33:"Partager sur les réseaux sociaux";s:6:"enable";a:1:{i:0;s:3:"yes";}}i:9;a:2:{s:3:"key";s:32:"Biographie de l’auteur/autrice";s:6:"enable";a:1:{i:0;s:3:"yes";}}i:10;a:2:{s:3:"key";s:21:"Note de remerciements";s:6:"enable";a:1:{i:0;s:3:"yes";}}i:11;a:2:{s:3:"key";s:14:"Recipe Content";s:6:"enable";a:1:{i:0;s:2:"no";}}}s:15:"embedRecipeLink";a:1:{i:0;s:3:"yes";}s:15:"recipeLinkLabel";s:20:"Lisez-le en ligne :";s:24:"displaySocialSharingInfo";a:1:{i:0;s:3:"yes";}s:15:"embedAuthorInfo";a:1:{i:0;s:3:"yes";}s:15:"thankyouMessage";s:0:"";s:18:"showNutritionFacts";a:1:{i:0;s:3:"yes";}s:19:"nutritionFactsLabel";s:23:"Valeurs nutritionnelles";s:20:"nutritionChartLayout";s:7:"default";s:20:"dailyValueDisclaimer";s:186:"Les pourcentages des valeurs quotidiennes sont basés sur un régime à 2 000 calories. Votre valeur quotidienne peut être plus ou moins élevée en fonction de vos besoins caloriques.";s:19:"displayStandardMode";s:0:"";s:26:"displayNutritionZeroValues";s:0:"";s:23:"disablePercentageValues";s:0:"";s:27:"additionalNutritionElements";a:0:{}s:10:"searchPage";s:0:"";s:16:"displaySearchBar";a:1:{i:0;s:3:"yes";}s:11:"searchLogic";s:3:"AND";s:13:"searchFilters";a:13:{i:0;a:3:{s:5:"label";s:6:"Saison";s:3:"key";s:6:"season";s:6:"enable";a:1:{i:0;s:3:"yes";}}i:1;a:3:{s:5:"label";s:7:"Cuisine";s:3:"key";s:7:"cuisine";s:6:"enable";a:1:{i:0;s:3:"yes";}}i:2;a:3:{s:5:"label";s:15:"Type de recette";s:3:"key";s:11:"recipe-type";s:6:"enable";a:1:{i:0;s:3:"yes";}}i:3;a:3:{s:5:"label";s:19:"Méthode de cuisson";s:3:"key";s:14:"cooking-method";s:6:"enable";a:1:{i:0;s:3:"yes";}}i:4;a:3:{s:5:"label";s:11:"Difficulté";s:3:"key";s:10:"difficulty";s:6:"enable";a:1:{i:0;s:3:"yes";}}i:5;a:3:{s:5:"label";s:12:"Ingrédients";s:3:"key";s:11:"ingredients";s:6:"enable";a:1:{i:0;s:3:"yes";}}i:6;a:3:{s:5:"label";s:14:"Facteur simple";s:3:"key";s:13:"simple-factor";s:6:"enable";a:1:{i:0;s:3:"yes";}}i:7;a:3:{s:5:"label";s:3:"Tri";s:3:"key";s:7:"sorting";s:6:"enable";a:1:{i:0;s:3:"yes";}}i:8;a:3:{s:5:"label";s:23:"Thématiques de recette";s:3:"key";s:11:"recipe-keys";s:6:"enable";a:0:{}}i:9;a:3:{s:5:"label";s:24:"Mots-clés de la recette";s:3:"key";s:11:"recipe-tags";s:6:"enable";a:0:{}}i:10;a:3:{s:5:"label";s:14:"Réinitialiser";s:3:"key";s:5:"reset";s:6:"enable";a:1:{i:0;s:3:"yes";}}i:11;a:3:{s:5:"label";s:18:"badges de recettes";s:3:"key";s:13:"recipe-badges";s:6:"enable";a:1:{i:0;s:3:"yes";}}i:12;a:3:{s:5:"label";s:14:"Recipe Dietary";s:3:"key";s:14:"recipe-dietary";s:6:"enable";a:1:{i:0;s:3:"yes";}}}s:16:"disableFAIconsJS";a:0:{}s:13:"allowSVGIcons";a:0:{}s:27:"enableDefaultSessionHandler";a:0:{}s:13:"dashboardPage";s:0:"";s:22:"enableUserRegistration";a:1:{i:0;s:3:"yes";}s:16:"recaptchaEnabled";a:0:{}s:16:"recpatchaVersion";s:2:"v3";s:16:"recaptchaSiteKey";s:0:"";s:18:"recaptchaSecretKey";s:0:"";s:16:"generateUsername";a:0:{}s:16:"generatePassword";a:0:{}s:16:"termsNConditions";a:0:{}s:20:"termsNConditionsText";s:108:"En vous inscrivant, vous acceptez nos conditions, notre politique de données et notre politique de cookies.";s:10:"loginImage";s:0:"";s:17:"loginImagePreview";s:0:"";s:17:"registrationImage";s:0:"";s:24:"registrationImagePreview";s:0:"";s:17:"newAccountSubject";s:43:"Votre compte {site_title} a été créé !";s:17:"newAccountContent";s:0:"";s:20:"resetPasswordSubject";s:62:"Demande de réinitialisation de mot de passe pour {site_title}";s:20:"resetPasswordContent";s:0:"";s:11:"customUnits";a:2:{i:0;a:5:{s:4:"unit";s:1:"v";s:8:"singular";s:5:"verre";s:12:"singularAbbr";s:1:"v";s:6:"plural";s:6:"verres";s:10:"pluralAbbr";s:1:"v";}i:1;a:5:{s:4:"unit";s:2:"cl";s:8:"singular";s:10:"Centilitre";s:12:"singularAbbr";s:2:"cl";s:6:"plural";s:11:"Centilitres";s:10:"pluralAbbr";s:2:"cl";}}}','yes');
INSERT INTO `miam_options` VALUES (248,'_transient_health-check-site-status-result','{"good":17,"recommended":6,"critical":0}','yes');
INSERT INTO `miam_options` VALUES (274,'theme_mods_cookery-lite','a:12:{i:0;b:0;s:18:"nav_menu_locations";a:1:{s:7:"primary";i:36;}s:18:"custom_css_post_id";i:-1;s:16:"background_color";s:6:"ededd0";s:12:"social_links";a:0:{}s:19:"post_sidebar_layout";s:8:"centered";s:19:"page_sidebar_layout";s:8:"centered";s:12:"layout_style";s:10:"no-sidebar";s:11:"slider_type";s:14:"latest_recipes";s:22:"featured_recipe_enable";b:0;s:15:"blog_main_title";s:19:"Dernières recettes";s:14:"read_more_text";s:7:"Plus...";}','yes');
INSERT INTO `miam_options` VALUES (330,'recipe-cuisine_children','a:0:{}','yes');
INSERT INTO `miam_options` VALUES (364,'nav_menu_options','a:1:{s:8:"auto_add";a:0:{}}','yes');
INSERT INTO `miam_options` VALUES (385,'db_upgraded','1','yes');
INSERT INTO `miam_options` VALUES (391,'auto_core_update_notified','a:4:{s:4:"type";s:7:"success";s:5:"email";s:13:"alex@vicq.org";s:7:"version";s:5:"6.6.1";s:9:"timestamp";i:1721780141;}','off');
INSERT INTO `miam_options` VALUES (453,'category_children','a:0:{}','yes');
INSERT INTO `miam_options` VALUES (456,'wpvivid_email_setting','a:3:{s:7:"send_to";a:0:{}s:6:"always";b:1;s:12:"email_enable";b:0;}','no');
INSERT INTO `miam_options` VALUES (457,'wpvivid_compress_setting','a:7:{s:13:"compress_type";s:3:"zip";s:13:"max_file_size";i:200;s:11:"no_compress";b:1;s:13:"use_temp_file";i:1;s:13:"use_temp_size";i:16;s:17:"exclude_file_size";i:0;s:24:"subpackage_plugin_upload";b:0;}','no');
INSERT INTO `miam_options` VALUES (458,'wpvivid_local_setting','a:2:{s:4:"path";s:14:"wpvividbackups";s:10:"save_local";i:1;}','no');
INSERT INTO `miam_options` VALUES (459,'wpvivid_upload_setting','a:2:{s:15:"remote_selected";a:0:{}s:28:"wpvivid-remote-64d7887038542";a:9:{s:7:"passive";s:1:"1";s:4:"name";s:8:"ovh-miam";s:6:"server";s:12:"ftp.vicq.org";s:8:"username";s:10:"vicqorgvmv";s:4:"path";s:23:"/backup/wordpress/miam/";s:8:"password";s:16:"RnRwb3ZoMTcxNg==";s:4:"type";s:3:"ftp";s:4:"host";s:12:"ftp.vicq.org";s:10:"is_encrypt";i:1;}}','no');
INSERT INTO `miam_options` VALUES (460,'wpvivid_common_setting','a:10:{s:18:"max_execution_time";i:300;s:17:"log_save_location";s:26:"wpvividbackups/wpvivid_log";s:16:"max_backup_count";i:3;s:14:"show_admin_bar";b:1;s:14:"domain_include";b:1;s:15:"estimate_backup";b:1;s:16:"max_resume_count";i:6;s:12:"memory_limit";s:4:"256M";s:20:"restore_memory_limit";s:4:"512M";s:12:"migrate_size";s:4:"2048";}','no');
INSERT INTO `miam_options` VALUES (461,'wpvivid_init','init','no');
INSERT INTO `miam_options` VALUES (462,'wpvivid_backup_list','a:2:{s:21:"wpvivid-66ac3b4208f3b";a:11:{s:4:"type";s:4:"Cron";s:11:"create_time";i:1722563394;s:13:"manual_delete";i:0;s:5:"local";a:1:{s:4:"path";s:14:"wpvividbackups";}s:8:"compress";a:1:{s:13:"compress_type";s:3:"zip";}s:10:"save_local";b:0;s:13:"backup_prefix";s:13:"miam.vicq.org";s:3:"log";s:96:"/home/vicqorgvmv/miam/wp-content/wpvividbackups/wpvivid_log/wpvivid-66ac3b4208f3b_backup_log.txt";s:6:"backup";a:2:{s:6:"result";s:7:"success";s:5:"files";a:1:{i:0;a:2:{s:9:"file_name";s:67:"miam.vicq.org_wpvivid-66ac3b4208f3b_2024-08-02-03-49_backup_all.zip";s:4:"size";i:50454642;}}}s:6:"remote";a:1:{s:28:"wpvivid-remote-64d7887038542";a:9:{s:7:"passive";s:1:"1";s:4:"name";s:8:"ovh-miam";s:6:"server";s:12:"ftp.vicq.org";s:8:"username";s:10:"vicqorgvmv";s:4:"path";s:23:"/backup/wordpress/miam/";s:8:"password";s:16:"RnRwb3ZoMTcxNg==";s:4:"type";s:3:"ftp";s:4:"host";s:12:"ftp.vicq.org";s:10:"is_encrypt";i:1;}}s:4:"lock";s:1:"0";}s:21:"wpvivid-66ad77be1fd49";a:11:{s:4:"type";s:4:"Cron";s:11:"create_time";i:1722644414;s:13:"manual_delete";i:0;s:5:"local";a:1:{s:4:"path";s:14:"wpvividbackups";}s:8:"compress";a:1:{s:13:"compress_type";s:3:"zip";}s:10:"save_local";b:0;s:13:"backup_prefix";s:13:"miam.vicq.org";s:3:"log";s:96:"/home/vicqorgvmv/miam/wp-content/wpvividbackups/wpvivid_log/wpvivid-66ad77be1fd49_backup_log.txt";s:6:"backup";a:2:{s:6:"result";s:7:"success";s:5:"files";a:1:{i:0;a:2:{s:9:"file_name";s:67:"miam.vicq.org_wpvivid-66ad77be1fd49_2024-08-03-02-20_backup_all.zip";s:4:"size";i:50454594;}}}s:6:"remote";a:1:{s:28:"wpvivid-remote-64d7887038542";a:9:{s:7:"passive";s:1:"1";s:4:"name";s:8:"ovh-miam";s:6:"server";s:12:"ftp.vicq.org";s:8:"username";s:10:"vicqorgvmv";s:4:"path";s:23:"/backup/wordpress/miam/";s:8:"password";s:16:"RnRwb3ZoMTcxNg==";s:4:"type";s:3:"ftp";s:4:"host";s:12:"ftp.vicq.org";s:10:"is_encrypt";i:1;}}s:4:"lock";s:1:"0";}}','off');
INSERT INTO `miam_options` VALUES (463,'wpvivid_remote_init','init','no');
INSERT INTO `miam_options` VALUES (465,'wpvivid_check_htaccess_rule_free','1','yes');
INSERT INTO `miam_options` VALUES (466,'wpvivid_need_review','show','no');
INSERT INTO `miam_options` VALUES (468,'wpvivid_user_history','a:1:{s:15:"remote_selected";a:1:{i:0;s:28:"wpvivid-remote-64d7887038542";}}','no');
INSERT INTO `miam_options` VALUES (469,'clean_task','a:1:{s:21:"wpvivid-66aad855b01eb";a:11:{s:4:"type";s:4:"Cron";s:11:"create_time";i:1722472533;s:13:"manual_delete";i:0;s:5:"local";a:1:{s:4:"path";s:14:"wpvividbackups";}s:8:"compress";a:1:{s:13:"compress_type";s:3:"zip";}s:10:"save_local";b:0;s:13:"backup_prefix";s:13:"miam.vicq.org";s:3:"log";s:96:"/home/vicqorgvmv/miam/wp-content/wpvividbackups/wpvivid_log/wpvivid-66aad855b01eb_backup_log.txt";s:6:"backup";a:2:{s:6:"result";s:7:"success";s:5:"files";a:1:{i:0;a:2:{s:9:"file_name";s:67:"miam.vicq.org_wpvivid-66aad855b01eb_2024-08-01-02-35_backup_all.zip";s:4:"size";i:50445605;}}}s:6:"remote";a:1:{s:28:"wpvivid-remote-64d7887038542";a:9:{s:7:"passive";s:1:"1";s:4:"name";s:8:"ovh-miam";s:6:"server";s:12:"ftp.vicq.org";s:8:"username";s:10:"vicqorgvmv";s:4:"path";s:23:"/backup/wordpress/miam/";s:8:"password";s:16:"RnRwb3ZoMTcxNg==";s:4:"type";s:3:"ftp";s:4:"host";s:12:"ftp.vicq.org";s:10:"is_encrypt";i:1;}}s:4:"lock";s:1:"0";}}','off');
INSERT INTO `miam_options` VALUES (473,'wpvivid_backup_success_count','314','off');
INSERT INTO `miam_options` VALUES (474,'wpvivid_backup_reports','a:178:{s:21:"wpvivid-64d7887fc2ca4";a:3:{s:7:"task_id";s:21:"wpvivid-64d7887fc2ca4";s:11:"backup_time";i:1691846784;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-64d789cd61c81";a:3:{s:7:"task_id";s:21:"wpvivid-64d789cd61c81";s:11:"backup_time";i:1691847118;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-64d82e2be2707";a:3:{s:7:"task_id";s:21:"wpvivid-64d82e2be2707";s:11:"backup_time";i:1691889196;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-64d97f8937265";a:3:{s:7:"task_id";s:21:"wpvivid-64d97f8937265";s:11:"backup_time";i:1691975561;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-64dbe2be497ac";a:3:{s:7:"task_id";s:21:"wpvivid-64dbe2be497ac";s:11:"backup_time";i:1692132030;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-64dcb2295c9b3";a:3:{s:7:"task_id";s:21:"wpvivid-64dcb2295c9b3";s:11:"backup_time";i:1692185129;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-64de1344d9d3b";a:3:{s:7:"task_id";s:21:"wpvivid-64de1344d9d3b";s:11:"backup_time";i:1692275524;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-64df0041e26c1";a:3:{s:7:"task_id";s:21:"wpvivid-64df0041e26c1";s:11:"backup_time";i:1692336194;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-64e0e2c2bd4d8";a:3:{s:7:"task_id";s:21:"wpvivid-64e0e2c2bd4d8";s:11:"backup_time";i:1692459714;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-64e30f9fc40b1";a:3:{s:7:"task_id";s:21:"wpvivid-64e30f9fc40b1";s:11:"backup_time";i:1692602271;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-64e4655eabf76";a:3:{s:7:"task_id";s:21:"wpvivid-64e4655eabf76";s:11:"backup_time";i:1692689758;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-64e5785c4bb96";a:3:{s:7:"task_id";s:21:"wpvivid-64e5785c4bb96";s:11:"backup_time";i:1692760156;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-64e72d3d58ebf";a:3:{s:7:"task_id";s:21:"wpvivid-64e72d3d58ebf";s:11:"backup_time";i:1692871997;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-64e8918798fa7";a:3:{s:7:"task_id";s:21:"wpvivid-64e8918798fa7";s:11:"backup_time";i:1692963207;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-64ea204e37fec";a:3:{s:7:"task_id";s:21:"wpvivid-64ea204e37fec";s:11:"backup_time";i:1693065294;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-64eb579ee67df";a:3:{s:7:"task_id";s:21:"wpvivid-64eb579ee67df";s:11:"backup_time";i:1693144991;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-64ebfa1a3494b";a:3:{s:7:"task_id";s:21:"wpvivid-64ebfa1a3494b";s:11:"backup_time";i:1693186586;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-64ed3e1065e51";a:3:{s:7:"task_id";s:21:"wpvivid-64ed3e1065e51";s:11:"backup_time";i:1693269520;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-64ee91e7398df";a:3:{s:7:"task_id";s:21:"wpvivid-64ee91e7398df";s:11:"backup_time";i:1693356519;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-64f09ad853f7f";a:3:{s:7:"task_id";s:21:"wpvivid-64f09ad853f7f";s:11:"backup_time";i:1693489880;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-64f250a33fa26";a:3:{s:7:"task_id";s:21:"wpvivid-64f250a33fa26";s:11:"backup_time";i:1693601955;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-64f2b789b152e";a:3:{s:7:"task_id";s:21:"wpvivid-64f2b789b152e";s:11:"backup_time";i:1693628297;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-64f478176eff1";a:3:{s:7:"task_id";s:21:"wpvivid-64f478176eff1";s:11:"backup_time";i:1693743127;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-64f577432b447";a:3:{s:7:"task_id";s:21:"wpvivid-64f577432b447";s:11:"backup_time";i:1693808451;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-64f6b4ccb412f";a:3:{s:7:"task_id";s:21:"wpvivid-64f6b4ccb412f";s:11:"backup_time";i:1693889740;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-64f9210c895f7";a:3:{s:7:"task_id";s:21:"wpvivid-64f9210c895f7";s:11:"backup_time";i:1694048524;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65007ba38dfb0";a:3:{s:7:"task_id";s:21:"wpvivid-65007ba38dfb0";s:11:"backup_time";i:1694530467;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-6501aae0b690b";a:3:{s:7:"task_id";s:21:"wpvivid-6501aae0b690b";s:11:"backup_time";i:1694608096;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-6506127e2b4e8";a:3:{s:7:"task_id";s:21:"wpvivid-6506127e2b4e8";s:11:"backup_time";i:1694896766;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65093d6c34af7";a:3:{s:7:"task_id";s:21:"wpvivid-65093d6c34af7";s:11:"backup_time";i:1695104364;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-650d2b67734ce";a:3:{s:7:"task_id";s:21:"wpvivid-650d2b67734ce";s:11:"backup_time";i:1695361895;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-650e909f8dc1a";a:3:{s:7:"task_id";s:21:"wpvivid-650e909f8dc1a";s:11:"backup_time";i:1695453343;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-650ff2b68e944";a:3:{s:7:"task_id";s:21:"wpvivid-650ff2b68e944";s:11:"backup_time";i:1695543990;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65115a13ec52b";a:3:{s:7:"task_id";s:21:"wpvivid-65115a13ec52b";s:11:"backup_time";i:1695635988;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-6518310b5365e";a:3:{s:7:"task_id";s:21:"wpvivid-6518310b5365e";s:11:"backup_time";i:1696084235;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-6519454a1dad2";a:3:{s:7:"task_id";s:21:"wpvivid-6519454a1dad2";s:11:"backup_time";i:1696154954;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-651a6c1a24b9b";a:3:{s:7:"task_id";s:21:"wpvivid-651a6c1a24b9b";s:11:"backup_time";i:1696230426;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-651b7c4c9af03";a:3:{s:7:"task_id";s:21:"wpvivid-651b7c4c9af03";s:11:"backup_time";i:1696300108;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-651d56b072cdd";a:3:{s:7:"task_id";s:21:"wpvivid-651d56b072cdd";s:11:"backup_time";i:1696421552;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-651e99da95be7";a:3:{s:7:"task_id";s:21:"wpvivid-651e99da95be7";s:11:"backup_time";i:1696504282;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-651f5000de70a";a:3:{s:7:"task_id";s:21:"wpvivid-651f5000de70a";s:11:"backup_time";i:1696550913;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-6520b8a068741";a:3:{s:7:"task_id";s:21:"wpvivid-6520b8a068741";s:11:"backup_time";i:1696643232;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-6522d1e730d67";a:3:{s:7:"task_id";s:21:"wpvivid-6522d1e730d67";s:11:"backup_time";i:1696780775;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65234b016c9de";a:3:{s:7:"task_id";s:21:"wpvivid-65234b016c9de";s:11:"backup_time";i:1696811777;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-6524fc0776ad2";a:3:{s:7:"task_id";s:21:"wpvivid-6524fc0776ad2";s:11:"backup_time";i:1696922631;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-6525eecb21af9";a:3:{s:7:"task_id";s:21:"wpvivid-6525eecb21af9";s:11:"backup_time";i:1696984779;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-6527378bdbc68";a:3:{s:7:"task_id";s:21:"wpvivid-6527378bdbc68";s:11:"backup_time";i:1697068940;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-6529059e5f986";a:3:{s:7:"task_id";s:21:"wpvivid-6529059e5f986";s:11:"backup_time";i:1697187230;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-652a298f0b5f7";a:3:{s:7:"task_id";s:21:"wpvivid-652a298f0b5f7";s:11:"backup_time";i:1697261967;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-652b2ced947fa";a:3:{s:7:"task_id";s:21:"wpvivid-652b2ced947fa";s:11:"backup_time";i:1697328365;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-652cd8af4dd92";a:3:{s:7:"task_id";s:21:"wpvivid-652cd8af4dd92";s:11:"backup_time";i:1697437871;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-652df52d3f6c0";a:3:{s:7:"task_id";s:21:"wpvivid-652df52d3f6c0";s:11:"backup_time";i:1697510701;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-6532dd8cdfbf1";a:3:{s:7:"task_id";s:21:"wpvivid-6532dd8cdfbf1";s:11:"backup_time";i:1697832332;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-653552a4e5d96";a:3:{s:7:"task_id";s:21:"wpvivid-653552a4e5d96";s:11:"backup_time";i:1697993381;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-6535ceb97b546";a:3:{s:7:"task_id";s:21:"wpvivid-6535ceb97b546";s:11:"backup_time";i:1698025145;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65374b403c357";a:3:{s:7:"task_id";s:21:"wpvivid-65374b403c357";s:11:"backup_time";i:1698122560;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-6538a76e7bb1b";a:3:{s:7:"task_id";s:21:"wpvivid-6538a76e7bb1b";s:11:"backup_time";i:1698211694;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-653b2177ba8be";a:3:{s:7:"task_id";s:21:"wpvivid-653b2177ba8be";s:11:"backup_time";i:1698374007;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-653d3304b4b8b";a:3:{s:7:"task_id";s:21:"wpvivid-653d3304b4b8b";s:11:"backup_time";i:1698509572;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-653da2e52cfbb";a:3:{s:7:"task_id";s:21:"wpvivid-653da2e52cfbb";s:11:"backup_time";i:1698538213;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-653f240097e0a";a:3:{s:7:"task_id";s:21:"wpvivid-653f240097e0a";s:11:"backup_time";i:1698636800;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65406afabf2db";a:3:{s:7:"task_id";s:21:"wpvivid-65406afabf2db";s:11:"backup_time";i:1698720506;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65419f203095a";a:3:{s:7:"task_id";s:21:"wpvivid-65419f203095a";s:11:"backup_time";i:1698799392;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-6542f18a90ec6";a:3:{s:7:"task_id";s:21:"wpvivid-6542f18a90ec6";s:11:"backup_time";i:1698886026;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65445c7307cf4";a:3:{s:7:"task_id";s:21:"wpvivid-65445c7307cf4";s:11:"backup_time";i:1698978931;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65458a51944f7";a:3:{s:7:"task_id";s:21:"wpvivid-65458a51944f7";s:11:"backup_time";i:1699056209;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-6547a994bc5f5";a:3:{s:7:"task_id";s:21:"wpvivid-6547a994bc5f5";s:11:"backup_time";i:1699195284;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-654869633c256";a:3:{s:7:"task_id";s:21:"wpvivid-654869633c256";s:11:"backup_time";i:1699244387;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-654bf170c24d8";a:3:{s:7:"task_id";s:21:"wpvivid-654bf170c24d8";s:11:"backup_time";i:1699475824;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-654d09f8421d8";a:3:{s:7:"task_id";s:21:"wpvivid-654d09f8421d8";s:11:"backup_time";i:1699547640;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-654d9a77691c0";a:3:{s:7:"task_id";s:21:"wpvivid-654d9a77691c0";s:11:"backup_time";i:1699584631;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-654ec5641d026";a:3:{s:7:"task_id";s:21:"wpvivid-654ec5641d026";s:11:"backup_time";i:1699661156;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-655016004ce79";a:3:{s:7:"task_id";s:21:"wpvivid-655016004ce79";s:11:"backup_time";i:1699747328;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65539429b6bb3";a:3:{s:7:"task_id";s:21:"wpvivid-65539429b6bb3";s:11:"backup_time";i:1699976233;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-6555fff283be5";a:3:{s:7:"task_id";s:21:"wpvivid-6555fff283be5";s:11:"backup_time";i:1700134898;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-6556cdeb793bb";a:3:{s:7:"task_id";s:21:"wpvivid-6556cdeb793bb";s:11:"backup_time";i:1700187627;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-6558da738755c";a:3:{s:7:"task_id";s:21:"wpvivid-6558da738755c";s:11:"backup_time";i:1700321907;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-655bfb1da4ba0";a:3:{s:7:"task_id";s:21:"wpvivid-655bfb1da4ba0";s:11:"backup_time";i:1700526877;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-655d7598123dd";a:3:{s:7:"task_id";s:21:"wpvivid-655d7598123dd";s:11:"backup_time";i:1700623768;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-655e96d1de8c7";a:3:{s:7:"task_id";s:21:"wpvivid-655e96d1de8c7";s:11:"backup_time";i:1700697810;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-655fe8fb7b602";a:3:{s:7:"task_id";s:21:"wpvivid-655fe8fb7b602";s:11:"backup_time";i:1700784379;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-6561d26eca21a";a:3:{s:7:"task_id";s:21:"wpvivid-6561d26eca21a";s:11:"backup_time";i:1700909678;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-6563aa6b85a2c";a:3:{s:7:"task_id";s:21:"wpvivid-6563aa6b85a2c";s:11:"backup_time";i:1701030507;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-6564b9b5d88e5";a:3:{s:7:"task_id";s:21:"wpvivid-6564b9b5d88e5";s:11:"backup_time";i:1701099957;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65654aed8a55b";a:3:{s:7:"task_id";s:21:"wpvivid-65654aed8a55b";s:11:"backup_time";i:1701137133;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-6566827a4136a";a:3:{s:7:"task_id";s:21:"wpvivid-6566827a4136a";s:11:"backup_time";i:1701216890;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-656b390c77762";a:3:{s:7:"task_id";s:21:"wpvivid-656b390c77762";s:11:"backup_time";i:1701525772;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-656c7c5bdb084";a:3:{s:7:"task_id";s:21:"wpvivid-656c7c5bdb084";s:11:"backup_time";i:1701608539;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-656df086121d9";a:3:{s:7:"task_id";s:21:"wpvivid-656df086121d9";s:11:"backup_time";i:1701703814;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-656e81f2ce8e7";a:3:{s:7:"task_id";s:21:"wpvivid-656e81f2ce8e7";s:11:"backup_time";i:1701741042;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-656fb99094607";a:3:{s:7:"task_id";s:21:"wpvivid-656fb99094607";s:11:"backup_time";i:1701820816;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-657349897a649";a:3:{s:7:"task_id";s:21:"wpvivid-657349897a649";s:11:"backup_time";i:1702054281;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65745724d836f";a:3:{s:7:"task_id";s:21:"wpvivid-65745724d836f";s:11:"backup_time";i:1702123300;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-6576c7ede71d2";a:3:{s:7:"task_id";s:21:"wpvivid-6576c7ede71d2";s:11:"backup_time";i:1702283246;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-6577d3f0237f5";a:3:{s:7:"task_id";s:21:"wpvivid-6577d3f0237f5";s:11:"backup_time";i:1702351856;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-6578f40b264fe";a:3:{s:7:"task_id";s:21:"wpvivid-6578f40b264fe";s:11:"backup_time";i:1702425611;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-657b1b263f713";a:3:{s:7:"task_id";s:21:"wpvivid-657b1b263f713";s:11:"backup_time";i:1702566694;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-657cc7b0ef986";a:3:{s:7:"task_id";s:21:"wpvivid-657cc7b0ef986";s:11:"backup_time";i:1702676401;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-657d0dfd578a4";a:3:{s:7:"task_id";s:21:"wpvivid-657d0dfd578a4";s:11:"backup_time";i:1702694397;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-657e3a0283130";a:3:{s:7:"task_id";s:21:"wpvivid-657e3a0283130";s:11:"backup_time";i:1702771202;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-657f8ea773523";a:3:{s:7:"task_id";s:21:"wpvivid-657f8ea773523";s:11:"backup_time";i:1702858407;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-6580e933dc0e1";a:3:{s:7:"task_id";s:21:"wpvivid-6580e933dc0e1";s:11:"backup_time";i:1702947123;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-658270b415cec";a:3:{s:7:"task_id";s:21:"wpvivid-658270b415cec";s:11:"backup_time";i:1703047348;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-6583854a16a54";a:3:{s:7:"task_id";s:21:"wpvivid-6583854a16a54";s:11:"backup_time";i:1703118154;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-6584e378dddc9";a:3:{s:7:"task_id";s:21:"wpvivid-6584e378dddc9";s:11:"backup_time";i:1703207801;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65862a3749469";a:3:{s:7:"task_id";s:21:"wpvivid-65862a3749469";s:11:"backup_time";i:1703291447;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-6587755bd0729";a:3:{s:7:"task_id";s:21:"wpvivid-6587755bd0729";s:11:"backup_time";i:1703376219;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-6588c8530cbdd";a:3:{s:7:"task_id";s:21:"wpvivid-6588c8530cbdd";s:11:"backup_time";i:1703462995;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-658a1c29d6d91";a:3:{s:7:"task_id";s:21:"wpvivid-658a1c29d6d91";s:11:"backup_time";i:1703549993;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-658c03a77f8cf";a:3:{s:7:"task_id";s:21:"wpvivid-658c03a77f8cf";s:11:"backup_time";i:1703674791;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-658ce79b4692b";a:3:{s:7:"task_id";s:21:"wpvivid-658ce79b4692b";s:11:"backup_time";i:1703733147;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-658e0c7d37b31";a:3:{s:7:"task_id";s:21:"wpvivid-658e0c7d37b31";s:11:"backup_time";i:1703808125;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-658ff52fd5340";a:3:{s:7:"task_id";s:21:"wpvivid-658ff52fd5340";s:11:"backup_time";i:1703933231;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-6590b2b709c90";a:3:{s:7:"task_id";s:21:"wpvivid-6590b2b709c90";s:11:"backup_time";i:1703981751;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65937012efa40";a:3:{s:7:"task_id";s:21:"wpvivid-65937012efa40";s:11:"backup_time";i:1704161299;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-6594a4fc1d54f";a:3:{s:7:"task_id";s:21:"wpvivid-6594a4fc1d54f";s:11:"backup_time";i:1704240380;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65973250e64d6";a:3:{s:7:"task_id";s:21:"wpvivid-65973250e64d6";s:11:"backup_time";i:1704407633;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-6597da25bca01";a:3:{s:7:"task_id";s:21:"wpvivid-6597da25bca01";s:11:"backup_time";i:1704450597;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-6599ea660de66";a:3:{s:7:"task_id";s:21:"wpvivid-6599ea660de66";s:11:"backup_time";i:1704585830;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-659b743977366";a:3:{s:7:"task_id";s:21:"wpvivid-659b743977366";s:11:"backup_time";i:1704686649;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-659c902e49694";a:3:{s:7:"task_id";s:21:"wpvivid-659c902e49694";s:11:"backup_time";i:1704759342;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-659f35cf7e01b";a:3:{s:7:"task_id";s:21:"wpvivid-659f35cf7e01b";s:11:"backup_time";i:1704932815;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65a082fd5ddb0";a:3:{s:7:"task_id";s:21:"wpvivid-65a082fd5ddb0";s:11:"backup_time";i:1705018109;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65a223586403f";a:3:{s:7:"task_id";s:21:"wpvivid-65a223586403f";s:11:"backup_time";i:1705124696;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65a35c72cfbf0";a:3:{s:7:"task_id";s:21:"wpvivid-65a35c72cfbf0";s:11:"backup_time";i:1705204850;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65a4775639d28";a:3:{s:7:"task_id";s:21:"wpvivid-65a4775639d28";s:11:"backup_time";i:1705277270;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65a5c8c4b4ae0";a:3:{s:7:"task_id";s:21:"wpvivid-65a5c8c4b4ae0";s:11:"backup_time";i:1705363652;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65aa5b7e3aadc";a:3:{s:7:"task_id";s:21:"wpvivid-65aa5b7e3aadc";s:11:"backup_time";i:1705663358;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65ab3f6ad1ee4";a:3:{s:7:"task_id";s:21:"wpvivid-65ab3f6ad1ee4";s:11:"backup_time";i:1705721706;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65ac5f1e96e77";a:3:{s:7:"task_id";s:21:"wpvivid-65ac5f1e96e77";s:11:"backup_time";i:1705795358;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65adb24c44fc2";a:3:{s:7:"task_id";s:21:"wpvivid-65adb24c44fc2";s:11:"backup_time";i:1705882188;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65af032f039dd";a:3:{s:7:"task_id";s:21:"wpvivid-65af032f039dd";s:11:"backup_time";i:1705968431;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65b18d3bf2ad5";a:3:{s:7:"task_id";s:21:"wpvivid-65b18d3bf2ad5";s:11:"backup_time";i:1706134844;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65b1b07ea7195";a:3:{s:7:"task_id";s:21:"wpvivid-65b1b07ea7195";s:11:"backup_time";i:1706143870;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65b2f69d4f6c9";a:3:{s:7:"task_id";s:21:"wpvivid-65b2f69d4f6c9";s:11:"backup_time";i:1706227357;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65b6903796727";a:3:{s:7:"task_id";s:21:"wpvivid-65b6903796727";s:11:"backup_time";i:1706463287;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65b8963086ac2";a:3:{s:7:"task_id";s:21:"wpvivid-65b8963086ac2";s:11:"backup_time";i:1706595888;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65b9a23a92543";a:3:{s:7:"task_id";s:21:"wpvivid-65b9a23a92543";s:11:"backup_time";i:1706664506;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65bafd276a2cc";a:3:{s:7:"task_id";s:21:"wpvivid-65bafd276a2cc";s:11:"backup_time";i:1706753319;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65bc313434370";a:3:{s:7:"task_id";s:21:"wpvivid-65bc313434370";s:11:"backup_time";i:1706832180;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65bd82a7a3084";a:3:{s:7:"task_id";s:21:"wpvivid-65bd82a7a3084";s:11:"backup_time";i:1706918567;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65bee0103909e";a:3:{s:7:"task_id";s:21:"wpvivid-65bee0103909e";s:11:"backup_time";i:1707008016;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65c0285fe0699";a:3:{s:7:"task_id";s:21:"wpvivid-65c0285fe0699";s:11:"backup_time";i:1707092064;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65c1f2063d40e";a:3:{s:7:"task_id";s:21:"wpvivid-65c1f2063d40e";s:11:"backup_time";i:1707209222;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65c3cf6475e3c";a:3:{s:7:"task_id";s:21:"wpvivid-65c3cf6475e3c";s:11:"backup_time";i:1707331428;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65c48a676ec9a";a:3:{s:7:"task_id";s:21:"wpvivid-65c48a676ec9a";s:11:"backup_time";i:1707379303;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65c63f2471683";a:3:{s:7:"task_id";s:21:"wpvivid-65c63f2471683";s:11:"backup_time";i:1707491108;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65c81d4403ad3";a:3:{s:7:"task_id";s:21:"wpvivid-65c81d4403ad3";s:11:"backup_time";i:1707613508;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65c960fe30a13";a:3:{s:7:"task_id";s:21:"wpvivid-65c960fe30a13";s:11:"backup_time";i:1707696382;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65cab22947222";a:3:{s:7:"task_id";s:21:"wpvivid-65cab22947222";s:11:"backup_time";i:1707782697;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65cc27faccfcf";a:3:{s:7:"task_id";s:21:"wpvivid-65cc27faccfcf";s:11:"backup_time";i:1707878394;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65ce2a4eaa1af";a:3:{s:7:"task_id";s:21:"wpvivid-65ce2a4eaa1af";s:11:"backup_time";i:1708010062;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65ced62cf00e9";a:3:{s:7:"task_id";s:21:"wpvivid-65ced62cf00e9";s:11:"backup_time";i:1708054061;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65cff879a9212";a:3:{s:7:"task_id";s:21:"wpvivid-65cff879a9212";s:11:"backup_time";i:1708128377;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65d2209dc053d";a:3:{s:7:"task_id";s:21:"wpvivid-65d2209dc053d";s:11:"backup_time";i:1708269725;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65d3f12e3a502";a:3:{s:7:"task_id";s:21:"wpvivid-65d3f12e3a502";s:11:"backup_time";i:1708388654;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65d6389952976";a:3:{s:7:"task_id";s:21:"wpvivid-65d6389952976";s:11:"backup_time";i:1708538009;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65d6c8e6a7a76";a:3:{s:7:"task_id";s:21:"wpvivid-65d6c8e6a7a76";s:11:"backup_time";i:1708574950;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65d7e09ac2aea";a:3:{s:7:"task_id";s:21:"wpvivid-65d7e09ac2aea";s:11:"backup_time";i:1708646554;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65dac7277e39f";a:3:{s:7:"task_id";s:21:"wpvivid-65dac7277e39f";s:11:"backup_time";i:1708836647;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65dc10a3967c8";a:3:{s:7:"task_id";s:21:"wpvivid-65dc10a3967c8";s:11:"backup_time";i:1708920995;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65ddf9d930124";a:3:{s:7:"task_id";s:21:"wpvivid-65ddf9d930124";s:11:"backup_time";i:1709046233;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65de999ee26e7";a:3:{s:7:"task_id";s:21:"wpvivid-65de999ee26e7";s:11:"backup_time";i:1709087134;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65dfc90dcfc26";a:3:{s:7:"task_id";s:21:"wpvivid-65dfc90dcfc26";s:11:"backup_time";i:1709164813;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65e11b6d8aa41";a:3:{s:7:"task_id";s:21:"wpvivid-65e11b6d8aa41";s:11:"backup_time";i:1709251437;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65e396b150f74";a:3:{s:7:"task_id";s:21:"wpvivid-65e396b150f74";s:11:"backup_time";i:1709414065;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65e3c131e4b2e";a:3:{s:7:"task_id";s:21:"wpvivid-65e3c131e4b2e";s:11:"backup_time";i:1709424946;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65e5492dd8ea2";a:3:{s:7:"task_id";s:21:"wpvivid-65e5492dd8ea2";s:11:"backup_time";i:1709525294;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65e661d412ec9";a:3:{s:7:"task_id";s:21:"wpvivid-65e661d412ec9";s:11:"backup_time";i:1709597140;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65e7d50a60e21";a:3:{s:7:"task_id";s:21:"wpvivid-65e7d50a60e21";s:11:"backup_time";i:1709692170;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65e90cb78a24c";a:3:{s:7:"task_id";s:21:"wpvivid-65e90cb78a24c";s:11:"backup_time";i:1709771959;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65ea80445656d";a:3:{s:7:"task_id";s:21:"wpvivid-65ea80445656d";s:11:"backup_time";i:1709867076;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65ec6335ab9b4";a:3:{s:7:"task_id";s:21:"wpvivid-65ec6335ab9b4";s:11:"backup_time";i:1709990709;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65ed630dd8eca";a:3:{s:7:"task_id";s:21:"wpvivid-65ed630dd8eca";s:11:"backup_time";i:1710056205;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65ee66d20472f";a:3:{s:7:"task_id";s:21:"wpvivid-65ee66d20472f";s:11:"backup_time";i:1710122706;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65f5a9697c527";a:3:{s:7:"task_id";s:21:"wpvivid-65f5a9697c527";s:11:"backup_time";i:1710598505;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65f67be717d47";a:3:{s:7:"task_id";s:21:"wpvivid-65f67be717d47";s:11:"backup_time";i:1710652391;s:6:"status";s:9:"Succeeded";}s:21:"wpvivid-65f79f13a7800";a:3:{s:7:"task_id";s:21:"wpvivid-65f79f13a7800";s:11:"backup_time";i:1710726931;s:6:"status";s:9:"Succeeded";}}','yes');
INSERT INTO `miam_options` VALUES (475,'wpvivid_last_msg','a:7:{s:2:"id";s:21:"wpvivid-66aed255521f8";s:4:"type";s:4:"Cron";s:7:"options";a:23:{s:12:"backup_files";s:8:"files+db";s:5:"local";s:1:"0";s:6:"remote";s:1:"1";s:7:"ismerge";s:1:"1";s:4:"lock";s:1:"0";s:4:"type";s:4:"Cron";s:6:"action";s:6:"backup";s:10:"save_local";b:0;s:13:"backup_prefix";s:13:"miam.vicq.org";s:11:"file_prefix";s:52:"miam.vicq.org_wpvivid-66aed255521f8_2024-08-04-02-59";s:13:"log_file_name";s:28:"wpvivid-66aed255521f8_backup";s:13:"log_file_path";s:96:"/home/vicqorgvmv/miam/wp-content/wpvividbackups/wpvivid_log/wpvivid-66aed255521f8_backup_log.txt";s:6:"prefix";s:52:"miam.vicq.org_wpvivid-66aed255521f8_2024-08-04-02-59";s:3:"dir";s:47:"/home/vicqorgvmv/miam/wp-content/wpvividbackups";s:10:"backup_dir";s:14:"wpvividbackups";s:14:"exclude-tables";a:6:{i:0;s:16:"miam_wpvivid_log";i:1;s:30:"miam_wpvivid_increment_big_ids";i:2;s:20:"miam_wpvivid_options";i:3;s:24:"miam_wpvivid_record_task";i:4;s:21:"miam_wpvivid_merge_db";i:5;s:22:"miam_wpvivid_merge_ids";}s:14:"include-tables";a:0:{}s:13:"exclude_files";a:9:{i:0;s:73:"#^\\/home\\/vicqorgvmv\\/miam\\/wp\\-content\\/plugins\\/wpvivid\\-backuprestore#";i:1;s:61:"#^\\/home\\/vicqorgvmv\\/miam\\/wp\\-content\\/plugins\\/wp\\-cerber#";i:2;s:53:"#^\\/home\\/vicqorgvmv\\/miam\\/wp\\-content\\/plugins\\/\\.#";i:3;s:71:"#^\\/home\\/vicqorgvmv\\/miam\\/wp\\-content\\/plugins\\/wpvivid\\-backup\\-pro#";i:4;s:67:"#^\\/home\\/vicqorgvmv\\/miam\\/wp\\-content\\/plugins\\/wpvividdashboard#";i:5;s:49:"#^\\/home\\/vicqorgvmv\\/miam\\/wp\\-content\\/upgrade#";i:6;s:57:"#^\\/home\\/vicqorgvmv\\/miam\\/wp\\-content\\/wpvivid_uploads#";i:7;s:49:"#^\\/home\\/vicqorgvmv\\/miam\\/wp\\-content\\/wpvivid#";i:8;s:56:"#^\\/home\\/vicqorgvmv\\/miam\\/wp\\-content\\/wpvividbackups#";}s:13:"include_files";a:3:{i:0;s:38:"#^\\/home\\/vicqorgvmv\\/miam\\/wp\\-admin#";i:1;s:41:"#^\\/home\\/vicqorgvmv\\/miam\\/wp\\-includes#";i:2;s:36:"#^\\/home\\/vicqorgvmv\\/miam\\/lotties#";}s:15:"include_plugins";a:0:{}s:14:"include_themes";a:0:{}s:14:"backup_options";a:1:{s:8:"compress";a:1:{s:13:"compress_type";s:3:"zip";}}s:14:"remote_options";a:1:{s:28:"wpvivid-remote-64d7887038542";a:9:{s:7:"passive";s:1:"1";s:4:"name";s:8:"ovh-miam";s:6:"server";s:12:"ftp.vicq.org";s:8:"username";s:10:"vicqorgvmv";s:4:"path";s:23:"/backup/wordpress/miam/";s:8:"password";s:16:"RnRwb3ZoMTcxNg==";s:4:"type";s:3:"ftp";s:4:"host";s:12:"ftp.vicq.org";s:10:"is_encrypt";i:1;}}}s:6:"status";a:7:{s:15:"task_start_time";i:1722733141;s:13:"task_end_time";i:1722733141;s:10:"start_time";i:1722733141;s:8:"run_time";i:1722733141;s:7:"timeout";i:1722733141;s:3:"str";s:5:"ready";s:12:"resume_count";i:0;}s:7:"setting";a:12:{s:17:"db_connect_method";s:4:"wpdb";s:12:"memory_limit";s:4:"256M";s:18:"max_execution_time";i:300;s:23:"compress_file_use_cache";b:0;s:19:"compress_file_count";i:500;s:13:"max_file_size";i:200;s:17:"max_sql_file_size";i:200;s:17:"exclude_file_size";i:0;s:16:"max_resume_count";i:6;s:10:"zip_method";s:10:"ziparchive";s:8:"is_merge";b:1;s:10:"save_local";b:0;}s:4:"data";a:3:{s:5:"doing";s:6:"backup";s:6:"backup";a:3:{s:5:"doing";s:0:"";s:8:"progress";i:0;s:7:"sub_job";a:0:{}}s:6:"upload";a:5:{s:5:"doing";s:0:"";s:8:"finished";i:0;s:8:"progress";i:0;s:8:"job_data";a:0:{}s:7:"sub_job";a:0:{}}}s:4:"jobs";a:7:{i:0;a:5:{s:11:"backup_type";s:9:"backup_db";s:8:"finished";i:0;s:8:"progress";i:0;s:10:"file_index";i:1;s:16:"mysql_file_index";i:1;}i:1;a:5:{s:11:"backup_type";s:13:"backup_themes";s:8:"finished";i:0;s:8:"progress";i:0;s:10:"file_index";i:1;s:5:"index";i:0;}i:2;a:5:{s:11:"backup_type";s:13:"backup_plugin";s:8:"finished";i:0;s:8:"progress";i:0;s:10:"file_index";i:1;s:5:"index";i:0;}i:3;a:5:{s:11:"backup_type";s:14:"backup_uploads";s:8:"finished";i:0;s:8:"progress";i:0;s:10:"file_index";i:1;s:5:"index";i:0;}i:4;a:5:{s:11:"backup_type";s:14:"backup_content";s:8:"finished";i:0;s:8:"progress";i:0;s:10:"file_index";i:1;s:5:"index";i:0;}i:5;a:5:{s:11:"backup_type";s:11:"backup_core";s:8:"finished";i:0;s:8:"progress";i:0;s:10:"file_index";i:1;s:5:"index";i:0;}i:6;a:6:{s:11:"backup_type";s:12:"backup_merge";s:8:"finished";i:0;s:8:"progress";i:0;s:10:"file_index";i:1;s:10:"child_file";a:0:{}s:5:"index";i:0;}}}','off');
INSERT INTO `miam_options` VALUES (479,'wpvivid_schedule_setting','a:5:{s:6:"enable";s:1:"1";s:4:"type";s:13:"wpvivid_daily";s:5:"event";s:27:"wpvivid_main_schedule_event";s:10:"start_time";i:1691884800;s:6:"backup";a:5:{s:12:"backup_files";s:8:"files+db";s:5:"local";i:0;s:6:"remote";i:1;s:7:"ismerge";i:1;s:4:"lock";s:1:"0";}}','no');
INSERT INTO `miam_options` VALUES (500,'cron_backup_count','312','off');
INSERT INTO `miam_options` VALUES (529,'wpvivid_review_msg','Cheers! The schedule feature of WPvivid Backup plugin seems to be running well. If you found WPvivid Backup plugin helpful, a 5-star rating will motivate us to keep improving the plugin quality.','no');
INSERT INTO `miam_options` VALUES (651,'auto_update_plugins','a:5:{i:0;s:39:"delicious-recipes/delicious-recipes.php";i:1;s:19:"akismet/akismet.php";i:2;s:9:"hello.php";i:3;s:47:"regenerate-thumbnails/regenerate-thumbnails.php";i:4;s:47:"wpvivid-backuprestore/wpvivid-backuprestore.php";}','no');
INSERT INTO `miam_options` VALUES (656,'auto_update_themes','a:4:{i:0;s:12:"cookery-lite";i:1;s:11:"bakers-lite";i:2;s:14:"blossom-recipe";i:3;s:9:"vw-bakery";}','no');
INSERT INTO `miam_options` VALUES (887,'recipe-cooking-method_children','a:0:{}','yes');
INSERT INTO `miam_options` VALUES (1219,'recipe-course_children','a:0:{}','yes');
INSERT INTO `miam_options` VALUES (1644,'wp_attachment_pages_enabled','1','yes');
INSERT INTO `miam_options` VALUES (9880,'_site_transient_timeout_php_check_990bfacb848fa087bcfc06850f5e4447','1722864822','off');
INSERT INTO `miam_options` VALUES (9881,'_site_transient_php_check_990bfacb848fa087bcfc06850f5e4447','a:5:{s:19:"recommended_version";s:3:"7.4";s:15:"minimum_version";s:3:"7.0";s:12:"is_supported";b:1;s:9:"is_secure";b:1;s:13:"is_acceptable";b:1;}','off');
INSERT INTO `miam_options` VALUES (9991,'_site_transient_update_core','O:8:"stdClass":4:{s:7:"updates";a:1:{i:0;O:8:"stdClass":10:{s:8:"response";s:6:"latest";s:8:"download";s:65:"https://downloads.wordpress.org/release/fr_FR/wordpress-6.6.1.zip";s:6:"locale";s:5:"fr_FR";s:8:"packages";O:8:"stdClass":5:{s:4:"full";s:65:"https://downloads.wordpress.org/release/fr_FR/wordpress-6.6.1.zip";s:10:"no_content";s:0:"";s:11:"new_bundled";s:0:"";s:7:"partial";s:0:"";s:8:"rollback";s:0:"";}s:7:"current";s:5:"6.6.1";s:7:"version";s:5:"6.6.1";s:11:"php_version";s:5:"7.0.0";s:13:"mysql_version";s:3:"5.0";s:11:"new_bundled";s:3:"6.4";s:15:"partial_version";s:0:"";}}s:12:"last_checked";i:1722733138;s:15:"version_checked";s:5:"6.6.1";s:12:"translations";a:0:{}}','off');
INSERT INTO `miam_options` VALUES (9993,'_site_transient_update_plugins','O:8:"stdClass":5:{s:12:"last_checked";i:1722733140;s:8:"response";a:0:{}s:12:"translations";a:0:{}s:9:"no_update";a:5:{s:19:"akismet/akismet.php";O:8:"stdClass":10:{s:2:"id";s:21:"w.org/plugins/akismet";s:4:"slug";s:7:"akismet";s:6:"plugin";s:19:"akismet/akismet.php";s:11:"new_version";s:5:"5.3.3";s:3:"url";s:38:"https://wordpress.org/plugins/akismet/";s:7:"package";s:56:"https://downloads.wordpress.org/plugin/akismet.5.3.3.zip";s:5:"icons";a:2:{s:2:"2x";s:60:"https://ps.w.org/akismet/assets/icon-256x256.png?rev=2818463";s:2:"1x";s:60:"https://ps.w.org/akismet/assets/icon-128x128.png?rev=2818463";}s:7:"banners";a:2:{s:2:"2x";s:63:"https://ps.w.org/akismet/assets/banner-1544x500.png?rev=2900731";s:2:"1x";s:62:"https://ps.w.org/akismet/assets/banner-772x250.png?rev=2900731";}s:11:"banners_rtl";a:0:{}s:8:"requires";s:3:"5.8";}s:9:"hello.php";O:8:"stdClass":10:{s:2:"id";s:25:"w.org/plugins/hello-dolly";s:4:"slug";s:11:"hello-dolly";s:6:"plugin";s:9:"hello.php";s:11:"new_version";s:5:"1.7.2";s:3:"url";s:42:"https://wordpress.org/plugins/hello-dolly/";s:7:"package";s:60:"https://downloads.wordpress.org/plugin/hello-dolly.1.7.3.zip";s:5:"icons";a:2:{s:2:"2x";s:64:"https://ps.w.org/hello-dolly/assets/icon-256x256.jpg?rev=2052855";s:2:"1x";s:64:"https://ps.w.org/hello-dolly/assets/icon-128x128.jpg?rev=2052855";}s:7:"banners";a:2:{s:2:"2x";s:67:"https://ps.w.org/hello-dolly/assets/banner-1544x500.jpg?rev=2645582";s:2:"1x";s:66:"https://ps.w.org/hello-dolly/assets/banner-772x250.jpg?rev=2052855";}s:11:"banners_rtl";a:0:{}s:8:"requires";s:3:"4.6";}s:47:"regenerate-thumbnails/regenerate-thumbnails.php";O:8:"stdClass":10:{s:2:"id";s:35:"w.org/plugins/regenerate-thumbnails";s:4:"slug";s:21:"regenerate-thumbnails";s:6:"plugin";s:47:"regenerate-thumbnails/regenerate-thumbnails.php";s:11:"new_version";s:5:"3.1.6";s:3:"url";s:52:"https://wordpress.org/plugins/regenerate-thumbnails/";s:7:"package";s:70:"https://downloads.wordpress.org/plugin/regenerate-thumbnails.3.1.6.zip";s:5:"icons";a:1:{s:2:"1x";s:74:"https://ps.w.org/regenerate-thumbnails/assets/icon-128x128.png?rev=1753390";}s:7:"banners";a:2:{s:2:"2x";s:77:"https://ps.w.org/regenerate-thumbnails/assets/banner-1544x500.jpg?rev=1753390";s:2:"1x";s:76:"https://ps.w.org/regenerate-thumbnails/assets/banner-772x250.jpg?rev=1753390";}s:11:"banners_rtl";a:0:{}s:8:"requires";s:3:"4.7";}s:39:"delicious-recipes/delicious-recipes.php";O:8:"stdClass":10:{s:2:"id";s:31:"w.org/plugins/delicious-recipes";s:4:"slug";s:17:"delicious-recipes";s:6:"plugin";s:39:"delicious-recipes/delicious-recipes.php";s:11:"new_version";s:5:"1.6.7";s:3:"url";s:48:"https://wordpress.org/plugins/delicious-recipes/";s:7:"package";s:66:"https://downloads.wordpress.org/plugin/delicious-recipes.1.6.7.zip";s:5:"icons";a:2:{s:2:"2x";s:70:"https://ps.w.org/delicious-recipes/assets/icon-256x256.jpg?rev=2394153";s:2:"1x";s:70:"https://ps.w.org/delicious-recipes/assets/icon-128x128.jpg?rev=2394153";}s:7:"banners";a:2:{s:2:"2x";s:73:"https://ps.w.org/delicious-recipes/assets/banner-1544x500.jpg?rev=3107777";s:2:"1x";s:72:"https://ps.w.org/delicious-recipes/assets/banner-772x250.jpg?rev=3107777";}s:11:"banners_rtl";a:0:{}s:8:"requires";s:3:"5.1";}s:47:"wpvivid-backuprestore/wpvivid-backuprestore.php";O:8:"stdClass":10:{s:2:"id";s:35:"w.org/plugins/wpvivid-backuprestore";s:4:"slug";s:21:"wpvivid-backuprestore";s:6:"plugin";s:47:"wpvivid-backuprestore/wpvivid-backuprestore.php";s:11:"new_version";s:7:"0.9.103";s:3:"url";s:52:"https://wordpress.org/plugins/wpvivid-backuprestore/";s:7:"package";s:72:"https://downloads.wordpress.org/plugin/wpvivid-backuprestore.0.9.103.zip";s:5:"icons";a:2:{s:2:"2x";s:74:"https://ps.w.org/wpvivid-backuprestore/assets/icon-256x256.png?rev=2899202";s:2:"1x";s:74:"https://ps.w.org/wpvivid-backuprestore/assets/icon-128x128.png?rev=2899202";}s:7:"banners";a:2:{s:2:"2x";s:77:"https://ps.w.org/wpvivid-backuprestore/assets/banner-1544x500.png?rev=2899202";s:2:"1x";s:76:"https://ps.w.org/wpvivid-backuprestore/assets/banner-772x250.png?rev=2899202";}s:11:"banners_rtl";a:0:{}s:8:"requires";s:3:"4.5";}}s:7:"checked";a:5:{s:19:"akismet/akismet.php";s:5:"5.3.3";s:9:"hello.php";s:5:"1.7.2";s:47:"regenerate-thumbnails/regenerate-thumbnails.php";s:5:"3.1.6";s:39:"delicious-recipes/delicious-recipes.php";s:5:"1.6.7";s:47:"wpvivid-backuprestore/wpvivid-backuprestore.php";s:7:"0.9.103";}}','off');
INSERT INTO `miam_options` VALUES (10249,'_site_transient_timeout_available_translations','1722714909','off');
INSERT INTO `miam_options` VALUES (10250,'_site_transient_available_translations','a:131:{s:2:"af";a:8:{s:8:"language";s:2:"af";s:7:"version";s:8:"5.8-beta";s:7:"updated";s:19:"2021-05-13 15:59:22";s:12:"english_name";s:9:"Afrikaans";s:11:"native_name";s:9:"Afrikaans";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/5.8-beta/af.zip";s:3:"iso";a:2:{i:1;s:2:"af";i:2;s:3:"afr";}s:7:"strings";a:1:{s:8:"continue";s:10:"Gaan voort";}}s:2:"am";a:8:{s:8:"language";s:2:"am";s:7:"version";s:5:"6.0.8";s:7:"updated";s:19:"2022-09-29 20:43:49";s:12:"english_name";s:7:"Amharic";s:11:"native_name";s:12:"አማርኛ";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/6.0.8/am.zip";s:3:"iso";a:2:{i:1;s:2:"am";i:2;s:3:"amh";}s:7:"strings";a:1:{s:8:"continue";s:9:"ቀጥል";}}s:3:"arg";a:8:{s:8:"language";s:3:"arg";s:7:"version";s:8:"6.2-beta";s:7:"updated";s:19:"2022-09-22 16:46:56";s:12:"english_name";s:9:"Aragonese";s:11:"native_name";s:9:"Aragonés";s:7:"package";s:65:"https://downloads.wordpress.org/translation/core/6.2-beta/arg.zip";s:3:"iso";a:3:{i:1;s:2:"an";i:2;s:3:"arg";i:3;s:3:"arg";}s:7:"strings";a:1:{s:8:"continue";s:8:"Continar";}}s:2:"ar";a:8:{s:8:"language";s:2:"ar";s:7:"version";s:5:"6.4.5";s:7:"updated";s:19:"2024-02-13 12:49:38";s:12:"english_name";s:6:"Arabic";s:11:"native_name";s:14:"العربية";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/6.4.5/ar.zip";s:3:"iso";a:2:{i:1;s:2:"ar";i:2;s:3:"ara";}s:7:"strings";a:1:{s:8:"continue";s:12:"متابعة";}}s:3:"ary";a:8:{s:8:"language";s:3:"ary";s:7:"version";s:6:"4.8.24";s:7:"updated";s:19:"2017-01-26 15:42:35";s:12:"english_name";s:15:"Moroccan Arabic";s:11:"native_name";s:31:"العربية المغربية";s:7:"package";s:63:"https://downloads.wordpress.org/translation/core/4.8.24/ary.zip";s:3:"iso";a:2:{i:1;s:2:"ar";i:3;s:3:"ary";}s:7:"strings";a:1:{s:8:"continue";s:16:"المتابعة";}}s:2:"as";a:8:{s:8:"language";s:2:"as";s:7:"version";s:5:"6.6.1";s:7:"updated";s:19:"2024-07-22 13:29:21";s:12:"english_name";s:8:"Assamese";s:11:"native_name";s:21:"অসমীয়া";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/6.6.1/as.zip";s:3:"iso";a:3:{i:1;s:2:"as";i:2;s:3:"asm";i:3;s:3:"asm";}s:7:"strings";a:1:{s:8:"continue";s:8:"Continue";}}s:3:"azb";a:8:{s:8:"language";s:3:"azb";s:7:"version";s:5:"6.4.5";s:7:"updated";s:19:"2024-01-19 08:58:31";s:12:"english_name";s:17:"South Azerbaijani";s:11:"native_name";s:29:"گؤنئی آذربایجان";s:7:"package";s:62:"https://downloads.wordpress.org/translation/core/6.4.5/azb.zip";s:3:"iso";a:2:{i:1;s:2:"az";i:3;s:3:"azb";}s:7:"strings";a:1:{s:8:"continue";s:8:"Continue";}}s:2:"az";a:8:{s:8:"language";s:2:"az";s:7:"version";s:5:"4.7.2";s:7:"updated";s:19:"2016-11-06 00:09:27";s:12:"english_name";s:11:"Azerbaijani";s:11:"native_name";s:16:"Azərbaycan dili";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/4.7.2/az.zip";s:3:"iso";a:2:{i:1;s:2:"az";i:2;s:3:"aze";}s:7:"strings";a:1:{s:8:"continue";s:5:"Davam";}}s:3:"bel";a:8:{s:8:"language";s:3:"bel";s:7:"version";s:6:"4.9.25";s:7:"updated";s:19:"2019-10-29 07:54:22";s:12:"english_name";s:10:"Belarusian";s:11:"native_name";s:29:"Беларуская мова";s:7:"package";s:63:"https://downloads.wordpress.org/translation/core/4.9.25/bel.zip";s:3:"iso";a:2:{i:1;s:2:"be";i:2;s:3:"bel";}s:7:"strings";a:1:{s:8:"continue";s:20:"Працягнуць";}}s:5:"bg_BG";a:8:{s:8:"language";s:5:"bg_BG";s:7:"version";s:5:"6.6.1";s:7:"updated";s:19:"2024-07-16 06:53:48";s:12:"english_name";s:9:"Bulgarian";s:11:"native_name";s:18:"Български";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.6.1/bg_BG.zip";s:3:"iso";a:2:{i:1;s:2:"bg";i:2;s:3:"bul";}s:7:"strings";a:1:{s:8:"continue";s:12:"Напред";}}s:5:"bn_BD";a:8:{s:8:"language";s:5:"bn_BD";s:7:"version";s:5:"6.5.5";s:7:"updated";s:19:"2024-06-20 17:11:07";s:12:"english_name";s:20:"Bengali (Bangladesh)";s:11:"native_name";s:15:"বাংলা";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.5.5/bn_BD.zip";s:3:"iso";a:1:{i:1;s:2:"bn";}s:7:"strings";a:1:{s:8:"continue";s:28:"চালিয়ে যান";}}s:2:"bo";a:8:{s:8:"language";s:2:"bo";s:7:"version";s:8:"5.8-beta";s:7:"updated";s:19:"2020-10-30 03:24:38";s:12:"english_name";s:7:"Tibetan";s:11:"native_name";s:21:"བོད་ཡིག";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/5.8-beta/bo.zip";s:3:"iso";a:2:{i:1;s:2:"bo";i:2;s:3:"tib";}s:7:"strings";a:1:{s:8:"continue";s:33:"མུ་མཐུད་དུ།";}}s:5:"bs_BA";a:8:{s:8:"language";s:5:"bs_BA";s:7:"version";s:5:"6.2.6";s:7:"updated";s:19:"2023-02-22 20:45:53";s:12:"english_name";s:7:"Bosnian";s:11:"native_name";s:8:"Bosanski";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.2.6/bs_BA.zip";s:3:"iso";a:2:{i:1;s:2:"bs";i:2;s:3:"bos";}s:7:"strings";a:1:{s:8:"continue";s:7:"Nastavi";}}s:2:"ca";a:8:{s:8:"language";s:2:"ca";s:7:"version";s:5:"6.6.1";s:7:"updated";s:19:"2024-07-18 21:27:42";s:12:"english_name";s:7:"Catalan";s:11:"native_name";s:7:"Català";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/6.6.1/ca.zip";s:3:"iso";a:2:{i:1;s:2:"ca";i:2;s:3:"cat";}s:7:"strings";a:1:{s:8:"continue";s:8:"Continua";}}s:3:"ceb";a:8:{s:8:"language";s:3:"ceb";s:7:"version";s:5:"4.7.2";s:7:"updated";s:19:"2016-03-02 17:25:51";s:12:"english_name";s:7:"Cebuano";s:11:"native_name";s:7:"Cebuano";s:7:"package";s:62:"https://downloads.wordpress.org/translation/core/4.7.2/ceb.zip";s:3:"iso";a:2:{i:2;s:3:"ceb";i:3;s:3:"ceb";}s:7:"strings";a:1:{s:8:"continue";s:7:"Padayun";}}s:5:"cs_CZ";a:8:{s:8:"language";s:5:"cs_CZ";s:7:"version";s:5:"6.6.1";s:7:"updated";s:19:"2024-07-23 09:49:04";s:12:"english_name";s:5:"Czech";s:11:"native_name";s:9:"Čeština";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.6.1/cs_CZ.zip";s:3:"iso";a:2:{i:1;s:2:"cs";i:2;s:3:"ces";}s:7:"strings";a:1:{s:8:"continue";s:11:"Pokračovat";}}s:2:"cy";a:8:{s:8:"language";s:2:"cy";s:7:"version";s:5:"6.6.1";s:7:"updated";s:19:"2024-07-10 16:05:42";s:12:"english_name";s:5:"Welsh";s:11:"native_name";s:7:"Cymraeg";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/6.6.1/cy.zip";s:3:"iso";a:2:{i:1;s:2:"cy";i:2;s:3:"cym";}s:7:"strings";a:1:{s:8:"continue";s:6:"Parhau";}}s:5:"da_DK";a:8:{s:8:"language";s:5:"da_DK";s:7:"version";s:5:"6.6.1";s:7:"updated";s:19:"2024-07-31 08:14:51";s:12:"english_name";s:6:"Danish";s:11:"native_name";s:5:"Dansk";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.6.1/da_DK.zip";s:3:"iso";a:2:{i:1;s:2:"da";i:2;s:3:"dan";}s:7:"strings";a:1:{s:8:"continue";s:8:"Fortsæt";}}s:5:"de_AT";a:8:{s:8:"language";s:5:"de_AT";s:7:"version";s:5:"6.6.1";s:7:"updated";s:19:"2024-07-10 06:17:47";s:12:"english_name";s:16:"German (Austria)";s:11:"native_name";s:21:"Deutsch (Österreich)";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.6.1/de_AT.zip";s:3:"iso";a:1:{i:1;s:2:"de";}s:7:"strings";a:1:{s:8:"continue";s:6:"Weiter";}}s:5:"de_DE";a:8:{s:8:"language";s:5:"de_DE";s:7:"version";s:5:"6.6.1";s:7:"updated";s:19:"2024-07-30 23:47:00";s:12:"english_name";s:6:"German";s:11:"native_name";s:7:"Deutsch";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.6.1/de_DE.zip";s:3:"iso";a:1:{i:1;s:2:"de";}s:7:"strings";a:1:{s:8:"continue";s:6:"Weiter";}}s:14:"de_CH_informal";a:8:{s:8:"language";s:14:"de_CH_informal";s:7:"version";s:5:"6.6.1";s:7:"updated";s:19:"2024-07-29 10:55:35";s:12:"english_name";s:30:"German (Switzerland, Informal)";s:11:"native_name";s:21:"Deutsch (Schweiz, Du)";s:7:"package";s:73:"https://downloads.wordpress.org/translation/core/6.6.1/de_CH_informal.zip";s:3:"iso";a:1:{i:1;s:2:"de";}s:7:"strings";a:1:{s:8:"continue";s:6:"Weiter";}}s:5:"de_CH";a:8:{s:8:"language";s:5:"de_CH";s:7:"version";s:5:"6.6.1";s:7:"updated";s:19:"2024-07-29 10:55:14";s:12:"english_name";s:20:"German (Switzerland)";s:11:"native_name";s:17:"Deutsch (Schweiz)";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.6.1/de_CH.zip";s:3:"iso";a:1:{i:1;s:2:"de";}s:7:"strings";a:1:{s:8:"continue";s:6:"Weiter";}}s:12:"de_DE_formal";a:8:{s:8:"language";s:12:"de_DE_formal";s:7:"version";s:5:"6.6.1";s:7:"updated";s:19:"2024-07-30 23:45:55";s:12:"english_name";s:15:"German (Formal)";s:11:"native_name";s:13:"Deutsch (Sie)";s:7:"package";s:71:"https://downloads.wordpress.org/translation/core/6.6.1/de_DE_formal.zip";s:3:"iso";a:1:{i:1;s:2:"de";}s:7:"strings";a:1:{s:8:"continue";s:6:"Weiter";}}s:3:"dsb";a:8:{s:8:"language";s:3:"dsb";s:7:"version";s:5:"6.2.6";s:7:"updated";s:19:"2022-07-16 12:13:09";s:12:"english_name";s:13:"Lower Sorbian";s:11:"native_name";s:16:"Dolnoserbšćina";s:7:"package";s:62:"https://downloads.wordpress.org/translation/core/6.2.6/dsb.zip";s:3:"iso";a:2:{i:2;s:3:"dsb";i:3;s:3:"dsb";}s:7:"strings";a:1:{s:8:"continue";s:5:"Dalej";}}s:3:"dzo";a:8:{s:8:"language";s:3:"dzo";s:7:"version";s:5:"4.7.2";s:7:"updated";s:19:"2016-06-29 08:59:03";s:12:"english_name";s:8:"Dzongkha";s:11:"native_name";s:18:"རྫོང་ཁ";s:7:"package";s:62:"https://downloads.wordpress.org/translation/core/4.7.2/dzo.zip";s:3:"iso";a:2:{i:1;s:2:"dz";i:2;s:3:"dzo";}s:7:"strings";a:1:{s:8:"continue";s:8:"Continue";}}s:2:"el";a:8:{s:8:"language";s:2:"el";s:7:"version";s:5:"6.6.1";s:7:"updated";s:19:"2024-08-02 13:40:02";s:12:"english_name";s:5:"Greek";s:11:"native_name";s:16:"Ελληνικά";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/6.6.1/el.zip";s:3:"iso";a:2:{i:1;s:2:"el";i:2;s:3:"ell";}s:7:"strings";a:1:{s:8:"continue";s:16:"Συνέχεια";}}s:5:"en_GB";a:8:{s:8:"language";s:5:"en_GB";s:7:"version";s:5:"6.6.1";s:7:"updated";s:19:"2024-07-09 16:06:37";s:12:"english_name";s:12:"English (UK)";s:11:"native_name";s:12:"English (UK)";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.6.1/en_GB.zip";s:3:"iso";a:3:{i:1;s:2:"en";i:2;s:3:"eng";i:3;s:3:"eng";}s:7:"strings";a:1:{s:8:"continue";s:8:"Continue";}}s:5:"en_CA";a:8:{s:8:"language";s:5:"en_CA";s:7:"version";s:5:"6.6.1";s:7:"updated";s:19:"2024-07-13 10:48:39";s:12:"english_name";s:16:"English (Canada)";s:11:"native_name";s:16:"English (Canada)";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.6.1/en_CA.zip";s:3:"iso";a:3:{i:1;s:2:"en";i:2;s:3:"eng";i:3;s:3:"eng";}s:7:"strings";a:1:{s:8:"continue";s:8:"Continue";}}s:5:"en_ZA";a:8:{s:8:"language";s:5:"en_ZA";s:7:"version";s:5:"6.6.1";s:7:"updated";s:19:"2024-06-30 07:39:36";s:12:"english_name";s:22:"English (South Africa)";s:11:"native_name";s:22:"English (South Africa)";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.6.1/en_ZA.zip";s:3:"iso";a:3:{i:1;s:2:"en";i:2;s:3:"eng";i:3;s:3:"eng";}s:7:"strings";a:1:{s:8:"continue";s:8:"Continue";}}s:5:"en_AU";a:8:{s:8:"language";s:5:"en_AU";s:7:"version";s:5:"6.6.1";s:7:"updated";s:19:"2024-07-11 10:54:13";s:12:"english_name";s:19:"English (Australia)";s:11:"native_name";s:19:"English (Australia)";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.6.1/en_AU.zip";s:3:"iso";a:3:{i:1;s:2:"en";i:2;s:3:"eng";i:3;s:3:"eng";}s:7:"strings";a:1:{s:8:"continue";s:8:"Continue";}}s:5:"en_NZ";a:8:{s:8:"language";s:5:"en_NZ";s:7:"version";s:5:"6.6.1";s:7:"updated";s:19:"2024-07-11 10:55:12";s:12:"english_name";s:21:"English (New Zealand)";s:11:"native_name";s:21:"English (New Zealand)";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.6.1/en_NZ.zip";s:3:"iso";a:3:{i:1;s:2:"en";i:2;s:3:"eng";i:3;s:3:"eng";}s:7:"strings";a:1:{s:8:"continue";s:8:"Continue";}}s:2:"eo";a:8:{s:8:"language";s:2:"eo";s:7:"version";s:5:"6.6.1";s:7:"updated";s:19:"2024-07-31 15:26:39";s:12:"english_name";s:9:"Esperanto";s:11:"native_name";s:9:"Esperanto";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/6.6.1/eo.zip";s:3:"iso";a:2:{i:1;s:2:"eo";i:2;s:3:"epo";}s:7:"strings";a:1:{s:8:"continue";s:8:"Daŭrigi";}}s:5:"es_CL";a:8:{s:8:"language";s:5:"es_CL";s:7:"version";s:5:"6.6.1";s:7:"updated";s:19:"2024-07-10 00:53:14";s:12:"english_name";s:15:"Spanish (Chile)";s:11:"native_name";s:17:"Español de Chile";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.6.1/es_CL.zip";s:3:"iso";a:3:{i:1;s:2:"es";i:2;s:3:"spa";i:3;s:3:"spa";}s:7:"strings";a:1:{s:8:"continue";s:9:"Continuar";}}s:5:"es_ES";a:8:{s:8:"language";s:5:"es_ES";s:7:"version";s:5:"6.6.1";s:7:"updated";s:19:"2024-07-18 18:46:57";s:12:"english_name";s:15:"Spanish (Spain)";s:11:"native_name";s:8:"Español";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.6.1/es_ES.zip";s:3:"iso";a:3:{i:1;s:2:"es";i:2;s:3:"spa";i:3;s:3:"spa";}s:7:"strings";a:1:{s:8:"continue";s:9:"Continuar";}}s:5:"es_MX";a:8:{s:8:"language";s:5:"es_MX";s:7:"version";s:5:"6.6.1";s:7:"updated";s:19:"2024-07-10 13:53:16";s:12:"english_name";s:16:"Spanish (Mexico)";s:11:"native_name";s:19:"Español de México";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.6.1/es_MX.zip";s:3:"iso";a:3:{i:1;s:2:"es";i:2;s:3:"spa";i:3;s:3:"spa";}s:7:"strings";a:1:{s:8:"continue";s:9:"Continuar";}}s:5:"es_VE";a:8:{s:8:"language";s:5:"es_VE";s:7:"version";s:5:"6.4.5";s:7:"updated";s:19:"2023-10-16 16:00:04";s:12:"english_name";s:19:"Spanish (Venezuela)";s:11:"native_name";s:21:"Español de Venezuela";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.4.5/es_VE.zip";s:3:"iso";a:3:{i:1;s:2:"es";i:2;s:3:"spa";i:3;s:3:"spa";}s:7:"strings";a:1:{s:8:"continue";s:9:"Continuar";}}s:5:"es_CR";a:8:{s:8:"language";s:5:"es_CR";s:7:"version";s:5:"6.4.5";s:7:"updated";s:19:"2023-11-08 20:42:04";s:12:"english_name";s:20:"Spanish (Costa Rica)";s:11:"native_name";s:22:"Español de Costa Rica";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.4.5/es_CR.zip";s:3:"iso";a:3:{i:1;s:2:"es";i:2;s:3:"spa";i:3;s:3:"spa";}s:7:"strings";a:1:{s:8:"continue";s:9:"Continuar";}}s:5:"es_EC";a:8:{s:8:"language";s:5:"es_EC";s:7:"version";s:5:"6.2.6";s:7:"updated";s:19:"2023-04-21 13:32:10";s:12:"english_name";s:17:"Spanish (Ecuador)";s:11:"native_name";s:19:"Español de Ecuador";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.2.6/es_EC.zip";s:3:"iso";a:3:{i:1;s:2:"es";i:2;s:3:"spa";i:3;s:3:"spa";}s:7:"strings";a:1:{s:8:"continue";s:9:"Continuar";}}s:5:"es_PE";a:8:{s:8:"language";s:5:"es_PE";s:7:"version";s:5:"5.8.9";s:7:"updated";s:19:"2021-10-04 20:53:18";s:12:"english_name";s:14:"Spanish (Peru)";s:11:"native_name";s:17:"Español de Perú";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/5.8.9/es_PE.zip";s:3:"iso";a:3:{i:1;s:2:"es";i:2;s:3:"spa";i:3;s:3:"spa";}s:7:"strings";a:1:{s:8:"continue";s:9:"Continuar";}}s:5:"es_DO";a:8:{s:8:"language";s:5:"es_DO";s:7:"version";s:5:"5.8.9";s:7:"updated";s:19:"2021-10-08 14:32:50";s:12:"english_name";s:28:"Spanish (Dominican Republic)";s:11:"native_name";s:33:"Español de República Dominicana";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/5.8.9/es_DO.zip";s:3:"iso";a:3:{i:1;s:2:"es";i:2;s:3:"spa";i:3;s:3:"spa";}s:7:"strings";a:1:{s:8:"continue";s:9:"Continuar";}}s:5:"es_UY";a:8:{s:8:"language";s:5:"es_UY";s:7:"version";s:8:"5.8-beta";s:7:"updated";s:19:"2021-03-31 18:33:26";s:12:"english_name";s:17:"Spanish (Uruguay)";s:11:"native_name";s:19:"Español de Uruguay";s:7:"package";s:67:"https://downloads.wordpress.org/translation/core/5.8-beta/es_UY.zip";s:3:"iso";a:3:{i:1;s:2:"es";i:2;s:3:"spa";i:3;s:3:"spa";}s:7:"strings";a:1:{s:8:"continue";s:9:"Continuar";}}s:5:"es_PR";a:8:{s:8:"language";s:5:"es_PR";s:7:"version";s:6:"5.4.15";s:7:"updated";s:19:"2020-04-29 15:36:59";s:12:"english_name";s:21:"Spanish (Puerto Rico)";s:11:"native_name";s:23:"Español de Puerto Rico";s:7:"package";s:65:"https://downloads.wordpress.org/translation/core/5.4.15/es_PR.zip";s:3:"iso";a:3:{i:1;s:2:"es";i:2;s:3:"spa";i:3;s:3:"spa";}s:7:"strings";a:1:{s:8:"continue";s:9:"Continuar";}}s:5:"es_CO";a:8:{s:8:"language";s:5:"es_CO";s:7:"version";s:5:"6.6.1";s:7:"updated";s:19:"2024-07-09 22:15:14";s:12:"english_name";s:18:"Spanish (Colombia)";s:11:"native_name";s:20:"Español de Colombia";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.6.1/es_CO.zip";s:3:"iso";a:3:{i:1;s:2:"es";i:2;s:3:"spa";i:3;s:3:"spa";}s:7:"strings";a:1:{s:8:"continue";s:9:"Continuar";}}s:5:"es_GT";a:8:{s:8:"language";s:5:"es_GT";s:7:"version";s:6:"5.2.20";s:7:"updated";s:19:"2019-03-02 06:35:01";s:12:"english_name";s:19:"Spanish (Guatemala)";s:11:"native_name";s:21:"Español de Guatemala";s:7:"package";s:65:"https://downloads.wordpress.org/translation/core/5.2.20/es_GT.zip";s:3:"iso";a:3:{i:1;s:2:"es";i:2;s:3:"spa";i:3;s:3:"spa";}s:7:"strings";a:1:{s:8:"continue";s:9:"Continuar";}}s:5:"es_AR";a:8:{s:8:"language";s:5:"es_AR";s:7:"version";s:5:"6.6.1";s:7:"updated";s:19:"2024-05-27 01:40:49";s:12:"english_name";s:19:"Spanish (Argentina)";s:11:"native_name";s:21:"Español de Argentina";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.6.1/es_AR.zip";s:3:"iso";a:3:{i:1;s:2:"es";i:2;s:3:"spa";i:3;s:3:"spa";}s:7:"strings";a:1:{s:8:"continue";s:9:"Continuar";}}s:2:"et";a:8:{s:8:"language";s:2:"et";s:7:"version";s:5:"6.5.5";s:7:"updated";s:19:"2024-06-06 09:50:37";s:12:"english_name";s:8:"Estonian";s:11:"native_name";s:5:"Eesti";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/6.5.5/et.zip";s:3:"iso";a:2:{i:1;s:2:"et";i:2;s:3:"est";}s:7:"strings";a:1:{s:8:"continue";s:6:"Jätka";}}s:2:"eu";a:8:{s:8:"language";s:2:"eu";s:7:"version";s:5:"6.4.5";s:7:"updated";s:19:"2024-06-02 15:48:46";s:12:"english_name";s:6:"Basque";s:11:"native_name";s:7:"Euskara";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/6.4.5/eu.zip";s:3:"iso";a:2:{i:1;s:2:"eu";i:2;s:3:"eus";}s:7:"strings";a:1:{s:8:"continue";s:8:"Jarraitu";}}s:5:"fa_AF";a:8:{s:8:"language";s:5:"fa_AF";s:7:"version";s:5:"6.6.1";s:7:"updated";s:19:"2024-06-20 17:15:28";s:12:"english_name";s:21:"Persian (Afghanistan)";s:11:"native_name";s:31:"(فارسی (افغانستان";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.6.1/fa_AF.zip";s:3:"iso";a:2:{i:1;s:2:"fa";i:2;s:3:"fas";}s:7:"strings";a:1:{s:8:"continue";s:10:"ادامه";}}s:5:"fa_IR";a:8:{s:8:"language";s:5:"fa_IR";s:7:"version";s:5:"6.6.1";s:7:"updated";s:19:"2024-07-21 21:22:40";s:12:"english_name";s:7:"Persian";s:11:"native_name";s:10:"فارسی";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.6.1/fa_IR.zip";s:3:"iso";a:2:{i:1;s:2:"fa";i:2;s:3:"fas";}s:7:"strings";a:1:{s:8:"continue";s:10:"ادامه";}}s:2:"fi";a:8:{s:8:"language";s:2:"fi";s:7:"version";s:5:"6.6.1";s:7:"updated";s:19:"2024-07-09 18:03:47";s:12:"english_name";s:7:"Finnish";s:11:"native_name";s:5:"Suomi";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/6.6.1/fi.zip";s:3:"iso";a:2:{i:1;s:2:"fi";i:2;s:3:"fin";}s:7:"strings";a:1:{s:8:"continue";s:5:"Jatka";}}s:5:"fr_CA";a:8:{s:8:"language";s:5:"fr_CA";s:7:"version";s:5:"6.6.1";s:7:"updated";s:19:"2024-05-06 13:13:32";s:12:"english_name";s:15:"French (Canada)";s:11:"native_name";s:19:"Français du Canada";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.6.1/fr_CA.zip";s:3:"iso";a:2:{i:1;s:2:"fr";i:2;s:3:"fra";}s:7:"strings";a:1:{s:8:"continue";s:9:"Continuer";}}s:5:"fr_FR";a:8:{s:8:"language";s:5:"fr_FR";s:7:"version";s:5:"6.6.1";s:7:"updated";s:19:"2024-07-31 15:19:15";s:12:"english_name";s:15:"French (France)";s:11:"native_name";s:9:"Français";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.6.1/fr_FR.zip";s:3:"iso";a:1:{i:1;s:2:"fr";}s:7:"strings";a:1:{s:8:"continue";s:9:"Continuer";}}s:5:"fr_BE";a:8:{s:8:"language";s:5:"fr_BE";s:7:"version";s:5:"6.5.5";s:7:"updated";s:19:"2024-02-01 23:56:53";s:12:"english_name";s:16:"French (Belgium)";s:11:"native_name";s:21:"Français de Belgique";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.5.5/fr_BE.zip";s:3:"iso";a:2:{i:1;s:2:"fr";i:2;s:3:"fra";}s:7:"strings";a:1:{s:8:"continue";s:9:"Continuer";}}s:3:"fur";a:8:{s:8:"language";s:3:"fur";s:7:"version";s:6:"4.8.24";s:7:"updated";s:19:"2023-04-30 13:56:46";s:12:"english_name";s:8:"Friulian";s:11:"native_name";s:8:"Friulian";s:7:"package";s:63:"https://downloads.wordpress.org/translation/core/4.8.24/fur.zip";s:3:"iso";a:2:{i:2;s:3:"fur";i:3;s:3:"fur";}s:7:"strings";a:1:{s:8:"continue";s:8:"Continue";}}s:2:"fy";a:8:{s:8:"language";s:2:"fy";s:7:"version";s:5:"6.2.6";s:7:"updated";s:19:"2022-12-25 12:53:23";s:12:"english_name";s:7:"Frisian";s:11:"native_name";s:5:"Frysk";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/6.2.6/fy.zip";s:3:"iso";a:2:{i:1;s:2:"fy";i:2;s:3:"fry";}s:7:"strings";a:1:{s:8:"continue";s:9:"Trochgean";}}s:2:"gd";a:8:{s:8:"language";s:2:"gd";s:7:"version";s:5:"4.7.2";s:7:"updated";s:19:"2016-08-23 17:41:37";s:12:"english_name";s:15:"Scottish Gaelic";s:11:"native_name";s:9:"Gàidhlig";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/4.7.2/gd.zip";s:3:"iso";a:3:{i:1;s:2:"gd";i:2;s:3:"gla";i:3;s:3:"gla";}s:7:"strings";a:1:{s:8:"continue";s:15:"Lean air adhart";}}s:5:"gl_ES";a:8:{s:8:"language";s:5:"gl_ES";s:7:"version";s:5:"6.6.1";s:7:"updated";s:19:"2024-07-14 22:55:59";s:12:"english_name";s:8:"Galician";s:11:"native_name";s:6:"Galego";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.6.1/gl_ES.zip";s:3:"iso";a:2:{i:1;s:2:"gl";i:2;s:3:"glg";}s:7:"strings";a:1:{s:8:"continue";s:9:"Continuar";}}s:2:"gu";a:8:{s:8:"language";s:2:"gu";s:7:"version";s:5:"6.4.5";s:7:"updated";s:19:"2024-03-01 06:52:39";s:12:"english_name";s:8:"Gujarati";s:11:"native_name";s:21:"ગુજરાતી";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/6.4.5/gu.zip";s:3:"iso";a:2:{i:1;s:2:"gu";i:2;s:3:"guj";}s:7:"strings";a:1:{s:8:"continue";s:25:"ચાલુ રાખો";}}s:3:"haz";a:8:{s:8:"language";s:3:"haz";s:7:"version";s:6:"4.4.32";s:7:"updated";s:19:"2015-12-05 00:59:09";s:12:"english_name";s:8:"Hazaragi";s:11:"native_name";s:15:"هزاره گی";s:7:"package";s:63:"https://downloads.wordpress.org/translation/core/4.4.32/haz.zip";s:3:"iso";a:1:{i:3;s:3:"haz";}s:7:"strings";a:1:{s:8:"continue";s:10:"ادامه";}}s:5:"he_IL";a:8:{s:8:"language";s:5:"he_IL";s:7:"version";s:5:"6.2.6";s:7:"updated";s:19:"2024-05-04 18:39:24";s:12:"english_name";s:6:"Hebrew";s:11:"native_name";s:16:"עִבְרִית";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.2.6/he_IL.zip";s:3:"iso";a:1:{i:1;s:2:"he";}s:7:"strings";a:1:{s:8:"continue";s:8:"המשך";}}s:5:"hi_IN";a:8:{s:8:"language";s:5:"hi_IN";s:7:"version";s:5:"6.4.5";s:7:"updated";s:19:"2024-02-25 08:05:38";s:12:"english_name";s:5:"Hindi";s:11:"native_name";s:18:"हिन्दी";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.4.5/hi_IN.zip";s:3:"iso";a:2:{i:1;s:2:"hi";i:2;s:3:"hin";}s:7:"strings";a:1:{s:8:"continue";s:25:"जारी रखें";}}s:2:"hr";a:8:{s:8:"language";s:2:"hr";s:7:"version";s:5:"6.6.1";s:7:"updated";s:19:"2024-07-31 12:47:29";s:12:"english_name";s:8:"Croatian";s:11:"native_name";s:8:"Hrvatski";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/6.6.1/hr.zip";s:3:"iso";a:2:{i:1;s:2:"hr";i:2;s:3:"hrv";}s:7:"strings";a:1:{s:8:"continue";s:7:"Nastavi";}}s:3:"hsb";a:8:{s:8:"language";s:3:"hsb";s:7:"version";s:5:"6.2.6";s:7:"updated";s:19:"2023-02-22 17:37:32";s:12:"english_name";s:13:"Upper Sorbian";s:11:"native_name";s:17:"Hornjoserbšćina";s:7:"package";s:62:"https://downloads.wordpress.org/translation/core/6.2.6/hsb.zip";s:3:"iso";a:2:{i:2;s:3:"hsb";i:3;s:3:"hsb";}s:7:"strings";a:1:{s:8:"continue";s:4:"Dale";}}s:5:"hu_HU";a:8:{s:8:"language";s:5:"hu_HU";s:7:"version";s:5:"6.6.1";s:7:"updated";s:19:"2024-07-18 16:12:48";s:12:"english_name";s:9:"Hungarian";s:11:"native_name";s:6:"Magyar";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.6.1/hu_HU.zip";s:3:"iso";a:2:{i:1;s:2:"hu";i:2;s:3:"hun";}s:7:"strings";a:1:{s:8:"continue";s:10:"Folytatás";}}s:2:"hy";a:8:{s:8:"language";s:2:"hy";s:7:"version";s:5:"4.7.2";s:7:"updated";s:19:"2016-12-03 16:21:10";s:12:"english_name";s:8:"Armenian";s:11:"native_name";s:14:"Հայերեն";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/4.7.2/hy.zip";s:3:"iso";a:2:{i:1;s:2:"hy";i:2;s:3:"hye";}s:7:"strings";a:1:{s:8:"continue";s:20:"Շարունակել";}}s:5:"id_ID";a:8:{s:8:"language";s:5:"id_ID";s:7:"version";s:5:"6.6.1";s:7:"updated";s:19:"2024-07-20 02:17:38";s:12:"english_name";s:10:"Indonesian";s:11:"native_name";s:16:"Bahasa Indonesia";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.6.1/id_ID.zip";s:3:"iso";a:2:{i:1;s:2:"id";i:2;s:3:"ind";}s:7:"strings";a:1:{s:8:"continue";s:9:"Lanjutkan";}}s:5:"is_IS";a:8:{s:8:"language";s:5:"is_IS";s:7:"version";s:6:"4.9.25";s:7:"updated";s:19:"2018-12-11 10:40:02";s:12:"english_name";s:9:"Icelandic";s:11:"native_name";s:9:"Íslenska";s:7:"package";s:65:"https://downloads.wordpress.org/translation/core/4.9.25/is_IS.zip";s:3:"iso";a:2:{i:1;s:2:"is";i:2;s:3:"isl";}s:7:"strings";a:1:{s:8:"continue";s:6:"Áfram";}}s:5:"it_IT";a:8:{s:8:"language";s:5:"it_IT";s:7:"version";s:5:"6.6.1";s:7:"updated";s:19:"2024-07-31 21:40:43";s:12:"english_name";s:7:"Italian";s:11:"native_name";s:8:"Italiano";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.6.1/it_IT.zip";s:3:"iso";a:2:{i:1;s:2:"it";i:2;s:3:"ita";}s:7:"strings";a:1:{s:8:"continue";s:8:"Continua";}}s:2:"ja";a:8:{s:8:"language";s:2:"ja";s:7:"version";s:5:"6.6.1";s:7:"updated";s:19:"2024-07-12 15:44:10";s:12:"english_name";s:8:"Japanese";s:11:"native_name";s:9:"日本語";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/6.6.1/ja.zip";s:3:"iso";a:1:{i:1;s:2:"ja";}s:7:"strings";a:1:{s:8:"continue";s:6:"次へ";}}s:5:"jv_ID";a:8:{s:8:"language";s:5:"jv_ID";s:7:"version";s:6:"4.9.25";s:7:"updated";s:19:"2019-02-16 23:58:56";s:12:"english_name";s:8:"Javanese";s:11:"native_name";s:9:"Basa Jawa";s:7:"package";s:65:"https://downloads.wordpress.org/translation/core/4.9.25/jv_ID.zip";s:3:"iso";a:2:{i:1;s:2:"jv";i:2;s:3:"jav";}s:7:"strings";a:1:{s:8:"continue";s:9:"Nerusaké";}}s:5:"ka_GE";a:8:{s:8:"language";s:5:"ka_GE";s:7:"version";s:5:"6.6.1";s:7:"updated";s:19:"2024-07-12 07:15:01";s:12:"english_name";s:8:"Georgian";s:11:"native_name";s:21:"ქართული";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.6.1/ka_GE.zip";s:3:"iso";a:2:{i:1;s:2:"ka";i:2;s:3:"kat";}s:7:"strings";a:1:{s:8:"continue";s:30:"გაგრძელება";}}s:3:"kab";a:8:{s:8:"language";s:3:"kab";s:7:"version";s:5:"6.2.6";s:7:"updated";s:19:"2023-07-05 11:40:39";s:12:"english_name";s:6:"Kabyle";s:11:"native_name";s:9:"Taqbaylit";s:7:"package";s:62:"https://downloads.wordpress.org/translation/core/6.2.6/kab.zip";s:3:"iso";a:2:{i:2;s:3:"kab";i:3;s:3:"kab";}s:7:"strings";a:1:{s:8:"continue";s:6:"Kemmel";}}s:2:"kk";a:8:{s:8:"language";s:2:"kk";s:7:"version";s:5:"6.6.1";s:7:"updated";s:19:"2024-07-18 02:49:24";s:12:"english_name";s:6:"Kazakh";s:11:"native_name";s:19:"Қазақ тілі";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/6.6.1/kk.zip";s:3:"iso";a:2:{i:1;s:2:"kk";i:2;s:3:"kaz";}s:7:"strings";a:1:{s:8:"continue";s:20:"Жалғастыру";}}s:2:"km";a:8:{s:8:"language";s:2:"km";s:7:"version";s:6:"5.2.20";s:7:"updated";s:19:"2019-06-10 16:18:28";s:12:"english_name";s:5:"Khmer";s:11:"native_name";s:27:"ភាសាខ្មែរ";s:7:"package";s:62:"https://downloads.wordpress.org/translation/core/5.2.20/km.zip";s:3:"iso";a:2:{i:1;s:2:"km";i:2;s:3:"khm";}s:7:"strings";a:1:{s:8:"continue";s:12:"បន្ត";}}s:2:"kn";a:8:{s:8:"language";s:2:"kn";s:7:"version";s:5:"6.6.1";s:7:"updated";s:19:"2024-08-01 17:47:37";s:12:"english_name";s:7:"Kannada";s:11:"native_name";s:15:"ಕನ್ನಡ";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/6.6.1/kn.zip";s:3:"iso";a:2:{i:1;s:2:"kn";i:2;s:3:"kan";}s:7:"strings";a:1:{s:8:"continue";s:30:"ಮುಂದುವರಿಸು";}}s:5:"ko_KR";a:8:{s:8:"language";s:5:"ko_KR";s:7:"version";s:5:"6.6.1";s:7:"updated";s:19:"2024-07-31 02:42:26";s:12:"english_name";s:6:"Korean";s:11:"native_name";s:9:"한국어";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.6.1/ko_KR.zip";s:3:"iso";a:2:{i:1;s:2:"ko";i:2;s:3:"kor";}s:7:"strings";a:1:{s:8:"continue";s:6:"계속";}}s:3:"ckb";a:8:{s:8:"language";s:3:"ckb";s:7:"version";s:5:"6.6.1";s:7:"updated";s:19:"2024-07-30 22:44:36";s:12:"english_name";s:16:"Kurdish (Sorani)";s:11:"native_name";s:13:"كوردی‎";s:7:"package";s:62:"https://downloads.wordpress.org/translation/core/6.6.1/ckb.zip";s:3:"iso";a:2:{i:1;s:2:"ku";i:3;s:3:"ckb";}s:7:"strings";a:1:{s:8:"continue";s:30:"به‌رده‌وام به‌";}}s:3:"kir";a:8:{s:8:"language";s:3:"kir";s:7:"version";s:5:"6.6.1";s:7:"updated";s:19:"2024-06-29 07:13:57";s:12:"english_name";s:6:"Kyrgyz";s:11:"native_name";s:16:"Кыргызча";s:7:"package";s:62:"https://downloads.wordpress.org/translation/core/6.6.1/kir.zip";s:3:"iso";a:3:{i:1;s:2:"ky";i:2;s:3:"kir";i:3;s:3:"kir";}s:7:"strings";a:1:{s:8:"continue";s:14:"Улантуу";}}s:2:"lo";a:8:{s:8:"language";s:2:"lo";s:7:"version";s:5:"4.7.2";s:7:"updated";s:19:"2016-11-12 09:59:23";s:12:"english_name";s:3:"Lao";s:11:"native_name";s:21:"ພາສາລາວ";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/4.7.2/lo.zip";s:3:"iso";a:2:{i:1;s:2:"lo";i:2;s:3:"lao";}s:7:"strings";a:1:{s:8:"continue";s:18:"ຕໍ່​ໄປ";}}s:5:"lt_LT";a:8:{s:8:"language";s:5:"lt_LT";s:7:"version";s:5:"6.5.5";s:7:"updated";s:19:"2024-06-13 13:11:03";s:12:"english_name";s:10:"Lithuanian";s:11:"native_name";s:15:"Lietuvių kalba";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.5.5/lt_LT.zip";s:3:"iso";a:2:{i:1;s:2:"lt";i:2;s:3:"lit";}s:7:"strings";a:1:{s:8:"continue";s:6:"Tęsti";}}s:2:"lv";a:8:{s:8:"language";s:2:"lv";s:7:"version";s:5:"6.6.1";s:7:"updated";s:19:"2024-06-20 17:21:01";s:12:"english_name";s:7:"Latvian";s:11:"native_name";s:16:"Latviešu valoda";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/6.6.1/lv.zip";s:3:"iso";a:2:{i:1;s:2:"lv";i:2;s:3:"lav";}s:7:"strings";a:1:{s:8:"continue";s:9:"Turpināt";}}s:5:"mk_MK";a:8:{s:8:"language";s:5:"mk_MK";s:7:"version";s:5:"6.0.8";s:7:"updated";s:19:"2022-10-01 09:23:52";s:12:"english_name";s:10:"Macedonian";s:11:"native_name";s:31:"Македонски јазик";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.0.8/mk_MK.zip";s:3:"iso";a:2:{i:1;s:2:"mk";i:2;s:3:"mkd";}s:7:"strings";a:1:{s:8:"continue";s:16:"Продолжи";}}s:5:"ml_IN";a:8:{s:8:"language";s:5:"ml_IN";s:7:"version";s:5:"6.5.5";s:7:"updated";s:19:"2024-06-13 20:34:23";s:12:"english_name";s:9:"Malayalam";s:11:"native_name";s:18:"മലയാളം";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.5.5/ml_IN.zip";s:3:"iso";a:2:{i:1;s:2:"ml";i:2;s:3:"mal";}s:7:"strings";a:1:{s:8:"continue";s:18:"തുടരുക";}}s:2:"mn";a:8:{s:8:"language";s:2:"mn";s:7:"version";s:5:"6.5.5";s:7:"updated";s:19:"2024-06-20 17:22:06";s:12:"english_name";s:9:"Mongolian";s:11:"native_name";s:12:"Монгол";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/6.5.5/mn.zip";s:3:"iso";a:2:{i:1;s:2:"mn";i:2;s:3:"mon";}s:7:"strings";a:1:{s:8:"continue";s:8:"Continue";}}s:2:"mr";a:8:{s:8:"language";s:2:"mr";s:7:"version";s:5:"6.6.1";s:7:"updated";s:19:"2024-06-20 17:22:32";s:12:"english_name";s:7:"Marathi";s:11:"native_name";s:15:"मराठी";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/6.6.1/mr.zip";s:3:"iso";a:2:{i:1;s:2:"mr";i:2;s:3:"mar";}s:7:"strings";a:1:{s:8:"continue";s:25:"सुरु ठेवा";}}s:5:"ms_MY";a:8:{s:8:"language";s:5:"ms_MY";s:7:"version";s:6:"5.5.14";s:7:"updated";s:19:"2022-03-11 13:52:22";s:12:"english_name";s:5:"Malay";s:11:"native_name";s:13:"Bahasa Melayu";s:7:"package";s:65:"https://downloads.wordpress.org/translation/core/5.5.14/ms_MY.zip";s:3:"iso";a:2:{i:1;s:2:"ms";i:2;s:3:"msa";}s:7:"strings";a:1:{s:8:"continue";s:8:"Teruskan";}}s:5:"my_MM";a:8:{s:8:"language";s:5:"my_MM";s:7:"version";s:6:"4.2.37";s:7:"updated";s:19:"2017-12-26 11:57:10";s:12:"english_name";s:17:"Myanmar (Burmese)";s:11:"native_name";s:15:"ဗမာစာ";s:7:"package";s:65:"https://downloads.wordpress.org/translation/core/4.2.37/my_MM.zip";s:3:"iso";a:2:{i:1;s:2:"my";i:2;s:3:"mya";}s:7:"strings";a:1:{s:8:"continue";s:54:"ဆက်လက်လုပ်ဆောင်ပါ။";}}s:5:"nb_NO";a:8:{s:8:"language";s:5:"nb_NO";s:7:"version";s:5:"6.6.1";s:7:"updated";s:19:"2024-07-21 18:30:52";s:12:"english_name";s:19:"Norwegian (Bokmål)";s:11:"native_name";s:13:"Norsk bokmål";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.6.1/nb_NO.zip";s:3:"iso";a:2:{i:1;s:2:"nb";i:2;s:3:"nob";}s:7:"strings";a:1:{s:8:"continue";s:8:"Fortsett";}}s:5:"ne_NP";a:8:{s:8:"language";s:5:"ne_NP";s:7:"version";s:5:"6.6.1";s:7:"updated";s:19:"2024-07-29 04:49:17";s:12:"english_name";s:6:"Nepali";s:11:"native_name";s:18:"नेपाली";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.6.1/ne_NP.zip";s:3:"iso";a:2:{i:1;s:2:"ne";i:2;s:3:"nep";}s:7:"strings";a:1:{s:8:"continue";s:43:"जारी राख्नुहोस्";}}s:12:"nl_NL_formal";a:8:{s:8:"language";s:12:"nl_NL_formal";s:7:"version";s:5:"6.6.1";s:7:"updated";s:19:"2024-07-30 14:01:20";s:12:"english_name";s:14:"Dutch (Formal)";s:11:"native_name";s:20:"Nederlands (Formeel)";s:7:"package";s:71:"https://downloads.wordpress.org/translation/core/6.6.1/nl_NL_formal.zip";s:3:"iso";a:2:{i:1;s:2:"nl";i:2;s:3:"nld";}s:7:"strings";a:1:{s:8:"continue";s:8:"Doorgaan";}}s:5:"nl_NL";a:8:{s:8:"language";s:5:"nl_NL";s:7:"version";s:5:"6.6.1";s:7:"updated";s:19:"2024-08-02 08:32:25";s:12:"english_name";s:5:"Dutch";s:11:"native_name";s:10:"Nederlands";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.6.1/nl_NL.zip";s:3:"iso";a:2:{i:1;s:2:"nl";i:2;s:3:"nld";}s:7:"strings";a:1:{s:8:"continue";s:8:"Doorgaan";}}s:5:"nl_BE";a:8:{s:8:"language";s:5:"nl_BE";s:7:"version";s:5:"6.6.1";s:7:"updated";s:19:"2024-08-01 01:41:04";s:12:"english_name";s:15:"Dutch (Belgium)";s:11:"native_name";s:20:"Nederlands (België)";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.6.1/nl_BE.zip";s:3:"iso";a:2:{i:1;s:2:"nl";i:2;s:3:"nld";}s:7:"strings";a:1:{s:8:"continue";s:8:"Doorgaan";}}s:5:"nn_NO";a:8:{s:8:"language";s:5:"nn_NO";s:7:"version";s:8:"5.8-beta";s:7:"updated";s:19:"2021-03-18 10:59:16";s:12:"english_name";s:19:"Norwegian (Nynorsk)";s:11:"native_name";s:13:"Norsk nynorsk";s:7:"package";s:67:"https://downloads.wordpress.org/translation/core/5.8-beta/nn_NO.zip";s:3:"iso";a:2:{i:1;s:2:"nn";i:2;s:3:"nno";}s:7:"strings";a:1:{s:8:"continue";s:9:"Hald fram";}}s:3:"oci";a:8:{s:8:"language";s:3:"oci";s:7:"version";s:6:"4.8.24";s:7:"updated";s:19:"2017-08-25 10:03:08";s:12:"english_name";s:7:"Occitan";s:11:"native_name";s:7:"Occitan";s:7:"package";s:63:"https://downloads.wordpress.org/translation/core/4.8.24/oci.zip";s:3:"iso";a:2:{i:1;s:2:"oc";i:2;s:3:"oci";}s:7:"strings";a:1:{s:8:"continue";s:9:"Contunhar";}}s:5:"pa_IN";a:8:{s:8:"language";s:5:"pa_IN";s:7:"version";s:5:"4.7.2";s:7:"updated";s:19:"2017-01-16 05:19:43";s:12:"english_name";s:15:"Panjabi (India)";s:11:"native_name";s:18:"ਪੰਜਾਬੀ";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.7.2/pa_IN.zip";s:3:"iso";a:2:{i:1;s:2:"pa";i:2;s:3:"pan";}s:7:"strings";a:1:{s:8:"continue";s:25:"ਜਾਰੀ ਰੱਖੋ";}}s:5:"pl_PL";a:8:{s:8:"language";s:5:"pl_PL";s:7:"version";s:5:"6.6.1";s:7:"updated";s:19:"2024-08-02 05:33:23";s:12:"english_name";s:6:"Polish";s:11:"native_name";s:6:"Polski";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.6.1/pl_PL.zip";s:3:"iso";a:2:{i:1;s:2:"pl";i:2;s:3:"pol";}s:7:"strings";a:1:{s:8:"continue";s:9:"Kontynuuj";}}s:2:"ps";a:8:{s:8:"language";s:2:"ps";s:7:"version";s:6:"4.3.33";s:7:"updated";s:19:"2015-12-02 21:41:29";s:12:"english_name";s:6:"Pashto";s:11:"native_name";s:8:"پښتو";s:7:"package";s:62:"https://downloads.wordpress.org/translation/core/4.3.33/ps.zip";s:3:"iso";a:2:{i:1;s:2:"ps";i:2;s:3:"pus";}s:7:"strings";a:1:{s:8:"continue";s:19:"دوام ورکړه";}}s:10:"pt_PT_ao90";a:8:{s:8:"language";s:10:"pt_PT_ao90";s:7:"version";s:5:"6.6.1";s:7:"updated";s:19:"2024-07-17 07:49:56";s:12:"english_name";s:27:"Portuguese (Portugal, AO90)";s:11:"native_name";s:17:"Português (AO90)";s:7:"package";s:69:"https://downloads.wordpress.org/translation/core/6.6.1/pt_PT_ao90.zip";s:3:"iso";a:1:{i:1;s:2:"pt";}s:7:"strings";a:1:{s:8:"continue";s:9:"Continuar";}}s:5:"pt_PT";a:8:{s:8:"language";s:5:"pt_PT";s:7:"version";s:5:"6.6.1";s:7:"updated";s:19:"2024-07-31 11:37:44";s:12:"english_name";s:21:"Portuguese (Portugal)";s:11:"native_name";s:10:"Português";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.6.1/pt_PT.zip";s:3:"iso";a:1:{i:1;s:2:"pt";}s:7:"strings";a:1:{s:8:"continue";s:9:"Continuar";}}s:5:"pt_AO";a:8:{s:8:"language";s:5:"pt_AO";s:7:"version";s:5:"6.4.5";s:7:"updated";s:19:"2023-08-21 12:15:00";s:12:"english_name";s:19:"Portuguese (Angola)";s:11:"native_name";s:20:"Português de Angola";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.4.5/pt_AO.zip";s:3:"iso";a:1:{i:1;s:2:"pt";}s:7:"strings";a:1:{s:8:"continue";s:9:"Continuar";}}s:5:"pt_BR";a:8:{s:8:"language";s:5:"pt_BR";s:7:"version";s:5:"6.6.1";s:7:"updated";s:19:"2024-07-22 12:21:09";s:12:"english_name";s:19:"Portuguese (Brazil)";s:11:"native_name";s:20:"Português do Brasil";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.6.1/pt_BR.zip";s:3:"iso";a:2:{i:1;s:2:"pt";i:2;s:3:"por";}s:7:"strings";a:1:{s:8:"continue";s:9:"Continuar";}}s:3:"rhg";a:8:{s:8:"language";s:3:"rhg";s:7:"version";s:5:"4.7.2";s:7:"updated";s:19:"2016-03-16 13:03:18";s:12:"english_name";s:8:"Rohingya";s:11:"native_name";s:8:"Ruáinga";s:7:"package";s:62:"https://downloads.wordpress.org/translation/core/4.7.2/rhg.zip";s:3:"iso";a:1:{i:3;s:3:"rhg";}s:7:"strings";a:1:{s:8:"continue";s:8:"Continue";}}s:5:"ro_RO";a:8:{s:8:"language";s:5:"ro_RO";s:7:"version";s:5:"6.6.1";s:7:"updated";s:19:"2024-08-03 07:44:15";s:12:"english_name";s:8:"Romanian";s:11:"native_name";s:8:"Română";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.6.1/ro_RO.zip";s:3:"iso";a:2:{i:1;s:2:"ro";i:2;s:3:"ron";}s:7:"strings";a:1:{s:8:"continue";s:9:"Continuă";}}s:5:"ru_RU";a:8:{s:8:"language";s:5:"ru_RU";s:7:"version";s:5:"6.6.1";s:7:"updated";s:19:"2024-07-22 07:43:03";s:12:"english_name";s:7:"Russian";s:11:"native_name";s:14:"Русский";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.6.1/ru_RU.zip";s:3:"iso";a:2:{i:1;s:2:"ru";i:2;s:3:"rus";}s:7:"strings";a:1:{s:8:"continue";s:20:"Продолжить";}}s:3:"sah";a:8:{s:8:"language";s:3:"sah";s:7:"version";s:5:"4.7.2";s:7:"updated";s:19:"2017-01-21 02:06:41";s:12:"english_name";s:5:"Sakha";s:11:"native_name";s:14:"Сахалыы";s:7:"package";s:62:"https://downloads.wordpress.org/translation/core/4.7.2/sah.zip";s:3:"iso";a:2:{i:2;s:3:"sah";i:3;s:3:"sah";}s:7:"strings";a:1:{s:8:"continue";s:12:"Салҕаа";}}s:3:"snd";a:8:{s:8:"language";s:3:"snd";s:7:"version";s:6:"5.4.15";s:7:"updated";s:19:"2020-07-07 01:53:37";s:12:"english_name";s:6:"Sindhi";s:11:"native_name";s:8:"سنڌي";s:7:"package";s:63:"https://downloads.wordpress.org/translation/core/5.4.15/snd.zip";s:3:"iso";a:3:{i:1;s:2:"sd";i:2;s:3:"snd";i:3;s:3:"snd";}s:7:"strings";a:1:{s:8:"continue";s:15:"اڳتي هلو";}}s:5:"si_LK";a:8:{s:8:"language";s:5:"si_LK";s:7:"version";s:5:"4.7.2";s:7:"updated";s:19:"2016-11-12 06:00:52";s:12:"english_name";s:7:"Sinhala";s:11:"native_name";s:15:"සිංහල";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.7.2/si_LK.zip";s:3:"iso";a:2:{i:1;s:2:"si";i:2;s:3:"sin";}s:7:"strings";a:1:{s:8:"continue";s:44:"දිගටම කරගෙන යන්න";}}s:5:"sk_SK";a:8:{s:8:"language";s:5:"sk_SK";s:7:"version";s:5:"6.6.1";s:7:"updated";s:19:"2024-07-19 11:59:21";s:12:"english_name";s:6:"Slovak";s:11:"native_name";s:11:"Slovenčina";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.6.1/sk_SK.zip";s:3:"iso";a:2:{i:1;s:2:"sk";i:2;s:3:"slk";}s:7:"strings";a:1:{s:8:"continue";s:12:"Pokračovať";}}s:3:"skr";a:8:{s:8:"language";s:3:"skr";s:7:"version";s:5:"6.4.2";s:7:"updated";s:19:"2023-11-12 10:29:16";s:12:"english_name";s:7:"Saraiki";s:11:"native_name";s:14:"سرائیکی";s:7:"package";s:62:"https://downloads.wordpress.org/translation/core/6.4.2/skr.zip";s:3:"iso";a:1:{i:3;s:3:"skr";}s:7:"strings";a:1:{s:8:"continue";s:17:"جاری رکھو";}}s:5:"sl_SI";a:8:{s:8:"language";s:5:"sl_SI";s:7:"version";s:5:"6.6.1";s:7:"updated";s:19:"2024-08-02 12:40:36";s:12:"english_name";s:9:"Slovenian";s:11:"native_name";s:13:"Slovenščina";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.6.1/sl_SI.zip";s:3:"iso";a:2:{i:1;s:2:"sl";i:2;s:3:"slv";}s:7:"strings";a:1:{s:8:"continue";s:8:"Nadaljuj";}}s:2:"sq";a:8:{s:8:"language";s:2:"sq";s:7:"version";s:5:"6.6.1";s:7:"updated";s:19:"2024-07-08 11:06:53";s:12:"english_name";s:8:"Albanian";s:11:"native_name";s:5:"Shqip";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/6.6.1/sq.zip";s:3:"iso";a:2:{i:1;s:2:"sq";i:2;s:3:"sqi";}s:7:"strings";a:1:{s:8:"continue";s:6:"Vazhdo";}}s:5:"sr_RS";a:8:{s:8:"language";s:5:"sr_RS";s:7:"version";s:5:"6.5.5";s:7:"updated";s:19:"2024-06-20 17:29:20";s:12:"english_name";s:7:"Serbian";s:11:"native_name";s:23:"Српски језик";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.5.5/sr_RS.zip";s:3:"iso";a:2:{i:1;s:2:"sr";i:2;s:3:"srp";}s:7:"strings";a:1:{s:8:"continue";s:14:"Настави";}}s:5:"sv_SE";a:8:{s:8:"language";s:5:"sv_SE";s:7:"version";s:5:"6.6.1";s:7:"updated";s:19:"2024-07-21 23:14:01";s:12:"english_name";s:7:"Swedish";s:11:"native_name";s:7:"Svenska";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.6.1/sv_SE.zip";s:3:"iso";a:2:{i:1;s:2:"sv";i:2;s:3:"swe";}s:7:"strings";a:1:{s:8:"continue";s:9:"Fortsätt";}}s:2:"sw";a:8:{s:8:"language";s:2:"sw";s:7:"version";s:5:"6.6.1";s:7:"updated";s:19:"2024-06-20 17:29:45";s:12:"english_name";s:7:"Swahili";s:11:"native_name";s:9:"Kiswahili";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/6.6.1/sw.zip";s:3:"iso";a:2:{i:1;s:2:"sw";i:2;s:3:"swa";}s:7:"strings";a:1:{s:8:"continue";s:7:"Endelea";}}s:3:"szl";a:8:{s:8:"language";s:3:"szl";s:7:"version";s:5:"4.7.2";s:7:"updated";s:19:"2016-09-24 19:58:14";s:12:"english_name";s:8:"Silesian";s:11:"native_name";s:17:"Ślōnskŏ gŏdka";s:7:"package";s:62:"https://downloads.wordpress.org/translation/core/4.7.2/szl.zip";s:3:"iso";a:1:{i:3;s:3:"szl";}s:7:"strings";a:1:{s:8:"continue";s:13:"Kōntynuować";}}s:5:"ta_IN";a:8:{s:8:"language";s:5:"ta_IN";s:7:"version";s:5:"4.7.2";s:7:"updated";s:19:"2017-01-27 03:22:47";s:12:"english_name";s:5:"Tamil";s:11:"native_name";s:15:"தமிழ்";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.7.2/ta_IN.zip";s:3:"iso";a:2:{i:1;s:2:"ta";i:2;s:3:"tam";}s:7:"strings";a:1:{s:8:"continue";s:24:"தொடரவும்";}}s:5:"ta_LK";a:8:{s:8:"language";s:5:"ta_LK";s:7:"version";s:6:"4.2.37";s:7:"updated";s:19:"2015-12-03 01:07:44";s:12:"english_name";s:17:"Tamil (Sri Lanka)";s:11:"native_name";s:15:"தமிழ்";s:7:"package";s:65:"https://downloads.wordpress.org/translation/core/4.2.37/ta_LK.zip";s:3:"iso";a:2:{i:1;s:2:"ta";i:2;s:3:"tam";}s:7:"strings";a:1:{s:8:"continue";s:18:"தொடர்க";}}s:2:"te";a:8:{s:8:"language";s:2:"te";s:7:"version";s:5:"4.7.2";s:7:"updated";s:19:"2017-01-26 15:47:39";s:12:"english_name";s:6:"Telugu";s:11:"native_name";s:18:"తెలుగు";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/4.7.2/te.zip";s:3:"iso";a:2:{i:1;s:2:"te";i:2;s:3:"tel";}s:7:"strings";a:1:{s:8:"continue";s:30:"కొనసాగించు";}}s:2:"th";a:8:{s:8:"language";s:2:"th";s:7:"version";s:5:"5.8.9";s:7:"updated";s:19:"2022-06-08 04:30:30";s:12:"english_name";s:4:"Thai";s:11:"native_name";s:9:"ไทย";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/5.8.9/th.zip";s:3:"iso";a:2:{i:1;s:2:"th";i:2;s:3:"tha";}s:7:"strings";a:1:{s:8:"continue";s:15:"ต่อไป";}}s:2:"tl";a:8:{s:8:"language";s:2:"tl";s:7:"version";s:6:"4.8.24";s:7:"updated";s:19:"2017-09-30 09:04:29";s:12:"english_name";s:7:"Tagalog";s:11:"native_name";s:7:"Tagalog";s:7:"package";s:62:"https://downloads.wordpress.org/translation/core/4.8.24/tl.zip";s:3:"iso";a:2:{i:1;s:2:"tl";i:2;s:3:"tgl";}s:7:"strings";a:1:{s:8:"continue";s:10:"Magpatuloy";}}s:5:"tr_TR";a:8:{s:8:"language";s:5:"tr_TR";s:7:"version";s:5:"6.6.1";s:7:"updated";s:19:"2024-07-18 06:08:32";s:12:"english_name";s:7:"Turkish";s:11:"native_name";s:8:"Türkçe";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.6.1/tr_TR.zip";s:3:"iso";a:2:{i:1;s:2:"tr";i:2;s:3:"tur";}s:7:"strings";a:1:{s:8:"continue";s:5:"Devam";}}s:5:"tt_RU";a:8:{s:8:"language";s:5:"tt_RU";s:7:"version";s:5:"4.7.2";s:7:"updated";s:19:"2016-11-20 20:20:50";s:12:"english_name";s:5:"Tatar";s:11:"native_name";s:19:"Татар теле";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.7.2/tt_RU.zip";s:3:"iso";a:2:{i:1;s:2:"tt";i:2;s:3:"tat";}s:7:"strings";a:1:{s:8:"continue";s:17:"дәвам итү";}}s:3:"tah";a:8:{s:8:"language";s:3:"tah";s:7:"version";s:5:"4.7.2";s:7:"updated";s:19:"2016-03-06 18:39:39";s:12:"english_name";s:8:"Tahitian";s:11:"native_name";s:10:"Reo Tahiti";s:7:"package";s:62:"https://downloads.wordpress.org/translation/core/4.7.2/tah.zip";s:3:"iso";a:3:{i:1;s:2:"ty";i:2;s:3:"tah";i:3;s:3:"tah";}s:7:"strings";a:1:{s:8:"continue";s:8:"Continue";}}s:5:"ug_CN";a:8:{s:8:"language";s:5:"ug_CN";s:7:"version";s:5:"6.6.1";s:7:"updated";s:19:"2024-07-10 01:07:15";s:12:"english_name";s:6:"Uighur";s:11:"native_name";s:16:"ئۇيغۇرچە";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.6.1/ug_CN.zip";s:3:"iso";a:2:{i:1;s:2:"ug";i:2;s:3:"uig";}s:7:"strings";a:1:{s:8:"continue";s:26:"داۋاملاشتۇرۇش";}}s:2:"uk";a:8:{s:8:"language";s:2:"uk";s:7:"version";s:5:"6.4.5";s:7:"updated";s:19:"2024-03-06 18:52:07";s:12:"english_name";s:9:"Ukrainian";s:11:"native_name";s:20:"Українська";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/6.4.5/uk.zip";s:3:"iso";a:2:{i:1;s:2:"uk";i:2;s:3:"ukr";}s:7:"strings";a:1:{s:8:"continue";s:20:"Продовжити";}}s:2:"ur";a:8:{s:8:"language";s:2:"ur";s:7:"version";s:6:"5.4.15";s:7:"updated";s:19:"2020-04-09 11:17:33";s:12:"english_name";s:4:"Urdu";s:11:"native_name";s:8:"اردو";s:7:"package";s:62:"https://downloads.wordpress.org/translation/core/5.4.15/ur.zip";s:3:"iso";a:2:{i:1;s:2:"ur";i:2;s:3:"urd";}s:7:"strings";a:1:{s:8:"continue";s:19:"جاری رکھیں";}}s:5:"uz_UZ";a:8:{s:8:"language";s:5:"uz_UZ";s:7:"version";s:8:"5.8-beta";s:7:"updated";s:19:"2021-02-28 12:02:22";s:12:"english_name";s:5:"Uzbek";s:11:"native_name";s:11:"O‘zbekcha";s:7:"package";s:67:"https://downloads.wordpress.org/translation/core/5.8-beta/uz_UZ.zip";s:3:"iso";a:2:{i:1;s:2:"uz";i:2;s:3:"uzb";}s:7:"strings";a:1:{s:8:"continue";s:11:"Davom etish";}}s:2:"vi";a:8:{s:8:"language";s:2:"vi";s:7:"version";s:5:"6.6.1";s:7:"updated";s:19:"2024-08-01 23:21:21";s:12:"english_name";s:10:"Vietnamese";s:11:"native_name";s:14:"Tiếng Việt";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/6.6.1/vi.zip";s:3:"iso";a:2:{i:1;s:2:"vi";i:2;s:3:"vie";}s:7:"strings";a:1:{s:8:"continue";s:12:"Tiếp tục";}}s:5:"zh_CN";a:8:{s:8:"language";s:5:"zh_CN";s:7:"version";s:5:"6.6.1";s:7:"updated";s:19:"2024-07-17 07:38:56";s:12:"english_name";s:15:"Chinese (China)";s:11:"native_name";s:12:"简体中文";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.6.1/zh_CN.zip";s:3:"iso";a:2:{i:1;s:2:"zh";i:2;s:3:"zho";}s:7:"strings";a:1:{s:8:"continue";s:6:"继续";}}s:5:"zh_TW";a:8:{s:8:"language";s:5:"zh_TW";s:7:"version";s:5:"6.6.1";s:7:"updated";s:19:"2024-08-02 11:13:39";s:12:"english_name";s:16:"Chinese (Taiwan)";s:11:"native_name";s:12:"繁體中文";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.6.1/zh_TW.zip";s:3:"iso";a:2:{i:1;s:2:"zh";i:2;s:3:"zho";}s:7:"strings";a:1:{s:8:"continue";s:6:"繼續";}}s:5:"zh_HK";a:8:{s:8:"language";s:5:"zh_HK";s:7:"version";s:5:"6.2.6";s:7:"updated";s:19:"2022-07-15 15:25:03";s:12:"english_name";s:19:"Chinese (Hong Kong)";s:11:"native_name";s:12:"香港中文";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.2.6/zh_HK.zip";s:3:"iso";a:2:{i:1;s:2:"zh";i:2;s:3:"zho";}s:7:"strings";a:1:{s:8:"continue";s:6:"繼續";}}}','off');
INSERT INTO `miam_options` VALUES (10271,'_transient_doing_cron','1722733137.5097389221191406250000','on');
INSERT INTO `miam_options` VALUES (10273,'_site_transient_timeout_theme_roots','1722734940','off');
INSERT INTO `miam_options` VALUES (10274,'_site_transient_theme_roots','a:5:{s:11:"bakers-lite";s:7:"/themes";s:14:"blossom-recipe";s:7:"/themes";s:12:"cookery-lite";s:7:"/themes";s:16:"twentytwentyfour";s:7:"/themes";s:9:"vw-bakery";s:7:"/themes";}','off');
INSERT INTO `miam_options` VALUES (10275,'_site_transient_update_themes','O:8:"stdClass":5:{s:12:"last_checked";i:1722733140;s:7:"checked";a:5:{s:11:"bakers-lite";s:3:"1.7";s:14:"blossom-recipe";s:5:"1.3.0";s:12:"cookery-lite";s:5:"1.1.4";s:16:"twentytwentyfour";s:3:"1.0";s:9:"vw-bakery";s:5:"1.6.9";}s:8:"response";a:1:{s:16:"twentytwentyfour";a:6:{s:5:"theme";s:16:"twentytwentyfour";s:11:"new_version";s:3:"1.2";s:3:"url";s:46:"https://wordpress.org/themes/twentytwentyfour/";s:7:"package";s:62:"https://downloads.wordpress.org/theme/twentytwentyfour.1.2.zip";s:8:"requires";s:3:"6.4";s:12:"requires_php";s:3:"7.0";}}s:9:"no_update";a:4:{s:11:"bakers-lite";a:6:{s:5:"theme";s:11:"bakers-lite";s:11:"new_version";s:3:"1.7";s:3:"url";s:41:"https://wordpress.org/themes/bakers-lite/";s:7:"package";s:57:"https://downloads.wordpress.org/theme/bakers-lite.1.7.zip";s:8:"requires";b:0;s:12:"requires_php";s:3:"5.6";}s:14:"blossom-recipe";a:6:{s:5:"theme";s:14:"blossom-recipe";s:11:"new_version";s:5:"1.3.0";s:3:"url";s:44:"https://wordpress.org/themes/blossom-recipe/";s:7:"package";s:62:"https://downloads.wordpress.org/theme/blossom-recipe.1.3.0.zip";s:8:"requires";b:0;s:12:"requires_php";s:3:"5.6";}s:12:"cookery-lite";a:6:{s:5:"theme";s:12:"cookery-lite";s:11:"new_version";s:5:"1.1.4";s:3:"url";s:42:"https://wordpress.org/themes/cookery-lite/";s:7:"package";s:60:"https://downloads.wordpress.org/theme/cookery-lite.1.1.4.zip";s:8:"requires";b:0;s:12:"requires_php";s:3:"5.6";}s:9:"vw-bakery";a:6:{s:5:"theme";s:9:"vw-bakery";s:11:"new_version";s:5:"1.6.9";s:3:"url";s:39:"https://wordpress.org/themes/vw-bakery/";s:7:"package";s:57:"https://downloads.wordpress.org/theme/vw-bakery.1.6.9.zip";s:8:"requires";s:3:"5.0";s:12:"requires_php";s:3:"7.2";}}s:12:"translations";a:0:{}}','off');
/*!40000 ALTER TABLE `miam_options` ENABLE KEYS */;
UNLOCK TABLES;

