<?php
/**
 * VW Bakery: Block Patterns
 *
 * @package VW Bakery
 * @since   1.0.0
 */

/**
 * Register Block Pattern Category.
 */
if ( function_exists( 'register_block_pattern_category' ) ) {

	register_block_pattern_category(
		'vw-bakery',
		array( 'label' => __( 'VW Bakery', 'vw-bakery' ) )
	);
}

/**
 * Register Block Patterns.
 */
if ( function_exists( 'register_block_pattern' ) ) {
	register_block_pattern(
		'vw-bakery/banner-section',
		array(
			'title'      => __( 'Banner Section', 'vw-bakery' ),
			'categories' => array( 'vw-bakery' ),
			'content'    => "<!-- wp:cover {\"url\":\"" . esc_url(get_template_directory_uri()) . "/inc/block-patterns/images/banner.png\",\"id\":7265,\"dimRatio\":0,\"align\":\"full\",\"className\":\"main-banner\"} -->\n<div class=\"wp-block-cover alignfull main-banner\" style=\"background-image:url(" . esc_url(get_template_directory_uri()) . "/inc/block-patterns/images/banner.png)\"><div class=\"wp-block-cover__inner-container\"><!-- wp:columns {\"align\":\"wide\"} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column {\"width\":\"25%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:25%\"></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"50%\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"flex-basis:50%\"><!-- wp:group {\"className\":\"middle-banner-content\"} -->\n<div class=\"wp-block-group middle-banner-content\"><div class=\"wp-block-group__inner-container\"><!-- wp:heading {\"textAlign\":\"center\",\"level\":1,\"className\":\"mt-0\",\"style\":{\"color\":{\"text\":\"#4d4749\"},\"typography\":{\"fontSize\":25}}} -->\n<h1 class=\"has-text-align-center mt-0 has-text-color\" style=\"color:#4d4749;font-size:25px\">Welcome To The Bakery</h1>\n<!-- /wp:heading -->\n\n<!-- wp:image {\"align\":\"center\",\"id\":7408,\"width\":389,\"height\":24,\"sizeSlug\":\"large\",\"linkDestination\":\"media\"} -->\n<div class=\"wp-block-image\"><figure class=\"aligncenter size-large is-resized\"><img src=\"" . esc_url(get_template_directory_uri()) . "/inc/block-patterns/images/title-image.png\" alt=\"\" class=\"wp-image-7408\" width=\"389\" height=\"24\"/></figure></div>\n<!-- /wp:image -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"className\":\"text-center mt-0\",\"fontSize\":\"normal\",\"style\":{\"color\":{\"text\":\"#4b4342\"}}} -->\n<p class=\"has-text-align-center text-center mt-0 has-text-color has-normal-font-size\" style=\"color:#4b4342\">Lorem ipsum is simply dummy text of the printing and typesetting industry. Lorem ipsum is simply dummy text</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:group --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"25%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:25%\"></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"align\":\"wide\",\"className\":\"contact-section\"} -->\n<div class=\"wp-block-columns alignwide contact-section\"><!-- wp:column {\"className\":\"contact-timing\"} -->\n<div class=\"wp-block-column contact-timing\"><!-- wp:cover {\"customOverlayColor\":\"#52d1cd\"} -->\n<div class=\"wp-block-cover has-background-dim\" style=\"background-color:#52d1cd\"><div class=\"wp-block-cover__inner-container\"><!-- wp:paragraph {\"className\":\"m-0\"} -->\n<p class=\"m-0\">Opening Times:-Monday - Friday: 8AM - 8PMSaturday: 9AM - 4PMSunday: Closed</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:cover --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"33.33%\",\"className\":\"contact-call ms-0\"} -->\n<div class=\"wp-block-column contact-call ms-0\" style=\"flex-basis:33.33%\"><!-- wp:cover {\"overlayColor\":\"white\"} -->\n<div class=\"wp-block-cover has-white-background-color has-background-dim\"><div class=\"wp-block-cover__inner-container\"><!-- wp:paragraph {\"align\":\"center\",\"className\":\"text-center m-0\",\"style\":{\"color\":{\"text\":\"#5b5b5b\"}}} -->\n<p class=\"has-text-align-center text-center m-0 has-text-color\" style=\"color:#5b5b5b\">Call Us For Knew Todays Menu</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:columns {\"className\":\"mb-0 mt-0\"} -->\n<div class=\"wp-block-columns mb-0 mt-0\"><!-- wp:column {\"width\":\"33.33%\",\"className\":\"con-image\"} -->\n<div class=\"wp-block-column con-image\" style=\"flex-basis:33.33%\"><!-- wp:image {\"align\":\"right\",\"id\":7251,\"width\":100,\"height\":100,\"sizeSlug\":\"large\",\"linkDestination\":\"media\"} -->\n<div class=\"wp-block-image\"><figure class=\"alignright size-large is-resized\"><img src=\"" . esc_url(get_template_directory_uri()) . "/inc/block-patterns/images/contact-call.png\" alt=\"\" class=\"wp-image-7251\" width=\"100\" height=\"100\"/></figure></div>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"66.66%\",\"className\":\"ms-0\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center ms-0\" style=\"flex-basis:66.66%\"><!-- wp:paragraph {\"align\":\"left\",\"className\":\"text-left mb-0 mt-0\",\"style\":{\"color\":{\"text\":\"#ff7c93\"}}} -->\n<p class=\"has-text-align-left text-left mb-0 mt-0 has-text-color\" style=\"color:#ff7c93\">&nbsp;+123 456 7890</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div></div>\n<!-- /wp:cover --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"33.33%\",\"className\":\"contact-email ms-0\"} -->\n<div class=\"wp-block-column contact-email ms-0\" style=\"flex-basis:33.33%\"><!-- wp:cover {\"overlayColor\":\"white\"} -->\n<div class=\"wp-block-cover has-white-background-color has-background-dim\"><div class=\"wp-block-cover__inner-container\"><!-- wp:paragraph {\"align\":\"center\",\"className\":\"text-center m-0\",\"style\":{\"color\":{\"text\":\"#4d4749\"}}} -->\n<p class=\"has-text-align-center text-center m-0 has-text-color\" style=\"color:#4d4749\">Or Chat With Us For Knew Todays Menu</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:columns {\"className\":\"mb-0 mt-0\"} -->\n<div class=\"wp-block-columns mb-0 mt-0\"><!-- wp:column {\"width\":\"33.33%\",\"className\":\"con-email\"} -->\n<div class=\"wp-block-column con-email\" style=\"flex-basis:33.33%\"><!-- wp:image {\"align\":\"right\",\"id\":7252,\"width\":100,\"height\":100,\"sizeSlug\":\"large\",\"linkDestination\":\"media\"} -->\n<div class=\"wp-block-image\"><figure class=\"alignright size-large is-resized\"><img src=\"" . esc_url(get_template_directory_uri()) . "/inc/block-patterns/images/contact-email.png\" alt=\"\" class=\"wp-image-7252\" width=\"100\" height=\"100\"/></figure></div>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"66.66%\",\"className\":\"ms-2\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center ms-2\" style=\"flex-basis:66.66%\"><!-- wp:paragraph {\"align\":\"left\",\"className\":\"text-left mb-0 mt-0\",\"style\":{\"color\":{\"text\":\"#ff7c93\"}}} -->\n<p class=\"has-text-align-left text-left mb-0 mt-0 has-text-color\" style=\"color:#ff7c93\">bakery@gmail.com</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div></div>\n<!-- /wp:cover --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"className\":\"contactus-btn ms-0\"} -->\n<div class=\"wp-block-column contactus-btn ms-0\"><!-- wp:cover {\"overlayColor\":\"white\"} -->\n<div class=\"wp-block-cover has-white-background-color has-background-dim\"><div class=\"wp-block-cover__inner-container\"><!-- wp:buttons {\"align\":\"center\"} -->\n<div class=\"wp-block-buttons aligncenter\"><!-- wp:button {\"borderRadius\":3,\"style\":{\"color\":{\"background\":\"#ff7c93\"}},\"textColor\":\"white\"} -->\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link has-white-color has-text-color has-background\" style=\"border-radius:3px;background-color:#ff7c93\">CONTACT US</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div></div>\n<!-- /wp:cover --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div></div>\n<!-- /wp:cover -->",
		)
	);

	register_block_pattern(
		'vw-bakery/products-section',
		array(
			'title'      => __( 'Product Section', 'vw-bakery' ),
			'categories' => array( 'vw-bakery' ),
			'content'    => "<!-- wp:cover {\"overlayColor\":\"white\",\"align\":\"full\",\"className\":\"products-section\"} -->\n<div class=\"wp-block-cover alignfull has-white-background-color has-background-dim products-section\"><div class=\"wp-block-cover__inner-container\"><!-- wp:heading {\"textAlign\":\"center\",\"style\":{\"color\":{\"text\":\"#4d4749\"}}} -->\n<h2 class=\"has-text-align-center has-text-color\" style=\"color:#4d4749\">Our Popular Bakery Products</h2>\n<!-- /wp:heading -->\n\n<!-- wp:image {\"align\":\"center\",\"id\":7406,\"sizeSlug\":\"large\",\"linkDestination\":\"media\"} -->\n<div class=\"wp-block-image\"><figure class=\"aligncenter size-large\"><img src=\"" . esc_url(get_template_directory_uri()) . "/inc/block-patterns/images/title-image.png\" alt=\"\" class=\"wp-image-7406\"/></figure></div>\n<!-- /wp:image -->\n\n<!-- wp:woocommerce/product-category {\"columns\":4,\"rows\":1,\"categories\":[32],\"contentVisibility\":{\"title\":true,\"price\":true,\"rating\":false,\"button\":true},\"align\":\"wide\",\"className\":\"m-0\"} /-->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:cover -->",
		)
	);
}